# -*- coding: utf-8 -*-
"""
/***************************************************************************
 fooodk
                                 A QGIS plugin
 This plugin pulls data from ODK Central to QGIS/CSV
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by WWF-Tanzania
        email                : lmathew@wwftz.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import *#QIcon, QImage, QPixmap
from qgis.PyQt.QtWidgets import QAction, QComboBox, QFileDialog, QTreeWidget, QTreeWidgetItem,QLabel
from qgis.core import * #QgsVectorLayer,QgsFeature

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .fooodk_dialog import fooodkDialog
from .fooodk_dialogI import fooodkDialogI
from .fooodk_dialogJ import fooodkDialogJ
import os
import os.path

import requests
import json
from urllib.parse import urlparse
#from collections import Mapping
from collections.abc import Mapping
from functools import reduce
from datetime import datetime
import webbrowser
import pandas as pd
import shutil


class fooodk:
    """QGIS Plugin Implementation."""
    
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'fooodk_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FooODK')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('fooodk', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/fooodk/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'FooODK'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&FooODK'),
                action)
            self.iface.removeToolBarIcon(action)
            
    # ====================================================================================================
    # ====================================================================================================
    # Lugha Swahili
    def lugha_SW(self):
        self.dlg.kiingireza.setChecked(False)
        self.dlg.label_msimbo.setText('Msimbo')
        self.dlg.label_jina.setText('Jina')
        self.dlg.label_nywila.setText('Nywila')
        self.dlg.patameza.setText('Unga')
        self.dlg.label_mradi.setText('Mradi')
        self.dlg.label_tarehe.setText('Tarehe')
        self.dlg.label_form.setText('Fomu')
        self.dlg.label_fomundogo.setText('Fomu Ndogo')
        self.dlg.label_takwimu.setText('Takwimu')
        self.dlg.label_aina.setText('Aina')
        self.dlg.ongeza.setText('Pakia')
        self.dlg.Viambatanisho.setText('Viambatanisho')
        self.dlgI.Nakili.setText('Nakili')
        self.dlgI.Ona.setText('Ona')
        self.dlgI.Shusha.setText('Pakua')
        
        
    # --------------------------------------------------------------------------------------------  
    # Lugha English
    def lugha_EN(self):
        self.dlg.swahili.setChecked(False)
        self.dlg.label_msimbo.setText('ODK URL')
        self.dlg.label_jina.setText('Username')
        self.dlg.label_nywila.setText('Password')
        self.dlg.patameza.setText('Connect')
        self.dlg.label_mradi.setText('Projects')
        self.dlg.label_tarehe.setText('Dates')
        self.dlg.label_form.setText('Form')
        self.dlg.label_fomundogo.setText('Sub-Form')
        self.dlg.label_takwimu.setText('Column')
        self.dlg.label_aina.setText('Type')
        self.dlg.ongeza.setText('Load')
        self.dlg.Viambatanisho.setText('Attachments')
        self.dlgI.Nakili.setText('Copy')
        self.dlgI.Ona.setText('View')
        self.dlgI.Shusha.setText('Download')
        
    
    # ====================================================================================================
    # ====================================================================================================    
    # Soma
    def get_logins(self):
        faili = os.path.join(os.path.dirname(__file__), 'faili.txt')
            
        if os.path.isfile(faili):
            f = open(faili, 'r')
            mistari = f.readlines()
            if mistari:
                mstari_wa_kwanza = (mistari[0]).split(";")
                f.close()
            
                msimbo_soma = (mstari_wa_kwanza[0]).split("|")
                if msimbo_soma[0] == 'Msimbo':
                    msimbo_somab = str(msimbo_soma[1])
                    self.dlg.msimbo.setText(msimbo_somab)
                
                jina_soma = (mstari_wa_kwanza[1]).split("|")
                if jina_soma[0] == 'Jina':
                    jina_somab = str(jina_soma[1])
                    self.dlg.jina.setText(jina_somab)
                
                
    # -----------------------------------------------------------------------------------------------
    # Tunza
    def set_logins(self):
        faili = os.path.join(os.path.dirname(__file__), 'faili.txt')
           
        msimbo = self.dlg.msimbo.text()
        jina = self.dlg.jina.text()
        msimbo_jina = "Msimbo|" + str(msimbo) + ";" + "Jina|" + str(jina)
            
        mistari = []
        if os.path.isfile(faili):
            f = open(faili, 'r')
            mistari = f.readlines()
            if mistari:
                mistari[0] = msimbo_jina
            f.close()
            
            f = open(faili, "w")
            if mistari:
                f.writelines(mistari)
            f.close()

        if not os.path.isfile(faili):
            f = open(faili, "w")
            f.writelines(msimbo_jina)
            f.close()
          

    # ====================================================================================================
    session_token = ''
    namba_ya_mradi = 0
    
    # ====================================================================================================
    # ODK Central Session
    def get_session_token(self):
        msimbo = self.dlg.msimbo.text()
        jina = self.dlg.jina.text()
        nywila = self.dlg.nywila.text()
        uMsimbo = (str(msimbo),"/v1/sessions")
        
        email_token_response = requests.post("".join(uMsimbo), data = json.dumps({"email": jina, "password": nywila}), headers = {"Content-Type": "application/json"},)        
        if email_token_response.status_code == 200:
            return email_token_response.json()["token"]
   
    # ====================================================================================================
    #List all Project
    def list_projects(self):
        iMsimbo = self.dlg.msimbo.text()        
        jMsimbo = (str(iMsimbo),"/v1/projects/")
        kMsimbo = "".join(jMsimbo)
        projects_response = requests.get(kMsimbo,headers={"Authorization": "Bearer " + session_token},)
        projects = {}
        
        if projects_response.status_code == 200:
            self.set_logins()
            for project in projects_response.json():
                self.dlg.mradi.addItem(str(project["id"]) + '|' + project["name"])
            
        return None
            
    # ====================================================================================================
    #List all Forms
    def list_forms(self):
        self.dlg.fomu.clear()
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()
        self.dlg.fomu.addItem('---Chagua Fomu---')   
        self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')   
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
                
        msimbo = self.dlg.msimbo.text()  
        global namba_ya_mradi
        namba_ya_mradi = str(self.dlg.mradi.currentText()).split('|')[0]
        
        fMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/")
        form_response = requests.get("".join(fMsimbo), headers = {"Authorization": "Bearer " + session_token},)         
        if form_response.status_code == 200:
            for fomu in form_response.json():
                self.dlg.fomu.addItem(str(fomu["xmlFormId"]))

        return None

    # ====================================================================================================   
    #Find Specific Key value
    def findValue(self,key, d):
        if key in d:
            return d[key]
        for v in d.values():
            if isinstance(v, dict):
                found = self.findValue(key, v)
                if found is not None:
                    return found
    

    # ====================================================================================================
    #List all Sub forms Forms Iterms
    def list_fomundogo(self):
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()
        self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')           
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
        
        # --------------------------------------------------------
        global iFomuU
        #global msimboFoo
        iFomuU = []

        iMsimbo = self.dlg.msimbo.text()        
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iTareheS = self.dlg.tarehemwanzo.date()
        iTareheE = self.dlg.tarehemwisho.date()
        iTakwimu = self.dlg.takwimu.currentText()
        
        #--------------------------------------------------------
        ##########Pata Takwimu za Zilizochaguliwa kwa Tarehe
        sDate = iTareheS.toPyDate()
        eDate = iTareheE.toPyDate()
        jTakwimu = str(iTakwimu)
        
        try:
            if sDate == eDate:
                self.dlg.jumbe.setText('Kuna Kosa : Tarehe (Date are the same)')
            elif  sDate > eDate:
                self.dlg.jumbe.setText('Kuna Kosa: Tarehe (The left date should be earlier)')
            elif sDate < eDate:
                sDatei = "__system/submissionDate gt " + str(sDate)
                eDatei = "__system/submissionDate lt " + str(eDate)
                iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/Submissions?$filter=",sDatei," and ",eDatei)
                jURL = "".join(iURL)
                self.dlg.jumbe.setText(jURL)
                
                #-------------------------------------------------------------------------------------------------
                iMsimbo_Response = requests.get(str(jURL), headers={"Authorization": "Bearer " + session_token},)
                if iMsimbo_Response.status_code == 200:
                    iJson = iMsimbo_Response.json()['value']                    
                    for iData in iJson:
                        iTambulisho = iData['__id']
                        iFomuU.append(str(iTambulisho))
                        
                    self.dlg.jumbe.setText("Idadi ya Takwimu: " + str(len(iJson)))
                    self.dlg.jumbe.setStyleSheet("background: cyan")
                                                        
                #-------------------------------------------------------------------------------------------------
                jMsimbo = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc")
                kMsimbo = "".join(jMsimbo)
                jMsimbo_Response = requests.get(kMsimbo, headers={"Authorization": "Bearer " + session_token},)
                if jMsimbo_Response.status_code == 200:
                    iFomuSub = jMsimbo_Response.json()['value']
                    for j in iFomuSub:
                        if j["url"] == "Submissions":
                            self.dlg.fomundogo.addItem(j["url"] + "(Fomu Kuu)")
                        else:
                            self.dlg.fomundogo.addItem(j["url"])

        except:
            self.dlg.jumbe.setText("Kuna shida (Error)")
            self.dlg.jumbe.setStyleSheet("background: red")
            
        return None
    # ====================================================================================================   
    # Nested keys in a json
    def extract_paths(self,base_path, dd): 
        new_paths = [] 
        for key, value in dd.items(): 
            new_path = base_path + ('|' if base_path else '') + key 
            if isinstance(value, Mapping): 
                new_paths.extend(self.extract_paths(new_path, value)) 
            else: 
                new_paths.append(new_path) 
        return new_paths
        
    # ====================================================================================================
    # Date Detections
    def isDateValid(self,date):
        pattern = "%Y-%m-%d"
        try:
            datetime.strptime(date, pattern)
            return True
        except ValueError:
            return False
            
    # ====================================================================================================
    # Get Values using nested keys
    def deep_get(self,_dict, keys, default=None):
        def _reducer(d, key):
            if isinstance(d, dict):
                return d.get(key, default)
            if isinstance(d, list):
                return d[key] if len(d) > 0 else default
            return default
        return reduce(_reducer, keys, _dict)
           
    # ====================================================================================================
    def flatten(self,d, base=()):
        for k, v in d.items():
            if isinstance(v, dict):
                yield from self.flatten(v, base + (k,))
            else:
                yield base + (k, v)
                
    # ====================================================================================================
    # ====================================================================================================
    #Chora Nukta
    def ChoraNukta_QGIS(self,Nukta):
        iGeoP =  QgsVectorLayer("Point?crs=epsg:4326", "Jira-Nukta" , "memory")
        jGeoP = iGeoP.dataProvider()
        jGeoP.addAttributes([QgsField('__id', QVariant.String)])
        jGeoP.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoP.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Nukta:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                
                jGeoP.addFeatures([iChora])  
                iGeoP.commitChanges()
                iGeoP.updateFields()
                iGeoP.updateExtents()
                
            QgsProject.instance().addMapLayer(iGeoP)        
            #--------------------------------------------------------
            self.dlg.jumbe.setText('Jira-Nukta Imechorwa (Point Layer Added)')
            self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Nukta') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None

    # ====================================================================================================
    #Chora Mstari
    def ChoraMstari_QGIS(self,Mstari):
        iGeoL = QgsVectorLayer("LineString?crs=epsg:4326", "Jira-Mstari", "memory")
        jGeoL = iGeoL.dataProvider()
        jGeoL.addAttributes([QgsField('__id', QVariant.String)])
        jGeoL.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoL.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Mstari:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                        
                jGeoL.addFeature(iChora)
                iGeoL.commitChanges()
                iGeoL.updateFields()
                iGeoL.updateExtents()
                
            QgsProject.instance().addMapLayer(iGeoL)
            #--------------------------------------------------------
            self.dlg.jumbe.setText('Jira-Mstari Imechorwa (Line Layer Added)')
            self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Mstari') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None

    # ====================================================================================================
    #Chora Mzingo
    def ChoraMzingo_QGIS(self,Mzingo):
        iGeoPo = QgsVectorLayer("Polygon?crs=epsg:4326", "Jira-Mzingo", "memory")
        jGeoPo = iGeoPo.dataProvider()   
        jGeoPo.addAttributes([QgsField('__id', QVariant.String)])
        jGeoPo.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoPo.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Mzingo:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                
                jGeoPo.addFeature(iChora)
                iGeoPo.commitChanges()
                iGeoPo.updateFields()
                iGeoPo.updateExtents()
                
                QgsProject.instance().addMapLayer(iGeoPo)
                #--------------------------------------------------------
                self.dlg.jumbe.setText('Jira-Mzingo Imechorwa (Polygon Layer Added)')
                self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Mzingo') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None
                     
                
        
    # ====================================================================================================   
    # ====================================================================================================
    # https://towardsdatascience.com/how-do-i-extract-nested-data-in-python-4e7bed37566a
    #List all Forms Iterms
    def list_iterms(self):
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()     
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   

        #self.dlg.tarehemwanzo('---Chagua Aina ya Tarehe---')
        #self.dlg.tarehemwisho('---Chagua Aina ya Tarehe---')

        msimbo = self.dlg.msimbo.text()  
        namba_ya_mradi = str(self.dlg.mradi.currentText()).split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuNdogo = self.dlg.fomundogo.currentText()
        

        iMsimboFomu = ""            
        if iFomuNdogo == "Submissions(Fomu Kuu)":
            iSub = str(iFomuNdogo).split("(")[0]
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iSub))
            iMsimboFomu = "".join(iMsimbo)
        else:
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iFomuNdogo))
            iMsimboFomu = "".join(iMsimbo)
        
        iResponse = requests.get(str(iMsimboFomu), headers={"Authorization": "Bearer " + session_token},)
        if iResponse.status_code == 200:
            iJson = iResponse.json()['value'][0]            
            #--------------------------------------------------------
            for items in self.flatten(iJson):
                iKeys = '|'.join(map(str, items))
                if "Point" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                elif "LineString" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                elif "Polygon" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                    
            #--------------------------------------------------------
            for jKeys in iJson:
                self.dlg.takwimu.addItem(str(jKeys))                    
    
    # ====================================================================================================   
    # ====================================================================================================
    #Plot Points
    def Chora(self):
        iMsimbo = self.dlg.msimbo.text()  
        global namba_ya_mradi
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuN = self.dlg.fomundogo.currentText()
        iType = self.dlg.aina.currentText()
        iTakwimu = self.dlg.takwimu.currentText()        
        
        zJira = str(str(iType).split("|")[-1:][0])
        jTakwimu = str(iTakwimu)
        #--------------------------------------------------------
        iM = ""
        iN = False        
        xJira = []
        iChuja = ''
        fanksheni = ""
        
        if iFomuN == "Submissions(Fomu Kuu)":
            iSub = str(iFomuN).split("(")[0]
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iSub))
            iM = "".join(iURL)
            iChuja = '__id'
        else:
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iFomuN))
            iM = "".join(iURL)          
            iChuja = '__Submissions-id'
        
        #--------------------------------------------------------
        iMsimbo_Response = requests.get(str(iM), headers={"Authorization": "Bearer " + session_token},)  
        if iMsimbo_Response.status_code == 200:
            iJson = iMsimbo_Response.json()['value']
            xJira = []
            fanksheni = ""
            
            for iData in iJson:
                subID = str(iData[iChuja])
                kTakwimu = str(iData[jTakwimu])
                #--------------------------------------------------------   
                for items in self.flatten(iData):
                    iKeys = '|'.join(map(str, items))                    
                    #--------------------------------------------------------  
                    if iData[iChuja] in iFomuU:
                        if str(iType) == str(iKeys) and str(zJira) == "Point":
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)                            
                            
                            XYZ = " ".join(map(str, iValues))
                            iXYZ = ("POINT (" + XYZ +")")                            
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
                        #--------------------------------------------------------
                        ##########Jira Mstari
                        if str(iType) == str(iKeys)  and str(zJira) == "LineString":                           
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)
                            
                            l = ""
                            for i in iValues:
                                j = ("".join(str(i))[1:][:-1]).replace(",", "")
                                l = l + ", " + j
                                
                            XYZ = l[1:]                                
                            iXYZ = ("LINESTRING (" + XYZ +")")
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
                        #--------------------------------------------------------
                        ##########Jira Mzingo
                        if str(iType) in str(iKeys) and str(zJira)  == "Polygon":
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)
                            
                            l = ""
                            for i in iValues[0]:
                                j = ("".join(str(i))[1:][:-1]).replace(",", "")
                                l = l + ", " + j
                                
                            XYZ = l[1:]
                            iXYZ = ("POLYGON ((" + XYZ + "))")
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
        else:
            self.dlg.jumbe.setText('Hakuna Takwimu, Badilisha Tarehe')
            self.dlg.jumbe.setStyleSheet("background: red")
            
        #--------------------------------------------------------
        if str(zJira) == "Point":
            self.ChoraNukta_QGIS(xJira)
        if str(zJira) == "LineString":
            self.ChoraMstari_QGIS(xJira)
        if str(zJira) == "Polygon":
            self.ChoraMzingo_QGIS(xJira)
            
        return None

    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================   
    # ====================================================================================================
    # Export CSV
    def shusha_csv(self,JinaFaili): 
        iMsimbo = self.dlg.msimbo.text()  
        global namba_ya_mradi
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuN = self.dlg.fomundogo.currentText()
        
        #--------------------------------------------------------
        iM = ""
        iN = False        
        xJira = []
        iChuja = ''
        fanksheni = ""
        JinaFaili_OUT = str(JinaFaili)
        
        if iFomuN == "Submissions(Fomu Kuu)":
            iSub = str(iFomuN).split("(")[0]
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iSub))
            iM = "".join(iURL)
            iChuja = '__id'
        else:
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iFomuN))
            iM = "".join(iURL)          
            iChuja = '__Submissions-id'
        
        #--------------------------------------------------------
        iMsimbo_Response = requests.get(str(iM), headers={"Authorization": "Bearer " + session_token},)  
        if iMsimbo_Response.status_code == 200:
            iJson = iMsimbo_Response.json()['value']
            '''
            jData = []
            i = 0
            for iData in iJson:
                kData = {}
                for iValue in flatten(iData):
                    jValue = iValue[-2]
                    kValue = iValue[-1]
                    lValue = {jValue: kValue}
                    kData[jValue] = kValue #append(lValue)
                jData.append(kData)
                i = i + 1
            df = pd.DataFrame(list(jData))
            '''
            df = pd.json_normalize(iJson)
            df.to_csv(JinaFaili_OUT)  
            
            lFaili = 'file:///{}?delimiter=,'.format(JinaFaili_OUT)
            mFaili = os.path.splitext(os.path.basename(JinaFaili_OUT))[0]
            #nMeza = QgsVectorLayer(inputFile, "table", 'delimitedtext')
            nMeza = QgsVectorLayer(lFaili, mFaili, 'delimitedtext')         
            QgsProject.instance().addMapLayer(nMeza)          
                                        
        else:
            self.dlg.jumbe.setText('Hakuna Takwimu, Badilisha Tarehe')
            self.dlg.jumbe.setStyleSheet("background: red")
            
        #--------------------------------------------------------
        '''
        if str(zJira) == "Point":
            self.ChoraNukta_QGIS(xJira)
        if str(zJira) == "LineString":
            self.ChoraMstari_QGIS(xJira)
        if str(zJira) == "Polygon":
            self.ChoraMzingo_QGIS(xJira) 
        '''
        return None
        
        # ================================================   
        self.dlg.jumbe.setText(JinaFaili)
        self.dlg.jumbe.setStyleSheet("background: blue")
    
    #-----------------------------------------------------------------------------------------------------
    def tunzaCSV(self):
        iFomu = self.dlg.fomu.currentText()
        JinaFaili, AinaFaili = QFileDialog.getSaveFileName(None,'Tuanza Takwimu za ' + iFomu,iFomu,"*.csv")        
        if JinaFaili:
            self.shusha_csv(JinaFaili)
            
    #-----------------------------------------------------------------------------------------------------
    def tunzaViambatanisho(self):
        self.dlgI.show()        
        self.dlgI.orodhaViambata.setColumnCount(3)
        self.dlgI.orodhaViambata.setHeaderLabels(["Jina","Aina","Msimbo"])
        
        # ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        iMsimbo = self.dlg.msimbo.text()        
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iTareheS = self.dlg.tarehemwanzo.date()
        iTareheE = self.dlg.tarehemwisho.date()
        iTakwimu = self.dlg.takwimu.currentText()
        iFomuN = self.dlg.fomundogo.currentText()
        
        #--------------------------------------------------------
        ##########Pata Takwimu za Zilizochaguliwa kwa Tarehe
        sDate = iTareheS.toPyDate()
        eDate = iTareheE.toPyDate()
        jTakwimu = str(iTakwimu)
        
        msimboFoo = ''
        iKiambata = ''
        
        try:
            if sDate == eDate:
                self.dlg.jumbe.setText('Kuna Kosa : Tarehe (Date are the same)')
            elif  sDate > eDate:
                self.dlg.jumbe.setText('Kuna Kosa: Tarehe (The left date should be earlier)')
            elif sDate < eDate:
                sDatei = "__system/submissionDate gt " + str(sDate)
                eDatei = "__system/submissionDate lt " + str(eDate)
                iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/Submissions?$filter=",sDatei," and ",eDatei)
                msimboFoo = "".join(iURL)                
       
            #--------------------------------------------------------
            iMsimbo_Response = requests.get(str(msimboFoo), headers={"Authorization": "Bearer " + session_token},)  
            if iMsimbo_Response.status_code == 200:
                iJson = iMsimbo_Response.json()['value']
                
                items = []
                for iData in iJson:
                    jData = iData['meta']  
                    item = QTreeWidgetItem([jData['instanceID']])
                    
                    jMsimbo = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu))
                    jMsimbo = "".join(jMsimbo)     
                    iKiambata = (jMsimbo,"/submissions/",str(jData['instanceID']),"/attachments")
                    iKiambata = "".join(iKiambata) 
                    
                    jMsimbo_Response = requests.get(iKiambata, headers={"Authorization": "Bearer " + session_token}, )                                        
                    if jMsimbo_Response.status_code == 200:
                        jJson = jMsimbo_Response.json()
                        
                        for kData in jJson:
                            lData = str(kData['name'])
                            mData = lData.split(".")[-1].upper()
                            nData = iKiambata + "/" + lData
                            child = QTreeWidgetItem([lData, mData, nData])
                            item.addChild(child)
                            
                        items.append(item)
                        
                self.dlgI.orodhaViambata.insertTopLevelItems(0, items)

        except:
            self.dlg.jumbe.setText('Shida na Viambatanisho')
            self.dlg.jumbe.setStyleSheet("background: red")
        
        '''
        #treeWidget = QTreeWidget()
        self.dlgI.orodhaViambata.setColumnCount(3)
        self.dlgI.orodhaViambata.setHeaderLabels(["Jina","Aina","Msimbo"])
        
        items = []
        for i in range(5):
            item = QTreeWidgetItem(["KEY: " + str(i)])
            for j in range(3):
                child = QTreeWidgetItem(["A" + str(j),"B" + str(j), str("https://www.wwf.or.tz/")])
                item.addChild(child)
                
            items.append(item)        
        self.dlgI.orodhaViambata.insertTopLevelItems(0, items)
        '''
        return None
        
    #-----------------------------------------------------------------------------------------------------
    def orodheshaMsimboS(self ,selectedItem, selectedColumn):
        if selectedItem:
            self.dlgI.onaJina.setText(str(selectedItem.text(0)))
            self.dlgI.onaExt.setText(str(selectedItem.text(1)))
            self.dlgI.onaMsimbo.setText(str(selectedItem.text(2)))
        
    #-----------------------------------------------------------------------------------------------------
    def orodheshaMsimboD(self, selectedItem, selectedColumn):
        if selectedItem:
            self.dlgI.orodhaViambata.setColumnCount(3)
            self.dlgI.orodhaViambata.setHeaderLabels(["Jina","Aina","Msimbo"])
            iLink = str(selectedItem.text(2))
            
    #-----------------------------------------------------------------------------------------------------
    def orodheshaNakili(self):
        iNakili = self.dlgI.onaMsimbo.text()
        jNakili = pd.DataFrame([str(iNakili)])
        jNakili.to_clipboard(index=False,header=False)

    #-----------------------------------------------------------------------------------------------------
    def msimboShusha(self):
        iNakili = self.dlgI.onaMsimbo.text()
        iJina = self.dlgI.onaJina.text()
        iExt = "*." + self.dlgI.onaExt.text()
        jina = self.dlg.jina.text()
        nywila = self.dlg.nywila.text()
        
        if iNakili:
            JinaFaili, AinaFaili = QFileDialog.getSaveFileName(None, 'Pakua Kiambata ...', iJina, iExt) 
            iJibu = requests.get(iNakili, auth = (jina,nywila), stream=True, allow_redirects=True)            
            iJibuAIna = iJibu.headers.get('content-type')
            self.dlgI.onaExt.setText(iJibuAIna)
            open(JinaFaili, 'wb').write(iJibu.content)
            
    #-----------------------------------------------------------------------------------------------------
    def OnaV(self):
        iNakili = self.dlgI.onaMsimbo.text()
        if iNakili:
            if session_token:
                headers = {'Content-Type': 'application/json; charset=utf-8', "Authorization": "Bearer " + session_token}                 
                iLink = str(iNakili)
                iPicha = requests.get(iLink, headers=headers)
                jPicha = QImage.fromData(iPicha.content)
                
                kPicha = jPicha.scaled(self.dlgJ.OnaLabel.width(), self.dlgJ.OnaLabel.height())
                lPicha = QPixmap.fromImage(kPicha)
                
                self.dlgJ.show()  
                self.dlgJ.OnaLabel.setPixmap(lPicha)
            
            
    # ====================================================================================================
    # ====================================================================================================
    # Get ODK Central Connection - self.dlg.DistancelineEdit.text()
    def ingiaODK(self):
        self.dlg.mradi.clear()
        self.dlg.fomu.clear()
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()        
        
        #Ingia na Orodhesha miradi        
        global session_token
        session_token = self.get_session_token()
        if session_token:
            self.dlg.mradi.addItem('---Chagua Mradi---')
            self.dlg.fomu.addItem('---Chagua Fomu---')   
            self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')    
            self.dlg.aina.addItem('---Chagua Aina Jira---')   
            self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')
            
            self.list_projects()
        
    # ====================================================================================================
    # ====================================================================================================
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = fooodkDialog()
            self.dlgI = fooodkDialogI()
            self.dlgJ = fooodkDialogJ()
            
        self.dlg.patameza.clicked.connect(self.ingiaODK)
        self.dlg.mradi.activated.connect(self.list_forms)
        self.dlg.fomu.activated.connect(self.list_fomundogo)
        self.dlg.fomundogo.activated.connect(self.list_iterms)
        self.dlg.ongeza.clicked.connect(self.Chora)
        self.dlg.koma.clicked.connect(self.tunzaCSV)
        self.dlg.Viambatanisho.clicked.connect(self.tunzaViambatanisho)
        
        
        # Viambatanisho
        self.dlgI.orodhaViambata.itemClicked.connect(self.orodheshaMsimboS)
        #self.dlgI. .itemDoubleClicked.connect(self.orodheshaMsimboD)
        self.dlgI.Nakili.clicked.connect(self.orodheshaNakili)        
        self.dlgI.Ona.clicked.connect(self.OnaV)
        self.dlgI.Shusha.clicked.connect(self.msimboShusha)
        
        #Lugha
        self.dlg.swahili.toggled.connect(self.lugha_SW)
        self.dlg.kiingireza.toggled.connect(self.lugha_EN)        
        
        
        # show the dialog
        self.dlg.show()
        self.get_logins()
        # Run the dialog event loop
        result = self.dlg.exec_()
                
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # self.get_logins()
            pass  