# -*- coding: utf-8 -*-
"""
/***************************************************************************
 fooodk
                                 A QGIS plugin
 This plugin pulls data from ODK Central to QGIS/CSV
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by WWF-Tanzania
        email                : lmathew@wwftz.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import *#QIcon
from qgis.PyQt.QtWidgets import QAction, QComboBox
from qgis.core import * #QgsVectorLayer,QgsFeature

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .fooodk_dialog import fooodkDialog
import os.path
import requests
import json
from urllib.parse import urlparse
from collections import Mapping
from functools import reduce
from datetime import datetime


class fooodk:
    """QGIS Plugin Implementation."""
    
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'fooodk_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FooODK')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('fooodk', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/fooodk/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'FooODK'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&FooODK'),
                action)
            self.iface.removeToolBarIcon(action)
            
    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================
    session_token = ''
    namba_ya_mradi = 0
    # ====================================================================================================
    # ODK Central Session
    def get_session_token(self):
        msimbo = self.dlg.msimbo.text()
        jina = self.dlg.jina.text()
        nywila = self.dlg.nywila.text()
        uMsimbo = (str(msimbo),"/v1/sessions")
        
        email_token_response = requests.post("".join(uMsimbo), data = json.dumps({"email": jina, "password": nywila}), headers = {"Content-Type": "application/json"},)
        
        if email_token_response.status_code == 200:
            return email_token_response.json()["token"]
   
    # ====================================================================================================
    #List all Project
    def list_projects(self):
        iMsimbo = self.dlg.msimbo.text()        
        jMsimbo = (str(iMsimbo),"/v1/projects/")
        kMsimbo = "".join(jMsimbo)
        projects_response = requests.get(kMsimbo,headers={"Authorization": "Bearer " + session_token},)
        projects = {}
        
        if projects_response.status_code == 200:
            for project in projects_response.json():
                self.dlg.mradi.addItem(str(project["id"]) + '|' + project["name"])
            
        return None
            
    # ====================================================================================================
    #List all Forms
    def list_forms(self):
        self.dlg.fomu.clear()
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()
        self.dlg.fomu.addItem('---Chagua Fomu---')   
        self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')   
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
                
        msimbo = self.dlg.msimbo.text()  
        global namba_ya_mradi
        namba_ya_mradi = str(self.dlg.mradi.currentText()).split('|')[0]
        
        fMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/")
        form_response = requests.get("".join(fMsimbo), headers = {"Authorization": "Bearer " + session_token},)         
        if form_response.status_code == 200:
            for fomu in form_response.json():
                self.dlg.fomu.addItem(str(fomu["xmlFormId"]))

        return None

    # ====================================================================================================   
    #Find Specific Key value
    def findValue(self,key, d):
        if key in d:
            return d[key]
        for v in d.values():
            if isinstance(v, dict):
                found = self.findValue(key, v)
                if found is not None:
                    return found
    

    # ====================================================================================================
    #List all Sub forms Forms Iterms
    def list_fomundogo(self):
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()
        self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')           
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
        
        # --------------------------------------------------------
        global namba_ya_mradi
        global iFomuU
        iFomuU = []

        iMsimbo = self.dlg.msimbo.text()        
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iTareheS = self.dlg.tarehemwanzo.date()
        iTareheE = self.dlg.tarehemwisho.date()
        iTakwimu = self.dlg.takwimu.currentText()
        
        #--------------------------------------------------------
        ##########Pata Takwimu za Zilizochaguliwa kwa Tarehe
        sDate = iTareheS.toPyDate()
        eDate = iTareheE.toPyDate()
        jTakwimu = str(iTakwimu)
        
        try:
            if sDate == eDate:
                self.dlg.jumbe.setText('Kuna Kosa : Tarehe (Date are the same)')
            elif  sDate > eDate:
                self.dlg.jumbe.setText('Kuna Kosa: Tarehe (The left date should be earlier)')
            elif sDate < eDate:
                sDatei = "__system/submissionDate gt " + str(sDate)
                eDatei = "__system/submissionDate lt " + str(eDate)
                iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/Submissions?$filter=",sDatei," and ",eDatei)
                jURL = "".join(iURL)                  
                #-------------------------------------------------------------------------------------------------
                iMsimbo_Response = requests.get(str(jURL), headers={"Authorization": "Bearer " + session_token},)
                if iMsimbo_Response.status_code == 200:
                    iJson = iMsimbo_Response.json()['value']                    
                    for iData in iJson:
                        iTambulisho = iData['__id']
                        iFomuU.append(str(iTambulisho))
                        
                    self.dlg.jumbe.setText("Idadi ya Takwimu: " + str(len(iJson)))
                    self.dlg.jumbe.setStyleSheet("background: cyan")
                                                        
                #-------------------------------------------------------------------------------------------------
                jMsimbo = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc")
                kMsimbo = "".join(jMsimbo)
                jMsimbo_Response = requests.get(kMsimbo, headers={"Authorization": "Bearer " + session_token},)
                if jMsimbo_Response.status_code == 200:
                    iFomuSub = jMsimbo_Response.json()['value']
                    for j in iFomuSub:
                        if j["url"] == "Submissions":
                            self.dlg.fomundogo.addItem(j["url"] + "(Fomu Kuu)")
                        else:
                            self.dlg.fomundogo.addItem(j["url"])

        except:
            self.dlg.jumbe.setText("Kuna shida (Error)")
            self.dlg.jumbe.setStyleSheet("background: red")
            
        return None
    # ====================================================================================================   
    # Nested keys in a json
    def extract_paths(self,base_path, dd): 
        new_paths = [] 
        for key, value in dd.items(): 
            new_path = base_path + ('|' if base_path else '') + key 
            if isinstance(value, Mapping): 
                new_paths.extend(self.extract_paths(new_path, value)) 
            else: 
                new_paths.append(new_path) 
        return new_paths
        
    # ====================================================================================================
    # Date Detections
    def isDateValid(self,date):
        pattern = "%Y-%m-%d"
        try:
            datetime.strptime(date, pattern)
            return True
        except ValueError:
            return False
            
    # ====================================================================================================
    # Get Values using nested keys
    def deep_get(self,_dict, keys, default=None):
        def _reducer(d, key):
            if isinstance(d, dict):
                return d.get(key, default)
            if isinstance(d, list):
                return d[key] if len(d) > 0 else default
            return default
        return reduce(_reducer, keys, _dict)
           
    # ====================================================================================================
    def flatten(self,d, base=()):
        for k, v in d.items():
            if isinstance(v, dict):
                yield from self.flatten(v, base + (k,))
            else:
                yield base + (k, v)
                
    # ====================================================================================================
    # ====================================================================================================
    #Chora Nukta
    def ChoraNukta_QGIS(self,Nukta):
        iGeoP =  QgsVectorLayer("Point?crs=epsg:4326", "Jira-Nukta" , "memory")
        jGeoP = iGeoP.dataProvider()
        jGeoP.addAttributes([QgsField('__id', QVariant.String)])
        jGeoP.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoP.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Nukta:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                
                jGeoP.addFeatures([iChora])  
                iGeoP.commitChanges()
                iGeoP.updateFields()
                iGeoP.updateExtents()
                
            QgsProject.instance().addMapLayer(iGeoP)        
            #--------------------------------------------------------
            self.dlg.jumbe.setText('Jira-Nukta Imechorwa (Point Layer Added)')
            self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Nukta') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None

    # ====================================================================================================
    #Chora Mstari
    def ChoraMstari_QGIS(self,Mstari):
        iGeoL = QgsVectorLayer("LineString?crs=epsg:4326", "Jira-Mstari", "memory")
        jGeoL = iGeoL.dataProvider()
        jGeoL.addAttributes([QgsField('__id', QVariant.String)])
        jGeoL.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoL.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Mstari:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                        
                jGeoL.addFeature(iChora)
                iGeoL.commitChanges()
                iGeoL.updateFields()
                iGeoL.updateExtents()
                
            QgsProject.instance().addMapLayer(iGeoL)
            #--------------------------------------------------------
            self.dlg.jumbe.setText('Jira-Mstari Imechorwa (Line Layer Added)')
            self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Mstari') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None

    # ====================================================================================================
    #Chora Mzingo
    def ChoraMzingo_QGIS(self,Mzingo):
        iGeoPo = QgsVectorLayer("Polygon?crs=epsg:4326", "Jira-Mzingo", "memory")
        jGeoPo = iGeoPo.dataProvider()   
        jGeoPo.addAttributes([QgsField('__id', QVariant.String)])
        jGeoPo.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoPo.updateFields()
        
        #--------------------------------------------------------
        try:
            for iterms in Mzingo:
                iterm = iterms.split('||')
                
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0],iterm[2]])
                
                jGeoPo.addFeature(iChora)
                iGeoPo.commitChanges()
                iGeoPo.updateFields()
                iGeoPo.updateExtents()
                
                QgsProject.instance().addMapLayer(iGeoPo)
                #--------------------------------------------------------
                self.dlg.jumbe.setText('Jira-Mzingo Imechorwa (Polygon Layer Added)')
                self.dlg.jumbe.setStyleSheet("background: green")
            
        except:
            self.dlg.jumbe.setText('Shida na Jira-Mzingo') 
            self.dlg.jumbe.setStyleSheet("background: red")
        
        
        return None
                     
                
        
    # ====================================================================================================   
    # ====================================================================================================
    # https://towardsdatascience.com/how-do-i-extract-nested-data-in-python-4e7bed37566a
    #List all Forms Iterms
    def list_iterms(self):
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()     
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   

        #self.dlg.tarehemwanzo('---Chagua Aina ya Tarehe---')
        #self.dlg.tarehemwisho('---Chagua Aina ya Tarehe---')

        msimbo = self.dlg.msimbo.text()  
        namba_ya_mradi = str(self.dlg.mradi.currentText()).split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuNdogo = self.dlg.fomundogo.currentText()
        

        iMsimboFomu = ""            
        if iFomuNdogo == "Submissions(Fomu Kuu)":
            iSub = str(iFomuNdogo).split("(")[0]
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iSub))
            iMsimboFomu = "".join(iMsimbo)
        else:
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iFomuNdogo))
            iMsimboFomu = "".join(iMsimbo)
        
        iResponse = requests.get(str(iMsimboFomu), headers={"Authorization": "Bearer " + session_token},)
        if iResponse.status_code == 200:
            iJson = iResponse.json()['value'][0]            
            #--------------------------------------------------------
            for items in self.flatten(iJson):
                iKeys = '|'.join(map(str, items))
                if "Point" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                elif "LineString" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                elif "Polygon" in str(iKeys):
                    self.dlg.aina.addItem(str(iKeys))
                    
            #--------------------------------------------------------
            for jKeys in iJson:
                self.dlg.takwimu.addItem(str(jKeys))                    
    
    # ====================================================================================================   
    # ====================================================================================================
    # Export XSV
    def shusha_csv(self):
        self.dlg.jumbe.setText('Toleo Lijalo (Next Version)')
        self.dlg.jumbe.setStyleSheet("background: blue")
        
        '''
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()     
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
        msimbo = self.dlg.msimbo.text()  
        namba_ya_mradi = str(self.dlg.mradi.currentText()).split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuNdogo = self.dlg.fomundogo.currentText()
        

        iMsimboFomu = ""            
        if iFomuNdogo == "Submissions(Fomu Kuu)":
            iSub = str(iFomuNdogo).split("(")[0]
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iSub),"csv")
            iMsimboFomu = "".join(iMsimbo)
        else:
            iMsimbo = (str(msimbo),"/v1/projects/",str(namba_ya_mradi),"/forms/",str(iFomu),".svc/",str(iFomuNdogo),"csv")
            iMsimboFomu = "".join(iMsimbo)
        
        iResponse = requests.get(str(iMsimboFomu), headers={"Authorization": "Bearer " + session_token},)
        if iResponse.status_code == 200:
            self.dlg.jumbe.setText(str(iMsimbo))
            self.dlg.jumbe.setStyleSheet("background: blue")
        '''

    # ====================================================================================================
    # ====================================================================================================
    #Plot Points
    def Chora(self):
        iMsimbo = self.dlg.msimbo.text()  
        global namba_ya_mradi
        iMradi = self.dlg.mradi.currentText().split('|')[0]
        iFomu = self.dlg.fomu.currentText()
        iFomuN = self.dlg.fomundogo.currentText()
        iType = self.dlg.aina.currentText()
        iTakwimu = self.dlg.takwimu.currentText()        
        
        zJira = str(str(iType).split("|")[-1:][0])
        jTakwimu = str(iTakwimu)
        #--------------------------------------------------------
        iM = ""
        iN = False        
        xJira = []
        iChuja = ''
        fanksheni = ""
        
        if iFomuN == "Submissions(Fomu Kuu)":
            iSub = str(iFomuN).split("(")[0]
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iSub))
            iM = "".join(iURL)
            iChuja = '__id'
        else:
            iURL = (str(iMsimbo),"/v1/projects/",str(iMradi),"/forms/",str(iFomu),".svc/",str(iFomuN))
            iM = "".join(iURL)          
            iChuja = '__Submissions-id'
        
        #--------------------------------------------------------
        iMsimbo_Response = requests.get(str(iM), headers={"Authorization": "Bearer " + session_token},)  
        if iMsimbo_Response.status_code == 200:
            iJson = iMsimbo_Response.json()['value']
            xJira = []
            fanksheni = ""
            
            for iData in iJson:
                subID = str(iData[iChuja])
                kTakwimu = str(iData[jTakwimu])
                #--------------------------------------------------------   
                for items in self.flatten(iData):
                    iKeys = '|'.join(map(str, items))                    
                    #--------------------------------------------------------  
                    if iData[iChuja] in iFomuU:
                        if str(iType) == str(iKeys) and str(zJira) == "Point":
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)                            
                            
                            XYZ = " ".join(map(str, iValues))
                            iXYZ = ("POINT (" + XYZ +")")                            
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
                        #--------------------------------------------------------
                        ##########Jira Mstari
                        if str(iType) == str(iKeys)  and str(zJira) == "LineString":                           
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)
                            
                            l = ""
                            for i in iValues:
                                j = ("".join(str(i))[1:][:-1]).replace(",", "")
                                l = l + ", " + j
                                
                            XYZ = l[1:]                                
                            iXYZ = ("LINESTRING (" + XYZ +")")
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
                        #--------------------------------------------------------
                        ##########Jira Mzingo
                        if str(iType) in str(iKeys) and str(zJira)  == "Polygon":
                            iJira = (iKeys.split("|")[:-2]) + ['coordinates']
                            iValues = self.deep_get(iData, iJira)
                            
                            l = ""
                            for i in iValues[0]:
                                j = ("".join(str(i))[1:][:-1]).replace(",", "")
                                l = l + ", " + j
                                
                            XYZ = l[1:]
                            iXYZ = ("POLYGON ((" + XYZ + "))")
                            jXYZ = (subID,iXYZ,kTakwimu)
                            kXYZ = "||".join(jXYZ)
                            xJira.append(kXYZ)
                            
        else:
            self.dlg.jumbe.setText('Hakuna Takwimu, Badilisha Tarehe')
            self.dlg.jumbe.setStyleSheet("background: red")
            
        #--------------------------------------------------------
        if str(zJira) == "Point":
            self.ChoraNukta_QGIS(xJira)
        if str(zJira) == "LineString":
            self.ChoraMstari_QGIS(xJira)
        if str(zJira) == "Polygon":
            self.ChoraMzingo_QGIS(xJira)
            
        return None
                    
    # ====================================================================================================
    # ====================================================================================================
    # Get ODK Central Connection - self.dlg.DistancelineEdit.text()
    def ingiaODK(self):
        self.dlg.mradi.clear()
        self.dlg.fomu.clear()
        self.dlg.fomundogo.clear()
        self.dlg.aina.clear()
        self.dlg.takwimu.clear()
        
        self.dlg.mradi.addItem('---Chagua Mradi---')
        self.dlg.fomu.addItem('---Chagua Fomu---')   
        self.dlg.fomundogo.addItem('---Chagua Fomu Ndogo---')    
        self.dlg.aina.addItem('---Chagua Aina Jira---')   
        self.dlg.takwimu.addItem('---Chagua Aina Takwimu---')   
        
        #self.dlg.ujumbe.setText('Taarifa zote Hapa')
        
        global session_token
        session_token = self.get_session_token()
        
        #self.dlg.ujumbe.setText = session_token
        self.list_projects()
        
       
        
    # ====================================================================================================
    # ====================================================================================================
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = fooodkDialog()
            
        self.dlg.patameza.clicked.connect(self.ingiaODK)
        self.dlg.mradi.activated.connect(self.list_forms)
        self.dlg.fomu.activated.connect(self.list_fomundogo)
        self.dlg.fomundogo.activated.connect(self.list_iterms)
        self.dlg.ongeza.clicked.connect(self.Chora)
        self.dlg.koma.clicked.connect(self.shusha_csv)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
        



    