"""
/***************************************************************************
 DlgFoliosWizard
                                 A QGIS plugin
 FoliosWizard
                             -------------------
        begin                : 2024-08-19
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Jean-Marie Arsac
        email                : jmarsac@azimut.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtWidgets, uic

from folios_wizard.folio_geometry import FolioGeometry
from folios_wizard.gui.splash.read_show_metadata import read_show_metadata
from folios_wizard.toolbelt.preferences import PlgOptionsManager
from folios_wizard.utils import Utils

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "dlg_folios_wizard.ui")
)


class DlgFoliosWizard(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DlgFoliosWizard, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self._settings = PlgOptionsManager.get_plg_settings()
        self.setupUi(self)

        self.label_date.setEnabled(False)
        self.label_date.setVisible(False)
        self.label_timestamp.setEnabled(False)
        self.label_timestamp.setVisible(False)
        self.toolButtonCleanCanvas.setEnabled(False)
        self.toolButtonCleanCanvas.setVisible(False)

    def show_dialog(self, settings):
        self._settings = settings
        read_show_metadata()
        self.preload_dialog_fields()
        self.show()

    def clean_folios(self):
        FolioGeometry.removeExistingFolios()
        self._layout.removeProjectLayouts(True)
        self.iface.mapCanvas().refresh()
        if self.dlg:
            self.dlg.comboBoxPrintScale.setEnabled(True)
            self.dlg.comboBoxLayout.setEnabled(True)
        self.iface.actionIdentify().trigger()

    def preload_dialog_fields(self):
        if self._settings.title:
            if self._settings.title[0:1] == "@":
                self.label_title.setText(self._settings.title[1:])
            self.lineEdit_title.setText(
                Utils.expandVariablesInString(self._settings.title)
            )
        if self._settings.subtitle:
            if self._settings.subtitle[0:1] == "@":
                self.label_subtitle.setText(self._settings.subtitle[1:])
            self.lineEdit_subtitle.setText(
                Utils.expandVariablesInString(self._settings.subtitle)
            )
        if self._settings.description:
            if self._settings.description[0:1] == "@":
                self.label_description.setText(self._settings.description[1:])
            self.lineEdit_description.setText(
                Utils.expandVariablesInString(self._settings.description)
            )
        if self._settings.field1:
            if self._settings.field1[0:1] == "@":
                self.label_field1.setText(self._settings.field1[1:])
            self.lineEdit_field1.setText(
                Utils.expandVariablesInString(self._settings.field1)
            )
        if self._settings.field2:
            if self._settings.field2[0:1] == "@":
                self.label_field2.setText(self._settings.field2[1:])
            self.lineEdit_field2.setText(
                Utils.expandVariablesInString(self._settings.field2)
            )
        if self._settings.field3:
            if self._settings.field3[0:1] == "@":
                self.label_field3.setText(self._settings.field3[1:])
            self.lineEdit_field3.setText(
                Utils.expandVariablesInString(self._settings.field3)
            )
        if self._settings.field4:
            if self._settings.field4[0:1] == "@":
                self.label_field4.setText(self._settings.field4[1:])
            self.lineEdit_field4.setText(
                Utils.expandVariablesInString(self._settings.field4)
            )
