"""
/***************************************************************************
 flowTrace
                                 A QGIS plugin
 traces the flow along poly
                              -------------------
        begin                : 2012-10-30
        copyright            : (C) 2012 by Ed
        email                : boesiii@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from flowtracedialog import flowTraceDialog

class flowTrace:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/flowtrace/icon.png"), \
            "Flow Trace", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Flow Trace", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Flow Trace",self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
		
		#setup final selection list
		final_list = []
		#setup temporary selection list
		selection_list = []
		#add tolernace value
		tolerance = 0.01
		#get current layer
		clayer = self.iface.mapCanvas().currentLayer()
		
		if clayer is None:
			return 
		
		#get provider
		provider = clayer.dataProvider()
		#setup empty feature
		feat = QgsFeature()
		#select all features for comparing coordinates
		#provider.select()
		
		for feature in clayer.selectedFeatures():
			# add selected features to final list
			final_list.append(feature.id())
			# add selected features to selection list for while loop
			selection_list.append(feature.id())
			

		#loop thru selection list
		while selection_list:
			#QMessageBox.information(None, "DEBUG:", "Selection List: " + str(selection_list))
			feat = QgsFeature()
			provider.featureAtId(selection_list[0], feat)
			# get node list
			nodes = feat.geometry().asPolyline()
			# get upstream coordinate
			upstream_coord = nodes[0]
			# select all features around upstream coordinate using a 20 unit bounding box					
			provider.select([], QgsRectangle(upstream_coord.x() - 10, upstream_coord.y() - 10, upstream_coord.x() + 10, upstream_coord.y() + 10))
			
			# loop thru all features
			while provider.nextFeature(feat):
				#get list of nodes
				nodes = feat.geometry().asPolyline()
				downstream_coord = nodes[1]
				distance = QgsDistanceArea()
				dist = distance.measureLine(downstream_coord, upstream_coord)
				#QMessageBox.information(None, "DEBUG:", "FID: " + str(feat.id()) + " -- UC: " + str(downstream_coord) + " -- DC: " + str(upstream_coord) + " -- Dist: " + str(dist))
				if dist < tolerance:
					#add feature to final list
					final_list.append(feat.id())
					selection_list.append(feat.id())
						
			selection_list.pop(0)
					
		
		clayer.setSelectedFeatures(final_list)
		self.iface.mapCanvas().refresh()