# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FloorPlanFilter
                                 A QGIS plugin
 This plugin applies a query filter to multiple map layers to visualize individual floor plans.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-19
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Rob Braggaar
        email                : rob@geofacta.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProject, QgsMessageLog

from qgis.PyQt.QtWidgets import QAction
from PyQt5.QtWidgets import QAction
# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .floor_plan_filter_dockwidget import FloorPlanFilterDockWidget
import os.path


class FloorPlanFilter:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'FloorPlanFilter_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Floor plan filter')
        self.toolbar = self.iface.addToolBar(u'FloorPlanFilter')
        self.toolbar.setObjectName(u'FloorPlanFilter')

        self.pluginIsActive = False
        self.dockwidget = None

        self.floorLevel = 0


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FloorPlanFilter', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/floor_plan_filter/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Open panel'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING FloorPlanFilter"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD FloorPlanFilter"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Floor plan filter'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def on_value_changed_spinbox(self, val):
        # handles change event for the SpinBox when the user enters the value directly
        self.floorLevel = val
        self.apply_filters()

    def on_value_changed_pushbutton(self, change):
        # change the filter through the PushButtons
        self.floorLevel += change    
        self.dockwidget.currentFloorLevelEdit.setValue(self.floorLevel)
        self.apply_filters()

    def apply_filters(self):
        for layer in self.layers:
            current_filter = layer.subsetString()
            new_filter = (current_filter.split("=")[0] + "= '{}'").format(self.floorLevel)
            #new_filter = current_filter.split("'")[0] + " " + str(self.floorLevel)
            if 'bouwlaag =' in layer.subsetString():
                QgsMessageLog.logMessage(new_filter, level=0)
                layer.setSubsetString(new_filter)   

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING FloorPlanFilter"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = FloorPlanFilterDockWidget()

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget in the left dock widget area
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

            # Fetch the currently loaded layers
            self.layers = QgsProject.instance().mapLayers().values()
            # self.layers = QgsProject.instance().layerTreeRoot().children()
            self.dockwidget.currentFloorLevelEdit.setValue(self.floorLevel)
            self.dockwidget.currentFloorLevelEdit.setMinimum(-100)

            # attach listeners for UI buttons and spinbox
            self.dockwidget.decreaseFloorLevelButton.clicked.connect(lambda: self.on_value_changed_pushbutton(-1))
            self.dockwidget.increaseFloorLevelButton.clicked.connect(lambda: self.on_value_changed_pushbutton(1))
            self.dockwidget.currentFloorLevelEdit.valueChanged.connect(self.on_value_changed_spinbox)  
