# -*- coding: utf-8 -*-

"""
/***************************************************************************
 FloodRiskSwatPlus
                                 A QGIS plugin
 FloodRiskSwatPlus
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-01-30
        copyright            : (C) 2025 by ICRA - Oliu Llorente
        email                : ollorente@icra.cat
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'ICRA - Oliu Llorente'
__date__ = '2025-01-30'
__copyright__ = '(C) 2025 by ICRA - Oliu Llorente'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.core import *
from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .FloodRiskSwatPlus_provider import FloodRiskSwatPlusProvider

from processing.gui.AlgorithmDialog import AlgorithmDialog
from qgis.core import QgsApplication, QgsProcessingFeedback, QgsProcessingParameters

from .allProcess.DamageUnits import DamageUnitsLayer as damageUnits
from .allProcess.FloodRisk import FloodRiskMitigation as FloodRisk



cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class FloodRiskSwatPlusPlugin(object):

    def __init__(self, iface):

        self.provider = None
        self.iface = iface
        self.provider = FloodRiskSwatPlusProvider()

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = FloodRiskSwatPlusProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def DamageUnits(self):
        servei = damageUnits()
        servei.initAlgorithm()
        servei.setProvider(self.provider)
        dlg = AlgorithmDialog(servei, parent=self.iface.mainWindow())
        dlg.show()
        # do NOT remove!!!! if you do then sip forgets the python subclass of AlgorithmDialog and you get a broken
        # dialog
        dlg.exec_()

    def FloodRiskMitigation(self):
        servei = FloodRisk()
        servei.initAlgorithm()
        servei.setProvider(self.provider)
        dlg = AlgorithmDialog(servei, parent=self.iface.mainWindow())
        dlg.show()
        # do NOT remove!!!! if you do then sip forgets the python subclass of AlgorithmDialog and you get a broken
        # dialog
        dlg.exec_()

    def initGui(self):
        self.menu = QMenu("FloodRiskSwat+", self.iface.mainWindow().menuBar())
        self.action_damageUnits = QAction("Damage units", self.iface.mainWindow())
        self.mitigation = QAction("Risk Mitigation", self.iface.mainWindow())

        actions = self.iface.mainWindow().menuBar().actions()
        lastAction = actions[-1]
        self.iface.mainWindow().menuBar().insertMenu(lastAction, self.menu)
        self.menu.addAction(self.action_damageUnits)
        self.menu.addAction(self.mitigation)

        self.action_damageUnits.triggered.connect(self.DamageUnits)
        self.mitigation.triggered.connect(self.FloodRiskMitigation)
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
