# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FloodRisk2
                                 A QGIS plugin
 This plugin assist authorities for flood risk analysis and management
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-09-04
        git sha              : $Format:%H$
        copyright            : (C) 2018 by L.Mancusi/RSE S.p.A.
        email                : leonardo.mancusi@rse-web.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the dialog
from .ProjectManagement.ProjectManagementDialog import ProjectDialog
from .ProjectCaricaDati.ProjectCaricaDatiDialog import CaricaDati_Dialog
from .ProjectCalcolaDanno.ProjectCalcolaDannoDialog import CalcolaDanno_Dialog
from .ProjectCalcolaRischio.ProjectCalcolaRischioDialog import CalcolaRischio_Dialog
from .ProjectGrafici.ProjectGraficiDialog import Grafici_Dialog
from .help import show_context_help

import numpy
import os.path
import sqlite3

class FloodRisk2:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """
        Constructor.
        :param iface: An interface instance that will be passed to this class which provides the hook by which you can manipulate the QGIS application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'FloodRisk2_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = ProjectDialog(self.iface)
        self.dlg2 = CaricaDati_Dialog(self.iface)
        self.dlg3 = CalcolaDanno_Dialog(self.iface)
        self.dlg4 = CalcolaRischio_Dialog(self.iface)
        self.dlg5 = Grafici_Dialog(self.iface)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FloodRisk2')

        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'FloodRisk2')
        self.toolbar.setObjectName(u'FloodRisk2')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """
        Get the translation for a string using Qt translation API.
        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FloodRisk2', message)


    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also  added to self.actions list.
        :rtype: QAction
        """
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu,action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/floodrisk2/icons/iconafloodrisk.png'
        #self.add_action(icon_path, text=self.tr(u'Flood risk analysis'), callback=self.run, parent=self.iface.mainWindow())

        #---Create Toolbar-------------------------------------------
        self.toolbar = self.iface.addToolBar('FloodRisk2_')
        self.toolbar.setObjectName('FloodRisk2ToolBar')

        # 1----first button---------------------------------
        self.toolbarProjectManagement = QAction(QIcon(':/plugins/floodrisk2/icons/1fp.png'), \
            'ProjectManagement', self.iface.mainWindow())
        self.toolbarProjectManagement.setObjectName('toolbarProjectManagement')
        self.toolbarProjectManagement.setCheckable(False)
        self.toolbarProjectManagement.triggered.connect(self.showToolbarProjectManagement)
        self.toolbar.addAction(self.toolbarProjectManagement)

        # 2----second button---------------------------------
        self.toolbarProjectCaricaDati = QAction(QIcon(':/plugins/floodrisk2/icons/2db.png'), \
            'ProjectCaricaDati', self.iface.mainWindow())
        self.toolbarProjectCaricaDati.setObjectName('toolbarProjectCaricaDati')
        self.toolbarProjectCaricaDati.setCheckable(False)
        self.toolbarProjectCaricaDati.triggered.connect(self.showToolbarProjectCaricaDati)
        self.toolbar.addAction(self.toolbarProjectCaricaDati)

        # 3----third button---------------------------------
        self.toolbarProjectCalcolaDanno = QAction(QIcon(':/plugins/floodrisk2/icons/3ei.png'), \
            'ProjectCalcolaDanno', self.iface.mainWindow())
        self.toolbarProjectCalcolaDanno.setObjectName('toolbarProjectCalcolaDanno')
        self.toolbarProjectCalcolaDanno.setCheckable(False)
        self.toolbarProjectCalcolaDanno.triggered.connect(self.showToolbarProjectCalcolaDanno)
        self.toolbar.addAction(self.toolbarProjectCalcolaDanno)

        # 4----fourth button---------------------------------
        self. toolbarProjectCalcolaRischio = QAction(QIcon(':/plugins/floodrisk2/icons/4lol.png'), \
            'ProjectCalcolaRischio', self.iface.mainWindow())
        self.toolbarProjectCalcolaRischio.setObjectName('toolbarProjectCalcolaRischio')
        self.toolbarProjectCalcolaRischio.setCheckable(False)
        self.toolbarProjectCalcolaRischio.triggered.connect(self.showToolbarProjectCalcoloRischio)
        self.toolbar.addAction(self.toolbarProjectCalcolaRischio)

        # 5----fifth button---------------------------------
        self.toolbarProjectGrafici = QAction(QIcon(':/plugins/floodrisk2/icons/5h.bmp'), \
            'ProjectGrafici', self.iface.mainWindow())
        self.toolbarProjectGrafici.setObjectName('toolbarProjectGrafici')
        self.toolbarProjectGrafici.setCheckable(False)
        self.toolbarProjectGrafici.triggered.connect(self.showToolbarProjectGrafici)
        self.toolbar.addAction(self.toolbarProjectGrafici)

        # 6----sixth button---------------------------------
        self.toolbartoolbarHelp = QAction(QIcon(':/plugins/floodrisk2/icons/6h.png'), \
            'Help', self.iface.mainWindow())
        self.toolbartoolbarHelp.setObjectName('Help')
        self.toolbartoolbarHelp.setCheckable(False)
        self.toolbartoolbarHelp.triggered.connect(self.show_help)
        self.toolbar.addAction(self.toolbartoolbarHelp)

         # add buttons to menu
        self.iface.addPluginToMenu("Floodrisk2", self.toolbarProjectManagement)
        self.iface.addPluginToMenu("Floodrisk2", self.toolbarProjectCaricaDati)
        self.iface.addPluginToMenu("Floodrisk2", self.toolbarProjectCalcolaDanno)
        self.iface.addPluginToMenu("Floodrisk2", self.toolbarProjectCalcolaRischio)
        self.iface.addPluginToMenu("Floodrisk2", self.toolbarProjectGrafici)
        self.iface.addPluginToMenu("Floodrisk2", self.toolbartoolbarHelp)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&FloodRisk2'), action)
            self.iface.removeToolBarIcon(action)

        del self.toolbar                    # remove the toolbar

    def showToolbarProjectManagement(self):
        self.dlg.exec_()                    # Run the window

    def showToolbarProjectCaricaDati(self):
        # inizializzo eventualmente il self.dlg2
        #self.geoDataBase=self.dlg.txtShellFilePath_2.text()
        self.geoDataBase = self.dlg.comboBox.currentText()

        if self.geoDataBase!="":
            self.dlg2.txtShellFilePath.setText(self.geoDataBase)

            # ------------------- Carico il database e inserisco i dati nel ComboBox (Exposure Instance) ---------------------------------
            conn = sqlite3.connect(self.geoDataBase, detect_types=sqlite3.PARSE_DECLTYPES|sqlite3.PARSE_COLNAMES)
            conn.enable_load_extension(True)
            conn.execute("SELECT load_extension('mod_spatialite')")
            cur = conn.cursor()
            sql="SELECT instance, Description from ExposureInstance"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg2.comboBox_6.clear()

            for row in records:
                self.dlg2.comboBox_6.addItem(str(row[0]))

            # Close communication with the database
            cur.close()
            conn.close()

        self.dlg2.setFileSql()
        self.dlg2.exec_()                   #Run the window


    def showToolbarProjectCalcolaDanno(self):
        # inizializzo eventualmente il self.dlg3
        # self.geoDataBase=self.dlg.txtShellFilePath_2.text()
        self.geoDataBase=self.dlg.comboBox.currentText()

        if self.geoDataBase!="":
            self.dlg3.txtShellFilePath_2.setText(self.geoDataBase)

            # ------------------- Carico il database ---------------------------------
            conn = sqlite3.connect(self.geoDataBase, detect_types=sqlite3.PARSE_DECLTYPES|sqlite3.PARSE_COLNAMES)
            conn.enable_load_extension(True)
            conn.execute("SELECT load_extension('mod_spatialite')")
            cur = conn.cursor()

            # ------------------- inserisco i dati nel ComboBox (Hazard Instance) ---------------------------------
            sql="SELECT instance, Description from HazardInstance"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg3.comboBox_6.clear()

            for row in records:
                self.dlg3.comboBox_6.addItem(str(row[0]))

            # ------------------- inserisco i dati nel ComboBox (Exposure Instance) ----------------------------
            sql="SELECT instance, Description from ExposureInstance"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg3.comboBox_8.clear()

            for row in records:
                self.dlg3.comboBox_8.addItem(str(row[0]))

            # ------------------- inserisco i dati nel ComboBox (VulnType) -------------------------------------
            sql="SELECT VulnID, Description from VulnType"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg3.comboBoxGrafici.clear()

            for row in records:
                self.dlg3.comboBoxGrafici.addItem(str(row[0]) + " - " + str(row[1]))

            # ------------------- inserisco i dati nel ComboBox (Hazard Files) ---------------------------------
            sql = ("SELECT DISTINCT YearReturnPeriod from HazardFiles");
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg3.comboBox_10.clear()

            for row in records:
                self.dlg3.comboBox_10.addItem(str(row[0]))

            # ------------------- inserisco i dati nel ComboBox (DAMAGESCENARIOS) ---------------------------------
            sql="SELECT Numscenario, Description from DAMAGESCENARIOS"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg3.comboBox_7.clear()
            self.dlg3.comboBox_9.clear()

            for row in records:
                self.dlg3.comboBox_7.addItem(str(row[0]))
                self.dlg3.comboBox_9.addItem(str(row[0]))

            # Close communication with the database
            cur.close()
            conn.close()

        self.dlg3.exec_()                   #Run the window

    def showToolbarProjectCalcoloRischio(self):
        # inizializzo eventualmente il self.dlg4
        #self.geoDataBase=self.dlg.txtShellFilePath_2.text()
        self.geoDataBase=self.dlg.comboBox.currentText()

        if self.geoDataBase!="":
            self.dlg4.txtShellFilePath_2.setText(self.geoDataBase)

            # ------------------- Carico il database ---------------------------------
            conn = sqlite3.connect(self.geoDataBase, detect_types=sqlite3.PARSE_DECLTYPES|sqlite3.PARSE_COLNAMES)
            conn.enable_load_extension(True)
            conn.execute("SELECT load_extension('mod_spatialite')")
            cur = conn.cursor()

            # ------------------- inserisco i dati nel ComboBox (Hazard Instance) ------------------------------
            sql="SELECT instance, Description from HazardInstance"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg4.comboBox_6.clear()

            for row in records:
                self.dlg4.comboBox_6.addItem(str(row[0]))

            # ------------------- inserisco i dati nel ComboBox (Exposure Instance) ------------------------------
            sql="SELECT instance, Description from ExposureInstance"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg4.comboBox_8.clear()

            for row in records:
                self.dlg4.comboBox_8.addItem(str(row[0]))

            # ---------------------- inserisco i dati nel ComboBox (Hazard Files) ---------------------------------
            sql = ("SELECT DISTINCT YearReturnPeriod from HazardFiles");
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg4.comboBox_10.clear()

            for row in records:
                self.dlg4.comboBox_10.addItem(str(row[0]))

            # ------------------- inserisco i dati nel ComboBox (POPSCENARIOS) ---------------------------------
            sql="SELECT Numscenario, Description from POPSCENARIOS"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg4.comboBox_3.clear()
            self.dlg4.comboBox_9.clear()

            for row in records:
                self.dlg4.comboBox_3.addItem(str(row[0]))
                self.dlg4.comboBox_9.addItem(str(row[0]))

            # -------------------------- Close communication with the database ----------------------------
            cur.close()
            conn.close()

            # ------------------- inserisco i dati nel ComboBox ( ... ) ---------------------------------
            self.dlg4.comboBox.clear()
            self.dlg4.comboBox.addItem('Vague')
            self.dlg4.comboBox.addItem('Precise')

            # ------------------- inserisco i dati nel ComboBox ( ... ) ---------------------------------
            self.dlg4.comboBox_2.clear()

            for item in range(1,11):
                self.dlg4.comboBox_2.addItem('C' + str(item))

        self.dlg4.exec_()                   #Run the window

    def showToolbarProjectGrafici(self):
        # inizializzo eventualmente il self.dlg5
        self.geoDataBase=self.dlg.comboBox.currentText()

        if self.geoDataBase!="":
            self.dlg5.txtShellFilePath_2.setText(self.geoDataBase)

            self.geoDataBase=self.dlg.comboBox.currentText()
            conn = sqlite3.connect(self.geoDataBase, detect_types=sqlite3.PARSE_DECLTYPES|sqlite3.PARSE_COLNAMES)
            conn.enable_load_extension(True)
            conn.execute("SELECT load_extension('mod_spatialite')")
            cur = conn.cursor()

            # ------------------- inserisco i dati nel ComboBox (DAMAGESCENARIOS) ---------------------------
            sql="SELECT Numscenario from DAMAGESCENARIOS"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg5.comboBox_7.clear()
            self.dlg5.comboBox_9.clear()
            self.dlg5.comboBox_12.clear()

            for row in records:
                s=str(row[0])
                self.dlg5.comboBox_7.addItem(s)
                self.dlg5.comboBox_9.addItem(s)
                self.dlg5.comboBox_12.addItem(s)

            # ------------------- inserisco i dati nel ComboBox (POPSCENARIOS) ----------------------------
            sql="SELECT Numscenario from POPSCENARIOS"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg5.comboBox_11.clear()
            self.dlg5.comboBox_10.clear()
            self.dlg5.comboBox_13.clear()

            for row in records:
                s=str(row[0])
                self.dlg5.comboBox_11.addItem(s)
                self.dlg5.comboBox_10.addItem(s)
                self.dlg5.comboBox_13.addItem(s)

            # ------------------- inserisco i dati nel ComboBox (LOLMeasures) ----------------------------
            sql = "SELECT Description from LOLMeasures"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg5.comboBox_15.clear()

            for row in records:
                s = str(row[0])
                self.dlg5.comboBox_15.addItem(s)

            # ------------------- inserisco i dati nel ComboBox (DamageMeasures) --------------------------
            sql = "SELECT Description from DamageMeasures"
            cur.execute(sql)
            records=cur.fetchall()
            self.dlg5.comboBox_14.clear()

            for row in records:
                s = str(row[0])
                self.dlg5.comboBox_14.addItem(s)

            # ---------------------- Close communication with the database -------------------------------
            cur.close()
            conn.close()
        try:
            self.dlg5.exec_()                    #Run the window
        except:
            pass

    def show_help(self):
        """Load the help text into the system browser."""
        show_context_help(context='index')

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()

        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and substitute with your code.
            pass
