# -*- coding: utf-8 -*-

"""
/***************************************************************************
 FlightCalculator
                                 A QGIS plugin
 This plugin calculates the distance, time take and estimated fuel burn for a line dataset.  
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-19
        copyright            : (C) 2024 by Elena Field/British Antarctic Survey
        email                : eleeld@bas.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Elena Field/British Antarctic Survey'
__date__ = '2024-07-19'
__copyright__ = '(C) 2024 by Elena Field/British Antarctic Survey'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon


from qgis.core import QgsProcessingAlgorithm, QgsApplication
from qgis.core import QgsExpression

from .flight_calculator_provider import FlightCalculatorProvider
from .journey_time_expression import calculate_time_taken
from .fuel_burn_calc_expression import calculate_fuel_burn

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class FlightCalculatorPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = FlightCalculatorProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        QgsExpression.registerFunction(calculate_time_taken)
        QgsExpression.registerFunction(calculate_fuel_burn)
        icon = os.path.join(os.path.join(cmd_folder, '/flight_calculator_icon.svg'))
        self.action = QAction(
            QIcon(icon),
            u"Flight Calculator",self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        #from .journey_time_expression import calculate_time_taken
        #from .fuel_burn_calc_expression import calculate_fuel_burn

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        QgsExpression.unregisterFunction(calculate_time_taken.name())
        QgsExpression.unregisterFunction(calculate_fuel_burn.name())
        self.iface.removePluginMenu(u"&FlightCalculator", self.action)
        self.iface.removeToolBarIcon(self.action)


    def run(self):
        processing.execAlgorithmDialog("Flight Calculator:Flight Calculator")