# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UserAndIvDialog
                                 A QGIS plugin
 This plugin helps downloading metadata of geotagged Flickr photos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-06-04
        git sha              : $Format:%H$
        copyright            : (C) 2018-2026 by Mátyás Gede
        email                : gedematyas@inf.elte.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import qgis.utils

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import QAction, QMessageBox, QWidget, QApplication
from PyQt5.QtCore import *
from PyQt5 import QtSql
from PyQt5.QtSql import *
from datetime import date,datetime

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'user_and_iv_dialog_base.ui'))


class UserAndIvDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(UserAndIvDialog, self).__init__(parent)
        # Set up the user interface from Designer.
        self.setupUi(self)
        self.fwDBFile.setFilter("SQLite files (*.sqlite)")
        # event handlers
        self.fwDBFile.fileChanged.connect(self.getTblNames) # DB file selected
        self.cbTable.currentIndexChanged.connect(self.setUITblNames) # auto set user and interval table names
        self.pbCreate.clicked.connect(self.createTables) # Create button
        self.pbClose.clicked.connect(self.close) # Close button
        self.WT=None
      
    def createTables(self):
        """Create user and interval tables and populate them"""
        # number of days between dates
        def ddiff(d2,d1):
            dd1=datetime.strptime(d1,"%Y-%m-%d").date()
            dd2=datetime.strptime(d2,"%Y-%m-%d").date()
            return (dd2-dd1).days;
        params={}
        params['dbFile']=self.fwDBFile.filePath()
        params['pt']=self.cbTable.currentText()
        params['ut']=self.leUTable.text()
        params['it']=self.leITable.text()
        params['ivth']=int(self.leITreshold.text())
        params['shortMax']=int(self.leShortMax.text())
        params['longMin']=int(self.leLongMin.text())
        params['localMin']=int(self.leLocalMin.text())
        params['localILength']=int(self.leLocalILength.text())
        
        # create and start thread
        self.WT=WorkerThread(qgis.utils.iface.mainWindow(), params)
        self.WT.jobFinished.connect(self.jobFinishedFromThread)
        self.WT.setTotal.connect(self.setTotal)
        self.WT.setProgress.connect(self.setProgress)
        self.WT.message.connect(self.message)
        self.WT.start()
        
        
    def close(self):
        """Close dialog"""
        if self.WT is not None:
            self.WT.stop()
        self.reject()
    
    def getTblNames(self):
        """DB file selected, read table names"""
        dbFile=self.fwDBFile.filePath()
        con=qgis.utils.spatialite_connect(dbFile)
        cur=con.cursor()
        # read spatialite tables
        cur.execute("select f_table_name from geometry_columns where geometry_type=1;")
        ts=cur.fetchall()
        # populate table selector combobox
        self.cbTable.clear()
        for t in ts:
            self.cbTable.addItem(t[0])
        # set progress bar to zero
        self.progressBar.setValue(0)
            
    def setUITblNames(self):
        """Set further table names when photos table selected"""
        pt=self.cbTable.currentText()
        if pt.startswith('photos_'):
            tn=pt[7:]
        else:
            tn=pt
        self.leUTable.setText('users_'+tn)
        self.leITable.setText('intervals_'+tn)
    
    def jobFinishedFromThread(self, success):
        self.progressBar.setValue(self.progressBar.maximum())
        self.WT.stop()

    def setTotal(self, total):
        self.progressBar.setMaximum(total)
        
    def setProgress(self, p):
        self.progressBar.setValue(p)
        
    def message(self, title, text, error=False):
        if error:
            QMessageBox.warning(self, title, text)
        else:
            QMessageBox.information(self, title, text)

class WorkerThread(QThread):
    # signals
    jobFinished=pyqtSignal(bool)
    setTotal=pyqtSignal(int)
    setProgress=pyqtSignal(int)
    message=pyqtSignal(str, str, bool)
    
    def __init__( self, parentThread, params):
        QThread.__init__( self, parentThread )
        self.params=params

    def run( self ):
        self.running = True
        success = self.doWork(**self.params)
        #if success:
        #    QMessageBox.information(self,"Status","Finished :)");        
        self.jobFinished.emit(success)
        
    def stop( self ):
        self.running = False
        pass
        
    def doWork( self, dbFile,pt,ut,it,ivth,shortMax,longMin,localMin,localILength ):
        """Fill users and intervals table"""       
        # number of days between dates
        def ddiff(d2,d1):
            dd1=datetime.strptime(d1,"%Y-%m-%d").date()
            dd2=datetime.strptime(d2,"%Y-%m-%d").date()
            return (dd2-dd1).days;
        
        #print("table names:", pt, ut, it)
        # set progress bar to 0
        self.setProgress.emit(0)
        QApplication.processEvents()
        # connect DB
        try:
            con=qgis.utils.spatialite_connect(dbFile)
            cur=con.cursor()
            # create user table
            cur.execute("drop table if exists "+ut)
            cur.execute("create table "+ut+" as select o_id, 0 as is_local, count(*) as photocount from "+pt+" group by 1 order by 2 desc")
            # create intervals
            cur.execute("drop table if exists "+it)
            cur.execute("create table "+it+" (o_id integer, ord integer, d1 text, d2 text, type text)")
            cur.execute("create index o_id_index on "+it+" (o_id)")
            print("tables created");
            cur.execute("select count(distinct o_id||'_'||date(p_date)) as cnt from "+pt+" where substring(p_date,1,4)!='0000'")
            pp=cur.fetchone()
            pcount=pp[0]
            print(pcount, 'distinct (user, date) pairs')
            cur2=con.cursor() # we need another cursor because interval table inserts are done parallelly with select result processing
            cur2.execute("select distinct o_id, date(p_date) from "+pt+" where substring(p_date,1,4)!='0000' order by 1,2")
            values=""
            self.setTotal.emit(pcount)
            
            cnt=0
            ivcnt=0
            p=cur2.fetchone()
            cnt+=1
            if p is None:
                # empty table...
                return False
            oid,d1=p
            d2=d1
            n=0
            while p is not None:
                if (ddiff(p[1],d2)>ivth) or (oid!=p[0]):
                    # new interval begins, store the previous
                    if ddiff(d2,d1)<shortMax:
                        itype="short"
                    elif ddiff(d2,d1)<longMin-1:
                        itype="medium"
                    else:
                        itype="long"
                    if values!="":
                        values+=","
                    values="('"+oid+"',"+str(n)+",'"+d1+"','"+d2+"','"+itype+"')"
                    cur.execute("insert into "+it+" (o_id,ord,d1,d2,type) values "+values)
                    ivcnt+=1
                    if (oid==p[0]):
                        n+=1
                    else:
                        n=0
                    oid,d1=p
                    d2=d1
                else:
                    d2=p[1]
                p=cur2.fetchone()
                cnt+=1
                if cnt%100==0:
                    # updating progress bar at every 100th user/date pair
                    self.setProgress.emit(cnt)
                    QApplication.processEvents()
                    
            # print(ivcnt, 'intervals created')
            # store last interval
            if ddiff(d2,d1)<shortMax:
                itype="short"
            elif ddiff(d2,d1)<longMin-1:
                itype="medium"
            else:
                itype="long"
            if values!="":
                values+=","
            # former: values+="('"+oid+"',"+str(n)+",'"+d1+"','"+d2+"','"+itype+"')"
            values="('"+oid+"',"+str(n)+",'"+d1+"','"+d2+"','"+itype+"')"
            cur.execute("insert into "+it+" (o_id,ord,d1,d2,type) values "+values)
            # commit intervals
            con.commit()
            print("intervals committed")
            # set local users
            cur.execute("update "+ut+" set is_local=1 where o_id in (select distinct o_id from "+it+" where ord>="+str(localMin)+" or julianday(d2)-julianday(d1)>="+str(localILength-1)+")")
            con.commit()
            print("users local status updated")
            # set local intervals
            cur.execute("update "+it+" set type='local' where o_id in (select o_id from "+ut+" where is_local)")
            con.commit()
            print("intervals local status updated")
            # create ivtype column if not exists
            cur.execute("select 1 from pragma_table_info('"+pt+"') where name='ivtype'")
            if cur.fetchone() is None:
                cur.execute("alter table "+pt+" add column ivtype text;")
            # set iv type for photos
            cur.execute("update "+pt+" set ivtype=(select type from "+it+" i where i.o_id="+pt+".o_id and date(p_date) between date(d1) and date(d2))")
            # final commit
            con.commit()
            print("photos local status updated")
            self.message.emit("Job finished", "Intervals created, photos status updated", False)
        except Exception as e:
            self.message.emit("Error", str(e), True)
            return False
        return True
            
        
    def cleanUp( self):
        pass