# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UserAndIvDialog
                                 A QGIS plugin
 This plugin helps downloading metadata of geotagged Flickr photos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-06-04
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Mátyás Gede
        email                : saman@map.elte.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import qgis.utils

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import QAction, QMessageBox, QWidget
from PyQt5.QtCore import *
from PyQt5 import QtSql
from PyQt5.QtSql import *
from datetime import date,datetime

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'user_and_iv_dialog_base.ui'))


class UserAndIvDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(UserAndIvDialog, self).__init__(parent)
        # Set up the user interface from Designer.
        self.setupUi(self)
        self.fwDBFile.setFilter("SQLite files (*.sqlite)")
        # event handlers
        self.fwDBFile.fileChanged.connect(self.getTblNames) # DB file selected
        self.cbTable.currentIndexChanged.connect(self.setUITblNames) # auto set user and interval table names
        self.pbCreate.clicked.connect(self.createTables) # Create button
        self.pbClose.clicked.connect(self.close) # Close button
        self.WT=None
      
    def createTables(self):
        """Create user and interval tables and populate them"""
        # number of days between dates
        def ddiff(d2,d1):
            dd1=datetime.strptime(d1,"%Y-%m-%d").date()
            dd2=datetime.strptime(d2,"%Y-%m-%d").date()
            return (dd2-dd1).days;
        params={}
        params['dbFile']=self.fwDBFile.filePath()
        params['pt']=self.cbTable.currentText()
        params['ut']=self.leUTable.text()
        params['it']=self.leITable.text()
        params['ivth']=int(self.leITreshold.text())
        params['shortMax']=int(self.leShortMax.text())
        params['longMin']=int(self.leLongMin.text())
        params['localMin']=int(self.leLocalMin.text())
        params['localILength']=int(self.leLocalILength.text())
        
        # create and start thread
        self.WT=WorkerThread(qgis.utils.iface.mainWindow(), params)
        self.WT.jobFinished.connect(self.jobFinishedFromThread)
        #self.WT.setTotal.connect(self.setTotal)
        #self.WT.setProgress.connect(self.setProgress)
        self.WT.start()
        
        
    def close(self):
        """Close dialog"""
        if self.WT is not None:
            self.WT.stop()
        self.reject()
    
    def getTblNames(self):
        """DB file selected, read table names"""
        dbFile=self.fwDBFile.filePath()
        con=qgis.utils.spatialite_connect(dbFile)
        cur=con.cursor()
        # read spatialite tables
        cur.execute("select f_table_name from geometry_columns where geometry_type=1;")
        ts=cur.fetchall()
        # populate table selector combobox
        self.cbTable.clear()
        for t in ts:
            self.cbTable.addItem(t[0])
    def setUITblNames(self):
        pt=self.cbTable.currentText()
        if pt.startswith('photos_'):
            tn=pt[7:]
        else:
            tn=pt
        self.leUTable.setText('users_'+tn)
        self.leITable.setText('intervals_'+tn)
    
    def jobFinishedFromThread( self, success ):
        self.progressBar.setValue(self.progressBar.maximum())
        self.WT.stop()

    def setTotal( self, total ):
        self.progressBar.setMaximum(total)
        
    def setProgress( self, p ):
        self.progressBar.setValue(p)

class WorkerThread( QThread ):
    # signals
    jobFinished=pyqtSignal(bool)
    setTotal=pyqtSignal(int)
    setProgress=pyqtSignal(int)
    
    def __init__( self, parentThread, params):
        QThread.__init__( self, parentThread )
        self.params=params

    def run( self ):
        self.running = True
        success = self.doWork(**self.params)
        #if success:
        #    QMessageBox.information(self,"Status","Finished :)");        
        self.jobFinished.emit(success)
        
    def stop( self ):
        self.running = False
        pass
        
    def doWork( self, dbFile,pt,ut,it,ivth,shortMax,longMin,localMin,localILength ):
        """Fill users and intervals table"""       
        # number of days between dates
        def ddiff(d2,d1):
            dd1=datetime.strptime(d1,"%Y-%m-%d").date()
            dd2=datetime.strptime(d2,"%Y-%m-%d").date()
            return (dd2-dd1).days;
        
        # set progress bar to 0
        self.setProgress.emit(0)
        # connect DB
        con=qgis.utils.spatialite_connect(dbFile)
        cur=con.cursor()
        # create user table
        cur.execute("drop table if exists "+ut)
        #QMessageBox.information(self,"Status",'user table dropped');
        cur.execute("create table "+ut+" as select o_id, 0 as is_local, count(*) as photocount from "+pt+" group by 1 order by 2 desc")
        #QMessageBox.information(self,"Status",'user table created');
        # create intervals
        cur.execute("drop table if exists "+it)
        #QMessageBox.information(self,"Status",'iv table dropped');
        cur.execute("create table "+it+" (o_id integer, ord integer, d1 text, d2 text, type text)")
        #QMessageBox.information(self,"Status",'iv table created');
        cur.execute("select distinct o_id, date(p_date) from "+pt+" order by 1,2")
        values=""
        self.setTotal.emit(cur.rowcount)
        cnt=0
        p=cur.fetchone()
        cnt+=1
        if p is None:
            # empty table...
            return False
        oid,d1=p
        d2=d1
        n=0
        while p is not None:
            if (ddiff(p[1],d2)>ivth) or (oid!=p[0]):
                # new interval begins, store the previous
                if ddiff(d2,d1)<shortMax:
                    itype="short"
                elif ddiff(d2,d1)<longMin-1:
                    itype="medium"
                else:
                    itype="long"
                if values!="":
                    values+=","
                values+="('"+oid+"',"+str(n)+",'"+d1+"','"+d2+"','"+itype+"')"
                if (oid==p[0]):
                    n+=1
                else:
                    #print(oid+": "+str(n))
                    n=0
                oid,d1=p
                d2=d1
                self.setProgress.emit(cnt)
            else:
                d2=p[1]
            p=cur.fetchone()
            cnt+=1
        # store last interval
        if ddiff(d2,d1)<shortMax:
            itype="short"
        elif ddiff(d2,d1)<longMin-1:
            itype="medium"
        else:
            itype="long"
        if values!="":
            values+=","
        values+="('"+oid+"',"+str(n)+",'"+d1+"','"+d2+"','"+itype+"')"
        cur.execute("insert into "+it+" (o_id,ord,d1,d2,type) values "+values)
        # set local users
        cur.execute("update "+ut+" set is_local=1 where o_id in (select distinct o_id from "+it+" where ord>="+str(localMin)+" or julianday(d2)-julianday(d1)>="+str(localILength-1)+")")
        # set local intervals
        cur.execute("update "+it+" set type='local' where o_id in (select o_id from "+ut+" where is_local)")
        # create ivtype column if not exists
        cur.execute("select 1 from pragma_table_info('"+pt+"') where name='ivtype'")
        if cur.fetchone() is None:
            cur.execute("alter table "+pt+" add column ivtype text;")
        # set iv type for photos
        cur.execute("update "+pt+" set ivtype=(select type from "+it+" i where i.o_id="+pt+".o_id and date(p_date) between date(d1) and date(d2))")
        # final commit
        con.commit()  
        return True
            
        
    def cleanUp( self):
        pass