# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FlexgisQGISDialog
                                 A QGIS plugin
 Manage your FlexGIS data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-08-06
        git sha              : $Format:%H$
        copyright            : (C) 2023 by FlexGIS
        email                : info@flexgis.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt import QtCore
from qgis.PyQt import QtWidgets
from PyQt5.QtGui import QPixmap, QIcon
from qgis.PyQt.QtWidgets import (
    QLabel
)

from PyQt5.QtSvg import QSvgRenderer
from PyQt5.QtGui import QPainter

from PyQt5.QtCore import QRectF

from ..constants import (
    AUTH_STYLE
)


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
root_path = Path(__file__).parents[1]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    root_path, 'ui', 'flexgis_dialog_base.ui'))


class FlexgisQGISDialog(QtWidgets.QDialog, FORM_CLASS):
    
    BANNER_WIDTH_PIXELS = 541
    BANNER_HEIGHT_PIXELS = 282 
    
    def __init__(self, parent=None):
        """Constructor."""
        super(FlexgisQGISDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        #self.setStyleSheet('background-color: #ececec;')
        #print(__file__)
        # self.setWindowFlags(Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        # иконка окна плагина (на маке не работает)
        root_path = Path(__file__).parents[1]
        imgPath_logo_mini = os.path.join(
            root_path,
            'icons',
            'icon.png',
            )
        icon = QIcon()
        wtPixmap = QPixmap(imgPath_logo_mini)
        icon.addPixmap(wtPixmap)
        self.setWindowIcon(icon)

        self.setStyleSheet(AUTH_STYLE)

        self.setupUi(self)
        
        self.png_path = os.path.join(root_path, 'icons', 'background.png')
        
        self.svg_path2 = os.path.join(root_path, 'icons', 'flexgis.svg')
        self.svg_renderer2 = QSvgRenderer(self.svg_path2)
        
        
    def paintEvent(self, event):
        super().paintEvent(event)
        try:
            painter = QPainter(self)
            painter.setRenderHint(QPainter.Antialiasing, True)                
            if os.path.exists(self.png_path):
                png_pixmap = QPixmap(self.png_path)
                if not png_pixmap.isNull():
                    scaled_pixmap = png_pixmap.scaled(
                        541,
                        282,
                        QtCore.Qt.KeepAspectRatioByExpanding,
                        QtCore.Qt.SmoothTransformation
                    )
                    painter.drawPixmap(0, 0, scaled_pixmap)                 
            if self.svg_renderer2.isValid():
                rect_f2 = QRectF(self.rect())
                self.svg_renderer2.render(painter, rect_f2)
        except Exception as e:
            print(f"Ошибка при отрисовке SVG: {e}")
        finally:
            painter.end()
