# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FlexgisQGISDialog
                                 A QGIS plugin
 Manage your FlexGIS data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-08-06
        git sha              : $Format:%H$
        copyright            : (C) 2023 by FlexGIS
        email                : info@flexgis.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtGui import QPixmap, QIcon
from qgis.PyQt.QtWidgets import (
    QLabel
)

from ..constants import (
    AUTH_STYLE
)


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
root_path = Path(__file__).parents[1]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    root_path, 'ui', 'flexgis_dialog_base.ui'))


class FlexgisQGISDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(FlexgisQGISDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        #self.setStyleSheet('background-color: #ececec;')
        #print(__file__)
        # self.setWindowFlags(Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        # иконка окна плагина (на маке не работает)
        root_path = Path(__file__).parents[1]
        imgPath_logo_mini = os.path.join(
            root_path,
            'icons',
            'icon.png',
            )
        icon = QIcon()
        wtPixmap = QPixmap(imgPath_logo_mini)
        icon.addPixmap(wtPixmap)
        self.setWindowIcon(icon)

        imgPath_banner = os.path.join(
            root_path,
            'icons',
            'header_banner.jpeg',
            )
        self.pixmap_banner = QPixmap(imgPath_banner)
        
        self.label_banner = QLabel(self)
        self.label_banner.setPixmap(self.pixmap_banner)
        self.label_banner.resize(self.pixmap_banner.width(),
                          self.pixmap_banner.height())
        self.label_banner.move(0, -10)

        imgPath_logo = os.path.join(
            root_path,
            'icons',
            'logo.png',
            )
        self.pixmap_logo = QPixmap(imgPath_logo)
        
        self.label_logo = QLabel(self)
        self.label_logo.setPixmap(self.pixmap_logo)
        self.label_logo.resize(self.pixmap_logo.width(),
                          self.pixmap_logo.height())
        self.label_logo.move(-20, -20)
        # self.label.setStyleSheet("font-size: 72px;font-weight:bold; color:black; background-color:rgba(0,0,0,.0)")
        self.label_logo.setStyleSheet("background-color:rgba(0,0,0,.0)")
        # print(AUTH_STYLE)
        self.setStyleSheet(AUTH_STYLE)
        
        self.setupUi(self)
