# firehunter

Этот плагин QGIS предназначен для создания мозаик Sentinel-2 для области, заданной прямоугольным выделением.
Мозаики строятся по заданному интервалу дат и записываются в отдельные слои с именем, включающим начальную и конечную дату построения мозаики.
Кроме того плагин позволяет создать отдельные слои со снимками Sentinel-2 за даты, попавшие в указанный интервал.

Плагин устанавливается в меню Plugins и создает три кнопки на панели инструментов и четыре пункта в меню "Plugins -> Fire Hunter".

В состав плагина входят следующие инструменты:
Authenticate GEE
Make a Sentinel-2 mosaic (parameter set I)
Make a Sentinel-2 mosaic (parameter set II)
Get a Sentinel-hub link

1. Authenticate GEE

Инструмент используется один раз для аутентификации QGIS в Google Earth Engine. После запуска инструмента появится окно ввода ключа аутентификации и произойдет открытие в браузере по умолчанию страницы получения аутентификационной информации Google Earth Engine. Полученный на странице ключ необходимо ввести в окно ввода.
Признаком успешной аутентификации служит появление информационного сообщения вверху области карты с сообщением "Authentication process completed successfully.".


2. Make a Sentinel-2 mosaic (parameter set I)

Для начала работы с инструментом необходимо нажать кнопку (или воспользоваться меню) и курсором выделить на карте прямоугольную область.

В появившемся окне "Get Sentinel-2 images" необходимо задать интервал дат для формирования мозаики. 
Интервал может быть задан двумя способами:
- В поле "Date (last date for mosaic)" указать конечную дату интервала, а в полях "Interval before (days before "Date")" и "Interval after (days after "Date")" указать количество дней до и после заданной даты соответственно.
- Определить даты интервала, основываясь на датах термоточек, попавших в выделенную область. Для этого нужно отметить пункт "Get dates interval from points layer" и в поле "Points layer" указать слой, из которого будут взяты термоточки. Начальная и конечная даты интервала будут определены, с учетом полей "Interval before (days before "Date")" и "Interval after (days after "Date")", по дате появления первой и последней термоточек. Если в слое будут выделенные точки, то будет доступен для отметки пункт "Selected features only", который позволит определять дату, основываясь только на отмеченных точках. (Внимание! При этом способе дата в поле "Date (last date for mosaic)" меняться не будет!)

Для того, чтобы кроме слоя мозаики были созданы  дополнительные слои за отдельные даты, необходимо отметить пункт "Generate single-date layers".
В имени каждого слоя будет присутствовать дата, за которую он создан.
Для создания композитного слоя необходимо отметить пункт "Generate composite layer".
Пункты "Generate composite layer for previous year" и "Generate composite layer for following year" используются, чтобы добавить к набору слоев композитные слои за те же даты, но на год раньше и на год позже выбранного года соответственно.

По умолчанию имя слоя формируется как S2SRC_YYYY-MM-DD, однако можно добавить к имени слоя префикс, указав его в поле "Layer prefix". Все создаваемые слои помещаются в группу "S2SRC"

Плагин также позволяет настраивать комбинацию каналов для отображения. По умолчанию стоит вариант "Произвольная комбинация каналов" (Custom), при которой в полях "Band1 (red)", "Band2 (green)", "Band3 (blue)" могут быть выбраны произвольные каналы. Также можно выбрать стандартные варианты комбинаций: True color', 'False color', 'False color (urban)', 'SWIR'.

Кроме настройки комбинации каналов для формирования мозаики может быть включены или выключены фильтры облачности для одиночных и композитных слоев (пункты "Apply cloud filter for singlelayers" и "Apply cloud filter for composite layers"), при этом может быть задан порог облачности, определяющий использование точек снимков для формирования мозаики (поля "Cloudness for singlelayers" и "Cloudness for composite layers").

Параметр "Make result layer visible" определяет будут или нет отображаться созданные слои.

После нажатия кнопки "Run" плагин выполнит формирование слоев. Признаком завершения работы плагина будет появление на экране сообщения "Loading resulting layers
Algorithm 'Get Sentinel2 images' finished".

Плагин использует в своей работе Google Earth Engine и источник COPERNICUS/S2. 
Для использования плагина должен быть установлен плагин QGIS Google Earth Engine и зарегистрирована ваша учетная запись в Google Earth Engine.


3. Make a Sentinel-2 mosaic (parameter set II)

Инструмент аналогичен инструменту Make a Sentinel-2 mosaic (parameter set I), но использует другой набор параметров по умолчанию.
Параметры по умолчанию для инструментов могут быть изменены в файле настроек firehunter.ini в каталоге плагина.


4. Get a Sentinel-hub link

Для начала работы с инструментом необходимо нажать кнопку (или воспользоваться меню) и курсором отметить на карте точку.
В результате работы будет сформирована ссылка на https://apps.sentinel-hub.com/eo-browser/, которая отобразит снимок в комбинации каналов SWIR с центром в точке, указанной курсором и увеличением (zoom) 13.
