# -*- coding: utf-8 -*-
"""
/***************************************************************************
 finding_laylines
                                 A QGIS plugin
 This Plugin finds the surface water flow path on a field.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-19
        git sha              : $Format:%H$
        copyright            : (C) 2021 by FALASY Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import errno
import os.path
import sys
import csv

from qgis.PyQt.QtCore import *
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import *
from qgis.PyQt.QtWidgets import QAction
from qgis.core import *
from qgis.core import QgsProject, QgsProcessingException, Qgis
from qgis.utils import *

from qgis import processing
import os

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .finding_laylines_dialog import finding_laylinesDialog
import os.path


class finding_laylines:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'finding_laylines_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
            
        # Create the dialog (after translation) and keep reference
        self.dlg = finding_laylinesDialog()
        
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&finding_laylines')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'finding_laylines')
        self.toolbar.setObjectName(u'finding_laylines')

        self.dlg.lineEdit.clear()
        self.initFolder();
        self.dlg.pushButton.clicked.connect(self.selectOutputFile);
       
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('finding_laylines', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/finding_laylines/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'This Plugin finds the surface water flow path on a field.'),
            callback=self.run,
            parent=self.iface.mainWindow())
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&finding_laylines'),
                action)
            self.iface.removeToolBarIcon(action)

    def initFolder(self):
        path_project = QgsProject.instance().fileName()
        path_project = path_project[:path_project.rfind("/"):]

        self.folderName = path_project

        self.dlg.lineEdit.setText(self.folderName);

    def selectOutputFile(self):
        folderTmp = QFileDialog.getExistingDirectory(self.dlg,
                                                     self.tr("Select output folder "), self.folderName)

        if folderTmp != "":
            self.folderName = folderTmp

        self.dlg.lineEdit.setText(self.folderName);

    def isFileOpened(self, file_path):
        if os.path.exists(file_path):
            try:
                os.rename(file_path, file_path + "_")
                os.rename(file_path + "_", file_path)
                return False
            except OSError as e:
                return True
                
    def run(self):
        """Run method that performs all the real work"""

        self.dlg.comboBox.clear()
        layers = QgsProject.instance().mapLayers().values()
        # fill selection combo, only polygon layers
        n = 0
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer and \
                    layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                self.dlg.comboBox.addItem(layer.name(), layer)
                n += 1

        if n == 0:  # no polygon layer
            iface.messageBar().pushMessage(self.tr("Warning"),
                                           self.tr("No polygon layer in actual project"),
                                           level=Qgis.Warning)
            return
                               
                       
        # self.dlg.comboBox_2.clear()
        # layers = QgsProject.instance().mapLayers().values()
        # # fill selection combo, only polygon layers
        # n = 0
        # for layer in layers:
            # if layer.type() == QgsMapLayer.RasterLayer:
                # self.dlg.comboBox_2.addItem(layer.name(), layer)
                # n += 1

        # if n == 0:  # no Raster layer
            # iface.messageBar().pushMessage(self.tr("Warning"),
                                           # self.tr("No Raster layer in actual project"),
                                           # level=Qgis.Warning)
            # return
            
        self.dlg.comboBox_2.clear()
        # layers = QgsProject.instance().layerTreeRoot().children()
        layers = QgsProject.instance().mapLayers().values()
        layer_list = []
        n = 0
        for layer in layers:
            if layer.type() == QgsMapLayer.RasterLayer:
                layer_list.append(layer.name())
                # self.dlg.comboBox_2.addItem(layer.name(), layer)
                self.dlg.comboBox_2.addItems(layer_list)
                n += 1

        # self.dlg.comboBox_2.addItems(layer_list)
        # n += 1

        if n == 0:  # no Raster layer
            iface.messageBar().pushMessage(self.tr("Warning"),
                                           self.tr("No Raster layer in actual project"),
                                           level=Qgis.Warning)
            return
            
        # show the dialog
        self.dlg.show()
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            dirName = self.dlg.lineEdit.text().strip()
            if len(dirName) == 0:
                iface.messageBar().pushMessage(self.tr("Warning"),
                                               self.tr("Please select target folder"), level=Qgis.Warning)
                return
            if not (
            self.dlg.checkBox.isChecked(), self.dlg.radioButton_fill.isChecked(), self.dlg.radioButton_unfill.isChecked(), self.dlg.radioButton_both.isChecked()):
                # self.dlg.checkRaster.isChecked()):
                iface.messageBar().pushMessage(self.tr("Warning"),
                                               self.tr(
                                                   "Neither vector nor raster layers selected for clipping. Nothing to do. "),
                                               level=Qgis.Warning)
                return

            index = self.dlg.comboBox.currentIndex()
            selection = self.dlg.comboBox.itemData(index) # boundary layer
            
            index = self.dlg.comboBox_2.currentIndex()
            selection2 = self.dlg.comboBox_2.itemData(index) # DEM layer
                                    
            checkedLayers = QgsProject.instance().layerTreeRoot().checkedLayers()

            # search existence of output folder, if not create it
            if not os.path.isdir(self.folderName):
                raise FileNotFoundError(
                    errno.ENOENT, os.strerror(errno.ENOENT), self.folderName)
            
                   
            directory = self.folderName + "/Filled"
            if not os.path.exists(directory) and self.dlg.radioButton_fill.isChecked():
                os.makedirs(directory)
                
            directory = self.folderName + "/Unfilled"
            if not os.path.exists(directory) and self.dlg.radioButton_unfill.isChecked():
                os.makedirs(directory)
                                          
                                        
            directory = self.folderName + "/Both"
            if not os.path.exists(directory) and self.dlg.radioButton_both.isChecked():
                os.makedirs(directory)
                
            # Progress bar
            progressMessageBar = iface.messageBar().createMessage(self.tr("Plotting Field LayLines..."))
            progress = QProgressBar()
            progress.setMaximum(len(checkedLayers) - 1)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            progression = 0
            
            # Analyses part
            for layer in checkedLayers:
                # out = None
                # clip raster layer (if displayed and checked)
                if layer.type() == QgsMapLayer.RasterLayer and layer != selection2 and self.dlg.radioButton_fill.isChecked():
                                       
                    # get extension about the raster
                    filename, file_extension = os.path.splitext(layer.source())

                    output1 = self.folderName + "/Unfilled/clip_" + layer.name() + file_extension
                    
                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output1):
                        output1 = self.folderName + "/Unfilled/clip_" + layer.name() + "(" + str(version) + ")" + file_extension
                        version += 1
                                            
                    processing.run("gdal:cliprasterbymasklayer", {"INPUT": layer.id(), "MASK": selection.id(), "CROP_TO_CUTLINE": True, "OUTPUT": output1})
                                                                                                                                                                                                         
                                                                                                                                                                                                   
                                    
                    output2 = self.folderName + "/Unfilled/netwk_" + layer.name() + file_extension
                    output3 = self.folderName + "/Unfilled/route_" + layer.name() + file_extension
                    output4 = self.folderName + "/Unfilled/Unfilled_Laylines_" + layer.name() + ".shp"
                    
                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output4):
                        output4 = self.folderName + "/Unfilled/Unfilled_Laylines_" + layer.name() + "(" + str(version) + ").shp"
                        version += 1
                                                                                                                               
                                                                                                                                                            
                    processing.run('saga:channelnetwork', {"ELEVATION": output1, "INIT_GRID": output1, "INIT_METHOD": 2, "INIT_VALUE": 0, "DIV_CELLS": 10, "MINLEN": 10,
                                    "CHNLNTWRK": output2, "CHNLROUTE": output3, "SHAPES": output4}) 
                                                                                                                        
                                                          
                    # # Execution Status Report
                    self.iface.messageBar().pushMessage( "Success", "Output file written and loaded at " + output4, level=Qgis.Success, duration=3 )
                    
                    # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output4, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output4, level=Qgis.Warning) 
                
                # Update progression
                time.sleep(1)
                progress.setValue(progression + 1)
                progression += 1

            iface.messageBar().clearWidgets()            
            
                           
            for layer in checkedLayers:              
                # out = None            
                            # clip raster layer (if displayed and checked)
                if layer.type() == QgsMapLayer.RasterLayer and layer != selection2 and self.dlg.radioButton_unfill.isChecked():
                                                                                
                    newint = self.dlg.doubleSpinBox_2.value()
                                        
                    # # get extension about the raster
                    filename, file_extension = os.path.splitext(layer.source())
                    
                    output5 = self.folderName + "/Filled/clip_" + layer.name() + file_extension
                    output6 = self.folderName + "/Filled/rasSAGA_" + layer.name() + ".sdat"
                    # output7 = self.folderName + "/Filled/Trans_" + layer.name() + file_extension
                    output8 = self.folderName + "/Filled/Filled_Contour_" + layer.name() + ".shp"
                    output9 = self.folderName + "/Filled/netwk_" + layer.name() + file_extension
                    output10 = self.folderName + "/Filled/route_" + layer.name() + file_extension
                    output11 = self.folderName + "/Filled/Filled_Laylines_" + layer.name() + ".shp"
                                                                                
                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output5):
                        output5 = self.folderName + "/Filled/clip_" + layer.name() + "(" + str(version) + ")" + file_extension
                        version += 1
                        
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output6):
                        output6 = self.folderName + "/Filled/rasSAGA_" + layer.name() + "(" + str(
                            version) + ").sdat"
                        version += 1
                                                                                                         
                                                            
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output8):
                        output8 = self.folderName + "/Filled/Filled_Contour_" + layer.name() + "(" + str(
                            version) + ").shp"
                        version += 1
                                                      
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output11):
                        output11 = self.folderName + "/Filled/Filled_Laylines_" + layer.name() + "(" + str(
                            version) + ").shp"
                        version += 1
                                                                                          
                                        
                    processing.run("gdal:cliprasterbymasklayer", {"INPUT": layer.id(), "MASK": selection.id(), "CROP_TO_CUTLINE": True, "OUTPUT": output5})
                                                                                                                                                     
                    processing.run('saga:fillsinks', {"DEM": output5, "MINSLOPE": 0.01, "RESULT": output6})
                                                               
                                                                                                                     
                    processing.run("gdal:contour", {"INPUT": output6, "BAND": 1, "INTERVAL": newint, "FIELD_NAME": 'ELEV', "OUTPUT": output8})
                                                                                                                                      
                     # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output8, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output8, level=Qgis.Warning)
                                                           
                    processing.run('saga:channelnetwork',
                                   {"ELEVATION": output6, "INIT_GRID": output6, "INIT_METHOD": 2, "INIT_VALUE": 0, "DIV_CELLS": 10, "MINLEN": 10,
                                    "CHNLNTWRK": output9, "CHNLROUTE": output10, "SHAPES": output11}) 
                                                                       
                                        
                    # # Execution Status Report
                    self.iface.messageBar().pushMessage("Success", "Output file written and loaded at " + output11, level=Qgis.Success, duration=3)
                                                            
                    # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output11, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output11, level=Qgis.Warning)
              
                # Update progression
                time.sleep(1)
                progress.setValue(progression + 1)
                progression += 1

            iface.messageBar().clearWidgets()
            
            for layer in checkedLayers:
                # out = None
                # clip raster layer (if displayed and checked)
                if layer.type() == QgsMapLayer.RasterLayer and layer != selection2 and self.dlg.radioButton_both.isChecked():
                                       
                    newint = self.dlg.doubleSpinBox_2.value()
                                        
                    # get extension about the raster
                    filename, file_extension = os.path.splitext(layer.source())

                    output1 = self.folderName + "/Both/clip_" + layer.name() + file_extension
                    output2 = self.folderName + "/Both/netwk_" + layer.name() + file_extension
                    output3 = self.folderName + "/Both/route_" + layer.name() + file_extension
                    output4 = self.folderName + "/Both/Unfilled_Laylines_" + layer.name() + ".shp"
                    output5 = self.folderName + "/Both/clip_" + layer.name() + file_extension
                    output6 = self.folderName + "/Both/rasSAGA_" + layer.name() + ".sdat"
                    # output7 = self.folderName + "/Unfilled/Trans_" + layer.name() + file_extension
                    output8 = self.folderName + "/Both/Filled_Contour_" + layer.name() + ".shp"
                    output9 = self.folderName + "/Both/netwk2_" + layer.name() + file_extension
                    output10 = self.folderName + "/Both/route2_" + layer.name() + file_extension
                    output11 = self.folderName + "/Both/Filled_Laylines_" + layer.name() + ".shp"

                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output1):
                        output1 = self.folderName + "/Both/clip_" + layer.name() + "(" + str(version) + ")" + file_extension
                        version += 1

                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output4):
                        output4 = self.folderName + "/Both/Unfilled_Laylines_" + layer.name() + "(" + str(version) + ").shp"
                        version += 1
                        
                    # check file isn't openned and is writable
                    version = 0
                    while self.isFileOpened(output5):
                        output5 = self.folderName + "/Both/clip_" + layer.name() + "(" + str(version) + ")" + file_extension
                        version += 1
                        
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output6):
                        output6 = self.folderName + "/Both/rasSAGA_" + layer.name() + "(" + str(
                            version) + ").sdat"
                        version += 1
                        
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output8):
                        output8 = self.folderName + "/Both/Filled_Contour_" + layer.name() + "(" + str(
                            version) + ").shp"
                        version += 1
                                                      
                    # check file isn't opened and is writable
                    version = 0
                    while self.isFileOpened(output11):
                        output11 = self.folderName + "/Both/Filled_Laylines_" + layer.name() + "(" + str(
                            version) + ").shp"
                        version += 1
                        
                    processing.run("gdal:cliprasterbymasklayer", {"INPUT": layer.id(), "MASK": selection.id(), "CROP_TO_CUTLINE": True, "OUTPUT": output1})
                                                                                                                                                                                                         
                                                                                                                                                                                                      
                    processing.run('saga:channelnetwork', {"ELEVATION": output1, "INIT_GRID": output1, "INIT_METHOD": 2, "INIT_VALUE": 0, "DIV_CELLS": 10, "MINLEN": 10,
                                    "CHNLNTWRK": output2, "CHNLROUTE": output3, "SHAPES": output4}) 
                                                                                                                        
                                                         
                    processing.run("gdal:cliprasterbymasklayer", {"INPUT": layer.id(), "MASK": selection.id(), "CROP_TO_CUTLINE": True, "OUTPUT": output5})
                    
                                                                                                                                                     
                    processing.run('saga:fillsinks', {"DEM": output5, "MINSLOPE": 0.01, "RESULT": output6})
                                                                                                                        
                                                                                           
                    processing.run("gdal:contour", {"INPUT": output6, "BAND": 1, "INTERVAL": newint, "FIELD_NAME": 'ELEV', "OUTPUT": output8})
                                                                                                                                      
                                                                               
                    processing.run('saga:channelnetwork',
                                   {"ELEVATION": output6, "INIT_GRID": output6, "INIT_METHOD": 2, "INIT_VALUE": 0, "DIV_CELLS": 10, "MINLEN": 10,
                                    "CHNLNTWRK": output9, "CHNLROUTE": output10, "SHAPES": output11}) 
                                                                       
                                        
                    # # Execution Status Report
                    self.iface.messageBar().pushMessage("Success", "Output file written and loaded at " + output11, level=Qgis.Success, duration=3)
                    
                     # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output4, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output4, level=Qgis.Warning)
                            
                     # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output8, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output8, level=Qgis.Warning)
                            
                    # load layer
                    if self.dlg.checkBox.isChecked():
                        out = iface.addVectorLayer(output11, "", "ogr")
                        if not out:
                            iface.messageBar().pushMessage(self.tr("Error"), self.tr("Could not load ") + output11, level=Qgis.Warning) 
                            
                # Update progression
                time.sleep(1)
                progress.setValue(progression + 1)
                progression += 1

            iface.messageBar().clearWidgets()
   