# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LfbRegenerationWildlifeImpactDialog
                                 A QGIS plugin
 Lfb Regeneration and Wildlife Impact Monitoring
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Grünecho
        email                : support@grunecho.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

import json

from qgis.core import QgsMessageLog
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import QCoreApplication, QSettings, QTranslator
from qgis.PyQt.QtWidgets import QDialog

from PyQt5.uic import loadUi
from PyQt5 import QtCore, QtGui
from qgis.PyQt.QtWidgets import QDialog, QPushButton

from ..layout.flow import FlowLayout

UI_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'chips.ui'))


class Chips(QtWidgets.QWidget, UI_CLASS):
    inputChanged = QtCore.pyqtSignal(int)

    def __init__(self, interface, schema, maxNumber):
        """Constructor."""

        QDialog.__init__(self, interface.mainWindow())

        self.setupUi(self)

        self.schema = schema
        self.buttons = []

        self.flowLayout = FlowLayout(round(maxNumber / 7))

        length = min(len(schema['enum']), maxNumber)
        for i in range(0, length):
            button = QPushButton(str(schema['enumLabels'][i]))
            button.setCheckable(True)
            button.setStyleSheet('''
                QPushButton {   
                    color:white;
                    padding: 3px;
                    border: 2px solid grey;
                    background-color: #ddd;
                    color: black;
                    border-radius: 2px;
                    margin: 3px;
                }
                QPushButton:checked{
                    background-color: rgb(80, 80, 80);
                    border: none;
                    color: white;
                }
                QPushButton:hover{
                    background-color: grey;
                    border-style: outset;
                }
            ''')
            button.setCursor(QtCore.Qt.PointingHandCursor)
            button.clicked.connect(self.selectedChip)
            self.flowLayout.addWidget(button)
            self.buttons.append(button)

        self.setLayout(self.flowLayout)

        self.show()


    def setValue(self, value):
        #buttons = self.flowLayout.children()
        
        
        for i in self.buttons:
            i.setChecked(i.text() == value)

    def selectedChip(self):
        rbt = self.sender()
        rbtText = rbt.text()
        self.setValue(rbtText)
        
        
        index = self.schema['enumLabels'].index(rbtText)
        
        if index != -1:
            self.inputChanged.emit(index)
            
        #self.inputChanged.emit(str(nr))