# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LfbRegenerationWildlifeImpactDialog
                                 A QGIS plugin
 Lfb Regeneration and Wildlife Impact Monitoring
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Grünecho
        email                : support@grunecho.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import uuid
import json
import tempfile

from qgis.core import QgsMessageLog, QgsProject, QgsWkbTypes, QgsVectorFileWriter, QgsFeature, QgsGeometry, QgsPointXY
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtCore import QDateTime

#from PyQt5.uic import loadUi
from PyQt5 import QtCore

from ...utils.helper import Utils

from ..unterlosnr_dialog import UnterlosnrDialog

UI_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'multi_change.ui'))


class MultiChange(QtWidgets.QWidget, UI_CLASS):
    """Implementation of the IoBtn widget."""

    set_unterlosnummer = QtCore.pyqtSignal(str)

    def __init__(self, interface, token=None):
        """Constructor."""

        QDialog.__init__(self, interface.mainWindow())

        self.setupUi(self)

        self.token = token

        #lyr=interface.activeLayer()
        #lyr.selectionChanged.connect(self._show_self)

        #fim_layer = Utils.getLayerById()
        #if fim_layer is not None:
        #    fim_layer.selectionChanged.disconnect()
        #    fim_layer.selectionChanged.connect(self._show_self)

        self.lfb_unterlosnr_btn.clicked.connect(self._open_unterlosnr_dialog)

        self.show_self()

    def update(self, unterlosnr):
        self.set_unterlosnummer.emit(unterlosnr)

    def set_token(self, token):
        self.token = token

    def show_self(self):
        feature_list = Utils.getSelectedFeaturesFim()

        Utils.refreshLayer()

        if len(feature_list) > 0:
            self.lfb_unterlosnr_btn.setText(f'Unterlosnummer an {str(len(feature_list))} Trakten ändern')
            self.show()
            return
        else:
            self.hide()
            return

    def _open_unterlosnr_dialog(self, feature=None):
        '''Open the unterlosnr dialog'''

        if feature is None:
            return
        
        feature_list = Utils.getSelectedFeaturesFim()

        dialog = UnterlosnrDialog(None, feature_list, self.token)

        try:
            dialog.set_unterlosnummer.disconnect()
        except:
            pass
        dialog.set_unterlosnummer.connect(self.update)

        dialog.exec_()