# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FiltreDate
                                 A QGIS plugin
 Filtre une couche avec des champs de date de création et de destruction
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-10
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wendy Laurent (Ville d'Orléans)
        email                : wendy.laurent@orleans-metropole.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QComboBox, QCompleter, QDialog, QVBoxLayout, QSlider
from qgis.core import *
from qgis.gui import *


from qgis.PyQt.QtCore import Qt

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Filtre_Date_dialog import FiltreDateDialog
import os.path




class FiltreDate:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'FiltreDate_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Filtre Palantir')

        self.slider = QgsRangeSlider()


        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        




    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FiltreDate', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Filtre_Date/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Filtre une couche par datation et thématique'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Filtre Palantir'),
                action)
            self.iface.removeToolBarIcon(action)


    
        
    def setup_slider(self):
        """Création du slider double"""
    # Remplace le widget placeholder par le vrai slider

        self.slider.setMinimum(-5500)
        self.slider.setMaximum(2040)
        self.slider.setRange(0, 1000)
        self.slider.setSingleStep(1)
        self.slider.setTickInterval(500)
        self.slider.setTickPosition(QSlider.TicksAbove)


    # Supprime le widget vide de Qt Designer
        layout = QVBoxLayout(self.dlg.doubleslider_2)
        layout.setContentsMargins(0, 0, 0, 0)
        layout.addWidget(self.slider)

    # On connecte les spin box avec les valeurs min et max de départ du slider
        self.min_val = self.slider.lowerValue()
        self.max_val = self.slider.upperValue()
        self.spinbox_min = self.dlg.Date_basse_doubleslider
        self.spinbox_max = self.dlg.Date_haute_doubleslider

        self.spinbox_min.setValue(self.min_val)
        self.spinbox_max.setValue(self.max_val)

    

    def values_changed(self):
        """Modifie le double slider si les valeurs des spin boxs min et max sont changées"""
        
        # Message d'erreur si date min > date max
        if self.spinbox_min.value() > self.spinbox_max.value() :
                self.iface.messageBar().pushMessage("Erreur:", "La date min est supérieure à la date max.",  level=Qgis.Warning, duration=5)
                
        # Message au double slider pour se synchroniser
        self.slider.setRange(self.spinbox_min.value(), self.spinbox_max.value())

    def slider_changed(self, min, max):
        """Modifie les valeurs des spin boxs min et max si le double slider bouge """       
        self.spinbox_min.setValue(min)
        self.spinbox_max.setValue(max)


            

        
    def categorie_affichage (self, layer, champs_theme) :
        """Création de la liste des thèmes à sélectionner"""
        layer.setSubsetString ("")
        field_index = layer.fields().indexOf(champs_theme) #On récupère l'index du champs
        item = layer.uniqueValues(field_index) #On crée une liste avec toutes les valeurs prisent dans le champs

        list_item = [i for i in item if i not in (None, 'NULL', '', False)] #On supprime les valeurs nulles de la liste
        
        self.dlg.mComboBox.clear()  # Vider le combo avant d'ajouter


        
        str_list_item = [str(n) for n in list_item]
        for i in str_list_item :
            self.dlg.mComboBox.addItem(i)

    def on_field_changed(self):
        """Sélection de la couche et du champs sur lequel la liste va être extraite"""
        layer = self.dlg.mMapLayerComboBox.currentLayer()       
        champs_theme = self.dlg.mFieldComboBox_5.currentField ()
        self.categorie_affichage(layer, champs_theme)
    
 
    def on_button_clicked(self):
        """Suppression des filtres existants sur la couche sélectionnée"""
        layer = self.dlg.mMapLayerComboBox.currentLayer() 
        layer.setSubsetString ("")
        layer.triggerRepaint()
        
                
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = FiltreDateDialog()
            self.dlg.mMapLayerComboBox.setAllowEmptyLayer(True)  
            self.dlg.mMapLayerComboBox.setCurrentIndex(-1)
            self.setup_slider() #On appel la fonction pour mettre en place le double slider sur l'interface
            self.dlg.horizontalSlider.setCursor(Qt.OpenHandCursor)  # Curseur "main ouverte" sur le slider simple. Il est générique sur le slider double
            self.dlg.pushButton.clicked.connect(self.run) #Qd on clique sur appliquer, ca appel la fction run

        # show the dialog
        self.dlg.show()

        # Choix de la couche à filtrer. On n'affiche que les couches vecteurs du projet.
        
        self.dlg.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.VectorLayer)    


        #On rempli avec les champs de la couche sélectionnée les différentes combobox
        self.dlg.mFieldComboBox.allowEmptyFieldName()
        self.dlg.mFieldComboBox.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_2.allowEmptyFieldName()
        self.dlg.mFieldComboBox_2.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_3.allowEmptyFieldName()
        self.dlg.mFieldComboBox_3.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_4.allowEmptyFieldName()
        self.dlg.mFieldComboBox_4.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_5.allowEmptyFieldName()
        self.dlg.mFieldComboBox_5.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_6.allowEmptyFieldName()
        self.dlg.mFieldComboBox_6.setAllowEmptyFieldName(True)
        self.dlg.mFieldComboBox_7.allowEmptyFieldName()
        self.dlg.mFieldComboBox_7.setAllowEmptyFieldName(True)
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox.setLayer) #DHC
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_2.setLayer)#DBC
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_3.setLayer)#DHD
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_4.setLayer)#DBD
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_6.setLayer)#date unique de création
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_7.setLayer)#date unique de destruction
        self.dlg.mMapLayerComboBox.layerChanged.connect(self.dlg.mFieldComboBox_5.setLayer)#champs contenant les thématiques

            
        # On crée un signal qui change le slider quand les valeurs des spins boxs changent
        self.spinbox_min.editingFinished.connect(self.values_changed)
        self.spinbox_max.editingFinished.connect(self.values_changed)

        # On crée un signal qui change la valeur des spin box quand le slider bouge
        self.slider.rangeChanged.connect(self.slider_changed)

        #On va créer une liste à partir des entrées présentes dans la couche et le champs choisi pour les thématiques
        self.dlg.mFieldComboBox_5.fieldChanged.connect(self.on_field_changed)

        # Bouton pour remettre à zéro les filtres
        self.dlg.pushButton_2.clicked.connect(self.on_button_clicked)

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            
            #On prend la couche rentrée par l'utilisateur
            #layer = self.dlg.mMapLayerComboBox.currentLayer()
            DHC = self.dlg.mFieldComboBox.currentField()
            DBC = self.dlg.mFieldComboBox_2.currentField()
            DHD = self.dlg.mFieldComboBox_3.currentField()
            DBD = self.dlg.mFieldComboBox_4.currentField()
            DateUniqueCreation = self.dlg.mFieldComboBox_6.currentField()
            DateUniqueDestruction = self.dlg.mFieldComboBox_7.currentField()

            #On garde en mémoire la date entrée par l'utilisateur
            date = self.dlg.spinBox.value()
            date_min = self.spinbox_min.value()
            date_max = self.spinbox_max.value()


            thematique = self.dlg.mComboBox.checkedItems()
            layer = self.dlg.mMapLayerComboBox.currentLayer() 
            champs_theme = self.dlg.mFieldComboBox_5.currentField()

            # Si aucune couhe à filtrer n'est sélectionnée, on ne peut pas accéder au reste
            if layer is None :
                self.iface.messageBar().pushMessage("Erreur:", "Il faut sélectionner une couche à filtrer",  level=Qgis.Warning, duration=5)
                self.dlg.Filtreparperiode.setChecked(False)
                self.dlg.Filtrepardate.setChecked(False)
                self.dlg.DateDouble.setChecked(False)
                self.dlg.DateUnique.setChecked(False)
                return
                
            # Requête prenant en compte la date sur les attributs de la couche ECF

            query = ""
                
            if self.dlg.Filtrepardate.isChecked():
                query = ""

                #Si les champs de datation ne sont pas configurés, on ne peut pas accéder au slider
                if not (self.dlg.DateDouble.isChecked() or self.dlg.DateUnique.isChecked()):
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut configurer les champs de datations pour utiliser le slider.",  level=Qgis.Warning, duration=5)
                    self.dlg.Filtrepardate.setChecked(False)
            
                # On adapte la requête en fonction du groupe coché "date double" ou "date unique" et on vérifie les conditions d'utilisation
                if (self.dlg.DateDouble.isChecked() and DHC and DBC and DHD and DBD) :
                    query += '("{}" <={:d} OR "{}" <={:d}) AND ("{}" >= {:d} OR "{}" >={:d})'.format(DHC,date,DBC,date,DHD,date,DBD,date)
                    
                elif (self.dlg.DateDouble.isChecked() and not (DHC and DBC and DHD and DBD)) :
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner toutes les dates hautes et basses.",  level=Qgis.Warning, duration=5)
                    return
                    
                elif (self.dlg.DateUnique.isChecked() and DateUniqueCreation and DateUniqueDestruction):
                    query = ""
                    query += '("{}" <={:d} AND "{}" >= {:d})'.format(DateUniqueCreation,date,DateUniqueDestruction,date)
                    
                elif (self.dlg.DateUnique.isChecked() and not (DateUniqueCreation and DateUniqueDestruction)):
                      self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner toutes les dates hautes et basses.",  level=Qgis.Warning, duration=5)
                      return

                # Verifier conditions d'utilisation pour la partie thématique
                if (champs_theme and len(thematique)==0) :
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner les thématiques à filtrer ou mettre un champs vide pour 'Champs contenant les thématiques'",  level=Qgis.Warning, duration=10)
                    return
                
                # si les tests passent, on peut faire la requete
                #On rajoute à la requête de base une requête sur les rubriques que l'on veut voir
                if len(thematique) > 0:
                    if len(query) > 0 :
                        query += " AND "
                    query += " ("
                    query += " OR ".join(['("'+champs_theme+'" = '"'"+theme_i+"'"") " for theme_i in thematique])
                    query += ")"
                    
                layer.setSubsetString (query)
                   

            elif self.dlg.Filtreparperiode.isChecked():
                query = ""

                #Si les champs de datation ne sont pas configurés, on ne peut pas accéder au slider
                if not (self.dlg.DateDouble.isChecked() or self.dlg.DateUnique.isChecked()):
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut configurer les champs de datations pour utiliser le slider.",  level=Qgis.Warning, duration=5)
                    self.dlg.Filtreparperiode.setChecked(False)

            
                # On adapte la requête en fonction du groupe coché "date double" ou "date unique"
                if (self.dlg.DateDouble.isChecked() and DHC and DBC and DHD and DBD):
                    query += '("{}" <={:d} OR "{}" <={:d}) AND ("{}" >= {:d} OR "{}" >={:d})'.format(DHC,date_max,DBC,date_max,DHD,date_min,DBD,date_min)
                    
                elif (self.dlg.DateUnique.isChecked() and DateUniqueCreation and DateUniqueDestruction):
                    query += '("{}" <={:d} AND "{}" >= {:d})'.format(DateUniqueCreation,date_max,DateUniqueDestruction,date_min)

                # Message d'erreur si tous les champs ne sont pas renseignés
                elif (self.dlg.DateDouble.isChecked() and not (DHC and DBC and DHD and DBD)) :
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner toutes les dates hautes et basses.",  level=Qgis.Warning, duration=5)
                    return
                                      
                elif (self.dlg.DateUnique.isChecked() and not (DateUniqueCreation and DateUniqueDestruction)):
                      self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner toutes les dates hautes et basses.",  level=Qgis.Warning, duration=5)
                      return
                
                
                # Verifier conditions d'utilisation pour la partie datation
                if (champs_theme and len(thematique)==0) :
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner les thématiques à filtrer ou mettre un champs vide pour 'Champs contenant les thématiques'",  level=Qgis.Warning, duration=10)
                    return
                
                # si les tests passent, on peut faire la requete
                #On rajoute à la requête de base une requête sur les rubriques que l'on veut voir
                if len(thematique) > 0:
                    if len(query) > 0 :
                        query += " AND "
                    query += " ("
                    query += " OR ".join(['("'+champs_theme+'" = '"'"+theme_i+"'"") " for theme_i in thematique])
                    query += ")"
                       
                layer.setSubsetString (query)

            else :
                query = ""

                # Verifier conditions d'utilisation pour la partie datation
                if (champs_theme and len(thematique)==0) :
                    self.iface.messageBar().pushMessage("Erreur:", "Il faut renseigner les thématiques à filtrer ou mettre un champs vide pour 'Champs contenant les thématiques'",  level=Qgis.Warning, duration=10)
                    return
                
                # si les tests passent, on peut faire la requete
                #On rajoute à la requête de base une requête sur les rubriques que l'on veut voir
                if len(thematique) > 0:
                    if len(query) > 0 :
                        query += " AND "
                    query += " ("
                    query += " OR ".join(['("'+champs_theme+'" = '"'"+theme_i+"'"") " for theme_i in thematique])
                    query += ")"
                layer.setSubsetString (query)
        
            

