#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Quick test backend creation in QGIS environment.
Run this in QGIS Python Console to test backend loading.
"""

print("="*80)
print("Testing Backend Creation v4.2.0")
print("="*80)

# Test 1: Import factory
print("\n[TEST 1] Importing BackendFactory...")
try:
    from filter_mate.adapters.backends.factory import BackendFactory
    print("✅ BackendFactory imported")
except Exception as e:
    print(f"❌ Import failed: {e}")
    import traceback
    traceback.print_exc()

# Test 2: Create backends
print("\n[TEST 2] Creating backends via get_backend()...")
try:
    # Create OGR backend
    print("  → Creating OGR backend...")
    ogr_backend = BackendFactory.get_backend('ogr', None, {})
    print(f"  ✅ OGR backend: {type(ogr_backend).__name__}")
    print(f"     - has build_expression: {hasattr(ogr_backend, 'build_expression')}")
    print(f"     - has apply_filter: {hasattr(ogr_backend, 'apply_filter')}")
    
    # Test build_expression
    print("  → Testing OGR build_expression()...")
    expr = ogr_backend.build_expression({}, {})
    print(f"  ✅ OGR expression: '{expr}' (empty is OK for OGR)")
    
except Exception as e:
    print(f"  ❌ OGR failed: {e}")
    import traceback
    traceback.print_exc()

try:
    # Create Spatialite backend
    print("\n  → Creating Spatialite backend...")
    spat_backend = BackendFactory.get_backend('spatialite', None, {})
    print(f"  ✅ Spatialite backend: {type(spat_backend).__name__}")
    print(f"     - has build_expression: {hasattr(spat_backend, 'build_expression')}")
    print(f"     - has apply_filter: {hasattr(spat_backend, 'apply_filter')}")
    
    # Test build_expression
    print("  → Testing Spatialite build_expression()...")
    expr = spat_backend.build_expression({}, {})
    print(f"  ✅ Spatialite expression: '{expr}' (empty OK - uses stub)")
    
except Exception as e:
    print(f"  ❌ Spatialite failed: {e}")
    import traceback
    traceback.print_exc()

print("\n" + "="*80)
print("✅ TESTS COMPLETE")
print("="*80)
