#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Quick test to verify backend imports work after before_migration removal.
v4.2.0: No more before_migration dependencies!
"""

import sys

print("="*80)
print("Testing FilterMate v4.2.0 Backend Imports (No before_migration!)")
print("="*80)

# Test 1: Import factory
print("\n[TEST 1] Importing BackendFactory...")
try:
    sys.path.insert(0, '/windows/c/Users/Simon/AppData/Roaming/QGIS/QGIS3/profiles/imagodata/python/plugins/filter_mate')
    from adapters.backends.factory import BackendFactory
    print("✅ BackendFactory imported successfully")
except Exception as e:
    print(f"❌ BackendFactory import failed: {e}")
    import traceback
    traceback.print_exc()

# Test 2: Import legacy adapters
print("\n[TEST 2] Importing legacy adapters...")
try:
    from adapters.backends.legacy_adapter import get_legacy_adapter
    print("✅ LegacyAdapter imported successfully")
except Exception as e:
    print(f"❌ LegacyAdapter import failed: {e}")
    import traceback
    traceback.print_exc()

# Test 3: Try to create OGR adapter
print("\n[TEST 3] Creating OGR adapter...")
try:
    from adapters.backends.legacy_adapter import get_legacy_adapter
    ogr_adapter = get_legacy_adapter('ogr', {})
    print(f"✅ OGR adapter created: {ogr_adapter}")
    print(f"   - Type: {type(ogr_adapter)}")
    print(f"   - Has build_expression: {hasattr(ogr_adapter, 'build_expression')}")
    print(f"   - Has apply_filter: {hasattr(ogr_adapter, 'apply_filter')}")
except Exception as e:
    print(f"❌ OGR adapter creation failed: {e}")
    import traceback
    traceback.print_exc()

# Test 4: Try to create Spatialite adapter
print("\n[TEST 4] Creating Spatialite adapter...")
try:
    from adapters.backends.legacy_adapter import get_legacy_adapter
    spatialite_adapter = get_legacy_adapter('spatialite', {})
    print(f"✅ Spatialite adapter created: {spatialite_adapter}")
    print(f"   - Type: {type(spatialite_adapter)}")
    print(f"   - Has build_expression: {hasattr(spatialite_adapter, 'build_expression')}")
    print(f"   - Has apply_filter: {hasattr(spatialite_adapter, 'apply_filter')}")
except Exception as e:
    print(f"❌ Spatialite adapter creation failed: {e}")
    import traceback
    traceback.print_exc()

# Test 5: Try to create PostgreSQL adapter  
print("\n[TEST 5] Creating PostgreSQL adapter...")
try:
    from adapters.backends.legacy_adapter import get_legacy_adapter
    pg_adapter = get_legacy_adapter('postgresql', {})
    print(f"✅ PostgreSQL adapter created: {pg_adapter}")
    print(f"   - Type: {type(pg_adapter)}")
    print(f"   - Has build_expression: {hasattr(pg_adapter, 'build_expression')}")
    print(f"   - Has apply_filter: {hasattr(pg_adapter, 'apply_filter')}")
except Exception as e:
    print(f"❌ PostgreSQL adapter creation failed: {e}")
    import traceback
    traceback.print_exc()

print("\n" + "="*80)
print("✅ ALL TESTS COMPLETE - Ready to reload in QGIS!")
print("="*80)
