"""
Script de test pour vérifier le chargement du plugin FilterMate dans QGIS.

Exécuter ce script dans la console Python de QGIS :
    exec(open('/path/to/filter_mate/test_plugin_load.py').read())
"""

print("=" * 60)
print("Test de chargement FilterMate")
print("=" * 60)

# 1. Test import du module principal
try:
    from filter_mate import filter_mate
    print("✓ Module principal 'filter_mate' importé")
except ImportError as e:
    print(f"✗ Erreur import module principal: {e}")
    import traceback
    traceback.print_exc()

# 2. Test import modules
try:
    from filter_mate.modules import appUtils
    print("✓ Module 'appUtils' importé")
    print(f"  → POSTGRESQL_AVAILABLE: {appUtils.POSTGRESQL_AVAILABLE}")
except ImportError as e:
    print(f"✗ Erreur import appUtils: {e}")
    import traceback
    traceback.print_exc()

# 3. Test import filter_mate_app
try:
    from filter_mate import filter_mate_app
    print("✓ Module 'filter_mate_app' importé")
except ImportError as e:
    print(f"✗ Erreur import filter_mate_app: {e}")
    import traceback
    traceback.print_exc()

# 4. Test présence du plugin dans QGIS
try:
    from qgis.utils import plugins
    if 'filter_mate' in plugins:
        print("✓ Plugin 'filter_mate' chargé dans QGIS")
        plugin = plugins['filter_mate']
        print(f"  → Plugin class: {type(plugin).__name__}")
        if hasattr(plugin, 'app'):
            print(f"  → App initialized: {plugin.app is not None}")
    else:
        print("✗ Plugin 'filter_mate' non trouvé dans plugins QGIS")
        print(f"  Plugins disponibles: {list(plugins.keys())}")
except Exception as e:
    print(f"✗ Erreur vérification plugin: {e}")
    import traceback
    traceback.print_exc()

# 5. Test détection couches PostgreSQL
try:
    from qgis.core import QgsProject, QgsVectorLayer
    project = QgsProject.instance()
    layers = project.mapLayers().values()
    postgres_layers = [l for l in layers if isinstance(l, QgsVectorLayer) and l.providerType() == 'postgres']
    
    print(f"\n✓ Projet QGIS analysé")
    print(f"  → Total couches: {len(list(layers))}")
    print(f"  → Couches PostgreSQL: {len(postgres_layers)}")
    
    if postgres_layers:
        print(f"  → Noms des couches PostgreSQL:")
        for layer in postgres_layers[:5]:  # Max 5
            print(f"    - {layer.name()}")
        if len(postgres_layers) > 5:
            print(f"    ... et {len(postgres_layers) - 5} autres")
except Exception as e:
    print(f"✗ Erreur analyse couches: {e}")
    import traceback
    traceback.print_exc()

print("\n" + "=" * 60)
print("Fin du test")
print("=" * 60)
