"""
Script de diagnostic détaillé pour identifier où FilterMate freeze.
À exécuter dans la console Python de QGIS après le freeze.
"""

import logging

# Activer les logs détaillés
logging.basicConfig(level=logging.DEBUG)

# Recharger le module avec logs détaillés
from qgis.utils import plugins

# Si le plugin est déjà chargé
if 'filter_mate' in plugins:
    print("✓ Plugin FilterMate détecté")
    plugin = plugins['filter_mate']
    
    # Vérifier l'état du dockwidget
    if hasattr(plugin, 'dockwidget'):
        dw = plugin.dockwidget
        print(f"  - dockwidget exists: {dw is not None}")
        
        if dw:
            print(f"  - widgets_initialized: {getattr(dw, 'widgets_initialized', 'N/A')}")
            print(f"  - has_loaded_layers: {getattr(dw, 'has_loaded_layers', 'N/A')}")
            print(f"  - PROJECT_LAYERS count: {len(getattr(dw, 'PROJECT_LAYERS', []))}")
            
            # Vérifier les widgets critiques
            if hasattr(dw, 'widgets'):
                print(f"  - widgets dict exists: {len(dw.widgets)} groups")
                for group_name in ['FILTERING', 'EXPORTING', 'DOCK']:
                    if group_name in dw.widgets:
                        widget_count = len(dw.widgets[group_name])
                        print(f"    - {group_name}: {widget_count} widgets")
    else:
        print("  ⚠ dockwidget n'existe pas")
else:
    print("✗ Plugin FilterMate non chargé")
    print("\nPlugins chargés:")
    for name in plugins.keys():
        print(f"  - {name}")
