"""
Script de diagnostic - à exécuter dans la console Python QGIS AVANT de charger le plugin.

Instructions:
1. Ouvrir QGIS sans le plugin FilterMate activé
2. Exécuter ce script dans la console Python
3. Ensuite activer le plugin FilterMate
4. Observer les logs pour voir où ça bloque
"""

import logging
import sys

# Configurer le logging pour voir tout
logging.basicConfig(
    level=logging.DEBUG,
    format='%(asctime)s [%(levelname)s] %(name)s: %(message)s',
    stream=sys.stdout
)

# Activer le logging pour filter_mate
filter_mate_logger = logging.getLogger('filter_mate')
filter_mate_logger.setLevel(logging.DEBUG)

# Créer un handler qui affiche dans la console QGIS
console_handler = logging.StreamHandler(sys.stdout)
console_handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
console_handler.setFormatter(formatter)
filter_mate_logger.addHandler(console_handler)

print("=" * 60)
print("DIAGNOSTIC MODE ACTIVÉ")
print("=" * 60)
print("\n⚠️  Maintenant, activez le plugin FilterMate.")
print("⚠️  Observez les logs pour voir où le freeze se produit.")
print("⚠️  Le dernier message avant le freeze indique le problème.")
print("\n" + "=" * 60)
