#!/usr/bin/env python3
"""Test simple de chargement du module sans QGIS"""
import sys
import os

plugin_dir = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, plugin_dir)

print("=" * 60)
print("TEST DE CHARGEMENT DU PLUGIN FILTERMATE")
print("=" * 60)

try:
    print("\n1. Import du module de base UI...")
    from filter_mate_dockwidget_base import Ui_FilterMateDockWidgetBase
    print("   ✓ OK")
    
    print("\n2. Vérification de la classe...")
    ui_class = Ui_FilterMateDockWidgetBase
    print(f"   Classe: {ui_class.__name__}")
    
    print("\n3. Recherche de noms avec '_3'...")
    methods = [m for m in dir(ui_class) if not m.startswith('__')]
    with_3 = [m for m in methods if '_3' in m]
    
    if with_3:
        print(f"   ⚠️  PROBLÈME: {len(with_3)} noms avec '_3' trouvés:")
        for name in with_3[:10]:
            print(f"      - {name}")
    else:
        print("   ✓ Aucun nom avec '_3' (OK)")
    
    print("\n4. Import du module principal (sans initialiser)...")
    # On n'importe pas car ça nécessite QGIS
    print("   (Nécessite QGIS - ignoré)")
    
    print("\n" + "=" * 60)
    print("RÉSULTAT: Module de base OK")
    print("=" * 60)
    print("\n✅ Le fichier .py généré est correct.")
    print("Si QGIS freeze, le problème vient probablement de:")
    print("  1. Cache Python de QGIS (redémarrer QGIS)")
    print("  2. Initialisation bloquante dans setupUi/setupUiCustom")
    print("  3. Conflit avec un autre plugin")
    
except Exception as e:
    print(f"\n✗ ERREUR: {e}")
    import traceback
    traceback.print_exc()
    sys.exit(1)
