---
sidebar_position: 1
---

# User Guide Introduction

Welcome to the FilterMate User Guide! This comprehensive guide covers everything you need to know to use FilterMate effectively.

## What is FilterMate?

FilterMate is an advanced QGIS plugin designed to make filtering and exporting vector data simple, fast, and powerful. Whether you're working with small shapefiles or massive PostGIS databases with millions of features, FilterMate has you covered.

## Who is This Guide For?

This guide is designed for:

- **GIS Analysts** working with spatial data in QGIS
- **Data Scientists** needing to filter and export geospatial datasets
- **Developers** integrating FilterMate into workflows
- **Students** learning QGIS and spatial analysis

## What You'll Learn

This guide is organized into the following sections:

### Basic Usage
- **[Interface Overview](./interface-overview.md)** - Tour of the FilterMate UI
- **[Filtering Basics](./filtering-basics.md)** - Attribute filters and expressions
- **[Geometric Filtering](./geometric-filtering.md)** - Spatial predicates and operations

### Advanced Features
- **[Buffer Operations](./buffer-operations.md)** - Working with buffer zones
- **[Export Features](./export-features.md)** - Exporting filtered data
- **[Filter History](./filter-history.md)** - Undo/redo and history management
- **[Advanced Features](./advanced-features.md)** - Power user tips and tricks

## Prerequisites

Before using this guide, you should have:

- ✅ QGIS 3.x installed
- ✅ FilterMate plugin installed (see [Installation](../installation.md))
- ✅ Basic familiarity with QGIS interface
- ✅ A vector layer loaded in QGIS

## Getting Help

If you need help:

- 📖 Check the [Troubleshooting](../advanced/troubleshooting.md) guide
- 🐛 Report issues on [GitHub](https://github.com/sducournau/filter_mate/issues)
- 💬 Join discussions on [GitHub Discussions](https://github.com/sducournau/filter_mate/discussions)

## Quick Navigation

**New to FilterMate?** → Start with [Interface Overview](./interface-overview.md)

**Need to filter data?** → See [Filtering Basics](./filtering-basics.md)

**Working with spatial data?** → Check [Geometric Filtering](./geometric-filtering.md)

**Ready to export?** → Read [Export Features](./export-features.md)

Let's get started!
