---
sidebar_position: 1
---

# Getting Started

Welcome to FilterMate! This guide will help you get up and running with advanced filtering and export capabilities in QGIS.

## What You'll Learn

In this section, you'll discover:

- **[Quick Start](./quick-start.md)** - A 5-minute introduction to FilterMate's core features
- **[First Filter](./first-filter.md)** - Step-by-step tutorial for creating your first filter

## Prerequisites

Before starting, make sure you have:

- ✅ QGIS 3.x installed (any version)
- ✅ FilterMate plugin installed (see [Installation](../installation.md))
- ✅ A vector layer loaded in your QGIS project

## Recommended Setup

For the best experience, especially with large datasets:

1. **Install psycopg2** for PostgreSQL support (optional but recommended)
2. **Use PostGIS layers** for datasets >50,000 features
3. **Enable automatic theme synchronization** in QGIS settings

:::tip Getting Help
If you run into issues, check the [Troubleshooting](../advanced/troubleshooting.md) guide or visit our [GitHub Issues](https://github.com/sducournau/filter_mate/issues) page.
:::

## Video Tutorial

Prefer to watch? Check out our complete video tutorial:

[![FilterMate Demo](https://img.youtube.com/vi/2gOEPrdl2Bo/0.jpg)](https://www.youtube.com/watch?v=2gOEPrdl2Bo)

## Next Steps

Ready to dive in? Start with the [Quick Start](./quick-start.md) tutorial!
