# FilterMate Documentation Index

**Version 2.1.0** | December 2025

## 📚 Active Documentation

### Core Documentation
- **[architecture.md](architecture.md)** - Complete system architecture and component diagrams
- **[DEVELOPER_ONBOARDING.md](DEVELOPER_ONBOARDING.md)** - Developer onboarding guide and setup instructions
- **[BACKEND_API.md](BACKEND_API.md)** - Backend API reference and usage

### Feature Implementation
- **[IMPLEMENTATION_STATUS.md](IMPLEMENTATION_STATUS.md)** - Current implementation status and performance optimizations
- **[FILTER_HISTORY_INTEGRATION.md](FILTER_HISTORY_INTEGRATION.md)** - Filter history system documentation
- **[AUTO_CONFIGURATION.md](AUTO_CONFIGURATION.md)** - Auto-configuration system
- **[INTEGRATION.md](INTEGRATION.md)** - Integration guidelines

### UI & Themes
- **[UI_SYSTEM_OVERVIEW.md](UI_SYSTEM_OVERVIEW.md)** - Complete UI system guide
- **[THEMES.md](THEMES.md)** - Theme system documentation
- **[UI_DYNAMIC_CONFIG.md](UI_DYNAMIC_CONFIG.md)** - Dynamic UI configuration
- **[UI_TESTING_GUIDE.md](UI_TESTING_GUIDE.md)** - UI testing procedures
- **[UI_STYLES_TESTING_CHECKLIST.md](UI_STYLES_TESTING_CHECKLIST.md)** - Styles testing checklist

---

## 📦 Archived Documentation

### Completed Fixes
Located in: `archived/fixes/`

- **FIELD_SELECTION_FIX.md** - QgsFieldExpressionWidget configuration fix (completed)
- **SOURCE_TABLE_NAME_FIX.md** - Source table name detection fix (completed)
- **SQLITE_LOCK_FIX.md** - SQLite database locking fix (completed)
- **SQLITE_LOCK_FIX_VISUAL.md** - Visual documentation of SQLite fix (completed)
- **FIX_EXPLORING_MULTIPLE_SPACING.md** - Multiple selection spacing fix (completed)
- **FIX_EXPLORING_SPACING_HEIGHTS.md** - Spacing heights fix (completed)
- **FIX_EXPLORING_WIDGET_OVERLAP.md** - Widget overlap fix (completed)

### Completed UI Improvements
Located in: `archived/ui-improvements/`

- **COMPACT_MODE_HARMONIZATION.md** - Compact mode harmonization (completed)
- **COMPACT_MODE_TEST_GUIDE.md** - Compact mode testing guide (completed)
- **UI_IMPROVEMENTS_README.md** - UI improvements overview (completed)
- **UI_IMPROVEMENTS_REPORT.md** - UI improvements report (completed)
- **UI_IMPROVEMENT_PLAN_2025.md** - 2025 UI improvement plan (completed)
- **UI_STYLES_REFACTORING.md** - Styles refactoring documentation (completed)
- **THEME_PREVIEW.md** - Theme preview system (completed)
- **THEME_SYNC.md** - Theme synchronization (completed)

### Planning & Analysis Documents
Located in: `archived/planning/`

- **UI_HARMONIZATION_PLAN.md** - UI harmonization planning (completed)
- **UI_DYNAMIC_PARAMETERS_ANALYSIS.md** - Dynamic parameters analysis (completed)
- **UI_HARDCODED_PARAMETERS_ANALYSIS.md** - Hardcoded parameters analysis (completed)
- **DEPLOYMENT_GUIDE_DYNAMIC_DIMENSIONS.md** - Deployment guide for dynamic dimensions (completed)
- **IMPLEMENTATION_DYNAMIC_DIMENSIONS.md** - Dynamic dimensions implementation (completed)

---

## 📖 Documentation Guidelines

### When to Archive
Documents should be moved to `archived/` when:
- The feature/fix is fully implemented and stable
- The document is primarily historical or planning-focused
- The information is superseded by active documentation

### Active Document Standards
Active documents should:
- Be kept up-to-date with current implementation
- Include version information and last update date
- Reference archived documents when relevant
- Focus on current functionality and usage

### Archive Organization
- **fixes/** - Completed bug fixes and corrections
- **ui-improvements/** - Completed UI enhancements and refactorings
- **planning/** - Historical planning and analysis documents

---

## 🔍 Quick Reference

### For Developers
Start here:
1. [DEVELOPER_ONBOARDING.md](DEVELOPER_ONBOARDING.md)
2. [architecture.md](architecture.md)
3. [BACKEND_API.md](BACKEND_API.md)

### For Contributors
Start here:
1. [IMPLEMENTATION_STATUS.md](IMPLEMENTATION_STATUS.md)
2. [UI_TESTING_GUIDE.md](UI_TESTING_GUIDE.md)
3. GitHub Copilot Instructions: `../.github/copilot-instructions.md`

### For Theme Developers
Start here:
1. [UI System Overview](UI_SYSTEM_OVERVIEW.md)
2. [Themes](THEMES.md)
3. [UI Dynamic Config](UI_DYNAMIC_CONFIG.md)

---

**Last Updated:** December 7, 2025
