# Aperçu visuel des thèmes

Ce document présente visuellement les couleurs de chaque thème pour chaque type de donnée.

## Légende des types

| Type | Description | Exemple |
|------|-------------|---------|
| none | Valeurs null/None | `null` |
| string | Chaînes de caractères | `"hello world"` |
| integer | Nombres entiers | `42` |
| float | Nombres décimaux | `3.14` |
| boolean | Booléens | `true`, `false` |
| list | Tableaux | `[1, 2, 3]` |
| dict | Objets | `{"key": "value"}` |
| url | URLs | `https://example.com` |
| filepath | Chemins de fichiers | `/path/to/file` |
| range | Plages | `{start: 1, end: 10, step: 1}` |
| choices | Choix | `{value: "A", choices: ["A", "B"]}` |

## Default Theme

**Style:** Classique, sobre  
**Recommandé pour:** Compatibilité maximale

| Type | Couleur | Hex |
|------|---------|-----|
| Tous les types | Noir | `#000000` |

## Monokai Theme

**Style:** Sombre, vibrant  
**Recommandé pour:** Interfaces sombres, longues sessions  
**Inspiration:** Sublime Text

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris | `#75715E` | 🟫 Subtil |
| string | Jaune | `#E6DB74` | 🟨 Vif |
| integer | Violet | `#AE81FF` | 🟪 Doux |
| float | Violet | `#AE81FF` | 🟪 Doux |
| boolean | Orange | `#FD971F` | 🟧 Chaud |
| list | Rose | `#F92672` | 🩷 Éclatant |
| dict | Cyan | `#66D9EF` | 🩵 Clair |
| url | Vert | `#A6E22E` | 🟩 Frais |
| filepath | Vert | `#A6E22E` | 🟩 Frais |
| range | Violet | `#AE81FF` | 🟪 Doux |
| choices | Jaune | `#E6DB74` | 🟨 Vif |

## Solarized Light Theme

**Style:** Clair, chaleureux  
**Recommandé pour:** Interfaces claires, lecture prolongée  
**Inspiration:** Solarized palette

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris clair | `#93A1A1` | ⬜ Neutre |
| string | Cyan | `#2AA198` | 🩵 Frais |
| integer | Magenta | `#D33682` | 💗 Vif |
| float | Magenta | `#D33682` | 💗 Vif |
| boolean | Orange | `#CB4B16` | 🟧 Chaud |
| list | Jaune | `#B58900` | 🟨 Doré |
| dict | Bleu | `#268BD2` | 🔵 Ciel |
| url | Vert | `#859900` | 🟩 Nature |
| filepath | Vert | `#859900` | 🟩 Nature |
| range | Violet | `#6C71C4` | 🟣 Lavande |
| choices | Cyan | `#2AA198` | 🩵 Frais |

## Solarized Dark Theme

**Style:** Sombre, chaleureux  
**Recommandé pour:** Interfaces sombres avec contraste modéré  
**Inspiration:** Solarized palette (version sombre)

Mêmes couleurs que Solarized Light, optimisées pour fond sombre.

## Nord Theme

**Style:** Frais, arctique  
**Recommandé pour:** Ambiance calme et professionnelle  
**Inspiration:** Palette Nord

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris froid | `#4C566A` | ⬛ Polaire |
| string | Vert | `#A3BE8C` | 🟩 Aurore |
| integer | Violet | `#B48EAD` | 🟪 Givré |
| float | Violet | `#B48EAD` | 🟪 Givré |
| boolean | Orange | `#D08770` | 🟧 Crépuscule |
| list | Jaune | `#EBCB8B` | 🟨 Soleil nordique |
| dict | Cyan | `#88C0D0` | 🩵 Glace |
| url | Turquoise | `#8FBCBB` | 🩵 Eau glacée |
| filepath | Turquoise | `#8FBCBB` | 🩵 Eau glacée |
| range | Violet | `#B48EAD` | 🟪 Givré |
| choices | Vert | `#A3BE8C` | 🟩 Aurore |

## Dracula Theme

**Style:** Sombre, dramatique  
**Recommandé pour:** Codage nocturne, contraste élevé  
**Inspiration:** Dracula theme

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris violet | `#6272A4` | 🟦 Brume |
| string | Jaune | `#F1FA8C` | 🟨 Lumineux |
| integer | Violet | `#BD93F9` | 🟣 Mystique |
| float | Violet | `#BD93F9` | 🟣 Mystique |
| boolean | Orange | `#FFB86C` | 🟧 Flamme |
| list | Rose | `#FF79C6` | 🩷 Néon |
| dict | Cyan | `#8BE9FD` | 🩵 Électrique |
| url | Vert | `#50FA7B` | 🟩 Néon |
| filepath | Vert | `#50FA7B` | 🟩 Néon |
| range | Violet | `#BD93F9` | 🟣 Mystique |
| choices | Jaune | `#F1FA8C` | 🟨 Lumineux |

## One Dark Theme

**Style:** Moderne, équilibré  
**Recommandé pour:** Usage général, style Atom/VS Code  
**Inspiration:** One Dark (Atom editor)

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris | `#5C6370` | ⬛ Neutre |
| string | Vert | `#98C379` | 🟩 Nature |
| integer | Orange | `#D19A66` | 🟧 Cuivre |
| float | Orange | `#D19A66` | 🟧 Cuivre |
| boolean | Rouge | `#E06C75` | 🔴 Vif |
| list | Jaune | `#E5C07B` | 🟨 Or |
| dict | Bleu | `#61AFEF` | 🔵 Clair |
| url | Cyan | `#56B6C2` | 🩵 Océan |
| filepath | Cyan | `#56B6C2` | 🩵 Océan |
| range | Violet | `#C678DD` | 🟣 Pourpre |
| choices | Vert | `#98C379` | 🟩 Nature |

## Gruvbox Theme

**Style:** Rétro, chaleureux  
**Recommandé pour:** Ambiance confortable, vintage  
**Inspiration:** Gruvbox palette

| Type | Couleur | Hex | Aperçu |
|------|---------|-----|---------|
| none | Gris | `#928374` | ⬛ Pierre |
| string | Vert | `#B8BB26` | 🟩 Lime |
| integer | Violet | `#D3869B` | 🟣 Prune |
| float | Violet | `#D3869B` | 🟣 Prune |
| boolean | Orange | `#FE8019` | 🟧 Feu |
| list | Jaune | `#FABD2F` | 🟨 Miel |
| dict | Bleu | `#83A598` | 🔵 Denim |
| url | Aqua | `#8EC07C` | 🩵 Menthe |
| filepath | Aqua | `#8EC07C` | 🩵 Menthe |
| range | Violet | `#D3869B` | 🟣 Prune |
| choices | Vert | `#B8BB26` | 🟩 Lime |

## Comparaison des thèmes

### Par ambiance

**Thèmes sombres (fond sombre recommandé):**
- Monokai - Le plus vibrant
- Dracula - Le plus dramatique
- Nord - Le plus calme
- One Dark - Le plus équilibré
- Solarized Dark - Le plus chaleureux
- Gruvbox - Le plus rétro

**Thèmes clairs (fond clair recommandé):**
- Default - Le plus simple
- Solarized Light - Le plus agréable

### Par contraste

**Contraste élevé:**
1. Dracula
2. Monokai
3. One Dark

**Contraste modéré:**
1. Nord
2. Gruvbox
3. Solarized Light/Dark

**Contraste minimal:**
1. Default

### Par usage

**Développement intensif:**
- Monokai ou One Dark

**Lecture/analyse de données:**
- Solarized Light ou Nord

**Présentation/documentation:**
- Solarized Light ou One Dark

**Sessions prolongées:**
- Nord ou Gruvbox (moins fatigue visuelle)

## Exemples de combinaisons de données

### Exemple 1 : Configuration simple
```json
{
  "enabled": true,
  "port": 5432,
  "host": "localhost"
}
```
- `enabled` (boolean) → couleur distinctive
- `5432` (integer) → différent de boolean
- `"localhost"` (string) → différent des nombres

### Exemple 2 : Structure complexe
```json
{
  "backends": [
    {
      "type": "postgresql",
      "url": "https://example.com",
      "timeout": 30.5
    }
  ]
}
```
- Objets (dict) → couleur structurante
- Tableaux (list) → couleur de collection
- Chaînes vs nombres → bien différenciés

### Exemple 3 : Tous les types
```json
{
  "string": "text",
  "integer": 42,
  "float": 3.14,
  "boolean": true,
  "null": null,
  "list": [1, 2],
  "dict": {"nested": "value"},
  "url": "https://example.com",
  "path": "/path/to/file"
}
```
Chaque type a sa propre couleur pour une distinction maximale.

## Recommandations finales

### Pour FilterMate

1. **Thème par défaut suggéré :** Monokai ou One Dark
   - Moderne et professionnel
   - Bon contraste sans être fatigant
   - Populaire dans la communauté des développeurs

2. **Alternative claire :** Solarized Light
   - Pour utilisateurs préférant les interfaces claires
   - Excellent pour longues sessions de lecture

3. **Option confort :** Nord
   - Couleurs apaisantes
   - Idéal pour réduire la fatigue oculaire

### Accessibilité

Tous les thèmes offrent un contraste suffisant pour une lisibilité correcte. Pour les utilisateurs avec déficiences visuelles :
- **Contraste maximal :** Dracula
- **Couleurs différenciées :** Monokai (meilleure séparation des types)

---

*Pour tester interactivement tous les thèmes, utilisez :*
```python
from modules.qt_json_view.theme_demo import show_theme_demo
show_theme_demo()
```
