from pathlib import Path
from file_management.providers.errors import FileDoesNotExistError


class SHPFileManager:

    def __init__(self, uri):
        self._file = Path(uri.database())
        self._exts = ['.shp', '.prj', '.dbf', '.shx', '.sbn', '.sbx', '.fbn', '.fbx', '.ain', '.aih', '.atx', '.ixs',
                      '.mxs', '.xml', '.cpg']

    def provider_name(self):
        return 'Shapefile'

    def rename_layer(self, target_uri):

        target_path = Path(target_uri.database())
        if not self._file.exists():
            raise FileDoesNotExistError

        for file in self._file.parent.glob(f'{self._file.stem}.*'):
            if file.suffix.lower() in self._exts:
                new_file = target_path.with_suffix(file.suffix)
                file.rename(new_file)

    def rename_database(self, target_uri):
        pass

    def layer_exists(self, target_uri):
        return Path(target_uri.database()).exists()

    def database_exists(self, target_uri):
        return False

    def ask_overwrite_layer(self, target_uri, iface):
        return True  # already asked in file dialog

    def ask_overwrite_database(self, target_uri, iface):
        return True

    def delete_layer(self, target_uri):
        p = Path(target_uri.database())
        for file in p.parent.glob(f'{p.stem}.*'):
            if file.suffix.lower() in self._exts:
                file.unlink()

    def delete_database(self, target_uri):
        pass
