# File Management

QGIS Plugin that allows users to rename layers on disk within QGIS via the right-click context menu in the 
Layers Panel. It also has functionality to let users copy layer paths (both absolute and relative) to the clipboard.

Functionality include:
* Rename SHP, TAB, MIF, GPKG vector layers
* Rename GPKG databases
* Copy layer name to clipboard
* Copy layer full path to clipboard
* Copy database path to clipboard
* Copy relative path to the clipboard (user chooses the starting directory)
* User customisable settings e.g. customisation on how the database name and layer name are separated when copying paths

## Dependencies

Requires at least Python 3.8. This loosely corresponds to QGIS version 3.22.8+.

## Installation

1. Open command prompt or bash
2. Navigate to the QGIS plugin folder

   <b>Windows:</b> `cd %appdata%\QGIS\QGIS3\profiles\default\python\plugins`

   <b>Linux:</b> `cd /home/USER/.local/share/QGIS/QGIS3/profiles/default/python/plugins`

3. Clone the repository

   `git clone https://gitlab.com/tuflow/qgis-file-management-plugin.git`

4. Rename the folder to `file_management`

   <b>Windows:</b> `rename qgis-file-management-plugin file_management`

   <b>Linux:</b> `mv qgis-file-management-plugin file_management`

5. Open QGIS and via the Plugin Manager tick on the 'file_management' plugin which should now be available under 
   'Installed Plugins'

## How to Use

This plugin adds an additional menu to the right-click context menu of layers in the Layers Panel called 'File Management'.
This menu contains the plugin functionality and the available options will vary depending on the layer that was 
right-clicked. E.g. If it was a raster layer or vector layer, and whether it was a SHP file or GPKG.

The settings can be found under the plugin menu:<br><b>Plugins >> File Management >> Settings</b>

## Changelog

See `metadata.txt` for changelog.

## License

Licensed under GNU GPLv3