from PyQt5.QtWidgets import QDialog
from PyQt5.QtCore import QSettings
from .ui_settings_dialog import Ui_FileManagementSettings


class FileManagementSettingsDialog(QDialog, Ui_FileManagementSettings):

    def __init__(self, parent, settings):
        QDialog.__init__(self, parent)
        self.setupUi(self)

        self.settings = settings

        self.cbDontCopyLayerName.setChecked(self.settings.dont_copy_layer_name_if_same)
        self.cbDontCopyLayerName.clicked.connect(self.set_dont_copy_layer_name_if_same)

        self.rbUseDefaultDelimiter.setChecked(self.settings.use_default_delimiter)
        self.rbUseCustomDelimiter.setChecked(not self.settings.use_default_delimiter)
        self.rbUseDefaultDelimiter.clicked.connect(self.set_use_default_delimiter)
        self.rbUseCustomDelimiter.clicked.connect(self.set_use_custom_delimiter)

        self.leCustomDelimiter.setText(self.settings.custom_delimiter)
        self.leCustomDelimiter.textChanged.connect(self.set_custom_delimiter)

    def set_dont_copy_layer_name_if_same(self):
        self.settings.dont_copy_layer_name_if_same = self.cbDontCopyLayerName.isChecked()
        QSettings().setValue('file_management/dont_copy_layer_name_if_same', self.settings.dont_copy_layer_name_if_same)

    def set_use_default_delimiter(self):
        self.settings.use_default_delimiter = self.rbUseDefaultDelimiter.isChecked()
        QSettings().setValue('file_management/use_default_delimiter', self.settings.use_default_delimiter)

    def set_use_custom_delimiter(self):
        self.settings.use_default_delimiter = not self.rbUseCustomDelimiter.isChecked()
        QSettings().setValue('file_management/use_default_delimiter', self.settings.use_default_delimiter)

    def set_custom_delimiter(self):
        self.settings.custom_delimiter = self.leCustomDelimiter.text()
        QSettings().setValue('file_management/custom_delimiter', self.settings.custom_delimiter)