# FiberQ v1.1

A QGIS plugin for fiber optic network design and documentation.

## What's New in v1.1

### Key Improvements

- **QGIS 3.22-3.40+ Compatibility**: New compatibility layer ensures the plugin works across all QGIS 3.x LTR versions
- **Fixed Cable Label Display**: Resolved cable label length calculation issues
- **Modular Architecture**: Code organized into dedicated packages for better maintainability
- **English Translations**: All identifiers and comments translated to English
- **Full v1.0 Compatibility**: Projects created in v1.0 work without modification
- **Preview Map CRS sync**: Sync CRS in pgAdmin4 (Preview Map) with working project CRS

### Module Structure

```
fiberq/
├── main_plugin.py           # Main plugin class
├── core/
│   ├── config_manager.py    # Configuration handling
│   ├── layer_manager.py     # Layer creation and management
│   ├── style_manager.py     # Layer styling
│   ├── data_manager.py      # Data persistence
│   └── export_manager.py    # Export functionality
├── ui/                      # Toolbar UI groups
├── dialogs/                 # Dialog classes
├── tools/                   # Map tools
├── utils/
│   ├── compat.py            # QGIS version compatibility
│   └── ...                  # Other utilities
├── models/                  # Data models
├── addons/                  # Advanced features
├── icons/                   # Toolbar icons
├── styles/                  # QML style files
└── resources/               # Map icons
```

## Features

### Core Features (Free)

- Create routes and place poles
- Lay aerial and underground cables (backbone, distribution, drop)
- Place network elements (ODF, OTB, TB, TO, Patch Panel, Joint Closures)
- Add optical slack/reserves
- Place manholes and ducting infrastructure
- Draw service areas
- Export to GeoPackage, GPX, KML/KMZ
- BOM (Bill of Materials) report generation

### Advanced Features (Pro License)

- Preview Map integration
- Publish to PostGIS
- Relations management
- Fiber break tracking
- Infrastructure cut tools

## Installation

### From QGIS Plugin Repository

1. Open QGIS → Plugins → Manage and Install Plugins
2. Search for: **FiberQ**
3. Click Install

### Manual Installation

1. Download the plugin ZIP
2. Extract to your QGIS plugins directory:
   - Windows: `%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\`
   - Linux: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
   - macOS: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`
3. Restart QGIS
4. Enable the plugin in Plugins → Manage and Install Plugins

## Requirements

- **QGIS**: 3.22 LTR through 3.40+ (all versions supported)
- **Operating System**: Windows / macOS / Linux

## Backward Compatibility

v1.1 maintains full backward compatibility with v1.0 projects:

- All layer names work in both Serbian and English
- Database field names unchanged
- Existing QML styles work without modification
- Pro license status preserved

## Support

- Website: https://www.fiberq.net/
- Repository: https://github.com/vukovicvl/fiberq
- Issues: https://github.com/vukovicvl/fiberq/issues

## License

GPL-3.0-or-later
