# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FeltTegn
                                 A QGIS plugin
 Plugin makes polys from oints
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-11-14
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Arkæologisk IT
        email                : ds@moesgaardmuseum.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QDateTime
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtCore import QVariant
from qgis.gui import QgsFileWidget, QgsProjectionSelectionWidget

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .felt_tegn_dialog import FeltTegnDialog
import os.path

import os
import csv
from operator import itemgetter
import json
import time

from qgis.core import (
  QgsFields,
  QgsGeometry,
  QgsPoint,
  QgsPointXY,
  QgsWkbTypes,
  QgsFeatureRequest,
  QgsDistanceArea,
  QgsPolygon,
  QgsField,
  QgsVectorFileWriter,
  QgsFeature,
  QgsVectorLayer,
  Qgis,
  QgsProject,
  QgsCoordinateReferenceSystem,
  QgsWkbTypes,
  QgsMarkerSymbol,
  QgsLineSymbol,
  QgsFillSymbol)



class FeltTegn:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'FeltTegn_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FeltTegn')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FeltTegn', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/felt_tegn/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Digitalisér GPS-punkter'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&FeltTegn'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = FeltTegnDialog()

        # Input file dialog
        ifile = self.dlg.inputTextFile
        # Enable multiple file ingest
        ifile.setStorageMode(QgsFileWidget.GetMultipleFiles)
        #Set up output directory dialog
        odir = self.dlg.outputTargetDir
        odir.setStorageMode(QgsFileWidget.GetDirectory)
        #Projection dialog
        proj = self.dlg.mQgsProjectionSelectionWidget
        proj.setCrs(QgsCoordinateReferenceSystem("EPSG:25832"))
        
        self.dlg.hvonaar.setDateTime(QDateTime.currentDateTime())
        who = self.dlg.hvem
        
        sag = self.dlg.SagsNummer
        
        kd = self.dlg.kDato
        
        
        # TODO: Fix the below
        mus_list = ['Auto',
                    'ARV',
                    'BMR',
                    'DKM',
                    'HOM',
                    'TAK',
                    'KBM',
                    'FHM',
                    'MKH',
                    'HBV',
                    'MLF',
                    'HEM',
                    'MNS',
                    'MSA',
                    'SBM',
                    'KNV',
                    'MSJ',
                    'THY',
                    'MVE',
                    'MOE',
                    'NATMUS',
                    'NJM',
                    'NJK',
                    'OBM',
                    'ROM',
                    'SKH',
                    'SJM',
                    'VKH',
                    'VHM',
                    'VMÅ',
                    'VSM',
                    'VIR',
                    'ØHM',
                    'ØFM']
        
        mus = self.dlg.MusComboBox
        mus.addItems(mus_list)
        
        # show the dialog
        self.dlg.show()
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        
       
        # See if OK was pressed
        if result:
            # Export file format radio butoons
            shp = self.dlg.radioButton_shp.isChecked()
            tab = self.dlg.radioButton_tab.isChecked()
            gp = self.dlg.radioButton_gp.isChecked()
            gjson = self.dlg.radioButton_gjson.isChecked()
            whom = who.text()
            when = self.dlg.hvonaar.date().toString('yyyy-M-dd')
            gps  = self.dlg.GPS_radioButton.isChecked()
            tps  = self.dlg.TPS_radioButton.isChecked()
            sag = sag.text()
            kdato = kd.text()
            
            mus_code = mus.currentText()
            
            mus.clear()
            
            # File creation options...
            #Add files to map
            add_files = self.dlg.chk_addfiles.isChecked() 
            '''Generate output containing all points? This is optional and is
            supporting legacy users- some will just want to load the csv'''
            kote_file = self.dlg.chk_kote.isChecked() 

            # Input files
            ifile = ifile.splitFilePaths(ifile.filePath())
            
            for i in ifile:
                # Instantiate Digi class
                digit = Digi([i],
                             kote_file=kote_file,
                             mus_code=mus_code,
                             sag=sag,
                             kdato=kdato,
                             who=whom,
                             when=when,
                             gps=gps,
                             tps=tps)
                
                # Export the features
                out_layers = digit.feat_export(odir.filePath(),
                                               proj.crs(),
                                               shp=shp,
                                               tab=tab,
                                               gp=gp,
                                               gjson=gjson)
                
                # Add files to Qgis layers
                if add_files is True:
                    #Instatiate our artist class
                    styled = Artist()
                    
                    #sort these and get symbology
                    for l in styled.order_layers(out_layers):
                        #get layer name
                        ol = QgsVectorLayer(l[0],os.path.split(l[0])[-1].split('.')[0],"ogr")
                        
                        #Add layer to map
                        QgsProject.instance().addMapLayer(ol)
                        
                        #Append properties to renderer
                        if not tab is True:
                            props = ol.renderer().symbol().symbolLayer(0).properties()
                            
                            for key in l[3]:
                                props[key] = l[3][key]
                            
                            #Set symbol type & properties depending on geometry
                            geom_type = QgsWkbTypes.displayString(ol.wkbType())
                            
                            if geom_type == 'Polygon' or geom_type == 'MultiPolygon':
                                ol.renderer().setSymbol(QgsFillSymbol.createSimple(props))
                            elif geom_type == 'LineString' or geom_type == 'MultiLineString':
                                ol.renderer().setSymbol(QgsLineSymbol.createSimple(props))
                            elif geom_type == 'Point' or geom_type == 'MultiPoint':
                                ol.renderer().setSymbol(QgsMarkerSymbol.createSimple(props))
                            else:
                                pass
                            #redraw layer
                            ol.triggerRepaint()
                            #refresh legend
                            node = QgsProject.instance().layerTreeRoot().findLayer(ol.id())
                            self.iface.layerTreeView().layerTreeModel().refreshLayerLegend(node)
                        
                else:
                    out_layers
                    
                    
class LoadDefs():
    def __init__(self,
                 codefile = None,
                 fname = None,
                 museum_code = 'default'):
        
        self.codes = None
        self.layers = None
        self.styles = None
        
        d = None
        
        if codefile is None:
            codefile = os.path.join(os.path.dirname(__file__),'layer_definition.json')
            
        if not os.path.exists(codefile) and not os.path.isfile(codefile):
            raise Exception('No Codefile found')
            
        else:
            with open(codefile, 'r') as ifile:
                d = json.load(ifile)
                
                
        
                
        self.codes=d['default']['codes']
        """Codes.these are deifned as a dict with the following attributes:
             key - text string identifying code
             ...sub dict keys... 
            - Aliases : Can a different code be used- if so list of codes. most
            frequent use of this is a singl letter prefix denoting feature type.
                      e.g. A1 = Anlæg, X1= Find etc.
            - layer : output layer name to append features to
            - type : geometric type object passed to Digi class. these are:
                    poly : polygon
                    zpoly : zigzag polygon
                    upoly : delete this from intersecting polgons
                            layer from which to do this is denoted by U_******
                    spoly : split poly using other polys. Target layer denoted
                            by S_********
                    point : point
                    pline : polyline
             - pass : what stage in the iterator are these taken in?:
                 1st pass- big trenches, fyldskift etc where people stop &
                 record anlæg etc in the middle
                 2nd pass- all the normal stuff
            """
        
        self.layers = d['default']['layers']
        '''Layers. Defined as a dict with the following attributes:
            key - layer name
            ... sub dict keys...
            - fields : list of fields as strings describing instances of the 
                       QgsField we'll run using eval() when we export data
            - field_mapping : how do these field names map to the default attributes
                              of the features. structered ar target field, attribute
            - prefix : prefix prepended to IDs on export of features e.g. A1234,
                       X567 etc.
            - type : geometric primitive type
                              
        '''
        
        self.styles = d['default']['styles']
        ''' Styles- how woe draw the Layers dict:
            - key : Layer name
            - do : drawing order. Int, Used to control how 
            - style : properties used for qgis renederer
            . '''
            
            
        '''This bit overwrites the default codes with museum specific stuff,
        using the 3 charachter museum abreviation code- e.g. FHM, VKH, HOM or 
        other string used to define a new set of impports in the GUI'''
        
        #TODO- set museum code from UI- or from import filemname???
        if museum_code == 'Auto':
            museum_code = fname[0:3].upper()
            
            
            
            
        
        if museum_code != 'default':
            if museum_code in d.keys():
                for code in d[museum_code]['codes']:
                    self.codes[code]=d[museum_code]['codes'][code]
                for layer in d[museum_code]['layers']:
                    self.layers[layer]=d[museum_code]['layers'][layer]
                for style in d[museum_code]['layers']:
                    self.layers[layer]=d[museum_code]['styles'][style]
                
class LoadData():
    """ Class to load data from a csv file"""
    def __init__(self,
                 museum_code='default',
                 fname='None'):
        
        """List to contain data values"""
        self.data=[]
       
        
        """Load data definition from JSON file"""
        defs = LoadDefs(museum_code=museum_code,
                        fname=fname)
        #codes deifning features and how they're handled
        self.codes = defs.codes
        # ditto layers
        self.layers = defs.layers
        
        # Dicts to contain first and second pass features, layers and all points
        self.feats_1st_pass = {}  
        self.feats_2nd_pass = {}
        self.all_points = {}
        self.errors =[]
             
        # loop through codes to check if they have aliases
        lcodes = {}
        for k in self.codes.keys():
            if not self.codes[k]["Aliases"] is None:
                # if they do add the code info under the alias
                for alias in self.codes[k]["Aliases"]:
                    lcodes[alias]=self.codes[k]
              
        for d in (lcodes):
            self.codes.update(lcodes)

    
    def parsefile(self,
                  infile, # path to source file inluding path #TODO from GUI
                  delimiter=',', # delimiter
                  xidx=0, # index for x column in source file
                  yidx=1, # index for y column in source file
                  zidx=2, # index for z column in source file
                  ididx=3, # index for point id
                  kidx=4, # index for arkdigi code
                  nidx=5, # index for notes field
                  proj = None, # handle projections from GUI
                  kote_file = False):
        """
        method loads and parses file
        """
        #open file and iterate over lines
        with open(infile, 'r') as i:
            r = csv.reader(i,delimiter=delimiter)
            # restructure if needed based on args
            for row in r:
                if len(row)>0:
                    x = row[xidx]
                    y=row[yidx]
                    z=row[zidx]
                    idid =row[ididx]
                    k = row[kidx]
                    
                    #append to self.data
                    self.data.append([x,y,z,idid,k])
        # set counter
        i = 0  
        # set up list to hold points related to feature
        current = []
        #loop over data
        l = len(self.data)
        for r in self.data:
            #set feature id
            fid = None
            #set point code
            kote = None
            #set attribute
            attr = None
            # set id for all points
            idid =r[3]
           
            #if line starts with a dash it's a standard code...
            if r[4][0] == '-':
                #check for first delimiter cos people do different things 
                space = r[4].find(' ') 
                dot = r[4].find('.')
                delim = None
                # find out how it's delimited
                if dot == -1 and space == -1:
                     kote = r[4]     
                elif dot == -1 and space > 0:
                    delim = space  
                elif dot > 0 and space ==-1:
                    delim = dot 
                elif dot>0 and space>0:
                    if dot < space:
                        delim = dot   
                    else:
                        delim = space
                # slice accordingly        
                if not delim is None:
                    if not delim == len(r[4])-1:
                        kote = r[4][:delim]
                        fid = r[4][delim+1:]
                    else:
                        kote = r[4]
                
                else:
                    kote = r[4]
                    '''fall-back condition is just to take these into the code
                    if it's wrong it will get picked up by error handling when we
                    get the code'''

                if not fid is None:
                    '''split off attributes from id'''    
                    if '.' in fid:
                        fid_l = fid.split('.') 
                        fid = fid_l[0]
    
                        if len(fid_l)>2:
                            attr = ' '.join(fid_l[1:])
                        else:
                            attr = fid_l[-1]                  
            # else the code is probably denoted by the fist letter            
            else:
                kote =r[4][0]
                #assign attribute if it's htere
                if '.' in r[4]:
                    fid, attr = r[4].split('.')
                # if it's not the feature id is the feature id
                else:
                    fid = r[4]          
            # Assign feature ID if none exists
            
            label = None
                      
            if fid is None:
                if len(current)==0:
                    fid = "%s_%s" %(kote,r[3])
                    #tfid = "%s" %(r[3])
            else:
                label = fid
            
            # check if code is in our code list
            if kote.upper() in self.codes.keys():
                #if so retrieve code from code list
                code = self.codes[kote.upper()]  
                # get the appropriate layer from the code list
                layer = code["layer"]
                # if it's not in our list of layers create it pronto- we'll need it later
                if not layer in self.layers.keys():
                    self.layers[layer]={'type':code["type"],'prefix':code["prefix"]}    
                # append the current geometry to current feature
                current.append([float(r[0]),float(r[1]),float(r[2]),r[3]])
                
                '''check this feature against the next in the list and to see
                if it's different or the last point in file. If so we're we're
                done with this feature and we can assign output to the 1st or 2nd
                pass feature dicts'''
                last_pt = False
                
                #is it the last point in the file?
                if not i==l-1:
                     if self.data[i+1][4] != r[4] or self.layers[layer]['type'] == 'point':
                        last_pt = True
                else:
                    last_pt = True
                    
                if last_pt is True:   
                    #add prefix to label
                    if not label is None:
                        try:
                            int(label)
                            label = self.layers[code['layer']]["prefix"]+label
                        except ValueError:
                            pass
                    
                    if not label is None:
                        label = label.upper()
                    
                    # ... unless it's a first pass feature
                    if code["pass"] == 1:
                        # I don't trust the feature ids from these to be unique 
                        feat_id = "%s_%s" %(kote, fid)
                        # check to see if this is a new feature or a contiuation
                        if not feat_id in self.feats_1st_pass.keys():
                            #if it's new make it
                            self.feats_1st_pass[feat_id]={}
                            self.feats_1st_pass[feat_id]["code"]=code
                            self.feats_1st_pass[feat_id]["points"]=current
                            self.feats_1st_pass[feat_id]["label"]=label
                        else:
                            #if it's not new add the points to the existing feature
                            for c in current:
                                self.feats_1st_pass[feat_id]["points"].append(c)
                        #create and add attributes for feature        
                        self.feats_1st_pass[feat_id]["attr"]=attr
                    else:
                        # if this is a second pass feature create it
                        # check first to see if it has a unique id- stones etc don't
                        if not fid in self.feats_2nd_pass.keys():
                        
                            self.feats_2nd_pass[fid] = {}
                            self.feats_2nd_pass[fid]["points"]=current
                            self.feats_2nd_pass[fid]["label"]=label
                        else:
                            fid = "%s_%s" %(kote, current[0][3])
                            self.feats_2nd_pass[fid] = {}
                            self.feats_2nd_pass[fid]["points"]=current
                            self.feats_2nd_pass[fid]["label"]=label
                            
                        # add code info and attributes    
                        self.feats_2nd_pass[fid]["code"]=code
                        self.feats_2nd_pass[fid]["attr"]=attr
                        
                        
                        
                    # reset current feature cos we're on to the next
                    current = []
            
            # if we can't find the code append to errors
            # TODO- handle this much betterer- add an error collection method
            else:
                self.errors.append(r)
                           
            # increment the counter cos we done here
            i =i+1
            
            if kote_file is True:
                pt_id = 'pt_%s' %(idid)
                self.all_points[pt_id]={"points":[[float(r[0]),float(r[1]),float(r[2]),r[3]]],
                                       "x":float(r[0]),
                                       "y":float(r[1]),
                                       "z":float(r[2]),
                                       "punkt_id":r[3],
                                       "Fid":fid,
                                       "type":kote,
                                       "attr":attr,
                                       "code":{"type":'point',"layer":'AllePunkter'},
                                       "label":fid}
              
                if not 'AllePunkter' in self.layers:
                    self.layers['AllePunkter']={'type':'point'}            
   
        print ("Errors", self.errors)
            
class Digi():
    """ 
    Class digtitises layers from points. 
    Seperate methods handle each type of feature to be digitised
    """
    
    def __init__(self, 
                 infiles, #list of csv files to load
                 mus_code = 'default',
                 split_files=True, #convert as seperate files or homogenise
                 case_delimiter = '_', # delimiter used in case- eg FHM12345_blah.csv
                 kote_file = False,
                 sag=None,
                 kdato=None,
                 who=None,
                 when=None,
                 gps=None,
                 tps=None,
                 ):
        
        # The layers we'll actually use
        self.layers = None
        
        # an empty dict to hold the features
        self.features = {}
        # filename
        self.fname = None
        
        #Errors
        self.errors=[]
        
        #Properites for all layers and features
        
        
        
        if gps is True:
            method = 'GPS'
        else:
            method = 'TPS'
        
        self.props={'Opmåler':who,
                    'Dato':when,
                    'Metode':method,
                    'Kampagne':kdato,
                    'Journal':mus_code+sag,
                    }
        
        
        
        ''' This if statment is kind of redundant, but left as a hook because 
        eventually we may add the option to merge seperate files'''
        if split_files is True:
            # Loop through and load files
            for f in infiles:
                fname=os.path.split(f)[-1] 
                
                if mus_code == 'Auto':
                    mus_code = fname[0:3].upper()
                    
                self.props['Museum']=mus_code
                    
                    
                if sag == 'Auto':
                    delims = ['_',' ','-']
                    first_delim = None
                    
                    for d in delims:
                        idx = fname.find(d)
                        
                        if not idx == -1:
                            if first_delim is None:
                                first_delim = idx
                            elif idx < first_delim:
                                first_delim = idx
                                
                    if first_delim is None:
                        first_delim = -1
                               
                    sag = fname[3:first_delim]      
                    
                self.props['Journal']=mus_code+sag
                        
                indata = LoadData(museum_code=mus_code, fname=fname)
                indata.parsefile(f, kote_file=kote_file)
                self.layers = indata.layers
                
                # Merge dictionaries containing features
                for d in (indata.feats_1st_pass,indata.feats_2nd_pass,indata.all_points):
                    self.features.update(d)
                
                                
                # Generate filename template for output
                if len(os.path.split(f)[-1])>2:
                    self.fname = '_'.join(os.path.split(f)[-1].split('.')[0:-1])
                
                else:
                    self.fname=os.path.split(f)[-1].split('.')[0]
                
                self.fname = self.fname.replace(' ', '_')
                
                # Call to feature builder method to construct geometries
                self.feature_builder()
                 
    def feature_builder(self):
        '''This method is used to construct geometries from points. Loops through
        features, constructs geometries and finally modifies features is either upoly 
        or spoly are found'''
        
        # Flag for modify features
        mod_feats = False
        
        # Loop through features
        for feat in self.features:
            #The current feature
            f = self.features[feat]
            
            #list to contain points
            pts = []
            
            # list to contain heights
            hts = []
            
            # append points as QGIS geometries
            for pt in f["points"]:
                pts.append(QgsPointXY(pt[0],pt[1])) 
                hts.append(pt[2])
                
                
            #calculate mean height
            hts = sum(hts)/len(hts)
                
            
            # Get feature type
            tp = f["code"]["type"]
            # get layer feature goes into
            l = f["code"]["layer"]
            
            # empty geometry
            geom = None
            
            geom_fejl = False
            
            # Pass point arrays to constructor methods depending on geometry type
            # deal with polygons
            if tp == "poly":
                if len(pts)>2:
                    geom = self.point2poly(pts)
                elif len(pts)==2:
                    geom = self.twopointpoly(pts)
                else:
                    geom = self.onepointfejlpoly(pts)
                    geom_fejl = True
                    
                    pass
            # deal with zig-zag polys
            elif tp == "zpoly":
                geom = self.zzpoly(pts)
            # deal with points
            elif tp == "point":
                geom = self.point2point(pts)
            # deal with poly lines
            elif tp == "pline":
                geom = self.point2pline(pts)
            # deal with cutouts from polys
            elif tp == "upoly":
                geom = self.point2poly(pts)
                mod_feats = True
            #Deal with superimpostion
            #Todo- implement method
            elif tp == "spoly":
                geom = self.point2poly(pts)
                mod_feats = True
            # If this layer is not in layers add it          
            if not l in self.layers:
                self.layers[l]={}
            # Set attribute   
            attr = f["attr"]  
            label = f["label"]
            # Output constructed features
            if not 'features' in self.layers[l].keys():
                self.layers[l]['features']={}
            if not l == 'AllePunkter':
                self.layers[l]['features'][feat]={"geom":geom,
                                                  "attr":attr,
                                                  "label":label,
                                                  'gf':geom_fejl,
                                                  'hts':hts}
                
                
                
            # Output all points
            
            #TODO set this so that AllePunkter is controlled by layer def.json
            #instead of this idiocy
            
            else:
                '''if not 'fields' in self.layers[l]:
                    self.layers[l]["fields"]=[QgsField("X", QVariant.Double),
                                                    QgsField("Y", QVariant.Double),
                                                    QgsField("Z", QVariant.Double),
                                                    QgsField("PtID", QVariant.String),
                                                    QgsField("Type", QVariant.String),
                                                    QgsField("FeatID", QVariant.String),
                                                    QgsField("Attr", QVariant.String)]
                    
                    self.layers[l]["field_mapping"]=[['X','X'],
                                                     ['Y','Y'],
                                                     ['Z','Z'],
                                                     ['PtID','PtID'],
                                                     ['Type','Type'],
                                                     ['FeatID','FeatID'],
                                                     ['Attr','Attr']]
                    
                    self.layers[l]['prefix']=''
                    '''
                    
                self.layers[l]['features'][feat]={"geom":geom,
                                                  "X":f['x'],
                                                  "Y":f['y'],
                                                  "Z":f['z'],
                                                  "PtID":f['punkt_id'],
                                                  "Type":f["type"],
                                                  "FeatID":f['Fid'],
                                                 "Attr":attr}

        for l in list(self.layers.keys()):
            if 'features' in self.layers[l] and l != 'AllePunkter':
                self.validator(l)
        
        # Modify features if true
        if mod_feats is True:
            self.mod_features()    
            
        
    def validator(self,
                  layer):
        '''Method intended to validate features and return a layer containing
        errors if there are any'''    
               
        # dict containing labels and features to find duplicate labels
        label_feat = {}
        
        #list containing features with no label
        empty = []
        
        #dict to conain geometry errors
        geometry_errors ={}
        
        #bool flags 
        dupes = False
        empties = False
        g_error = False
        
        
        #iterate through features
        
        for feat in self.layers[layer]['features']:
            #if 'geom' in self.layers[layer]['features'].keys():
            if len(self.layers[layer]['features'][feat]) > 0:
                if type(self.layers[layer]['features'][feat]) is dict:
                    if 'label' in self.layers[layer]['features'][feat]:
                        l = self.layers[layer]['features'][feat]["label"]
                        if l is not None and len(l)>0:
                            if not l in label_feat:
                                label_feat[l]=[feat]
                            else:
                                label_feat[l].append(feat)
                                dupes = True
                        else: 
                            empty.append(feat)
                            empties = True
                     
                    else: 
                        empty.append(feat)
                        empties = True
                        
                        
                    if not self.layers[layer]["type"] == 'point':
                        errors = self.layers[layer]['features'][feat]["geom"].validateGeometry()
                      
                        if self.layers[layer]['features'][feat]['gf'] is True:
                            errors.append('Polygon has only one point')                                
                      
                        if len(errors)>0:
                            geometry_errors[feat]=errors
                            g_error = True
                        
        if dupes is True or empties is True or g_error is True:
            lname = '%s_%s' %('FEJL',layer)
            
            if not lname in self.layers.keys():
                self.layers[lname]={}
                self.layers[lname]['features']={}
                self.layers[lname]['fields'] = self.layers[layer]['fields'].copy()+['QgsField("Duplicate_Nr", QVariant.String)',
                                                                             'QgsField("No_ID", QVariant.String)',
                                                                             'QgsField("Geometry_error", QVariant.String)']
                self.layers[lname]['field_mapping']= self.layers[layer]['field_mapping'].copy()+[['Duplicate_Nr','Duplicate_Nr'],
                                                                                                 ['No_ID','No_ID'],
                                                                                                 ['Geometry_error','Geometry_error']]
                
                self.layers[lname]['type']=self.layers[layer]['type']
                self.layers[lname]['prefix']=self.layers[layer]['prefix']
                
            if dupes is True:
                for l in label_feat:
                    if len(label_feat[l])>1:
                        for f in label_feat[l]:
                            if not f in self.layers[lname]['features'].keys():
                                self.layers[lname]['features'][f]={}
                                self.layers[lname]['features'][f]['geom']=self.layers[layer]['features'][f]['geom']
                                self.layers[lname]['features'][f]['attr']=self.layers[layer]['features'][f]['attr']
                                self.layers[lname]['features'][f]['label']=self.layers[layer]['features'][f]['label']
                                self.layers[lname]['features'][f]['hts']=self.layers[layer]['features'][f]['hts']

                            self.layers[lname]['features'][f]["Duplicate_Nr"] = 'Y'
                            
                            if not 'No_ID' in self.layers[lname]['features'][f].keys():
                                self.layers[lname]['features'][f]['No_ID']=''
                            if not 'Geometry_error' in self.layers[lname]['features'][f].keys():    
                                self.layers[lname]['features'][f]['Geometry_error']=''
                            
            
            if empties is True:
                for f in empty:
                    if not f is None:
                        if not f in self.layers[lname]['features'].keys():
                            self.layers[lname]['features'][f]={}
                            self.layers[lname]['features'][f]['geom']=self.layers[layer]['features'][f]['geom']
                            self.layers[lname]['features'][f]['attr']=self.layers[layer]['features'][f]['attr']
                            self.layers[lname]['features'][f]['label']=self.layers[layer]['features'][f]['label']
                            self.layers[lname]['features'][f]['hts']=self.layers[layer]['features'][f]['hts']
                        
                        self.layers[lname]['features'][f]['No_ID']='Y'
                        
                        if not 'Duplicate_Nr' in self.layers[lname]['features'][f].keys():
                            self.layers[lname]['features'][f]['Duplicate_Nr']=''
                        if not 'Geometry_error' in self.layers[lname]['features'][f].keys():    
                            self.layers[lname]['features'][f]['Geometry_error']=''
                            
            if g_error is True:
                if len(geometry_errors)>0:
                    for f in geometry_errors.keys():
                        if not f in self.layers[lname]['features'].keys():
                            self.layers[lname]['features'][f]={}
                            self.layers[lname]['features'][f]['geom']=self.layers[layer]['features'][f]['geom']
                            self.layers[lname]['features'][f]['attr']=self.layers[layer]['features'][f]['attr']
                            self.layers[lname]['features'][f]['label']=self.layers[layer]['features'][f]['label']
                            self.layers[lname]['features'][f]['hts']=self.layers[layer]['features'][f]['hts']
    
                        e = []
                        for g in geometry_errors[f]:
                            e.append(str(g))
                        self.layers[lname]['features'][f]['Geometry_error']=' '.join(e)
                        
                        if not 'Duplicate_Nr' in self.layers[lname]['features'][f].keys():
                            self.layers[lname]['features'][f]['Duplicate_Nr']=''
                        if not 'No_ID' in self.layers[lname]['features'][f].keys():    
                            self.layers[lname]['features'][f]['No_ID']=''
                        
            
    def mod_features(self):
        # Method for modifiying features based on intersecting geometries
        for l in self.layers:
            if self.layers[l]['type']=='upoly' or self.layers[l]['type']=='spoly':
                # Get the target layer
                target_key = l.split('_')[-1]
                target = self.layers[target_key]['features']
                # Use this layer as the modifer
                source = self.layers[l]['features']
                
                # loop through features and perofm a pairwise comparison
                for feat1 in target:
                    if not type(target[feat1]) is str:
                        f1_geom = target[feat1]['geom']
                        for feat2 in source: 
                            if not type(source[feat2]) is str:
                                f2_geom = source[feat2]['geom']
                                
                                # DO the two features intersect?
                                if f1_geom.intersects(f2_geom):
                                    #if so perform modification
                                    if self.layers[l]['type']=='upoly':
                                        f1_geom = f1_geom.difference(f2_geom)
                                        
                                    elif self.layers[l]['type']=='spoly':
                                        #Todo implement spoly method
                                        pass
                        '''After we've checked all geometries add the modifed 
                        geometry back to the original feature'''
                        self.layers['features'][target_key][feat1]['geom']=f1_geom
                                           
    def feat_export(self, 
                    odir, 
                    srs,
                    shp=True,
                    tab=False,
                    gp=False,
                    gjson=False):
        ''' Method to export features to different file formats'''
        
        # Driver name        
        dr_n = None
        # File extension
        dr_ext =None
        
        # list of output files
        o_list = []
        
        # Set driver based on checkboxes in dialog passed from FeltTegn.run()
        # Shapefile

        if shp is True:
            dr_n = "ESRI Shapefile"
            dr_ext=".shp"
        #Tab file
        elif tab is True:
            #dr_n = "MITAB"
            '''Note- MITAB doesn't work as driver name, although according to
            docs it should. Works now with "Mapinfo File" for whatever reason. 
            I don't know either'''
            print('TABTABTAB',tab)
            dr_n = "Mapinfo File"
            dr_ext=".tab"
        #Geopackage
        elif gp is True:
            dr_n = "GPKG"
            dr_ext=".gpkg"
        #GeoJSON
        elif gjson is True:
            dr_n = "GeoJSON"
            dr_ext=".geojson"
    
        else:
            raise Exception("No output format chosen")
        
        # Loop through layers
        for l in self.layers:
            print (l)
            if 'features' in self.layers[l].keys():
                print (self.layers[l]['field_mapping'])
                # Set filename
                name = "%s_%s" %(self.fname,l)
                #Set full output path
                ofname = os.path.join(odir,name+dr_ext)
                #Set up fields
                fields = QgsFields()
                
                if 'fields' in self.layers[l]:
                    for field in self.layers[l]['fields']:
                        if type(field) is QgsField:
                            fields.append(field)
                        else:
                            fields.append(eval(field))
               
                # Set geometry type
                if self.layers[l]['type']=='point':
                    gt=QgsWkbTypes.Point
                    gt = "Point"
                    
                elif self.layers[l]['type']=='pline':
                    gt=QgsWkbTypes.LineString
                    gt = "LineString"
                    
                elif self.layers[l]['type']== 'poly' or self.layers[l]['type']=='zpoly':
                    gt=QgsWkbTypes.Polygon
                    gt = "Polygon"
                
                '''Set coordiante system and geometry type as a string for the the 
                memory layer constructor. This is silly, but it's how it works'''
                gt = "%s?crs=%s" % (gt,srs.authid())  
                
                # Construct memory layer and add fields
                tmp_layer = QgsVectorLayer(gt, l, "memory") 
                pr = tmp_layer.dataProvider()
                pr.addAttributes(fields)
                tmp_layer.updateFields()
                
                # Add features to memory layer
                for feat in self.layers[l]['features'].keys():
                    self.layers[l]['features'][feat].update(self.props)
                    fet = QgsFeature()
                    fet.setGeometry(self.layers[l]['features'][feat]["geom"])
                    fet.setFields(fields)
                    
                    for f in fields:
                        n = f.name()
                        for fm in self.layers[l]['field_mapping']:
                            if n == fm[0]:
                                fet.setAttribute(fields.indexOf(n),self.layers[l]['features'][feat][fm[1]])    
                    

                    pr.addFeatures([fet])
                    tmp_layer.updateExtents()

                # Set transform context for output layer
                transform_context = QgsProject.instance().transformContext()
                #Instantiate a fiel writer class with attributes
                save_options = QgsVectorFileWriter.SaveVectorOptions()
                # Set driver
                save_options.driverName = dr_n
                # Set encoding
                save_options.fileEncoding = "UTF-8"
                # Allow overwrite
                save_options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteFile
                
                if tab is True:
                    '''Need to set bounds for MapInfo files. Buffers by 500m to 
                    avoid any potential rounding errors or issues with modifiying
                    the layers later'''
                    ext=tmp_layer.extent()
                   
                    xmax = ext.xMaximum()
                    ymax = ext.yMaximum()
                    xmin = ext.xMinimum()
                    ymin = ext.yMinimum()
                    
                    #save_options.fileEncoding = "ISO-8859-1"
                    
                    save_options.layerOptions = ['BOUNDS=%s,%s,%s,%s' %(xmin,ymin,xmax,ymax),
                                                 'ENCODING=ISO-8859-1']
                
                # Get Qgis Version
                q_version =int(Qgis.QGIS_VERSION.split('.')[1])
                
                #Export layers
                ''' check to see if layer i already loaded and if so remove from
                canvas- for some reason the newer version won't overwrite a file already
                loaded in the canvas (though it will happily do it in the filesystem'''
                
                for lyr in QgsProject.instance().mapLayers().values():
                    if lyr.name()==name:
                        QgsProject.instance().removeMapLayers([lyr.id()])
                        QgsProject.instance().reloadAllLayers()
                QgsProject.instance().reloadAllLayers()

                        
                        
                
                ''' Intention here is to use the QGIS version to set the behaviour 
                depending on how the version of Qgis handles file output, as early
                testing indicated incomaptiblity with version 3.10. However- seem to 
                fine with 3.10.3.
                
                2021-10-05
                Amended as writeAsVectorFormatV2 is apparently also now deprecated
                
                '''
                
                if q_version >= 20:
                    error = QgsVectorFileWriter.writeAsVectorFormatV3(tmp_layer,
                                                                       ofname,
                                                                       transform_context,
                                                                       save_options)
                    
                elif q_version >= 12:
                    error = QgsVectorFileWriter.writeAsVectorFormatV2(tmp_layer,
                                                                       ofname,
                                                                       transform_context,
                                                                       save_options)  
                    
                else:
                    print ('OLD METHOD!')
                    error = QgsVectorFileWriter.writeAsVectorFormat(layer=tmp_layer,
                                                                    fileName=ofname,
                                                                    options=save_options)
                                                                      
                            
                if error[0] == QgsVectorFileWriter.NoError:
                    print("success!")
                else:
                    print(error)
                 
                # Tidy up cos we cant trust GC
                del error
                del tmp_layer
                
                # Append to list of output files
                if not self.layers[l]['type']== 'upoly' or self.layers[l]['type']=='spoly':
                    o_list.append([ofname,l])
                
        return o_list       
        
    #******************** GENERIC METHODS *************************************
    ''' These are all the geometry constructors'''
    def point2poly(self,points):
        """ internal method to take geometry and spit out a polygon """
        ring = QgsGeometry.fromPolygonXY([points])     
        
        return ring
    
    def point2pline(self,points):
        """ internal method to take geometry and spit out a polyline """
        ln = QgsGeometry.fromPolylineXY(points)
        
        return ln
    
    def point2point(self,point):
        p1 = QgsGeometry.fromPointXY(point[0])
        
        return p1
 
    def zzpoly(self,points):
        """
        method for digitising polygons on long linear features such as trial
        trenches and drains in a 'zigzag' order.
        take points as list, then re-order alternating points by taking the left 
        and right sides by splitting the ist of points into odd and even indices, 
        then reversing the order of the evens and rejoining the two lists forming 
        a ring.
        """
        # extract the odd and even points from the list. 
        odds = points[0::2]
        evens = points[1::2] 
        # Reverse the order of the even points
        evens.reverse()
        #Join the lists
        pts = odds + evens
        # Create polygon
        poly = self.point2poly(pts)
        return poly
        
    def twopointpoly(self,points):
        """
        method spits out a circle from two points on perimiter of feature. 
        """
        # Generate a line geometry from the two points
        ln = self.point2pline(points)
        # Find the radius of the circle as half the line length  
        d = ln.length()/2
        #Find the centroid of the line
        c = ln.centroid()
        # Buffer around the centroid using the calculated radius
        poly = c.buffer(d,25)
        
        return poly
    
    def onepointfejlpoly(self,point):
         poly = QgsGeometry.fromPointXY(point[0]).buffer(0.25,25)
         
         return poly
    
class Artist():
    ''' Class orders layers and sets up symbology before we add them to the map canvas.'''
    # Todo- set this up to read a local symbol file 
    def __init__(self,
                 layer_def=None):
        
        self.layer_def = layer_def
        
        if self.layer_def is None:
            self.layer_def = LoadDefs().styles[0]
            


    def order_layers(self, out_layers):
        draw_list = []
        
        
        for layer in out_layers:
            l = layer[1]
            o = layer[0]
            if l in self.layer_def.keys():
                draw_list.append((o,l,self.layer_def[l]["do"],self.layer_def[l]["style"]))
            else:
                draw_list.append((o,l,self.layer_def["FallBack"]["do"],self.layer_def["FallBack"]["style"]))

        draw_list.sort(key=itemgetter(2))
            
        return draw_list
            
        
class MetaDataFile():
    def __init__(self):
        pass


            