# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QPandas
                                 A QGIS plugin
 Pandas utilities in QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-07
        copyright            : (C) 2020 by Matteo Ghetta (Faunalia)
        email                : matteo.ghetta@faunalia.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matteo Ghetta (Faunalia)'
__date__ = '2020-07-07'
__copyright__ = '(C) 2020 by Matteo Ghetta (Faunalia)'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QVariant

import numpy as np
import pandas as pd

from qgis.core import (
    QgsField,
    QgsFields
)


def convert_types(df):
    """
    Args:
        df ([pandas DataFrame]): Pandas DataFrame that contains the field types
        to be converted

    Returns:
        d [dictionary]: [python dictionary]
    """

    d = {}

    for col in df.columns:
        if df[col].dtype == np.int32:
            d[col] = QVariant.Int
        elif df[col].dtype == np.int64:
            d[col] = QVariant.Int
        elif df[col].dtype == np.float64:
            d[col] = QVariant.Double
        elif df[col].dtype == np.float32:
            d[col] = QVariant.Double
        else:
            d[col] = QVariant.String

    return d

def dataframe_from_layer(layer):
    """
    Args:
        layer (QgsVectorLayer): QgsVectorLayer that will be transformed into a
        pandas DataFrame

    Returns:
        df [pandas DataFrame]: [Pandas DataFrame]
    """

    # get field names used as column names in the Pandas DataFrame
    names = [f.name() for f in layer.fields()]

    # get attributes from features
    data = [i.attributes() for i in layer.getFeatures()]

    # create the DataFrame
    df = pd.DataFrame(data, columns=names)

    return df


def dataframe_to_fields(df):
    """Converts a pandas dataframe into a QgsFields object with names and types

    Args:
        df (pandas dataframe): pandas dataframe to convert

    Returns:
        layer (QgsFields): the final QgsFields structure
    """

    # from QVariant type to numpy types
    numpy_type_map = {
        np.dtype('bool'): QVariant.Bool, # boolean
        np.dtype('int'): QVariant.Int, # int
        np.dtype('int64'): QVariant.Int, #int64
        np.dtype('double'): QVariant.Double, # double
        np.dtype('str'):QVariant.String, # character
        np.dtype('object'): QVariant.String, # force string if datatype is read as object
        np.dtype('datetime64[D]'): QVariant.Date, # date
        np.dtype('datetime64[s]'): QVariant.Time, # time
        np.dtype('datetime64[s]'): QVariant.DateTime, # datetime
    }

    fields = QgsFields()

    for name, type in zip(df.columns, df.dtypes):
        fields.append(
            QgsField(name, numpy_type_map[type])
        )

    return fields