# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Grid2Tif
                                 A QGIS plugin
 Grid export to tif
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-06-11
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Milickij Alex
        email                : milickij@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QSize
from PyQt5.QtGui import *
from PyQt5.QtWidgets import QAction, QFileDialog, QWidget
from qgis.gui import *
from qgis.core import (
    QgsMapLayerModel,
    QgsMapLayerProxyModel,
    QgsProject,
    QgsMapSettings,
    QgsMapRendererJob, 
    QgsMapSettings,
    QgsMapRendererSequentialJob
)

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .export_tif_dialog import Grid2TifDialog
import os.path


class Grid2Tif:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Grid2Tif_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Grid2Tif')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Grid2Tif', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/export_tif/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Tif_MapInfo'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Grid2Tif'),
                action)
            self.iface.removeToolBarIcon(action)    

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Grid2TifDialog()

        def on_layer_changed(vlayer):                                    
            self.dlg.mFieldComboBox.setLayer(vlayer)

        vlayer=self.dlg.mMapLayerComboBox.currentLayer()
        self.dlg.mFieldComboBox.setLayer(vlayer)
        self.dlg.mMapLayerComboBox.layerChanged.connect(on_layer_changed)                                      

        def select_output_file():
            wid = QWidget()
            folderpath = QFileDialog.getExistingDirectory(wid, "Select folder")            
            self.dlg.mLineEditPath.setText(folderpath)

        self.dlg.pushButton.clicked.connect(select_output_file)        
        
        self.dlg.show()                                     

        # Run the dialog event loop
        result = self.dlg.exec_()                

        def saveTIFF(box, name, path):            
            options = QgsMapSettings()
            layers = QgsProject.instance().mapLayers().values()
            options.setLayers(layers)
            options.setBackgroundColor(QColor(255, 255, 255))
            options.setOutputSize(QSize(5000, 5000))
            options.setExtent(box)                
            render = QgsMapRendererSequentialJob(options)        
            render.start()
            render.waitForFinished()    
            img = render.renderedImage()    
            img.save(path+"/"+name+".tif","tif")   
        
        def saveMapInfo(box, name, path):
            xmin = box.xMinimum()
            xmax = box.xMaximum()
            ymin = box.yMinimum()
            ymax = box.yMaximum()
            textFilePath = path+"/"+name+".tab"
            f = open( textFilePath, 'wt', encoding='cp1251')
            line="!table\n"
            line+="!version 300\n"
            line+="!charset WindowsCyrillic\n"
            line+="\n"
            line+="Definition Table\n"
            line+="  File \""+name+".tif\"\n" 
            line+="  Type \"Raster\"\n"
            line+="  ("+str(xmin)+","+str(ymax)+") (0,0) Label \"L1\",\n"
            line+="  ("+str(xmin)+","+str(ymin)+") (0,5000) Label \"L2\",\n"
            line+="  ("+str(xmax)+","+str(ymax)+") (5000,0) Label \"L3\",\n"
            line+="  ("+str(xmax)+","+str(ymin)+") (5000,5000) Label \"L4\"\n"
            line+="  CoordSys NonEarth Units \"m\"\n"
            line+="  Units \"m\""   
            f.write(line)
            f.close()
        # See if OK was pressed
        if result:            
            currentField=self.dlg.mFieldComboBox.currentField()
            currentPath=self.dlg.mLineEditPath.text()

            layer = self.dlg.mMapLayerComboBox.currentLayer()
            selectionObject = layer.getSelectedFeatures()
            layer.removeSelection()
            
            for selObj in selectionObject:    
                box=selObj.geometry().boundingBox()                
                saveTIFF(box, selObj[currentField], currentPath)
                saveMapInfo(box, selObj[currentField], currentPath)            
                print("create: "+selObj[currentField])
            
            print("finished create files tiff+mapinfo")
            pass
