# Export 2KML

**Version:** 1.0.2  
**Author:** Mirjan Ali Sha  
**License:** MIT  

> 🌍 **Batch-export QGIS layers to Google Earth with full symbology preservation!**

Export 2KML is a powerful QGIS 3.x plugin that exports any combination of vector and raster layers into a single KML or KMZ file **with QGIS symbology fully preserved**. Your maps will look exactly the same in Google Earth!

---

## ✨ Key Features

| Feature                           | Description                                                |
| --------------------------------- | ---------------------------------------------------------- |
| **🎨 Full Symbology Preservation** | Colors, line widths, fills, patterns exported accurately   |
| **🖼️ Pattern/Complex Symbology**   | Renders as image for hatched fills, gradients, SVG markers |
| **📦 Batch Export**                | Export multiple vector and raster layers at once           |
| **⚙️ Per-Layer Settings**          | Fill transparency, stroke scale, label export per layer    |
| **🔲 Hollow Polygon Support**      | Outline-only polygons correctly detected and exported      |
| **📍 Right-Click Export**          | Quick export from Layer Panel context menu                 |
| **📊 Progress Tracking**           | Real-time export progress with vertex counts               |

---

## 📋 How to Use

### Quick Start
1. **Install** the plugin from QGIS Plugin Manager
2. **Add layers** to QGIS and style them as desired
3. **Export** using one of these methods:
   - 🔧 **Toolbar**: Click the Export 2KML icon in "MAS Vector Processing" toolbar
   - 📋 **Menu**: Vector → MAS Vector Processing → Export 2KML...
   - 🖱️ **Right-click**: Select layers in Layer Panel → Export Selected to KML

### Export Dialog Options

| Option                     | Description                                                           |
| -------------------------- | --------------------------------------------------------------------- |
| **Layer Selection**        | Check/uncheck layers to include in export                             |
| **Fill Mode**              | Auto (detect), Fill (force solid), Hollow (outline only)              |
| **Per-Layer Settings**     | Right-click row → Transparency, Stroke Scale, Labels, Render as Image |
| **KML Properties**         | Map layer fields to Name, Description, Timestamp, etc.                |
| **Selected Features Only** | Export only selected features from each layer                         |

### Advanced: Pattern/Complex Symbology
For layers with **hatched patterns, gradients, or complex symbology**:
1. Right-click the layer row in the Export dialog
2. Enable **"Render as Image"** option
3. The layer will be exported as a high-quality georeferenced PNG overlay

---

## 🔧 Requirements

- QGIS 3.0 or later

---

## 📝 Changelog

### v1.0.2 - Per-Layer Settings & Pattern Support
- ✨ NEW: Per-layer Fill Mode control (Auto/Fill/Hollow)
- ✨ NEW: Per-layer settings dialog (Transparency, Stroke Scale, Labels)
- ✨ NEW: "Render as Image" for complex symbology (patterns, gradients)
- 🔧 Fixed: Transparent background for image export
- 🔧 Fixed: Improved hollow polygon detection

### v1.0.1 - Hollow Polygon Fixes
- Added "Force Hollow Polygons" option
- Fixed transparent background for vector-as-image rendering
- Improved hollow detection (checks brushStyle and alpha)

### v1.0.0 - Complex Symbology & Layer Order
- New "Render Vectors as Images" for complex symbology preservation
- Layer order preserved (bottom-to-top processing)
- Fixed hollow polygon symbology

### v0.7 - Raster KMZ Export Fix
- Fixed raster export errors
- Large raster support (auto-scales to max 4096px)
- Progress feedback during raster processing

### v0.6 - Context Menu & Bug Fixes
- Added right-click context menu in Layer panel
- Fixed duplicate toolbar icons

### v0.5 - Symbology Preservation
- Added QGIS symbology preservation
- Supports Single Symbol, Categorized, and Graduated renderers
- StyleMap for normal/highlight states
- Custom Point Icons rendered to PNG

---

## 📧 Support & Feedback

- **Issues**: [GitHub Issues](https://github.com/Mirjan-Ali-Sha/export2kml/issues)
- **Email**: mastools.help@gmail.com
- **Wiki**: [GitHub Wiki](https://github.com/Mirjan-Ali-Sha/export2kml/wiki)

---

⭐ **If this plugin helps you, please rate it on the QGIS Plugin Repository!**

---

*MAS refers to "Mirjan Ali Sha"*
