# -*- coding: utf-8 -*-

from qgis.PyQt.QtWidgets import QDialog, QVBoxLayout, QHBoxLayout, QLabel, QPushButton, QTextEdit
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QFont

class VertexLimitDialog(QDialog):
    def __init__(self, parent, current_vertices, limit, current_layer_name):
        super().__init__(parent)
        self.choice = None
        self.setupUi(current_vertices, limit, current_layer_name)
        
    def setupUi(self, current_vertices, limit, current_layer_name):
        self.setWindowTitle("Vertex Limit Exceeded")
        self.setModal(True)
        self.resize(500, 350)
        
        layout = QVBoxLayout(self)
        
        # Warning message
        warning_label = QLabel("⚠️ Google Earth Vertex Limit Exceeded")
        warning_font = QFont()
        warning_font.setBold(True)
        warning_font.setPointSize(14)
        warning_label.setFont(warning_font)
        warning_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(warning_label)
        
        # Details
        details = QTextEdit()
        details.setReadOnly(True)
        details.setMaximumHeight(120)
        details.setPlainText(
            f"Current total vertices: {current_vertices:,}\n"
            f"Google Earth limit: {limit:,}\n"
            f"Exceeded by: {current_vertices - limit:,} vertices\n"
            f"Current layer: {current_layer_name}\n\n"
            f"Google Earth cannot import KML files with more than {limit:,} total vertices.\n"
            f"What would you like to do?"
        )
        layout.addWidget(details)
        
        # Option buttons
        button_layout = QVBoxLayout()
        
        # Stop button
        stop_btn = QPushButton("🛑 Stop Conversion")
        stop_btn.setStyleSheet("QPushButton { text-align: left; padding: 8px; }")
        stop_btn.clicked.connect(lambda: self.set_choice("stop"))
        button_layout.addWidget(stop_btn)
        
        stop_desc = QLabel("   Stop the conversion process. You can then unselect some layers/files to reduce vertex count.")
        stop_desc.setWordWrap(True)
        stop_desc.setStyleSheet("color: gray; margin-left: 20px; margin-bottom: 10px;")
        button_layout.addWidget(stop_desc)
        
        # Skip button
        skip_btn = QPushButton("⏭️ Skip Remaining")
        skip_btn.setStyleSheet("QPushButton { text-align: left; padding: 8px; }")
        skip_btn.clicked.connect(lambda: self.set_choice("skip"))
        button_layout.addWidget(skip_btn)
        
        skip_desc = QLabel("   Skip all remaining features but keep what has been processed so far. Creates a partial export.")
        skip_desc.setWordWrap(True)
        skip_desc.setStyleSheet("color: gray; margin-left: 20px; margin-bottom: 10px;")
        button_layout.addWidget(skip_desc)
        
        # Keep button
        keep_btn = QPushButton("✅ Keep All (Ignore Limit)")
        keep_btn.setStyleSheet("QPushButton { text-align: left; padding: 8px; }")
        keep_btn.clicked.connect(lambda: self.set_choice("keep"))
        button_layout.addWidget(keep_btn)
        
        keep_desc = QLabel("   Ignore the vertex limit and convert all selected data. The resulting file may fail to import in Google Earth.")
        keep_desc.setWordWrap(True)
        keep_desc.setStyleSheet("color: gray; margin-left: 20px; margin-bottom: 10px;")
        button_layout.addWidget(keep_desc)
        
        layout.addLayout(button_layout)
        
    def set_choice(self, choice):
        self.choice = choice
        self.accept()
