# -*- coding: utf-8 -*-

"""
/***************************************************************************
 EVCSPlugin
                                 A QGIS plugin
 Estimates possible locations for EV Charging Stations given relevant data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-17
        copyright            : (C) 2025 by Vishesh, Aashuthosh, Sarthak
        email                : aashuthoshsadashivasharma@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Vishesh, Aashuthosh, Sarthak'
__date__ = '2025-11-17'
__copyright__ = '(C) 2025 by Vishesh, Aashuthosh, Sarthak'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterVectorLayer,
                       QgsCoordinateReferenceSystem,
                       QgsProperty)
import processing


class EVCSPluginAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterNumber('consumer_weight', 'Consumer Weight', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=1, defaultValue=0.5))
        self.addParameter(QgsProcessingParameterVectorLayer('existingchargingstation', 'ExistingChargingStation', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('investor_weight', 'Investor Weight', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=1, defaultValue=0.5))
        self.addParameter(QgsProcessingParameterVectorLayer('primary_roads', 'primary_roads', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('secondary_roads', 'secondary_roads', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        # SubDistrict should contain PopulationDensity data and the average landPrice data as attributes in it
        # 
        self.addParameter(QgsProcessingParameterVectorLayer('subdistricts', 'SubDistricts', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Distancencs', 'DistanceNCS', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Finallayer', 'FinalLayer', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Coveragegaps', 'CoverageGaps', type=QgsProcessing.TypeVectorPolygon, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Roadside_candidate_points', 'Roadside_Candidate_Points', type=QgsProcessing.TypeVectorPoint, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Voronoivertices', 'VoronoiVertices', type=QgsProcessing.TypeVectorPoint, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Weighted_score_output', 'Weighted_Score_Output', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Candidate_points_with_pop', 'Candidate_Points_with_Pop', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Finallayer_2', 'FinalLayer', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Existingchargingstations', 'ExistingChargingStations', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Voronoidiagram', 'VoronoiDiagram', type=QgsProcessing.TypeVectorPolygon, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(38, model_feedback)
        results = {}
        outputs = {}

        # voronoi diagram
        alg_params = {
            'BUFFER': 0,
            'COPY_ATTRIBUTES': True,
            'INPUT': parameters['existingchargingstation'],
            'TOLERANCE': 0,
            'OUTPUT': parameters['Voronoidiagram']
        }
        outputs['VoronoiDiagram'] = processing.run('native:voronoipolygons', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Voronoidiagram'] = outputs['VoronoiDiagram']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Merge vector layers
        alg_params = {
            'ADD_SOURCE_FIELDS': False,
            'CRS': QgsCoordinateReferenceSystem('EPSG:32644'),
            'LAYERS': [parameters['primary_roads'],parameters['secondary_roads']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MergeVectorLayers'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['VoronoiDiagram']['OUTPUT'],
            'OUTPUT': parameters['Voronoivertices']
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Voronoivertices'] = outputs['ExtractVertices']['OUTPUT']

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Distance to nearest hub (points)
        alg_params = {
            'FIELD': 'id',
            'HUBS': parameters['existingchargingstation'],
            'INPUT': outputs['ExtractVertices']['OUTPUT'],
            'UNIT': 0,  # Meters
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DistanceToNearestHubPoints'] = processing.run('qgis:distancetonearesthubpoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # v.clean
        alg_params = {
            '-b': False,
            '-c': False,
            'GRASS_MIN_AREA_PARAMETER': 0.0001,
            'GRASS_OUTPUT_TYPE_PARAMETER': 0,  # auto
            'GRASS_REGION_PARAMETER': None,
            'GRASS_SNAP_TOLERANCE_PARAMETER': -1,
            'GRASS_VECTOR_DSCO': None,
            'GRASS_VECTOR_EXPORT_NOCAT': False,
            'GRASS_VECTOR_LCO': None,
            'input': outputs['MergeVectorLayers']['OUTPUT'],
            'threshold': '1',
            'tool': [0],  # break
            'type': [0,1,2,3,4,5,6],  # point,line,boundary,centroid,area,face,kernel
            'error': QgsProcessing.TEMPORARY_OUTPUT,
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Vclean'] = processing.run('grass:v.clean', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Circles with ID
        alg_params = {
            'FIELD_NAME': 'circle_id',
            'GROUP_FIELDS': [''],
            'INPUT': outputs['DistanceToNearestHubPoints']['OUTPUT'],
            'MODULUS': 0,
            'SORT_ASCENDING': True,
            'SORT_EXPRESSION': None,
            'SORT_NULLS_FIRST': False,
            'START': 0,
            'OUTPUT': parameters['Distancencs']
        }
        outputs['CirclesWithId'] = processing.run('native:addautoincrementalfield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Distancencs'] = outputs['CirclesWithId']['OUTPUT']

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Snap geometries to layer
        alg_params = {
            'BEHAVIOR': 0,  # Prefer aligning nodes, insert new vertices where required
            'INPUT': parameters['existingchargingstation'],
            'REFERENCE_LAYER': outputs['Vclean']['output'],
            'TOLERANCE': 30,
            'OUTPUT': parameters['Existingchargingstations']
        }
        outputs['SnapGeometriesToLayer'] = processing.run('native:snapgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Existingchargingstations'] = outputs['SnapGeometriesToLayer']['OUTPUT']

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': QgsProperty.fromExpression('"HubDist"/2'),
            'END_CAP_STYLE': 0,  # Round
            'INPUT': outputs['CirclesWithId']['OUTPUT'],
            'JOIN_STYLE': 0,  # Round
            'MITER_LIMIT': 2,
            'SEGMENTS': 20,
            'SEPARATE_DISJOINT': False,
            'OUTPUT': parameters['Coveragegaps']
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Coveragegaps'] = outputs['Buffer']['OUTPUT']

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Difference
        alg_params = {
            'GRID_SIZE': None,
            'INPUT': outputs['Buffer']['OUTPUT'],
            'OVERLAY': parameters['subdistricts'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Difference'] = processing.run('native:difference', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Intersected Layer
        alg_params = {
            'GRID_SIZE': None,
            'INPUT': outputs['Buffer']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': parameters['subdistricts'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': None,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['IntersectedLayer'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Intersect_with_Area
        alg_params = {
            'CALC_METHOD': 0,  # Ellipsoidal
            'INPUT': outputs['IntersectedLayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersect_with_area'] = processing.run('qgis:exportaddgeometrycolumns', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Field calculator
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'area',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '$area',
            'INPUT': outputs['Difference']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator_2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Intersect_with_Weighted_Pop
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'weighted_pop',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"population_den" * "area" / 1000000',
            'INPUT': outputs['Intersect_with_area']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersect_with_weighted_pop'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # Intersect_with_Weighted_Land_Value
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'Weighted_LandValue',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"avg_land_price" * "area" / 1000000',
            'INPUT': outputs['Intersect_with_weighted_pop']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersect_with_weighted_land_value'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # stats_from_outside
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'weighted_pop',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Integer
            'FORMULA': '("area" * 3596) / 1000000 ',
            'INPUT': outputs['FieldCalculator_2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Stats_from_outside'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # Aggregated_Stats
        alg_params = {
            'AGGREGATES': [{'aggregate': 'sum','delimiter': ',','input': 'weighted_pop','length': 0,'name': 'weighted_pop','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'aggregate': 'sum','delimiter': ',','input': 'area','length': 0,'name': 'area','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'aggregate': 'first_value','delimiter': ',','input': 'circle_id','length': 0,'name': 'circle_id','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'aggregate': 'first_value','delimiter': ',','input': 'HubDist','length': 0,'name': 'HubDist','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'aggregate': 'sum','delimiter': ',','input': 'Weighted_LandValue','length': 0,'name': 'Weighted_LandValue','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'GROUP_BY': 'circle_id',
            'INPUT': outputs['Intersect_with_weighted_land_value']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Aggregated_stats'] = processing.run('native:aggregate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # stats_from_outside2
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'Weighted_LandValue',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '7500 * "area" / 1000000',
            'INPUT': outputs['Stats_from_outside']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Stats_from_outside2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # merged_outer_inner_circle
        alg_params = {
            'ADD_SOURCE_FIELDS': False,
            'CRS': QgsCoordinateReferenceSystem('EPSG:32644'),
            'LAYERS': [outputs['Aggregated_stats']['OUTPUT'],outputs['Stats_from_outside2']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Merged_outer_inner_circle'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Aggregate
        alg_params = {
            'AGGREGATES': [{'aggregate': 'sum','delimiter': ',','input': 'weighted_pop','length': 0,'name': 'total_weighted_pop','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},{'aggregate': 'sum','delimiter': ',','input': 'area','length': 0,'name': 'total_area','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'aggregate': 'first_value','delimiter': ',','input': 'circle_id','length': 0,'name': 'circle_id','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'aggregate': 'first_value','delimiter': ',','input': 'HubDist','length': 0,'name': 'HubDist','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'aggregate': 'sum','delimiter': ',','input': 'Weighted_LandValue','length': 0,'name': 'total_weighted_land','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'GROUP_BY': 'circle_id',
            'INPUT': outputs['Merged_outer_inner_circle']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Aggregate'] = processing.run('native:aggregate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # AlmostFinalLayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Avg_Pop_Density',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"total_weighted_pop" / ( "total_area" / 1000000 )',
            'INPUT': outputs['Aggregate']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Almostfinallayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # AlmostFinalLayer2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Avg_Land_Value',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"total_weighted_land" / ( "total_area" / 1000000 )',
            'INPUT': outputs['Almostfinallayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Almostfinallayer2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # JoinedLayer
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'FIELD': 'circle_id',
            'FIELDS_TO_COPY': ['Avg_Pop_Density','Avg_Land_Value'],
            'FIELD_2': 'circle_id',
            'INPUT': outputs['CirclesWithId']['OUTPUT'],
            'INPUT_2': outputs['Almostfinallayer2']['OUTPUT'],
            'METHOD': 1,  # Take attributes of the first matching feature only (one-to-one)
            'PREFIX': None,
            'OUTPUT': parameters['Candidate_points_with_pop']
        }
        outputs['Joinedlayer'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Candidate_points_with_pop'] = outputs['Joinedlayer']['OUTPUT']

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Points along geometry
        alg_params = {
            'DISTANCE': 500,
            'END_OFFSET': 0,
            'INPUT': outputs['Vclean']['output'],
            'START_OFFSET': 0,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PointsAlongGeometry'] = processing.run('native:pointsalonglines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # Add ID to points along geometry
        alg_params = {
            'FIELD_NAME': 'id',
            'GROUP_FIELDS': [''],
            'INPUT': outputs['PointsAlongGeometry']['OUTPUT'],
            'MODULUS': 0,
            'SORT_ASCENDING': True,
            'SORT_EXPRESSION': None,
            'SORT_NULLS_FIRST': False,
            'START': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PointsAlongGeometryWithId'] = processing.run('native:addautoincrementalfield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Min_dist_to_road
        alg_params = {
            'FIELD': 'id',
            'HUBS': outputs['PointsAlongGeometryWithId']['OUTPUT'],
            'INPUT': outputs['Joinedlayer']['OUTPUT'],
            'UNIT': 0,  # Meters
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Min_dist_to_road'] = processing.run('qgis:distancetonearesthubpoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # Min_dist_to_road_2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'dist_road',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'attribute($currentfeature, \'HubDist\')',
            'INPUT': outputs['Min_dist_to_road']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Min_dist_to_road_2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # Snap geometries to layer
        alg_params = {
            'BEHAVIOR': 2,  # Move vertex
            'INPUT': outputs['Min_dist_to_road_2']['OUTPUT'],
            'REFERENCE_LAYER': outputs['PointsAlongGeometryWithId']['OUTPUT'],
            'TOLERANCE': 1000,
            'OUTPUT': parameters['Roadside_candidate_points']
        }
        outputs['SnapGeometriesToLayer_2'] = processing.run('native:snapgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Roadside_candidate_points'] = outputs['SnapGeometriesToLayer_2']['OUTPUT']

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Min_dist_to_existing
        alg_params = {
            'FIELD': 'id',
            'HUBS': parameters['existingchargingstation'],
            'INPUT': outputs['SnapGeometriesToLayer_2']['OUTPUT'],
            'UNIT': 0,  # Meters
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Min_dist_to_existing'] = processing.run('qgis:distancetonearesthubpoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # Min_dist_to_existing_2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'dist_existing',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'attribute($currentfeature, \'HubDist\')',
            'INPUT': outputs['Min_dist_to_existing']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Min_dist_to_existing_2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Normalise_pop_density
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'norm_pop_den',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'scale_linear("Avg_Pop_Density", minimum("Avg_Pop_Density"), maximum("Avg_Pop_Density"), 0, 1)',
            'INPUT': outputs['Min_dist_to_existing_2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Normalise_pop_density'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # Normalise_land_value
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'norm_land_val',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'scale_linear("Avg_Land_Value", minimum("Avg_Land_Value"), maximum("Avg_Land_Value"), 0, 1)',
            'INPUT': outputs['Normalise_pop_density']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Normalise_land_value'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Normalise_dist_road
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'norm_dist_road',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'scale_linear("dist_road", minimum("dist_road"), maximum("dist_road"), 0, 1)',
            'INPUT': outputs['Normalise_land_value']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Normalise_dist_road'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # Normalise_dist_existing
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'norm_dist_existing',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': 'scale_linear("dist_existing", minimum("dist_existing"), maximum("dist_existing"), 0, 1)',
            'INPUT': outputs['Normalise_dist_road']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Normalise_dist_existing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # Consumer_Score
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'consumer_score',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '("norm_pop_den" + (1 - "norm_dist_road"))/2',
            'INPUT': outputs['Normalise_dist_existing']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Consumer_score'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # Investor_Score
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'investor_score',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '((1 - "norm_land_val") + "norm_dist_existing")/2',
            'INPUT': outputs['Consumer_score']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Investor_score'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # Weighted_Score
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'weighted_score',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '((@consumer_weight * "consumer_score") + (@investor_weight * "investor_score"))/2',
            'INPUT': outputs['Investor_score']['OUTPUT'],
            'OUTPUT': parameters['Weighted_score_output']
        }
        outputs['Weighted_score'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Weighted_score_output'] = outputs['Weighted_score']['OUTPUT']

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '"weighted_score" > 0.3',
            'INPUT': outputs['Weighted_score']['OUTPUT'],
            'OUTPUT': parameters['Finallayer']
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Finallayer'] = outputs['ExtractByExpression']['OUTPUT']

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # FinalLayer
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT'],
            'CALC_METHOD': 0,  # Ellipsoidal
            'OUTPUT': parameters['Finallayer_2']
        }
        outputs['Finallayer'] = processing.run('qgis:exportaddgeometrycolumns', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Finallayer_2'] = outputs['Finallayer']['OUTPUT']
        return results

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'evcsmodel'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('EVCS Model')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('EVCS Plugin')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'evcsplugin'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return EVCSPluginAlgorithm()