# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EUMapper
                                 A QGIS plugin
 This plugin creates customized EU maps
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-12-23
        git sha              : $Format:%H$
        copyright            : (C) 2019 by The Map Workshop
        email                : themapworkshop@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis import *
from qgis.PyQt.QtGui import QColor
from PyQt5.QtWidgets import QApplication, QWidget, QMessageBox
from PyQt5.QtWidgets import *
from qgis.core import *
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .EU_Mapper_dialog import EUMapperDialog
import os.path
import sys


class EUMapper:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'EUMapper_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&EU Mapper')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('EUMapper', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/EU_Mapper/EUICON.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Generate EU Map'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&EU Mapper'),
                action)
            self.iface.removeToolBarIcon(action)
    def Population(self): #Function to display population map of the EU
        path = sys.path[3] + '/eu_mapper' #Define path to the location of the maps (shapefiles)
        os.chdir(path) #Go to the file location
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr') #Add the background map
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'Population of EU 2019', 'ogr') #Add the EU Map
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))  # Define color of background map
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'POP2019' #Define the target field inf the attribute table of the EU map
        myRangeList = [] #Define the intervals and their respective colors
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#00ff00"))
        myRange = QgsRendererRange(0.44, 5, symbol, '0.44 - 5 M')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#aa00ff"))
        myRange = QgsRendererRange(5, 10, symbol, '5 - 10 M')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#0055ff"))
        myRange = QgsRendererRange(10, 30, symbol, '10 - 30 M')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#ffaa00"))
        myRange = QgsRendererRange(30, 50, symbol, '30 - 50 M')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#e60000"))
        myRange = QgsRendererRange(50, 83.517, symbol, '50 - 83.52 M')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass #Similar steps as in the Population function will apply for the other functions
    def Populationd(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'EU Population Density 2019', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'Popd'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#00ff00"))
        myRange = QgsRendererRange(18, 50, symbol, '18 - 50 People/Km^2')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#aa00ff"))
        myRange = QgsRendererRange(50, 100, symbol, '50 - 100 People/Km^2')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#0055ff"))
        myRange = QgsRendererRange(100, 200, symbol, '100 - 200 People/Km^2')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#ffaa00"))
        myRange = QgsRendererRange(200, 500, symbol, '200 - 500 People/Km^2')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#e60000"))
        myRange = QgsRendererRange(500, 1400, symbol, '500 - 1376 People/Km^2')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass
    def BNPC(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'EU GDP per Capita 2017', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'GDP'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#61c17c"))
        myRange = QgsRendererRange(8197, 15000, symbol, '8197 - 15000 $')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#2a6847"))
        myRange = QgsRendererRange(15000, 50000, symbol, '15000 - 50000 $')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#6178c1"))
        myRange = QgsRendererRange(50000, 750000, symbol, '50000 - 75000 $')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#2a4368"))
        myRange = QgsRendererRange(750000, 100000, symbol, '75000 - 100000 $')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#00008b"))
        myRange = QgsRendererRange(100000, 105280, symbol, ' > 100000 $')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass
    def AverageSalary(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'EU Average Salary Net 2018', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'AVS'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#61c17c"))
        myRange = QgsRendererRange(457, 1000, symbol, '457 - 1000 €')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#2a6847"))
        myRange = QgsRendererRange(1000, 1500, symbol, '1000 - 1500 €')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#6178c1"))
        myRange = QgsRendererRange(1500, 2500, symbol, '1500 - 2500 €')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#2a4368"))
        myRange = QgsRendererRange(2500, 3000, symbol, '2500 - 3000 €')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#00008b"))
        myRange = QgsRendererRange(3000, 3270, symbol, ' > 3000 €')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass
    def LifeExpectancy(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'EU Life Expectancy 2016', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'AVA'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#010101"))
        myRange = QgsRendererRange(74.3, 78, symbol, '74.3 - 78 Years')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#880000"))
        myRange = QgsRendererRange(78, 80, symbol, '78 - 80 Years')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#00ee00"))
        myRange = QgsRendererRange(80, 82, symbol, '80 - 82 Years')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#008800"))
        myRange = QgsRendererRange(82, 83, symbol, '82 - 83 Years')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass
    def COEMISSIONS(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer(
            'TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer(
            'EU_COUNTRIES_BOUNDARIES.shp',
            'EU CO2 Emissions 2018', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'CO2E'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#041D3F"))
        myRange = QgsRendererRange(1.51, 10, symbol, ' < 10 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#326E7F"))
        myRange = QgsRendererRange(10, 50, symbol, '10 - 50 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#EB0F54"))
        myRange = QgsRendererRange(50, 100, symbol, '50 - 100 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#A89441"))
        myRange = QgsRendererRange(100, 300, symbol, '100 - 300 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#F5C222"))
        myRange = QgsRendererRange(300, 500, symbol, ' 300 - 500 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f5a622"))
        myRange = QgsRendererRange(500, 700, symbol, ' 500 - 700 MTon')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f55122"))
        myRange = QgsRendererRange(700, 752.65, symbol, ' > 700 MTon')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass
    def PlainEU(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        EU_LAG = self.iface.addVectorLayer('EU_COUNTRIES_BOUNDARIES.shp',
                                           'EU Countries', 'ogr')
        renderer = EU_LAG.renderer()
        symbol = renderer.symbol()
        symbol.setColor(QColor('#003399'))
        EU_LAG.triggerRepaint()
        pass


    def FIREPOWER(self):
        path = sys.path[3] + '/eu_mapper'
        os.chdir(path)
        Andet_Lag = self.iface.addVectorLayer('TM_WORLD_BORDERS-0.3.shp',
            'NON EU Countries', 'ogr')
        EU_LAG = self.iface.addVectorLayer('EU_COUNTRIES_BOUNDARIES.shp',
                                           'Global Firepower Index', 'ogr')
        renderer1 = Andet_Lag.renderer()
        symbol1 = renderer1.symbol()
        symbol1.setColor(QColor('#f7f7f7'))  
        #symbol1.setStrokeWidth(0)
        Andet_Lag.triggerRepaint()
        shp = EU_LAG
        myOpacity = 1
        target_field = 'FIRI'
        myRangeList = []
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#ececa3"))
        myRange = QgsRendererRange(1.5000, 2.0000, symbol, 'Very Bad (1.5000 - 2.0000)')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#b5e550"))
        myRange = QgsRendererRange(1.0000, 1.5, symbol, 'Bad (0.9999 - 1.5000)')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#abc32f"))
        myRange = QgsRendererRange(0.5000, 1.0000, symbol, 'Normal (0.5000 - 1.0000)')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#809c13"))
        myRange = QgsRendererRange(0.1000, 0.5000, symbol, 'Effective (0.1000 - 0.5000) ')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#607c3c"))
        myRange = QgsRendererRange(0.0001, 0.1000, symbol, 'Very Effective (0.0001 - 0.1000)')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        pass

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = EUMapperDialog()
            self.dlg.pushButton.clicked.connect(self.Population)
            self.dlg.pushButton_2.clicked.connect(self.Populationd)
            self.dlg.pushButton_3.clicked.connect(self.BNPC)
            self.dlg.pushButton_4.clicked.connect(self.AverageSalary)
            self.dlg.pushButton_5.clicked.connect(self.LifeExpectancy)
            self.dlg.pushButton_6.clicked.connect(self.COEMISSIONS)
            self.dlg.pushButton_7.clicked.connect(self.PlainEU)
            self.dlg.pushButton_8.clicked.connect(self.FIREPOWER)


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            #self.OpenEU()

            #pass
