"""Manage the tool"""
from qgis.gui import QgsMapTool
from qgis.core import Qgis, QgsMessageLog
from .coordinates import Coordinates
from .client import Client

class CaptureTool(QgsMapTool):
    def __init__(self, iface, client):
        QgsMapTool.__init__(self, iface.mapCanvas())
        self.canvas = iface.mapCanvas()
        self.iface = iface
        self.coord = Coordinates(self.canvas)
        self.client = client

    def canvasReleaseEvent(self, event):
        x = event.pos().x()
        y = event.pos().y()
        self.coord.set_canvas_project()
        self.coord.set_destination_crs()
        self.coord.set_x_transform()
        point = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
        self.coord.set_point_to_wgs84(point)
        self.coord.set_latitude_longitude_wgs84()

        self.client.set_search_url_xy(self.coord.latitude, self.coord.longitude)
        self.client.set_request()

    def activate(self):
        message = " click on map to see the oblique aerial photographs..."
        self.iface.messageBar().pushMessage('Info',
                                            message,
                                            level=Qgis.Info,
                                            )

    def deactivate(self):
        QgsMapTool.deactivate(self)
        self.deactivated.emit()
   
    def message_log(self, msg=""):
        QgsMessageLog.logMessage('{} {}'.format(self.__class__.__name__, msg), 'Estonian Oblique Aerial Photographs', Qgis.Info)