from qgis.core import (
    QgsCoordinateReferenceSystem,
    QgsCoordinateTransform,
    QgsProject,
    QgsWkbTypes,
    QgsPoint,
    QgsGeometry,
)

class Coordinates:

    def __init__(self, canvas):
        self.canvas = canvas
        self.longitude = 0.0
        self.latitude = 0.0
        self.project_canvas = ""
        self.destination_crs = ""
        self.point_project = []
        self.x_transform = ""

    def set_canvas_project(self):
        """Return the canvas of the project"""
        self.project_canvas = self.canvas.mapSettings().destinationCrs()
        return self.project_canvas

    def set_destination_crs(self):
        """Return the Geographical L-EST crs"""
        self.destination_crs = QgsCoordinateReferenceSystem.fromEpsgId(4935)
        return self.destination_crs

    def set_x_transform(self):
        """Return the x transform from project crs to destination crs"""
        self.x_transform = QgsCoordinateTransform(
        self.project_canvas,
        self.destination_crs,
        QgsProject.instance())
        return self.x_transform

    def set_latitude_longitude_wgs84(self):
        """Set the latitude and the longitude coordinates for project crs"""
        self.longitude = self.point_project[0]
        self.latitude = self.point_project[1]


    def set_point_to_wgs84(self, point):
        """Transform the destination crs point to the project crs"""
        self.point_project = self.x_transform.transform(point)
        return self.point_project