from qgis.PyQt.QtWidgets import QApplication
from qgis.PyQt.QtCore import QUrl, pyqtSignal, QEventLoop
from PyQt5 import Qt, QtCore, QtWidgets, QtGui, QtWebKit, QtWebKitWidgets
from qgis.PyQt.QtWebKitWidgets import QWebView
from qgis.core import Qgis, QgsMessageLog


class Client(QWebView):
    """Class for web requests"""

    def __init__(self):
        self.base_url = "https://fotoladu.maaamet.ee/etak.php?"
        self.url = ""
        self.error_message_connection = "Web request failed"

        QWebView.__init__(self)
        self.web_view = QWebView()

    def set_search_url_xy(self, x, y):
        """Sets the search url with coordinates from capture tool"""

        self.url = self.base_url \
                                    + 'B=' + str(x) + '&' + 'L=' + str(y)
        return self.url

    def set_request(self):
        """Open the url"""

        try:
            self.web_view.load(QUrl(self.url))
            self.web_view.show()
            self.web_view.activateWindow()
        except Exception as e:
            self.message_log(f'{self.error_message_connection}: {e}')
            return False

    def message_log(self, msg=""):
        QgsMessageLog.logMessage('{} {}'.format(self.__class__.__name__, msg), 'Estonian Oblique Aerial Photographs', Qgis.Warning)
