# Estonian Address search

QGIS plugin to search Estonian official addresses and cadastral units provided by [In-ADS API].

## Plugin

`Estonian Address Search` is available from the QGIS plugin repository. It provides a GUI with address search bar, settings window under _settings_ button and a toggle button for the reverse search by coordinates on clicking map.

## Utilization

For search addresses, simply write the desired address or cadastral unit's id in the plugin's search bar. To move to an address object on the map, select the address from the results.

It is also possible to select the address on the map by activating the toggle button _Click on the map to get the address_. The cursor will change to a cross and you can now click on the map to display the address of the location. Clicking again restores the normal cursor.

### Settings

Settings window enables:

- select between two different zoom controls: zoom or pan to an address object.
- select between general address search or address object type based search and include or exlude different data stores (e.g. buildings, streets..) addresses are searched from
- specify number of results being displayed
- choose whether only objects with uniqueness requirement are returned

## In-ADS service Documentation

For more information about In-ADS API, read the description of gazetteer service from developer manual: 

- [In-ADS et]
- [In-ADS en]

## References

This tool is inspired by [French Address] and some parts of code are taken from its [repo] with modifications.

## License & copyright

Licensed under the MIT License.

Copyright (C) 2024 [Estonian Land Board].

[Estonian Land Board]:https://maaamet.ee
[In-ADS API]: https://inaadress.maaamet.ee/
[In-ADS et]: https://inaadress.maaamet.ee/inaadress/js/pdf/et/in_aadress_developer_manual.pdf
[In-ADS en]: https://inaadress.maaamet.ee/inaadress/js/pdf/en/in_aadress_developer_manual.pdf
[French Address]: https://plugins.qgis.org/plugins/french_address/
[repo]: https://github.com/Gui0delp/french_address
