# -*- coding: utf-8 -*-
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsProcessingProvider
from .processing.AutoGridAlg import AutoGridAlg

class EstatMeshProvider(QgsProcessingProvider):
    def loadAlgorithms(self):
        self.addAlgorithm(AutoGridAlg())

    def id(self):
        return "estat_mesh_import"

    def name(self):
        return self.tr("e-Statメッシュ一括インポート")

    def tr(self, string):
        return QCoreApplication.translate("EstatMeshImport", string)

class EstatMeshImportPlugin:
    def __init__(self, iface):
        self.iface = iface
        self.provider = None

    def initProcessing(self):
        from qgis.core import QgsApplication
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.provider = EstatMeshProvider()
        self.initProcessing()

    def unload(self):
        from qgis.core import QgsApplication
        QgsApplication.processingRegistry().removeProvider(self.provider)
