# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ERA5DataReader
                                 A QGIS plugin
 This plugin loads and analyzes evaporation data from the Climate Data Store.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Elaf
        email                : s-elaf.seif@zewailcity.edu.eg
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from PyQt5.QtCore import QRegExp
from PyQt5.QtGui import QRegExpValidator
from PyQt5.QtGui import QDoubleValidator

from qgis.utils import iface
from qgis.core import QgsProject

from qgis.core import *
from qgis.gui import *
from qgis.utils import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *
# Initialize Qt resources from file resources.py
from .resources import *


import processing
from osgeo import gdal
import shutil

from PyQt5.QtWidgets import QApplication, QTableView, QAction, QFileDialog
import sys

# Import the code for the dialog
from .era5_data_reader_dialog import ERA5DataReaderDialog
from .era5_data_reader_dialog import HelpDialog
from .era5_data_reader_dialog import AboutDialog

import os.path

import numpy as np
from numpy import array
import matplotlib.pyplot as plt
import pandas as pd
import cdsapi
import re


class ERA5DataReader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ERA5DataReader_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&ERA5 Data Reader')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ERA5DataReader', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/era5_data_reader/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'ERA5 Data Reader'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&ERA5 Data Reader'),
                action)
            self.iface.removeToolBarIcon(action)

    def SelectAllMonths(self):
        self.dlg.January.setChecked(True)
        self.dlg.February.setChecked(True)
        self.dlg.March.setChecked(True)
        self.dlg.April.setChecked(True)
        self.dlg.May.setChecked(True)
        self.dlg.June.setChecked(True)
        self.dlg.July.setChecked(True)
        self.dlg.August.setChecked(True)
        self.dlg.September.setChecked(True)
        self.dlg.October.setChecked(True)
        self.dlg.November.setChecked(True)
        self.dlg.December.setChecked(True)

    def ClearAllMonths(self):
        self.dlg.January.setChecked(False)
        self.dlg.February.setChecked(False)
        self.dlg.March.setChecked(False)
        self.dlg.April.setChecked(False)
        self.dlg.May.setChecked(False)
        self.dlg.June.setChecked(False)
        self.dlg.July.setChecked(False)
        self.dlg.August.setChecked(False)
        self.dlg.September.setChecked(False)
        self.dlg.October.setChecked(False)
        self.dlg.November.setChecked(False)
        self.dlg.December.setChecked(False)

    def SelectAllDays(self):
        self.dlg.Day1.setChecked(True)
        self.dlg.Day2.setChecked(True)
        self.dlg.Day3.setChecked(True)
        self.dlg.Day4.setChecked(True)
        self.dlg.Day5.setChecked(True)
        self.dlg.Day6.setChecked(True)
        self.dlg.Day7.setChecked(True)
        self.dlg.Day8.setChecked(True)
        self.dlg.Day9.setChecked(True)
        self.dlg.Day10.setChecked(True)
        self.dlg.Day11.setChecked(True)
        self.dlg.Day12.setChecked(True)
        self.dlg.Day13.setChecked(True)
        self.dlg.Day14.setChecked(True)
        self.dlg.Day15.setChecked(True)
        self.dlg.Day16.setChecked(True)
        self.dlg.Day17.setChecked(True)
        self.dlg.Day18.setChecked(True)
        self.dlg.Day19.setChecked(True)
        self.dlg.Day20.setChecked(True)
        self.dlg.Day21.setChecked(True)
        self.dlg.Day21.setChecked(True)
        self.dlg.Day22.setChecked(True)
        self.dlg.Day23.setChecked(True)
        self.dlg.Day24.setChecked(True)
        self.dlg.Day25.setChecked(True)
        self.dlg.Day26.setChecked(True)
        self.dlg.Day27.setChecked(True)
        self.dlg.Day28.setChecked(True)
        self.dlg.Day29.setChecked(True)
        self.dlg.Day30.setChecked(True)
        self.dlg.Day31.setChecked(True)

    def ClearAllDays(self):
        self.dlg.Day1.setChecked(False)
        self.dlg.Day2.setChecked(False)
        self.dlg.Day3.setChecked(False)
        self.dlg.Day4.setChecked(False)
        self.dlg.Day5.setChecked(False)
        self.dlg.Day6.setChecked(False)
        self.dlg.Day7.setChecked(False)
        self.dlg.Day8.setChecked(False)
        self.dlg.Day9.setChecked(False)
        self.dlg.Day10.setChecked(False)
        self.dlg.Day11.setChecked(False)
        self.dlg.Day12.setChecked(False)
        self.dlg.Day13.setChecked(False)
        self.dlg.Day14.setChecked(False)
        self.dlg.Day15.setChecked(False)
        self.dlg.Day16.setChecked(False)
        self.dlg.Day17.setChecked(False)
        self.dlg.Day18.setChecked(False)
        self.dlg.Day19.setChecked(False)
        self.dlg.Day20.setChecked(False)
        self.dlg.Day21.setChecked(False)
        self.dlg.Day21.setChecked(False)
        self.dlg.Day22.setChecked(False)
        self.dlg.Day23.setChecked(False)
        self.dlg.Day24.setChecked(False)
        self.dlg.Day25.setChecked(False)
        self.dlg.Day26.setChecked(False)
        self.dlg.Day27.setChecked(False)
        self.dlg.Day28.setChecked(False)
        self.dlg.Day29.setChecked(False)
        self.dlg.Day30.setChecked(False)
        self.dlg.Day31.setChecked(False)

    def SelectAllTime(self):
        self.dlg.Time0.setChecked(True)
        self.dlg.Time1.setChecked(True)
        self.dlg.Time2.setChecked(True)
        self.dlg.Time3.setChecked(True)
        self.dlg.Time4.setChecked(True)
        self.dlg.Time5.setChecked(True)
        self.dlg.Time6.setChecked(True)
        self.dlg.Time7.setChecked(True)
        self.dlg.Time8.setChecked(True)
        self.dlg.Time9.setChecked(True)
        self.dlg.Time10.setChecked(True)
        self.dlg.Time11.setChecked(True)
        self.dlg.Time12.setChecked(True)
        self.dlg.Time13.setChecked(True)
        self.dlg.Time14.setChecked(True)
        self.dlg.Time15.setChecked(True)
        self.dlg.Time16.setChecked(True)
        self.dlg.Time17.setChecked(True)
        self.dlg.Time18.setChecked(True)
        self.dlg.Time19.setChecked(True)
        self.dlg.Time20.setChecked(True)
        self.dlg.Time21.setChecked(True)
        self.dlg.Time22.setChecked(True)
        self.dlg.Time23.setChecked(True)

    def ClearAllTime(self):
        self.dlg.Time0.setChecked(False)
        self.dlg.Time1.setChecked(False)
        self.dlg.Time2.setChecked(False)
        self.dlg.Time3.setChecked(False)
        self.dlg.Time4.setChecked(False)
        self.dlg.Time5.setChecked(False)
        self.dlg.Time6.setChecked(False)
        self.dlg.Time7.setChecked(False)
        self.dlg.Time8.setChecked(False)
        self.dlg.Time9.setChecked(False)
        self.dlg.Time10.setChecked(False)
        self.dlg.Time11.setChecked(False)
        self.dlg.Time12.setChecked(False)
        self.dlg.Time13.setChecked(False)
        self.dlg.Time14.setChecked(False)
        self.dlg.Time15.setChecked(False)
        self.dlg.Time16.setChecked(False)
        self.dlg.Time17.setChecked(False)
        self.dlg.Time18.setChecked(False)
        self.dlg.Time19.setChecked(False)
        self.dlg.Time20.setChecked(False)
        self.dlg.Time21.setChecked(False)
        self.dlg.Time22.setChecked(False)
        self.dlg.Time23.setChecked(False)

    def help_clicked(self):
        self.help.show()

    def about_clicked(self):
        self.about.show()

    def select_output_file(self):
        global filename
        filename = ""
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select   output file ","", '*.nc')
        self.dlg.LayerName.setText(filename)

    def change_month_text(self):
        self.dlg.selectonemonth.setText("At least one selection must be made")

    def clear_month_text(self):
        self.dlg.selectonemonth.clear()

    def change_day_text(self):
        self.dlg.selectoneday.setText("At least one selection must be made")

    def clear_day_text(self):
        self.dlg.selectoneday.clear()

    def change_time_text(self):
        self.dlg.selectonetime.setText("At least one selection must be made")

    def clear_time_text(self):
        self.dlg.selectonetime.clear()


    def run(self):
        """Run method that performs all the real work"""

        if self.first_start == True:
            self.first_start = False
            self.dlg = ERA5DataReaderDialog()
            self.help = HelpDialog()
            self.about = AboutDialog()
            self.dlg.pushButton.clicked.connect(self.select_output_file)
            self.dlg.About.clicked.connect(self.about_clicked)

            self.dlg.button_box.helpRequested.connect(self.help_clicked)

            self.dlg.SelectAllMonths.clicked.connect(self.SelectAllMonths)
            self.dlg.ClearAllMonths.clicked.connect(self.ClearAllMonths)

            self.dlg.SelectAllDays.clicked.connect(self.SelectAllDays)
            self.dlg.ClearAllDays.clicked.connect(self.ClearAllDays)

            self.dlg.SelectAllTime.clicked.connect(self.SelectAllTime)
            self.dlg.ClearAllTime.clicked.connect(self.ClearAllTime)

            self.dlg.SelectAllMonths.clicked.connect(self.clear_month_text)
            self.dlg.ClearAllMonths.clicked.connect(self.change_month_text)

            self.dlg.SelectAllDays.clicked.connect(self.clear_day_text)
            self.dlg.ClearAllDays.clicked.connect(self.change_day_text)

            self.dlg.SelectAllTime.clicked.connect(self.clear_time_text)
            self.dlg.ClearAllTime.clicked.connect(self.change_time_text)

            self.dlg.January.stateChanged.connect(self.clear_month_text)
            self.dlg.February.stateChanged.connect(self.clear_month_text)
            self.dlg.March.stateChanged.connect(self.clear_month_text)
            self.dlg.April.stateChanged.connect(self.clear_month_text)
            self.dlg.May.stateChanged.connect(self.clear_month_text)
            self.dlg.June.stateChanged.connect(self.clear_month_text)
            self.dlg.July.stateChanged.connect(self.clear_month_text)
            self.dlg.August.stateChanged.connect(self.clear_month_text)
            self.dlg.September.stateChanged.connect(self.clear_month_text)
            self.dlg.October.stateChanged.connect(self.clear_month_text)
            self.dlg.November.stateChanged.connect(self.clear_month_text)
            self.dlg.December.stateChanged.connect(self.clear_month_text)

            self.dlg.Day1.stateChanged.connect(self.clear_day_text)
            self.dlg.Day2.stateChanged.connect(self.clear_day_text)
            self.dlg.Day3.stateChanged.connect(self.clear_day_text)
            self.dlg.Day4.stateChanged.connect(self.clear_day_text)
            self.dlg.Day5.stateChanged.connect(self.clear_day_text)
            self.dlg.Day6.stateChanged.connect(self.clear_day_text)
            self.dlg.Day7.stateChanged.connect(self.clear_day_text)
            self.dlg.Day8.stateChanged.connect(self.clear_day_text)
            self.dlg.Day9.stateChanged.connect(self.clear_day_text)
            self.dlg.Day10.stateChanged.connect(self.clear_day_text)
            self.dlg.Day11.stateChanged.connect(self.clear_day_text)
            self.dlg.Day12.stateChanged.connect(self.clear_day_text)
            self.dlg.Day13.stateChanged.connect(self.clear_day_text)
            self.dlg.Day14.stateChanged.connect(self.clear_day_text)
            self.dlg.Day15.stateChanged.connect(self.clear_day_text)
            self.dlg.Day16.stateChanged.connect(self.clear_day_text)
            self.dlg.Day17.stateChanged.connect(self.clear_day_text)
            self.dlg.Day18.stateChanged.connect(self.clear_day_text)
            self.dlg.Day19.stateChanged.connect(self.clear_day_text)
            self.dlg.Day20.stateChanged.connect(self.clear_day_text)
            self.dlg.Day21.stateChanged.connect(self.clear_day_text)
            self.dlg.Day22.stateChanged.connect(self.clear_day_text)
            self.dlg.Day23.stateChanged.connect(self.clear_day_text)
            self.dlg.Day24.stateChanged.connect(self.clear_day_text)
            self.dlg.Day25.stateChanged.connect(self.clear_day_text)
            self.dlg.Day26.stateChanged.connect(self.clear_day_text)
            self.dlg.Day27.stateChanged.connect(self.clear_day_text)
            self.dlg.Day28.stateChanged.connect(self.clear_day_text)
            self.dlg.Day29.stateChanged.connect(self.clear_day_text)
            self.dlg.Day30.stateChanged.connect(self.clear_day_text)
            self.dlg.Day31.stateChanged.connect(self.clear_day_text)

            self.dlg.Time0.stateChanged.connect(self.clear_time_text)
            self.dlg.Time1.stateChanged.connect(self.clear_time_text)
            self.dlg.Time2.stateChanged.connect(self.clear_time_text)
            self.dlg.Time3.stateChanged.connect(self.clear_time_text)
            self.dlg.Time4.stateChanged.connect(self.clear_time_text)
            self.dlg.Time5.stateChanged.connect(self.clear_time_text)
            self.dlg.Time6.stateChanged.connect(self.clear_time_text)
            self.dlg.Time7.stateChanged.connect(self.clear_time_text)
            self.dlg.Time8.stateChanged.connect(self.clear_time_text)
            self.dlg.Time9.stateChanged.connect(self.clear_time_text)
            self.dlg.Time10.stateChanged.connect(self.clear_time_text)
            self.dlg.Time11.stateChanged.connect(self.clear_time_text)
            self.dlg.Time12.stateChanged.connect(self.clear_time_text)
            self.dlg.Time13.stateChanged.connect(self.clear_time_text)
            self.dlg.Time14.stateChanged.connect(self.clear_time_text)
            self.dlg.Time15.stateChanged.connect(self.clear_time_text)
            self.dlg.Time16.stateChanged.connect(self.clear_time_text)
            self.dlg.Time17.stateChanged.connect(self.clear_time_text)
            self.dlg.Time18.stateChanged.connect(self.clear_time_text)
            self.dlg.Time19.stateChanged.connect(self.clear_time_text)
            self.dlg.Time20.stateChanged.connect(self.clear_time_text)
            self.dlg.Time21.stateChanged.connect(self.clear_time_text)
            self.dlg.Time22.stateChanged.connect(self.clear_time_text)
            self.dlg.Time23.stateChanged.connect(self.clear_time_text)


        self.dlg.selectonemonth.clear()
        self.dlg.selectoneday.clear()
        self.dlg.selectonetime.clear()

        #Set validator for years
        regexYear = QRegExp("[0-9_\s]+")
        validatorYear = QRegExpValidator(regexYear)
        self.dlg.Year.setValidator(validatorYear)

        #Set validator for coordinates
        validatorNorth = QDoubleValidator(-90, 90, 2)
        validatorNorth.setNotation(QDoubleValidator.StandardNotation)

        validatorWest = QDoubleValidator(-180, 180, 2)
        validatorWest.setNotation(QDoubleValidator.StandardNotation)

        validatorSouth = QDoubleValidator(-90, 90, 2)
        validatorSouth.setNotation(QDoubleValidator.StandardNotation)

        validatorEast = QDoubleValidator(-180, 180, 2)
        validatorEast.setNotation(QDoubleValidator.StandardNotation)

        self.dlg.NorthCoordinate.setValidator(validatorNorth)
        self.dlg.WestCoordinate.setValidator(validatorWest)
        self.dlg.SouthCoordinate.setValidator(validatorSouth)
        self.dlg.EastCoordinate.setValidator(validatorEast)


        self.dlg.show()


        result = self.dlg.exec_()


        Years = list()
        Months = list()
        Days = list()
        Time = list()
        Area = list()

        if result:
            #Append selected checkboxes in the corresponding list
            if self.dlg.January.isChecked():
                Months.append ('01')
            if self.dlg.February.isChecked():
                Months.append ('02')
            if self.dlg.March.isChecked():
                Months.append ('03')
            if self.dlg.April.isChecked():
                Months.append ('04')
            if self.dlg.May.isChecked():
                Months.append ('05')
            if self.dlg.June.isChecked():
                Months.append ('06')
            if self.dlg.July.isChecked():
                Months.append ('07')
            if self.dlg.August.isChecked():
                Months.append ('08')
            if self.dlg.September.isChecked():
                Months.append ('09')
            if self.dlg.October.isChecked():
                Months.append ('10')
            if self.dlg.November.isChecked():
                Months.append ('11')
            if self.dlg.December.isChecked():
                Months.append ('12')


            if self.dlg.Day1.isChecked():
                Days.append ('01')
            if self.dlg.Day2.isChecked():
                Days.append ('02')
            if self.dlg.Day3.isChecked():
                Days.append ('03')
            if self.dlg.Day4.isChecked():
                Days.append ('04')
            if self.dlg.Day5.isChecked():
                Days.append ('05')
            if self.dlg.Day6.isChecked():
                Days.append ('06')
            if self.dlg.Day7.isChecked():
                Days.append ('07')
            if self.dlg.Day8.isChecked():
                Days.append ('08')
            if self.dlg.Day9.isChecked():
                Days.append ('09')
            if self.dlg.Day10.isChecked():
                Days.append ('10')
            if self.dlg.Day11.isChecked():
                Days.append ('11')
            if self.dlg.Day12.isChecked():
                Days.append ('12')
            if self.dlg.Day13.isChecked():
                Days.append ('13')
            if self.dlg.Day14.isChecked():
                Days.append ('14')
            if self.dlg.Day15.isChecked():
                Days.append ('15')
            if self.dlg.Day16.isChecked():
                Days.append ('16')
            if self.dlg.Day17.isChecked():
                Days.append ('17')
            if self.dlg.Day18.isChecked():
                Days.append ('18')
            if self.dlg.Day19.isChecked():
                Days.append ('19')
            if self.dlg.Day20.isChecked():
                Days.append ('20')
            if self.dlg.Day21.isChecked():
                Days.append ('21')
            if self.dlg.Day22.isChecked():
                Days.append ('22')
            if self.dlg.Day23.isChecked():
                Days.append ('23')
            if self.dlg.Day24.isChecked():
                Days.append ('24')
            if self.dlg.Day25.isChecked():
                Days.append ('25')
            if self.dlg.Day26.isChecked():
                Days.append ('26')
            if self.dlg.Day27.isChecked():
                Days.append ('27')
            if self.dlg.Day28.isChecked():
                Days.append ('28')
            if self.dlg.Day29.isChecked():
                Days.append ('29')
            if self.dlg.Day30.isChecked():
                Days.append ('30')
            if self.dlg.Day31.isChecked():
                Days.append ('31')


            if self.dlg.January.isChecked():
                Months.append ('01')
            if self.dlg.February.isChecked():
                Months.append ('02')
            if self.dlg.March.isChecked():
                Months.append ('03')
            if self.dlg.April.isChecked():
                Months.append ('04')
            if self.dlg.May.isChecked():
                Months.append ('05')
            if self.dlg.June.isChecked():
                Months.append ('06')
            if self.dlg.July.isChecked():
                Months.append ('07')
            if self.dlg.August.isChecked():
                Months.append ('08')
            if self.dlg.September.isChecked():
                Months.append ('09')
            if self.dlg.October.isChecked():
                Months.append ('10')
            if self.dlg.November.isChecked():
                Months.append ('11')
            if self.dlg.December.isChecked():
                Months.append ('12')


            if self.dlg.Time0.isChecked():
                Time.append ('00:00')
            if self.dlg.Time1.isChecked():
                Time.append ('01:00')
            if self.dlg.Time2.isChecked():
                Time.append ('02:00')
            if self.dlg.Time3.isChecked():
                Time.append ('03:00')
            if self.dlg.Time4.isChecked():
                Time.append ('04:00')
            if self.dlg.Time5.isChecked():
                Time.append ('05:00')
            if self.dlg.Time6.isChecked():
                Time.append ('06:00')
            if self.dlg.Time7.isChecked():
                Time.append ('07:00')
            if self.dlg.Time8.isChecked():
                Time.append ('08:00')
            if self.dlg.Time9.isChecked():
                Time.append ('09:00')
            if self.dlg.Time10.isChecked():
                Time.append ('10:00')
            if self.dlg.Time11.isChecked():
                Time.append ('11:00')
            if self.dlg.Time12.isChecked():
                Time.append ('12:00')
            if self.dlg.Time13.isChecked():
                Time.append ('13:00')
            if self.dlg.Time14.isChecked():
                Time.append ('14:00')
            if self.dlg.Time15.isChecked():
                Time.append ('15:00')
            if self.dlg.Time16.isChecked():
                Time.append ('16:00')
            if self.dlg.Time17.isChecked():
                Time.append ('17:00')
            if self.dlg.Time18.isChecked():
                Time.append ('18:00')
            if self.dlg.Time19.isChecked():
                Time.append ('19:00')
            if self.dlg.Time20.isChecked():
                Time.append ('20:00')
            if self.dlg.Time21.isChecked():
                Time.append ('21:00')
            if self.dlg.Time22.isChecked():
                Time.append ('22:00')
            if self.dlg.Time23.isChecked():
                Time.append ('23:00')

            #Append years in a list
            for Y in self.dlg.Year.text().split(' '):
                Years.append(Y)

            #Append coordinates in a list
            for North in self.dlg.NorthCoordinate.text().split(' '):
                NorthInt = float(North)
                Area.append(NorthInt)
            for West in self.dlg.WestCoordinate.text().split(' '):
                WestInt = float(West)
                Area.append(WestInt)
            for South in self.dlg.SouthCoordinate.text().split(' '):
                SouthInt = float(South)
                Area.append(SouthInt)
            for East in self.dlg.EastCoordinate.text().split(' '):
                EastInt = float(East)
                Area.append(EastInt)

            try:
                if filename == "":
                    Layer_Name = self.dlg.LayerName.text()
                    pn = QgsProject.instance().readPath("./")
                    sl = '/'
                    fn = Layer_Name+".nc"
                    selectpath = False
                else:
                    originalpath = QgsProject.instance().readPath("./")
                    Layer_Name = re.findall('(^.*).nc', self.dlg.LayerName.text())[0]
                    pn = re.findall('^.*/', self.dlg.LayerName.text())[0]
                    sl = '/'
                    fn = re.findall('^.*/(\S+)', self.dlg.LayerName.text())[0]
                    selectpath = True
            except:
                    Layer_Name = self.dlg.LayerName.text()
                    pn = QgsProject.instance().readPath("./")
                    sl = '/'
                    fn = Layer_Name+".nc"
                    selectpath = False

            #Download evaporation data through the API
            c = cdsapi.Client()
            c.retrieve(
                'reanalysis-era5-single-levels',
                {
                    'product_type': 'reanalysis',
                    'variable': 'mean_evaporation_rate',
                    'year': Years,
                    'month': Months,
                    'day': Days,
                    'time': Time,
                    'area': Area,
                    'format': 'netcdf',
                },
                fn)

            if selectpath == True:
                original = originalpath + sl + fn
                target = pn + sl + fn
                shutil.move(original, target)
                rlayer = iface.addRasterLayer(target, '')
                nbands = rlayer.bandCount()

            else:
                rlayer = iface.addRasterLayer(pn+sl+fn, '')
                nbands = rlayer.bandCount()

            #Show download success message
            self.iface.messageBar().pushMessage(
              "Success", "Output file downloaded at " + pn+fn,
              level=Qgis.Success, duration=8)

            #Append band values in an array
            wd = rlayer.width()
            ht = rlayer.height()
            values=[]
            provider= rlayer.dataProvider()
            for aband in range(rlayer.bandCount()):
                block = provider.block(aband+1,rlayer.extent(),wd,ht)
                for i in range(rlayer.width()):
                    for j in range(rlayer.height()):
                        values.append(block.value(i,j))
            arr = np.reshape(array(values),(-1,wd,ht))

            arrnew = np.moveaxis(arr,0,-1)

            arrnew = -arrnew *60 *60

            #Carry out statistical anaylysis and place each parameter for each pixel in an array
            arrsum = []
            arravg = []
            arrmax = []
            arrmin = []
            for arr1 in arrnew:
                for arr2 in arr1:
                    arrsum.append(np.sum(arr2))
                    arravg.append(np.average(arr2))
                    arrmax.append(np.max(arr2))
                    arrmin.append(np.min(arr2))
            rearrsum = np.reshape(array(arrsum), (rlayer.width(),rlayer.height()))

            #Create arrays for row and column count
            arrrow = []
            arrcol = []
            ro = -1
            p = wd * ht
            while len(arrrow) < p:
                ro = ro + 1
                co = -1
                for r in range(wd):
                    arrrow.append(ro)
                    co = co + 1
                    arrcol.append(co)

            #Append array values into a dataframe
            dfrow = pd.DataFrame(arrrow, columns = ["Row"])
            dfcol = pd.DataFrame(arrcol, columns = ["Column"])
            dfsum = pd.DataFrame(arrsum, columns = ["Sum"])
            dfavg = pd.DataFrame(arravg, columns = ["Average"])
            dfmax = pd.DataFrame(arrmax, columns = ["Max"])
            dfmin = pd.DataFrame(arrmin, columns = ["Min"])

            df1 = pd.merge(dfrow, dfcol, how = "outer", left_index= True, right_index = True)
            df2 = pd.merge(df1, dfsum, how = "outer", left_index= True, right_index = True)
            df3 = pd.merge(df2, dfavg, how = "outer", left_index= True, right_index = True)
            df4 = pd.merge(df3, dfmax, how = "outer", left_index= True, right_index = True)
            dfin = pd.merge(df4, dfmin, how = "outer", left_index= True, right_index = True)

            #Create point vector layer having statistical data
            alg_params = {
                'FIELD_NAME': 'VALUE',
                'INPUT_RASTER': rlayer,
                'RASTER_BAND': 1,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            vlay = processing.run('qgis:pixelstopoints', alg_params)
            vlayer = vlay['OUTPUT']

            vlayer.startEditing()
            for head in dfin :
                myField = QgsField( head, QVariant.Double )
                vlayer.addAttribute(myField)

            provider= rlayer.dataProvider()
            band1 = []
            for i in range(rlayer.height()):
                for j in range(rlayer.width()):
                    block = provider.block(1,rlayer.extent(),rlayer.width(),rlayer.height())
                    band1.append(block.value(i,j))

            x = 0
            for feature in vlayer.getFeatures():
                att = feature.attributes()[0]
                if att == band1[x]:
                    feature[1] = int(dfin.iloc[x]['Row'])
                    feature[2] = int(dfin.iloc[x]['Column'])
                    feature[3] = str(dfin.iloc[x]['Sum'])
                    feature[4] = str(dfin.iloc[x]['Average'])
                    feature[5] = str(dfin.iloc[x]['Max'])
                    feature[6] = str(dfin.iloc[x]['Min'])

                    vlayer.updateFeature(feature)
                x = x + 1
            vlayer.commitChanges()
            vlayer.dataProvider().deleteAttributes([0])
            vlayer.updateFields()
            QgsProject.instance().addMapLayer(vlayer)

            #Show vector points layer success message
            self.iface.messageBar().pushMessage(
              "Success", "Vector points layer loaded.",
              level=Qgis.Success, duration=4)

        #Reset conditions
        self.dlg.Year.clear()
        self.dlg.LayerName.clear()
        self.dlg.NorthCoordinate.clear()
        self.dlg.WestCoordinate.clear()
        self.dlg.SouthCoordinate.clear()
        self.dlg.EastCoordinate.clear()

        self.dlg.selectonemonth.clear()
        self.dlg.selectoneday.clear()
        self.dlg.selectonetime.clear()

        self.dlg.January.setChecked(False)
        self.dlg.February.setChecked(False)
        self.dlg.March.setChecked(False)
        self.dlg.April.setChecked(False)
        self.dlg.May.setChecked(False)
        self.dlg.June.setChecked(False)
        self.dlg.July.setChecked(False)
        self.dlg.August.setChecked(False)
        self.dlg.September.setChecked(False)
        self.dlg.October.setChecked(False)
        self.dlg.November.setChecked(False)
        self.dlg.December.setChecked(False)

        self.dlg.Day1.setChecked(False)
        self.dlg.Day2.setChecked(False)
        self.dlg.Day3.setChecked(False)
        self.dlg.Day4.setChecked(False)
        self.dlg.Day5.setChecked(False)
        self.dlg.Day6.setChecked(False)
        self.dlg.Day7.setChecked(False)
        self.dlg.Day8.setChecked(False)
        self.dlg.Day9.setChecked(False)
        self.dlg.Day10.setChecked(False)
        self.dlg.Day11.setChecked(False)
        self.dlg.Day12.setChecked(False)
        self.dlg.Day13.setChecked(False)
        self.dlg.Day14.setChecked(False)
        self.dlg.Day15.setChecked(False)
        self.dlg.Day16.setChecked(False)
        self.dlg.Day17.setChecked(False)
        self.dlg.Day18.setChecked(False)
        self.dlg.Day19.setChecked(False)
        self.dlg.Day20.setChecked(False)
        self.dlg.Day21.setChecked(False)
        self.dlg.Day21.setChecked(False)
        self.dlg.Day22.setChecked(False)
        self.dlg.Day23.setChecked(False)
        self.dlg.Day24.setChecked(False)
        self.dlg.Day25.setChecked(False)
        self.dlg.Day26.setChecked(False)
        self.dlg.Day27.setChecked(False)
        self.dlg.Day28.setChecked(False)
        self.dlg.Day29.setChecked(False)
        self.dlg.Day30.setChecked(False)
        self.dlg.Day31.setChecked(False)

        self.dlg.Time0.setChecked(False)
        self.dlg.Time1.setChecked(False)
        self.dlg.Time2.setChecked(False)
        self.dlg.Time3.setChecked(False)
        self.dlg.Time4.setChecked(False)
        self.dlg.Time5.setChecked(False)
        self.dlg.Time6.setChecked(False)
        self.dlg.Time7.setChecked(False)
        self.dlg.Time8.setChecked(False)
        self.dlg.Time9.setChecked(False)
        self.dlg.Time10.setChecked(False)
        self.dlg.Time11.setChecked(False)
        self.dlg.Time12.setChecked(False)
        self.dlg.Time13.setChecked(False)
        self.dlg.Time14.setChecked(False)
        self.dlg.Time15.setChecked(False)
        self.dlg.Time16.setChecked(False)
        self.dlg.Time17.setChecked(False)
        self.dlg.Time18.setChecked(False)
        self.dlg.Time19.setChecked(False)
        self.dlg.Time20.setChecked(False)
        self.dlg.Time21.setChecked(False)
        self.dlg.Time22.setChecked(False)
        self.dlg.Time23.setChecked(False)
