from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication  
from qgis.PyQt.QtGui import QIcon  
from qgis.PyQt.QtWidgets import QAction, QFileDialog  
from qgis.core import QgsProject, Qgis
from qgis.core import *
from qgis.PyQt.QtWidgets import QButtonGroup   

from qgis.core import (
    QgsMessageLog,
    QgsGeometry,
)

from qgis.gui import (
    QgsMessageBar,
)

from qgis.PyQt.QtWidgets import (
    QSizePolicy,
    QPushButton,
    QDialog,
    QGridLayout,
    QDialogButtonBox,
)

from .equi_processing_voronoiTestpy import processLB
# Initialize Qt resources from file equi_processing.resources.py  
from .resources import *  
# Import the code for the dialog  
from .equi_processing_dialog import DisplayInfoDialog  
import os.path  
    
class MyDialog(QDialog):
    def __init__(self):
        QDialog.__init__(self)
        self.bar = QgsMessageBar()
        self.bar.setSizePolicy( QSizePolicy.Minimum, QSizePolicy.Fixed )
        self.setLayout(QGridLayout())
        self.layout().setContentsMargins(0, 0, 0, 0)
        self.bar.pushMessage("coordinate must be","WGS84", level=Qgis.Info)   
#        self.buttonbox = QDialogButtonBox(QDialogButtonBox.Ok)
#        self.buttonbox.accepted.connect(self.run)
#        self.layout().addWidget(self.buttonbox, 0, 0, 2, 1)
#        self.layout().addWidget(self.bar, 0, 0, 5, 5)
    def run(self):
        self.bar.pushMessage("coordinate must be","WGS84", level=Qgis.Info)    
class DisplayInfo:  
    """QGIS Plugin Implementation."""  
    
    def __init__(self, iface):  
        """Constructor. 

        :param iface: An interface instance that will be passed to this class 
            which provides the hook by which you can manipulate the QGIS 
            application at run time. 
        :type iface: QgsInterface 
        """  
        #message
        
      
        
        # Save reference to the QGIS interface  
        self.iface = iface  
        # initialize plugin directory  
        self.plugin_dir = os.path.dirname(__file__)  
        # initialize locale  
        locale = QSettings().value('locale/userLocale')[0:2]  
        locale_path = os.path.join(  
            self.plugin_dir,  
            'i18n',  
            'DisplayInfo_{}.qm'.format(locale))  
    
        if os.path.exists(locale_path):  
            self.translator = QTranslator()  
            self.translator.load(locale_path)  
            QCoreApplication.installTranslator(self.translator)  
    
        # Declare instance attributes  
        self.actions = []  
        self.menu = self.tr(u'&Equidistance Processing')  
    
        # Check if plugin was started the first time in current QGIS session  
        # Must be set in initGui() to survive plugin reloads  
        self.first_start = None  
    
    # noinspection PyMethodMayBeStatic  
    def tr(self, message):  
        """Get the translation for a string using Qt translation API. 

        We implement this ourselves since we do not inherit QObject. 

        :param message: String for translation. 
        :type message: str, QString 

        :returns: Translated version of message. 
        :rtype: QString 
        """  
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass  
        return QCoreApplication.translate('DisplayInfo', message)  
    
    
    def add_action(  
        self,  
        icon_path,  
        text,  
        callback,  
        enabled_flag=True,  
        add_to_menu=True,  
        add_to_toolbar=True,  
        status_tip=None,  
        whats_this=None,  
        parent=None):  
        """Add a toolbar icon to the toolbar. 

        :param icon_path: Path to the icon for this action. Can be a resource 
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path. 
        :type icon_path: str 

        :param text: Text that should be shown in menu items for this action. 
        :type text: str 

        :param callback: Function to be called when the action is triggered. 
        :type callback: function 

        :param enabled_flag: A flag indicating if the action should be enabled 
            by default. Defaults to True. 
        :type enabled_flag: bool 

        :param add_to_menu: Flag indicating whether the action should also 
            be added to the menu. Defaults to True. 
        :type add_to_menu: bool 

        :param add_to_toolbar: Flag indicating whether the action should also 
            be added to the toolbar. Defaults to True. 
        :type add_to_toolbar: bool 

        :param status_tip: Optional text to show in a popup when mouse pointer 
            hovers over the action. 
        :type status_tip: str 

        :param parent: Parent widget for the new action. Defaults None. 
        :type parent: QWidget 

        :param whats_this: Optional text to show in the status bar when the 
            mouse pointer hovers over the action. 

        :returns: The action that was created. Note that the action is also 
            added to self.actions list. 
        :rtype: QAction 
        """  
    
        icon = QIcon(icon_path)  
        action = QAction(icon, text, parent)  
        action.triggered.connect(callback)  
        action.setEnabled(enabled_flag)  
    
        if status_tip is not None:  
            action.setStatusTip(status_tip)  
    
        if whats_this is not None:  
            action.setWhatsThis(whats_this)  
    
        if add_to_toolbar:  
            # Adds plugin icon to Plugins toolbar  
            self.iface.addToolBarIcon(action)  
    
        if add_to_menu:  
            self.iface.addPluginToMenu(  
                self.menu,  
                action)  
    
        self.actions.append(action)  
    
        return action  
    
    def initGui(self):  
        """Create the menu entries and toolbar icons inside the QGIS GUI."""  
    
        icon_path = ':/plugins/equi_processing/icon.png'  
        self.add_action(  
            icon_path,  
            text=self.tr(u'Equidistance Processing'),  
            callback=self.run,  
            parent=self.iface.mainWindow())  
    
        # will be set False in run()  
        self.first_start = True  
    
    
    def unload(self):  
        """Removes the plugin menu item and icon from QGIS GUI."""  
        for action in self.actions:  
            self.iface.removePluginMenu(  
                self.tr(u'&Equidistance Processing'),  
                action)  
            self.iface.removeToolBarIcon(action)  
    
    def select_output_file(self):  
        filename, _filter = QFileDialog.getSaveFileName(  
            self.dlg, "Select output filename and destination","layer_info", '*.txt')  
        self.dlg.lineEdit.setText(filename) 
     # Define a function to handle checkbox toggling
    def handleCheckBoxToggled(state):
     if state == 2:  # Checked state
        checked_checkbox = button_group.checkedButton()
        for other_checkbox in button_group.buttons():
            if other_checkbox is not checked_checkbox:
                other_checkbox.setChecked(False)
    
    def run(self):  
        """Run method that performs all the real work"""  
    
        # Create the dialog with elements (after translation) and keep reference  
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started  
        if self.first_start == True:  
            self.first_start = False  
            self.dlg = DisplayInfoDialog()  
#            self.dlg.toolButton.clicked.connect(self.select_output_file)  
    
        # Fetch the currently loaded layers  
        layers = QgsProject.instance().layerTreeRoot().children()

        # Clear the contents of the comboBox from previous runs  
        self.dlg.comboBox.clear()
        self.dlg.comboBox2.clear()
        #self.dlg.checkBox.clear()
        #self.dlg.checkBox_2.clear()
        

	

        # Populate the comboBox with names of all the loaded layers  
        self.dlg.comboBox.addItems([layer.name() for layer in layers])
        self.dlg.comboBox2.addItems([layer.name() for layer in layers])

        self.dlg.checkBox.setChecked(True)
        ##############################################################################################
        # Create a QButtonGroup to manage the checkboxes
        button_group = QButtonGroup()

        # Assuming you have two checkboxes, checkBox1 and checkBox2
        button_group.addButton(self.dlg.checkBox, 1)
        button_group.addButton(self.dlg.checkBox_2, 2)

        # Connect the checkboxes to a slot (a function) to handle toggling
        self.dlg.checkBox.stateChanged.connect(self.handleCheckBoxToggled)
        self.dlg.checkBox_2.stateChanged.connect(self.handleCheckBoxToggled)

       

        ########################################################################################
        
    
        # Show the dialog  
        self.dlg.show()

        # Run the dialog event loop  
        result = self.dlg.exec_()

        # See if OK was pressed  
        if result:  
#            filename = self.dlg.lineEdit.text()  
#            with open(filename, 'w') as output_file:  

                # Get the selected layer
                selectedLayerIndex = self.dlg.comboBox.currentIndex()
                selectedLayerIndex2 = self.dlg.comboBox2.currentIndex()
                
                
                selectedLayer = layers[selectedLayerIndex].layer()
                selectedLayer2 = layers[selectedLayerIndex2].layer()
                 # algo_dir =  direction[selectedLayerIndex3]
         
           
                  #feature = selectedLayer2.getFeatures()
                 # polygon = feature.geometry().asPolygon()
                 # n = len(polygon[0])
                 # for i in range(n):
                  # print (polygon[0][i]) 
                layer_CRS_description = selectedLayer.crs().description()
                print(layer_CRS_description)
                strcrs=str(layer_CRS_description)
                word="custumSCR" 
                
                if not word in strcrs:
                 print('conversion necessaire')
                 
                 if("WGS"in strcrs):
#                  iface.messageBar().pushMessage("", "Coordinate  in WGS84 or ITRF", level=Qgis.Critical)
                  
                  sourceCrs = QgsCoordinateReferenceSystem(4326)
                  #Custum crs based on data location
                  falsW=1000
                  falsN=1000
                  for feature in selectedLayer.getFeatures():
                   geom = feature.geometry()
                   Point = feature.geometry().asPoint()
                   if(falsW>Point.x()):
                     falsW=Point.x()
                     
                   if(falsN>Point.y()):
                     falsN=Point.y()
                    
                   for feature in selectedLayer2.getFeatures():
                     geom = feature.geometry()
                     Point = feature.geometry().asPoint()
                     if(falsW>Point.x()):
                       falsW=Point.x()
                     
                     if(falsN>Point.y()):
                       falsN=Point.y()
                  falsN=falsN-1
                  falsW=falsW-1
                  
                   
                  destCrs = QgsCoordinateReferenceSystem()
                  prji="+proj=tmerc  +lat_0="+str(falsN) +" +lon_0="+str(falsW)+ " +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
                  print(prji)
                  destCrs.createFromProj4(prji)
                  tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
                  conv=1
                  
                
                  State_A=[]
                  State_B=[]
                  y=0
                
                  for feature in selectedLayer.getFeatures():
                   geom = feature.geometry()
                   Point = feature.geometry().asPoint()

                   State_A.append(QgsPoint(Point.x(),Point.y()))
                 
                   if not word in strcrs:
                    geom = QgsGeometry(State_A[y])
                    geom.transform(tr)
                    Point= geom.asPoint()
                    State_A[y]=QgsPoint(Point.x(),Point.y())
                   
                   y=y+1
                 
                  y=0
                
                  for feature in selectedLayer2.getFeatures():
                   geom = feature.geometry()
                   Point = feature.geometry().asPoint()

                   State_B.append(QgsPoint(Point.x(),Point.y()))
                 
                   if not word in strcrs:
                    geom = QgsGeometry(State_B[y])
                    geom.transform(tr)
                    Point= geom.asPoint()
                    State_B[y]=QgsPoint(Point.x(),Point.y())
                    print("State_B:",State_B[y])
                  
                   else:
                    print("State_B:",State_A[y])
                   y=y+1
                ###############################################
                  if self.dlg.checkBox.isChecked():
                    States_situation='Opposite_States'
                  if self.dlg.checkBox_2.isChecked():
                    States_situation='Adjacent_States'
                 
                 
                  processLB(State_A,State_B,falsN,falsW,prji,States_situation)
                ##############################################
                
#                  layer_source = selectedLayer.dataProvider().dataSourceUri() + '\n' #QgsProject.instance().readPath("./") + '\n'  
#            
#                # Get the selected layer's extent
#                  layer_extent = selectedLayer.extent() 
#                  xmin = str(layer_extent.xMinimum())  
#                  xmax = str(layer_extent.xMaximum())  
#                  ymin = str(layer_extent.yMinimum())  
#                  ymax = str(layer_extent.yMaximum())
#
#                # Get the selected layer's CRS ID and description
#                  layer_CRS_id = selectedLayer.crs().authid()  
#                  layer_CRS_description = selectedLayer.crs().description()  
#
#                # Output the info to the text file
#                  output_file.write("Filepath: " + layer_source)  
#                  output_file.write("X-min: " + xmin +"m" + '\n')  
#                  output_file.write("X-max: " + xmax +"m"+ '\n')  
#                  output_file.write("Y-min: " + ymin +"m" +'\n')  
#                  output_file.write("Y-max: " + ymax +"m"+ '\n')  
#                  output_file.write("CRS: " + layer_CRS_id +" - " + layer_CRS_description)
#                  output_file.write(str(len))
#                  output_file.close()

                # Open the text file
#                  os.startfile(filename)

            # Generate a message after running the plugin
                  self.iface.messageBar().pushMessage(  
                   "Success", "Processing done" ,  
                   level=Qgis.Success, duration=10)
                 else:
                     myDlg = MyDialog()
                     myDlg.show()