# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EarthObservationPavementAnalysisDialog
                                 A QGIS plugin
 This plugin prepares the data sets to train, validate and assess earth observation imagery for pavement analysis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by TRL Software
        email                : ckettell@trl.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from typing import Optional
from qgis.PyQt.QtWidgets import QDialog, QTextBrowser  # Make sure to import QTextBrowser
from qgis.PyQt import uic
from PyQt5.QtWidgets import QDialog, QTextBrowser, QProgressBar, QVBoxLayout
from PyQt5.QtCore import Qt


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'EO_pavement_analysis_dialog_base.ui'))

class EarthObservationPavementAnalysisDialog(QDialog, FORM_CLASS):
    def __init__(self, parent: Optional[QDialog] = None) -> None:
        """Constructor."""
        super(EarthObservationPavementAnalysisDialog, self).__init__(parent)
        self.setupUi(self)

        # Ensure the progress bar is set up correctly
        if hasattr(self, 'progressBar'):
            self.progressBar.setMinimum(0)
            self.progressBar.setMaximum(100)
            self.progressBar.setValue(0)  # Initialize to 0%
        else:
            print("Warning: progressBar not found in the UI file")

        # No need to create a new layout or set it, as the progress bar is already in the UI

    def set_progress(self, value: int) -> None:
        """Set the value of the progress bar."""
        if hasattr(self, 'progressBar'):
            self.progressBar.setValue(int(value))
        else:
            print(f"Progress update: {value}%")
        
    def show_message(self, message: str) -> None:
        """Display a message in the text browser."""
        self.textBrowser.append(message)

    def clear_messages(self) -> None:
        """Clear all messages from the text browser."""
        self.textBrowser.clear()

    def enable_buttons(self, enable: bool) -> None:
        """Enable or disable all buttons in the dialog."""
        self.pushButton.setEnabled(enable)
        self.loadRoadCentreLinesButton.setEnabled(enable)
        self.sectionRoadButton.setEnabled(enable)
        self.loadRastersButton.setEnabled(enable)
        self.extractRastersButton.setEnabled(enable)

    def get_constant_width(self) -> bool:
        """Get the state of the constant width checkbox."""
        return self.constantWidthCheckBox.isChecked()

    def get_box_width(self) -> float:
        """Get the width of the boxes to be created."""
        return self.boxWidthSpinBox.value()
    
    def get_debug_option(self) -> bool:
        """Get the state of the debug_option checkbox."""
        return self.debug_option.isChecked()