# -*- coding: utf-8 -*-
'''
dataSpec.py contains parameters and pre-calculated values for all Prospect versions
calling these parameters is quicker than calculating them for each run of Prospect
Be careful to change values for the exact Prospect version!

References:
Féret J.B., Berger K., de Boissieu F., Malenovský Z. (2020):
PROSPECT-PRO for estimating content of nitrogen-containing leaf proteins and other carbon-based constituents

Féret J.B., Gitelson A.A., Noble S.D., & Jacquemoud S. (2017):
PROSPECT-D: towards modeling leaf optical properties through a complete lifecycle,
Remote Sensing of Environment, 193:204-215. Article.

Féret J.B., François C., Asner G.P., Gitelson A.A., Martin R.E., Bidel L.P.R., Ustin S.L.,
le Maire G., & Jacquemoud S. (2008):
PROSPECT-4 and 5: advances in the leaf optical properties model separating photosynthetic pigments.
Remote Sensing of Environment, 112, 3030-3043. Article.

Jacquemoud S., & Baret F. (1990), PROSPECT: a model of leaf optical properties spectra.
Remote Sensing of Environment, 34, 75-91. Article.
'''
import numpy as np

# Lambda:
lambd = np.arange(400, 2501)

## PROSPECTPro

# Refractive Index:
Ppro_refractive = np.array(
    [1.5115, 1.5115, 1.5115, 1.5115, 1.5115, 1.5115, 1.5108, 1.5101, 1.5095, 1.5088, 1.5081, 1.5076, 1.5071, 1.5065,
     1.506, 1.5055, 1.505, 1.5046, 1.5041, 1.5037, 1.5032, 1.5029, 1.5026, 1.5022, 1.5019, 1.5016, 1.5013, 1.501,
     1.5008, 1.5005, 1.5002, 1.5, 1.4997, 1.4995, 1.4992, 1.499, 1.4988, 1.4986, 1.4984, 1.4982, 1.498, 1.4977, 1.4974,
     1.4972, 1.4969, 1.4966, 1.4964, 1.4962, 1.4959, 1.4957, 1.4955, 1.4953, 1.4951, 1.4949, 1.4947, 1.4945, 1.4943,
     1.4942, 1.494, 1.4939, 1.4937, 1.4935, 1.4934, 1.4932, 1.4931, 1.4929, 1.4928, 1.4927, 1.4925, 1.4924, 1.4923,
     1.4922, 1.492, 1.4919, 1.4917, 1.4916, 1.4915, 1.4914, 1.4912, 1.4911, 1.491, 1.4909, 1.4907, 1.4906, 1.4904,
     1.4903, 1.4902, 1.49, 1.4899, 1.4897, 1.4896, 1.4895, 1.4893, 1.4892, 1.489, 1.4889, 1.4887, 1.4885, 1.4884,
     1.4882, 1.488, 1.4878, 1.4876, 1.4875, 1.4873, 1.4871, 1.4869, 1.4867, 1.4865, 1.4863, 1.4861, 1.4859, 1.4856,
     1.4854, 1.4851, 1.4849, 1.4846, 1.4844, 1.4841, 1.4839, 1.4836, 1.4833, 1.483, 1.4828, 1.4825, 1.4822, 1.4819,
     1.4816, 1.4813, 1.481, 1.4807, 1.4804, 1.4801, 1.4797, 1.4794, 1.4791, 1.4788, 1.4784, 1.4781, 1.4777, 1.4774,
     1.4771, 1.4767, 1.4764, 1.476, 1.4757, 1.4753, 1.475, 1.4746, 1.4743, 1.4739, 1.4735, 1.4732, 1.4728, 1.4725,
     1.4721, 1.4717, 1.4713, 1.4709, 1.4705, 1.4701, 1.4697, 1.4693, 1.4689, 1.4685, 1.4681, 1.4677, 1.4673, 1.467,
     1.4666, 1.4662, 1.4658, 1.4654, 1.4651, 1.4647, 1.4643, 1.4639, 1.4635, 1.4632, 1.4628, 1.4624, 1.462, 1.4616,
     1.4613, 1.4609, 1.4605, 1.4602, 1.4598, 1.4595, 1.4591, 1.4588, 1.4585, 1.4582, 1.4579, 1.4576, 1.4573, 1.457,
     1.4567, 1.4565, 1.4562, 1.4559, 1.4556, 1.4553, 1.4551, 1.4548, 1.4545, 1.4543, 1.454, 1.4538, 1.4535, 1.4533,
     1.4531, 1.4528, 1.4526, 1.4523, 1.4521, 1.4519, 1.4517, 1.4514, 1.4512, 1.451, 1.4508, 1.4506, 1.4504, 1.4502,
     1.45, 1.4498, 1.4497, 1.4495, 1.4494, 1.4492, 1.4491, 1.4489, 1.4488, 1.4486, 1.4485, 1.4484, 1.4483, 1.4482,
     1.4481, 1.448, 1.4479, 1.4478, 1.4478, 1.4477, 1.4476, 1.4475, 1.4475, 1.4474, 1.4474, 1.4473, 1.4473, 1.4472,
     1.4472, 1.4471, 1.4471, 1.447, 1.447, 1.4469, 1.4469, 1.4468, 1.4468, 1.4468, 1.4467, 1.4467, 1.4467, 1.4466,
     1.4466, 1.4465, 1.4465, 1.4464, 1.4464, 1.4463, 1.4463, 1.4462, 1.4462, 1.4461, 1.446, 1.446, 1.4459, 1.4458,
     1.4457, 1.4457, 1.4456, 1.4456, 1.4455, 1.4454, 1.4453, 1.4453, 1.4452, 1.4451, 1.445, 1.445, 1.4449, 1.4449,
     1.4448, 1.4447, 1.4446, 1.4446, 1.4445, 1.4444, 1.4443, 1.4442, 1.4441, 1.444, 1.4439, 1.4438, 1.4437, 1.4435,
     1.4434, 1.4433, 1.4431, 1.443, 1.4428, 1.4427, 1.4425, 1.4423, 1.4422, 1.442, 1.4419, 1.4417, 1.4415, 1.4413,
     1.4411, 1.4409, 1.4407, 1.4405, 1.4403, 1.4402, 1.44, 1.4398, 1.4396, 1.4394, 1.4393, 1.4391, 1.4389, 1.4387,
     1.4385, 1.4384, 1.4382, 1.438, 1.4378, 1.4377, 1.4375, 1.4374, 1.4372, 1.4371, 1.437, 1.4368, 1.4367, 1.4366,
     1.4364, 1.4363, 1.4361, 1.436, 1.4358, 1.4357, 1.4356, 1.4354, 1.4353, 1.4352, 1.4351, 1.435, 1.4349, 1.4348,
     1.4347, 1.4346, 1.4345, 1.4345, 1.4344, 1.4343, 1.4343, 1.4342, 1.4342, 1.4341, 1.4341, 1.4341, 1.4341, 1.434,
     1.434, 1.434, 1.434, 1.434, 1.434, 1.434, 1.434, 1.434, 1.4341, 1.4341, 1.4342, 1.4342, 1.4342, 1.4342, 1.4343,
     1.4343, 1.4343, 1.4343, 1.4344, 1.4344, 1.4345, 1.4345, 1.4345, 1.4346, 1.4346, 1.4347, 1.4347, 1.4347, 1.4347,
     1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347,
     1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348,
     1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4347, 1.4347,
     1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4346, 1.4346, 1.4346, 1.4346, 1.4346, 1.4345,
     1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4344, 1.4344, 1.4344, 1.4344, 1.4343,
     1.4343, 1.4342, 1.4342, 1.4342, 1.4342, 1.4341, 1.4341, 1.4341, 1.4341, 1.4341, 1.434, 1.434, 1.434, 1.434, 1.4339,
     1.4339, 1.4338, 1.4338, 1.4338, 1.4338, 1.4337, 1.4337, 1.4337, 1.4337, 1.4336, 1.4336, 1.4335, 1.4335, 1.4335,
     1.4335, 1.4334, 1.4334, 1.4334, 1.4334, 1.4333, 1.4333, 1.4332, 1.4332, 1.4332, 1.4332, 1.4331, 1.4331, 1.4331,
     1.4331, 1.433, 1.433, 1.4329, 1.4329, 1.4329, 1.4328, 1.4328, 1.4327, 1.4327, 1.4326, 1.4326, 1.4325, 1.4325,
     1.4324, 1.4324, 1.4323, 1.4323, 1.4322, 1.4322, 1.4322, 1.4321, 1.4321, 1.432, 1.432, 1.432, 1.4319, 1.4319,
     1.4318, 1.4318, 1.4318, 1.4317, 1.4317, 1.4316, 1.4316, 1.4316, 1.4315, 1.4315, 1.4314, 1.4314, 1.4313, 1.4313,
     1.4312, 1.4312, 1.4311, 1.431, 1.431, 1.4309, 1.4309, 1.4308, 1.4307, 1.4307, 1.4306, 1.4306, 1.4305, 1.4304,
     1.4304, 1.4303, 1.4303, 1.4302, 1.4301, 1.43, 1.43, 1.4299, 1.4298, 1.4297, 1.4297, 1.4296, 1.4296, 1.4295, 1.4294,
     1.4293, 1.4293, 1.4292, 1.4291, 1.429, 1.4289, 1.4289, 1.4288, 1.4287, 1.4286, 1.4285, 1.4285, 1.4284, 1.4283,
     1.4282, 1.4281, 1.4281, 1.428, 1.4279, 1.4278, 1.4277, 1.4276, 1.4275, 1.4274, 1.4273, 1.4272, 1.4272, 1.4271,
     1.427, 1.4269, 1.4268, 1.4267, 1.4266, 1.4265, 1.4264, 1.4263, 1.4263, 1.4262, 1.4261, 1.426, 1.4259, 1.4258,
     1.4257, 1.4256, 1.4255, 1.4254, 1.4253, 1.4252, 1.4251, 1.425, 1.4249, 1.4248, 1.4247, 1.4246, 1.4245, 1.4244,
     1.4242, 1.4241, 1.424, 1.4239, 1.4238, 1.4237, 1.4236, 1.4235, 1.4234, 1.4233, 1.4232, 1.4231, 1.423, 1.4229,
     1.4228, 1.4226, 1.4225, 1.4224, 1.4223, 1.4222, 1.422, 1.4219, 1.4218, 1.4217, 1.4216, 1.4215, 1.4214, 1.4213,
     1.4212, 1.4211, 1.4209, 1.4208, 1.4207, 1.4206, 1.4205, 1.4203, 1.4202, 1.4201, 1.42, 1.4199, 1.4197, 1.4196,
     1.4195, 1.4194, 1.4193, 1.4191, 1.419, 1.4189, 1.4188, 1.4187, 1.4185, 1.4184, 1.4183, 1.4182, 1.4181, 1.4179,
     1.4178, 1.4177, 1.4176, 1.4175, 1.4173, 1.4172, 1.4171, 1.417, 1.4169, 1.4167, 1.4166, 1.4165, 1.4164, 1.4163,
     1.4161, 1.416, 1.4159, 1.4158, 1.4157, 1.4156, 1.4155, 1.4154, 1.4153, 1.4152, 1.415, 1.4149, 1.4148, 1.4147,
     1.4146, 1.4145, 1.4144, 1.4143, 1.4142, 1.4141, 1.4139, 1.4138, 1.4137, 1.4136, 1.4135, 1.4133, 1.4132, 1.4131,
     1.413, 1.4129, 1.4128, 1.4127, 1.4126, 1.4125, 1.4124, 1.4122, 1.4121, 1.412, 1.4119, 1.4118, 1.4117, 1.4116,
     1.4115, 1.4114, 1.4113, 1.4111, 1.411, 1.4109, 1.4108, 1.4107, 1.4106, 1.4105, 1.4104, 1.4103, 1.4102, 1.4101,
     1.41, 1.4099, 1.4098, 1.4097, 1.4096, 1.4095, 1.4094, 1.4093, 1.4092, 1.409, 1.4089, 1.4088, 1.4087, 1.4086,
     1.4085, 1.4084, 1.4083, 1.4082, 1.4081, 1.408, 1.4079, 1.4078, 1.4077, 1.4076, 1.4075, 1.4074, 1.4073, 1.4072,
     1.4071, 1.407, 1.4069, 1.4068, 1.4067, 1.4066, 1.4065, 1.4064, 1.4063, 1.4062, 1.4061, 1.406, 1.4059, 1.4058,
     1.4057, 1.4056, 1.4054, 1.4053, 1.4052, 1.4051, 1.405, 1.4049, 1.4048, 1.4047, 1.4046, 1.4045, 1.4044, 1.4043,
     1.4042, 1.4041, 1.404, 1.4038, 1.4037, 1.4036, 1.4035, 1.4034, 1.4033, 1.4032, 1.4031, 1.403, 1.4029, 1.4028,
     1.4027, 1.4026, 1.4025, 1.4024, 1.4023, 1.4022, 1.4021, 1.402, 1.4019, 1.4017, 1.4016, 1.4015, 1.4014, 1.4013,
     1.4012, 1.4011, 1.401, 1.4009, 1.4008, 1.4007, 1.4006, 1.4005, 1.4004, 1.4003, 1.4001, 1.4, 1.3999, 1.3998, 1.3997,
     1.3996, 1.3995, 1.3994, 1.3993, 1.3992, 1.3991, 1.399, 1.3989, 1.3988, 1.3987, 1.3985, 1.3984, 1.3983, 1.3982,
     1.3981, 1.398, 1.3979, 1.3978, 1.3977, 1.3976, 1.3975, 1.3974, 1.3973, 1.3972, 1.3971, 1.397, 1.3969, 1.3968,
     1.3967, 1.3966, 1.3965, 1.3964, 1.3963, 1.3962, 1.3961, 1.396, 1.3959, 1.3958, 1.3957, 1.3956, 1.3955, 1.3954,
     1.3953, 1.3952, 1.3951, 1.3949, 1.3948, 1.3947, 1.3946, 1.3945, 1.3944, 1.3943, 1.3942, 1.3941, 1.394, 1.3939,
     1.3938, 1.3937, 1.3936, 1.3935, 1.3934, 1.3933, 1.3932, 1.3931, 1.393, 1.3929, 1.3928, 1.3927, 1.3926, 1.3925,
     1.3924, 1.3923, 1.3922, 1.3921, 1.392, 1.3919, 1.3918, 1.3917, 1.3916, 1.3915, 1.3914, 1.3913, 1.3912, 1.3911,
     1.391, 1.3909, 1.3908, 1.3907, 1.3906, 1.3905, 1.3904, 1.3903, 1.3902, 1.3901, 1.39, 1.3899, 1.3898, 1.3897,
     1.3896, 1.3895, 1.3893, 1.3892, 1.3891, 1.389, 1.3889, 1.3888, 1.3887, 1.3886, 1.3885, 1.3884, 1.3883, 1.3882,
     1.3881, 1.388, 1.3879, 1.3877, 1.3876, 1.3875, 1.3874, 1.3873, 1.3872, 1.3871, 1.387, 1.3869, 1.3868, 1.3867,
     1.3866, 1.3865, 1.3864, 1.3863, 1.3861, 1.386, 1.3859, 1.3858, 1.3857, 1.3855, 1.3854, 1.3853, 1.3852, 1.3851,
     1.3849, 1.3848, 1.3847, 1.3846, 1.3845, 1.3843, 1.3842, 1.3841, 1.384, 1.3839, 1.3837, 1.3836, 1.3835, 1.3834,
     1.3833, 1.3831, 1.383, 1.3829, 1.3828, 1.3826, 1.3825, 1.3823, 1.3822, 1.3821, 1.382, 1.3818, 1.3817, 1.3816,
     1.3815, 1.3813, 1.3812, 1.381, 1.3809, 1.3808, 1.3807, 1.3805, 1.3804, 1.3803, 1.3802, 1.38, 1.3799, 1.3797,
     1.3796, 1.3794, 1.3793, 1.3791, 1.379, 1.3788, 1.3787, 1.3785, 1.3784, 1.3782, 1.3781, 1.3779, 1.3778, 1.3776,
     1.3775, 1.3773, 1.3772, 1.377, 1.3769, 1.3767, 1.3766, 1.3764, 1.3763, 1.3761, 1.376, 1.3758, 1.3756, 1.3755,
     1.3753, 1.3752, 1.375, 1.3748, 1.3747, 1.3745, 1.3744, 1.3742, 1.374, 1.3739, 1.3737, 1.3736, 1.3734, 1.3732,
     1.3731, 1.3729, 1.3728, 1.3726, 1.3724, 1.3723, 1.3721, 1.372, 1.3718, 1.3716, 1.3715, 1.3713, 1.3712, 1.371,
     1.3708, 1.3706, 1.3705, 1.3703, 1.3701, 1.3699, 1.3698, 1.3696, 1.3695, 1.3693, 1.3692, 1.369, 1.3689, 1.3687,
     1.3686, 1.3684, 1.3683, 1.3681, 1.368, 1.3678, 1.3676, 1.3675, 1.3673, 1.3672, 1.367, 1.3668, 1.3666, 1.3665,
     1.3663, 1.3661, 1.3659, 1.3658, 1.3656, 1.3655, 1.3653, 1.3651, 1.365, 1.3648, 1.3647, 1.3645, 1.3643, 1.3641,
     1.364, 1.3638, 1.3636, 1.3634, 1.3633, 1.3631, 1.363, 1.3628, 1.3626, 1.3625, 1.3623, 1.3622, 1.362, 1.3618,
     1.3617, 1.3615, 1.3614, 1.3612, 1.361, 1.3608, 1.3607, 1.3605, 1.3603, 1.3601, 1.36, 1.3598, 1.3597, 1.3595,
     1.3593, 1.3592, 1.359, 1.3589, 1.3587, 1.3585, 1.3584, 1.3582, 1.3581, 1.3579, 1.3577, 1.3576, 1.3574, 1.3573,
     1.3571, 1.3569, 1.3568, 1.3566, 1.3565, 1.3563, 1.3561, 1.356, 1.3558, 1.3557, 1.3555, 1.3553, 1.3552, 1.355,
     1.3549, 1.3547, 1.3545, 1.3544, 1.3542, 1.3541, 1.3539, 1.3537, 1.3536, 1.3534, 1.3533, 1.3531, 1.3529, 1.3528,
     1.3526, 1.3525, 1.3523, 1.3521, 1.352, 1.3518, 1.3517, 1.3515, 1.3513, 1.3512, 1.351, 1.3509, 1.3507, 1.3505,
     1.3504, 1.3502, 1.3501, 1.3499, 1.3498, 1.3496, 1.3495, 1.3493, 1.3492, 1.349, 1.3489, 1.3487, 1.3486, 1.3484,
     1.3482, 1.3481, 1.3479, 1.3478, 1.3476, 1.3475, 1.3473, 1.3472, 1.347, 1.3469, 1.3467, 1.3466, 1.3464, 1.3463,
     1.3461, 1.3459, 1.3458, 1.3456, 1.3455, 1.3453, 1.3452, 1.345, 1.3449, 1.3447, 1.3446, 1.3445, 1.3443, 1.3442,
     1.344, 1.3439, 1.3438, 1.3436, 1.3435, 1.3433, 1.3432, 1.3431, 1.3429, 1.3428, 1.3426, 1.3425, 1.3424, 1.3422,
     1.3421, 1.3419, 1.3418, 1.3417, 1.3415, 1.3414, 1.3412, 1.3411, 1.341, 1.3409, 1.3407, 1.3406, 1.3405, 1.3404,
     1.3402, 1.3401, 1.3399, 1.3398, 1.3397, 1.3396, 1.3394, 1.3393, 1.3392, 1.3391, 1.339, 1.3388, 1.3387, 1.3386,
     1.3385, 1.3383, 1.3382, 1.338, 1.3379, 1.3378, 1.3377, 1.3376, 1.3375, 1.3374, 1.3373, 1.3372, 1.337, 1.3369,
     1.3368, 1.3367, 1.3366, 1.3365, 1.3364, 1.3363, 1.3362, 1.3361, 1.3359, 1.3358, 1.3357, 1.3356, 1.3355, 1.3354,
     1.3353, 1.3352, 1.3351, 1.335, 1.3349, 1.3348, 1.3347, 1.3346, 1.3345, 1.3344, 1.3343, 1.3342, 1.3341, 1.334,
     1.3339, 1.3338, 1.3337, 1.3336, 1.3335, 1.3334, 1.3333, 1.3332, 1.3331, 1.333, 1.3329, 1.3328, 1.3327, 1.3326,
     1.3325, 1.3324, 1.3323, 1.3322, 1.3321, 1.332, 1.332, 1.3319, 1.3318, 1.3317, 1.3316, 1.3316, 1.3315, 1.3314,
     1.3313, 1.3312, 1.3311, 1.331, 1.3309, 1.3308, 1.3307, 1.3307, 1.3306, 1.3305, 1.3304, 1.3303, 1.3303, 1.3302,
     1.3301, 1.33, 1.3299, 1.3299, 1.3298, 1.3297, 1.3296, 1.3295, 1.3295, 1.3294, 1.3293, 1.3292, 1.3291, 1.3291,
     1.329, 1.3289, 1.3288, 1.3287, 1.3287, 1.3286, 1.3285, 1.3284, 1.3283, 1.3283, 1.3282, 1.3281, 1.328, 1.3279,
     1.3279, 1.3278, 1.3277, 1.3276, 1.3275, 1.3275, 1.3274, 1.3273, 1.3272, 1.3271, 1.3271, 1.327, 1.3269, 1.3268,
     1.3268, 1.3267, 1.3267, 1.3266, 1.3265, 1.3264, 1.3264, 1.3263, 1.3262, 1.3261, 1.3261, 1.326, 1.326, 1.3259,
     1.3258, 1.3257, 1.3257, 1.3256, 1.3255, 1.3254, 1.3254, 1.3253, 1.3253, 1.3252, 1.3251, 1.325, 1.325, 1.3249,
     1.3248, 1.3247, 1.3247, 1.3246, 1.3246, 1.3245, 1.3244, 1.3243, 1.3243, 1.3242, 1.3241, 1.324, 1.324, 1.3239,
     1.3239, 1.3238, 1.3237, 1.3236, 1.3236, 1.3235, 1.3234, 1.3233, 1.3233, 1.3232, 1.3232, 1.3231, 1.323, 1.323,
     1.3229, 1.3229, 1.3228, 1.3227, 1.3227, 1.3226, 1.3226, 1.3225, 1.3224, 1.3224, 1.3223, 1.3223, 1.3222, 1.3221,
     1.322, 1.322, 1.3219, 1.3218, 1.3217, 1.3217, 1.3216, 1.3216, 1.3215, 1.3214, 1.3213, 1.3213, 1.3212, 1.3211,
     1.321, 1.321, 1.3209, 1.3209, 1.3208, 1.3207, 1.3206, 1.3206, 1.3205, 1.3204, 1.3203, 1.3203, 1.3202, 1.3202,
     1.3201, 1.32, 1.32, 1.3199, 1.3199, 1.3198, 1.3197, 1.3197, 1.3196, 1.3196, 1.3195, 1.3194, 1.3193, 1.3193, 1.3192,
     1.3191, 1.319, 1.319, 1.3189, 1.3189, 1.3188, 1.3187, 1.3186, 1.3186, 1.3185, 1.3184, 1.3183, 1.3183, 1.3182,
     1.3182, 1.3181, 1.318, 1.3179, 1.3179, 1.3178, 1.3177, 1.3176, 1.3175, 1.3175, 1.3174, 1.3173, 1.3172, 1.3171,
     1.3171, 1.317, 1.3169, 1.3168, 1.3167, 1.3167, 1.3166, 1.3165, 1.3164, 1.3163, 1.3163, 1.3162, 1.3161, 1.316,
     1.3159, 1.3159, 1.3158, 1.3157, 1.3156, 1.3155, 1.3154, 1.3153, 1.3152, 1.3151, 1.315, 1.315, 1.3149, 1.3148,
     1.3147, 1.3146, 1.3146, 1.3145, 1.3144, 1.3143, 1.3142, 1.3141, 1.314, 1.3139, 1.3138, 1.3137, 1.3136, 1.3135,
     1.3134, 1.3133, 1.3132, 1.3131, 1.313, 1.3129, 1.3128, 1.3127, 1.3126, 1.3125, 1.3124, 1.3123, 1.3122, 1.3121,
     1.312, 1.3119, 1.3118, 1.3117, 1.3116, 1.3115, 1.3114, 1.3113, 1.3112, 1.311, 1.3109, 1.3108, 1.3107, 1.3106,
     1.3105, 1.3104, 1.3103, 1.3102, 1.3101, 1.3099, 1.3098, 1.3097, 1.3096, 1.3095, 1.3094, 1.3093, 1.3092, 1.3091,
     1.309, 1.3088, 1.3087, 1.3086, 1.3085, 1.3084, 1.3082, 1.3081, 1.308, 1.3079, 1.3078, 1.3076, 1.3075, 1.3074,
     1.3073, 1.3072, 1.307, 1.3069, 1.3068, 1.3067, 1.3066, 1.3064, 1.3063, 1.3062, 1.3061, 1.306, 1.3059, 1.3058,
     1.3057, 1.3056, 1.3055, 1.3053, 1.3052, 1.3051, 1.305, 1.3049, 1.3047, 1.3046, 1.3045, 1.3044, 1.3043, 1.3041,
     1.304, 1.3039, 1.3038, 1.3037, 1.3035, 1.3034, 1.3033, 1.3032, 1.3031, 1.3029, 1.3028, 1.3027, 1.3026, 1.3025,
     1.3023, 1.3022, 1.3021, 1.302, 1.3019, 1.3017, 1.3016, 1.3015, 1.3014, 1.3013, 1.3011, 1.301, 1.3009, 1.3008,
     1.3007, 1.3005, 1.3004, 1.3003, 1.3002, 1.3001, 1.2999, 1.2998, 1.2997, 1.2996, 1.2995, 1.2993, 1.2992, 1.2991,
     1.299, 1.2989, 1.2987, 1.2986, 1.2985, 1.2984, 1.2983, 1.2981, 1.298, 1.2979, 1.2978, 1.2977, 1.2975, 1.2974,
     1.2973, 1.2972, 1.297, 1.2969, 1.2967, 1.2966, 1.2965, 1.2964, 1.2962, 1.2961, 1.296, 1.2959, 1.2958, 1.2957,
     1.2956, 1.2955, 1.2954, 1.2953, 1.2951, 1.295, 1.2949, 1.2948, 1.2947, 1.2945, 1.2944, 1.2943, 1.2942, 1.2941,
     1.2939, 1.2938, 1.2937, 1.2936, 1.2935, 1.2933, 1.2932, 1.2931, 1.293, 1.2928, 1.2927, 1.2925, 1.2924, 1.2923,
     1.2922, 1.292, 1.2919, 1.2918, 1.2917, 1.2916, 1.2914, 1.2913, 1.2912, 1.2911, 1.291, 1.2908, 1.2907, 1.2906,
     1.2905, 1.2904, 1.2902, 1.2901, 1.29, 1.2899, 1.2898, 1.2896, 1.2895, 1.2894, 1.2893, 1.2892, 1.289, 1.2889,
     1.2888, 1.2887, 1.2886, 1.2884, 1.2883, 1.2882, 1.2881, 1.288, 1.2878, 1.2877, 1.2876, 1.2875, 1.2874, 1.2873,
     1.2872, 1.2871, 1.287, 1.2869, 1.2867, 1.2866, 1.2865, 1.2864, 1.2863, 1.2862, 1.2861, 1.286, 1.2859, 1.2858,
     1.2856, 1.2855, 1.2854, 1.2853, 1.2852, 1.285, 1.2849, 1.2848, 1.2847, 1.2846, 1.2845, 1.2844, 1.2843, 1.2842,
     1.2841, 1.284, 1.2839, 1.2838, 1.2837, 1.2836, 1.2834, 1.2833, 1.2832, 1.2831, 1.283, 1.2829, 1.2828, 1.2827,
     1.2826, 1.2825, 1.2824, 1.2823, 1.2822, 1.2821, 1.282, 1.2818, 1.2817, 1.2816, 1.2815, 1.2814, 1.2813, 1.2812,
     1.2811, 1.281, 1.2809, 1.2808, 1.2807, 1.2806, 1.2805, 1.2804, 1.2803, 1.2802, 1.2801, 1.28, 1.2799, 1.2799,
     1.2798, 1.2797, 1.2796, 1.2795, 1.2795, 1.2794, 1.2793, 1.2792, 1.2791, 1.2791, 1.279, 1.2789, 1.2788, 1.2788,
     1.2787, 1.2787, 1.2786, 1.2785, 1.2785, 1.2784, 1.2784, 1.2783, 1.2782, 1.2781, 1.278, 1.2779, 1.2778, 1.2777,
     1.2776, 1.2776, 1.2775, 1.2774, 1.2773, 1.2772, 1.2771, 1.277, 1.2769, 1.2768, 1.2767, 1.2766, 1.2765, 1.2764,
     1.2763, 1.2762, 1.2761, 1.276, 1.2759, 1.2758, 1.2757, 1.2757, 1.2756, 1.2755, 1.2754, 1.2753, 1.2753, 1.2752,
     1.2751, 1.275, 1.2749, 1.2749, 1.2748, 1.2747, 1.2746, 1.2745, 1.2745, 1.2744, 1.2743, 1.2742, 1.2742, 1.2741,
     1.2741, 1.274, 1.2739, 1.2739, 1.2738, 1.2738, 1.2737, 1.2736, 1.2736, 1.2735, 1.2735, 1.2734, 1.2733, 1.2733,
     1.2732, 1.2732, 1.2731, 1.273, 1.273, 1.2729, 1.2729, 1.2728, 1.2727, 1.2727, 1.2726, 1.2726, 1.2725, 1.2725,
     1.2724, 1.2724, 1.2723, 1.2723, 1.2722, 1.2722, 1.2721, 1.2721, 1.272, 1.272, 1.2719, 1.2719, 1.2718, 1.2718,
     1.2717, 1.2717, 1.2716, 1.2716, 1.2715, 1.2715, 1.2714, 1.2714, 1.2713, 1.2713, 1.2713, 1.2713, 1.2712, 1.2712,
     1.2712, 1.2712, 1.2711, 1.2711, 1.271, 1.271, 1.271, 1.271, 1.2709, 1.2709, 1.2709, 1.2709, 1.2709, 1.2708, 1.2708,
     1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2709, 1.2709,
     1.271, 1.271, 1.2711, 1.2712, 1.2712, 1.2713, 1.2714, 1.2715, 1.2716, 1.2717, 1.2718, 1.2719, 1.272, 1.2722,
     1.2723, 1.2725, 1.2726, 1.2728, 1.273, 1.2732, 1.2734, 1.2736])

Ppro_k_Cab = np.array([6.49E-02,6.67E-02,6.86E-02,7.00E-02,7.09E-02,7.13E-02,7.13E-02,7.13E-02,7.12E-02,7.12E-02,7.15E-02,7.19E-02,7.20E-02,7.18E-02,7.15E-02,7.11E-02,7.08E-02,7.04E-02,7.01E-02,6.98E-02,6.98E-02,7.01E-02,7.03E-02,7.05E-02,7.05E-02,7.05E-02,7.08E-02,7.13E-02,7.16E-02,7.19E-02,7.24E-02,7.31E-02,7.37E-02,7.40E-02,7.43E-02,7.45E-02,7.47E-02,7.47E-02,7.46E-02,7.43E-02,7.38E-02,7.28E-02,7.16E-02,7.05E-02,6.91E-02,6.76E-02,6.60E-02,6.45E-02,6.27E-02,6.08E-02,5.88E-02,5.68E-02,5.47E-02,5.28E-02,5.11E-02,4.96E-02,4.81E-02,4.68E-02,4.56E-02,4.47E-02,4.39E-02,4.32E-02,4.27E-02,4.22E-02,4.18E-02,4.13E-02,4.09E-02,4.06E-02,4.03E-02,4.00E-02,3.97E-02,3.95E-02,3.93E-02,3.90E-02,3.88E-02,3.85E-02,3.83E-02,3.79E-02,3.75E-02,3.71E-02,3.68E-02,3.63E-02,3.58E-02,3.52E-02,3.46E-02,3.39E-02,3.32E-02,3.24E-02,3.15E-02,3.06E-02,2.97E-02,2.87E-02,2.77E-02,2.66E-02,2.56E-02,2.45E-02,2.34E-02,2.23E-02,2.12E-02,2.01E-02,1.90E-02,1.80E-02,1.69E-02,1.59E-02,1.49E-02,1.40E-02,1.30E-02,1.22E-02,1.13E-02,1.05E-02,9.70E-03,8.95E-03,8.25E-03,7.58E-03,6.96E-03,6.39E-03,5.87E-03,5.40E-03,4.99E-03,4.63E-03,4.33E-03,4.09E-03,3.89E-03,3.74E-03,3.65E-03,3.61E-03,3.62E-03,3.67E-03,3.77E-03,3.90E-03,4.07E-03,4.26E-03,4.48E-03,4.73E-03,4.99E-03,5.27E-03,5.56E-03,5.87E-03,6.17E-03,6.48E-03,6.79E-03,7.09E-03,7.39E-03,7.67E-03,7.95E-03,8.21E-03,8.45E-03,8.68E-03,8.90E-03,9.11E-03,9.31E-03,9.50E-03,9.68E-03,9.86E-03,1.00E-02,1.02E-02,1.04E-02,1.06E-02,1.07E-02,1.09E-02,1.10E-02,1.12E-02,1.14E-02,1.16E-02,1.18E-02,1.21E-02,1.23E-02,1.26E-02,1.29E-02,1.33E-02,1.36E-02,1.39E-02,1.43E-02,1.47E-02,1.50E-02,1.54E-02,1.57E-02,1.60E-02,1.63E-02,1.66E-02,1.69E-02,1.72E-02,1.75E-02,1.78E-02,1.81E-02,1.83E-02,1.86E-02,1.88E-02,1.90E-02,1.92E-02,1.94E-02,1.96E-02,1.98E-02,1.99E-02,2.01E-02,2.02E-02,2.03E-02,2.05E-02,2.06E-02,2.07E-02,2.09E-02,2.10E-02,2.12E-02,2.13E-02,2.15E-02,2.18E-02,2.20E-02,2.23E-02,2.26E-02,2.29E-02,2.32E-02,2.35E-02,2.38E-02,2.42E-02,2.46E-02,2.49E-02,2.53E-02,2.56E-02,2.60E-02,2.63E-02,2.65E-02,2.68E-02,2.70E-02,2.72E-02,2.74E-02,2.75E-02,2.76E-02,2.77E-02,2.78E-02,2.79E-02,2.80E-02,2.81E-02,2.82E-02,2.84E-02,2.86E-02,2.88E-02,2.92E-02,2.96E-02,3.01E-02,3.06E-02,3.12E-02,3.19E-02,3.27E-02,3.34E-02,3.43E-02,3.51E-02,3.59E-02,3.68E-02,3.76E-02,3.83E-02,3.90E-02,3.96E-02,4.02E-02,4.08E-02,4.14E-02,4.21E-02,4.29E-02,4.38E-02,4.49E-02,4.61E-02,4.75E-02,4.91E-02,5.08E-02,5.27E-02,5.47E-02,5.68E-02,5.89E-02,6.08E-02,6.28E-02,6.45E-02,6.61E-02,6.75E-02,6.87E-02,6.96E-02,7.05E-02,7.10E-02,7.14E-02,7.14E-02,7.11E-02,7.02E-02,6.89E-02,6.66E-02,6.39E-02,6.05E-02,5.69E-02,5.27E-02,4.87E-02,4.47E-02,4.09E-02,3.71E-02,3.37E-02,3.05E-02,2.75E-02,2.48E-02,2.23E-02,2.01E-02,1.82E-02,1.64E-02,1.49E-02,1.35E-02,1.22E-02,1.12E-02,1.02E-02,9.34E-03,8.59E-03,7.92E-03,7.31E-03,6.77E-03,6.28E-03,5.83E-03,5.42E-03,5.04E-03,4.70E-03,4.37E-03,4.07E-03,3.79E-03,3.53E-03,3.29E-03,3.06E-03,2.84E-03,2.64E-03,2.46E-03,2.28E-03,2.12E-03,1.96E-03,1.82E-03,1.69E-03,1.56E-03,1.45E-03,1.34E-03,1.24E-03,1.15E-03,1.06E-03,9.78E-04,9.04E-04,8.36E-04,7.73E-04,7.15E-04,6.62E-04,6.12E-04,5.68E-04,5.27E-04,4.90E-04,4.56E-04,4.26E-04,3.98E-04,3.73E-04,3.51E-04,3.31E-04,3.14E-04,2.98E-04,2.83E-04,2.68E-04,2.53E-04,2.38E-04,2.23E-04,2.09E-04,1.94E-04,1.80E-04,1.66E-04,1.53E-04,1.40E-04,1.27E-04,1.15E-04,1.03E-04,9.18E-05,8.10E-05,7.07E-05,6.10E-05,5.19E-05,4.34E-05,3.55E-05,2.84E-05,2.20E-05,1.63E-05,1.15E-05,7.43E-06,4.23E-06,1.90E-06,4.80E-07,1.05E-13,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00])
Ppro_k_Ccx = np.array([1.67E-01,1.68E-01,1.67E-01,1.67E-01,1.68E-01,1.68E-01,1.68E-01,1.67E-01,1.67E-01,1.67E-01,1.66E-01,1.66E-01,1.65E-01,1.66E-01,1.66E-01,1.66E-01,1.66E-01,1.66E-01,1.67E-01,1.67E-01,1.67E-01,1.68E-01,1.68E-01,1.68E-01,1.69E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.67E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.68E-01,1.69E-01,1.69E-01,1.70E-01,1.70E-01,1.70E-01,1.70E-01,1.70E-01,1.70E-01,1.70E-01,1.70E-01,1.69E-01,1.69E-01,1.67E-01,1.66E-01,1.64E-01,1.63E-01,1.61E-01,1.60E-01,1.58E-01,1.57E-01,1.55E-01,1.53E-01,1.52E-01,1.50E-01,1.48E-01,1.47E-01,1.45E-01,1.43E-01,1.42E-01,1.41E-01,1.39E-01,1.38E-01,1.37E-01,1.36E-01,1.35E-01,1.35E-01,1.35E-01,1.34E-01,1.34E-01,1.34E-01,1.34E-01,1.34E-01,1.33E-01,1.33E-01,1.32E-01,1.31E-01,1.30E-01,1.29E-01,1.28E-01,1.26E-01,1.25E-01,1.23E-01,1.21E-01,1.19E-01,1.17E-01,1.14E-01,1.12E-01,1.10E-01,1.08E-01,1.06E-01,1.04E-01,1.01E-01,9.90E-02,9.67E-02,9.45E-02,9.22E-02,8.99E-02,8.75E-02,8.52E-02,8.29E-02,8.06E-02,7.83E-02,7.59E-02,7.36E-02,7.13E-02,6.90E-02,6.67E-02,6.44E-02,6.22E-02,5.99E-02,5.76E-02,5.54E-02,5.32E-02,5.10E-02,4.89E-02,4.67E-02,4.46E-02,4.25E-02,4.04E-02,3.84E-02,3.64E-02,3.44E-02,3.25E-02,3.06E-02,2.88E-02,2.70E-02,2.52E-02,2.35E-02,2.18E-02,2.02E-02,1.86E-02,1.71E-02,1.56E-02,1.42E-02,1.28E-02,1.15E-02,1.03E-02,9.10E-03,7.98E-03,6.93E-03,5.95E-03,5.03E-03,4.19E-03,3.42E-03,2.72E-03,2.09E-03,1.55E-03,1.08E-03,6.98E-04,3.95E-04,1.77E-04,4.45E-05,2.13E-13,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00])
Ppro_k_Canth = np.array([6.67E-02,6.41E-02,6.19E-02,5.99E-02,5.83E-02,5.67E-02,5.54E-02,5.42E-02,5.31E-02,5.20E-02,5.10E-02,5.01E-02,4.94E-02,4.86E-02,4.79E-02,4.74E-02,4.69E-02,4.65E-02,4.62E-02,4.58E-02,4.54E-02,4.51E-02,4.48E-02,4.45E-02,4.42E-02,4.41E-02,4.40E-02,4.39E-02,4.38E-02,4.39E-02,4.39E-02,4.39E-02,4.40E-02,4.40E-02,4.41E-02,4.42E-02,4.43E-02,4.44E-02,4.45E-02,4.46E-02,4.48E-02,4.49E-02,4.51E-02,4.52E-02,4.54E-02,4.56E-02,4.58E-02,4.59E-02,4.60E-02,4.62E-02,4.64E-02,4.67E-02,4.70E-02,4.72E-02,4.74E-02,4.76E-02,4.78E-02,4.81E-02,4.83E-02,4.86E-02,4.88E-02,4.91E-02,4.94E-02,4.96E-02,4.98E-02,5.01E-02,5.04E-02,5.08E-02,5.11E-02,5.16E-02,5.19E-02,5.24E-02,5.28E-02,5.34E-02,5.40E-02,5.45E-02,5.49E-02,5.55E-02,5.62E-02,5.66E-02,5.72E-02,5.77E-02,5.83E-02,5.88E-02,5.95E-02,6.01E-02,6.07E-02,6.12E-02,6.18E-02,6.24E-02,6.29E-02,6.34E-02,6.40E-02,6.45E-02,6.50E-02,6.54E-02,6.59E-02,6.64E-02,6.69E-02,6.73E-02,6.78E-02,6.81E-02,6.85E-02,6.88E-02,6.91E-02,6.94E-02,6.96E-02,6.98E-02,7.01E-02,7.03E-02,7.05E-02,7.07E-02,7.09E-02,7.10E-02,7.12E-02,7.13E-02,7.14E-02,7.15E-02,7.16E-02,7.16E-02,7.17E-02,7.17E-02,7.18E-02,7.18E-02,7.19E-02,7.20E-02,7.21E-02,7.22E-02,7.22E-02,7.23E-02,7.23E-02,7.24E-02,7.25E-02,7.25E-02,7.25E-02,7.25E-02,7.25E-02,7.24E-02,7.23E-02,7.22E-02,7.21E-02,7.18E-02,7.16E-02,7.13E-02,7.11E-02,7.07E-02,7.03E-02,6.98E-02,6.94E-02,6.88E-02,6.81E-02,6.74E-02,6.67E-02,6.59E-02,6.51E-02,6.42E-02,6.34E-02,6.24E-02,6.15E-02,6.06E-02,5.97E-02,5.86E-02,5.76E-02,5.66E-02,5.55E-02,5.44E-02,5.32E-02,5.21E-02,5.09E-02,4.97E-02,4.85E-02,4.73E-02,4.62E-02,4.50E-02,4.39E-02,4.28E-02,4.17E-02,4.06E-02,3.95E-02,3.85E-02,3.74E-02,3.62E-02,3.50E-02,3.39E-02,3.28E-02,3.17E-02,3.06E-02,2.96E-02,2.87E-02,2.77E-02,2.68E-02,2.60E-02,2.51E-02,2.43E-02,2.35E-02,2.27E-02,2.19E-02,2.11E-02,2.03E-02,1.95E-02,1.87E-02,1.80E-02,1.72E-02,1.66E-02,1.60E-02,1.54E-02,1.48E-02,1.43E-02,1.38E-02,1.33E-02,1.28E-02,1.23E-02,1.19E-02,1.14E-02,1.09E-02,1.05E-02,1.00E-02,9.58E-03,9.16E-03,8.78E-03,8.41E-03,8.05E-03,7.71E-03,7.38E-03,7.06E-03,6.75E-03,6.46E-03,6.17E-03,5.90E-03,5.65E-03,5.40E-03,5.16E-03,4.93E-03,4.72E-03,4.51E-03,4.31E-03,4.12E-03,3.94E-03,3.77E-03,3.61E-03,3.45E-03,3.30E-03,3.16E-03,3.03E-03,2.90E-03,2.78E-03,2.66E-03,2.55E-03,2.45E-03,2.35E-03,2.25E-03,2.16E-03,2.07E-03,1.99E-03,1.91E-03,1.83E-03,1.75E-03,1.68E-03,1.61E-03,1.54E-03,1.47E-03,1.40E-03,1.34E-03,1.27E-03,1.20E-03,1.14E-03,1.07E-03,1.00E-03,9.30E-04,8.58E-04,7.85E-04,7.10E-04,6.39E-04,5.71E-04,5.07E-04,4.47E-04,3.90E-04,3.37E-04,2.88E-04,2.43E-04,2.01E-04,1.63E-04,1.29E-04,9.93E-05,7.31E-05,5.09E-05,3.26E-05,1.84E-05,8.20E-06,2.06E-06,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00])
Ppro_k_Cbrown = np.array([5.27E-01,5.26E-01,5.25E-01,5.24E-01,5.23E-01,5.22E-01,5.21E-01,5.20E-01,5.19E-01,5.18E-01,5.17E-01,5.16E-01,5.15E-01,5.14E-01,5.13E-01,5.12E-01,5.11E-01,5.10E-01,5.09E-01,5.08E-01,5.07E-01,5.06E-01,5.05E-01,5.04E-01,5.03E-01,5.02E-01,5.01E-01,5.00E-01,4.99E-01,4.98E-01,4.97E-01,4.96E-01,4.95E-01,4.94E-01,4.92E-01,4.91E-01,4.90E-01,4.89E-01,4.88E-01,4.86E-01,4.85E-01,4.84E-01,4.83E-01,4.82E-01,4.81E-01,4.79E-01,4.78E-01,4.77E-01,4.76E-01,4.75E-01,4.73E-01,4.72E-01,4.71E-01,4.70E-01,4.68E-01,4.67E-01,4.66E-01,4.65E-01,4.63E-01,4.62E-01,4.61E-01,4.60E-01,4.59E-01,4.58E-01,4.57E-01,4.56E-01,4.55E-01,4.54E-01,4.53E-01,4.52E-01,4.50E-01,4.49E-01,4.48E-01,4.47E-01,4.46E-01,4.45E-01,4.44E-01,4.43E-01,4.42E-01,4.41E-01,4.40E-01,4.39E-01,4.38E-01,4.36E-01,4.35E-01,4.34E-01,4.32E-01,4.31E-01,4.30E-01,4.29E-01,4.27E-01,4.26E-01,4.25E-01,4.23E-01,4.22E-01,4.21E-01,4.20E-01,4.18E-01,4.17E-01,4.16E-01,4.14E-01,4.14E-01,4.13E-01,4.12E-01,4.11E-01,4.10E-01,4.09E-01,4.08E-01,4.07E-01,4.07E-01,4.06E-01,4.05E-01,4.04E-01,4.03E-01,4.02E-01,4.01E-01,4.00E-01,3.99E-01,3.98E-01,3.97E-01,3.96E-01,3.95E-01,3.94E-01,3.93E-01,3.92E-01,3.91E-01,3.91E-01,3.90E-01,3.89E-01,3.88E-01,3.87E-01,3.85E-01,3.82E-01,3.80E-01,3.78E-01,3.76E-01,3.74E-01,3.72E-01,3.70E-01,3.68E-01,3.65E-01,3.64E-01,3.63E-01,3.61E-01,3.60E-01,3.58E-01,3.57E-01,3.55E-01,3.54E-01,3.53E-01,3.51E-01,3.50E-01,3.49E-01,3.48E-01,3.47E-01,3.46E-01,3.45E-01,3.43E-01,3.42E-01,3.41E-01,3.40E-01,3.38E-01,3.37E-01,3.35E-01,3.33E-01,3.31E-01,3.29E-01,3.28E-01,3.26E-01,3.24E-01,3.22E-01,3.20E-01,3.18E-01,3.16E-01,3.14E-01,3.12E-01,3.10E-01,3.08E-01,3.06E-01,3.04E-01,3.02E-01,3.00E-01,2.98E-01,2.96E-01,2.94E-01,2.92E-01,2.90E-01,2.88E-01,2.86E-01,2.84E-01,2.82E-01,2.80E-01,2.78E-01,2.77E-01,2.75E-01,2.73E-01,2.71E-01,2.69E-01,2.67E-01,2.65E-01,2.64E-01,2.62E-01,2.60E-01,2.58E-01,2.57E-01,2.55E-01,2.53E-01,2.52E-01,2.50E-01,2.48E-01,2.46E-01,2.45E-01,2.43E-01,2.41E-01,2.40E-01,2.38E-01,2.37E-01,2.35E-01,2.33E-01,2.32E-01,2.30E-01,2.29E-01,2.27E-01,2.26E-01,2.24E-01,2.23E-01,2.22E-01,2.20E-01,2.19E-01,2.17E-01,2.16E-01,2.14E-01,2.13E-01,2.12E-01,2.10E-01,2.09E-01,2.07E-01,2.06E-01,2.05E-01,2.03E-01,2.02E-01,2.01E-01,1.99E-01,1.98E-01,1.97E-01,1.96E-01,1.94E-01,1.93E-01,1.92E-01,1.90E-01,1.89E-01,1.88E-01,1.87E-01,1.85E-01,1.84E-01,1.83E-01,1.82E-01,1.80E-01,1.79E-01,1.78E-01,1.77E-01,1.76E-01,1.74E-01,1.73E-01,1.72E-01,1.70E-01,1.69E-01,1.68E-01,1.67E-01,1.65E-01,1.64E-01,1.63E-01,1.61E-01,1.60E-01,1.59E-01,1.57E-01,1.56E-01,1.55E-01,1.53E-01,1.52E-01,1.50E-01,1.49E-01,1.48E-01,1.46E-01,1.45E-01,1.44E-01,1.42E-01,1.41E-01,1.40E-01,1.38E-01,1.37E-01,1.36E-01,1.35E-01,1.33E-01,1.32E-01,1.31E-01,1.30E-01,1.28E-01,1.27E-01,1.26E-01,1.25E-01,1.23E-01,1.22E-01,1.21E-01,1.20E-01,1.19E-01,1.18E-01,1.17E-01,1.16E-01,1.14E-01,1.13E-01,1.12E-01,1.11E-01,1.10E-01,1.09E-01,1.08E-01,1.07E-01,1.06E-01,1.05E-01,1.04E-01,1.02E-01,1.01E-01,1.00E-01,9.93E-02,9.83E-02,9.73E-02,9.63E-02,9.52E-02,9.42E-02,9.32E-02,9.22E-02,9.12E-02,9.02E-02,8.92E-02,8.83E-02,8.73E-02,8.63E-02,8.53E-02,8.44E-02,8.34E-02,8.24E-02,8.16E-02,8.07E-02,7.99E-02,7.90E-02,7.82E-02,7.73E-02,7.65E-02,7.56E-02,7.48E-02,7.39E-02,7.32E-02,7.25E-02,7.17E-02,7.10E-02,7.02E-02,6.95E-02,6.88E-02,6.80E-02,6.73E-02,6.65E-02,6.59E-02,6.52E-02,6.45E-02,6.39E-02,6.32E-02,6.25E-02,6.18E-02,6.12E-02,6.05E-02,5.98E-02,5.91E-02,5.84E-02,5.77E-02,5.70E-02,5.63E-02,5.56E-02,5.49E-02,5.42E-02,5.35E-02,5.28E-02,5.23E-02,5.17E-02,5.11E-02,5.05E-02,4.99E-02,4.93E-02,4.87E-02,4.82E-02,4.76E-02,4.70E-02,4.65E-02,4.59E-02,4.54E-02,4.49E-02,4.44E-02,4.39E-02,4.33E-02,4.28E-02,4.23E-02,4.18E-02,4.13E-02,4.08E-02,4.03E-02,3.99E-02,3.94E-02,3.89E-02,3.84E-02,3.79E-02,3.75E-02,3.70E-02,3.66E-02,3.62E-02,3.57E-02,3.53E-02,3.49E-02,3.45E-02,3.41E-02,3.37E-02,3.33E-02,3.29E-02,3.25E-02,3.21E-02,3.18E-02,3.14E-02,3.10E-02,3.07E-02,3.03E-02,2.99E-02,2.95E-02,2.92E-02,2.89E-02,2.85E-02,2.82E-02,2.79E-02,2.75E-02,2.72E-02,2.69E-02,2.66E-02,2.62E-02,2.59E-02,2.56E-02,2.53E-02,2.50E-02,2.47E-02,2.44E-02,2.41E-02,2.38E-02,2.35E-02,2.32E-02,2.29E-02,2.26E-02,2.24E-02,2.21E-02,2.19E-02,2.16E-02,2.13E-02,2.11E-02,2.08E-02,2.06E-02,2.03E-02,2.01E-02,1.98E-02,1.96E-02,1.94E-02,1.92E-02,1.89E-02,1.87E-02,1.85E-02,1.83E-02,1.80E-02,1.78E-02,1.76E-02,1.74E-02,1.72E-02,1.70E-02,1.68E-02,1.66E-02,1.64E-02,1.62E-02,1.60E-02,1.59E-02,1.57E-02,1.55E-02,1.53E-02,1.52E-02,1.50E-02,1.48E-02,1.46E-02,1.45E-02,1.43E-02,1.41E-02,1.40E-02,1.39E-02,1.37E-02,1.36E-02,1.34E-02,1.33E-02,1.31E-02,1.30E-02,1.29E-02,1.28E-02,1.27E-02,1.26E-02,1.25E-02,1.24E-02,1.23E-02,1.22E-02,1.21E-02,1.20E-02,1.19E-02,1.18E-02,1.17E-02,1.16E-02,1.15E-02,1.14E-02,1.13E-02,1.12E-02,1.11E-02,1.10E-02,1.09E-02,1.08E-02,1.07E-02,1.06E-02,1.05E-02,1.04E-02,1.03E-02,1.02E-02,1.01E-02,9.98E-03,9.88E-03,9.79E-03,9.69E-03,9.60E-03,9.50E-03,9.40E-03,9.31E-03,9.21E-03,9.12E-03,9.03E-03,8.93E-03,8.84E-03,8.74E-03,8.65E-03,8.56E-03,8.46E-03,8.37E-03,8.28E-03,8.19E-03,8.10E-03,8.00E-03,7.91E-03,7.82E-03,7.73E-03,7.64E-03,7.55E-03,7.46E-03,7.37E-03,7.28E-03,7.20E-03,7.11E-03,7.02E-03,6.93E-03,6.84E-03,6.76E-03,6.67E-03,6.59E-03,6.50E-03,6.41E-03,6.33E-03,6.24E-03,6.16E-03,6.08E-03,5.99E-03,5.91E-03,5.83E-03,5.75E-03,5.66E-03,5.58E-03,5.50E-03,5.42E-03,5.34E-03,5.26E-03,5.18E-03,5.10E-03,5.02E-03,4.95E-03,4.87E-03,4.79E-03,4.71E-03,4.64E-03,4.56E-03,4.49E-03,4.41E-03,4.34E-03,4.26E-03,4.19E-03,4.12E-03,4.04E-03,3.97E-03,3.90E-03,3.83E-03,3.76E-03,3.69E-03,3.62E-03,3.55E-03,3.48E-03,3.42E-03,3.35E-03,3.28E-03,3.22E-03,3.15E-03,3.09E-03,3.02E-03,2.96E-03,2.89E-03,2.83E-03,2.77E-03,2.71E-03,2.65E-03,2.59E-03,2.53E-03,2.47E-03,2.41E-03,2.35E-03,2.29E-03,2.23E-03,2.18E-03,2.12E-03,2.07E-03,2.01E-03,1.96E-03,1.91E-03,1.85E-03,1.80E-03,1.75E-03,1.70E-03,1.65E-03,1.60E-03,1.55E-03,1.50E-03,1.46E-03,1.41E-03,1.36E-03,1.32E-03,1.27E-03,1.23E-03,1.19E-03,1.14E-03,1.10E-03,1.06E-03,1.02E-03,9.81E-04,9.42E-04,9.04E-04,8.67E-04,8.30E-04,7.94E-04,7.58E-04,7.24E-04,6.90E-04,6.57E-04,6.25E-04,5.93E-04,5.63E-04,5.33E-04,5.03E-04,4.75E-04,4.47E-04,4.21E-04,3.94E-04,3.69E-04,3.45E-04,3.21E-04,2.98E-04,2.76E-04,2.55E-04,2.34E-04,2.15E-04,1.96E-04,1.78E-04,1.61E-04,1.45E-04,1.29E-04,1.15E-04,1.01E-04,8.80E-05,7.60E-05,6.49E-05,5.46E-05,4.52E-05,3.67E-05,2.90E-05,2.23E-05,1.64E-05,1.14E-05,7.30E-06,4.11E-06,1.83E-06,4.58E-07,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00])
Ppro_k_Cw = np.array([5.80E-05,5.85E-05,5.90E-05,5.99E-05,6.10E-05,6.20E-05,6.30E-05,6.40E-05,6.50E-05,6.60E-05,6.70E-05,6.79E-05,6.90E-05,7.05E-05,7.20E-05,7.31E-05,7.40E-05,7.49E-05,7.60E-05,7.74E-05,7.90E-05,8.06E-05,8.20E-05,8.30E-05,8.40E-05,8.55E-05,8.70E-05,8.80E-05,8.90E-05,9.05E-05,9.20E-05,9.30E-05,9.40E-05,9.55E-05,9.70E-05,9.80E-05,9.90E-05,1.01E-04,1.02E-04,1.03E-04,1.04E-04,1.05E-04,1.06E-04,1.07E-04,1.08E-04,1.09E-04,1.10E-04,1.11E-04,1.12E-04,1.13E-04,1.14E-04,1.15E-04,1.16E-04,1.17E-04,1.18E-04,1.19E-04,1.20E-04,1.21E-04,1.22E-04,1.23E-04,1.24E-04,1.25E-04,1.26E-04,1.27E-04,1.28E-04,1.29E-04,1.30E-04,1.32E-04,1.33E-04,1.34E-04,1.35E-04,1.36E-04,1.38E-04,1.40E-04,1.41E-04,1.42E-04,1.44E-04,1.46E-04,1.48E-04,1.50E-04,1.52E-04,1.54E-04,1.57E-04,1.60E-04,1.62E-04,1.64E-04,1.67E-04,1.70E-04,1.74E-04,1.78E-04,1.81E-04,1.85E-04,1.89E-04,1.93E-04,1.98E-04,2.03E-04,2.09E-04,2.16E-04,2.23E-04,2.30E-04,2.38E-04,2.46E-04,2.55E-04,2.64E-04,2.73E-04,2.82E-04,2.91E-04,3.00E-04,3.10E-04,3.19E-04,3.29E-04,3.39E-04,3.49E-04,3.59E-04,3.68E-04,3.77E-04,3.86E-04,3.96E-04,4.04E-04,4.07E-04,4.09E-04,4.14E-04,4.16E-04,4.11E-04,4.09E-04,4.18E-04,4.27E-04,4.27E-04,4.23E-04,4.24E-04,4.29E-04,4.37E-04,4.45E-04,4.51E-04,4.56E-04,4.63E-04,4.70E-04,4.75E-04,4.80E-04,4.88E-04,4.95E-04,4.98E-04,5.03E-04,5.14E-04,5.27E-04,5.36E-04,5.44E-04,5.53E-04,5.64E-04,5.76E-04,5.88E-04,6.00E-04,6.11E-04,6.22E-04,6.31E-04,6.39E-04,6.46E-04,6.52E-04,6.58E-04,6.65E-04,6.72E-04,6.79E-04,6.86E-04,6.92E-04,6.99E-04,7.08E-04,7.18E-04,7.26E-04,7.34E-04,7.46E-04,7.59E-04,7.73E-04,7.87E-04,8.02E-04,8.19E-04,8.39E-04,8.58E-04,8.75E-04,8.96E-04,9.24E-04,9.52E-04,9.75E-04,1.00E-03,1.04E-03,1.08E-03,1.12E-03,1.16E-03,1.20E-03,1.25E-03,1.30E-03,1.36E-03,1.41E-03,1.46E-03,1.51E-03,1.57E-03,1.64E-03,1.70E-03,1.76E-03,1.86E-03,2.04E-03,2.22E-03,2.32E-03,2.37E-03,2.40E-03,2.45E-03,2.52E-03,2.59E-03,2.63E-03,2.65E-03,2.67E-03,2.69E-03,2.70E-03,2.72E-03,2.73E-03,2.74E-03,2.75E-03,2.76E-03,2.78E-03,2.79E-03,2.80E-03,2.81E-03,2.82E-03,2.84E-03,2.85E-03,2.87E-03,2.88E-03,2.89E-03,2.91E-03,2.92E-03,2.94E-03,2.96E-03,2.97E-03,2.99E-03,3.00E-03,3.01E-03,3.02E-03,3.04E-03,3.06E-03,3.08E-03,3.09E-03,3.11E-03,3.13E-03,3.14E-03,3.16E-03,3.18E-03,3.20E-03,3.22E-03,3.24E-03,3.26E-03,3.29E-03,3.32E-03,3.34E-03,3.36E-03,3.39E-03,3.42E-03,3.46E-03,3.51E-03,3.57E-03,3.64E-03,3.71E-03,3.79E-03,3.87E-03,3.93E-03,3.98E-03,4.02E-03,4.05E-03,4.07E-03,4.09E-03,4.10E-03,4.11E-03,4.12E-03,4.14E-03,4.15E-03,4.16E-03,4.17E-03,4.20E-03,4.22E-03,4.25E-03,4.27E-03,4.29E-03,4.32E-03,4.35E-03,4.38E-03,4.42E-03,4.46E-03,4.50E-03,4.55E-03,4.59E-03,4.65E-03,4.70E-03,4.76E-03,4.83E-03,4.90E-03,4.99E-03,5.07E-03,5.15E-03,5.24E-03,5.35E-03,5.47E-03,5.59E-03,5.72E-03,5.86E-03,6.00E-03,6.15E-03,6.30E-03,6.46E-03,6.63E-03,6.80E-03,6.99E-03,7.20E-03,7.42E-03,7.65E-03,7.89E-03,8.16E-03,8.45E-03,8.76E-03,9.11E-03,9.48E-03,9.87E-03,1.03E-02,1.07E-02,1.12E-02,1.17E-02,1.22E-02,1.27E-02,1.32E-02,1.37E-02,1.43E-02,1.49E-02,1.55E-02,1.62E-02,1.70E-02,1.79E-02,1.89E-02,1.99E-02,2.10E-02,2.21E-02,2.31E-02,2.39E-02,2.47E-02,2.53E-02,2.58E-02,2.62E-02,2.65E-02,2.67E-02,2.69E-02,2.70E-02,2.71E-02,2.72E-02,2.73E-02,2.73E-02,2.74E-02,2.74E-02,2.75E-02,2.75E-02,2.75E-02,2.75E-02,2.76E-02,2.76E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.77E-02,2.76E-02,2.76E-02,2.75E-02,2.75E-02,2.75E-02,2.74E-02,2.73E-02,2.72E-02,2.71E-02,2.70E-02,2.69E-02,2.68E-02,2.66E-02,2.65E-02,2.63E-02,2.62E-02,2.61E-02,2.59E-02,2.56E-02,2.52E-02,2.51E-02,2.50E-02,2.47E-02,2.45E-02,2.41E-02,2.39E-02,2.37E-02,2.36E-02,2.34E-02,2.32E-02,2.30E-02,2.28E-02,2.25E-02,2.24E-02,2.24E-02,2.22E-02,2.20E-02,2.20E-02,2.20E-02,2.20E-02,2.18E-02,2.19E-02,2.19E-02,2.19E-02,2.20E-02,2.21E-02,2.22E-02,2.23E-02,2.25E-02,2.28E-02,2.30E-02,2.31E-02,2.33E-02,2.39E-02,2.45E-02,2.48E-02,2.52E-02,2.62E-02,2.77E-02,2.83E-02,2.91E-02,3.11E-02,3.21E-02,3.30E-02,3.46E-02,3.61E-02,3.66E-02,3.70E-02,3.79E-02,3.83E-02,3.85E-02,3.91E-02,3.95E-02,3.97E-02,4.00E-02,4.04E-02,4.06E-02,4.08E-02,4.12E-02,4.13E-02,4.15E-02,4.20E-02,4.20E-02,4.22E-02,4.25E-02,4.27E-02,4.28E-02,4.31E-02,4.36E-02,4.37E-02,4.38E-02,4.43E-02,4.45E-02,4.47E-02,4.51E-02,4.53E-02,4.55E-02,4.61E-02,4.66E-02,4.69E-02,4.71E-02,4.71E-02,4.75E-02,4.83E-02,4.87E-02,4.89E-02,4.96E-02,5.01E-02,5.05E-02,5.12E-02,5.15E-02,5.20E-02,5.30E-02,5.35E-02,5.39E-02,5.47E-02,5.53E-02,5.57E-02,5.60E-02,5.65E-02,5.75E-02,5.79E-02,5.83E-02,5.92E-02,5.98E-02,6.01E-02,6.04E-02,6.09E-02,6.19E-02,6.23E-02,6.27E-02,6.36E-02,6.41E-02,6.46E-02,6.56E-02,6.64E-02,6.67E-02,6.70E-02,6.77E-02,6.90E-02,6.99E-02,7.04E-02,7.09E-02,7.19E-02,7.36E-02,7.49E-02,7.56E-02,7.63E-02,7.79E-02,8.09E-02,8.29E-02,8.41E-02,8.53E-02,8.80E-02,9.27E-02,9.58E-02,9.82E-02,1.01E-01,1.04E-01,1.07E-01,1.11E-01,1.19E-01,1.25E-01,1.28E-01,1.33E-01,1.37E-01,1.41E-01,1.47E-01,1.56E-01,1.64E-01,1.69E-01,1.73E-01,1.82E-01,1.96E-01,2.05E-01,2.11E-01,2.19E-01,2.29E-01,2.39E-01,2.47E-01,2.54E-01,2.70E-01,2.98E-01,3.15E-01,3.27E-01,3.44E-01,3.62E-01,3.79E-01,3.93E-01,4.07E-01,4.18E-01,4.27E-01,4.39E-01,4.54E-01,4.61E-01,4.63E-01,4.66E-01,4.70E-01,4.73E-01,4.76E-01,4.77E-01,4.79E-01,4.80E-01,4.81E-01,4.83E-01,4.84E-01,4.86E-01,4.87E-01,4.87E-01,4.86E-01,4.86E-01,4.84E-01,4.82E-01,4.80E-01,4.79E-01,4.76E-01,4.74E-01,4.71E-01,4.68E-01,4.64E-01,4.60E-01,4.57E-01,4.53E-01,4.48E-01,4.43E-01,4.40E-01,4.36E-01,4.32E-01,4.27E-01,4.22E-01,4.17E-01,4.12E-01,4.07E-01,4.02E-01,3.96E-01,3.92E-01,3.87E-01,3.82E-01,3.76E-01,3.70E-01,3.64E-01,3.58E-01,3.52E-01,3.46E-01,3.40E-01,3.35E-01,3.30E-01,3.24E-01,3.19E-01,3.14E-01,3.09E-01,3.02E-01,2.96E-01,2.90E-01,2.84E-01,2.78E-01,2.72E-01,2.67E-01,2.62E-01,2.57E-01,2.51E-01,2.44E-01,2.39E-01,2.36E-01,2.33E-01,2.30E-01,2.25E-01,2.20E-01,2.15E-01,2.11E-01,2.06E-01,2.02E-01,1.98E-01,1.94E-01,1.90E-01,1.87E-01,1.84E-01,1.82E-01,1.79E-01,1.75E-01,1.72E-01,1.69E-01,1.66E-01,1.64E-01,1.61E-01,1.59E-01,1.56E-01,1.55E-01,1.53E-01,1.52E-01,1.51E-01,1.50E-01,1.48E-01,1.46E-01,1.45E-01,1.44E-01,1.44E-01,1.43E-01,1.43E-01,1.42E-01,1.41E-01,1.41E-01,1.41E-01,1.41E-01,1.41E-01,1.41E-01,1.41E-01,1.41E-01,1.43E-01,1.44E-01,1.44E-01,1.44E-01,1.44E-01,1.46E-01,1.48E-01,1.50E-01,1.52E-01,1.53E-01,1.55E-01,1.56E-01,1.58E-01,1.60E-01,1.63E-01,1.66E-01,1.68E-01,1.69E-01,1.71E-01,1.74E-01,1.78E-01,1.82E-01,1.87E-01,1.89E-01,1.91E-01,1.93E-01,1.97E-01,2.01E-01,2.03E-01,2.05E-01,2.08E-01,2.12E-01,2.17E-01,2.20E-01,2.22E-01,2.25E-01,2.30E-01,2.34E-01,2.35E-01,2.34E-01,2.35E-01,2.40E-01,2.45E-01,2.49E-01,2.53E-01,2.58E-01,2.65E-01,2.72E-01,2.77E-01,2.81E-01,2.89E-01,3.02E-01,3.16E-01,3.27E-01,3.38E-01,3.53E-01,3.77E-01,4.04E-01,4.28E-01,4.50E-01,4.71E-01,4.93E-01,5.20E-01,5.57E-01,6.05E-01,6.52E-01,6.86E-01,7.16E-01,7.54E-01,8.06E-01,8.60E-01,8.98E-01,9.25E-01,9.49E-01,9.77E-01,1.01E+00,1.04E+00,1.07E+00,1.10E+00,1.12E+00,1.13E+00,1.14E+00,1.15E+00,1.16E+00,1.17E+00,1.18E+00,1.19E+00,1.19E+00,1.20E+00,1.20E+00,1.20E+00,1.20E+00,1.21E+00,1.21E+00,1.21E+00,1.21E+00,1.22E+00,1.23E+00,1.23E+00,1.23E+00,1.23E+00,1.23E+00,1.23E+00,1.24E+00,1.24E+00,1.24E+00,1.24E+00,1.25E+00,1.25E+00,1.26E+00,1.26E+00,1.26E+00,1.26E+00,1.27E+00,1.27E+00,1.27E+00,1.27E+00,1.28E+00,1.28E+00,1.28E+00,1.28E+00,1.28E+00,1.28E+00,1.28E+00,1.27E+00,1.27E+00,1.27E+00,1.27E+00,1.27E+00,1.27E+00,1.27E+00,1.26E+00,1.26E+00,1.26E+00,1.26E+00,1.25E+00,1.25E+00,1.24E+00,1.24E+00,1.24E+00,1.24E+00,1.23E+00,1.22E+00,1.22E+00,1.21E+00,1.21E+00,1.21E+00,1.21E+00,1.21E+00,1.20E+00,1.20E+00,1.20E+00,1.20E+00,1.19E+00,1.19E+00,1.18E+00,1.18E+00,1.18E+00,1.17E+00,1.17E+00,1.16E+00,1.16E+00,1.16E+00,1.16E+00,1.16E+00,1.15E+00,1.15E+00,1.14E+00,1.14E+00,1.13E+00,1.13E+00,1.13E+00,1.12E+00,1.12E+00,1.12E+00,1.11E+00,1.11E+00,1.10E+00,1.10E+00,1.10E+00,1.10E+00,1.10E+00,1.10E+00,1.10E+00,1.09E+00,1.09E+00,1.09E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.08E+00,1.09E+00,1.09E+00,1.10E+00,1.10E+00,1.11E+00,1.11E+00,1.11E+00,1.12E+00,1.12E+00,1.13E+00,1.14E+00,1.15E+00,1.16E+00,1.16E+00,1.17E+00,1.18E+00,1.18E+00,1.19E+00,1.20E+00,1.21E+00,1.22E+00,1.23E+00,1.24E+00,1.25E+00,1.27E+00,1.28E+00,1.30E+00,1.31E+00,1.32E+00,1.34E+00,1.35E+00,1.37E+00,1.39E+00,1.42E+00,1.44E+00,1.47E+00,1.49E+00,1.51E+00,1.53E+00,1.56E+00,1.58E+00,1.61E+00,1.64E+00,1.67E+00,1.70E+00,1.73E+00,1.76E+00,1.79E+00,1.83E+00,1.87E+00,1.91E+00,1.94E+00,1.97E+00,2.01E+00,2.05E+00,2.10E+00,2.15E+00,2.20E+00,2.24E+00,2.28E+00,2.31E+00,2.36E+00,2.42E+00,2.48E+00,2.54E+00,2.59E+00,2.63E+00,2.67E+00,2.70E+00,2.74E+00,2.78E+00,2.83E+00,2.89E+00,2.96E+00,3.03E+00,3.10E+00,3.15E+00,3.18E+00,3.23E+00,3.27E+00,3.32E+00,3.36E+00,3.41E+00,3.45E+00,3.50E+00,3.54E+00,3.60E+00,3.65E+00,3.70E+00,3.75E+00,3.80E+00,3.87E+00,3.93E+00,3.99E+00,4.06E+00,4.13E+00,4.22E+00,4.30E+00,4.39E+00,4.50E+00,4.63E+00,4.74E+00,4.90E+00,5.09E+00,5.26E+00,5.48E+00,5.72E+00,6.01E+00,6.24E+00,6.58E+00,6.93E+00,7.31E+00,7.63E+00,8.09E+00,8.55E+00,9.03E+00,9.59E+00,1.00E+01,1.06E+01,1.12E+01,1.18E+01,1.25E+01,1.32E+01,1.37E+01,1.43E+01,1.51E+01,1.58E+01,1.65E+01,1.71E+01,1.78E+01,1.85E+01,1.92E+01,1.98E+01,2.03E+01,2.09E+01,2.15E+01,2.20E+01,2.26E+01,2.31E+01,2.36E+01,2.41E+01,2.45E+01,2.49E+01,2.53E+01,2.57E+01,2.61E+01,2.64E+01,2.67E+01,2.70E+01,2.73E+01,2.76E+01,2.78E+01,2.81E+01,2.84E+01,2.86E+01,2.88E+01,2.89E+01,2.91E+01,2.93E+01,2.94E+01,2.96E+01,2.97E+01,2.98E+01,2.99E+01,3.00E+01,3.01E+01,3.02E+01,3.03E+01,3.04E+01,3.04E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.06E+01,3.06E+01,3.06E+01,3.06E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.04E+01,3.04E+01,3.03E+01,3.02E+01,3.01E+01,3.01E+01,3.00E+01,2.98E+01,2.97E+01,2.96E+01,2.94E+01,2.92E+01,2.90E+01,2.87E+01,2.85E+01,2.83E+01,2.80E+01,2.78E+01,2.75E+01,2.72E+01,2.70E+01,2.66E+01,2.64E+01,2.61E+01,2.58E+01,2.56E+01,2.52E+01,2.50E+01,2.47E+01,2.44E+01,2.41E+01,2.39E+01,2.36E+01,2.33E+01,2.31E+01,2.27E+01,2.25E+01,2.22E+01,2.19E+01,2.16E+01,2.14E+01,2.11E+01,2.08E+01,2.05E+01,2.03E+01,2.00E+01,1.97E+01,1.95E+01,1.92E+01,1.90E+01,1.87E+01,1.85E+01,1.83E+01,1.80E+01,1.78E+01,1.76E+01,1.73E+01,1.71E+01,1.69E+01,1.67E+01,1.65E+01,1.62E+01,1.61E+01,1.58E+01,1.56E+01,1.55E+01,1.53E+01,1.50E+01,1.49E+01,1.47E+01,1.45E+01,1.43E+01,1.41E+01,1.40E+01,1.38E+01,1.36E+01,1.35E+01,1.33E+01,1.32E+01,1.30E+01,1.28E+01,1.27E+01,1.25E+01,1.24E+01,1.22E+01,1.21E+01,1.19E+01,1.18E+01,1.17E+01,1.15E+01,1.14E+01,1.13E+01,1.11E+01,1.10E+01,1.09E+01,1.08E+01,1.06E+01,1.05E+01,1.04E+01,1.03E+01,1.02E+01,1.01E+01,1.00E+01,9.91E+00,9.84E+00,9.75E+00,9.66E+00,9.56E+00,9.48E+00,9.38E+00,9.31E+00,9.20E+00,9.13E+00,9.05E+00,8.98E+00,8.90E+00,8.82E+00,8.74E+00,8.67E+00,8.59E+00,8.51E+00,8.45E+00,8.36E+00,8.30E+00,8.23E+00,8.16E+00,8.10E+00,8.04E+00,7.96E+00,7.89E+00,7.83E+00,7.77E+00,7.71E+00,7.65E+00,7.61E+00,7.55E+00,7.50E+00,7.43E+00,7.37E+00,7.32E+00,7.25E+00,7.20E+00,7.16E+00,7.12E+00,7.08E+00,7.04E+00,6.99E+00,6.94E+00,6.91E+00,6.87E+00,6.83E+00,6.78E+00,6.74E+00,6.71E+00,6.70E+00,6.65E+00,6.63E+00,6.60E+00,6.57E+00,6.53E+00,6.50E+00,6.47E+00,6.45E+00,6.42E+00,6.40E+00,6.36E+00,6.35E+00,6.31E+00,6.28E+00,6.25E+00,6.21E+00,6.19E+00,6.16E+00,6.13E+00,6.12E+00,6.09E+00,6.08E+00,6.05E+00,6.05E+00,6.02E+00,6.01E+00,5.98E+00,5.97E+00,5.95E+00,5.94E+00,5.92E+00,5.91E+00,5.89E+00,5.88E+00,5.85E+00,5.83E+00,5.80E+00,5.79E+00,5.75E+00,5.75E+00,5.72E+00,5.71E+00,5.69E+00,5.68E+00,5.66E+00,5.66E+00,5.64E+00,5.65E+00,5.63E+00,5.63E+00,5.62E+00,5.62E+00,5.60E+00,5.61E+00,5.60E+00,5.60E+00,5.58E+00,5.58E+00,5.56E+00,5.56E+00,5.55E+00,5.55E+00,5.54E+00,5.54E+00,5.53E+00,5.53E+00,5.53E+00,5.53E+00,5.53E+00,5.53E+00,5.52E+00,5.52E+00,5.52E+00,5.53E+00,5.52E+00,5.52E+00,5.52E+00,5.52E+00,5.51E+00,5.53E+00,5.51E+00,5.52E+00,5.52E+00,5.52E+00,5.51E+00,5.52E+00,5.52E+00,5.54E+00,5.54E+00,5.54E+00,5.56E+00,5.57E+00,5.58E+00,5.61E+00,5.61E+00,5.63E+00,5.64E+00,5.66E+00,5.67E+00,5.69E+00,5.70E+00,5.73E+00,5.75E+00,5.77E+00,5.78E+00,5.80E+00,5.81E+00,5.83E+00,5.84E+00,5.88E+00,5.89E+00,5.93E+00,5.95E+00,5.97E+00,6.00E+00,6.03E+00,6.05E+00,6.09E+00,6.10E+00,6.14E+00,6.17E+00,6.20E+00,6.22E+00,6.26E+00,6.28E+00,6.34E+00,6.37E+00,6.39E+00,6.45E+00,6.49E+00,6.52E+00,6.57E+00,6.62E+00,6.66E+00,6.69E+00,6.75E+00,6.80E+00,6.84E+00,6.90E+00,6.96E+00,7.00E+00,7.05E+00,7.11E+00,7.18E+00,7.24E+00,7.27E+00,7.34E+00,7.41E+00,7.48E+00,7.54E+00,7.59E+00,7.67E+00,7.73E+00,7.78E+00,7.83E+00,7.89E+00,7.95E+00,8.00E+00,8.05E+00,8.10E+00,8.16E+00,8.21E+00,8.24E+00,8.26E+00,8.32E+00,8.35E+00,8.39E+00,8.43E+00,8.45E+00,8.48E+00,8.51E+00,8.54E+00,8.56E+00,8.59E+00,8.62E+00,8.64E+00,8.67E+00,8.69E+00,8.72E+00,8.74E+00,8.76E+00,8.78E+00,8.78E+00,8.78E+00,8.79E+00,8.81E+00,8.81E+00,8.81E+00,8.81E+00,8.80E+00,8.80E+00,8.79E+00,8.78E+00,8.77E+00,8.75E+00,8.75E+00,8.74E+00,8.74E+00,8.74E+00,8.74E+00,8.75E+00,8.76E+00,8.78E+00,8.79E+00,8.79E+00,8.80E+00,8.79E+00,8.81E+00,8.82E+00,8.84E+00,8.85E+00,8.85E+00,8.86E+00,8.87E+00,8.87E+00,8.88E+00,8.89E+00,8.90E+00,8.92E+00,8.95E+00,8.97E+00,9.01E+00,9.03E+00,9.11E+00,9.15E+00,9.20E+00,9.26E+00,9.32E+00,9.38E+00,9.46E+00,9.54E+00,9.63E+00,9.72E+00,9.82E+00,9.94E+00,1.01E+01,1.02E+01,1.03E+01,1.04E+01,1.06E+01,1.08E+01,1.09E+01,1.11E+01,1.14E+01,1.16E+01,1.18E+01,1.21E+01,1.24E+01,1.27E+01,1.30E+01,1.33E+01,1.38E+01,1.41E+01,1.48E+01,1.53E+01,1.59E+01,1.64E+01,1.71E+01,1.77E+01,1.85E+01,1.93E+01,2.05E+01,2.15E+01,2.25E+01,2.37E+01,2.48E+01,2.62E+01,2.75E+01,2.97E+01,3.14E+01,3.32E+01,3.50E+01,3.73E+01,3.93E+01,4.27E+01,4.53E+01,4.79E+01,5.06E+01,5.36E+01,5.76E+01,6.09E+01,6.40E+01,6.72E+01,7.06E+01,7.50E+01,7.84E+01,8.16E+01,8.47E+01,8.75E+01,9.19E+01,9.46E+01,9.72E+01,1.00E+02,1.03E+02,1.06E+02,1.08E+02,1.10E+02,1.12E+02,1.14E+02,1.16E+02,1.17E+02,1.19E+02,1.20E+02,1.22E+02,1.23E+02,1.24E+02,1.25E+02,1.26E+02,1.27E+02,1.28E+02,1.28E+02,1.29E+02,1.29E+02,1.30E+02,1.30E+02,1.30E+02,1.30E+02,1.31E+02,1.31E+02,1.31E+02,1.31E+02,1.30E+02,1.30E+02,1.30E+02,1.30E+02,1.29E+02,1.29E+02,1.28E+02,1.28E+02,1.27E+02,1.26E+02,1.26E+02,1.25E+02,1.24E+02,1.23E+02,1.22E+02,1.22E+02,1.21E+02,1.20E+02,1.19E+02,1.18E+02,1.17E+02,1.16E+02,1.15E+02,1.14E+02,1.13E+02,1.12E+02,1.11E+02,1.10E+02,1.09E+02,1.08E+02,1.07E+02,1.06E+02,1.04E+02,1.04E+02,1.02E+02,1.01E+02,1.01E+02,9.93E+01,9.83E+01,9.71E+01,9.63E+01,9.49E+01,9.41E+01,9.34E+01,9.21E+01,9.12E+01,9.01E+01,8.93E+01,8.80E+01,8.73E+01,8.61E+01,8.53E+01,8.46E+01,8.34E+01,8.26E+01,8.15E+01,8.08E+01,7.97E+01,7.90E+01,7.80E+01,7.72E+01,7.63E+01,7.56E+01,7.46E+01,7.39E+01,7.30E+01,7.23E+01,7.14E+01,7.08E+01,6.99E+01,6.92E+01,6.87E+01,6.78E+01,6.69E+01,6.63E+01,6.55E+01,6.49E+01,6.41E+01,6.36E+01,6.28E+01,6.23E+01,6.16E+01,6.11E+01,6.03E+01,5.98E+01,5.91E+01,5.86E+01,5.79E+01,5.75E+01,5.68E+01,5.63E+01,5.57E+01,5.50E+01,5.46E+01,5.40E+01,5.36E+01,5.29E+01,5.26E+01,5.20E+01,5.14E+01,5.10E+01,5.05E+01,5.01E+01,4.95E+01,4.92E+01,4.86E+01,4.81E+01,4.77E+01,4.72E+01,4.69E+01,4.64E+01,4.58E+01,4.55E+01,4.50E+01,4.47E+01,4.43E+01,4.38E+01,4.35E+01,4.30E+01,4.27E+01,4.23E+01,4.19E+01,4.16E+01,4.12E+01,4.07E+01,4.05E+01,4.00E+01,3.98E+01,3.93E+01,3.89E+01,3.87E+01,3.83E+01,3.79E+01,3.76E+01,3.73E+01,3.69E+01,3.66E+01,3.63E+01,3.59E+01,3.57E+01,3.54E+01,3.50E+01,3.48E+01,3.45E+01,3.41E+01,3.39E+01,3.36E+01,3.33E+01,3.31E+01,3.28E+01,3.25E+01,3.23E+01,3.20E+01,3.17E+01,3.15E+01,3.13E+01,3.10E+01,3.07E+01,3.05E+01,3.03E+01,3.00E+01,2.98E+01,2.96E+01,2.93E+01,2.91E+01,2.89E+01,2.87E+01,2.84E+01,2.82E+01,2.80E+01,2.78E+01,2.75E+01,2.74E+01,2.71E+01,2.69E+01,2.67E+01,2.66E+01,2.64E+01,2.62E+01,2.60E+01,2.58E+01,2.57E+01,2.55E+01,2.53E+01,2.52E+01,2.50E+01,2.49E+01,2.47E+01,2.46E+01,2.44E+01,2.42E+01,2.40E+01,2.39E+01,2.37E+01,2.36E+01,2.34E+01,2.33E+01,2.32E+01,2.30E+01,2.29E+01,2.28E+01,2.26E+01,2.25E+01,2.24E+01,2.23E+01,2.21E+01,2.20E+01,2.19E+01,2.18E+01,2.17E+01,2.16E+01,2.15E+01,2.14E+01,2.13E+01,2.12E+01,2.11E+01,2.10E+01,2.09E+01,2.09E+01,2.08E+01,2.07E+01,2.06E+01,2.05E+01,2.04E+01,2.03E+01,2.03E+01,2.02E+01,2.01E+01,2.00E+01,2.00E+01,1.99E+01,1.98E+01,1.98E+01,1.97E+01,1.96E+01,1.96E+01,1.95E+01,1.95E+01,1.94E+01,1.94E+01,1.93E+01,1.93E+01,1.92E+01,1.92E+01,1.91E+01,1.91E+01,1.90E+01,1.90E+01,1.90E+01,1.89E+01,1.88E+01,1.88E+01,1.87E+01,1.87E+01,1.87E+01,1.86E+01,1.86E+01,1.85E+01,1.85E+01,1.85E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.83E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.84E+01,1.85E+01,1.85E+01,1.85E+01,1.85E+01,1.86E+01,1.86E+01,1.86E+01,1.86E+01,1.87E+01,1.87E+01,1.87E+01,1.88E+01,1.88E+01,1.88E+01,1.89E+01,1.89E+01,1.90E+01,1.90E+01,1.91E+01,1.91E+01,1.92E+01,1.92E+01,1.93E+01,1.93E+01,1.94E+01,1.95E+01,1.95E+01,1.96E+01,1.97E+01,1.97E+01,1.98E+01,1.99E+01,1.99E+01,2.00E+01,2.00E+01,2.01E+01,2.02E+01,2.03E+01,2.04E+01,2.05E+01,2.05E+01,2.06E+01,2.07E+01,2.08E+01,2.09E+01,2.09E+01,2.10E+01,2.11E+01,2.13E+01,2.14E+01,2.15E+01,2.15E+01,2.16E+01,2.17E+01,2.18E+01,2.19E+01,2.20E+01,2.21E+01,2.22E+01,2.23E+01,2.25E+01,2.26E+01,2.28E+01,2.29E+01,2.30E+01,2.31E+01,2.33E+01,2.34E+01,2.35E+01,2.36E+01,2.38E+01,2.39E+01,2.41E+01,2.42E+01,2.43E+01,2.44E+01,2.46E+01,2.47E+01,2.49E+01,2.50E+01,2.52E+01,2.53E+01,2.55E+01,2.56E+01,2.58E+01,2.59E+01,2.61E+01,2.62E+01,2.65E+01,2.66E+01,2.68E+01,2.70E+01,2.71E+01,2.73E+01,2.74E+01,2.76E+01,2.79E+01,2.80E+01,2.82E+01,2.84E+01,2.86E+01,2.87E+01,2.90E+01,2.92E+01,2.93E+01,2.95E+01,2.97E+01,2.99E+01,3.00E+01,3.04E+01,3.05E+01,3.07E+01,3.09E+01,3.11E+01,3.15E+01,3.16E+01,3.18E+01,3.20E+01,3.22E+01,3.24E+01,3.27E+01,3.29E+01,3.31E+01,3.33E+01,3.35E+01,3.39E+01,3.40E+01,3.43E+01,3.45E+01,3.47E+01,3.49E+01,3.53E+01,3.55E+01,3.57E+01,3.59E+01,3.61E+01,3.66E+01,3.68E+01,3.70E+01,3.72E+01,3.76E+01,3.78E+01,3.80E+01,3.83E+01,3.85E+01,3.89E+01,3.91E+01,3.94E+01,3.96E+01,4.01E+01,4.02E+01,4.05E+01,4.08E+01,4.10E+01,4.15E+01,4.17E+01,4.20E+01,4.22E+01,4.27E+01,4.29E+01,4.32E+01,4.34E+01,4.39E+01,4.41E+01,4.44E+01,4.46E+01,4.51E+01,4.54E+01,4.57E+01,4.59E+01,4.64E+01,4.66E+01,4.69E+01,4.71E+01,4.76E+01,4.79E+01,4.82E+01,4.84E+01,4.89E+01,4.92E+01,4.94E+01,5.00E+01,5.02E+01,5.05E+01,5.08E+01,5.13E+01,5.16E+01,5.19E+01,5.25E+01,5.28E+01,5.31E+01,5.34E+01,5.40E+01,5.43E+01,5.46E+01,5.52E+01,5.56E+01,5.59E+01,5.62E+01,5.69E+01,5.71E+01,5.75E+01,5.81E+01,5.84E+01,5.88E+01,5.95E+01,5.98E+01,6.01E+01,6.04E+01,6.11E+01,6.15E+01,6.18E+01,6.25E+01,6.29E+01,6.32E+01,6.39E+01,6.43E+01,6.46E+01,6.54E+01,6.57E+01,6.61E+01,6.69E+01,6.73E+01,6.76E+01,6.84E+01,6.88E+01,6.92E+01,7.01E+01,7.05E+01,7.08E+01,7.17E+01,7.21E+01,7.25E+01,7.34E+01,7.38E+01,7.42E+01,7.51E+01,7.55E+01,7.59E+01,7.68E+01,7.72E+01,7.80E+01,7.84E+01,7.88E+01,7.97E+01,8.01E+01,8.05E+01,8.14E+01,8.17E+01,8.22E+01,8.30E+01,8.34E+01,8.42E+01,8.47E+01,8.51E+01,8.58E+01,8.62E+01,8.64E+01,8.71E+01,8.76E+01,8.88E+01,8.90E+01,8.95E+01,9.06E+01,9.09E+01,9.13E+01,9.20E+01,9.24E+01,9.31E+01,9.33E+01,9.36E+01,9.42E+01,9.45E+01,9.50E+01,9.53E+01])
Ppro_k_Cm = np.array([1.10E+02,1.04E+02,9.80E+01,9.24E+01,8.71E+01,8.23E+01,7.81E+01,7.40E+01,7.01E+01,6.65E+01,6.30E+01,5.95E+01,5.62E+01,5.30E+01,5.00E+01,4.72E+01,4.46E+01,4.22E+01,4.00E+01,3.78E+01,3.57E+01,3.36E+01,3.17E+01,2.99E+01,2.83E+01,2.68E+01,2.54E+01,2.40E+01,2.28E+01,2.15E+01,2.02E+01,1.90E+01,1.79E+01,1.68E+01,1.58E+01,1.48E+01,1.39E+01,1.31E+01,1.23E+01,1.16E+01,1.10E+01,1.04E+01,9.92E+00,9.41E+00,8.95E+00,8.51E+00,8.09E+00,7.64E+00,7.27E+00,6.94E+00,6.66E+00,6.42E+00,6.22E+00,6.01E+00,5.78E+00,5.57E+00,5.37E+00,5.17E+00,4.95E+00,4.76E+00,4.58E+00,4.42E+00,4.26E+00,4.12E+00,4.01E+00,3.95E+00,3.85E+00,3.78E+00,3.67E+00,3.55E+00,3.46E+00,3.36E+00,3.28E+00,3.18E+00,3.10E+00,3.05E+00,2.98E+00,2.95E+00,2.91E+00,2.87E+00,2.80E+00,2.78E+00,2.75E+00,2.73E+00,2.70E+00,2.68E+00,2.66E+00,2.63E+00,2.61E+00,2.59E+00,2.57E+00,2.55E+00,2.54E+00,2.52E+00,2.50E+00,2.49E+00,2.47E+00,2.46E+00,2.44E+00,2.43E+00,2.42E+00,2.41E+00,2.39E+00,2.38E+00,2.37E+00,2.37E+00,2.36E+00,2.35E+00,2.34E+00,2.33E+00,2.33E+00,2.32E+00,2.32E+00,2.31E+00,2.31E+00,2.31E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.30E+00,2.31E+00,2.31E+00,2.31E+00,2.31E+00,2.31E+00,2.32E+00,2.32E+00,2.32E+00,2.32E+00,2.33E+00,2.33E+00,2.33E+00,2.34E+00,2.34E+00,2.35E+00,2.35E+00,2.35E+00,2.36E+00,2.36E+00,2.37E+00,2.37E+00,2.38E+00,2.38E+00,2.39E+00,2.40E+00,2.40E+00,2.41E+00,2.41E+00,2.42E+00,2.42E+00,2.43E+00,2.44E+00,2.44E+00,2.45E+00,2.45E+00,2.46E+00,2.47E+00,2.47E+00,2.48E+00,2.49E+00,2.49E+00,2.50E+00,2.51E+00,2.51E+00,2.52E+00,2.53E+00,2.53E+00,2.54E+00,2.55E+00,2.55E+00,2.56E+00,2.56E+00,2.57E+00,2.58E+00,2.58E+00,2.59E+00,2.60E+00,2.60E+00,2.61E+00,2.61E+00,2.62E+00,2.63E+00,2.63E+00,2.64E+00,2.64E+00,2.65E+00,2.65E+00,2.66E+00,2.66E+00,2.67E+00,2.67E+00,2.68E+00,2.68E+00,2.69E+00,2.69E+00,2.69E+00,2.70E+00,2.70E+00,2.70E+00,2.71E+00,2.71E+00,2.71E+00,2.72E+00,2.72E+00,2.72E+00,2.72E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.72E+00,2.74E+00,2.73E+00,2.72E+00,2.71E+00,2.70E+00,2.70E+00,2.69E+00,2.69E+00,2.69E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.67E+00,2.67E+00,2.67E+00,2.67E+00,2.67E+00,2.67E+00,2.68E+00,2.67E+00,2.68E+00,2.68E+00,2.68E+00,2.67E+00,2.66E+00,2.67E+00,2.67E+00,2.67E+00,2.66E+00,2.66E+00,2.67E+00,2.67E+00,2.68E+00,2.69E+00,2.68E+00,2.70E+00,2.71E+00,2.72E+00,2.72E+00,2.73E+00,2.74E+00,2.74E+00,2.75E+00,2.76E+00,2.78E+00,2.79E+00,2.82E+00,2.84E+00,2.87E+00,2.88E+00,2.90E+00,2.92E+00,2.94E+00,2.95E+00,2.97E+00,2.98E+00,2.98E+00,2.94E+00,2.89E+00,2.86E+00,2.88E+00,2.89E+00,2.89E+00,2.89E+00,2.90E+00,2.89E+00,2.88E+00,2.90E+00,2.93E+00,2.97E+00,3.01E+00,3.05E+00,3.08E+00,3.11E+00,3.13E+00,3.13E+00,3.10E+00,3.05E+00,2.98E+00,2.94E+00,2.92E+00,2.93E+00,2.95E+00,2.98E+00,3.03E+00,3.05E+00,3.07E+00,3.09E+00,3.10E+00,3.09E+00,3.09E+00,3.08E+00,3.09E+00,3.07E+00,3.07E+00,3.07E+00,3.07E+00,3.09E+00,3.09E+00,3.11E+00,3.14E+00,3.15E+00,3.16E+00,3.19E+00,3.23E+00,3.27E+00,3.30E+00,3.36E+00,3.42E+00,3.48E+00,3.53E+00,3.58E+00,3.63E+00,3.71E+00,3.78E+00,3.85E+00,3.93E+00,3.99E+00,4.07E+00,4.16E+00,4.24E+00,4.32E+00,4.40E+00,4.48E+00,4.56E+00,4.64E+00,4.71E+00,4.78E+00,4.85E+00,4.91E+00,4.97E+00,5.03E+00,5.07E+00,5.13E+00,5.18E+00,5.22E+00,5.27E+00,5.32E+00,5.36E+00,5.40E+00,5.44E+00,5.46E+00,5.48E+00,5.50E+00,5.52E+00,5.55E+00,5.56E+00,5.58E+00,5.58E+00,5.60E+00,5.61E+00,5.64E+00,5.65E+00,5.68E+00,5.68E+00,5.69E+00,5.68E+00,5.69E+00,5.71E+00,5.72E+00,5.72E+00,5.72E+00,5.73E+00,5.74E+00,5.74E+00,5.75E+00,5.75E+00,5.74E+00,5.76E+00,5.77E+00,5.78E+00,5.79E+00,5.80E+00,5.81E+00,5.81E+00,5.82E+00,5.83E+00,5.82E+00,5.83E+00,5.85E+00,5.88E+00,5.90E+00,5.91E+00,5.92E+00,5.94E+00,5.96E+00,5.96E+00,5.97E+00,5.98E+00,5.99E+00,5.99E+00,6.02E+00,6.01E+00,6.03E+00,6.01E+00,6.02E+00,6.02E+00,6.03E+00,6.03E+00,6.04E+00,6.03E+00,6.01E+00,5.99E+00,5.99E+00,5.98E+00,5.97E+00,5.97E+00,5.97E+00,5.95E+00,5.95E+00,5.94E+00,5.93E+00,5.93E+00,5.93E+00,5.91E+00,5.90E+00,5.88E+00,5.88E+00,5.88E+00,5.86E+00,5.84E+00,5.83E+00,5.82E+00,5.81E+00,5.80E+00,5.79E+00,5.78E+00,5.78E+00,5.78E+00,5.77E+00,5.76E+00,5.77E+00,5.76E+00,5.76E+00,5.74E+00,5.74E+00,5.76E+00,5.76E+00,5.75E+00,5.75E+00,5.75E+00,5.75E+00,5.74E+00,5.74E+00,5.75E+00,5.74E+00,5.74E+00,5.74E+00,5.73E+00,5.73E+00,5.73E+00,5.72E+00,5.72E+00,5.72E+00,5.70E+00,5.69E+00,5.70E+00,5.70E+00,5.71E+00,5.73E+00,5.73E+00,5.74E+00,5.74E+00,5.75E+00,5.75E+00,5.74E+00,5.75E+00,5.75E+00,5.75E+00,5.75E+00,5.75E+00,5.74E+00,5.74E+00,5.75E+00,5.74E+00,5.76E+00,5.75E+00,5.75E+00,5.75E+00,5.73E+00,5.74E+00,5.72E+00,5.73E+00,5.71E+00,5.70E+00,5.70E+00,5.70E+00,5.69E+00,5.69E+00,5.67E+00,5.66E+00,5.63E+00,5.61E+00,5.59E+00,5.59E+00,5.56E+00,5.55E+00,5.53E+00,5.52E+00,5.51E+00,5.49E+00,5.46E+00,5.45E+00,5.44E+00,5.43E+00,5.41E+00,5.39E+00,5.38E+00,5.38E+00,5.36E+00,5.35E+00,5.33E+00,5.32E+00,5.30E+00,5.29E+00,5.28E+00,5.27E+00,5.26E+00,5.25E+00,5.25E+00,5.23E+00,5.22E+00,5.21E+00,5.20E+00,5.21E+00,5.20E+00,5.19E+00,5.19E+00,5.18E+00,5.18E+00,5.18E+00,5.17E+00,5.15E+00,5.14E+00,5.14E+00,5.13E+00,5.12E+00,5.11E+00,5.13E+00,5.11E+00,5.10E+00,5.10E+00,5.11E+00,5.11E+00,5.11E+00,5.13E+00,5.14E+00,5.13E+00,5.15E+00,5.18E+00,5.19E+00,5.20E+00,5.24E+00,5.26E+00,5.27E+00,5.29E+00,5.34E+00,5.37E+00,5.39E+00,5.43E+00,5.45E+00,5.49E+00,5.52E+00,5.56E+00,5.61E+00,5.65E+00,5.70E+00,5.74E+00,5.74E+00,5.64E+00,5.69E+00,5.72E+00,5.76E+00,5.80E+00,5.85E+00,5.88E+00,5.92E+00,5.97E+00,6.02E+00,6.06E+00,6.12E+00,6.17E+00,6.21E+00,6.27E+00,6.32E+00,6.38E+00,6.43E+00,6.49E+00,6.54E+00,6.58E+00,6.62E+00,6.67E+00,6.73E+00,6.77E+00,6.81E+00,6.86E+00,6.91E+00,6.96E+00,7.01E+00,7.05E+00,7.09E+00,7.14E+00,7.16E+00,7.20E+00,7.23E+00,7.27E+00,7.32E+00,7.34E+00,7.36E+00,7.40E+00,7.44E+00,7.47E+00,7.51E+00,7.53E+00,7.56E+00,7.58E+00,7.60E+00,7.63E+00,7.65E+00,7.67E+00,7.69E+00,7.70E+00,7.71E+00,7.72E+00,7.73E+00,7.73E+00,7.71E+00,7.70E+00,7.70E+00,7.67E+00,7.64E+00,7.62E+00,7.59E+00,7.56E+00,7.52E+00,7.48E+00,7.45E+00,7.44E+00,7.41E+00,7.38E+00,7.36E+00,7.35E+00,7.33E+00,7.33E+00,7.33E+00,7.30E+00,7.30E+00,7.30E+00,7.29E+00,7.29E+00,7.29E+00,7.28E+00,7.28E+00,7.26E+00,7.25E+00,7.24E+00,7.23E+00,7.21E+00,7.19E+00,7.16E+00,7.14E+00,7.11E+00,7.10E+00,7.07E+00,7.04E+00,7.00E+00,6.97E+00,6.93E+00,6.89E+00,6.84E+00,6.79E+00,6.76E+00,6.73E+00,6.69E+00,6.66E+00,6.61E+00,6.57E+00,6.55E+00,6.52E+00,6.51E+00,6.48E+00,6.48E+00,6.48E+00,6.49E+00,6.50E+00,6.49E+00,6.46E+00,6.44E+00,6.43E+00,6.41E+00,6.42E+00,6.40E+00,6.38E+00,6.37E+00,6.37E+00,6.35E+00,6.32E+00,6.31E+00,6.31E+00,6.28E+00,6.28E+00,6.27E+00,6.26E+00,6.24E+00,6.23E+00,6.22E+00,6.23E+00,6.22E+00,6.21E+00,6.19E+00,6.19E+00,6.18E+00,6.16E+00,6.14E+00,6.14E+00,6.12E+00,6.10E+00,6.09E+00,6.06E+00,6.06E+00,6.05E+00,6.04E+00,6.04E+00,6.01E+00,6.00E+00,5.99E+00,6.00E+00,5.98E+00,5.95E+00,5.95E+00,5.93E+00,5.91E+00,5.89E+00,5.87E+00,5.83E+00,5.79E+00,5.77E+00,5.73E+00,5.68E+00,5.68E+00,5.66E+00,5.65E+00,5.62E+00,5.59E+00,5.57E+00,5.56E+00,5.55E+00,5.55E+00,5.54E+00,5.52E+00,5.51E+00,5.51E+00,5.49E+00,5.47E+00,5.46E+00,5.45E+00,5.45E+00,5.44E+00,5.44E+00,5.44E+00,5.45E+00,5.47E+00,5.46E+00,5.45E+00,5.45E+00,5.41E+00,5.38E+00,5.28E+00,5.23E+00,5.20E+00,5.17E+00,5.14E+00,5.12E+00,5.11E+00,5.13E+00,5.14E+00,5.17E+00,5.18E+00,5.19E+00,5.18E+00,5.20E+00,5.20E+00,5.20E+00,5.22E+00,5.24E+00,5.30E+00,5.32E+00,5.38E+00,5.44E+00,5.49E+00,5.56E+00,5.63E+00,5.69E+00,5.76E+00,5.83E+00,5.91E+00,6.00E+00,6.09E+00,6.19E+00,6.33E+00,6.45E+00,6.58E+00,6.71E+00,6.84E+00,6.97E+00,7.11E+00,7.24E+00,7.39E+00,7.51E+00,7.64E+00,7.77E+00,7.87E+00,7.98E+00,8.07E+00,8.15E+00,8.22E+00,8.29E+00,8.35E+00,8.45E+00,8.52E+00,8.58E+00,8.67E+00,8.72E+00,8.76E+00,8.82E+00,8.86E+00,8.91E+00,8.94E+00,8.95E+00,8.96E+00,8.98E+00,9.02E+00,9.04E+00,9.04E+00,9.03E+00,9.03E+00,9.05E+00,9.05E+00,9.04E+00,9.04E+00,9.04E+00,9.04E+00,9.02E+00,9.02E+00,9.01E+00,8.97E+00,8.97E+00,8.95E+00,8.96E+00,8.94E+00,8.92E+00,8.91E+00,8.90E+00,8.89E+00,8.88E+00,8.87E+00,8.86E+00,8.85E+00,8.86E+00,8.86E+00,8.88E+00,8.87E+00,8.87E+00,8.86E+00,8.83E+00,8.84E+00,8.86E+00,8.86E+00,8.83E+00,8.84E+00,8.84E+00,8.83E+00,8.81E+00,8.82E+00,8.81E+00,8.80E+00,8.79E+00,8.79E+00,8.80E+00,8.77E+00,8.75E+00,8.76E+00,8.76E+00,8.75E+00,8.76E+00,8.78E+00,8.79E+00,8.80E+00,8.81E+00,8.85E+00,8.87E+00,8.89E+00,8.91E+00,8.94E+00,8.98E+00,8.99E+00,9.00E+00,9.03E+00,9.08E+00,9.11E+00,9.14E+00,9.17E+00,9.21E+00,9.26E+00,9.30E+00,9.36E+00,9.41E+00,9.45E+00,9.52E+00,9.58E+00,9.64E+00,9.69E+00,9.76E+00,9.85E+00,9.95E+00,1.00E+01,1.01E+01,1.03E+01,1.04E+01,1.05E+01,1.06E+01,1.08E+01,1.09E+01,1.10E+01,1.12E+01,1.14E+01,1.15E+01,1.17E+01,1.18E+01,1.20E+01,1.22E+01,1.23E+01,1.25E+01,1.27E+01,1.29E+01,1.31E+01,1.33E+01,1.35E+01,1.36E+01,1.38E+01,1.40E+01,1.42E+01,1.44E+01,1.46E+01,1.48E+01,1.50E+01,1.52E+01,1.53E+01,1.55E+01,1.57E+01,1.59E+01,1.61E+01,1.62E+01,1.64E+01,1.65E+01,1.67E+01,1.68E+01,1.69E+01,1.70E+01,1.71E+01,1.72E+01,1.73E+01,1.73E+01,1.74E+01,1.75E+01,1.76E+01,1.76E+01,1.77E+01,1.77E+01,1.78E+01,1.78E+01,1.79E+01,1.79E+01,1.80E+01,1.80E+01,1.81E+01,1.81E+01,1.81E+01,1.82E+01,1.83E+01,1.83E+01,1.84E+01,1.84E+01,1.85E+01,1.85E+01,1.86E+01,1.86E+01,1.87E+01,1.87E+01,1.88E+01,1.88E+01,1.89E+01,1.89E+01,1.90E+01,1.90E+01,1.91E+01,1.91E+01,1.92E+01,1.92E+01,1.93E+01,1.93E+01,1.93E+01,1.94E+01,1.94E+01,1.94E+01,1.94E+01,1.95E+01,1.95E+01,1.95E+01,1.96E+01,1.96E+01,1.96E+01,1.96E+01,1.97E+01,1.97E+01,1.97E+01,1.97E+01,1.97E+01,1.97E+01,1.97E+01,1.98E+01,1.98E+01,1.98E+01,1.98E+01,1.98E+01,1.98E+01,1.99E+01,1.99E+01,1.99E+01,1.99E+01,1.99E+01,1.99E+01,2.00E+01,2.00E+01,2.00E+01,2.00E+01,2.01E+01,2.01E+01,2.01E+01,2.02E+01,2.02E+01,2.02E+01,2.02E+01,2.02E+01,2.02E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.03E+01,2.02E+01,2.02E+01,2.02E+01,2.02E+01,2.01E+01,2.01E+01,2.01E+01,2.00E+01,2.00E+01,2.00E+01,1.99E+01,1.99E+01,1.98E+01,1.98E+01,1.97E+01,1.96E+01,1.96E+01,1.95E+01,1.95E+01,1.94E+01,1.94E+01,1.93E+01,1.92E+01,1.92E+01,1.91E+01,1.91E+01,1.90E+01,1.89E+01,1.89E+01,1.88E+01,1.87E+01,1.87E+01,1.86E+01,1.86E+01,1.85E+01,1.85E+01,1.84E+01,1.83E+01,1.83E+01,1.82E+01,1.82E+01,1.81E+01,1.81E+01,1.80E+01,1.80E+01,1.79E+01,1.79E+01,1.78E+01,1.78E+01,1.78E+01,1.77E+01,1.77E+01,1.77E+01,1.77E+01,1.76E+01,1.76E+01,1.76E+01,1.76E+01,1.76E+01,1.77E+01,1.77E+01,1.77E+01,1.78E+01,1.79E+01,1.80E+01,1.80E+01,1.81E+01,1.83E+01,1.84E+01,1.85E+01,1.87E+01,1.88E+01,1.90E+01,1.91E+01,1.93E+01,1.95E+01,1.97E+01,1.99E+01,2.02E+01,2.04E+01,2.07E+01,2.09E+01,2.11E+01,2.14E+01,2.16E+01,2.19E+01,2.21E+01,2.24E+01,2.26E+01,2.29E+01,2.31E+01,2.34E+01,2.36E+01,2.39E+01,2.41E+01,2.43E+01,2.46E+01,2.48E+01,2.50E+01,2.52E+01,2.54E+01,2.56E+01,2.58E+01,2.61E+01,2.63E+01,2.64E+01,2.66E+01,2.67E+01,2.69E+01,2.70E+01,2.72E+01,2.73E+01,2.74E+01,2.75E+01,2.76E+01,2.78E+01,2.79E+01,2.80E+01,2.82E+01,2.84E+01,2.85E+01,2.86E+01,2.88E+01,2.90E+01,2.91E+01,2.92E+01,2.94E+01,2.95E+01,2.96E+01,2.97E+01,2.98E+01,3.00E+01,3.01E+01,3.02E+01,3.03E+01,3.04E+01,3.05E+01,3.06E+01,3.07E+01,3.07E+01,3.08E+01,3.08E+01,3.08E+01,3.07E+01,3.07E+01,3.07E+01,3.06E+01,3.05E+01,3.05E+01,3.03E+01,3.03E+01,3.02E+01,3.02E+01,3.00E+01,3.00E+01,3.00E+01,2.99E+01,2.99E+01,2.98E+01,2.98E+01,2.98E+01,2.97E+01,2.98E+01,2.98E+01,2.98E+01,2.98E+01,2.99E+01,2.99E+01,3.00E+01,3.00E+01,3.01E+01,3.01E+01,3.01E+01,3.02E+01,3.02E+01,3.02E+01,3.03E+01,3.03E+01,3.03E+01,3.03E+01,3.03E+01,3.02E+01,3.02E+01,3.01E+01,3.01E+01,3.00E+01,2.99E+01,2.98E+01,2.98E+01,2.98E+01,2.97E+01,2.96E+01,2.95E+01,2.93E+01,2.93E+01,2.92E+01,2.91E+01,2.90E+01,2.89E+01,2.88E+01,2.87E+01,2.87E+01,2.87E+01,2.87E+01,2.86E+01,2.85E+01,2.85E+01,2.85E+01,2.84E+01,2.83E+01,2.82E+01,2.82E+01,2.82E+01,2.81E+01,2.80E+01,2.80E+01,2.80E+01,2.79E+01,2.79E+01,2.79E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.79E+01,2.79E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.78E+01,2.79E+01,2.79E+01,2.80E+01,2.80E+01,2.81E+01,2.81E+01,2.82E+01,2.82E+01,2.82E+01,2.82E+01,2.83E+01,2.84E+01,2.85E+01,2.85E+01,2.86E+01,2.87E+01,2.87E+01,2.89E+01,2.90E+01,2.91E+01,2.92E+01,2.93E+01,2.94E+01,2.96E+01,2.97E+01,2.99E+01,3.00E+01,3.02E+01,3.04E+01,3.04E+01,3.06E+01,3.08E+01,3.10E+01,3.12E+01,3.13E+01,3.15E+01,3.16E+01,3.18E+01,3.20E+01,3.22E+01,3.23E+01,3.26E+01,3.28E+01,3.32E+01,3.34E+01,3.36E+01,3.38E+01,3.41E+01,3.43E+01,3.45E+01,3.47E+01,3.50E+01,3.52E+01,3.54E+01,3.56E+01,3.58E+01,3.60E+01,3.62E+01,3.64E+01,3.66E+01,3.67E+01,3.68E+01,3.70E+01,3.71E+01,3.74E+01,3.76E+01,3.79E+01,3.80E+01,3.81E+01,3.82E+01,3.83E+01,3.86E+01,3.87E+01,3.88E+01,3.88E+01,3.88E+01,3.88E+01,3.89E+01,3.90E+01,3.90E+01,3.91E+01,3.91E+01,3.92E+01,3.93E+01,3.95E+01,3.94E+01,3.95E+01,3.96E+01,3.95E+01,3.96E+01,3.96E+01,3.95E+01,3.94E+01,3.94E+01,3.92E+01,3.93E+01,3.89E+01,3.92E+01,3.87E+01])
Ppro_k_Cp = np.array([0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,0.00E+00,7.66E-05,1.69E-04,2.43E-04,3.04E-04,3.60E-04,4.15E-04,4.77E-04,5.52E-04,6.46E-04,7.65E-04,9.15E-04,1.10E-03,1.34E-03,1.59E-03,1.88E-03,2.21E-03,2.59E-03,3.02E-03,3.51E-03,4.08E-03,4.72E-03,5.45E-03,6.29E-03,7.29E-03,8.45E-03,9.80E-03,1.14E-02,1.32E-02,1.53E-02,1.77E-02,2.06E-02,2.38E-02,2.76E-02,3.21E-02,3.72E-02,4.31E-02,5.00E-02,5.73E-02,6.64E-02,7.42E-02,8.38E-02,9.37E-02,1.11E-01,1.31E-01,1.60E-01,1.97E-01,2.44E-01,3.00E-01,3.65E-01,4.41E-01,5.29E-01,6.29E-01,7.38E-01,8.60E-01,9.87E-01,1.12E+00,1.26E+00,1.40E+00,1.55E+00,1.71E+00,1.86E+00,2.02E+00,2.17E+00,2.31E+00,2.46E+00,2.60E+00,2.73E+00,2.85E+00,2.97E+00,3.08E+00,3.18E+00,3.27E+00,3.37E+00,3.45E+00,3.54E+00,3.62E+00,3.69E+00,3.76E+00,3.84E+00,3.91E+00,3.98E+00,4.05E+00,4.11E+00,4.17E+00,4.22E+00,4.28E+00,4.32E+00,4.37E+00,4.42E+00,4.46E+00,4.50E+00,4.53E+00,4.56E+00,4.60E+00,4.63E+00,4.66E+00,4.69E+00,4.71E+00,4.74E+00,4.77E+00,4.79E+00,4.81E+00,4.83E+00,4.85E+00,4.88E+00,4.89E+00,4.90E+00,4.91E+00,4.92E+00,4.92E+00,4.92E+00,4.92E+00,4.92E+00,4.90E+00,4.89E+00,4.87E+00,4.85E+00,4.82E+00,4.79E+00,4.76E+00,4.73E+00,4.70E+00,4.68E+00,4.65E+00,4.62E+00,4.60E+00,4.58E+00,4.58E+00,4.57E+00,4.57E+00,4.57E+00,4.58E+00,4.59E+00,4.60E+00,4.61E+00,4.63E+00,4.64E+00,4.66E+00,4.69E+00,4.71E+00,4.74E+00,4.77E+00,4.80E+00,4.82E+00,4.84E+00,4.86E+00,4.87E+00,4.89E+00,4.91E+00,4.93E+00,4.95E+00,4.97E+00,4.99E+00,5.00E+00,5.02E+00,5.04E+00,5.06E+00,5.08E+00,5.09E+00,5.11E+00,5.13E+00,5.14E+00,5.15E+00,5.16E+00,5.16E+00,5.17E+00,5.17E+00,5.18E+00,5.18E+00,5.19E+00,5.19E+00,5.19E+00,5.18E+00,5.18E+00,5.17E+00,5.17E+00,5.16E+00,5.16E+00,5.17E+00,5.17E+00,5.18E+00,5.19E+00,5.20E+00,5.21E+00,5.23E+00,5.24E+00,5.26E+00,5.27E+00,5.29E+00,5.30E+00,5.32E+00,5.33E+00,5.34E+00,5.34E+00,5.34E+00,5.34E+00,5.33E+00,5.32E+00,5.31E+00,5.29E+00,5.27E+00,5.24E+00,5.22E+00,5.19E+00,5.16E+00,5.13E+00,5.11E+00,5.08E+00,5.06E+00,5.04E+00,5.03E+00,5.01E+00,5.00E+00,4.99E+00,4.99E+00,4.99E+00,5.00E+00,5.00E+00,5.02E+00,5.03E+00,5.05E+00,5.07E+00,5.10E+00,5.13E+00,5.16E+00,5.20E+00,5.24E+00,5.29E+00,5.35E+00,5.41E+00,5.48E+00,5.55E+00,5.64E+00,5.72E+00,5.82E+00,5.91E+00,6.02E+00,6.12E+00,6.23E+00,6.35E+00,6.48E+00,6.61E+00,6.75E+00,6.89E+00,7.04E+00,7.19E+00,7.35E+00,7.51E+00,7.68E+00,7.85E+00,8.03E+00,8.20E+00,8.37E+00,8.55E+00,8.72E+00,8.88E+00,9.05E+00,9.20E+00,9.35E+00,9.48E+00,9.61E+00,9.73E+00,9.84E+00,9.94E+00,1.00E+01,1.01E+01,1.02E+01,1.02E+01,1.02E+01,1.02E+01,1.03E+01,1.03E+01,1.03E+01,1.03E+01,1.02E+01,1.02E+01,1.02E+01,1.02E+01,1.02E+01,1.01E+01,1.01E+01,1.01E+01,1.00E+01,1.00E+01,1.00E+01,1.00E+01,1.00E+01,1.00E+01,1.00E+01,1.00E+01,1.01E+01,1.01E+01,1.01E+01,1.02E+01,1.02E+01,1.02E+01,1.02E+01,1.03E+01,1.03E+01,1.03E+01,1.03E+01,1.04E+01,1.04E+01,1.04E+01,1.04E+01,1.04E+01,1.04E+01,1.03E+01,1.03E+01,1.03E+01,1.02E+01,1.02E+01,1.02E+01,1.01E+01,1.00E+01,9.98E+00,9.91E+00,9.84E+00,9.76E+00,9.67E+00,9.59E+00,9.50E+00,9.41E+00,9.31E+00,9.20E+00,9.10E+00,8.99E+00,8.88E+00,8.75E+00,8.62E+00,8.49E+00,8.36E+00,8.23E+00,8.11E+00,7.99E+00,7.86E+00,7.73E+00,7.62E+00,7.51E+00,7.40E+00,7.29E+00,7.20E+00,7.11E+00,7.02E+00,6.93E+00,6.85E+00,6.79E+00,6.73E+00,6.68E+00,6.64E+00,6.60E+00,6.56E+00,6.53E+00,6.50E+00,6.48E+00,6.45E+00,6.43E+00,6.41E+00,6.39E+00,6.37E+00,6.36E+00,6.35E+00,6.33E+00,6.33E+00,6.32E+00,6.31E+00,6.30E+00,6.29E+00,6.27E+00,6.26E+00,6.24E+00,6.21E+00,6.19E+00,6.15E+00,6.12E+00,6.08E+00,6.04E+00,5.99E+00,5.95E+00,5.90E+00,5.85E+00,5.80E+00,5.75E+00,5.70E+00,5.66E+00,5.62E+00,5.58E+00,5.54E+00,5.51E+00,5.48E+00,5.46E+00,5.43E+00,5.41E+00,5.38E+00,5.36E+00,5.33E+00,5.30E+00,5.27E+00,5.23E+00,5.18E+00,5.13E+00,5.08E+00,5.02E+00,4.96E+00,4.90E+00,4.84E+00,4.78E+00,4.71E+00,4.65E+00,4.59E+00,4.54E+00,4.49E+00,4.45E+00,4.41E+00,4.40E+00,4.38E+00,4.37E+00,4.36E+00,4.34E+00,4.32E+00,4.31E+00,4.28E+00,4.27E+00,4.26E+00,4.23E+00,4.21E+00,4.17E+00,4.13E+00,4.08E+00,4.05E+00,4.01E+00,3.96E+00,3.90E+00,3.83E+00,3.76E+00,3.69E+00,3.62E+00,3.54E+00,3.46E+00,3.40E+00,3.36E+00,3.32E+00,3.30E+00,3.28E+00,3.28E+00,3.29E+00,3.31E+00,3.33E+00,3.36E+00,3.40E+00,3.47E+00,3.55E+00,3.66E+00,3.77E+00,3.90E+00,4.06E+00,4.23E+00,4.43E+00,4.64E+00,4.89E+00,5.12E+00,5.37E+00,5.64E+00,5.91E+00,6.21E+00,6.52E+00,6.83E+00,7.15E+00,7.48E+00,7.84E+00,8.20E+00,8.56E+00,8.92E+00,9.29E+00,9.66E+00,1.00E+01,1.04E+01,1.07E+01,1.11E+01,1.14E+01,1.18E+01,1.21E+01,1.24E+01,1.28E+01,1.31E+01,1.34E+01,1.37E+01,1.39E+01,1.42E+01,1.45E+01,1.47E+01,1.50E+01,1.52E+01,1.54E+01,1.56E+01,1.58E+01,1.60E+01,1.62E+01,1.63E+01,1.65E+01,1.66E+01,1.68E+01,1.69E+01,1.70E+01,1.71E+01,1.71E+01,1.72E+01,1.73E+01,1.73E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.74E+01,1.75E+01,1.75E+01,1.75E+01,1.76E+01,1.76E+01,1.77E+01,1.77E+01,1.78E+01,1.78E+01,1.79E+01,1.79E+01,1.79E+01,1.80E+01,1.80E+01,1.80E+01,1.80E+01,1.80E+01,1.80E+01,1.79E+01,1.79E+01,1.78E+01,1.78E+01,1.77E+01,1.76E+01,1.75E+01,1.74E+01,1.73E+01,1.72E+01,1.71E+01,1.70E+01,1.69E+01,1.68E+01,1.67E+01,1.65E+01,1.64E+01,1.63E+01,1.61E+01,1.60E+01,1.59E+01,1.57E+01,1.56E+01,1.55E+01,1.53E+01,1.52E+01,1.51E+01,1.49E+01,1.48E+01,1.47E+01,1.45E+01,1.44E+01,1.43E+01,1.41E+01,1.40E+01,1.39E+01,1.38E+01,1.37E+01,1.36E+01,1.34E+01,1.34E+01,1.33E+01,1.32E+01,1.31E+01,1.30E+01,1.30E+01,1.29E+01,1.29E+01,1.28E+01,1.28E+01,1.28E+01,1.28E+01,1.29E+01,1.29E+01,1.30E+01,1.30E+01,1.31E+01,1.32E+01,1.33E+01,1.35E+01,1.36E+01,1.38E+01,1.39E+01,1.41E+01,1.43E+01,1.45E+01,1.47E+01,1.49E+01,1.50E+01,1.52E+01,1.54E+01,1.55E+01,1.56E+01,1.57E+01,1.58E+01,1.58E+01,1.58E+01,1.57E+01,1.56E+01,1.55E+01,1.54E+01,1.52E+01,1.49E+01,1.46E+01,1.43E+01,1.40E+01,1.36E+01,1.32E+01,1.28E+01,1.23E+01,1.19E+01,1.14E+01,1.10E+01,1.05E+01,1.00E+01,9.56E+00,9.10E+00,8.67E+00,8.25E+00,7.85E+00,7.47E+00,7.11E+00,6.79E+00,6.49E+00,6.22E+00,5.97E+00,5.74E+00,5.53E+00,5.35E+00,5.19E+00,5.05E+00,4.92E+00,4.81E+00,4.72E+00,4.65E+00,4.60E+00,4.56E+00,4.54E+00,4.54E+00,4.53E+00,4.54E+00,4.56E+00,4.59E+00,4.61E+00,4.65E+00,4.70E+00,4.75E+00,4.81E+00,4.86E+00,4.93E+00,5.00E+00,5.08E+00,5.17E+00,5.25E+00,5.35E+00,5.44E+00,5.54E+00,5.64E+00,5.75E+00,5.87E+00,5.99E+00,6.13E+00,6.29E+00,6.47E+00,6.66E+00,6.87E+00,7.10E+00,7.35E+00,7.61E+00,7.89E+00,8.20E+00,8.53E+00,8.87E+00,9.22E+00,9.60E+00,1.00E+01,1.04E+01,1.08E+01,1.13E+01,1.18E+01,1.22E+01,1.27E+01,1.32E+01,1.37E+01,1.42E+01,1.48E+01,1.53E+01,1.58E+01,1.63E+01,1.69E+01,1.74E+01,1.80E+01,1.85E+01,1.91E+01,1.96E+01,2.01E+01,2.07E+01,2.12E+01,2.17E+01,2.22E+01,2.28E+01,2.32E+01,2.37E+01,2.42E+01,2.46E+01,2.51E+01,2.55E+01,2.58E+01,2.62E+01,2.66E+01,2.69E+01,2.72E+01,2.75E+01,2.78E+01,2.80E+01,2.82E+01,2.85E+01,2.87E+01,2.88E+01,2.90E+01,2.92E+01,2.93E+01,2.94E+01,2.96E+01,2.96E+01,2.97E+01,2.98E+01,2.99E+01,2.99E+01,2.99E+01,3.00E+01,3.00E+01,3.00E+01,3.00E+01,3.00E+01,2.99E+01,2.99E+01,2.98E+01,2.97E+01,2.97E+01,2.96E+01,2.95E+01,2.94E+01,2.93E+01,2.92E+01,2.91E+01,2.90E+01,2.89E+01,2.88E+01,2.87E+01,2.85E+01,2.84E+01,2.82E+01,2.80E+01,2.78E+01,2.76E+01,2.74E+01,2.72E+01,2.70E+01,2.68E+01,2.66E+01,2.63E+01,2.61E+01,2.59E+01,2.56E+01,2.54E+01,2.52E+01,2.50E+01,2.48E+01,2.46E+01,2.44E+01,2.42E+01,2.41E+01,2.40E+01,2.39E+01,2.38E+01,2.37E+01,2.37E+01,2.37E+01,2.37E+01,2.37E+01,2.37E+01,2.38E+01,2.39E+01,2.40E+01,2.42E+01,2.43E+01,2.45E+01,2.47E+01,2.49E+01,2.52E+01,2.54E+01,2.57E+01,2.60E+01,2.63E+01,2.66E+01,2.69E+01,2.72E+01,2.75E+01,2.78E+01,2.81E+01,2.84E+01,2.88E+01,2.91E+01,2.94E+01,2.97E+01,2.99E+01,3.02E+01,3.05E+01,3.08E+01,3.11E+01,3.14E+01,3.16E+01,3.19E+01,3.22E+01,3.25E+01,3.28E+01,3.30E+01,3.33E+01,3.36E+01,3.38E+01,3.41E+01,3.43E+01,3.46E+01,3.48E+01,3.50E+01,3.52E+01,3.54E+01,3.55E+01,3.57E+01,3.58E+01,3.59E+01,3.59E+01,3.59E+01,3.59E+01,3.59E+01,3.58E+01,3.57E+01,3.55E+01,3.53E+01,3.52E+01,3.49E+01,3.47E+01,3.45E+01,3.42E+01,3.39E+01,3.36E+01,3.33E+01,3.29E+01,3.26E+01,3.23E+01,3.20E+01,3.17E+01,3.14E+01,3.11E+01,3.09E+01,3.07E+01,3.04E+01,3.02E+01,3.00E+01,2.99E+01,2.97E+01,2.96E+01,2.94E+01,2.93E+01,2.92E+01,2.91E+01,2.90E+01,2.89E+01,2.88E+01,2.87E+01,2.86E+01,2.85E+01,2.84E+01,2.84E+01,2.83E+01,2.82E+01,2.81E+01,2.81E+01,2.81E+01,2.80E+01,2.80E+01,2.80E+01,2.79E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.80E+01,2.79E+01,2.78E+01,2.77E+01,2.76E+01,2.75E+01,2.74E+01,2.72E+01,2.70E+01,2.68E+01,2.66E+01,2.64E+01,2.61E+01,2.59E+01,2.57E+01,2.54E+01,2.52E+01,2.50E+01,2.47E+01,2.45E+01,2.42E+01,2.40E+01,2.38E+01,2.36E+01,2.34E+01,2.32E+01,2.30E+01,2.28E+01,2.27E+01,2.25E+01,2.24E+01,2.22E+01,2.21E+01,2.20E+01,2.18E+01,2.17E+01,2.16E+01,2.15E+01,2.14E+01,2.13E+01,2.12E+01,2.11E+01,2.10E+01,2.09E+01,2.08E+01,2.07E+01,2.05E+01,2.04E+01,2.03E+01,2.02E+01,2.02E+01,2.01E+01,2.00E+01,1.99E+01,1.98E+01,1.97E+01,1.96E+01,1.95E+01,1.94E+01,1.93E+01,1.92E+01,1.91E+01,1.90E+01,1.89E+01,1.88E+01,1.86E+01,1.85E+01,1.84E+01,1.83E+01,1.81E+01,1.80E+01,1.79E+01,1.78E+01,1.77E+01,1.76E+01,1.75E+01,1.75E+01,1.74E+01,1.74E+01,1.73E+01,1.73E+01,1.73E+01,1.72E+01,1.72E+01,1.72E+01,1.71E+01,1.71E+01,1.71E+01,1.71E+01,1.71E+01,1.71E+01,1.70E+01,1.70E+01,1.70E+01,1.70E+01,1.70E+01,1.69E+01,1.69E+01,1.69E+01,1.69E+01,1.69E+01,1.69E+01,1.69E+01,1.68E+01,1.68E+01,1.68E+01,1.67E+01,1.66E+01,1.64E+01,1.63E+01,1.61E+01,1.59E+01,1.57E+01,1.55E+01,1.53E+01,1.51E+01,1.49E+01,1.47E+01,1.45E+01,1.43E+01,1.41E+01,1.38E+01,1.36E+01,1.33E+01,1.31E+01,1.28E+01,1.26E+01,1.23E+01,1.21E+01,1.18E+01,1.16E+01,1.13E+01,1.10E+01,1.07E+01,1.05E+01,1.02E+01,9.95E+00,9.73E+00,9.54E+00,9.37E+00,9.24E+00,9.15E+00,9.10E+00,9.10E+00,9.15E+00,9.25E+00,9.41E+00])
Ppro_k_Cbc = np.array([1.28E+02,1.21E+02,1.14E+02,1.08E+02,1.02E+02,9.60E+01,9.10E+01,8.63E+01,8.18E+01,7.76E+01,7.35E+01,6.94E+01,6.55E+01,6.18E+01,5.83E+01,5.51E+01,5.20E+01,4.92E+01,4.66E+01,4.41E+01,4.16E+01,3.92E+01,3.70E+01,3.49E+01,3.30E+01,3.12E+01,2.96E+01,2.80E+01,2.65E+01,2.51E+01,2.36E+01,2.22E+01,2.08E+01,1.95E+01,1.84E+01,1.73E+01,1.62E+01,1.53E+01,1.44E+01,1.35E+01,1.28E+01,1.21E+01,1.16E+01,1.10E+01,1.04E+01,9.92E+00,9.43E+00,8.91E+00,8.48E+00,8.09E+00,7.77E+00,7.49E+00,7.26E+00,7.01E+00,6.74E+00,6.50E+00,6.26E+00,6.03E+00,5.77E+00,5.55E+00,5.34E+00,5.15E+00,4.97E+00,4.80E+00,4.67E+00,4.60E+00,4.49E+00,4.41E+00,4.28E+00,4.14E+00,4.04E+00,3.92E+00,3.83E+00,3.71E+00,3.62E+00,3.56E+00,3.48E+00,3.44E+00,3.40E+00,3.35E+00,3.27E+00,3.24E+00,3.21E+00,3.18E+00,3.15E+00,3.12E+00,3.10E+00,3.07E+00,3.05E+00,3.02E+00,3.00E+00,2.98E+00,2.96E+00,2.94E+00,2.92E+00,2.90E+00,2.88E+00,2.87E+00,2.85E+00,2.83E+00,2.82E+00,2.80E+00,2.79E+00,2.78E+00,2.77E+00,2.76E+00,2.75E+00,2.74E+00,2.73E+00,2.72E+00,2.71E+00,2.71E+00,2.70E+00,2.70E+00,2.69E+00,2.69E+00,2.69E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.68E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.69E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.70E+00,2.71E+00,2.71E+00,2.71E+00,2.71E+00,2.71E+00,2.71E+00,2.71E+00,2.72E+00,2.72E+00,2.72E+00,2.72E+00,2.72E+00,2.72E+00,2.73E+00,2.73E+00,2.73E+00,2.73E+00,2.74E+00,2.74E+00,2.74E+00,2.75E+00,2.75E+00,2.75E+00,2.76E+00,2.76E+00,2.77E+00,2.77E+00,2.77E+00,2.78E+00,2.78E+00,2.79E+00,2.80E+00,2.80E+00,2.81E+00,2.81E+00,2.82E+00,2.83E+00,2.84E+00,2.84E+00,2.85E+00,2.86E+00,2.87E+00,2.88E+00,2.89E+00,2.90E+00,2.91E+00,2.93E+00,2.94E+00,2.95E+00,2.97E+00,2.98E+00,3.00E+00,3.01E+00,3.03E+00,3.05E+00,3.07E+00,3.09E+00,3.11E+00,3.13E+00,3.16E+00,3.18E+00,3.21E+00,3.24E+00,3.27E+00,3.30E+00,3.33E+00,3.36E+00,3.40E+00,3.44E+00,3.48E+00,3.52E+00,3.56E+00,3.61E+00,3.66E+00,3.72E+00,3.77E+00,3.83E+00,3.90E+00,3.96E+00,4.04E+00,4.11E+00,4.19E+00,4.27E+00,4.35E+00,4.43E+00,4.52E+00,4.61E+00,4.70E+00,4.79E+00,4.88E+00,4.97E+00,5.05E+00,5.14E+00,5.22E+00,5.31E+00,5.39E+00,5.46E+00,5.54E+00,5.61E+00,5.68E+00,5.74E+00,5.80E+00,5.86E+00,5.91E+00,5.96E+00,6.00E+00,6.05E+00,6.08E+00,6.12E+00,6.16E+00,6.19E+00,6.22E+00,6.24E+00,6.27E+00,6.29E+00,6.31E+00,6.33E+00,6.34E+00,6.36E+00,6.37E+00,6.38E+00,6.40E+00,6.41E+00,6.42E+00,6.43E+00,6.44E+00,6.44E+00,6.45E+00,6.46E+00,6.47E+00,6.48E+00,6.48E+00,6.49E+00,6.50E+00,6.50E+00,6.51E+00,6.52E+00,6.52E+00,6.53E+00,6.54E+00,6.55E+00,6.56E+00,6.57E+00,6.58E+00,6.58E+00,6.59E+00,6.59E+00,6.60E+00,6.60E+00,6.61E+00,6.61E+00,6.60E+00,6.60E+00,6.59E+00,6.59E+00,6.58E+00,6.58E+00,6.57E+00,6.56E+00,6.54E+00,6.53E+00,6.52E+00,6.50E+00,6.48E+00,6.46E+00,6.45E+00,6.43E+00,6.41E+00,6.39E+00,6.38E+00,6.36E+00,6.34E+00,6.32E+00,6.30E+00,6.28E+00,6.26E+00,6.25E+00,6.23E+00,6.21E+00,6.19E+00,6.17E+00,6.15E+00,6.13E+00,6.11E+00,6.09E+00,6.08E+00,6.06E+00,6.04E+00,6.02E+00,6.01E+00,5.99E+00,5.98E+00,5.96E+00,5.95E+00,5.93E+00,5.92E+00,5.91E+00,5.90E+00,5.90E+00,5.89E+00,5.88E+00,5.88E+00,5.87E+00,5.87E+00,5.86E+00,5.86E+00,5.86E+00,5.86E+00,5.86E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.85E+00,5.86E+00,5.86E+00,5.87E+00,5.87E+00,5.87E+00,5.87E+00,5.88E+00,5.88E+00,5.88E+00,5.88E+00,5.88E+00,5.89E+00,5.89E+00,5.89E+00,5.89E+00,5.89E+00,5.89E+00,5.88E+00,5.88E+00,5.87E+00,5.87E+00,5.86E+00,5.86E+00,5.86E+00,5.85E+00,5.84E+00,5.84E+00,5.83E+00,5.82E+00,5.81E+00,5.80E+00,5.79E+00,5.78E+00,5.76E+00,5.75E+00,5.73E+00,5.71E+00,5.70E+00,5.68E+00,5.66E+00,5.64E+00,5.62E+00,5.60E+00,5.58E+00,5.57E+00,5.55E+00,5.53E+00,5.51E+00,5.49E+00,5.47E+00,5.46E+00,5.44E+00,5.43E+00,5.41E+00,5.40E+00,5.38E+00,5.36E+00,5.35E+00,5.33E+00,5.32E+00,5.30E+00,5.29E+00,5.28E+00,5.26E+00,5.25E+00,5.24E+00,5.23E+00,5.22E+00,5.21E+00,5.20E+00,5.19E+00,5.18E+00,5.17E+00,5.16E+00,5.16E+00,5.15E+00,5.14E+00,5.14E+00,5.14E+00,5.13E+00,5.13E+00,5.12E+00,5.12E+00,5.12E+00,5.12E+00,5.12E+00,5.12E+00,5.12E+00,5.12E+00,5.13E+00,5.14E+00,5.14E+00,5.15E+00,5.17E+00,5.18E+00,5.19E+00,5.21E+00,5.23E+00,5.25E+00,5.27E+00,5.31E+00,5.33E+00,5.36E+00,5.39E+00,5.42E+00,5.44E+00,5.47E+00,5.49E+00,5.51E+00,5.53E+00,5.55E+00,5.57E+00,5.59E+00,5.61E+00,5.63E+00,5.64E+00,5.66E+00,5.68E+00,5.69E+00,5.71E+00,5.73E+00,5.75E+00,5.78E+00,5.80E+00,5.82E+00,5.85E+00,5.88E+00,5.91E+00,5.95E+00,5.99E+00,6.03E+00,6.06E+00,6.10E+00,6.14E+00,6.18E+00,6.21E+00,6.25E+00,6.29E+00,6.33E+00,6.37E+00,6.41E+00,6.45E+00,6.50E+00,6.54E+00,6.58E+00,6.63E+00,6.67E+00,6.71E+00,6.76E+00,6.80E+00,6.85E+00,6.89E+00,6.93E+00,6.97E+00,7.01E+00,7.05E+00,7.09E+00,7.13E+00,7.17E+00,7.20E+00,7.24E+00,7.27E+00,7.30E+00,7.33E+00,7.35E+00,7.37E+00,7.38E+00,7.39E+00,7.40E+00,7.40E+00,7.39E+00,7.38E+00,7.37E+00,7.35E+00,7.33E+00,7.30E+00,7.28E+00,7.25E+00,7.22E+00,7.19E+00,7.16E+00,7.13E+00,7.10E+00,7.07E+00,7.05E+00,7.03E+00,7.01E+00,6.99E+00,6.98E+00,6.97E+00,6.96E+00,6.96E+00,6.96E+00,6.96E+00,6.96E+00,6.97E+00,6.97E+00,6.97E+00,6.97E+00,6.98E+00,6.98E+00,6.98E+00,6.98E+00,6.97E+00,6.96E+00,6.96E+00,6.95E+00,6.94E+00,6.92E+00,6.90E+00,6.88E+00,6.86E+00,6.84E+00,6.81E+00,6.78E+00,6.75E+00,6.72E+00,6.69E+00,6.67E+00,6.64E+00,6.62E+00,6.59E+00,6.57E+00,6.55E+00,6.53E+00,6.52E+00,6.50E+00,6.49E+00,6.48E+00,6.47E+00,6.46E+00,6.45E+00,6.44E+00,6.43E+00,6.42E+00,6.42E+00,6.41E+00,6.40E+00,6.39E+00,6.38E+00,6.36E+00,6.35E+00,6.33E+00,6.32E+00,6.31E+00,6.30E+00,6.29E+00,6.28E+00,6.27E+00,6.26E+00,6.25E+00,6.25E+00,6.24E+00,6.23E+00,6.23E+00,6.22E+00,6.21E+00,6.21E+00,6.20E+00,6.19E+00,6.19E+00,6.18E+00,6.17E+00,6.16E+00,6.15E+00,6.14E+00,6.13E+00,6.12E+00,6.12E+00,6.11E+00,6.09E+00,6.08E+00,6.07E+00,6.05E+00,6.04E+00,6.02E+00,6.00E+00,5.99E+00,5.97E+00,5.95E+00,5.93E+00,5.91E+00,5.89E+00,5.87E+00,5.85E+00,5.83E+00,5.81E+00,5.79E+00,5.78E+00,5.76E+00,5.74E+00,5.72E+00,5.70E+00,5.69E+00,5.67E+00,5.66E+00,5.66E+00,5.65E+00,5.65E+00,5.65E+00,5.65E+00,5.65E+00,5.64E+00,5.64E+00,5.64E+00,5.63E+00,5.61E+00,5.60E+00,5.58E+00,5.57E+00,5.55E+00,5.54E+00,5.52E+00,5.51E+00,5.50E+00,5.48E+00,5.47E+00,5.45E+00,5.43E+00,5.42E+00,5.40E+00,5.39E+00,5.38E+00,5.37E+00,5.38E+00,5.38E+00,5.40E+00,5.41E+00,5.43E+00,5.45E+00,5.47E+00,5.49E+00,5.51E+00,5.54E+00,5.57E+00,5.59E+00,5.63E+00,5.67E+00,5.72E+00,5.77E+00,5.83E+00,5.90E+00,5.97E+00,6.04E+00,6.13E+00,6.21E+00,6.30E+00,6.39E+00,6.49E+00,6.58E+00,6.68E+00,6.77E+00,6.87E+00,6.96E+00,7.06E+00,7.15E+00,7.23E+00,7.31E+00,7.39E+00,7.47E+00,7.53E+00,7.60E+00,7.65E+00,7.71E+00,7.75E+00,7.80E+00,7.83E+00,7.87E+00,7.90E+00,7.92E+00,7.94E+00,7.96E+00,7.98E+00,8.00E+00,8.01E+00,8.02E+00,8.02E+00,8.02E+00,8.02E+00,8.02E+00,8.01E+00,8.01E+00,8.00E+00,7.99E+00,7.98E+00,7.96E+00,7.95E+00,7.94E+00,7.93E+00,7.92E+00,7.90E+00,7.89E+00,7.87E+00,7.86E+00,7.85E+00,7.84E+00,7.83E+00,7.82E+00,7.81E+00,7.80E+00,7.79E+00,7.78E+00,7.77E+00,7.76E+00,7.75E+00,7.74E+00,7.73E+00,7.72E+00,7.71E+00,7.70E+00,7.70E+00,7.69E+00,7.68E+00,7.67E+00,7.66E+00,7.65E+00,7.64E+00,7.63E+00,7.62E+00,7.61E+00,7.60E+00,7.60E+00,7.60E+00,7.60E+00,7.60E+00,7.60E+00,7.61E+00,7.62E+00,7.63E+00,7.65E+00,7.67E+00,7.69E+00,7.72E+00,7.75E+00,7.78E+00,7.81E+00,7.85E+00,7.88E+00,7.93E+00,7.97E+00,8.02E+00,8.07E+00,8.12E+00,8.17E+00,8.23E+00,8.28E+00,8.34E+00,8.39E+00,8.45E+00,8.51E+00,8.58E+00,8.65E+00,8.72E+00,8.80E+00,8.89E+00,8.98E+00,9.07E+00,9.17E+00,9.27E+00,9.39E+00,9.50E+00,9.62E+00,9.75E+00,9.88E+00,1.00E+01,1.02E+01,1.03E+01,1.05E+01,1.06E+01,1.08E+01,1.10E+01,1.12E+01,1.13E+01,1.15E+01,1.17E+01,1.19E+01,1.21E+01,1.23E+01,1.24E+01,1.26E+01,1.28E+01,1.30E+01,1.32E+01,1.34E+01,1.36E+01,1.38E+01,1.40E+01,1.42E+01,1.44E+01,1.46E+01,1.48E+01,1.50E+01,1.52E+01,1.54E+01,1.55E+01,1.57E+01,1.59E+01,1.61E+01,1.63E+01,1.64E+01,1.66E+01,1.68E+01,1.69E+01,1.71E+01,1.72E+01,1.74E+01,1.75E+01,1.77E+01,1.78E+01,1.80E+01,1.81E+01,1.82E+01,1.84E+01,1.85E+01,1.86E+01,1.87E+01,1.88E+01,1.90E+01,1.91E+01,1.92E+01,1.93E+01,1.94E+01,1.95E+01,1.96E+01,1.97E+01,1.98E+01,1.99E+01,2.00E+01,2.01E+01,2.01E+01,2.02E+01,2.03E+01,2.04E+01,2.04E+01,2.05E+01,2.06E+01,2.07E+01,2.07E+01,2.08E+01,2.08E+01,2.09E+01,2.09E+01,2.10E+01,2.10E+01,2.11E+01,2.11E+01,2.12E+01,2.12E+01,2.12E+01,2.13E+01,2.13E+01,2.13E+01,2.14E+01,2.14E+01,2.14E+01,2.14E+01,2.14E+01,2.14E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.15E+01,2.14E+01,2.14E+01,2.14E+01,2.14E+01,2.14E+01,2.13E+01,2.13E+01,2.13E+01,2.13E+01,2.13E+01,2.12E+01,2.12E+01,2.12E+01,2.11E+01,2.11E+01,2.11E+01,2.10E+01,2.10E+01,2.09E+01,2.09E+01,2.08E+01,2.08E+01,2.07E+01,2.07E+01,2.06E+01,2.06E+01,2.05E+01,2.04E+01,2.04E+01,2.03E+01,2.03E+01,2.02E+01,2.01E+01,2.01E+01,2.00E+01,1.99E+01,1.99E+01,1.98E+01,1.97E+01,1.96E+01,1.96E+01,1.95E+01,1.94E+01,1.94E+01,1.93E+01,1.92E+01,1.92E+01,1.91E+01,1.90E+01,1.90E+01,1.89E+01,1.88E+01,1.87E+01,1.87E+01,1.86E+01,1.85E+01,1.84E+01,1.84E+01,1.83E+01,1.82E+01,1.81E+01,1.81E+01,1.80E+01,1.79E+01,1.78E+01,1.78E+01,1.77E+01,1.76E+01,1.76E+01,1.75E+01,1.74E+01,1.74E+01,1.73E+01,1.73E+01,1.72E+01,1.71E+01,1.71E+01,1.70E+01,1.70E+01,1.69E+01,1.69E+01,1.68E+01,1.68E+01,1.68E+01,1.67E+01,1.67E+01,1.66E+01,1.66E+01,1.66E+01,1.66E+01,1.65E+01,1.65E+01,1.65E+01,1.65E+01,1.65E+01,1.65E+01,1.65E+01,1.66E+01,1.66E+01,1.66E+01,1.67E+01,1.67E+01,1.68E+01,1.69E+01,1.70E+01,1.71E+01,1.72E+01,1.73E+01,1.74E+01,1.75E+01,1.77E+01,1.78E+01,1.80E+01,1.82E+01,1.84E+01,1.86E+01,1.88E+01,1.90E+01,1.92E+01,1.94E+01,1.96E+01,1.99E+01,2.01E+01,2.03E+01,2.06E+01,2.08E+01,2.11E+01,2.13E+01,2.16E+01,2.18E+01,2.21E+01,2.23E+01,2.25E+01,2.28E+01,2.30E+01,2.33E+01,2.35E+01,2.37E+01,2.39E+01,2.41E+01,2.44E+01,2.46E+01,2.48E+01,2.50E+01,2.51E+01,2.53E+01,2.55E+01,2.56E+01,2.58E+01,2.59E+01,2.61E+01,2.62E+01,2.63E+01,2.65E+01,2.66E+01,2.67E+01,2.68E+01,2.70E+01,2.71E+01,2.72E+01,2.73E+01,2.75E+01,2.76E+01,2.77E+01,2.79E+01,2.80E+01,2.82E+01,2.83E+01,2.85E+01,2.87E+01,2.88E+01,2.90E+01,2.91E+01,2.93E+01,2.95E+01,2.96E+01,2.97E+01,2.99E+01,3.00E+01,3.01E+01,3.02E+01,3.03E+01,3.04E+01,3.04E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.04E+01,3.04E+01,3.03E+01,3.03E+01,3.02E+01,3.02E+01,3.01E+01,3.01E+01,3.00E+01,3.00E+01,3.00E+01,2.99E+01,2.99E+01,2.99E+01,2.99E+01,3.00E+01,3.00E+01,3.00E+01,3.01E+01,3.01E+01,3.02E+01,3.02E+01,3.03E+01,3.03E+01,3.04E+01,3.04E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.05E+01,3.04E+01,3.04E+01,3.03E+01,3.03E+01,3.02E+01,3.01E+01,3.00E+01,2.99E+01,2.99E+01,2.98E+01,2.97E+01,2.96E+01,2.95E+01,2.95E+01,2.94E+01,2.93E+01,2.93E+01,2.92E+01,2.92E+01,2.91E+01,2.91E+01,2.90E+01,2.90E+01,2.90E+01,2.89E+01,2.89E+01,2.89E+01,2.89E+01,2.88E+01,2.88E+01,2.88E+01,2.88E+01,2.87E+01,2.87E+01,2.87E+01,2.87E+01,2.87E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.86E+01,2.87E+01,2.87E+01,2.87E+01,2.88E+01,2.88E+01,2.88E+01,2.89E+01,2.89E+01,2.89E+01,2.90E+01,2.90E+01,2.91E+01,2.91E+01,2.92E+01,2.93E+01,2.93E+01,2.94E+01,2.95E+01,2.96E+01,2.97E+01,2.98E+01,2.99E+01,3.00E+01,3.01E+01,3.02E+01,3.03E+01,3.05E+01,3.06E+01,3.08E+01,3.10E+01,3.11E+01,3.13E+01,3.15E+01,3.16E+01,3.18E+01,3.20E+01,3.22E+01,3.23E+01,3.25E+01,3.27E+01,3.29E+01,3.31E+01,3.33E+01,3.36E+01,3.38E+01,3.40E+01,3.42E+01,3.45E+01,3.47E+01,3.50E+01,3.52E+01,3.55E+01,3.57E+01,3.60E+01,3.63E+01,3.65E+01,3.68E+01,3.70E+01,3.73E+01,3.75E+01,3.78E+01,3.80E+01,3.82E+01,3.85E+01,3.87E+01,3.89E+01,3.91E+01,3.94E+01,3.96E+01,3.98E+01,4.01E+01,4.03E+01,4.05E+01,4.07E+01,4.09E+01,4.11E+01,4.12E+01,4.14E+01,4.16E+01,4.17E+01,4.19E+01,4.20E+01,4.21E+01,4.23E+01,4.24E+01,4.25E+01,4.26E+01,4.27E+01,4.28E+01,4.29E+01,4.30E+01,4.31E+01,4.32E+01,4.32E+01,4.33E+01,4.34E+01,4.34E+01,4.34E+01,4.34E+01,4.34E+01,4.33E+01,4.32E+01,4.31E+01,4.30E+01,4.28E+01,4.26E+01])

Ppro_t12 = np.array([0.956921806,0.956921806,0.956921806,0.956921806,0.956921806,0.956921806,0.957013593,0.957105337,0.957183938,0.957275599,0.957367214,0.957432627,0.957498016,0.957576452,0.957641791,0.957707106,0.957772398,0.957824615,0.957889866,0.957942049,0.958007258,0.958046371,0.958085477,0.958137604,0.95817669,0.958215767,0.958254836,0.958293896,0.958319932,0.958358978,0.958398015,0.958424036,0.958463059,0.95848907,0.958528079,0.958554081,0.958580078,0.958606072,0.958632062,0.958658048,0.958684031,0.958722997,0.958761955,0.958787922,0.958826865,0.9588658,0.958891752,0.9589177,0.958956614,0.958982553,0.959008487,0.959034418,0.959060345,0.959086267,0.959112186,0.959138102,0.959164013,0.959176967,0.959202873,0.959215824,0.959241724,0.959267619,0.959280566,0.959306456,0.959319399,0.959345284,0.959358224,0.959371164,0.95939704,0.959409977,0.959422913,0.959435847,0.959461714,0.959474646,0.959500507,0.959513436,0.959526364,0.959539291,0.959565142,0.959578066,0.959590989,0.959603911,0.959629752,0.959642671,0.959668506,0.959681423,0.959694338,0.959720165,0.959733077,0.959758899,0.959771808,0.959784717,0.95981053,0.959823436,0.959849243,0.959862146,0.959887948,0.959913746,0.959926643,0.959952435,0.959978223,0.960004007,0.960029787,0.960042676,0.96006845,0.96009422,0.960119986,0.960145748,0.960171507,0.960197261,0.960223011,0.960248757,0.960287369,0.960313105,0.960351702,0.960377429,0.96041601,0.960441727,0.960480293,0.960506,0.960544551,0.960583094,0.960621627,0.960647312,0.96068583,0.960724339,0.960762839,0.960801331,0.960839812,0.960878285,0.960916749,0.960955203,0.960993649,0.961044895,0.961083319,0.961121733,0.961160139,0.961211332,0.961249716,0.96130088,0.961339242,0.961377595,0.961428718,0.961467049,0.961518143,0.961556453,0.961607518,0.961645806,0.961696841,0.961735107,0.961786114,0.961837104,0.961875335,0.961926296,0.961964505,0.962015436,0.962066351,0.962117248,0.962168129,0.962218993,0.96226984,0.96232067,0.962371483,0.962422279,0.962473057,0.962523819,0.962574564,0.962625292,0.962663326,0.962714024,0.962764705,0.962815368,0.962866014,0.962903987,0.962954603,0.963005202,0.963055783,0.963106347,0.963144259,0.963194792,0.963245309,0.963295807,0.963346288,0.963384138,0.963434589,0.963485022,0.963522835,0.963573237,0.963611028,0.963661399,0.963699166,0.963736923,0.96377467,0.963812408,0.963850135,0.963887852,0.963925559,0.963963256,0.963988382,0.964026063,0.964063733,0.964101394,0.964139044,0.964164139,0.964201773,0.964239396,0.964264473,0.96430208,0.964327145,0.964364735,0.964389789,0.964414839,0.964452405,0.964477443,0.964514993,0.96454002,0.964565042,0.964590061,0.964627579,0.964652586,0.964677588,0.964702586,0.964727579,0.964752567,0.964777551,0.964802531,0.964827506,0.964839991,0.96486496,0.964877442,0.964902403,0.964914882,0.964939836,0.964952312,0.964977259,0.964989731,0.965002202,0.965014672,0.96502714,0.965039608,0.965052074,0.965064539,0.965077003,0.965077003,0.965089466,0.965101927,0.965114388,0.965114388,0.965126847,0.965126847,0.965139305,0.965139305,0.965151762,0.965151762,0.965164218,0.965164218,0.965176673,0.965176673,0.965189127,0.965189127,0.965201579,0.965201579,0.965201579,0.96521403,0.96521403,0.96521403,0.965226481,0.965226481,0.96523893,0.96523893,0.965251377,0.965251377,0.965263824,0.965263824,0.96527627,0.96527627,0.965288714,0.965301157,0.965301157,0.965313599,0.96532604,0.96533848,0.96533848,0.965350918,0.965350918,0.965363356,0.965375792,0.965388227,0.965388227,0.965400661,0.965413094,0.965425525,0.965425525,0.965437956,0.965437956,0.965450385,0.965462813,0.96547524,0.96547524,0.965487666,0.96550009,0.965512514,0.965524936,0.965537357,0.965549777,0.965562196,0.965574614,0.96558703,0.96561186,0.965624273,0.965636684,0.965661504,0.965673913,0.965698726,0.965711131,0.965735937,0.965760738,0.965773137,0.965797931,0.965810327,0.965835114,0.965859896,0.965884674,0.965909447,0.965934216,0.965958979,0.965983738,0.966008493,0.966020868,0.966045615,0.966070358,0.966095095,0.966119828,0.966132193,0.966156919,0.96618164,0.966206356,0.966231068,0.966243422,0.966268126,0.966292826,0.966317521,0.966329867,0.966354554,0.966366897,0.966391577,0.966403916,0.966416253,0.966440924,0.966453258,0.96646559,0.966490252,0.966502581,0.966527235,0.96653956,0.966564207,0.966576529,0.96658885,0.966613487,0.966625804,0.96663812,0.966650434,0.966662747,0.96667506,0.96668737,0.96669968,0.966711989,0.966724296,0.966724296,0.966736602,0.966748907,0.966748907,0.966761211,0.966761211,0.966773513,0.966773513,0.966773513,0.966773513,0.966785814,0.966785814,0.966785814,0.966785814,0.966785814,0.966785814,0.966785814,0.966785814,0.966785814,0.966773513,0.966773513,0.966761211,0.966761211,0.966761211,0.966761211,0.966748907,0.966748907,0.966748907,0.966748907,0.966736602,0.966736602,0.966724296,0.966724296,0.966724296,0.966711989,0.966711989,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96668737,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.96669968,0.966711989,0.966711989,0.966711989,0.966711989,0.966711989,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966724296,0.966736602,0.966736602,0.966736602,0.966736602,0.966748907,0.966748907,0.966761211,0.966761211,0.966761211,0.966761211,0.966773513,0.966773513,0.966773513,0.966773513,0.966773513,0.966785814,0.966785814,0.966785814,0.966785814,0.966798114,0.966798114,0.966810413,0.966810413,0.966810413,0.966810413,0.966822711,0.966822711,0.966822711,0.966822711,0.966835007,0.966835007,0.966847302,0.966847302,0.966847302,0.966847302,0.966859596,0.966859596,0.966859596,0.966859596,0.966871889,0.966871889,0.966884181,0.966884181,0.966884181,0.966884181,0.966896471,0.966896471,0.966896471,0.966896471,0.96690876,0.96690876,0.966921048,0.966921048,0.966921048,0.966933335,0.966933335,0.96694562,0.96694562,0.966957904,0.966957904,0.966970187,0.966970187,0.966982469,0.966982469,0.96699475,0.96699475,0.967007029,0.967007029,0.967007029,0.967019308,0.967019308,0.967031585,0.967031585,0.967031585,0.96704386,0.96704386,0.967056135,0.967056135,0.967056135,0.967068408,0.967068408,0.96708068,0.96708068,0.96708068,0.967092951,0.967092951,0.967105221,0.967105221,0.967117489,0.967117489,0.967129756,0.967129756,0.967142022,0.967154287,0.967154287,0.967166551,0.967166551,0.967178813,0.967191074,0.967191074,0.967203334,0.967203334,0.967215593,0.96722785,0.96722785,0.967240106,0.967240106,0.967252361,0.967264615,0.967276868,0.967276868,0.967289119,0.967301369,0.967313618,0.967313618,0.967325866,0.967325866,0.967338112,0.967350357,0.967362601,0.967362601,0.967374844,0.967387085,0.967399326,0.967411565,0.967411565,0.967423802,0.967436039,0.967448274,0.967460508,0.967460508,0.967472741,0.967484973,0.967497203,0.967509432,0.967509432,0.96752166,0.967533887,0.967546112,0.967558337,0.96757056,0.967582781,0.967595002,0.967607221,0.967619439,0.967619439,0.967631656,0.967643871,0.967656086,0.967668299,0.967680511,0.967692721,0.96770493,0.967717139,0.967729345,0.967729345,0.967741551,0.967753755,0.967765959,0.96777816,0.967790361,0.96780256,0.967814759,0.967826955,0.967839151,0.967851345,0.967863539,0.967875731,0.967887921,0.967900111,0.967912299,0.967924486,0.967936671,0.967948856,0.967961039,0.967985401,0.967997581,0.968009759,0.968021936,0.968034112,0.968046286,0.968058459,0.968070631,0.968082802,0.968094971,0.968107139,0.968119306,0.968131471,0.968143636,0.968155799,0.968180121,0.96819228,0.968204439,0.968216595,0.968228751,0.968253058,0.96826521,0.96827736,0.968289509,0.968301657,0.968313804,0.968325949,0.968338094,0.968350236,0.968362378,0.968386657,0.968398795,0.968410932,0.968423067,0.968435201,0.968459465,0.968471595,0.968483724,0.968495852,0.968507978,0.968532227,0.96854435,0.968556471,0.968568591,0.96858071,0.968604944,0.968617059,0.968629172,0.968641285,0.968653396,0.968677614,0.968689721,0.968701827,0.968713932,0.968726035,0.968750238,0.968762338,0.968774436,0.968786533,0.968798629,0.968822816,0.968834908,0.968846999,0.968859088,0.968871176,0.968895348,0.968907433,0.968919515,0.968931597,0.968943677,0.968967834,0.96897991,0.968991986,0.969004059,0.969016132,0.969028203,0.969040273,0.969052342,0.969064409,0.969076475,0.969100604,0.969112666,0.969124727,0.969136786,0.969148845,0.969160902,0.969172957,0.969185012,0.969197065,0.969209117,0.969233217,0.969245265,0.969257311,0.969269357,0.969281401,0.969305485,0.969317525,0.969329564,0.969341601,0.969353638,0.969365672,0.969377706,0.969389738,0.969401769,0.969413799,0.969437854,0.96944988,0.969461905,0.969473928,0.96948595,0.96949797,0.969509989,0.969522007,0.969534024,0.969546039,0.969570066,0.969582077,0.969594087,0.969606096,0.969618104,0.96963011,0.969642114,0.969654118,0.96966612,0.969678121,0.96969012,0.969702119,0.969714115,0.969726111,0.969738105,0.969750098,0.96976209,0.96977408,0.969786069,0.969798057,0.969822028,0.969834012,0.969845994,0.969857975,0.969869955,0.969881933,0.96989391,0.969905886,0.96991786,0.969929833,0.969941805,0.969953776,0.969965745,0.969977713,0.969989679,0.970001644,0.970013608,0.97002557,0.970037531,0.970049491,0.97006145,0.970073407,0.970085363,0.970097317,0.97010927,0.970121222,0.970133172,0.970145122,0.970157069,0.970169016,0.970180961,0.970192905,0.970204847,0.970216788,0.970228728,0.970252604,0.970264539,0.970276474,0.970288407,0.970300338,0.970312269,0.970324198,0.970336126,0.970348052,0.970359977,0.970371901,0.970383823,0.970395744,0.970407664,0.970419582,0.970443414,0.970455329,0.970467242,0.970479153,0.970491063,0.970502972,0.97051488,0.970526786,0.970538691,0.970550594,0.970562496,0.970574397,0.970586296,0.970598194,0.970610091,0.970621986,0.97063388,0.970645773,0.970657664,0.970669554,0.97069333,0.970705216,0.9707171,0.970728983,0.970740865,0.970752745,0.970764624,0.970776502,0.970788379,0.970800253,0.970812127,0.970823999,0.97083587,0.97084774,0.970859608,0.97088334,0.970895204,0.970907067,0.970918928,0.970930788,0.970942647,0.970954504,0.97096636,0.970978214,0.970990067,0.971001919,0.971013769,0.971025618,0.971037466,0.971049312,0.971073001,0.971084843,0.971096684,0.971108523,0.971120361,0.971132198,0.971144033,0.971155867,0.971167699,0.971179531,0.97119136,0.971203189,0.971215016,0.971226841,0.971238666,0.971250488,0.97126231,0.97127413,0.971285949,0.971297766,0.971309582,0.971321397,0.97133321,0.971345022,0.971356832,0.971368641,0.971380449,0.971392255,0.97140406,0.971415863,0.971427666,0.971439466,0.971451266,0.971463064,0.97147486,0.971498449,0.971510242,0.971522033,0.971533822,0.97154561,0.971557397,0.971569183,0.971580967,0.971592749,0.971604531,0.97161631,0.971628089,0.971639866,0.971651642,0.971663416,0.971675189,0.97168696,0.97169873,0.971710499,0.971722266,0.971734032,0.971745797,0.97175756,0.971769321,0.971781082,0.97179284,0.971804598,0.971816354,0.971828109,0.971839862,0.971851614,0.971863364,0.971875113,0.971886861,0.971898607,0.971910352,0.971922095,0.971933837,0.971945578,0.971957317,0.971969055,0.971980791,0.971992526,0.97200426,0.972015992,0.972027722,0.972039452,0.97205118,0.972062906,0.972074631,0.972086355,0.972098077,0.972109798,0.972121517,0.972133235,0.972156667,0.972168381,0.972180093,0.972191804,0.972203513,0.972215221,0.972226928,0.972238633,0.972250337,0.972262039,0.97227374,0.97228544,0.972297138,0.972308835,0.97232053,0.972343916,0.972355607,0.972367296,0.972378985,0.972390671,0.972402356,0.97241404,0.972425723,0.972437404,0.972449083,0.972460761,0.972472438,0.972484113,0.972495787,0.972507459,0.9725308,0.972542468,0.972554135,0.9725658,0.972577464,0.972600787,0.972612446,0.972624104,0.972635761,0.972647416,0.972670722,0.972682373,0.972694022,0.97270567,0.972717316,0.972740605,0.972752247,0.972763888,0.972775527,0.972787165,0.972810436,0.97282207,0.972833702,0.972845333,0.972856962,0.972880216,0.97289184,0.972903464,0.972915086,0.972938325,0.972949943,0.972973173,0.972984787,0.972996398,0.973008009,0.973031225,0.973042831,0.973054435,0.973066038,0.97308924,0.973100838,0.973124031,0.973135625,0.973147218,0.973158809,0.973181988,0.973193575,0.97320516,0.973216744,0.973239908,0.973251487,0.973274642,0.973286217,0.973309363,0.973320934,0.973344071,0.973355638,0.973378766,0.973390328,0.973413448,0.973425005,0.973448116,0.973459669,0.973482771,0.973494319,0.973517412,0.973528957,0.973552041,0.973563581,0.973586656,0.973598191,0.973621258,0.973632789,0.973655846,0.973667372,0.973690421,0.973701943,0.973724983,0.973748016,0.973759531,0.973782556,0.973794066,0.973817082,0.973840091,0.973851594,0.973874595,0.973886093,0.973909085,0.973932071,0.973943562,0.973966539,0.973978025,0.974000993,0.974023955,0.974035433,0.974058386,0.974069861,0.974092804,0.974115742,0.974127209,0.974150138,0.9741616,0.97418452,0.974207434,0.974218888,0.974241793,0.974253243,0.974276139,0.974299028,0.974321912,0.974333352,0.974356226,0.974379094,0.974401957,0.974413386,0.974436239,0.974447663,0.974470507,0.974481927,0.974504762,0.974516177,0.974539003,0.974550414,0.97457323,0.974584636,0.974607444,0.974618845,0.974641644,0.974664436,0.97467583,0.974698613,0.974710002,0.974732776,0.974755544,0.974778305,0.974789684,0.974812436,0.974835182,0.974857922,0.97486929,0.974892021,0.974903384,0.974926105,0.974948821,0.974960176,0.974982882,0.974994233,0.97501693,0.97503962,0.975062305,0.975073645,0.97509632,0.975118989,0.975141652,0.975152981,0.975175634,0.975186958,0.975209603,0.97523224,0.975243557,0.975266185,0.975277497,0.975300117,0.975322729,0.975334034,0.975356637,0.975367937,0.975390531,0.975413119,0.9754357,0.975446989,0.975469561,0.975492127,0.975514686,0.975525964,0.975548514,0.975559787,0.975582328,0.975604862,0.975616127,0.975638652,0.975649912,0.975672428,0.975694937,0.975706189,0.975728689,0.975739937,0.975762427,0.975784911,0.97579615,0.975818625,0.97582986,0.975852325,0.975874783,0.97588601,0.975908459,0.975919681,0.975942121,0.975964554,0.975975768,0.975998192,0.976009401,0.976031815,0.976054222,0.976065424,0.976087822,0.976099018,0.976121407,0.976143789,0.976154977,0.97617735,0.976188534,0.976210896,0.976233253,0.976244428,0.976266775,0.976277946,0.976300283,0.976322614,0.976333777,0.976356098,0.976367256,0.976389567,0.976411872,0.976423022,0.976445317,0.976456462,0.976478747,0.976501026,0.976512163,0.976534432,0.976545565,0.976567824,0.976590077,0.976601201,0.976623444,0.976634563,0.976656797,0.976667911,0.976690135,0.976701244,0.976723458,0.976734563,0.976756767,0.976767866,0.976790061,0.976801155,0.97682334,0.976845518,0.976856604,0.976878772,0.976889854,0.976912012,0.976923089,0.976945237,0.976956309,0.976978448,0.976989515,0.977011643,0.977022705,0.977044824,0.977055881,0.97707799,0.977100092,0.977111141,0.977133233,0.977144277,0.97716636,0.977177398,0.977199471,0.977210505,0.977232567,0.977243596,0.977254623,0.977276673,0.977287695,0.977309734,0.977320752,0.977331767,0.977353793,0.977364804,0.97738682,0.977397826,0.977408829,0.977430832,0.977441831,0.977463824,0.977474818,0.97748581,0.977507789,0.977518777,0.977540746,0.977551728,0.977562709,0.977584665,0.97759564,0.977617586,0.977628557,0.977639525,0.977650492,0.977672422,0.977683384,0.977694344,0.977705303,0.977727215,0.977738169,0.977760071,0.977771019,0.977781966,0.977792912,0.977814797,0.977825737,0.977836676,0.977847612,0.977858547,0.977880413,0.977891343,0.977902271,0.977913197,0.977935046,0.977945967,0.977967805,0.977978722,0.977989636,0.978000549,0.978011461,0.97802237,0.978033278,0.978044185,0.978055089,0.978076893,0.978087793,0.97809869,0.978109586,0.978120481,0.978131373,0.978142264,0.978153153,0.978164041,0.978174927,0.978196693,0.978207574,0.978218453,0.97822933,0.978240206,0.97825108,0.978261952,0.978272822,0.978283691,0.978294558,0.978305423,0.978316287,0.978327148,0.978338009,0.978348867,0.978359724,0.978370579,0.978381432,0.978392283,0.978403133,0.978413981,0.978424828,0.978435672,0.978446515,0.978457357,0.978468196,0.978479034,0.97848987,0.978500704,0.978511537,0.978522368,0.978533197,0.978544024,0.97855485,0.978565674,0.978576496,0.978587316,0.978598135,0.978608952,0.978619768,0.978619768,0.978630581,0.978641393,0.978652203,0.978663011,0.978663011,0.978673818,0.978684623,0.978695426,0.978706227,0.978717027,0.978727825,0.978738621,0.978749416,0.978760209,0.978760209,0.978771,0.978781789,0.978792576,0.978803362,0.978803362,0.978814146,0.978824928,0.978835709,0.978846488,0.978846488,0.978857265,0.97886804,0.978878814,0.978889585,0.978889585,0.978900355,0.978911124,0.97892189,0.978932655,0.978932655,0.978943418,0.97895418,0.978964939,0.978975697,0.978975697,0.978986453,0.978997207,0.97900796,0.979018711,0.979018711,0.97902946,0.979040207,0.979050953,0.979061696,0.979061696,0.979072438,0.979083179,0.979093917,0.979104654,0.979104654,0.979115389,0.979126122,0.979136854,0.979147583,0.979147583,0.979158311,0.979169037,0.979179762,0.979179762,0.979190484,0.979190484,0.979201205,0.979211924,0.979222642,0.979222642,0.979233357,0.979244071,0.979254783,0.979254783,0.979265494,0.979265494,0.979276202,0.979286909,0.979297614,0.979297614,0.979308317,0.979319019,0.979329718,0.979329718,0.979340416,0.979340416,0.979351112,0.979361807,0.979372499,0.979372499,0.97938319,0.979393879,0.979404566,0.979404566,0.979415252,0.979415252,0.979425935,0.979436617,0.979447298,0.979447298,0.979457976,0.979468653,0.979479327,0.979479327,0.97949,0.97949,0.979500672,0.979511341,0.979522009,0.979522009,0.979532675,0.979543339,0.979554001,0.979554001,0.979564662,0.979564662,0.97957532,0.979585977,0.979585977,0.979596633,0.979596633,0.979607286,0.979617938,0.979617938,0.979628587,0.979628587,0.979639235,0.979649882,0.979649882,0.979660526,0.979660526,0.979671169,0.97968181,0.979692449,0.979692449,0.979703086,0.979713721,0.979724355,0.979724355,0.979734987,0.979734987,0.979745617,0.979756245,0.979766872,0.979766872,0.979777497,0.97978812,0.979798741,0.979798741,0.97980936,0.97980936,0.979819978,0.979830593,0.979841207,0.979841207,0.979851819,0.97986243,0.979873038,0.979873038,0.979883645,0.979883645,0.97989425,0.979904853,0.979904853,0.979915454,0.979915454,0.979926054,0.979936651,0.979936651,0.979947247,0.979947247,0.979957841,0.979968434,0.979979024,0.979979024,0.979989613,0.980000199,0.980010784,0.980010784,0.980021368,0.980021368,0.980031949,0.980042529,0.980053106,0.980053106,0.980063682,0.980074256,0.980084829,0.980084829,0.980095399,0.980095399,0.980105968,0.980116535,0.9801271,0.9801271,0.980137663,0.980148225,0.980158784,0.980169342,0.980169342,0.980179898,0.980190452,0.980201004,0.980211555,0.980211555,0.980222103,0.98023265,0.980243195,0.980253739,0.980253739,0.98026428,0.980274819,0.980285357,0.980295893,0.980295893,0.980306427,0.980316959,0.98032749,0.980338018,0.980338018,0.980348545,0.98035907,0.980369593,0.980380114,0.980390634,0.980401151,0.980411667,0.980422181,0.980432693,0.980432693,0.980443203,0.980453711,0.980464218,0.980474723,0.980474723,0.980485226,0.980495727,0.980506226,0.980516723,0.980527219,0.980537712,0.980548204,0.980558694,0.980569182,0.980579669,0.980590153,0.980600636,0.980611116,0.980621595,0.980632072,0.980642548,0.980653021,0.980663492,0.980673962,0.98068443,0.980694896,0.98070536,0.980715822,0.980726283,0.980736741,0.980747198,0.980757653,0.980768106,0.980778557,0.980789006,0.980799453,0.980809899,0.980820343,0.980830784,0.980851662,0.980862099,0.980872533,0.980882965,0.980893396,0.980903825,0.980914252,0.980924677,0.9809351,0.980945521,0.980966358,0.980976774,0.980987188,0.9809976,0.98100801,0.981018418,0.981028825,0.981039229,0.981049632,0.981060032,0.981080828,0.981091223,0.981101617,0.981112008,0.981122397,0.981143171,0.981153554,0.981163936,0.981174316,0.981184695,0.981205445,0.981215818,0.981226189,0.981236557,0.981246924,0.981267652,0.981278014,0.981288373,0.98129873,0.981309086,0.981329791,0.981340141,0.981350489,0.981360835,0.981371179,0.981381522,0.981391862,0.981402201,0.981412537,0.981422872,0.981443536,0.981453865,0.981464192,0.981474517,0.98148484,0.981505481,0.981515799,0.981526115,0.981536428,0.98154674,0.981567358,0.981577665,0.981587969,0.981598271,0.981608572,0.981629167,0.981639462,0.981649755,0.981660045,0.981670334,0.981690907,0.98170119,0.981711471,0.981721751,0.981732028,0.981752577,0.981762849,0.981773119,0.981783387,0.981793653,0.981814179,0.981824439,0.981834698,0.981844954,0.981855208,0.981875712,0.98188596,0.981896207,0.981906452,0.981916695,0.981937175,0.981947412,0.981957647,0.98196788,0.981978111,0.981998568,0.982008794,0.982019017,0.982029239,0.982039459,0.982059892,0.982070106,0.982080318,0.982090528,0.982100736,0.982121146,0.982131349,0.982141549,0.982151747,0.982161944,0.982182331,0.982192521,0.98220271,0.982212897,0.982223081,0.982243445,0.982253624,0.982263801,0.982273976,0.98229432,0.982304489,0.982324821,0.982334984,0.982345146,0.982355305,0.982375618,0.982385771,0.982395923,0.982406072,0.98241622,0.982426366,0.982436509,0.982446651,0.982456791,0.982466928,0.982487198,0.98249733,0.98250746,0.982517588,0.982527714,0.98254796,0.98255808,0.982568198,0.982578314,0.982588428,0.98260865,0.982618759,0.982628865,0.982638969,0.982649071,0.98266927,0.982679366,0.982689461,0.982699553,0.982719732,0.982729818,0.982749985,0.982760066,0.982770144,0.982780221,0.982800368,0.982810438,0.982820507,0.982830574,0.982840638,0.982860761,0.98287082,0.982880877,0.982890931,0.982900984,0.982921083,0.98293113,0.982941175,0.982951217,0.982961258,0.982981333,0.982991368,0.983001401,0.983011431,0.98302146,0.983041511,0.983051534,0.983061555,0.983071573,0.98308159,0.983101617,0.983111628,0.983121636,0.983131643,0.983141647,0.983161651,0.983171649,0.983181646,0.98319164,0.983201633,0.983221612,0.983231598,0.983241583,0.983251565,0.983261545,0.983271524,0.9832815,0.983291475,0.983301447,0.983311417,0.983331352,0.983341316,0.983351278,0.983361238,0.983371197,0.983381153,0.983391107,0.983401059,0.983411009,0.983420957,0.983440847,0.983450789,0.983460729,0.983470667,0.983480602,0.983500468,0.983510398,0.983520325,0.983530251,0.983540175,0.983550096,0.983560016,0.983569933,0.983579849,0.983589762,0.983599674,0.983609583,0.98361949,0.983629395,0.983639299,0.983659099,0.983668996,0.983678891,0.983688784,0.983698675,0.983708564,0.98371845,0.983728335,0.983738218,0.983748099,0.983757977,0.983767854,0.983777728,0.983787601,0.983797471,0.983817206,0.98382707,0.983836932,0.983846792,0.98385665,0.983866506,0.98387636,0.983886212,0.983896062,0.983905909,0.983915755,0.983925599,0.98393544,0.98394528,0.983955117,0.983964952,0.983974785,0.983984617,0.983994446,0.984004273,0.984004273,0.984014098,0.984023921,0.984033742,0.98404356,0.98404356,0.984053377,0.984063192,0.984073004,0.984082815,0.984082815,0.984092623,0.984102429,0.984112233,0.984112233,0.984122036,0.984122036,0.984131836,0.984141634,0.984141634,0.984151429,0.984151429,0.984161223,0.984171015,0.984180805,0.984190592,0.984200378,0.984210161,0.984219942,0.984229722,0.984229722,0.984239499,0.984249274,0.984259047,0.984268818,0.984278586,0.984288353,0.984298118,0.98430788,0.98431764,0.984327399,0.984337155,0.984346909,0.984356661,0.984366411,0.984376159,0.984385905,0.984395648,0.98440539,0.984415129,0.984415129,0.984424866,0.984434602,0.984444335,0.984454066,0.984454066,0.984463795,0.984473521,0.984483246,0.984492969,0.984492969,0.984502689,0.984512408,0.984522124,0.984531838,0.984531838,0.98454155,0.98455126,0.984560968,0.984560968,0.984570674,0.984570674,0.984580377,0.984590079,0.984590079,0.984599778,0.984599778,0.984609475,0.98461917,0.98461917,0.984628863,0.984628863,0.984638554,0.984648243,0.984648243,0.98465793,0.98465793,0.984667614,0.984677297,0.984677297,0.984686977,0.984686977,0.984696655,0.984706331,0.984706331,0.984716005,0.984716005,0.984725677,0.984725677,0.984735347,0.984735347,0.984745014,0.984745014,0.98475468,0.98475468,0.984764343,0.984764343,0.984774004,0.984774004,0.984783663,0.984783663,0.98479332,0.98479332,0.984802975,0.984802975,0.984812628,0.984812628,0.984822278,0.984822278,0.984831927,0.984831927,0.984841573,0.984841573,0.984841573,0.984841573,0.984851217,0.984851217,0.984851217,0.984851217,0.984860859,0.984860859,0.984870499,0.984870499,0.984870499,0.984870499,0.984880137,0.984880137,0.984880137,0.984880137,0.984880137,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984889772,0.984880137,0.984880137,0.984870499,0.984870499,0.984860859,0.984851217,0.984851217,0.984841573,0.984831927,0.984822278,0.984812628,0.984802975,0.98479332,0.984783663,0.984774004,0.98475468,0.984745014,0.984725677,0.984716005,0.984696655,0.984677297,0.98465793,0.984638554,0.98461917])

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=90)
Ppro_tav90n = np.array([0.906535556,0.906535556,0.906535556,0.906535556,0.906535556,0.906535556,0.90663803,0.906740528,0.906828401,0.906930942,0.907033506,0.907106781,0.907180067,0.907268027,0.90734134,0.907414665,0.907488002,0.90754668,0.907620039,0.907678735,0.907752116,0.90779615,0.907840189,0.907898914,0.907942962,0.907987016,0.908031073,0.908075135,0.908104513,0.908148582,0.908192656,0.908222041,0.908266122,0.908295512,0.9083396,0.908368995,0.908398392,0.90842779,0.908457191,0.908486594,0.908515999,0.908560109,0.908604224,0.908633637,0.908677759,0.908721886,0.908751307,0.908780729,0.908824867,0.908854294,0.908883723,0.908913155,0.908942588,0.908972024,0.909001461,0.9090309,0.909060342,0.909075063,0.909104507,0.90911923,0.909148678,0.909178127,0.909192852,0.909222305,0.909237032,0.909266487,0.909281215,0.909295944,0.909325404,0.909340134,0.909354865,0.909369596,0.909399061,0.909413794,0.909443261,0.909457995,0.90947273,0.909487466,0.909516938,0.909531675,0.909546412,0.90956115,0.909590628,0.909605367,0.909634848,0.909649589,0.90966433,0.909693815,0.909708558,0.909738045,0.90975279,0.909767535,0.909797026,0.909811773,0.909841267,0.909856015,0.909885513,0.909915013,0.909929763,0.909959266,0.909988771,0.910018278,0.910047786,0.910062542,0.910092053,0.910121567,0.910151083,0.910180601,0.910210121,0.910239643,0.910269167,0.910298693,0.910342986,0.910372518,0.910416818,0.910446355,0.910490663,0.910520205,0.910564521,0.910594067,0.910638391,0.91068272,0.910727053,0.910756611,0.910800952,0.910845297,0.910889647,0.910934002,0.910978361,0.911022726,0.911067094,0.911111468,0.911155846,0.911215024,0.911259413,0.911303807,0.911348206,0.911407411,0.91145182,0.91151104,0.911555461,0.911599886,0.911659127,0.911703563,0.911762819,0.911807266,0.911866536,0.911910995,0.91197028,0.91201475,0.91207405,0.912133358,0.912177845,0.912237169,0.912281667,0.912341005,0.912400352,0.912459708,0.912519072,0.912578444,0.912637825,0.912697215,0.912756614,0.912816021,0.912875436,0.91293486,0.912994293,0.913053735,0.913098322,0.913157779,0.913217244,0.913276718,0.913336201,0.913380819,0.913440317,0.913499824,0.91355934,0.913618864,0.913663513,0.913723053,0.913782602,0.913842159,0.913901726,0.913946406,0.914005988,0.914065578,0.914110277,0.914169883,0.914214594,0.914274215,0.914318938,0.914363665,0.914408397,0.914453134,0.914497876,0.914542624,0.914587376,0.914632133,0.914661974,0.91470674,0.914751511,0.914796287,0.914841068,0.914870925,0.914915714,0.914960509,0.914990374,0.915035178,0.915065049,0.915109861,0.915139738,0.915169617,0.915214441,0.915244326,0.915289158,0.915319049,0.915348942,0.915378837,0.915423685,0.915453586,0.915483489,0.915513395,0.915543303,0.915573213,0.915603126,0.915633041,0.915662958,0.915677917,0.915707838,0.915722799,0.915752723,0.915767686,0.915797614,0.915812579,0.91584251,0.915857476,0.915872443,0.91588741,0.915902379,0.915917347,0.915932316,0.915947286,0.915962257,0.915962257,0.915977228,0.915992199,0.916007171,0.916007171,0.916022144,0.916022144,0.916037118,0.916037118,0.916052091,0.916052091,0.916067066,0.916067066,0.916082041,0.916082041,0.916097017,0.916097017,0.916111993,0.916111993,0.916111993,0.91612697,0.91612697,0.91612697,0.916141947,0.916141947,0.916156925,0.916156925,0.916171904,0.916171904,0.916186883,0.916186883,0.916201862,0.916201862,0.916216843,0.916231824,0.916231824,0.916246805,0.916261787,0.91627677,0.91627677,0.916291753,0.916291753,0.916306737,0.916321721,0.916336706,0.916336706,0.916351692,0.916366678,0.916381664,0.916381664,0.916396652,0.916396652,0.91641164,0.916426628,0.916441617,0.916441617,0.916456607,0.916471597,0.916486588,0.916501579,0.916516571,0.916531564,0.916546557,0.916561551,0.916576545,0.916606536,0.916621532,0.916636528,0.916666523,0.916681522,0.916711521,0.916726521,0.916756523,0.916786528,0.916801531,0.916831539,0.916846544,0.916876555,0.916906569,0.916936586,0.916966605,0.916996626,0.917026649,0.917056675,0.917086703,0.917101718,0.91713175,0.917161785,0.917191821,0.91722186,0.91723688,0.917266923,0.917296968,0.917327015,0.917357065,0.917372091,0.917402144,0.9174322,0.917462258,0.917477288,0.91750735,0.917522382,0.917552447,0.91756748,0.917582515,0.917612585,0.917627621,0.917642657,0.917672732,0.917687771,0.917717849,0.917732889,0.917762972,0.917778014,0.917793056,0.917823143,0.917838188,0.917853233,0.917868278,0.917883325,0.917898372,0.917913419,0.917928467,0.917943516,0.917958565,0.917958565,0.917973615,0.917988665,0.917988665,0.918003717,0.918003717,0.918018768,0.918018768,0.918018768,0.918018768,0.918033821,0.918033821,0.918033821,0.918033821,0.918033821,0.918033821,0.918033821,0.918033821,0.918033821,0.918018768,0.918018768,0.918003717,0.918003717,0.918003717,0.918003717,0.917988665,0.917988665,0.917988665,0.917988665,0.917973615,0.917973615,0.917958565,0.917958565,0.917958565,0.917943516,0.917943516,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917913419,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917928467,0.917943516,0.917943516,0.917943516,0.917943516,0.917943516,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917958565,0.917973615,0.917973615,0.917973615,0.917973615,0.917988665,0.917988665,0.918003717,0.918003717,0.918003717,0.918003717,0.918018768,0.918018768,0.918018768,0.918018768,0.918018768,0.918033821,0.918033821,0.918033821,0.918033821,0.918048874,0.918048874,0.918063927,0.918063927,0.918063927,0.918063927,0.918078981,0.918078981,0.918078981,0.918078981,0.918094036,0.918094036,0.918109091,0.918109091,0.918109091,0.918109091,0.918124147,0.918124147,0.918124147,0.918124147,0.918139204,0.918139204,0.918154261,0.918154261,0.918154261,0.918154261,0.918169319,0.918169319,0.918169319,0.918169319,0.918184377,0.918184377,0.918199436,0.918199436,0.918199436,0.918214496,0.918214496,0.918229556,0.918229556,0.918244617,0.918244617,0.918259679,0.918259679,0.918274741,0.918274741,0.918289803,0.918289803,0.918304867,0.918304867,0.918304867,0.918319931,0.918319931,0.918334995,0.918334995,0.918334995,0.91835006,0.91835006,0.918365126,0.918365126,0.918365126,0.918380192,0.918380192,0.918395259,0.918395259,0.918395259,0.918410327,0.918410327,0.918425395,0.918425395,0.918440464,0.918440464,0.918455534,0.918455534,0.918470604,0.918485674,0.918485674,0.918500746,0.918500746,0.918515818,0.91853089,0.91853089,0.918545963,0.918545963,0.918561037,0.918576111,0.918576111,0.918591186,0.918591186,0.918606262,0.918621338,0.918636415,0.918636415,0.918651492,0.918666571,0.918681649,0.918681649,0.918696729,0.918696729,0.918711808,0.918726889,0.91874197,0.91874197,0.918757052,0.918772134,0.918787217,0.918802301,0.918802301,0.918817385,0.91883247,0.918847556,0.918862642,0.918862642,0.918877729,0.918892816,0.918907904,0.918922993,0.918922993,0.918938082,0.918953172,0.918968262,0.918983353,0.918998445,0.919013537,0.91902863,0.919043724,0.919058818,0.919058818,0.919073913,0.919089009,0.919104105,0.919119201,0.919134299,0.919149397,0.919164495,0.919179595,0.919194694,0.919194694,0.919209795,0.919224896,0.919239998,0.9192551,0.919270203,0.919285307,0.919300411,0.919315516,0.919330621,0.919345727,0.919360834,0.919375942,0.91939105,0.919406158,0.919421267,0.919436377,0.919451488,0.919466599,0.919481711,0.919511936,0.91952705,0.919542164,0.919557279,0.919572395,0.919587511,0.919602628,0.919617745,0.919632864,0.919647982,0.919663102,0.919678222,0.919693342,0.919708464,0.919723586,0.919753831,0.919768955,0.91978408,0.919799205,0.91981433,0.919844584,0.919859711,0.91987484,0.919889969,0.919905098,0.919920228,0.919935359,0.919950491,0.919965623,0.919980755,0.920011023,0.920026157,0.920041293,0.920056429,0.920071565,0.92010184,0.920116979,0.920132118,0.920147258,0.920162398,0.920192681,0.920207823,0.920222966,0.92023811,0.920253254,0.920283545,0.920298691,0.920313838,0.920328985,0.920344133,0.920374432,0.920389582,0.920404732,0.920419884,0.920435036,0.920465342,0.920480496,0.92049565,0.920510806,0.920525962,0.920556275,0.920571433,0.920586592,0.920601751,0.920616911,0.920647232,0.920662394,0.920677556,0.920692719,0.920707883,0.920738212,0.920753378,0.920768544,0.920783711,0.920798879,0.920814047,0.920829216,0.920844385,0.920859556,0.920874727,0.92090507,0.920920243,0.920935417,0.920950591,0.920965765,0.920980941,0.920996117,0.921011294,0.921026471,0.921041649,0.921072007,0.921087187,0.921102368,0.921117549,0.921132731,0.921163097,0.921178281,0.921193466,0.921208651,0.921223837,0.921239024,0.921254211,0.921269399,0.921284588,0.921299777,0.921330158,0.921345349,0.921360541,0.921375733,0.921390927,0.92140612,0.921421315,0.92143651,0.921451706,0.921466903,0.921497298,0.921512496,0.921527696,0.921542895,0.921558096,0.921573297,0.921588499,0.921603702,0.921618905,0.921634109,0.921649313,0.921664518,0.921679724,0.921694931,0.921710138,0.921725346,0.921740554,0.921755764,0.921770973,0.921786184,0.921816607,0.92183182,0.921847033,0.921862247,0.921877461,0.921892677,0.921907893,0.921923109,0.921938326,0.921953544,0.921968763,0.921983982,0.921999202,0.922014423,0.922029644,0.922044866,0.922060089,0.922075312,0.922090536,0.922105761,0.922120986,0.922136212,0.922151439,0.922166666,0.922181894,0.922197123,0.922212352,0.922227582,0.922242813,0.922258045,0.922273277,0.922288509,0.922303743,0.922318977,0.922334212,0.922364684,0.92237992,0.922395158,0.922410396,0.922425635,0.922440875,0.922456115,0.922471356,0.922486598,0.92250184,0.922517083,0.922532327,0.922547571,0.922562816,0.922578062,0.922608555,0.922623803,0.922639051,0.922654301,0.92266955,0.922684801,0.922700052,0.922715304,0.922730557,0.92274581,0.922761064,0.922776318,0.922791574,0.92280683,0.922822086,0.922837344,0.922852602,0.922867861,0.92288312,0.92289838,0.922928903,0.922944165,0.922959428,0.922974691,0.922989956,0.923005221,0.923020486,0.923035753,0.92305102,0.923066287,0.923081556,0.923096825,0.923112095,0.923127365,0.923142637,0.923173181,0.923188454,0.923203728,0.923219003,0.923234278,0.923249555,0.923264831,0.923280109,0.923295387,0.923310666,0.923325945,0.923341226,0.923356507,0.923371788,0.923387071,0.923417637,0.923432922,0.923448207,0.923463493,0.923478779,0.923494067,0.923509355,0.923524643,0.923539933,0.923555223,0.923570514,0.923585805,0.923601097,0.92361639,0.923631684,0.923646978,0.923662273,0.923677569,0.923692865,0.923708162,0.92372346,0.923738758,0.923754058,0.923769357,0.923784658,0.923799959,0.923815261,0.923830564,0.923845868,0.923861172,0.923876477,0.923891782,0.923907089,0.923922396,0.923937703,0.923968321,0.923983631,0.923998941,0.924014252,0.924029564,0.924044877,0.92406019,0.924075504,0.924090819,0.924106135,0.924121451,0.924136768,0.924152086,0.924167404,0.924182723,0.924198043,0.924213363,0.924228685,0.924244007,0.924259329,0.924274653,0.924289977,0.924305302,0.924320627,0.924335953,0.92435128,0.924366608,0.924381936,0.924397265,0.924412595,0.924427926,0.924443257,0.924458589,0.924473922,0.924489255,0.924504589,0.924519924,0.92453526,0.924550596,0.924565933,0.924581271,0.924596609,0.924611949,0.924627289,0.924642629,0.924657971,0.924673313,0.924688656,0.924703999,0.924719343,0.924734688,0.924750034,0.924765381,0.924780728,0.924796076,0.924826774,0.924842124,0.924857474,0.924872826,0.924888178,0.924903531,0.924918885,0.924934239,0.924949595,0.92496495,0.924980307,0.924995664,0.925011023,0.925026381,0.925041741,0.925072462,0.925087824,0.925103186,0.92511855,0.925133914,0.925149278,0.925164644,0.92518001,0.925195377,0.925210744,0.925226113,0.925241482,0.925256852,0.925272222,0.925287594,0.925318338,0.925333712,0.925349086,0.925364461,0.925379837,0.92541059,0.925425968,0.925441347,0.925456727,0.925472107,0.925502869,0.925518252,0.925533635,0.925549019,0.925564403,0.925595175,0.925610561,0.925625949,0.925641337,0.925656726,0.925687507,0.925702898,0.92571829,0.925733683,0.925749076,0.925779866,0.925795262,0.925810658,0.925826055,0.925856852,0.925872252,0.925903053,0.925918455,0.925933857,0.925949261,0.925980069,0.925995475,0.926010881,0.926026288,0.926057104,0.926072514,0.926103334,0.926118746,0.926134158,0.926149571,0.9261804,0.926195815,0.926211231,0.926226648,0.926257484,0.926272903,0.926303743,0.926319165,0.92635001,0.926365433,0.926396283,0.926411709,0.926442563,0.926457991,0.92648885,0.92650428,0.926535144,0.926550576,0.926581444,0.926596879,0.926627752,0.926643189,0.926674066,0.926689506,0.926720387,0.926735829,0.926766716,0.92678216,0.926813051,0.926828497,0.926859393,0.926874842,0.926905742,0.926936645,0.926952098,0.926983005,0.926998461,0.927029373,0.927060289,0.927075747,0.927106668,0.927122129,0.927153054,0.927183982,0.927199447,0.927230379,0.927245847,0.927276784,0.927307725,0.927323196,0.927354141,0.927369615,0.927400565,0.927431517,0.927446995,0.927477953,0.927493433,0.927524395,0.92755536,0.927570844,0.927601815,0.927617301,0.927648276,0.927679254,0.927710235,0.927725727,0.927756713,0.927787702,0.927818694,0.927834191,0.927865189,0.927880688,0.92791169,0.927927192,0.927958199,0.927973703,0.928004714,0.928020221,0.928051237,0.928066747,0.928097768,0.928113279,0.928144305,0.928175334,0.928190849,0.928221883,0.928237401,0.92826844,0.928299481,0.928330526,0.92834605,0.9283771,0.928408153,0.928439209,0.928454738,0.928485799,0.928501331,0.928532397,0.928563466,0.928579002,0.928610076,0.928625614,0.928656693,0.928687775,0.92871886,0.928734404,0.928765495,0.928796588,0.928827685,0.928843234,0.928874336,0.928889888,0.928920995,0.928952105,0.928967661,0.928998775,0.929014334,0.929045454,0.929076577,0.929092139,0.929123267,0.929138832,0.929169965,0.929201101,0.929232241,0.929247812,0.929278956,0.929310104,0.929341255,0.929356832,0.929387988,0.929403567,0.929434728,0.929465892,0.929481476,0.929512645,0.929528231,0.929559405,0.929590583,0.929606173,0.929637355,0.929652948,0.929684136,0.929715327,0.929730923,0.929762119,0.929777719,0.92980892,0.929840124,0.929855728,0.929886937,0.929902543,0.929933758,0.929964976,0.929980586,0.930011809,0.930027422,0.93005865,0.930089881,0.930105498,0.930136735,0.930152354,0.930183596,0.930214841,0.930230465,0.930261715,0.930277341,0.930308596,0.930339855,0.930355486,0.93038675,0.930402383,0.930433652,0.930464924,0.930480561,0.930511839,0.930527479,0.930558762,0.930590048,0.930605692,0.930636983,0.93065263,0.930683927,0.930715227,0.930730878,0.930762183,0.930777837,0.930809147,0.930840461,0.930856119,0.930887438,0.930903099,0.930934423,0.930950086,0.930981416,0.930997082,0.931028416,0.931044085,0.931075425,0.931091096,0.931122441,0.931138115,0.931169465,0.931200819,0.931216497,0.931247856,0.931263537,0.931294902,0.931310585,0.931341955,0.931357641,0.931389016,0.931404705,0.931436085,0.931451777,0.931483162,0.931498856,0.931530247,0.931561641,0.93157734,0.93160874,0.931624441,0.931655846,0.93167155,0.93170296,0.931718667,0.931750083,0.931765792,0.931781502,0.931812925,0.931828638,0.931860066,0.931875781,0.931891498,0.931922933,0.931938652,0.931970093,0.931985815,0.932001537,0.932032985,0.932048711,0.932080164,0.932095892,0.932111621,0.932143082,0.932158813,0.932190279,0.932206014,0.932221749,0.932253222,0.93226896,0.932300439,0.93231618,0.932331921,0.932347664,0.932379152,0.932394897,0.932410643,0.93242639,0.932457887,0.932473637,0.932505139,0.932520892,0.932536645,0.9325524,0.932583911,0.932599669,0.932615427,0.932631186,0.932646945,0.932678468,0.932694231,0.932709994,0.932725759,0.93275729,0.932773058,0.932804595,0.932820365,0.932836136,0.932851908,0.932867681,0.932883454,0.932899229,0.932915004,0.932930781,0.932962337,0.932978116,0.932993896,0.933009677,0.933025459,0.933041242,0.933057026,0.933072811,0.933088597,0.933104383,0.93313596,0.933151749,0.93316754,0.933183331,0.933199123,0.933214916,0.933230711,0.933246506,0.933262302,0.933278099,0.933293897,0.933309695,0.933325495,0.933341296,0.933357098,0.9333729,0.933388704,0.933404508,0.933420314,0.93343612,0.933451927,0.933467735,0.933483545,0.933499355,0.933515166,0.933530978,0.933546791,0.933562605,0.933578419,0.933594235,0.933610052,0.93362587,0.933641688,0.933657508,0.933673328,0.93368915,0.933704972,0.933720796,0.93373662,0.933752445,0.933752445,0.933768271,0.933784099,0.933799927,0.933815756,0.933815756,0.933831586,0.933847417,0.933863249,0.933879082,0.933894915,0.93391075,0.933926586,0.933942423,0.93395826,0.93395826,0.933974099,0.933989938,0.934005779,0.93402162,0.93402162,0.934037463,0.934053306,0.934069151,0.934084996,0.934084996,0.934100842,0.93411669,0.934132538,0.934148387,0.934148387,0.934164237,0.934180088,0.93419594,0.934211793,0.934211793,0.934227647,0.934243502,0.934259358,0.934275215,0.934275215,0.934291073,0.934306932,0.934322792,0.934338652,0.934338652,0.934354514,0.934370377,0.93438624,0.934402105,0.934402105,0.934417971,0.934433837,0.934449705,0.934465573,0.934465573,0.934481443,0.934497313,0.934513185,0.934529057,0.934529057,0.934544931,0.934560805,0.93457668,0.93457668,0.934592557,0.934592557,0.934608434,0.934624312,0.934640192,0.934640192,0.934656072,0.934671953,0.934687835,0.934687835,0.934703718,0.934703718,0.934719602,0.934735488,0.934751374,0.934751374,0.934767261,0.934783149,0.934799038,0.934799038,0.934814928,0.934814928,0.934830819,0.934846711,0.934862604,0.934862604,0.934878498,0.934894393,0.934910289,0.934910289,0.934926186,0.934926186,0.934942084,0.934957983,0.934973883,0.934973883,0.934989784,0.935005686,0.935021588,0.935021588,0.935037492,0.935037492,0.935053397,0.935069303,0.93508521,0.93508521,0.935101118,0.935117027,0.935132936,0.935132936,0.935148847,0.935148847,0.935164759,0.935180672,0.935180672,0.935196586,0.935196586,0.9352125,0.935228416,0.935228416,0.935244333,0.935244333,0.935260251,0.93527617,0.93527617,0.935292089,0.935292089,0.93530801,0.935323932,0.935339855,0.935339855,0.935355779,0.935371703,0.935387629,0.935387629,0.935403556,0.935403556,0.935419484,0.935435413,0.935451342,0.935451342,0.935467273,0.935483205,0.935499138,0.935499138,0.935515072,0.935515072,0.935531006,0.935546942,0.935562879,0.935562879,0.935578817,0.935594756,0.935610696,0.935610696,0.935626637,0.935626637,0.935642579,0.935658521,0.935658521,0.935674465,0.935674465,0.93569041,0.935706356,0.935706356,0.935722303,0.935722303,0.935738251,0.9357542,0.93577015,0.93577015,0.935786101,0.935802053,0.935818006,0.935818006,0.93583396,0.93583396,0.935849915,0.935865872,0.935881829,0.935881829,0.935897787,0.935913746,0.935929706,0.935929706,0.935945667,0.935945667,0.93596163,0.935977593,0.935993557,0.935993557,0.936009522,0.936025489,0.936041456,0.936057424,0.936057424,0.936073394,0.936089364,0.936105336,0.936121308,0.936121308,0.936137282,0.936153256,0.936169232,0.936185208,0.936185208,0.936201186,0.936217164,0.936233144,0.936249125,0.936249125,0.936265107,0.936281089,0.936297073,0.936313058,0.936313058,0.936329044,0.936345031,0.936361019,0.936377008,0.936392998,0.936408989,0.936424981,0.936440974,0.936456968,0.936456968,0.936472963,0.936488959,0.936504957,0.936520955,0.936520955,0.936536954,0.936552955,0.936568956,0.936584959,0.936600962,0.936616967,0.936632972,0.936648979,0.936664987,0.936680995,0.936697005,0.936713016,0.936729028,0.936745041,0.936761055,0.93677707,0.936793086,0.936809103,0.936825121,0.93684114,0.936857161,0.936873182,0.936889204,0.936905228,0.936921252,0.936937278,0.936953305,0.936969332,0.936985361,0.937001391,0.937017422,0.937033453,0.937049486,0.93706552,0.937097592,0.937113629,0.937129667,0.937145706,0.937161747,0.937177788,0.937193831,0.937209874,0.937225919,0.937241965,0.937274059,0.937290108,0.937306158,0.937322209,0.937338261,0.937354315,0.937370369,0.937386424,0.93740248,0.937418538,0.937450656,0.937466717,0.937482779,0.937498841,0.937514905,0.937547036,0.937563104,0.937579172,0.937595241,0.937611311,0.937643455,0.937659529,0.937675604,0.93769168,0.937707756,0.937739913,0.937755993,0.937772075,0.937788157,0.93780424,0.93783641,0.937852497,0.937868585,0.937884674,0.937900763,0.937916854,0.937932947,0.93794904,0.937965134,0.937981229,0.938013423,0.938029522,0.938045622,0.938061723,0.938077824,0.938110032,0.938126137,0.938142243,0.938158351,0.938174459,0.938206679,0.938222791,0.938238904,0.938255018,0.938271133,0.938303367,0.938319485,0.938335605,0.938351726,0.938367847,0.938400094,0.938416219,0.938432346,0.938448473,0.938464601,0.938496862,0.938512993,0.938529126,0.93854526,0.938561395,0.938593669,0.938609807,0.938625947,0.938642088,0.938658229,0.938690516,0.938706661,0.938722808,0.938738955,0.938755104,0.938787404,0.938803556,0.938819709,0.938835863,0.938852018,0.938884332,0.938900491,0.938916651,0.938932812,0.938948974,0.938981301,0.938997467,0.939013633,0.939029801,0.93904597,0.939078311,0.939094483,0.939110656,0.939126831,0.939143007,0.939175361,0.93919154,0.939207721,0.939223902,0.939240084,0.939272453,0.939288639,0.939304826,0.939321014,0.939353394,0.939369585,0.939401972,0.939418167,0.939434363,0.939450561,0.939482959,0.93949916,0.939515362,0.939531565,0.939547769,0.939563975,0.939580181,0.939596389,0.939612598,0.939628808,0.939661231,0.939677445,0.93969366,0.939709875,0.939726093,0.93975853,0.93977475,0.939790972,0.939807195,0.939823419,0.93985587,0.939872098,0.939888327,0.939904556,0.939920787,0.939953253,0.939969487,0.939985723,0.94000196,0.940034437,0.940050677,0.940083162,0.940099405,0.94011565,0.940131897,0.940164393,0.940180642,0.940196893,0.940213146,0.940229399,0.940261909,0.940278166,0.940294424,0.940310683,0.940326943,0.940359468,0.940375732,0.940391997,0.940408263,0.940424531,0.940457069,0.940473341,0.940489613,0.940505886,0.940522161,0.940554714,0.940570992,0.940587272,0.940603552,0.940619834,0.940652401,0.940668687,0.940684973,0.940701261,0.94071755,0.940750132,0.940766425,0.940782719,0.940799014,0.94081531,0.940847906,0.940864206,0.940880507,0.940896809,0.940913113,0.940929417,0.940945723,0.940962031,0.940978339,0.940994648,0.941027271,0.941043584,0.941059899,0.941076215,0.941092531,0.941108849,0.941125169,0.941141489,0.941157811,0.941174134,0.941206784,0.94122311,0.941239438,0.941255767,0.941272097,0.941304762,0.941321096,0.941337431,0.941353767,0.941370105,0.941386444,0.941402784,0.941419125,0.941435468,0.941451812,0.941468157,0.941484503,0.941500851,0.941517199,0.941533549,0.941566253,0.941582607,0.941598962,0.941615318,0.941631675,0.941648034,0.941664394,0.941680755,0.941697117,0.941713481,0.941729846,0.941746212,0.941762579,0.941778948,0.941795318,0.941828061,0.941844435,0.94186081,0.941877186,0.941893563,0.941909942,0.941926322,0.941942703,0.941959085,0.941975469,0.941991854,0.94200824,0.942024627,0.942041016,0.942057406,0.942073797,0.94209019,0.942106583,0.942122978,0.942139375,0.942139375,0.942155772,0.942172171,0.942188571,0.942204972,0.942204972,0.942221375,0.942237779,0.942254184,0.94227059,0.94227059,0.942286998,0.942303407,0.942319817,0.942319817,0.942336228,0.942336228,0.942352641,0.942369055,0.942369055,0.94238547,0.94238547,0.942401887,0.942418305,0.942434724,0.942451144,0.942467566,0.942483989,0.942500413,0.942516838,0.942516838,0.942533265,0.942549693,0.942566123,0.942582553,0.942598985,0.942615418,0.942631853,0.942648289,0.942664726,0.942681164,0.942697604,0.942714045,0.942730487,0.94274693,0.942763375,0.942779821,0.942796269,0.942812717,0.942829167,0.942829167,0.942845619,0.942862071,0.942878525,0.94289498,0.94289498,0.942911437,0.942927894,0.942944353,0.942960814,0.942960814,0.942977275,0.942993738,0.943010203,0.943026668,0.943026668,0.943043135,0.943059603,0.943076073,0.943076073,0.943092544,0.943092544,0.943109016,0.943125489,0.943125489,0.943141964,0.943141964,0.94315844,0.943174917,0.943174917,0.943191396,0.943191396,0.943207876,0.943224357,0.943224357,0.94324084,0.94324084,0.943257324,0.943273809,0.943273809,0.943290295,0.943290295,0.943306783,0.943323272,0.943323272,0.943339763,0.943339763,0.943356255,0.943356255,0.943372748,0.943372748,0.943389242,0.943389242,0.943405738,0.943405738,0.943422235,0.943422235,0.943438734,0.943438734,0.943455233,0.943455233,0.943471735,0.943471735,0.943488237,0.943488237,0.943504741,0.943504741,0.943521246,0.943521246,0.943537752,0.943537752,0.94355426,0.94355426,0.94355426,0.94355426,0.943570769,0.943570769,0.943570769,0.943570769,0.943587279,0.943587279,0.943603791,0.943603791,0.943603791,0.943603791,0.943620304,0.943620304,0.943620304,0.943620304,0.943620304,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943636818,0.943620304,0.943620304,0.943603791,0.943603791,0.943587279,0.943570769,0.943570769,0.94355426,0.943537752,0.943521246,0.943504741,0.943488237,0.943471735,0.943455233,0.943438734,0.943405738,0.943389242,0.943356255,0.943339763,0.943306783,0.943273809,0.94324084,0.943207876,0.943174917])


## PROSPECT_D

# Refractive Index:
PD_refractive = np.array([1.5115, 1.5115, 1.5115, 1.5115, 1.5115, 1.5115, 1.5108, 1.5101, 1.5095, 1.5088, 
                        1.5081, 1.5076, 1.5071, 1.5065, 1.506, 1.5055, 1.505, 1.5046, 1.5041, 1.5037,
                        1.5032, 1.5029, 1.5026, 1.5022, 1.5019, 1.5016, 1.5013, 1.501, 1.5008, 1.5005,
                        1.5002, 1.5, 1.4997, 1.4995, 1.4992, 1.499, 1.4988, 1.4986, 1.4984, 1.4982,
                        1.498, 1.4977, 1.4974, 1.4972, 1.4969, 1.4966, 1.4964, 1.4962, 1.4959, 1.4957,
                        1.4955, 1.4953, 1.4951, 1.4949, 1.4947, 1.4945, 1.4943, 1.4942, 1.494, 1.4939,
                        1.4937, 1.4935, 1.4934, 1.4932, 1.4931, 1.4929, 1.4928, 1.4927, 1.4925, 1.4924,
                        1.4923, 1.4922, 1.492, 1.4919, 1.4917, 1.4916, 1.4915, 1.4914, 1.4912, 1.4911,
                        1.491, 1.4909, 1.4907, 1.4906, 1.4904, 1.4903, 1.4902, 1.49, 1.4899, 1.4897,
                        1.4896, 1.4895, 1.4893, 1.4892, 1.489, 1.4889, 1.4887, 1.4885, 1.4884, 1.4882,
                        1.488, 1.4878, 1.4876, 1.4875, 1.4873, 1.4871, 1.4869, 1.4867, 1.4865, 1.4863,
                        1.4861, 1.4859, 1.4856, 1.4854, 1.4851, 1.4849, 1.4846, 1.4844, 1.4841, 1.4839,
                        1.4836, 1.4833, 1.483, 1.4828, 1.4825, 1.4822, 1.4819, 1.4816, 1.4813, 1.481,
                        1.4807, 1.4804, 1.4801, 1.4797, 1.4794, 1.4791, 1.4788, 1.4784, 1.4781, 1.4777,
                        1.4774, 1.4771, 1.4767, 1.4764, 1.476, 1.4757, 1.4753, 1.475, 1.4746, 1.4743,
                        1.4739, 1.4735, 1.4732, 1.4728, 1.4725, 1.4721, 1.4717, 1.4713, 1.4709, 1.4705,
                        1.4701, 1.4697, 1.4693, 1.4689, 1.4685, 1.4681, 1.4677, 1.4673, 1.467, 1.4666,
                        1.4662, 1.4658, 1.4654, 1.4651, 1.4647, 1.4643, 1.4639, 1.4635, 1.4632, 1.4628,
                        1.4624, 1.462, 1.4616, 1.4613, 1.4609, 1.4605, 1.4602, 1.4598, 1.4595, 1.4591,
                        1.4588, 1.4585, 1.4582, 1.4579, 1.4576, 1.4573, 1.457, 1.4567, 1.4565, 1.4562,
                        1.4559, 1.4556, 1.4553, 1.4551, 1.4548, 1.4545, 1.4543, 1.454, 1.4538, 1.4535,
                        1.4533, 1.4531, 1.4528, 1.4526, 1.4523, 1.4521, 1.4519, 1.4517, 1.4514, 1.4512,
                        1.451, 1.4508, 1.4506, 1.4504, 1.4502, 1.45, 1.4498, 1.4497, 1.4495, 1.4494,
                        1.4492, 1.4491, 1.4489, 1.4488, 1.4486, 1.4485, 1.4484, 1.4483, 1.4482, 1.4481,
                        1.448, 1.4479, 1.4478, 1.4478, 1.4477, 1.4476, 1.4475, 1.4475, 1.4474, 1.4474,
                        1.4473, 1.4473, 1.4472, 1.4472, 1.4471, 1.4471, 1.447, 1.447, 1.4469, 1.4469,
                        1.4468, 1.4468, 1.4468, 1.4467, 1.4467, 1.4467, 1.4466, 1.4466, 1.4465, 1.4465,
                        1.4464, 1.4464, 1.4463, 1.4463, 1.4462, 1.4462, 1.4461, 1.446, 1.446, 1.4459,
                        1.4458, 1.4457, 1.4457, 1.4456, 1.4456, 1.4455, 1.4454, 1.4453, 1.4453, 1.4452,
                        1.4451, 1.445, 1.445, 1.4449, 1.4449, 1.4448, 1.4447, 1.4446, 1.4446, 1.4445,
                        1.4444, 1.4443, 1.4442, 1.4441, 1.444, 1.4439, 1.4438, 1.4437, 1.4435, 1.4434,
                        1.4433, 1.4431, 1.443, 1.4428, 1.4427, 1.4425, 1.4423, 1.4422, 1.442, 1.4419,
                        1.4417, 1.4415, 1.4413, 1.4411, 1.4409, 1.4407, 1.4405, 1.4403, 1.4402, 1.44,
                        1.4398, 1.4396, 1.4394, 1.4393, 1.4391, 1.4389, 1.4387, 1.4385, 1.4384, 1.4382,
                        1.438, 1.4378, 1.4377, 1.4375, 1.4374, 1.4372, 1.4371, 1.437, 1.4368, 1.4367,
                        1.4366, 1.4364, 1.4363, 1.4361, 1.436, 1.4358, 1.4357, 1.4356, 1.4354, 1.4353,
                        1.4352, 1.4351, 1.435, 1.4349, 1.4348, 1.4347, 1.4346, 1.4345, 1.4345, 1.4344,
                        1.4343, 1.4343, 1.4342, 1.4342, 1.4341, 1.4341, 1.4341, 1.4341, 1.434, 1.434,
                        1.434, 1.434, 1.434, 1.434, 1.434, 1.434, 1.434, 1.4341, 1.4341, 1.4342,
                        1.4342, 1.4342, 1.4342, 1.4343, 1.4343, 1.4343, 1.4343, 1.4344, 1.4344, 1.4345,
                        1.4345, 1.4345, 1.4346, 1.4346, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347,
                        1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347,
                        1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4348, 1.4348,
                        1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348,
                        1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4348, 1.4347, 1.4347,
                        1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4347, 1.4346, 1.4346,
                        1.4346, 1.4346, 1.4346, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345, 1.4345,
                        1.4345, 1.4345, 1.4345, 1.4344, 1.4344, 1.4344, 1.4344, 1.4343, 1.4343, 1.4342,
                        1.4342, 1.4342, 1.4342, 1.4341, 1.4341, 1.4341, 1.4341, 1.4341, 1.434, 1.434,
                        1.434, 1.434, 1.4339, 1.4339, 1.4338, 1.4338, 1.4338, 1.4338, 1.4337, 1.4337,
                        1.4337, 1.4337, 1.4336, 1.4336, 1.4335, 1.4335, 1.4335, 1.4335, 1.4334, 1.4334,
                        1.4334, 1.4334, 1.4333, 1.4333, 1.4332, 1.4332, 1.4332, 1.4332, 1.4331, 1.4331,
                        1.4331, 1.4331, 1.433, 1.433, 1.4329, 1.4329, 1.4329, 1.4328, 1.4328, 1.4327,
                        1.4327, 1.4326, 1.4326, 1.4325, 1.4325, 1.4324, 1.4324, 1.4323, 1.4323, 1.4322,
                        1.4322, 1.4322, 1.4321, 1.4321, 1.432, 1.432, 1.432, 1.4319, 1.4319, 1.4318,
                        1.4318, 1.4318, 1.4317, 1.4317, 1.4316, 1.4316, 1.4316, 1.4315, 1.4315, 1.4314,
                        1.4314, 1.4313, 1.4313, 1.4312, 1.4312, 1.4311, 1.431, 1.431, 1.4309, 1.4309,
                        1.4308, 1.4307, 1.4307, 1.4306, 1.4306, 1.4305, 1.4304, 1.4304, 1.4303, 1.4303,
                        1.4302, 1.4301, 1.43, 1.43, 1.4299, 1.4298, 1.4297, 1.4297, 1.4296, 1.4296,
                        1.4295, 1.4294, 1.4293, 1.4293, 1.4292, 1.4291, 1.429, 1.4289, 1.4289, 1.4288,
                        1.4287, 1.4286, 1.4285, 1.4285, 1.4284, 1.4283, 1.4282, 1.4281, 1.4281, 1.428,
                        1.4279, 1.4278, 1.4277, 1.4276, 1.4275, 1.4274, 1.4273, 1.4272, 1.4272, 1.4271,
                        1.427, 1.4269, 1.4268, 1.4267, 1.4266, 1.4265, 1.4264, 1.4263, 1.4263, 1.4262,
                        1.4261, 1.426, 1.4259, 1.4258, 1.4257, 1.4256, 1.4255, 1.4254, 1.4253, 1.4252,
                        1.4251, 1.425, 1.4249, 1.4248, 1.4247, 1.4246, 1.4245, 1.4244, 1.4242, 1.4241,
                        1.424, 1.4239, 1.4238, 1.4237, 1.4236, 1.4235, 1.4234, 1.4233, 1.4232, 1.4231,
                        1.423, 1.4229, 1.4228, 1.4226, 1.4225, 1.4224, 1.4223, 1.4222, 1.422, 1.4219,
                        1.4218, 1.4217, 1.4216, 1.4215, 1.4214, 1.4213, 1.4212, 1.4211, 1.4209, 1.4208,
                        1.4207, 1.4206, 1.4205, 1.4203, 1.4202, 1.4201, 1.42, 1.4199, 1.4197, 1.4196,
                        1.4195, 1.4194, 1.4193, 1.4191, 1.419, 1.4189, 1.4188, 1.4187, 1.4185, 1.4184,
                        1.4183, 1.4182, 1.4181, 1.4179, 1.4178, 1.4177, 1.4176, 1.4175, 1.4173, 1.4172,
                        1.4171, 1.417, 1.4169, 1.4167, 1.4166, 1.4165, 1.4164, 1.4163, 1.4161, 1.416,
                        1.4159, 1.4158, 1.4157, 1.4156, 1.4155, 1.4154, 1.4153, 1.4152, 1.415, 1.4149,
                        1.4148, 1.4147, 1.4146, 1.4145, 1.4144, 1.4143, 1.4142, 1.4141, 1.4139, 1.4138,
                        1.4137, 1.4136, 1.4135, 1.4133, 1.4132, 1.4131, 1.413, 1.4129, 1.4128, 1.4127,
                        1.4126, 1.4125, 1.4124, 1.4122, 1.4121, 1.412, 1.4119, 1.4118, 1.4117, 1.4116,
                        1.4115, 1.4114, 1.4113, 1.4111, 1.411, 1.4109, 1.4108, 1.4107, 1.4106, 1.4105,
                        1.4104, 1.4103, 1.4102, 1.4101, 1.41, 1.4099, 1.4098, 1.4097, 1.4096, 1.4095,
                        1.4094, 1.4093, 1.4092, 1.409, 1.4089, 1.4088, 1.4087, 1.4086, 1.4085, 1.4084,
                        1.4083, 1.4082, 1.4081, 1.408, 1.4079, 1.4078, 1.4077, 1.4076, 1.4075, 1.4074,
                        1.4073, 1.4072, 1.4071, 1.407, 1.4069, 1.4068, 1.4067, 1.4066, 1.4065, 1.4064,
                        1.4063, 1.4062, 1.4061, 1.406, 1.4059, 1.4058, 1.4057, 1.4056, 1.4054, 1.4053,
                        1.4052, 1.4051, 1.405, 1.4049, 1.4048, 1.4047, 1.4046, 1.4045, 1.4044, 1.4043,
                        1.4042, 1.4041, 1.404, 1.4038, 1.4037, 1.4036, 1.4035, 1.4034, 1.4033, 1.4032,
                        1.4031, 1.403, 1.4029, 1.4028, 1.4027, 1.4026, 1.4025, 1.4024, 1.4023, 1.4022,
                        1.4021, 1.402, 1.4019, 1.4017, 1.4016, 1.4015, 1.4014, 1.4013, 1.4012, 1.4011,
                        1.401, 1.4009, 1.4008, 1.4007, 1.4006, 1.4005, 1.4004, 1.4003, 1.4001, 1.4,
                        1.3999, 1.3998, 1.3997, 1.3996, 1.3995, 1.3994, 1.3993, 1.3992, 1.3991, 1.399,
                        1.3989, 1.3988, 1.3987, 1.3985, 1.3984, 1.3983, 1.3982, 1.3981, 1.398, 1.3979,
                        1.3978, 1.3977, 1.3976, 1.3975, 1.3974, 1.3973, 1.3972, 1.3971, 1.397, 1.3969,
                        1.3968, 1.3967, 1.3966, 1.3965, 1.3964, 1.3963, 1.3962, 1.3961, 1.396, 1.3959,
                        1.3958, 1.3957, 1.3956, 1.3955, 1.3954, 1.3953, 1.3952, 1.3951, 1.3949, 1.3948,
                        1.3947, 1.3946, 1.3945, 1.3944, 1.3943, 1.3942, 1.3941, 1.394, 1.3939, 1.3938,
                        1.3937, 1.3936, 1.3935, 1.3934, 1.3933, 1.3932, 1.3931, 1.393, 1.3929, 1.3928,
                        1.3927, 1.3926, 1.3925, 1.3924, 1.3923, 1.3922, 1.3921, 1.392, 1.3919, 1.3918,
                        1.3917, 1.3916, 1.3915, 1.3914, 1.3913, 1.3912, 1.3911, 1.391, 1.3909, 1.3908,
                        1.3907, 1.3906, 1.3905, 1.3904, 1.3903, 1.3902, 1.3901, 1.39, 1.3899, 1.3898,
                        1.3897, 1.3896, 1.3895, 1.3893, 1.3892, 1.3891, 1.389, 1.3889, 1.3888, 1.3887,
                        1.3886, 1.3885, 1.3884, 1.3883, 1.3882, 1.3881, 1.388, 1.3879, 1.3877, 1.3876,
                        1.3875, 1.3874, 1.3873, 1.3872, 1.3871, 1.387, 1.3869, 1.3868, 1.3867, 1.3866,
                        1.3865, 1.3864, 1.3863, 1.3861, 1.386, 1.3859, 1.3858, 1.3857, 1.3855, 1.3854,
                        1.3853, 1.3852, 1.3851, 1.3849, 1.3848, 1.3847, 1.3846, 1.3845, 1.3843, 1.3842,
                        1.3841, 1.384, 1.3839, 1.3837, 1.3836, 1.3835, 1.3834, 1.3833, 1.3831, 1.383,
                        1.3829, 1.3828, 1.3826, 1.3825, 1.3823, 1.3822, 1.3821, 1.382, 1.3818, 1.3817,
                        1.3816, 1.3815, 1.3813, 1.3812, 1.381, 1.3809, 1.3808, 1.3807, 1.3805, 1.3804,
                        1.3803, 1.3802, 1.38, 1.3799, 1.3797, 1.3796, 1.3794, 1.3793, 1.3791, 1.379,
                        1.3788, 1.3787, 1.3785, 1.3784, 1.3782, 1.3781, 1.3779, 1.3778, 1.3776, 1.3775,
                        1.3773, 1.3772, 1.377, 1.3769, 1.3767, 1.3766, 1.3764, 1.3763, 1.3761, 1.376,
                        1.3758, 1.3756, 1.3755, 1.3753, 1.3752, 1.375, 1.3748, 1.3747, 1.3745, 1.3744,
                        1.3742, 1.374, 1.3739, 1.3737, 1.3736, 1.3734, 1.3732, 1.3731, 1.3729, 1.3728,
                        1.3726, 1.3724, 1.3723, 1.3721, 1.372, 1.3718, 1.3716, 1.3715, 1.3713, 1.3712,
                        1.371, 1.3708, 1.3706, 1.3705, 1.3703, 1.3701, 1.3699, 1.3698, 1.3696, 1.3695,
                        1.3693, 1.3692, 1.369, 1.3689, 1.3687, 1.3686, 1.3684, 1.3683, 1.3681, 1.368,
                        1.3678, 1.3676, 1.3675, 1.3673, 1.3672, 1.367, 1.3668, 1.3666, 1.3665, 1.3663,
                        1.3661, 1.3659, 1.3658, 1.3656, 1.3655, 1.3653, 1.3651, 1.365, 1.3648, 1.3647,
                        1.3645, 1.3643, 1.3641, 1.364, 1.3638, 1.3636, 1.3634, 1.3633, 1.3631, 1.363,
                        1.3628, 1.3626, 1.3625, 1.3623, 1.3622, 1.362, 1.3618, 1.3617, 1.3615, 1.3614,
                        1.3612, 1.361, 1.3608, 1.3607, 1.3605, 1.3603, 1.3601, 1.36, 1.3598, 1.3597,
                        1.3595, 1.3593, 1.3592, 1.359, 1.3589, 1.3587, 1.3585, 1.3584, 1.3582, 1.3581,
                        1.3579, 1.3577, 1.3576, 1.3574, 1.3573, 1.3571, 1.3569, 1.3568, 1.3566, 1.3565,
                        1.3563, 1.3561, 1.356, 1.3558, 1.3557, 1.3555, 1.3553, 1.3552, 1.355, 1.3549,
                        1.3547, 1.3545, 1.3544, 1.3542, 1.3541, 1.3539, 1.3537, 1.3536, 1.3534, 1.3533,
                        1.3531, 1.3529, 1.3528, 1.3526, 1.3525, 1.3523, 1.3521, 1.352, 1.3518, 1.3517,
                        1.3515, 1.3513, 1.3512, 1.351, 1.3509, 1.3507, 1.3505, 1.3504, 1.3502, 1.3501,
                        1.3499, 1.3498, 1.3496, 1.3495, 1.3493, 1.3492, 1.349, 1.3489, 1.3487, 1.3486,
                        1.3484, 1.3482, 1.3481, 1.3479, 1.3478, 1.3476, 1.3475, 1.3473, 1.3472, 1.347,
                        1.3469, 1.3467, 1.3466, 1.3464, 1.3463, 1.3461, 1.3459, 1.3458, 1.3456, 1.3455,
                        1.3453, 1.3452, 1.345, 1.3449, 1.3447, 1.3446, 1.3445, 1.3443, 1.3442, 1.344,
                        1.3439, 1.3438, 1.3436, 1.3435, 1.3433, 1.3432, 1.3431, 1.3429, 1.3428, 1.3426,
                        1.3425, 1.3424, 1.3422, 1.3421, 1.3419, 1.3418, 1.3417, 1.3415, 1.3414, 1.3412,
                        1.3411, 1.341, 1.3409, 1.3407, 1.3406, 1.3405, 1.3404, 1.3402, 1.3401, 1.3399,
                        1.3398, 1.3397, 1.3396, 1.3394, 1.3393, 1.3392, 1.3391, 1.339, 1.3388, 1.3387,
                        1.3386, 1.3385, 1.3383, 1.3382, 1.338, 1.3379, 1.3378, 1.3377, 1.3376, 1.3375,
                        1.3374, 1.3373, 1.3372, 1.337, 1.3369, 1.3368, 1.3367, 1.3366, 1.3365, 1.3364,
                        1.3363, 1.3362, 1.3361, 1.3359, 1.3358, 1.3357, 1.3356, 1.3355, 1.3354, 1.3353,
                        1.3352, 1.3351, 1.335, 1.3349, 1.3348, 1.3347, 1.3346, 1.3345, 1.3344, 1.3343,
                        1.3342, 1.3341, 1.334, 1.3339, 1.3338, 1.3337, 1.3336, 1.3335, 1.3334, 1.3333,
                        1.3332, 1.3331, 1.333, 1.3329, 1.3328, 1.3327, 1.3326, 1.3325, 1.3324, 1.3323,
                        1.3322, 1.3321, 1.332, 1.332, 1.3319, 1.3318, 1.3317, 1.3316, 1.3316, 1.3315,
                        1.3314, 1.3313, 1.3312, 1.3311, 1.331, 1.3309, 1.3308, 1.3307, 1.3307, 1.3306,
                        1.3305, 1.3304, 1.3303, 1.3303, 1.3302, 1.3301, 1.33, 1.3299, 1.3299, 1.3298,
                        1.3297, 1.3296, 1.3295, 1.3295, 1.3294, 1.3293, 1.3292, 1.3291, 1.3291, 1.329,
                        1.3289, 1.3288, 1.3287, 1.3287, 1.3286, 1.3285, 1.3284, 1.3283, 1.3283, 1.3282,
                        1.3281, 1.328, 1.3279, 1.3279, 1.3278, 1.3277, 1.3276, 1.3275, 1.3275, 1.3274,
                        1.3273, 1.3272, 1.3271, 1.3271, 1.327, 1.3269, 1.3268, 1.3268, 1.3267, 1.3267,
                        1.3266, 1.3265, 1.3264, 1.3264, 1.3263, 1.3262, 1.3261, 1.3261, 1.326, 1.326,
                        1.3259, 1.3258, 1.3257, 1.3257, 1.3256, 1.3255, 1.3254, 1.3254, 1.3253, 1.3253,
                        1.3252, 1.3251, 1.325, 1.325, 1.3249, 1.3248, 1.3247, 1.3247, 1.3246, 1.3246,
                        1.3245, 1.3244, 1.3243, 1.3243, 1.3242, 1.3241, 1.324, 1.324, 1.3239, 1.3239,
                        1.3238, 1.3237, 1.3236, 1.3236, 1.3235, 1.3234, 1.3233, 1.3233, 1.3232, 1.3232,
                        1.3231, 1.323, 1.323, 1.3229, 1.3229, 1.3228, 1.3227, 1.3227, 1.3226, 1.3226,
                        1.3225, 1.3224, 1.3224, 1.3223, 1.3223, 1.3222, 1.3221, 1.322, 1.322, 1.3219,
                        1.3218, 1.3217, 1.3217, 1.3216, 1.3216, 1.3215, 1.3214, 1.3213, 1.3213, 1.3212,
                        1.3211, 1.321, 1.321, 1.3209, 1.3209, 1.3208, 1.3207, 1.3206, 1.3206, 1.3205,
                        1.3204, 1.3203, 1.3203, 1.3202, 1.3202, 1.3201, 1.32, 1.32, 1.3199, 1.3199,
                        1.3198, 1.3197, 1.3197, 1.3196, 1.3196, 1.3195, 1.3194, 1.3193, 1.3193, 1.3192,
                        1.3191, 1.319, 1.319, 1.3189, 1.3189, 1.3188, 1.3187, 1.3186, 1.3186, 1.3185,
                        1.3184, 1.3183, 1.3183, 1.3182, 1.3182, 1.3181, 1.318, 1.3179, 1.3179, 1.3178,
                        1.3177, 1.3176, 1.3175, 1.3175, 1.3174, 1.3173, 1.3172, 1.3171, 1.3171, 1.317,
                        1.3169, 1.3168, 1.3167, 1.3167, 1.3166, 1.3165, 1.3164, 1.3163, 1.3163, 1.3162,
                        1.3161, 1.316, 1.3159, 1.3159, 1.3158, 1.3157, 1.3156, 1.3155, 1.3154, 1.3153,
                        1.3152, 1.3151, 1.315, 1.315, 1.3149, 1.3148, 1.3147, 1.3146, 1.3146, 1.3145,
                        1.3144, 1.3143, 1.3142, 1.3141, 1.314, 1.3139, 1.3138, 1.3137, 1.3136, 1.3135,
                        1.3134, 1.3133, 1.3132, 1.3131, 1.313, 1.3129, 1.3128, 1.3127, 1.3126, 1.3125,
                        1.3124, 1.3123, 1.3122, 1.3121, 1.312, 1.3119, 1.3118, 1.3117, 1.3116, 1.3115,
                        1.3114, 1.3113, 1.3112, 1.311, 1.3109, 1.3108, 1.3107, 1.3106, 1.3105, 1.3104,
                        1.3103, 1.3102, 1.3101, 1.3099, 1.3098, 1.3097, 1.3096, 1.3095, 1.3094, 1.3093,
                        1.3092, 1.3091, 1.309, 1.3088, 1.3087, 1.3086, 1.3085, 1.3084, 1.3082, 1.3081,
                        1.308, 1.3079, 1.3078, 1.3076, 1.3075, 1.3074, 1.3073, 1.3072, 1.307, 1.3069,
                        1.3068, 1.3067, 1.3066, 1.3064, 1.3063, 1.3062, 1.3061, 1.306, 1.3059, 1.3058,
                        1.3057, 1.3056, 1.3055, 1.3053, 1.3052, 1.3051, 1.305, 1.3049, 1.3047, 1.3046,
                        1.3045, 1.3044, 1.3043, 1.3041, 1.304, 1.3039, 1.3038, 1.3037, 1.3035, 1.3034,
                        1.3033, 1.3032, 1.3031, 1.3029, 1.3028, 1.3027, 1.3026, 1.3025, 1.3023, 1.3022,
                        1.3021, 1.302, 1.3019, 1.3017, 1.3016, 1.3015, 1.3014, 1.3013, 1.3011, 1.301,
                        1.3009, 1.3008, 1.3007, 1.3005, 1.3004, 1.3003, 1.3002, 1.3001, 1.2999, 1.2998,
                        1.2997, 1.2996, 1.2995, 1.2993, 1.2992, 1.2991, 1.299, 1.2989, 1.2987, 1.2986,
                        1.2985, 1.2984, 1.2983, 1.2981, 1.298, 1.2979, 1.2978, 1.2977, 1.2975, 1.2974,
                        1.2973, 1.2972, 1.297, 1.2969, 1.2967, 1.2966, 1.2965, 1.2964, 1.2962, 1.2961,
                        1.296, 1.2959, 1.2958, 1.2957, 1.2956, 1.2955, 1.2954, 1.2953, 1.2951, 1.295,
                        1.2949, 1.2948, 1.2947, 1.2945, 1.2944, 1.2943, 1.2942, 1.2941, 1.2939, 1.2938,
                        1.2937, 1.2936, 1.2935, 1.2933, 1.2932, 1.2931, 1.293, 1.2928, 1.2927, 1.2925,
                        1.2924, 1.2923, 1.2922, 1.292, 1.2919, 1.2918, 1.2917, 1.2916, 1.2914, 1.2913,
                        1.2912, 1.2911, 1.291, 1.2908, 1.2907, 1.2906, 1.2905, 1.2904, 1.2902, 1.2901,
                        1.29, 1.2899, 1.2898, 1.2896, 1.2895, 1.2894, 1.2893, 1.2892, 1.289, 1.2889,
                        1.2888, 1.2887, 1.2886, 1.2884, 1.2883, 1.2882, 1.2881, 1.288, 1.2878, 1.2877,
                        1.2876, 1.2875, 1.2874, 1.2873, 1.2872, 1.2871, 1.287, 1.2869, 1.2867, 1.2866,
                        1.2865, 1.2864, 1.2863, 1.2862, 1.2861, 1.286, 1.2859, 1.2858, 1.2856, 1.2855,
                        1.2854, 1.2853, 1.2852, 1.285, 1.2849, 1.2848, 1.2847, 1.2846, 1.2845, 1.2844,
                        1.2843, 1.2842, 1.2841, 1.284, 1.2839, 1.2838, 1.2837, 1.2836, 1.2834, 1.2833,
                        1.2832, 1.2831, 1.283, 1.2829, 1.2828, 1.2827, 1.2826, 1.2825, 1.2824, 1.2823,
                        1.2822, 1.2821, 1.282, 1.2818, 1.2817, 1.2816, 1.2815, 1.2814, 1.2813, 1.2812,
                        1.2811, 1.281, 1.2809, 1.2808, 1.2807, 1.2806, 1.2805, 1.2804, 1.2803, 1.2802,
                        1.2801, 1.28, 1.2799, 1.2799, 1.2798, 1.2797, 1.2796, 1.2795, 1.2795, 1.2794,
                        1.2793, 1.2792, 1.2791, 1.2791, 1.279, 1.2789, 1.2788, 1.2788, 1.2787, 1.2787,
                        1.2786, 1.2785, 1.2785, 1.2784, 1.2784, 1.2783, 1.2782, 1.2781, 1.278, 1.2779,
                        1.2778, 1.2777, 1.2776, 1.2776, 1.2775, 1.2774, 1.2773, 1.2772, 1.2771, 1.277,
                        1.2769, 1.2768, 1.2767, 1.2766, 1.2765, 1.2764, 1.2763, 1.2762, 1.2761, 1.276,
                        1.2759, 1.2758, 1.2757, 1.2757, 1.2756, 1.2755, 1.2754, 1.2753, 1.2753, 1.2752,
                        1.2751, 1.275, 1.2749, 1.2749, 1.2748, 1.2747, 1.2746, 1.2745, 1.2745, 1.2744,
                        1.2743, 1.2742, 1.2742, 1.2741, 1.2741, 1.274, 1.2739, 1.2739, 1.2738, 1.2738,
                        1.2737, 1.2736, 1.2736, 1.2735, 1.2735, 1.2734, 1.2733, 1.2733, 1.2732, 1.2732,
                        1.2731, 1.273, 1.273, 1.2729, 1.2729, 1.2728, 1.2727, 1.2727, 1.2726, 1.2726,
                        1.2725, 1.2725, 1.2724, 1.2724, 1.2723, 1.2723, 1.2722, 1.2722, 1.2721, 1.2721,
                        1.272, 1.272, 1.2719, 1.2719, 1.2718, 1.2718, 1.2717, 1.2717, 1.2716, 1.2716,
                        1.2715, 1.2715, 1.2714, 1.2714, 1.2713, 1.2713, 1.2713, 1.2713, 1.2712, 1.2712,
                        1.2712, 1.2712, 1.2711, 1.2711, 1.271, 1.271, 1.271, 1.271, 1.2709, 1.2709,
                        1.2709, 1.2709, 1.2709, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708,
                        1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2709, 1.2709, 1.271,
                        1.271, 1.2711, 1.2712, 1.2712, 1.2713, 1.2714, 1.2715, 1.2716, 1.2717, 1.2718,
                        1.2719, 1.272, 1.2722, 1.2723, 1.2725, 1.2726, 1.2728, 1.273, 1.2732, 1.2734,
                        1.2736])

PD_k_Cab = np.array([0.064881, 0.066732, 0.068551, 0.069982, 0.0709, 0.071333, 0.07132, 0.07126, 0.071223, 0.071228, 
                    0.071491, 0.071888, 0.072018, 0.071827, 0.071493, 0.071132, 0.070763, 0.070437, 0.070094, 0.06984,
                    0.069819, 0.070054, 0.070281, 0.070503, 0.070473, 0.070528, 0.070809, 0.071312, 0.071622, 0.071905,
                    0.072449, 0.073091, 0.073652, 0.074047, 0.074335, 0.074542, 0.074691, 0.074653, 0.07457, 0.074285,
                    0.073794, 0.072818, 0.071622, 0.070459, 0.069105, 0.067568, 0.066026, 0.064492, 0.062668, 0.060755,
                    0.058775, 0.056778, 0.054732, 0.052844, 0.051125, 0.049573, 0.048139, 0.046801, 0.045645, 0.044691,
                    0.043873, 0.043162, 0.042653, 0.042206, 0.041774, 0.041297, 0.040911, 0.040571, 0.040302, 0.040009,
                    0.039727, 0.039521, 0.039292, 0.039035, 0.038773, 0.038523, 0.03826, 0.037881, 0.03751, 0.037149,
                    0.036776, 0.0363, 0.035761, 0.03521, 0.034583, 0.033909, 0.033184, 0.032377, 0.031519, 0.030584,
                    0.029662, 0.028699, 0.027692, 0.02664, 0.02559, 0.024517, 0.023428, 0.022328, 0.021224, 0.020137,
                    0.019048, 0.01798, 0.016943, 0.015923, 0.014934, 0.013979, 0.01305, 0.012154, 0.011296, 0.01048,
                    0.0097008, 0.008954, 0.0082461, 0.00758, 0.0069574, 0.0063867, 0.005868, 0.0054015, 0.0049913, 0.0046349,
                    0.0043338, 0.004085, 0.0038874, 0.0037421, 0.0036525, 0.0036118, 0.0036193, 0.0036728, 0.0037697, 0.0039032,
                    0.004069, 0.0042637, 0.0044843, 0.00473, 0.0049935, 0.0052728, 0.0055645, 0.0058662, 0.0061706, 0.0064792,
                    0.0067864, 0.00709, 0.007388, 0.0076742, 0.0079483, 0.0082083, 0.0084536, 0.008685, 0.0089037, 0.0091119,
                    0.0093094, 0.0095001, 0.0096821, 0.0098639, 0.01004, 0.010214, 0.010386, 0.010556, 0.010724, 0.010889,
                    0.011048, 0.011217, 0.011402, 0.011605, 0.011827, 0.012075, 0.01234, 0.012628, 0.012933, 0.01326,
                    0.013598, 0.013947, 0.014301, 0.014658, 0.01501, 0.015357, 0.015693, 0.016023, 0.01634, 0.016648,
                    0.016945, 0.017241, 0.017527, 0.017801, 0.018066, 0.018325, 0.018568, 0.0188, 0.019019, 0.019228,
                    0.019419, 0.019599, 0.019766, 0.019922, 0.020066, 0.020199, 0.020327, 0.020458, 0.020585, 0.020715,
                    0.020854, 0.021007, 0.021172, 0.021348, 0.021546, 0.021764, 0.022003, 0.022268, 0.022553, 0.022859,
                    0.023177, 0.023502, 0.023842, 0.024199, 0.024561, 0.024917, 0.025269, 0.025617, 0.02595, 0.026255,
                    0.02653, 0.026786, 0.02701, 0.027207, 0.027379, 0.027523, 0.027645, 0.027739, 0.027821, 0.027895,
                    0.027978, 0.028072, 0.028194, 0.02836, 0.028573, 0.028846, 0.029181, 0.029599, 0.030077, 0.030634,
                    0.031248, 0.031927, 0.032659, 0.033441, 0.034255, 0.035101, 0.035949, 0.036779, 0.037588, 0.038323,
                    0.039014, 0.039631, 0.040222, 0.040804, 0.041418, 0.042107, 0.04288, 0.043808, 0.044861, 0.046107,
                    0.047495, 0.049113, 0.050849, 0.05273, 0.0547, 0.056761, 0.058868, 0.06083, 0.06275, 0.064472,
                    0.066112, 0.067471, 0.068675, 0.069635, 0.070465, 0.070995, 0.071402, 0.071358, 0.071127, 0.070185,
                    0.068921, 0.066576, 0.063948, 0.060482, 0.056858, 0.052747, 0.048726, 0.044707, 0.040858, 0.037141,
                    0.033671, 0.030459, 0.027502, 0.024787, 0.02233, 0.020144, 0.018173, 0.016421, 0.014852, 0.013471,
                    0.012241, 0.011155, 0.010193, 0.009343, 0.0085869, 0.007915, 0.0073126, 0.0067711, 0.0062803, 0.0058322,
                    0.0054214, 0.0050449, 0.0046965, 0.0043735, 0.004072, 0.0037922, 0.0035302, 0.0032856, 0.0030575, 0.0028435,
                    0.0026434, 0.0024563, 0.0022809, 0.0021168, 0.0019636, 0.0018206, 0.0016869, 0.0015628, 0.0014468, 0.0013388,
                    0.0012386, 0.0011459, 0.0010591, 0.00097828, 0.00090409, 0.00083609, 0.00077289, 0.00071503, 0.00066162, 0.00061235,
                    0.00056764, 0.00052722, 0.00048994, 0.00045636, 0.00042566, 0.00039812, 0.00037316, 0.00035104, 0.00033141, 0.00031371,
                    0.00029841, 0.00028315, 0.00026796, 0.00025289, 0.00023795, 0.00022319, 0.00020864, 0.00019431, 0.00018026, 0.00016649,
                    0.00015306, 0.00013998, 0.00012729, 0.00011501, 0.00010319, 9.1841e-05, 8.1005e-05, 7.0709e-05, 6.0985e-05, 5.1862e-05,
                    4.3372e-05, 3.5545e-05, 2.8412e-05, 2.2003e-05, 1.6349e-05, 1.1481e-05, 7.4298e-06, 4.2252e-06, 1.8983e-06, 4.7969e-07,
                    1.0525e-13, 0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000])

PD_k_Car = np.array([0.16734, 0.16761, 0.16718, 0.16721, 0.16761, 0.1676, 0.16751, 0.16743, 0.16724, 0.16668, 
                    0.16588, 0.16552, 0.16545, 0.16569, 0.16609, 0.16619, 0.16629, 0.16646, 0.16662, 0.16687,
                    0.16716, 0.16754, 0.16798, 0.16844, 0.1686, 0.16847, 0.16814, 0.168, 0.16773, 0.16741,
                    0.16755, 0.16774, 0.16791, 0.16797, 0.16794, 0.16797, 0.16818, 0.16832, 0.1687, 0.16916,
                    0.16957, 0.16968, 0.16963, 0.1699, 0.16991, 0.16981, 0.16977, 0.16973, 0.16935, 0.16857,
                    0.16744, 0.16602, 0.16446, 0.1629, 0.16136, 0.15978, 0.15822, 0.15656, 0.15497, 0.1533,
                    0.15167, 0.14997, 0.14832, 0.14677, 0.14508, 0.14349, 0.142, 0.14055, 0.13919, 0.13802,
                    0.13701, 0.13614, 0.13548, 0.135, 0.13464, 0.13437, 0.13417, 0.13394, 0.13375, 0.13356,
                    0.13327, 0.13279, 0.13217, 0.13141, 0.13042, 0.12922, 0.12782, 0.12631, 0.12457, 0.12269,
                    0.12066, 0.1186, 0.11652, 0.11441, 0.11227, 0.11011, 0.10793, 0.10573, 0.1035, 0.10126,
                    0.099004, 0.096734, 0.09445, 0.092156, 0.089854, 0.087544, 0.085228, 0.082909, 0.080588, 0.078267,
                    0.075947, 0.073631, 0.071319, 0.069014, 0.066717, 0.064431, 0.062156, 0.059895, 0.057649, 0.055421,
                    0.053211, 0.051021, 0.048854, 0.04671, 0.044592, 0.042502, 0.040441, 0.03841, 0.036412, 0.034449,
                    0.032521, 0.030631, 0.028781, 0.026971, 0.025205, 0.023483, 0.021808, 0.020181, 0.018603, 0.017077,
                    0.015605, 0.014187, 0.012826, 0.011524, 0.010282, 0.0091015, 0.0079848, 0.0069335, 0.0059492, 0.0050338,
                    0.004189, 0.0034164, 0.0027178, 0.0020949, 0.0015495, 0.0010832, 0.00069786, 0.00039514, 0.00017677, 4.448e-05,
                    2.1316e-13, 0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000])

PD_k_Anth = np.array([0.066675, 0.064056, 0.061933, 0.059922, 0.058277, 0.056699, 0.055366, 0.054163, 0.053116, 0.05198, 
                    0.050951, 0.050117, 0.049387, 0.048604, 0.047876, 0.047379, 0.046899, 0.046532, 0.046157, 0.045792,
                    0.045429, 0.045144, 0.044845, 0.044536, 0.044249, 0.044116, 0.043958, 0.043874, 0.043805, 0.043858,
                    0.043861, 0.043912, 0.043959, 0.044037, 0.04411, 0.044203, 0.044277, 0.044399, 0.04451, 0.044647,
                    0.044787, 0.044919, 0.045061, 0.045227, 0.045415, 0.045589, 0.045753, 0.045857, 0.045994, 0.046195,
                    0.046414, 0.04668, 0.046953, 0.047162, 0.04736, 0.047593, 0.047814, 0.048082, 0.048335, 0.048595,
                    0.048839, 0.049123, 0.04937, 0.049608, 0.049841, 0.050136, 0.05042, 0.050784, 0.05115, 0.051557,
                    0.051941, 0.052387, 0.05282, 0.053409, 0.05399, 0.054462, 0.05494, 0.055543, 0.056155, 0.056638,
                    0.057152, 0.057689, 0.058265, 0.058847, 0.059478, 0.060054, 0.06067, 0.061221, 0.061809, 0.062358,
                    0.062922, 0.063434, 0.06397, 0.064462, 0.064964, 0.065431, 0.06591, 0.066378, 0.066852, 0.067309,
                    0.067771, 0.068133, 0.068479, 0.068815, 0.06914, 0.069362, 0.069563, 0.069828, 0.070073, 0.070279,
                    0.070472, 0.070679, 0.070872, 0.071025, 0.071165, 0.071285, 0.07139, 0.071486, 0.071573, 0.07163,
                    0.071682, 0.071739, 0.071775, 0.071815, 0.071864, 0.071959, 0.07206, 0.072153, 0.07224, 0.072295,
                    0.072349, 0.072414, 0.072476, 0.07251, 0.072528, 0.072529, 0.072506, 0.072433, 0.07234, 0.07221,
                    0.072063, 0.071837, 0.071602, 0.071343, 0.071067, 0.070707, 0.070307, 0.06984, 0.069355, 0.068756,
                    0.06814, 0.06744, 0.066733, 0.065904, 0.065061, 0.06421, 0.063357, 0.062437, 0.061518, 0.060579,
                    0.059652, 0.058611, 0.057591, 0.056554, 0.055543, 0.054379, 0.053243, 0.052056, 0.0509, 0.049671,
                    0.048481, 0.047309, 0.046174, 0.045, 0.043871, 0.042781, 0.041734, 0.040618, 0.039543, 0.038457,
                    0.037412, 0.0362, 0.035043, 0.033919, 0.032846, 0.031701, 0.030606, 0.029616, 0.028665, 0.027715,
                    0.026803, 0.025951, 0.025134, 0.024293, 0.023487, 0.022687, 0.021918, 0.021085, 0.020284, 0.019497,
                    0.01874, 0.017977, 0.017242, 0.016604, 0.015987, 0.01541, 0.014845, 0.014317, 0.0138, 0.013295,
                    0.012801, 0.012336, 0.011884, 0.011394, 0.010918, 0.010464, 0.010022, 0.0095808, 0.0091553, 0.0087766,
                    0.008411, 0.0080523, 0.0077073, 0.0073755, 0.0070567, 0.0067504, 0.0064566, 0.0061747, 0.0059044, 0.0056455,
                    0.0053977, 0.0051604, 0.0049336, 0.0047168, 0.0045097, 0.004312, 0.0041234, 0.0039435, 0.003772, 0.0036087,
                    0.003453, 0.0033048, 0.0031638, 0.0030295, 0.0029017, 0.00278, 0.0026642, 0.0025538, 0.0024487, 0.0023483,
                    0.0022525, 0.0021608, 0.0020731, 0.0019889, 0.0019079, 0.0018298, 0.0017542, 0.0016809, 0.0016096, 0.0015398,
                    0.0014713, 0.0014037, 0.0013368, 0.0012702, 0.0012035, 0.0011365, 0.0010688, 0.0010001, 0.00093008, 0.00085841,
                    0.00078476, 0.00071002, 0.00063884, 0.00057124, 0.00050727, 0.00044695, 0.0003903, 0.00033737, 0.00028817, 0.00024273,
                    0.0002011, 0.00016329, 0.00012933, 9.9259e-05, 7.3102e-05, 5.0888e-05, 3.2647e-05, 1.8408e-05, 8.2009e-06, 2.0551e-06,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000])

PD_k_Brown =  np.array([5.272e-01, 5.262e-01, 5.252e-01, 5.242e-01, 5.232e-01, 5.222e-01, 5.212e-01, 5.202e-01, 5.192e-01, 5.182e-01, 
                        5.172e-01, 5.162e-01, 5.152e-01, 5.142e-01, 5.132e-01, 5.122e-01, 5.112e-01, 5.102e-01, 5.092e-01, 5.082e-01,
                        5.072e-01, 5.062e-01, 5.052e-01, 5.042e-01, 5.032e-01, 5.022e-01, 5.012e-01, 5.002e-01, 4.992e-01, 4.982e-01,
                        4.972e-01, 4.960e-01, 4.948e-01, 4.936e-01, 4.924e-01, 4.912e-01, 4.900e-01, 4.888e-01, 4.876e-01, 4.864e-01,
                        4.852e-01, 4.840e-01, 4.829e-01, 4.817e-01, 4.805e-01, 4.793e-01, 4.781e-01, 4.769e-01, 4.757e-01, 4.745e-01,
                        4.733e-01, 4.720e-01, 4.708e-01, 4.695e-01, 4.683e-01, 4.670e-01, 4.658e-01, 4.645e-01, 4.633e-01, 4.620e-01,
                        4.608e-01, 4.597e-01, 4.587e-01, 4.577e-01, 4.566e-01, 4.556e-01, 4.546e-01, 4.535e-01, 4.525e-01, 4.515e-01,
                        4.504e-01, 4.494e-01, 4.484e-01, 4.473e-01, 4.463e-01, 4.453e-01, 4.442e-01, 4.432e-01, 4.422e-01, 4.411e-01,
                        4.401e-01, 4.388e-01, 4.375e-01, 4.362e-01, 4.350e-01, 4.337e-01, 4.324e-01, 4.311e-01, 4.298e-01, 4.285e-01,
                        4.272e-01, 4.260e-01, 4.247e-01, 4.234e-01, 4.221e-01, 4.208e-01, 4.195e-01, 4.183e-01, 4.170e-01, 4.157e-01,
                        4.144e-01, 4.135e-01, 4.127e-01, 4.118e-01, 4.109e-01, 4.100e-01, 4.092e-01, 4.083e-01, 4.074e-01, 4.065e-01,
                        4.057e-01, 4.047e-01, 4.038e-01, 4.028e-01, 4.019e-01, 4.009e-01, 4.000e-01, 3.990e-01, 3.981e-01, 3.971e-01,
                        3.962e-01, 3.952e-01, 3.943e-01, 3.933e-01, 3.924e-01, 3.914e-01, 3.905e-01, 3.895e-01, 3.886e-01, 3.876e-01,
                        3.867e-01, 3.846e-01, 3.824e-01, 3.803e-01, 3.782e-01, 3.760e-01, 3.739e-01, 3.718e-01, 3.696e-01, 3.675e-01,
                        3.654e-01, 3.639e-01, 3.625e-01, 3.611e-01, 3.597e-01, 3.582e-01, 3.568e-01, 3.554e-01, 3.540e-01, 3.525e-01,
                        3.511e-01, 3.500e-01, 3.489e-01, 3.478e-01, 3.467e-01, 3.456e-01, 3.445e-01, 3.434e-01, 3.423e-01, 3.412e-01,
                        3.401e-01, 3.383e-01, 3.366e-01, 3.348e-01, 3.330e-01, 3.312e-01, 3.294e-01, 3.276e-01, 3.258e-01, 3.241e-01,
                        3.223e-01, 3.202e-01, 3.182e-01, 3.162e-01, 3.141e-01, 3.121e-01, 3.100e-01, 3.080e-01, 3.059e-01, 3.039e-01,
                        3.019e-01, 2.999e-01, 2.979e-01, 2.959e-01, 2.940e-01, 2.920e-01, 2.900e-01, 2.881e-01, 2.861e-01, 2.841e-01,
                        2.821e-01, 2.803e-01, 2.784e-01, 2.766e-01, 2.747e-01, 2.728e-01, 2.710e-01, 2.691e-01, 2.673e-01, 2.654e-01,
                        2.636e-01, 2.618e-01, 2.601e-01, 2.584e-01, 2.566e-01, 2.549e-01, 2.532e-01, 2.515e-01, 2.497e-01, 2.480e-01,
                        2.463e-01, 2.447e-01, 2.431e-01, 2.414e-01, 2.398e-01, 2.382e-01, 2.366e-01, 2.350e-01, 2.334e-01, 2.318e-01,
                        2.302e-01, 2.288e-01, 2.273e-01, 2.258e-01, 2.244e-01, 2.229e-01, 2.215e-01, 2.200e-01, 2.185e-01, 2.171e-01,
                        2.156e-01, 2.143e-01, 2.129e-01, 2.115e-01, 2.102e-01, 2.088e-01, 2.074e-01, 2.061e-01, 2.047e-01, 2.033e-01,
                        2.020e-01, 2.007e-01, 1.994e-01, 1.981e-01, 1.968e-01, 1.955e-01, 1.942e-01, 1.929e-01, 1.916e-01, 1.903e-01,
                        1.890e-01, 1.878e-01, 1.865e-01, 1.853e-01, 1.841e-01, 1.829e-01, 1.816e-01, 1.804e-01, 1.792e-01, 1.780e-01,
                        1.768e-01, 1.755e-01, 1.742e-01, 1.729e-01, 1.717e-01, 1.704e-01, 1.691e-01, 1.679e-01, 1.666e-01, 1.653e-01,
                        1.641e-01, 1.627e-01, 1.613e-01, 1.600e-01, 1.586e-01, 1.572e-01, 1.559e-01, 1.545e-01, 1.532e-01, 1.518e-01,
                        1.504e-01, 1.491e-01, 1.478e-01, 1.464e-01, 1.451e-01, 1.437e-01, 1.424e-01, 1.411e-01, 1.397e-01, 1.384e-01,
                        1.370e-01, 1.358e-01, 1.345e-01, 1.333e-01, 1.320e-01, 1.308e-01, 1.295e-01, 1.283e-01, 1.270e-01, 1.258e-01,
                        1.245e-01, 1.234e-01, 1.223e-01, 1.212e-01, 1.200e-01, 1.189e-01, 1.178e-01, 1.167e-01, 1.156e-01, 1.144e-01,
                        1.133e-01, 1.122e-01, 1.111e-01, 1.100e-01, 1.089e-01, 1.078e-01, 1.067e-01, 1.056e-01, 1.046e-01, 1.035e-01,
                        1.024e-01, 1.013e-01, 1.003e-01, 9.931e-02, 9.829e-02, 9.727e-02, 9.625e-02, 9.524e-02, 9.422e-02, 9.320e-02,
                        9.218e-02, 9.120e-02, 9.022e-02, 8.924e-02, 8.827e-02, 8.729e-02, 8.631e-02, 8.533e-02, 8.435e-02, 8.337e-02,
                        8.239e-02, 8.155e-02, 8.070e-02, 7.985e-02, 7.901e-02, 7.816e-02, 7.732e-02, 7.647e-02, 7.562e-02, 7.478e-02,
                        7.393e-02, 7.319e-02, 7.245e-02, 7.171e-02, 7.097e-02, 7.023e-02, 6.949e-02, 6.875e-02, 6.801e-02, 6.727e-02,
                        6.653e-02, 6.586e-02, 6.519e-02, 6.452e-02, 6.385e-02, 6.318e-02, 6.251e-02, 6.184e-02, 6.117e-02, 6.050e-02,
                        5.983e-02, 5.913e-02, 5.843e-02, 5.773e-02, 5.704e-02, 5.634e-02, 5.564e-02, 5.494e-02, 5.424e-02, 5.354e-02,
                        5.284e-02, 5.226e-02, 5.167e-02, 5.109e-02, 5.050e-02, 4.992e-02, 4.933e-02, 4.874e-02, 4.816e-02, 4.757e-02,
                        4.699e-02, 4.646e-02, 4.594e-02, 4.542e-02, 4.490e-02, 4.437e-02, 4.385e-02, 4.333e-02, 4.281e-02, 4.228e-02,
                        4.176e-02, 4.128e-02, 4.081e-02, 4.033e-02, 3.985e-02, 3.937e-02, 3.889e-02, 3.841e-02, 3.793e-02, 3.746e-02,
                        3.698e-02, 3.657e-02, 3.615e-02, 3.574e-02, 3.533e-02, 3.492e-02, 3.451e-02, 3.409e-02, 3.368e-02, 3.327e-02,
                        3.286e-02, 3.249e-02, 3.212e-02, 3.175e-02, 3.139e-02, 3.102e-02, 3.065e-02, 3.028e-02, 2.991e-02, 2.954e-02,
                        2.918e-02, 2.885e-02, 2.852e-02, 2.819e-02, 2.786e-02, 2.753e-02, 2.720e-02, 2.688e-02, 2.655e-02, 2.622e-02,
                        2.589e-02, 2.559e-02, 2.529e-02, 2.499e-02, 2.469e-02, 2.440e-02, 2.410e-02, 2.380e-02, 2.350e-02, 2.320e-02,
                        2.290e-02, 2.264e-02, 2.238e-02, 2.212e-02, 2.186e-02, 2.159e-02, 2.133e-02, 2.107e-02, 2.081e-02, 2.055e-02,
                        2.029e-02, 2.006e-02, 1.983e-02, 1.961e-02, 1.938e-02, 1.915e-02, 1.893e-02, 1.870e-02, 1.847e-02, 1.825e-02,
                        1.802e-02, 1.782e-02, 1.762e-02, 1.742e-02, 1.723e-02, 1.703e-02, 1.683e-02, 1.663e-02, 1.643e-02, 1.623e-02,
                        1.604e-02, 1.586e-02, 1.568e-02, 1.551e-02, 1.533e-02, 1.516e-02, 1.498e-02, 1.481e-02, 1.463e-02, 1.446e-02,
                        1.428e-02, 1.414e-02, 1.400e-02, 1.385e-02, 1.371e-02, 1.357e-02, 1.343e-02, 1.328e-02, 1.314e-02, 1.300e-02,
                        1.286e-02, 1.275e-02, 1.265e-02, 1.255e-02, 1.245e-02, 1.235e-02, 1.225e-02, 1.215e-02, 1.205e-02, 1.195e-02,
                        1.185e-02, 1.175e-02, 1.165e-02, 1.155e-02, 1.145e-02, 1.135e-02, 1.125e-02, 1.115e-02, 1.105e-02, 1.096e-02,
                        1.086e-02, 1.076e-02, 1.066e-02, 1.056e-02, 1.047e-02, 1.037e-02, 1.027e-02, 1.017e-02, 1.008e-02, 9.980e-03,
                        9.884e-03, 9.787e-03, 9.691e-03, 9.595e-03, 9.500e-03, 9.404e-03, 9.309e-03, 9.214e-03, 9.120e-03, 9.025e-03,
                        8.931e-03, 8.837e-03, 8.743e-03, 8.650e-03, 8.557e-03, 8.464e-03, 8.371e-03, 8.279e-03, 8.187e-03, 8.095e-03,
                        8.004e-03, 7.913e-03, 7.822e-03, 7.732e-03, 7.641e-03, 7.552e-03, 7.462e-03, 7.373e-03, 7.284e-03, 7.195e-03,
                        7.107e-03, 7.019e-03, 6.932e-03, 6.844e-03, 6.758e-03, 6.671e-03, 6.585e-03, 6.499e-03, 6.414e-03, 6.329e-03,
                        6.244e-03, 6.160e-03, 6.076e-03, 5.993e-03, 5.910e-03, 5.827e-03, 5.745e-03, 5.663e-03, 5.581e-03, 5.500e-03,
                        5.419e-03, 5.339e-03, 5.259e-03, 5.180e-03, 5.101e-03, 5.023e-03, 4.945e-03, 4.867e-03, 4.790e-03, 4.713e-03,
                        4.637e-03, 4.561e-03, 4.486e-03, 4.411e-03, 4.337e-03, 4.263e-03, 4.190e-03, 4.117e-03, 4.044e-03, 3.972e-03,
                        3.901e-03, 3.830e-03, 3.760e-03, 3.690e-03, 3.620e-03, 3.552e-03, 3.483e-03, 3.416e-03, 3.348e-03, 3.282e-03,
                        3.215e-03, 3.150e-03, 3.085e-03, 3.020e-03, 2.956e-03, 2.893e-03, 2.830e-03, 2.768e-03, 2.706e-03, 2.645e-03,
                        2.585e-03, 2.525e-03, 2.465e-03, 2.407e-03, 2.348e-03, 2.291e-03, 2.234e-03, 2.178e-03, 2.122e-03, 2.067e-03,
                        2.012e-03, 1.959e-03, 1.905e-03, 1.853e-03, 1.801e-03, 1.750e-03, 1.699e-03, 1.649e-03, 1.600e-03, 1.551e-03,
                        1.503e-03, 1.456e-03, 1.409e-03, 1.363e-03, 1.318e-03, 1.274e-03, 1.230e-03, 1.187e-03, 1.144e-03, 1.102e-03,
                        1.061e-03, 1.021e-03, 9.811e-04, 9.422e-04, 9.040e-04, 8.665e-04, 8.297e-04, 7.937e-04, 7.584e-04, 7.239e-04,
                        6.901e-04, 6.571e-04, 6.248e-04, 5.933e-04, 5.626e-04, 5.326e-04, 5.034e-04, 4.750e-04, 4.473e-04, 4.205e-04,
                        3.944e-04, 3.691e-04, 3.446e-04, 3.210e-04, 2.981e-04, 2.760e-04, 2.548e-04, 2.344e-04, 2.148e-04, 1.960e-04,
                        1.780e-04, 1.609e-04, 1.446e-04, 1.292e-04, 1.146e-04, 1.009e-04, 8.804e-05, 7.603e-05, 6.488e-05, 5.460e-05,
                        4.519e-05, 3.666e-05, 2.901e-05, 2.225e-05, 1.637e-05, 1.138e-05, 7.297e-06, 4.111e-06, 1.830e-06, 4.581e-07,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                        0.0])

PD_k_Cw = np.array([5.800E-05, 5.852E-05, 5.900E-05, 5.989E-05, 6.100E-05, 6.203E-05, 6.300E-05, 6.399E-05, 6.500E-05, 6.603E-05, 
                    6.700E-05, 6.790E-05, 6.900E-05, 7.050E-05, 7.200E-05, 7.312E-05, 7.400E-05, 7.490E-05, 7.600E-05, 7.740E-05,
                    7.900E-05, 8.063E-05, 8.200E-05, 8.297E-05, 8.400E-05, 8.551E-05, 8.700E-05, 8.800E-05, 8.900E-05, 9.050E-05,
                    9.200E-05, 9.300E-05, 9.400E-05, 9.550E-05, 9.700E-05, 9.801E-05, 9.900E-05, 1.005E-04, 1.020E-04, 1.031E-04,
                    1.040E-04, 1.050E-04, 1.060E-04, 1.070E-04, 1.080E-04, 1.090E-04, 1.100E-04, 1.110E-04, 1.120E-04, 1.130E-04,
                    1.140E-04, 1.150E-04, 1.160E-04, 1.170E-04, 1.180E-04, 1.190E-04, 1.200E-04, 1.210E-04, 1.220E-04, 1.230E-04,
                    1.240E-04, 1.250E-04, 1.260E-04, 1.270E-04, 1.280E-04, 1.289E-04, 1.300E-04, 1.315E-04, 1.330E-04, 1.340E-04,
                    1.350E-04, 1.364E-04, 1.380E-04, 1.396E-04, 1.410E-04, 1.424E-04, 1.440E-04, 1.459E-04, 1.480E-04, 1.499E-04,
                    1.520E-04, 1.544E-04, 1.570E-04, 1.596E-04, 1.620E-04, 1.643E-04, 1.670E-04, 1.704E-04, 1.740E-04, 1.775E-04,
                    1.810E-04, 1.849E-04, 1.890E-04, 1.934E-04, 1.980E-04, 2.031E-04, 2.090E-04, 2.158E-04, 2.230E-04, 2.303E-04,
                    2.380E-04, 2.463E-04, 2.550E-04, 2.640E-04, 2.730E-04, 2.819E-04, 2.910E-04, 3.004E-04, 3.100E-04, 3.194E-04,
                    3.290E-04, 3.390E-04, 3.490E-04, 3.588E-04, 3.680E-04, 3.767E-04, 3.860E-04, 3.962E-04, 4.040E-04, 4.069E-04,
                    4.090E-04, 4.138E-04, 4.160E-04, 4.112E-04, 4.090E-04, 4.176E-04, 4.270E-04, 4.268E-04, 4.230E-04, 4.237E-04,
                    4.290E-04, 4.371E-04, 4.450E-04, 4.506E-04, 4.560E-04, 4.631E-04, 4.700E-04, 4.748E-04, 4.800E-04, 4.879E-04,
                    4.950E-04, 4.983E-04, 5.030E-04, 5.141E-04, 5.270E-04, 5.363E-04, 5.440E-04, 5.532E-04, 5.640E-04, 5.759E-04,
                    5.880E-04, 5.998E-04, 6.110E-04, 6.215E-04, 6.310E-04, 6.391E-04, 6.460E-04, 6.520E-04, 6.580E-04, 6.647E-04,
                    6.720E-04, 6.793E-04, 6.860E-04, 6.920E-04, 6.990E-04, 7.084E-04, 7.180E-04, 7.257E-04, 7.340E-04, 7.455E-04,
                    7.590E-04, 7.729E-04, 7.870E-04, 8.020E-04, 8.190E-04, 8.386E-04, 8.580E-04, 8.754E-04, 8.960E-04, 9.238E-04,
                    9.520E-04, 9.745E-04, 1.000E-03, 1.037E-03, 1.079E-03, 1.119E-03, 1.159E-03, 1.204E-03, 1.253E-03, 1.304E-03,
                    1.356E-03, 1.408E-03, 1.459E-03, 1.510E-03, 1.567E-03, 1.635E-03, 1.700E-03, 1.758E-03, 1.860E-03, 2.042E-03,
                    2.224E-03, 2.323E-03, 2.366E-03, 2.400E-03, 2.448E-03, 2.519E-03, 2.587E-03, 2.629E-03, 2.653E-03, 2.674E-03,
                    2.691E-03, 2.704E-03, 2.715E-03, 2.727E-03, 2.740E-03, 2.753E-03, 2.764E-03, 2.775E-03, 2.785E-03, 2.797E-03,
                    2.810E-03, 2.824E-03, 2.839E-03, 2.854E-03, 2.868E-03, 2.881E-03, 2.893E-03, 2.907E-03, 2.922E-03, 2.938E-03,
                    2.955E-03, 2.972E-03, 2.988E-03, 3.000E-03, 3.011E-03, 3.023E-03, 3.038E-03, 3.057E-03, 3.076E-03, 3.094E-03,
                    3.111E-03, 3.127E-03, 3.144E-03, 3.162E-03, 3.181E-03, 3.202E-03, 3.223E-03, 3.242E-03, 3.263E-03, 3.289E-03,
                    3.315E-03, 3.338E-03, 3.362E-03, 3.390E-03, 3.423E-03, 3.461E-03, 3.508E-03, 3.567E-03, 3.636E-03, 3.712E-03,
                    3.791E-03, 3.866E-03, 3.931E-03, 3.981E-03, 4.019E-03, 4.049E-03, 4.072E-03, 4.087E-03, 4.098E-03, 4.109E-03,
                    4.122E-03, 4.137E-03, 4.150E-03, 4.160E-03, 4.173E-03, 4.196E-03, 4.223E-03, 4.248E-03, 4.270E-03, 4.293E-03,
                    4.318E-03, 4.347E-03, 4.381E-03, 4.418E-03, 4.458E-03, 4.500E-03, 4.545E-03, 4.594E-03, 4.646E-03, 4.701E-03,
                    4.760E-03, 4.827E-03, 4.903E-03, 4.986E-03, 5.071E-03, 5.154E-03, 5.244E-03, 5.351E-03, 5.470E-03, 5.594E-03,
                    5.722E-03, 5.855E-03, 5.995E-03, 6.146E-03, 6.303E-03, 6.463E-03, 6.628E-03, 6.804E-03, 6.993E-03, 7.197E-03,
                    7.415E-03, 7.647E-03, 7.893E-03, 8.157E-03, 8.445E-03, 8.763E-03, 9.109E-03, 9.479E-03, 9.871E-03, 1.029E-02,
                    1.072E-02, 1.119E-02, 1.168E-02, 1.218E-02, 1.268E-02, 1.319E-02, 1.372E-02, 1.428E-02, 1.487E-02, 1.551E-02,
                    1.621E-02, 1.699E-02, 1.787E-02, 1.886E-02, 1.992E-02, 2.101E-02, 2.207E-02, 2.306E-02, 2.394E-02, 2.469E-02,
                    2.532E-02, 2.583E-02, 2.623E-02, 2.652E-02, 2.672E-02, 2.689E-02, 2.702E-02, 2.713E-02, 2.722E-02, 2.728E-02,
                    2.733E-02, 2.738E-02, 2.741E-02, 2.745E-02, 2.748E-02, 2.751E-02, 2.754E-02, 2.758E-02, 2.763E-02, 2.767E-02,
                    2.771E-02, 2.773E-02, 2.773E-02, 2.774E-02, 2.774E-02, 2.773E-02, 2.770E-02, 2.766E-02, 2.761E-02, 2.757E-02,
                    2.754E-02, 2.752E-02, 2.748E-02, 2.741E-02, 2.731E-02, 2.720E-02, 2.710E-02, 2.701E-02, 2.690E-02, 2.675E-02,
                    2.659E-02, 2.645E-02, 2.633E-02, 2.624E-02, 2.613E-02, 2.593E-02, 2.558E-02, 2.523E-02, 2.513E-02, 2.501E-02,
                    2.466E-02, 2.447E-02, 2.412E-02, 2.389E-02, 2.374E-02, 2.355E-02, 2.337E-02, 2.318E-02, 2.304E-02, 2.281E-02,
                    2.246E-02, 2.243E-02, 2.238E-02, 2.222E-02, 2.204E-02, 2.201E-02, 2.204E-02, 2.196E-02, 2.177E-02, 2.190E-02,
                    2.188E-02, 2.188E-02, 2.198E-02, 2.210E-02, 2.223E-02, 2.233E-02, 2.248E-02, 2.276E-02, 2.304E-02, 2.311E-02,
                    2.329E-02, 2.388E-02, 2.446E-02, 2.475E-02, 2.516E-02, 2.620E-02, 2.769E-02, 2.830E-02, 2.914E-02, 3.108E-02,
                    3.214E-02, 3.297E-02, 3.459E-02, 3.606E-02, 3.662E-02, 3.702E-02, 3.788E-02, 3.829E-02, 3.854E-02, 3.909E-02,
                    3.949E-02, 3.972E-02, 4.000E-02, 4.040E-02, 4.057E-02, 4.075E-02, 4.115E-02, 4.127E-02, 4.149E-02, 4.204E-02,
                    4.199E-02, 4.223E-02, 4.254E-02, 4.272E-02, 4.280E-02, 4.306E-02, 4.360E-02, 4.369E-02, 4.379E-02, 4.433E-02,
                    4.454E-02, 4.466E-02, 4.505E-02, 4.527E-02, 4.552E-02, 4.605E-02, 4.658E-02, 4.691E-02, 4.705E-02, 4.713E-02,
                    4.752E-02, 4.833E-02, 4.867E-02, 4.894E-02, 4.960E-02, 5.006E-02, 5.050E-02, 5.115E-02, 5.153E-02, 5.204E-02,
                    5.298E-02, 5.346E-02, 5.386E-02, 5.465E-02, 5.528E-02, 5.566E-02, 5.596E-02, 5.653E-02, 5.745E-02, 5.789E-02,
                    5.831E-02, 5.924E-02, 5.982E-02, 6.009E-02, 6.035E-02, 6.094E-02, 6.185E-02, 6.226E-02, 6.269E-02, 6.360E-02,
                    6.407E-02, 6.458E-02, 6.562E-02, 6.636E-02, 6.672E-02, 6.699E-02, 6.769E-02, 6.900E-02, 6.989E-02, 7.037E-02,
                    7.085E-02, 7.187E-02, 7.358E-02, 7.486E-02, 7.562E-02, 7.630E-02, 7.792E-02, 8.085E-02, 8.292E-02, 8.410E-02,
                    8.528E-02, 8.801E-02, 9.268E-02, 9.584E-02, 9.819E-02, 1.012E-01, 1.042E-01, 1.066E-01, 1.113E-01, 1.194E-01,
                    1.246E-01, 1.281E-01, 1.327E-01, 1.374E-01, 1.410E-01, 1.465E-01, 1.557E-01, 1.635E-01, 1.688E-01, 1.732E-01,
                    1.818E-01, 1.963E-01, 2.050E-01, 2.106E-01, 2.187E-01, 2.287E-01, 2.386E-01, 2.468E-01, 2.542E-01, 2.701E-01,
                    2.976E-01, 3.153E-01, 3.274E-01, 3.438E-01, 3.622E-01, 3.785E-01, 3.930E-01, 4.068E-01, 4.184E-01, 4.273E-01,
                    4.385E-01, 4.538E-01, 4.611E-01, 4.633E-01, 4.663E-01, 4.701E-01, 4.733E-01, 4.756E-01, 4.772E-01, 4.785E-01,
                    4.800E-01, 4.814E-01, 4.827E-01, 4.843E-01, 4.864E-01, 4.870E-01, 4.867E-01, 4.864E-01, 4.857E-01, 4.841E-01,
                    4.821E-01, 4.804E-01, 4.786E-01, 4.764E-01, 4.738E-01, 4.710E-01, 4.677E-01, 4.641E-01, 4.604E-01, 4.570E-01,
                    4.532E-01, 4.482E-01, 4.434E-01, 4.397E-01, 4.362E-01, 4.316E-01, 4.265E-01, 4.215E-01, 4.168E-01, 4.121E-01,
                    4.072E-01, 4.017E-01, 3.963E-01, 3.915E-01, 3.868E-01, 3.816E-01, 3.760E-01, 3.701E-01, 3.640E-01, 3.581E-01,
                    3.521E-01, 3.461E-01, 3.402E-01, 3.349E-01, 3.297E-01, 3.243E-01, 3.191E-01, 3.141E-01, 3.086E-01, 3.022E-01,
                    2.957E-01, 2.897E-01, 2.840E-01, 2.782E-01, 2.724E-01, 2.672E-01, 2.621E-01, 2.566E-01, 2.506E-01, 2.444E-01,
                    2.391E-01, 2.357E-01, 2.331E-01, 2.299E-01, 2.251E-01, 2.198E-01, 2.151E-01, 2.109E-01, 2.064E-01, 2.020E-01,
                    1.981E-01, 1.944E-01, 1.904E-01, 1.868E-01, 1.841E-01, 1.818E-01, 1.790E-01, 1.752E-01, 1.715E-01, 1.687E-01,
                    1.664E-01, 1.639E-01, 1.613E-01, 1.586E-01, 1.562E-01, 1.545E-01, 1.532E-01, 1.522E-01, 1.510E-01, 1.495E-01,
                    1.475E-01, 1.457E-01, 1.447E-01, 1.442E-01, 1.438E-01, 1.433E-01, 1.426E-01, 1.418E-01, 1.412E-01, 1.410E-01,
                    1.409E-01, 1.408E-01, 1.406E-01, 1.405E-01, 1.408E-01, 1.414E-01, 1.426E-01, 1.435E-01, 1.438E-01, 1.439E-01,
                    1.443E-01, 1.456E-01, 1.475E-01, 1.498E-01, 1.519E-01, 1.534E-01, 1.547E-01, 1.561E-01, 1.580E-01, 1.604E-01,
                    1.632E-01, 1.659E-01, 1.677E-01, 1.693E-01, 1.712E-01, 1.739E-01, 1.777E-01, 1.824E-01, 1.866E-01, 1.890E-01,
                    1.906E-01, 1.929E-01, 1.967E-01, 2.005E-01, 2.031E-01, 2.051E-01, 2.079E-01, 2.123E-01, 2.166E-01, 2.196E-01,
                    2.219E-01, 2.251E-01, 2.298E-01, 2.337E-01, 2.346E-01, 2.342E-01, 2.353E-01, 2.397E-01, 2.450E-01, 2.491E-01,
                    2.528E-01, 2.578E-01, 2.650E-01, 2.719E-01, 2.765E-01, 2.811E-01, 2.891E-01, 3.023E-01, 3.164E-01, 3.271E-01,
                    3.378E-01, 3.533E-01, 3.770E-01, 4.037E-01, 4.281E-01, 4.502E-01, 4.712E-01, 4.932E-01, 5.202E-01, 5.572E-01,
                    6.052E-01, 6.520E-01, 6.863E-01, 7.159E-01, 7.535E-01, 8.064E-01, 8.597E-01, 8.981E-01, 9.253E-01, 9.493E-01,
                    9.769E-01, 1.008E+00, 1.041E+00, 1.073E+00, 1.100E+00, 1.119E+00, 1.131E+00, 1.140E+00, 1.150E+00, 1.160E+00,
                    1.170E+00, 1.181E+00, 1.190E+00, 1.194E+00, 1.196E+00, 1.197E+00, 1.200E+00, 1.203E+00, 1.205E+00, 1.206E+00,
                    1.207E+00, 1.213E+00, 1.223E+00, 1.232E+00, 1.234E+00, 1.232E+00, 1.229E+00, 1.230E+00, 1.233E+00, 1.236E+00,
                    1.239E+00, 1.241E+00, 1.244E+00, 1.248E+00, 1.252E+00, 1.256E+00, 1.258E+00, 1.260E+00, 1.262E+00, 1.265E+00,
                    1.267E+00, 1.270E+00, 1.272E+00, 1.275E+00, 1.277E+00, 1.280E+00, 1.282E+00, 1.283E+00, 1.283E+00, 1.279E+00,
                    1.272E+00, 1.266E+00, 1.267E+00, 1.271E+00, 1.273E+00, 1.271E+00, 1.265E+00, 1.260E+00, 1.258E+00, 1.258E+00,
                    1.257E+00, 1.252E+00, 1.247E+00, 1.243E+00, 1.243E+00, 1.243E+00, 1.240E+00, 1.233E+00, 1.224E+00, 1.216E+00,
                    1.214E+00, 1.214E+00, 1.213E+00, 1.210E+00, 1.205E+00, 1.200E+00, 1.199E+00, 1.198E+00, 1.197E+00, 1.194E+00,
                    1.189E+00, 1.184E+00, 1.180E+00, 1.176E+00, 1.171E+00, 1.166E+00, 1.161E+00, 1.158E+00, 1.157E+00, 1.157E+00,
                    1.155E+00, 1.152E+00, 1.148E+00, 1.142E+00, 1.138E+00, 1.133E+00, 1.130E+00, 1.126E+00, 1.123E+00, 1.120E+00,
                    1.116E+00, 1.111E+00, 1.107E+00, 1.103E+00, 1.101E+00, 1.101E+00, 1.101E+00, 1.101E+00, 1.100E+00, 1.098E+00,
                    1.094E+00, 1.089E+00, 1.085E+00, 1.084E+00, 1.083E+00, 1.083E+00, 1.082E+00, 1.081E+00, 1.080E+00, 1.079E+00,
                    1.080E+00, 1.083E+00, 1.087E+00, 1.093E+00, 1.099E+00, 1.104E+00, 1.107E+00, 1.109E+00, 1.111E+00, 1.115E+00,
                    1.121E+00, 1.129E+00, 1.137E+00, 1.147E+00, 1.156E+00, 1.164E+00, 1.170E+00, 1.175E+00, 1.181E+00, 1.188E+00,
                    1.196E+00, 1.206E+00, 1.216E+00, 1.227E+00, 1.239E+00, 1.252E+00, 1.267E+00, 1.283E+00, 1.297E+00, 1.310E+00,
                    1.323E+00, 1.336E+00, 1.351E+00, 1.370E+00, 1.392E+00, 1.416E+00, 1.440E+00, 1.465E+00, 1.489E+00, 1.511E+00,
                    1.532E+00, 1.555E+00, 1.580E+00, 1.610E+00, 1.642E+00, 1.672E+00, 1.701E+00, 1.728E+00, 1.758E+00, 1.791E+00,
                    1.831E+00, 1.872E+00, 1.911E+00, 1.943E+00, 1.974E+00, 2.007E+00, 2.047E+00, 2.098E+00, 2.153E+00, 2.203E+00,
                    2.243E+00, 2.277E+00, 2.312E+00, 2.357E+00, 2.415E+00, 2.479E+00, 2.540E+00, 2.590E+00, 2.631E+00, 2.666E+00,
                    2.701E+00, 2.738E+00, 2.780E+00, 2.829E+00, 2.889E+00, 2.960E+00, 3.033E+00, 3.097E+00, 3.146E+00, 3.181E+00,
                    3.226E+00, 3.267E+00, 3.319E+00, 3.363E+00, 3.412E+00, 3.449E+00, 3.504E+00, 3.544E+00, 3.600E+00, 3.648E+00,
                    3.701E+00, 3.752E+00, 3.802E+00, 3.871E+00, 3.927E+00, 3.985E+00, 4.064E+00, 4.125E+00, 4.216E+00, 4.302E+00,
                    4.389E+00, 4.504E+00, 4.630E+00, 4.737E+00, 4.904E+00, 5.092E+00, 5.260E+00, 5.479E+00, 5.720E+00, 6.006E+00,
                    6.242E+00, 6.580E+00, 6.927E+00, 7.313E+00, 7.633E+00, 8.089E+00, 8.545E+00, 9.030E+00, 9.591E+00, 1.002E+01,
                    1.063E+01, 1.122E+01, 1.184E+01, 1.245E+01, 1.316E+01, 1.369E+01, 1.434E+01, 1.509E+01, 1.578E+01, 1.646E+01,
                    1.714E+01, 1.781E+01, 1.854E+01, 1.919E+01, 1.980E+01, 2.029E+01, 2.089E+01, 2.146E+01, 2.202E+01, 2.260E+01,
                    2.313E+01, 2.360E+01, 2.407E+01, 2.450E+01, 2.493E+01, 2.533E+01, 2.571E+01, 2.606E+01, 2.641E+01, 2.673E+01,
                    2.701E+01, 2.729E+01, 2.756E+01, 2.782E+01, 2.806E+01, 2.835E+01, 2.856E+01, 2.875E+01, 2.892E+01, 2.908E+01,
                    2.926E+01, 2.940E+01, 2.956E+01, 2.966E+01, 2.982E+01, 2.993E+01, 3.003E+01, 3.014E+01, 3.023E+01, 3.029E+01,
                    3.036E+01, 3.042E+01, 3.046E+01, 3.049E+01, 3.052E+01, 3.053E+01, 3.055E+01, 3.056E+01, 3.056E+01, 3.055E+01,
                    3.054E+01, 3.051E+01, 3.049E+01, 3.045E+01, 3.041E+01, 3.035E+01, 3.029E+01, 3.023E+01, 3.014E+01, 3.006E+01,
                    2.998E+01, 2.983E+01, 2.971E+01, 2.957E+01, 2.936E+01, 2.917E+01, 2.899E+01, 2.872E+01, 2.851E+01, 2.829E+01,
                    2.800E+01, 2.777E+01, 2.754E+01, 2.722E+01, 2.699E+01, 2.664E+01, 2.638E+01, 2.611E+01, 2.581E+01, 2.555E+01,
                    2.522E+01, 2.497E+01, 2.468E+01, 2.443E+01, 2.413E+01, 2.388E+01, 2.364E+01, 2.332E+01, 2.307E+01, 2.274E+01,
                    2.250E+01, 2.218E+01, 2.193E+01, 2.163E+01, 2.139E+01, 2.107E+01, 2.082E+01, 2.052E+01, 2.025E+01, 2.001E+01,
                    1.972E+01, 1.951E+01, 1.924E+01, 1.900E+01, 1.874E+01, 1.847E+01, 1.827E+01, 1.802E+01, 1.784E+01, 1.758E+01,
                    1.734E+01, 1.712E+01, 1.688E+01, 1.671E+01, 1.647E+01, 1.623E+01, 1.606E+01, 1.583E+01, 1.562E+01, 1.545E+01,
                    1.525E+01, 1.504E+01, 1.489E+01, 1.468E+01, 1.447E+01, 1.432E+01, 1.413E+01, 1.395E+01, 1.381E+01, 1.364E+01,
                    1.348E+01, 1.329E+01, 1.316E+01, 1.298E+01, 1.282E+01, 1.265E+01, 1.254E+01, 1.238E+01, 1.223E+01, 1.206E+01,
                    1.193E+01, 1.181E+01, 1.166E+01, 1.152E+01, 1.137E+01, 1.126E+01, 1.114E+01, 1.100E+01, 1.088E+01, 1.075E+01,
                    1.064E+01, 1.054E+01, 1.044E+01, 1.032E+01, 1.022E+01, 1.011E+01, 1.001E+01, 9.912E+00, 9.839E+00, 9.754E+00,
                    9.660E+00, 9.563E+00, 9.477E+00, 9.383E+00, 9.305E+00, 9.202E+00, 9.133E+00, 9.047E+00, 8.977E+00, 8.898E+00,
                    8.820E+00, 8.742E+00, 8.665E+00, 8.588E+00, 8.509E+00, 8.448E+00, 8.364E+00, 8.295E+00, 8.234E+00, 8.157E+00,
                    8.104E+00, 8.036E+00, 7.959E+00, 7.890E+00, 7.834E+00, 7.773E+00, 7.712E+00, 7.654E+00, 7.609E+00, 7.548E+00,
                    7.495E+00, 7.432E+00, 7.374E+00, 7.315E+00, 7.252E+00, 7.203E+00, 7.164E+00, 7.124E+00, 7.084E+00, 7.041E+00,
                    6.987E+00, 6.943E+00, 6.910E+00, 6.865E+00, 6.828E+00, 6.776E+00, 6.742E+00, 6.714E+00, 6.695E+00, 6.654E+00,
                    6.630E+00, 6.599E+00, 6.567E+00, 6.526E+00, 6.501E+00, 6.474E+00, 6.449E+00, 6.420E+00, 6.401E+00, 6.363E+00,
                    6.345E+00, 6.309E+00, 6.282E+00, 6.250E+00, 6.214E+00, 6.186E+00, 6.163E+00, 6.130E+00, 6.121E+00, 6.091E+00,
                    6.076E+00, 6.053E+00, 6.048E+00, 6.016E+00, 6.005E+00, 5.982E+00, 5.973E+00, 5.947E+00, 5.940E+00, 5.919E+00,
                    5.911E+00, 5.887E+00, 5.875E+00, 5.846E+00, 5.826E+00, 5.798E+00, 5.787E+00, 5.751E+00, 5.746E+00, 5.718E+00,
                    5.705E+00, 5.685E+00, 5.684E+00, 5.657E+00, 5.658E+00, 5.644E+00, 5.648E+00, 5.626E+00, 5.626E+00, 5.619E+00,
                    5.618E+00, 5.603E+00, 5.614E+00, 5.597E+00, 5.603E+00, 5.582E+00, 5.584E+00, 5.564E+00, 5.563E+00, 5.547E+00,
                    5.545E+00, 5.536E+00, 5.542E+00, 5.529E+00, 5.532E+00, 5.525E+00, 5.533E+00, 5.528E+00, 5.529E+00, 5.516E+00,
                    5.524E+00, 5.516E+00, 5.526E+00, 5.520E+00, 5.520E+00, 5.516E+00, 5.522E+00, 5.511E+00, 5.527E+00, 5.511E+00,
                    5.519E+00, 5.515E+00, 5.520E+00, 5.510E+00, 5.518E+00, 5.523E+00, 5.538E+00, 5.535E+00, 5.544E+00, 5.557E+00,
                    5.571E+00, 5.583E+00, 5.606E+00, 5.607E+00, 5.629E+00, 5.636E+00, 5.664E+00, 5.670E+00, 5.693E+00, 5.702E+00,
                    5.733E+00, 5.752E+00, 5.766E+00, 5.776E+00, 5.797E+00, 5.811E+00, 5.829E+00, 5.842E+00, 5.877E+00, 5.891E+00,
                    5.930E+00, 5.945E+00, 5.972E+00, 5.999E+00, 6.025E+00, 6.051E+00, 6.087E+00, 6.096E+00, 6.136E+00, 6.166E+00,
                    6.198E+00, 6.219E+00, 6.256E+00, 6.284E+00, 6.335E+00, 6.369E+00, 6.392E+00, 6.445E+00, 6.493E+00, 6.517E+00,
                    6.571E+00, 6.617E+00, 6.658E+00, 6.689E+00, 6.748E+00, 6.796E+00, 6.842E+00, 6.897E+00, 6.955E+00, 7.003E+00,
                    7.054E+00, 7.111E+00, 7.179E+00, 7.235E+00, 7.274E+00, 7.339E+00, 7.414E+00, 7.481E+00, 7.536E+00, 7.594E+00,
                    7.669E+00, 7.734E+00, 7.776E+00, 7.833E+00, 7.893E+00, 7.952E+00, 8.000E+00, 8.045E+00, 8.103E+00, 8.155E+00,
                    8.205E+00, 8.241E+00, 8.264E+00, 8.321E+00, 8.352E+00, 8.394E+00, 8.430E+00, 8.448E+00, 8.477E+00, 8.512E+00,
                    8.535E+00, 8.562E+00, 8.593E+00, 8.618E+00, 8.640E+00, 8.670E+00, 8.689E+00, 8.720E+00, 8.738E+00, 8.755E+00,
                    8.777E+00, 8.778E+00, 8.778E+00, 8.794E+00, 8.805E+00, 8.807E+00, 8.809E+00, 8.811E+00, 8.799E+00, 8.795E+00,
                    8.789E+00, 8.779E+00, 8.767E+00, 8.754E+00, 8.750E+00, 8.738E+00, 8.739E+00, 8.735E+00, 8.744E+00, 8.753E+00,
                    8.755E+00, 8.780E+00, 8.787E+00, 8.790E+00, 8.798E+00, 8.794E+00, 8.811E+00, 8.820E+00, 8.836E+00, 8.845E+00,
                    8.854E+00, 8.858E+00, 8.868E+00, 8.869E+00, 8.884E+00, 8.888E+00, 8.900E+00, 8.922E+00, 8.951E+00, 8.973E+00,
                    9.010E+00, 9.034E+00, 9.110E+00, 9.146E+00, 9.195E+00, 9.259E+00, 9.315E+00, 9.380E+00, 9.457E+00, 9.535E+00,
                    9.633E+00, 9.723E+00, 9.824E+00, 9.935E+00, 1.005E+01, 1.018E+01, 1.031E+01, 1.042E+01, 1.059E+01, 1.075E+01,
                    1.094E+01, 1.110E+01, 1.139E+01, 1.160E+01, 1.184E+01, 1.208E+01, 1.235E+01, 1.266E+01, 1.301E+01, 1.334E+01,
                    1.375E+01, 1.412E+01, 1.478E+01, 1.529E+01, 1.586E+01, 1.641E+01, 1.709E+01, 1.774E+01, 1.853E+01, 1.925E+01,
                    2.051E+01, 2.148E+01, 2.250E+01, 2.367E+01, 2.483E+01, 2.622E+01, 2.751E+01, 2.972E+01, 3.144E+01, 3.317E+01,
                    3.504E+01, 3.725E+01, 3.927E+01, 4.269E+01, 4.530E+01, 4.789E+01, 5.060E+01, 5.360E+01, 5.761E+01, 6.088E+01,
                    6.401E+01, 6.720E+01, 7.059E+01, 7.497E+01, 7.841E+01, 8.157E+01, 8.469E+01, 8.752E+01, 9.189E+01, 9.456E+01,
                    9.722E+01, 9.995E+01, 1.033E+02, 1.057E+02, 1.078E+02, 1.097E+02, 1.123E+02, 1.140E+02, 1.157E+02, 1.171E+02,
                    1.190E+02, 1.203E+02, 1.215E+02, 1.226E+02, 1.240E+02, 1.248E+02, 1.257E+02, 1.265E+02, 1.275E+02, 1.281E+02,
                    1.286E+02, 1.292E+02, 1.296E+02, 1.299E+02, 1.303E+02, 1.304E+02, 1.306E+02, 1.306E+02, 1.306E+02, 1.305E+02,
                    1.304E+02, 1.301E+02, 1.299E+02, 1.296E+02, 1.291E+02, 1.287E+02, 1.282E+02, 1.275E+02, 1.270E+02, 1.264E+02,
                    1.256E+02, 1.249E+02, 1.242E+02, 1.232E+02, 1.224E+02, 1.216E+02, 1.206E+02, 1.197E+02, 1.190E+02, 1.178E+02,
                    1.170E+02, 1.157E+02, 1.149E+02, 1.140E+02, 1.128E+02, 1.118E+02, 1.110E+02, 1.097E+02, 1.088E+02, 1.076E+02,
                    1.066E+02, 1.058E+02, 1.044E+02, 1.036E+02, 1.023E+02, 1.014E+02, 1.005E+02, 9.928E+01, 9.831E+01, 9.711E+01,
                    9.631E+01, 9.488E+01, 9.412E+01, 9.341E+01, 9.206E+01, 9.121E+01, 9.009E+01, 8.929E+01, 8.804E+01, 8.725E+01,
                    8.611E+01, 8.532E+01, 8.460E+01, 8.336E+01, 8.262E+01, 8.151E+01, 8.076E+01, 7.973E+01, 7.904E+01, 7.800E+01,
                    7.723E+01, 7.628E+01, 7.557E+01, 7.463E+01, 7.392E+01, 7.298E+01, 7.234E+01, 7.141E+01, 7.082E+01, 6.986E+01,
                    6.924E+01, 6.865E+01, 6.779E+01, 6.688E+01, 6.634E+01, 6.548E+01, 6.490E+01, 6.412E+01, 6.358E+01, 6.281E+01,
                    6.232E+01, 6.156E+01, 6.105E+01, 6.029E+01, 5.980E+01, 5.907E+01, 5.857E+01, 5.788E+01, 5.746E+01, 5.680E+01,
                    5.632E+01, 5.566E+01, 5.503E+01, 5.463E+01, 5.398E+01, 5.356E+01, 5.294E+01, 5.256E+01, 5.197E+01, 5.138E+01,
                    5.098E+01, 5.047E+01, 5.006E+01, 4.951E+01, 4.915E+01, 4.860E+01, 4.806E+01, 4.773E+01, 4.718E+01, 4.685E+01,
                    4.635E+01, 4.584E+01, 4.553E+01, 4.503E+01, 4.473E+01, 4.426E+01, 4.379E+01, 4.348E+01, 4.302E+01, 4.273E+01,
                    4.228E+01, 4.186E+01, 4.155E+01, 4.115E+01, 4.072E+01, 4.046E+01, 4.002E+01, 3.975E+01, 3.934E+01, 3.894E+01,
                    3.868E+01, 3.827E+01, 3.790E+01, 3.762E+01, 3.726E+01, 3.687E+01, 3.664E+01, 3.628E+01, 3.592E+01, 3.568E+01,
                    3.536E+01, 3.499E+01, 3.479E+01, 3.447E+01, 3.413E+01, 3.392E+01, 3.363E+01, 3.329E+01, 3.309E+01, 3.280E+01,
                    3.251E+01, 3.231E+01, 3.200E+01, 3.172E+01, 3.154E+01, 3.127E+01, 3.097E+01, 3.071E+01, 3.052E+01, 3.025E+01,
                    2.999E+01, 2.980E+01, 2.958E+01, 2.929E+01, 2.906E+01, 2.888E+01, 2.865E+01, 2.840E+01, 2.822E+01, 2.799E+01,
                    2.776E+01, 2.751E+01, 2.737E+01, 2.713E+01, 2.692E+01, 2.671E+01, 2.657E+01, 2.637E+01, 2.617E+01, 2.597E+01,
                    2.584E+01, 2.565E+01, 2.547E+01, 2.528E+01, 2.518E+01, 2.501E+01, 2.485E+01, 2.466E+01, 2.455E+01, 2.438E+01,
                    2.420E+01, 2.401E+01, 2.386E+01, 2.374E+01, 2.358E+01, 2.342E+01, 2.328E+01, 2.318E+01, 2.304E+01, 2.289E+01,
                    2.275E+01, 2.262E+01, 2.252E+01, 2.239E+01, 2.227E+01, 2.214E+01, 2.202E+01, 2.194E+01, 2.183E+01, 2.172E+01,
                    2.162E+01, 2.150E+01, 2.140E+01, 2.133E+01, 2.123E+01, 2.112E+01, 2.102E+01, 2.091E+01, 2.085E+01, 2.077E+01,
                    2.067E+01, 2.058E+01, 2.049E+01, 2.040E+01, 2.033E+01, 2.027E+01, 2.018E+01, 2.010E+01, 2.002E+01, 1.995E+01,
                    1.987E+01, 1.983E+01, 1.976E+01, 1.969E+01, 1.963E+01, 1.958E+01, 1.952E+01, 1.946E+01, 1.942E+01, 1.938E+01,
                    1.933E+01, 1.928E+01, 1.923E+01, 1.918E+01, 1.913E+01, 1.909E+01, 1.904E+01, 1.900E+01, 1.896E+01, 1.889E+01,
                    1.884E+01, 1.880E+01, 1.874E+01, 1.870E+01, 1.866E+01, 1.860E+01, 1.856E+01, 1.852E+01, 1.849E+01, 1.845E+01,
                    1.843E+01, 1.839E+01, 1.837E+01, 1.837E+01, 1.838E+01, 1.837E+01, 1.836E+01, 1.835E+01, 1.835E+01, 1.835E+01,
                    1.834E+01, 1.833E+01, 1.833E+01, 1.833E+01, 1.834E+01, 1.833E+01, 1.834E+01, 1.834E+01, 1.832E+01, 1.831E+01,
                    1.829E+01, 1.828E+01, 1.828E+01, 1.829E+01, 1.829E+01, 1.830E+01, 1.832E+01, 1.835E+01, 1.836E+01, 1.837E+01,
                    1.837E+01, 1.838E+01, 1.837E+01, 1.840E+01, 1.842E+01, 1.843E+01, 1.846E+01, 1.849E+01, 1.851E+01, 1.854E+01,
                    1.857E+01, 1.858E+01, 1.860E+01, 1.864E+01, 1.865E+01, 1.867E+01, 1.870E+01, 1.875E+01, 1.879E+01, 1.883E+01,
                    1.888E+01, 1.893E+01, 1.897E+01, 1.903E+01, 1.908E+01, 1.913E+01, 1.919E+01, 1.924E+01, 1.929E+01, 1.934E+01,
                    1.940E+01, 1.946E+01, 1.951E+01, 1.961E+01, 1.966E+01, 1.973E+01, 1.980E+01, 1.985E+01, 1.991E+01, 1.997E+01,
                    2.004E+01, 2.013E+01, 2.020E+01, 2.027E+01, 2.038E+01, 2.046E+01, 2.054E+01, 2.062E+01, 2.071E+01, 2.079E+01,
                    2.087E+01, 2.094E+01, 2.103E+01, 2.111E+01, 2.126E+01, 2.135E+01, 2.145E+01, 2.153E+01, 2.164E+01, 2.174E+01,
                    2.183E+01, 2.192E+01, 2.202E+01, 2.212E+01, 2.223E+01, 2.234E+01, 2.245E+01, 2.264E+01, 2.276E+01, 2.287E+01,
                    2.301E+01, 2.313E+01, 2.327E+01, 2.338E+01, 2.351E+01, 2.363E+01, 2.377E+01, 2.385E+01, 2.409E+01, 2.418E+01,
                    2.433E+01, 2.444E+01, 2.459E+01, 2.470E+01, 2.485E+01, 2.495E+01, 2.523E+01, 2.534E+01, 2.549E+01, 2.564E+01,
                    2.579E+01, 2.592E+01, 2.611E+01, 2.623E+01, 2.653E+01, 2.664E+01, 2.681E+01, 2.695E+01, 2.712E+01, 2.727E+01,
                    2.744E+01, 2.756E+01, 2.789E+01, 2.802E+01, 2.819E+01, 2.838E+01, 2.855E+01, 2.869E+01, 2.903E+01, 2.916E+01,
                    2.934E+01, 2.951E+01, 2.969E+01, 2.988E+01, 3.002E+01, 3.038E+01, 3.054E+01, 3.073E+01, 3.092E+01, 3.107E+01,
                    3.145E+01, 3.160E+01, 3.180E+01, 3.199E+01, 3.219E+01, 3.238E+01, 3.272E+01, 3.290E+01, 3.311E+01, 3.331E+01,
                    3.348E+01, 3.388E+01, 3.404E+01, 3.426E+01, 3.447E+01, 3.468E+01, 3.486E+01, 3.528E+01, 3.547E+01, 3.570E+01,
                    3.592E+01, 3.610E+01, 3.656E+01, 3.675E+01, 3.697E+01, 3.716E+01, 3.761E+01, 3.777E+01, 3.801E+01, 3.827E+01,
                    3.848E+01, 3.892E+01, 3.913E+01, 3.938E+01, 3.957E+01, 4.007E+01, 4.024E+01, 4.050E+01, 4.078E+01, 4.096E+01,
                    4.147E+01, 4.167E+01, 4.196E+01, 4.220E+01, 4.268E+01, 4.293E+01, 4.319E+01, 4.342E+01, 4.388E+01, 4.413E+01,
                    4.439E+01, 4.464E+01, 4.513E+01, 4.538E+01, 4.565E+01, 4.590E+01, 4.638E+01, 4.663E+01, 4.690E+01, 4.714E+01,
                    4.764E+01, 4.787E+01, 4.817E+01, 4.836E+01, 4.894E+01, 4.917E+01, 4.940E+01, 4.997E+01, 5.021E+01, 5.050E+01,
                    5.078E+01, 5.131E+01, 5.159E+01, 5.191E+01, 5.246E+01, 5.275E+01, 5.310E+01, 5.339E+01, 5.401E+01, 5.429E+01,
                    5.462E+01, 5.523E+01, 5.555E+01, 5.588E+01, 5.618E+01, 5.686E+01, 5.713E+01, 5.746E+01, 5.808E+01, 5.841E+01,
                    5.878E+01, 5.946E+01, 5.976E+01, 6.009E+01, 6.039E+01, 6.107E+01, 6.146E+01, 6.180E+01, 6.250E+01, 6.286E+01,
                    6.316E+01, 6.392E+01, 6.427E+01, 6.462E+01, 6.539E+01, 6.574E+01, 6.609E+01, 6.685E+01, 6.725E+01, 6.759E+01,
                    6.842E+01, 6.881E+01, 6.918E+01, 7.009E+01, 7.046E+01, 7.084E+01, 7.174E+01, 7.212E+01, 7.249E+01, 7.340E+01,
                    7.381E+01, 7.423E+01, 7.514E+01, 7.554E+01, 7.591E+01, 7.675E+01, 7.718E+01, 7.801E+01, 7.839E+01, 7.880E+01,
                    7.970E+01, 8.005E+01, 8.046E+01, 8.136E+01, 8.173E+01, 8.215E+01, 8.295E+01, 8.338E+01, 8.423E+01, 8.474E+01,
                    8.510E+01, 8.584E+01, 8.617E+01, 8.637E+01, 8.708E+01, 8.762E+01, 8.884E+01, 8.904E+01, 8.945E+01, 9.055E+01,
                    9.089E+01, 9.134E+01, 9.204E+01, 9.244E+01, 9.308E+01, 9.333E+01, 9.358E+01, 9.416E+01, 9.448E+01, 9.499E+01,
                    9.530E+01])

PD_k_Cm = np.array([1.097E+02, 1.037E+02, 9.798E+01, 9.244E+01, 8.713E+01, 8.231E+01, 7.806E+01, 7.404E+01, 7.013E+01, 6.654E+01, 
                    6.300E+01, 5.954E+01, 5.616E+01, 5.301E+01, 5.001E+01, 4.723E+01, 4.463E+01, 4.220E+01, 3.996E+01, 3.780E+01,
                    3.567E+01, 3.362E+01, 3.170E+01, 2.993E+01, 2.832E+01, 2.679E+01, 2.535E+01, 2.402E+01, 2.276E+01, 2.150E+01,
                    2.024E+01, 1.901E+01, 1.785E+01, 1.676E+01, 1.575E+01, 1.481E+01, 1.392E+01, 1.312E+01, 1.233E+01, 1.161E+01,
                    1.096E+01, 1.041E+01, 9.924E+00, 9.410E+00, 8.947E+00, 8.508E+00, 8.087E+00, 7.640E+00, 7.269E+00, 6.939E+00,
                    6.660E+00, 6.422E+00, 6.222E+00, 6.010E+00, 5.782E+00, 5.573E+00, 5.370E+00, 5.173E+00, 4.946E+00, 4.761E+00,
                    4.575E+00, 4.419E+00, 4.259E+00, 4.117E+00, 4.006E+00, 3.945E+00, 3.853E+00, 3.784E+00, 3.671E+00, 3.554E+00,
                    3.462E+00, 3.364E+00, 3.282E+00, 3.184E+00, 3.102E+00, 3.051E+00, 2.983E+00, 2.947E+00, 2.913E+00, 2.869E+00,
                    2.803E+00, 2.777E+00, 2.751E+00, 2.726E+00, 2.702E+00, 2.679E+00, 2.656E+00, 2.634E+00, 2.613E+00, 2.593E+00,
                    2.573E+00, 2.554E+00, 2.536E+00, 2.519E+00, 2.502E+00, 2.486E+00, 2.471E+00, 2.457E+00, 2.443E+00, 2.430E+00,
                    2.417E+00, 2.405E+00, 2.394E+00, 2.384E+00, 2.374E+00, 2.365E+00, 2.356E+00, 2.348E+00, 2.341E+00, 2.334E+00,
                    2.328E+00, 2.323E+00, 2.318E+00, 2.314E+00, 2.310E+00, 2.307E+00, 2.304E+00, 2.303E+00, 2.301E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                    2.300E+00, 2.300E+00, 2.301E+00, 2.301E+00, 2.302E+00, 2.303E+00, 2.305E+00, 2.306E+00, 2.308E+00, 2.310E+00,
                    2.312E+00, 2.315E+00, 2.318E+00, 2.320E+00, 2.323E+00, 2.327E+00, 2.330E+00, 2.334E+00, 2.338E+00, 2.342E+00,
                    2.346E+00, 2.350E+00, 2.354E+00, 2.359E+00, 2.364E+00, 2.369E+00, 2.374E+00, 2.379E+00, 2.384E+00, 2.389E+00,
                    2.395E+00, 2.400E+00, 2.406E+00, 2.412E+00, 2.418E+00, 2.424E+00, 2.430E+00, 2.436E+00, 2.442E+00, 2.448E+00,
                    2.454E+00, 2.461E+00, 2.467E+00, 2.473E+00, 2.480E+00, 2.486E+00, 2.493E+00, 2.499E+00, 2.506E+00, 2.512E+00,
                    2.519E+00, 2.525E+00, 2.532E+00, 2.538E+00, 2.545E+00, 2.551E+00, 2.558E+00, 2.564E+00, 2.570E+00, 2.577E+00,
                    2.583E+00, 2.589E+00, 2.595E+00, 2.601E+00, 2.607E+00, 2.613E+00, 2.619E+00, 2.625E+00, 2.631E+00, 2.636E+00,
                    2.642E+00, 2.647E+00, 2.652E+00, 2.657E+00, 2.662E+00, 2.667E+00, 2.672E+00, 2.677E+00, 2.681E+00, 2.685E+00,
                    2.689E+00, 2.693E+00, 2.697E+00, 2.701E+00, 2.704E+00, 2.708E+00, 2.711E+00, 2.714E+00, 2.716E+00, 2.719E+00,
                    2.721E+00, 2.723E+00, 2.725E+00, 2.726E+00, 2.728E+00, 2.729E+00, 2.730E+00, 2.730E+00, 2.731E+00, 2.731E+00,
                    2.721E+00, 2.736E+00, 2.728E+00, 2.719E+00, 2.712E+00, 2.698E+00, 2.702E+00, 2.691E+00, 2.688E+00, 2.686E+00,
                    2.682E+00, 2.676E+00, 2.675E+00, 2.677E+00, 2.670E+00, 2.671E+00, 2.668E+00, 2.670E+00, 2.674E+00, 2.674E+00,
                    2.683E+00, 2.674E+00, 2.675E+00, 2.682E+00, 2.683E+00, 2.665E+00, 2.661E+00, 2.668E+00, 2.670E+00, 2.674E+00,
                    2.664E+00, 2.661E+00, 2.665E+00, 2.668E+00, 2.681E+00, 2.686E+00, 2.684E+00, 2.697E+00, 2.712E+00, 2.720E+00,
                    2.717E+00, 2.726E+00, 2.744E+00, 2.743E+00, 2.751E+00, 2.763E+00, 2.778E+00, 2.793E+00, 2.818E+00, 2.835E+00,
                    2.865E+00, 2.879E+00, 2.899E+00, 2.918E+00, 2.936E+00, 2.953E+00, 2.966E+00, 2.977E+00, 2.981E+00, 2.942E+00,
                    2.888E+00, 2.864E+00, 2.877E+00, 2.886E+00, 2.888E+00, 2.891E+00, 2.899E+00, 2.887E+00, 2.884E+00, 2.900E+00,
                    2.929E+00, 2.969E+00, 3.014E+00, 3.053E+00, 3.075E+00, 3.111E+00, 3.128E+00, 3.130E+00, 3.103E+00, 3.051E+00,
                    2.980E+00, 2.941E+00, 2.920E+00, 2.931E+00, 2.950E+00, 2.979E+00, 3.025E+00, 3.048E+00, 3.066E+00, 3.087E+00,
                    3.099E+00, 3.090E+00, 3.088E+00, 3.081E+00, 3.086E+00, 3.071E+00, 3.065E+00, 3.069E+00, 3.067E+00, 3.085E+00,
                    3.094E+00, 3.110E+00, 3.136E+00, 3.149E+00, 3.158E+00, 3.191E+00, 3.230E+00, 3.266E+00, 3.298E+00, 3.356E+00,
                    3.419E+00, 3.476E+00, 3.534E+00, 3.584E+00, 3.632E+00, 3.708E+00, 3.775E+00, 3.847E+00, 3.931E+00, 3.987E+00,
                    4.071E+00, 4.156E+00, 4.242E+00, 4.320E+00, 4.395E+00, 4.480E+00, 4.561E+00, 4.638E+00, 4.708E+00, 4.782E+00,
                    4.846E+00, 4.906E+00, 4.974E+00, 5.026E+00, 5.071E+00, 5.131E+00, 5.179E+00, 5.220E+00, 5.271E+00, 5.322E+00,
                    5.358E+00, 5.403E+00, 5.441E+00, 5.460E+00, 5.481E+00, 5.500E+00, 5.523E+00, 5.548E+00, 5.560E+00, 5.575E+00,
                    5.582E+00, 5.597E+00, 5.611E+00, 5.639E+00, 5.653E+00, 5.675E+00, 5.682E+00, 5.685E+00, 5.680E+00, 5.689E+00,
                    5.711E+00, 5.723E+00, 5.715E+00, 5.716E+00, 5.732E+00, 5.741E+00, 5.743E+00, 5.752E+00, 5.745E+00, 5.744E+00,
                    5.757E+00, 5.766E+00, 5.781E+00, 5.787E+00, 5.798E+00, 5.810E+00, 5.808E+00, 5.815E+00, 5.825E+00, 5.824E+00,
                    5.827E+00, 5.854E+00, 5.878E+00, 5.900E+00, 5.908E+00, 5.922E+00, 5.940E+00, 5.962E+00, 5.963E+00, 5.966E+00,
                    5.982E+00, 5.990E+00, 5.994E+00, 6.016E+00, 6.014E+00, 6.025E+00, 6.008E+00, 6.022E+00, 6.021E+00, 6.027E+00,
                    6.027E+00, 6.035E+00, 6.025E+00, 6.009E+00, 5.990E+00, 5.987E+00, 5.984E+00, 5.971E+00, 5.971E+00, 5.973E+00,
                    5.951E+00, 5.952E+00, 5.939E+00, 5.933E+00, 5.931E+00, 5.925E+00, 5.909E+00, 5.897E+00, 5.884E+00, 5.881E+00,
                    5.876E+00, 5.856E+00, 5.843E+00, 5.830E+00, 5.818E+00, 5.807E+00, 5.799E+00, 5.792E+00, 5.776E+00, 5.783E+00,
                    5.776E+00, 5.767E+00, 5.762E+00, 5.769E+00, 5.756E+00, 5.762E+00, 5.737E+00, 5.740E+00, 5.757E+00, 5.756E+00,
                    5.751E+00, 5.754E+00, 5.751E+00, 5.750E+00, 5.744E+00, 5.744E+00, 5.754E+00, 5.744E+00, 5.735E+00, 5.740E+00,
                    5.732E+00, 5.728E+00, 5.731E+00, 5.724E+00, 5.724E+00, 5.715E+00, 5.697E+00, 5.693E+00, 5.703E+00, 5.700E+00,
                    5.713E+00, 5.728E+00, 5.731E+00, 5.735E+00, 5.743E+00, 5.754E+00, 5.753E+00, 5.744E+00, 5.746E+00, 5.746E+00,
                    5.746E+00, 5.750E+00, 5.749E+00, 5.743E+00, 5.740E+00, 5.747E+00, 5.739E+00, 5.755E+00, 5.749E+00, 5.753E+00,
                    5.745E+00, 5.732E+00, 5.735E+00, 5.724E+00, 5.725E+00, 5.712E+00, 5.702E+00, 5.700E+00, 5.700E+00, 5.686E+00,
                    5.685E+00, 5.672E+00, 5.659E+00, 5.627E+00, 5.613E+00, 5.590E+00, 5.591E+00, 5.563E+00, 5.552E+00, 5.525E+00,
                    5.517E+00, 5.506E+00, 5.494E+00, 5.459E+00, 5.450E+00, 5.438E+00, 5.428E+00, 5.407E+00, 5.391E+00, 5.382E+00,
                    5.376E+00, 5.358E+00, 5.347E+00, 5.333E+00, 5.319E+00, 5.301E+00, 5.292E+00, 5.284E+00, 5.274E+00, 5.258E+00,
                    5.253E+00, 5.249E+00, 5.233E+00, 5.222E+00, 5.211E+00, 5.204E+00, 5.210E+00, 5.200E+00, 5.193E+00, 5.186E+00,
                    5.177E+00, 5.175E+00, 5.178E+00, 5.173E+00, 5.152E+00, 5.135E+00, 5.139E+00, 5.128E+00, 5.121E+00, 5.114E+00,
                    5.126E+00, 5.107E+00, 5.104E+00, 5.100E+00, 5.109E+00, 5.114E+00, 5.112E+00, 5.128E+00, 5.137E+00, 5.131E+00,
                    5.152E+00, 5.175E+00, 5.194E+00, 5.200E+00, 5.244E+00, 5.257E+00, 5.273E+00, 5.289E+00, 5.335E+00, 5.366E+00,
                    5.389E+00, 5.427E+00, 5.453E+00, 5.490E+00, 5.522E+00, 5.562E+00, 5.605E+00, 5.652E+00, 5.698E+00, 5.744E+00,
                    5.743E+00, 5.642E+00, 5.689E+00, 5.722E+00, 5.755E+00, 5.798E+00, 5.848E+00, 5.875E+00, 5.918E+00, 5.971E+00,
                    6.022E+00, 6.061E+00, 6.116E+00, 6.173E+00, 6.214E+00, 6.266E+00, 6.319E+00, 6.382E+00, 6.426E+00, 6.486E+00,
                    6.542E+00, 6.579E+00, 6.616E+00, 6.666E+00, 6.728E+00, 6.771E+00, 6.807E+00, 6.858E+00, 6.908E+00, 6.959E+00,
                    7.006E+00, 7.052E+00, 7.093E+00, 7.136E+00, 7.164E+00, 7.199E+00, 7.232E+00, 7.266E+00, 7.315E+00, 7.340E+00,
                    7.361E+00, 7.399E+00, 7.440E+00, 7.473E+00, 7.505E+00, 7.525E+00, 7.557E+00, 7.579E+00, 7.604E+00, 7.633E+00,
                    7.653E+00, 7.674E+00, 7.691E+00, 7.699E+00, 7.708E+00, 7.721E+00, 7.730E+00, 7.729E+00, 7.712E+00, 7.702E+00,
                    7.695E+00, 7.670E+00, 7.644E+00, 7.618E+00, 7.585E+00, 7.555E+00, 7.517E+00, 7.479E+00, 7.451E+00, 7.435E+00,
                    7.408E+00, 7.379E+00, 7.363E+00, 7.347E+00, 7.332E+00, 7.332E+00, 7.332E+00, 7.304E+00, 7.295E+00, 7.296E+00,
                    7.291E+00, 7.292E+00, 7.292E+00, 7.281E+00, 7.283E+00, 7.264E+00, 7.250E+00, 7.240E+00, 7.228E+00, 7.210E+00,
                    7.186E+00, 7.164E+00, 7.143E+00, 7.114E+00, 7.101E+00, 7.069E+00, 7.038E+00, 7.003E+00, 6.974E+00, 6.928E+00,
                    6.889E+00, 6.839E+00, 6.793E+00, 6.764E+00, 6.729E+00, 6.694E+00, 6.662E+00, 6.613E+00, 6.572E+00, 6.546E+00,
                    6.522E+00, 6.507E+00, 6.482E+00, 6.484E+00, 6.479E+00, 6.494E+00, 6.496E+00, 6.491E+00, 6.461E+00, 6.440E+00,
                    6.430E+00, 6.413E+00, 6.421E+00, 6.399E+00, 6.379E+00, 6.365E+00, 6.372E+00, 6.346E+00, 6.321E+00, 6.310E+00,
                    6.314E+00, 6.282E+00, 6.277E+00, 6.270E+00, 6.258E+00, 6.242E+00, 6.234E+00, 6.221E+00, 6.231E+00, 6.221E+00,
                    6.205E+00, 6.193E+00, 6.192E+00, 6.179E+00, 6.159E+00, 6.143E+00, 6.143E+00, 6.120E+00, 6.098E+00, 6.087E+00,
                    6.063E+00, 6.056E+00, 6.053E+00, 6.040E+00, 6.044E+00, 6.007E+00, 5.996E+00, 5.994E+00, 5.997E+00, 5.975E+00,
                    5.954E+00, 5.946E+00, 5.927E+00, 5.914E+00, 5.890E+00, 5.873E+00, 5.832E+00, 5.794E+00, 5.768E+00, 5.728E+00,
                    5.681E+00, 5.680E+00, 5.655E+00, 5.648E+00, 5.620E+00, 5.594E+00, 5.567E+00, 5.557E+00, 5.552E+00, 5.553E+00,
                    5.539E+00, 5.524E+00, 5.507E+00, 5.505E+00, 5.487E+00, 5.474E+00, 5.462E+00, 5.450E+00, 5.448E+00, 5.441E+00,
                    5.440E+00, 5.442E+00, 5.450E+00, 5.466E+00, 5.461E+00, 5.452E+00, 5.445E+00, 5.412E+00, 5.379E+00, 5.280E+00,
                    5.228E+00, 5.199E+00, 5.171E+00, 5.139E+00, 5.124E+00, 5.112E+00, 5.129E+00, 5.145E+00, 5.173E+00, 5.176E+00,
                    5.185E+00, 5.183E+00, 5.200E+00, 5.202E+00, 5.204E+00, 5.224E+00, 5.244E+00, 5.297E+00, 5.318E+00, 5.376E+00,
                    5.441E+00, 5.491E+00, 5.561E+00, 5.629E+00, 5.687E+00, 5.757E+00, 5.830E+00, 5.911E+00, 5.998E+00, 6.090E+00,
                    6.193E+00, 6.330E+00, 6.449E+00, 6.581E+00, 6.710E+00, 6.838E+00, 6.970E+00, 7.107E+00, 7.238E+00, 7.388E+00,
                    7.506E+00, 7.635E+00, 7.767E+00, 7.874E+00, 7.977E+00, 8.071E+00, 8.150E+00, 8.220E+00, 8.292E+00, 8.350E+00,
                    8.449E+00, 8.521E+00, 8.583E+00, 8.666E+00, 8.723E+00, 8.759E+00, 8.821E+00, 8.864E+00, 8.909E+00, 8.941E+00,
                    8.949E+00, 8.955E+00, 8.983E+00, 9.022E+00, 9.043E+00, 9.044E+00, 9.028E+00, 9.034E+00, 9.052E+00, 9.048E+00,
                    9.041E+00, 9.037E+00, 9.036E+00, 9.035E+00, 9.021E+00, 9.016E+00, 9.008E+00, 8.970E+00, 8.974E+00, 8.953E+00,
                    8.957E+00, 8.937E+00, 8.923E+00, 8.912E+00, 8.895E+00, 8.891E+00, 8.880E+00, 8.867E+00, 8.855E+00, 8.852E+00,
                    8.861E+00, 8.864E+00, 8.876E+00, 8.869E+00, 8.873E+00, 8.855E+00, 8.828E+00, 8.839E+00, 8.855E+00, 8.856E+00,
                    8.833E+00, 8.842E+00, 8.844E+00, 8.830E+00, 8.808E+00, 8.818E+00, 8.807E+00, 8.797E+00, 8.794E+00, 8.791E+00,
                    8.795E+00, 8.772E+00, 8.754E+00, 8.759E+00, 8.760E+00, 8.746E+00, 8.762E+00, 8.778E+00, 8.790E+00, 8.795E+00,
                    8.811E+00, 8.848E+00, 8.874E+00, 8.885E+00, 8.913E+00, 8.944E+00, 8.981E+00, 8.988E+00, 9.001E+00, 9.034E+00,
                    9.076E+00, 9.111E+00, 9.141E+00, 9.171E+00, 9.214E+00, 9.255E+00, 9.304E+00, 9.356E+00, 9.406E+00, 9.448E+00,
                    9.516E+00, 9.578E+00, 9.638E+00, 9.692E+00, 9.763E+00, 9.845E+00, 9.953E+00, 1.004E+01, 1.015E+01, 1.027E+01,
                    1.039E+01, 1.052E+01, 1.063E+01, 1.077E+01, 1.091E+01, 1.103E+01, 1.119E+01, 1.135E+01, 1.150E+01, 1.166E+01,
                    1.181E+01, 1.201E+01, 1.217E+01, 1.235E+01, 1.251E+01, 1.269E+01, 1.287E+01, 1.307E+01, 1.325E+01, 1.346E+01,
                    1.364E+01, 1.384E+01, 1.404E+01, 1.423E+01, 1.441E+01, 1.461E+01, 1.481E+01, 1.499E+01, 1.518E+01, 1.534E+01,
                    1.554E+01, 1.571E+01, 1.591E+01, 1.607E+01, 1.622E+01, 1.637E+01, 1.653E+01, 1.667E+01, 1.678E+01, 1.690E+01,
                    1.698E+01, 1.709E+01, 1.718E+01, 1.725E+01, 1.734E+01, 1.739E+01, 1.748E+01, 1.755E+01, 1.761E+01, 1.767E+01,
                    1.771E+01, 1.777E+01, 1.783E+01, 1.787E+01, 1.794E+01, 1.795E+01, 1.799E+01, 1.805E+01, 1.809E+01, 1.813E+01,
                    1.820E+01, 1.827E+01, 1.830E+01, 1.835E+01, 1.841E+01, 1.846E+01, 1.852E+01, 1.856E+01, 1.861E+01, 1.866E+01,
                    1.871E+01, 1.876E+01, 1.881E+01, 1.885E+01, 1.890E+01, 1.896E+01, 1.903E+01, 1.907E+01, 1.911E+01, 1.916E+01,
                    1.921E+01, 1.927E+01, 1.929E+01, 1.932E+01, 1.935E+01, 1.936E+01, 1.940E+01, 1.943E+01, 1.947E+01, 1.951E+01,
                    1.953E+01, 1.956E+01, 1.960E+01, 1.961E+01, 1.962E+01, 1.966E+01, 1.966E+01, 1.969E+01, 1.970E+01, 1.972E+01,
                    1.974E+01, 1.974E+01, 1.976E+01, 1.978E+01, 1.979E+01, 1.982E+01, 1.982E+01, 1.983E+01, 1.986E+01, 1.988E+01,
                    1.989E+01, 1.989E+01, 1.993E+01, 1.993E+01, 1.997E+01, 2.001E+01, 2.001E+01, 2.004E+01, 2.007E+01, 2.011E+01,
                    2.014E+01, 2.015E+01, 2.017E+01, 2.019E+01, 2.022E+01, 2.023E+01, 2.023E+01, 2.026E+01, 2.027E+01, 2.029E+01,
                    2.028E+01, 2.027E+01, 2.029E+01, 2.029E+01, 2.031E+01, 2.029E+01, 2.026E+01, 2.030E+01, 2.031E+01, 2.030E+01,
                    2.030E+01, 2.031E+01, 2.029E+01, 2.029E+01, 2.026E+01, 2.025E+01, 2.023E+01, 2.020E+01, 2.016E+01, 2.015E+01,
                    2.012E+01, 2.009E+01, 2.007E+01, 2.003E+01, 1.998E+01, 1.996E+01, 1.991E+01, 1.986E+01, 1.980E+01, 1.975E+01,
                    1.969E+01, 1.964E+01, 1.959E+01, 1.953E+01, 1.947E+01, 1.941E+01, 1.936E+01, 1.931E+01, 1.922E+01, 1.918E+01,
                    1.912E+01, 1.906E+01, 1.899E+01, 1.890E+01, 1.885E+01, 1.881E+01, 1.875E+01, 1.867E+01, 1.861E+01, 1.858E+01,
                    1.852E+01, 1.846E+01, 1.840E+01, 1.834E+01, 1.829E+01, 1.824E+01, 1.819E+01, 1.813E+01, 1.807E+01, 1.803E+01,
                    1.798E+01, 1.792E+01, 1.788E+01, 1.782E+01, 1.780E+01, 1.775E+01, 1.773E+01, 1.768E+01, 1.768E+01, 1.766E+01,
                    1.763E+01, 1.762E+01, 1.763E+01, 1.764E+01, 1.764E+01, 1.766E+01, 1.770E+01, 1.774E+01, 1.779E+01, 1.786E+01,
                    1.795E+01, 1.803E+01, 1.814E+01, 1.825E+01, 1.836E+01, 1.851E+01, 1.866E+01, 1.881E+01, 1.895E+01, 1.913E+01,
                    1.932E+01, 1.951E+01, 1.972E+01, 1.994E+01, 2.017E+01, 2.040E+01, 2.065E+01, 2.089E+01, 2.114E+01, 2.140E+01,
                    2.163E+01, 2.186E+01, 2.210E+01, 2.237E+01, 2.262E+01, 2.290E+01, 2.313E+01, 2.339E+01, 2.361E+01, 2.387E+01,
                    2.410E+01, 2.435E+01, 2.455E+01, 2.479E+01, 2.499E+01, 2.521E+01, 2.541E+01, 2.562E+01, 2.583E+01, 2.605E+01,
                    2.626E+01, 2.643E+01, 2.657E+01, 2.674E+01, 2.689E+01, 2.701E+01, 2.718E+01, 2.732E+01, 2.742E+01, 2.754E+01,
                    2.763E+01, 2.777E+01, 2.794E+01, 2.804E+01, 2.821E+01, 2.836E+01, 2.850E+01, 2.863E+01, 2.878E+01, 2.896E+01,
                    2.913E+01, 2.922E+01, 2.937E+01, 2.947E+01, 2.960E+01, 2.970E+01, 2.982E+01, 2.997E+01, 3.007E+01, 3.018E+01,
                    3.028E+01, 3.040E+01, 3.053E+01, 3.060E+01, 3.066E+01, 3.070E+01, 3.076E+01, 3.078E+01, 3.075E+01, 3.074E+01,
                    3.072E+01, 3.065E+01, 3.058E+01, 3.051E+01, 3.045E+01, 3.034E+01, 3.029E+01, 3.023E+01, 3.015E+01, 3.004E+01,
                    3.000E+01, 2.998E+01, 2.991E+01, 2.986E+01, 2.984E+01, 2.981E+01, 2.976E+01, 2.973E+01, 2.976E+01, 2.977E+01,
                    2.979E+01, 2.981E+01, 2.985E+01, 2.989E+01, 2.999E+01, 3.000E+01, 3.005E+01, 3.007E+01, 3.011E+01, 3.017E+01,
                    3.022E+01, 3.023E+01, 3.029E+01, 3.028E+01, 3.029E+01, 3.027E+01, 3.027E+01, 3.024E+01, 3.019E+01, 3.010E+01,
                    3.010E+01, 3.003E+01, 2.993E+01, 2.983E+01, 2.984E+01, 2.975E+01, 2.966E+01, 2.958E+01, 2.948E+01, 2.930E+01,
                    2.926E+01, 2.920E+01, 2.913E+01, 2.902E+01, 2.890E+01, 2.882E+01, 2.873E+01, 2.873E+01, 2.870E+01, 2.865E+01,
                    2.858E+01, 2.854E+01, 2.851E+01, 2.846E+01, 2.838E+01, 2.834E+01, 2.823E+01, 2.820E+01, 2.817E+01, 2.809E+01,
                    2.803E+01, 2.803E+01, 2.801E+01, 2.794E+01, 2.791E+01, 2.790E+01, 2.784E+01, 2.779E+01, 2.781E+01, 2.782E+01,
                    2.781E+01, 2.781E+01, 2.783E+01, 2.785E+01, 2.785E+01, 2.782E+01, 2.782E+01, 2.780E+01, 2.780E+01, 2.778E+01,
                    2.783E+01, 2.784E+01, 2.788E+01, 2.791E+01, 2.799E+01, 2.804E+01, 2.812E+01, 2.811E+01, 2.819E+01, 2.819E+01,
                    2.817E+01, 2.817E+01, 2.831E+01, 2.837E+01, 2.848E+01, 2.853E+01, 2.859E+01, 2.870E+01, 2.874E+01, 2.887E+01,
                    2.898E+01, 2.910E+01, 2.923E+01, 2.934E+01, 2.944E+01, 2.959E+01, 2.973E+01, 2.987E+01, 3.002E+01, 3.016E+01,
                    3.035E+01, 3.043E+01, 3.064E+01, 3.084E+01, 3.098E+01, 3.122E+01, 3.132E+01, 3.152E+01, 3.165E+01, 3.184E+01,
                    3.204E+01, 3.221E+01, 3.233E+01, 3.255E+01, 3.282E+01, 3.315E+01, 3.339E+01, 3.360E+01, 3.384E+01, 3.410E+01,
                    3.426E+01, 3.452E+01, 3.473E+01, 3.497E+01, 3.519E+01, 3.539E+01, 3.561E+01, 3.579E+01, 3.604E+01, 3.618E+01,
                    3.636E+01, 3.660E+01, 3.675E+01, 3.682E+01, 3.699E+01, 3.711E+01, 3.735E+01, 3.758E+01, 3.792E+01, 3.796E+01,
                    3.812E+01, 3.822E+01, 3.833E+01, 3.856E+01, 3.874E+01, 3.877E+01, 3.884E+01, 3.883E+01, 3.879E+01, 3.886E+01,
                    3.900E+01, 3.900E+01, 3.906E+01, 3.905E+01, 3.916E+01, 3.928E+01, 3.948E+01, 3.943E+01, 3.951E+01, 3.964E+01,
                    3.953E+01, 3.960E+01, 3.958E+01, 3.954E+01, 3.940E+01, 3.936E+01, 3.917E+01, 3.926E+01, 3.893E+01, 3.921E+01,
                    3.871E+01])

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=40)
PD_t12 = np.array([0.95692180550750894, 0.95692180550750894, 0.95692180550750894, 0.95692180550750894, 0.95692180550750894, 0.95692180550750894, 0.95701359340659375, 0.95710533680184717, 0.95718393848535566, 0.95727559891191749, 0.95736721449097284, 0.95743262666577178, 0.95749801585350469, 0.95757645247370515, 0.95764179093442559, 0.95770710626660105, 0.95777239842587114, 0.95782461543896247, 0.95788986577506452, 0.95794204927194448, 0.95800725764060302, 0.95804637144334892, 0.95808547682045875, 0.95813760420003502, 0.95817668987974436, 0.95821576710158018, 0.95825483585585336, 0.95829389613286531, 0.95831993160315843, 0.95835897772982037, 0.95839801535332281, 0.9584240357068684, 0.95846305913679353, 0.95848907001894701, 0.95852807922823569, 0.95855408062092673, 0.9585800782127798, 0.95860607200088865, 0.95863206198236528, 0.95865804815430511, 0.95868403051381768, 0.95872299689841967, 0.95876195468871761, 0.95878792176946726, 0.95882686521412552, 0.95886580003830468, 0.95889175179374864, 0.95891769971058372, 0.95895661438206659, 0.95898255268961718, 0.95900848714834741, 0.95903441775533183, 0.95906034450763966, 0.9590862674023507, 0.95911218643653984, 0.95913810160727486, 0.95916401291162834, 0.95917696711299028, 0.95920287261225989, 0.95921582390943594, 0.95924172359702486, 0.95926761940648964, 0.95928056585600685, 0.95930645584276442, 0.95931939937928057, 0.95934528353671789, 0.95935822415691296, 0.95937116380426046, 0.95939704017896654, 0.95940997690558161, 0.95942291265788071, 0.95943584743549304, 0.95946171406519132, 0.95947464591653953, 0.95950050669037801, 0.9595134356121342, 0.95952636355662002, 0.95953929052346609, 0.95956514152276573, 0.95957806555447511, 0.95959098860706815, 0.95960391068017259, 0.95962975188642663, 0.95964267101884937, 0.95966850634039824, 0.95968142252878896, 0.95969433773509771, 0.95972016519998604, 0.95973307745781811, 0.95975889902240952, 0.95977180832843056, 0.95978471664976306, 0.95981053033689412, 0.95982343570195205, 0.95984924347318179, 0.9598621458786134, 0.9598879477272334, 0.95991374562373144, 0.95992664308899978, 0.95995243505170735, 0.95997822305482805, 0.96000400709537093, 0.96002978717035536, 0.96004267571982382, 0.96006844984085593, 0.96009421998883615, 0.96011998616078276, 0.96014574835369892, 0.96017150656457895, 0.96019726079042966, 0.96022301102824192, 0.96024875727502446, 0.96028736915543178, 0.9603131054114693, 0.96035170229165667, 0.96037742853814201, 0.96041601038988322, 0.96044172660798577, 0.96048029340300167, 0.96050599957385419, 0.96054455128382865, 0.96058309392917374, 0.9606216274996715, 0.96064731150003602, 0.96068582992305163, 0.9607243392439303, 0.96076283945241725, 0.96080133053825645, 0.96083981249118, 0.96087828530090702, 0.96091674895715895, 0.96095520344963015, 0.96099364876802784, 0.96104489490394385, 0.9610833187760327, 0.96112173343963514, 0.96116013888439955, 0.96121133178579221, 0.96124971567967532, 0.96130087980892553, 0.96133924209545285, 0.96137759510436449, 0.96142871799975338, 0.96146704932042704, 0.96151814326034257, 0.96155645283602154, 0.96160751774471265, 0.96164580551852619, 0.96169684132008815, 0.9617351072350393, 0.96178611385341284, 0.96183710376146192, 0.96187533521136581, 0.96192629581638167, 0.96196450526035182, 0.96201543648587073, 0.96206635088871861, 0.96211724844383706, 0.96216812912616811, 0.96221899291058444, 0.96226983977196678, 0.96232066968514385, 0.96237148262492056, 0.96242227856607176, 0.96247305748334422, 0.96252381935146047, 0.96257456414509468, 0.96262529183892109, 0.9626633263722737, 0.96271402408034634, 0.96276470461876484, 0.96281536796206568, 0.96286601408477546, 0.96290398736044369, 0.96295460328569316, 0.9630052019201164, 0.96305578323810725, 0.9631063472140472, 0.96314425879984833, 0.96319479236544447, 0.96324530851835988, 0.96329580723286001, 0.96334628848316473, 0.96338413794450573, 0.96343458857039377, 0.9634850216610682, 0.96352283495602642, 0.9635732372977962, 0.96361102750129646, 0.96366139901472403, 0.96369916606714479, 0.9637369231793852, 0.96377467034045639, 0.96381240753936637, 0.96385013476512071, 0.96388785200668958, 0.96392555925305878, 0.96396325649319159, 0.96398838242214302, 0.96402606296066651, 0.96406373346348673, 0.96410139391952798, 0.96413904431771691, 0.96416413898999687, 0.96420177260044393, 0.96423939612344189, 0.96426447286247929, 0.96430207954835945, 0.96432714505234929, 0.96436473487018359, 0.96438978911850337, 0.96441483885875701, 0.96445240500930474, 0.96447744346495179, 0.96451499267305907, 0.96454001982339943, 0.9645650424458031, 0.96459006053695817, 0.96462757917034136, 0.96465258591884961, 0.96467758812447224, 0.96470258578388424, 0.96472757889376848, 0.96475256745077753, 0.96477755145158051, 0.96480253089284473, 0.96482750577122678, 0.96483999149830024, 0.96486495952610574, 0.96487744182600488, 0.96490240299571584, 0.96491488186467789, 0.96493983616876078, 0.96495231160303063, 0.96497725903394693, 0.96498973102974916, 0.96500220187856323, 0.96501467157996323, 0.96502714013352942, 0.96503960753884166, 0.96505207379548386, 0.96506453890304078, 0.96507700286107889, 0.96507700286107889, 0.96508946566919529, 0.96510192732695521, 0.96511438783393455, 0.96511438783393455, 0.9651268471897303, 0.9651268471897303, 0.96513930539391812, 0.96513930539391812, 0.96515176244606748, 0.96515176244606748, 0.96516421834576216, 0.96516421834576216, 0.9651766730925857, 0.9651766730925857, 0.96518912668610857, 0.96518912668610857, 0.96520157912591931, 0.96520157912591931, 0.96520157912591931, 0.96521403041159126, 0.96521403041159126, 0.96521403041159126, 0.96522648054270843, 0.96522648054270843, 0.96523892951883294, 0.96523892951883294, 0.96525137733956246, 0.96525137733956246, 0.96526382400447053, 0.96526382400447053, 0.96527626951312828, 0.96527626951312828, 0.96528871386511483, 0.96530115706001673, 0.96530115706001673, 0.96531359909740266, 0.96532603997685884, 0.96533847969795283, 0.96533847969795283, 0.96535091826026909, 0.96535091826026909, 0.96536335566338249, 0.9653757919068684, 0.96538822699030813, 0.96538822699030813, 0.96540066091327159, 0.96541309367534345, 0.96542552527610015, 0.96542552527610015, 0.96543795571511215, 0.96543795571511215, 0.96545038499195523, 0.96546281310620763, 0.96547524005745344, 0.96547524005745344, 0.9654876658452598, 0.96550009046920504, 0.96551251392886661, 0.96552493622381352, 0.96553735735362367, 0.9655497773178815, 0.96556219611615424, 0.96557461374802467, 0.96558703021304648, 0.96561185964090712, 0.96562427260289041, 0.965636684396324, 0.96566150447590426, 0.96567391276119063, 0.96569872582061678, 0.96571113059390601, 0.96573593662550827, 0.96576073796762896, 0.9657731368790643, 0.96579793118056212, 0.96581032656976606, 0.96583511382295151, 0.96585989637298075, 0.96588467421643553, 0.96590944734988948, 0.96593421576991323, 0.96595897947309362, 0.96598373845597985, 0.9660084927151501, 0.96602086807226362, 0.96604561523941235, 0.9660703576742522, 0.96609509537333904, 0.96611982833323995, 0.96613219303491227, 0.96615691887955746, 0.96618163997640383, 0.96620635632198704, 0.96623106791286373, 0.96624342192420976, 0.96626812637655124, 0.96629282606554612, 0.96631752098773949, 0.96632986666020559, 0.96635455442570406, 0.96636689651787533, 0.96639157711888557, 0.96640391562686234, 0.96641625293924349, 0.96644092397547199, 0.96645325769845503, 0.96646559022410106, 0.96649025168166025, 0.96650258061270755, 0.96652723487714398, 0.96653956020967402, 0.96656420727316417, 0.96657652900326307, 0.96658884953167745, 0.96661348698172267, 0.96662580390248332, 0.9666381196198186, 0.96665043413329654, 0.96666274744247105, 0.96667505954691801, 0.96668737044620001, 0.96669968013988017, 0.96671198862750729, 0.96672429590866849, 0.96672429590866849, 0.96673660198290634, 0.96674890684979686, 0.96674890684979686, 0.9667612105088883, 0.9667612105088883, 0.96677351295976854, 0.96677351295976854, 0.96677351295976854, 0.96677351295976854, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96677351295976854, 0.96677351295976854, 0.9667612105088883, 0.9667612105088883, 0.9667612105088883, 0.9667612105088883, 0.96674890684979686, 0.96674890684979686, 0.96674890684979686, 0.96674890684979686, 0.96673660198290634, 0.96673660198290634, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96671198862750729, 0.96671198862750729, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96668737044620001, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96669968013988017, 0.96671198862750729, 0.96671198862750729, 0.96671198862750729, 0.96671198862750729, 0.96671198862750729, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96672429590866849, 0.96673660198290634, 0.96673660198290634, 0.96673660198290634, 0.96673660198290634, 0.96674890684979686, 0.96674890684979686, 0.9667612105088883, 0.9667612105088883, 0.9667612105088883, 0.9667612105088883, 0.96677351295976854, 0.96677351295976854, 0.96677351295976854, 0.96677351295976854, 0.96677351295976854, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96678581420197829, 0.96679811423508399, 0.96679811423508399, 0.96681041305864601, 0.96681041305864601, 0.96681041305864601, 0.96681041305864601, 0.96682271067224312, 0.96682271067224312, 0.96682271067224312, 0.96682271067224312, 0.96683500707542103, 0.96683500707542103, 0.9668473022677373, 0.9668473022677373, 0.9668473022677373, 0.9668473022677373, 0.9668595962487726, 0.9668595962487726, 0.9668595962487726, 0.9668595962487726, 0.96687188901807586, 0.96687188901807586, 0.96688418057520764, 0.96688418057520764, 0.96688418057520764, 0.96688418057520764, 0.96689647091973585, 0.96689647091973585, 0.96689647091973585, 0.96689647091973585, 0.96690876005121984, 0.96690876005121984, 0.96692104796922029, 0.96692104796922029, 0.96692104796922029, 0.9669333346732919, 0.9669333346732919, 0.96694562016300878, 0.96694562016300878, 0.96695790443791496, 0.96695790443791496, 0.96697018749758701, 0.96697018749758701, 0.96698246934158161, 0.96698246934158161, 0.96699474996944967, 0.96699474996944967, 0.96700702938076055, 0.96700702938076055, 0.96700702938076055, 0.96701930757507437, 0.96701930757507437, 0.96703158455194549, 0.96703158455194549, 0.96703158455194549, 0.96704386031093548, 0.96704386031093548, 0.96705613485160824, 0.96705613485160824, 0.96705613485160824, 0.96706840817352402, 0.96706840817352402, 0.96708068027623217, 0.96708068027623217, 0.96708068027623217, 0.96709295115929828, 0.96709295115929828, 0.96710522082228301, 0.96710522082228301, 0.96711748926474872, 0.96711748926474872, 0.96712975648624566, 0.96712975648624566, 0.96714202248634196, 0.96715428726458752, 0.96715428726458752, 0.96716655082053993, 0.96716655082053993, 0.96717881315376819, 0.96719107426382445, 0.96719107426382445, 0.96720333415025983, 0.96720333415025983, 0.96721559281265002, 0.96722785025053237, 0.96722785025053237, 0.96724010646348513, 0.96724010646348513, 0.96725236145104487, 0.96726461521279006, 0.96727686774825794, 0.96727686774825794, 0.96728911905702208, 0.96730136913862919, 0.96731361799263971, 0.96731361799263971, 0.96732586561860867, 0.96732586561860867, 0.96733811201610087, 0.96735035718466866, 0.96736260112385597, 0.96736260112385597, 0.96737484383323569, 0.96738708531235562, 0.96739932556077446, 0.96741156457805, 0.96741156457805, 0.96742380236372572, 0.96743603891737939, 0.96744827423855329, 0.96746050832680364, 0.96746050832680364, 0.96747274118167959, 0.9674849728027507, 0.96749720318955168, 0.96750943234166376, 0.96750943234166376, 0.96752166025861841, 0.9675338869399791, 0.96754611238530153, 0.96755833659413981, 0.96757055956604809, 0.96758278130057662, 0.96759500179728264, 0.96760722105571872, 0.9676194390754409, 0.9676194390754409, 0.9676316558559992, 0.96764387139694663, 0.9676560856978409, 0.96766829875823235, 0.96768051057767623, 0.96769272115571747, 0.96770493049192352, 0.96771713858582964, 0.96772934543700195, 0.96772934543700195, 0.9677415510449886, 0.96775375540933617, 0.96776595852959968, 0.96777816040533615, 0.96779036103609384, 0.96780256042142199, 0.96781475856087895, 0.96782695545400843, 0.9678391511003599, 0.96785134549949792, 0.96786353865096419, 0.96787573055430454, 0.96788792120907963, 0.96790011061482972, 0.96791229877111629, 0.96792448567748124, 0.96793667133347883, 0.96794885573866052, 0.96796103889257323, 0.96798540144479073, 0.967997580842196, 0.9680097589865323, 0.9680219358773452, 0.96803411151419005, 0.96804628589660702, 0.96805845902415755, 0.96807063089637135, 0.96808280151281689, 0.9680949708730231, 0.96810713897656409, 0.96811930582296701, 0.96813147141178291, 0.96814363574256301, 0.96815579881486014, 0.96818012118216734, 0.96819228047628381, 0.96820443851009297, 0.96821659528316151, 0.96822875079501858, 0.96825305803330197, 0.96826520975882624, 0.9682773602213276, 0.96828950942036007, 0.96830165735546181, 0.96831380402618894, 0.9683259494320775, 0.96833809357267953, 0.96835023644753726, 0.96836237805619774, 0.96838665747310448, 0.96839879528043715, 0.96841093181975857, 0.96842306709060622, 0.96843520109252512, 0.96845946528776206, 0.96847159548015804, 0.96848372440180475, 0.9684958520522492, 0.96850797843102554, 0.96853222737176925, 0.96854434993281546, 0.96855647122037558, 0.9685685912339842, 0.96858070997319234, 0.9686049436265739, 0.9686170585398246, 0.96862917217684741, 0.96864128453718235, 0.96865339562036301, 0.96867761395344398, 0.96868972120243024, 0.96870182717243658, 0.96871393186300303, 0.96872603527366541, 0.96875023825346207, 0.96876233782167631, 0.96877443610815839, 0.96878653311244978, 0.96879862883408097, 0.96882281642754509, 0.96883490829845931, 0.96884699888487724, 0.96885908818634425, 0.96887117620239105, 0.968895348376413, 0.96890743253346412, 0.96891951540325316, 0.96893159698532583, 0.96894367727921327, 0.96896783400062259, 0.96897991042720844, 0.96899198556377608, 0.96900405940985379, 0.96901613196498604, 0.9690282032287022, 0.96904027320054253, 0.96905234188005684, 0.96906440926676862, 0.96907647536021335, 0.96910060366548478, 0.96911266587637213, 0.96912472679214556, 0.96913678641234857, 0.96914884473651208, 0.96916090176416914, 0.96917295749485921, 0.96918501192812323, 0.96919706506348313, 0.96920911690048794, 0.96923321667756202, 0.96924526461669391, 0.96925731125561376, 0.96926935659385338, 0.96928140063094248, 0.96930548479981604, 0.96931752493066903, 0.96932956375851465, 0.96934160128287661, 0.96935363750330716, 0.9693656724193267, 0.96937770603047091, 0.96938973833627529, 0.96940176933627908, 0.96941379903000557, 0.96943785449677256, 0.9694498802688799, 0.96946190473284277, 0.96947392788820763, 0.96948594973449176, 0.96949797027122575, 0.96950998949795553, 0.96952200741420014, 0.9695340240195025, 0.96954603931339622, 0.9695700659650538, 0.96958207732188928, 0.96959408736543173, 0.96960609609521686, 0.9696181035107766, 0.96963010961164253, 0.96964211439734016, 0.96965411786740485, 0.9696661200213611, 0.96967812085874527, 0.96969012037908464, 0.96970211858191269, 0.9697141154667599, 0.96972611103314599, 0.96973810528061322, 0.96975009820867764, 0.96976208981688938, 0.96977408010475807, 0.96978606907181719, 0.96979805671759645, 0.96982202804343975, 0.96983401172255079, 0.96984599407850214, 0.96985797511081706, 0.96986995481902771, 0.96988193320265204, 0.9698939102612244, 0.96990588599427197, 0.96991786040131989, 0.96992983348189687, 0.96994180523553641, 0.9699537756617499, 0.9699657447600829, 0.96997771253005138, 0.96998967897118282, 0.97000164408299472, 0.97001360786503665, 0.97002557031681647, 0.97003753143786475, 0.97004949122770989, 0.97006144968587182, 0.97007340681188081, 0.97008536260526013, 0.97009731706554203, 0.97010927019223836, 0.97012122198488171, 0.97013317244300334, 0.97014512156611965, 0.97015706935375357, 0.97016901580543236, 0.97018096092068051, 0.97019290469902719, 0.97020484713999278, 0.97021678824309654, 0.97022872800787197, 0.97025260352049691, 0.97026453926741008, 0.97027647367407244, 0.97028840674002781, 0.97030033846478414, 0.97031226884785959, 0.97032419788879898, 0.97033612558710236, 0.97034805194230433, 0.97035997695391851, 0.9703719006214736, 0.97038382294449288, 0.97039574392249806, 0.97040766355499919, 0.97041958184152566, 0.97044341437474468, 0.97045532862048089, 0.97046724151832231, 0.97047915306779775, 0.97049106326842538, 0.97050297211971948, 0.97051487962121652, 0.97052678577241425, 0.97053869057284725, 0.97055059402203447, 0.97056249611948386, 0.97057439686473157, 0.97058629625729054, 0.97059819429667471, 0.97061009098241302, 0.97062198631401431, 0.97063388029100206, 0.97064577291289977, 0.97065766417922328, 0.97066955408947531, 0.97069332983989431, 0.97070521567909196, 0.97071710016029633, 0.9707289832830388, 0.97074086504682844, 0.97075274545118262, 0.97076462449562928, 0.97077650217965961, 0.97078837850281674, 0.97080025346461485, 0.97081212706455045, 0.97082399930215779, 0.97083587017696094, 0.97084773968845306, 0.97085960783616221, 0.97088334003829535, 0.97089520409175167, 0.97090706677947558, 0.97091892810099956, 0.97093078805583932, 0.9709426466434955, 0.97095450386349647, 0.97096635971534839, 0.970978214198565, 0.97099006731266613, 0.9710019190571676, 0.97101376943157347, 0.97102561843541246, 0.97103746606818409, 0.97104931232940994, 0.97107300073527658, 0.97108484287894359, 0.97109668364910984, 0.97110852304529582, 0.97112036106702138, 0.97113219771378301, 0.97114403298510021, 0.97115586688049571, 0.97116769939946601, 0.97117953054153039, 0.97119136030619635, 0.97120318869298528, 0.97121501570139945, 0.9712268413309566, 0.97123866558115979, 0.97125048845152628, 0.97126230994157436, 0.97127413005079677, 0.97128594877871466, 0.97129776612484342, 0.97130958208868556, 0.97132139666975337, 0.97133320986756, 0.97134502168161074, 0.97135683211141832, 0.97136864115649146, 0.97138044881633878, 0.97139225509047156, 0.97140405997839929, 0.97141586347962683, 0.97142766559367666, 0.97143946632003131, 0.97145126565822304, 0.97146306360775769, 0.97147486016813778, 0.97149844911945693, 0.97151024150941889, 0.97152203250826885, 0.97153382211549422, 0.9715456103306076, 0.97155739715313372, 0.97156918258256253, 0.97158096661839932, 0.97159274926016448, 0.97160453050736095, 0.97161631035948692, 0.97162808881605101, 0.97163986587656292, 0.97165164154053263, 0.97166341580745452, 0.97167518867685088, 0.97168696014821432, 0.97169873022105324, 0.97171049889486882, 0.97172226616917623, 0.97173403204347508, 0.97174579651727289, 0.97175755959006793, 0.97176932126136983, 0.97178108153067599, 0.97179284039750768, 0.97180459786135143, 0.97181635392171994, 0.97182810857811308, 0.97183986183003213, 0.97185161367698902, 0.97186336411848517, 0.97187511315402308, 0.97188686078309816, 0.97189860700522235, 0.97191035181990182, 0.97192209522661932, 0.97193383722490323, 0.97194557781423452, 0.97195731699413046, 0.97196905476408657, 0.97198079112359848, 0.97199252607218178, 0.97200425960932357, 0.97201599173454178, 0.9720277224473256, 0.97203945174717621, 0.97205117963359511, 0.97206290610609092, 0.97207463116414849, 0.97208635480728989, 0.97209807703499751, 0.97210979784678198, 0.97212151724213491, 0.97213323522056172, 0.97215666692463221, 0.97216838064927613, 0.97218009295498631, 0.97219180384127524, 0.97220351330762289, 0.97221522135354332, 0.97222692797853072, 0.97223863318208248, 0.97225033696369778, 0.97226203932286981, 0.97227374025911117, 0.97228543977189918, 0.97229713786074723, 0.97230883452514005, 0.97232052976459526, 0.97234391596662695, 0.97235560692821144, 0.97236729646282782, 0.97237898456998617, 0.97239067124916734, 0.97240235649988582, 0.97241404032161927, 0.97242572271387917, 0.9724374036761575, 0.97244908320793844, 0.97246076130872949, 0.97247243797802341, 0.97248411321531814, 0.97249578702010309, 0.9725074593918781, 0.97253079983436219, 0.97254246790407484, 0.97255413453874173, 0.97256579973787705, 0.97257746350096363, 0.97260078671697547, 0.97261244616888842, 0.97262410418272738, 0.9726357607579954, 0.9726474158941778, 0.97267072184725223, 0.97268237266313617, 0.97269402203790456, 0.97270566997105257, 0.97271731646207327, 0.97274060511569083, 0.97275224727727749, 0.97276388799470137, 0.97277552726745353, 0.97278716509502072, 0.97281043641259735, 0.97282206990158315, 0.97283370194334129, 0.97284533253737948, 0.97285696168318636, 0.97288021562804994, 0.97289184042608989, 0.97290346377385351, 0.97291508567083551, 0.97293832511038836, 0.97294994265194357, 0.97297317337605682, 0.97298478655759724, 0.97299639828476714, 0.97300800855706182, 0.97303122473498138, 0.97304283063957964, 0.97305443508725475, 0.97306603807750147, 0.97308923968362027, 0.97310083829847505, 0.97312403114920909, 0.97313562538406306, 0.9731472181578833, 0.9731588094701602, 0.97318198770804565, 0.9731935746326158, 0.97320516009358859, 0.97321674409045722, 0.97323990768977509, 0.97325148729120359, 0.97327464209503978, 0.97328621729640485, 0.97330936329546736, 0.97332093409212628, 0.97334407127713574, 0.9733556376644481, 0.97337876602610696, 0.97339032799941527, 0.97341344752842163, 0.97342500508307872, 0.97344811577012325, 0.97345966890146951, 0.97348277073722378, 0.97349431944059328, 0.97351741241573519, 0.973528956686465, 0.97355204079165458, 0.97356358062507575, 0.97358665585096915, 0.97359819124239755, 0.97362125757963569, 0.97363278852440016, 0.97365584596362476, 0.97366737245703505, 0.97369042098887593, 0.97370194302625324, 0.9737249826413138, 0.97374801630665597, 0.97375953090686573, 0.97378255563978344, 0.97379406577143512, 0.97381708156252089, 0.97384009138716376, 0.97385159406075539, 0.97387459492787942, 0.97388609312035634, 0.9739090850205282, 0.973932070937507, 0.97394356165097784, 0.97396653858527205, 0.97397802480503959, 0.97400099274720819, 0.97402395468936254, 0.97403543340913046, 0.9740583863433927, 0.97406986055683364, 0.97409280447372204, 0.97411574237376819, 0.97412720906616057, 0.97415013793301974, 0.97416160010644526, 0.97418451993063193, 0.97420743372108121, 0.97421888835233927, 0.97424179308426762, 0.97425324318388384, 0.97427613884776998, 0.97429902846099559, 0.97432191201932994, 0.97433335152658029, 0.97435622599462635, 0.97437909439716586, 0.97440195672996155, 0.97441338561886615, 0.97443623883906927, 0.97444766316929488, 0.97447050726733275, 0.97448192703408465, 0.97450476200038061, 0.97451617719886408, 0.97453900302383301, 0.97455041364925044, 0.97457323032329857, 0.97458463637085091, 0.97460744388435716, 0.97461884534924681, 0.97464164369261352, 0.9746644359172022, 0.97467582973361111, 0.9746986127720032, 0.97471000199291835, 0.97473277583547369, 0.97475554354212501, 0.97477830510856733, 0.97478968358787221, 0.97481243593596356, 0.97483518213311093, 0.97485792217501988, 0.97486928988640598, 0.9748920206873789, 0.97490338377588714, 0.97492610532623913, 0.97494882070412414, 0.9749601760770451, 0.97498288218813745, 0.9749942329252349, 0.97501692975982956, 0.97503962040468495, 0.97506230485547873, 0.97507364475674818, 0.9750963199083359, 0.97511898885504567, 0.97514165159253952, 0.9751529806314686, 0.97517563404701291, 0.97518695842252923, 0.97520960250634647, 0.97523224036358669, 0.97524355695588261, 0.97526618546511923, 0.97527749738095759, 0.97530011653238258, 0.97532272943982801, 0.97533403355069415, 0.97535663708400622, 0.97536793650534614, 0.97539053065470172, 0.97541311854262758, 0.97543570016475978, 0.97544698862478696, 0.97546956084003011, 0.97549212677855401, 0.97551468643596284, 0.97552596390789237, 0.97554851413542631, 0.97555978688995659, 0.97558232767775921, 0.97560486216691378, 0.97561612704813316, 0.97563865208108858, 0.9756499122317408, 0.97567242779860253, 0.97569493704925192, 0.97570618930460873, 0.97572868907265253, 0.97573993658424618, 0.97576242685977843, 0.97578491080146434, 0.97579615039573409, 0.97581862482835691, 0.97582985966561875, 0.97585232457924798, 0.97587478314136178, 0.97588601003921194, 0.97590845906574197, 0.97591968119331207, 0.97594212067429409, 0.97596455378603564, 0.97597576795205709, 0.97599819150163269, 0.97600940088407062, 0.97603181486147816, 0.97605422245188511, 0.9760654238505827, 0.97608782185216114, 0.97609901845392899, 0.97612140685665671, 0.97614378885459319, 0.97615497745035762, 0.97617734983273652, 0.97618853361821334, 0.97621089637498693, 0.97623325270911177, 0.97624442846629267, 0.97626677515806837, 0.97627794609155105, 0.97630028313091222, 0.97632261372972562, 0.97633377661253629, 0.97635609754214747, 0.97636725558783066, 0.97638956683813616, 0.97641187162997189, 0.97642302160255434, 0.97644531669824897, 0.97645646182023427, 0.9764787472096822, 0.97650102612267053, 0.9765121631490794, 0.97653443233893999, 0.9765455645012513, 0.97656782395782882, 0.97659007691993427, 0.97660120096413716, 0.97662344417604707, 0.97663456334261234, 0.97665679679415862, 0.9766679110780071, 0.97669013475902267, 0.97670124415505544, 0.97672345805535565, 0.9767345625584859, 0.97675676666786782, 0.9767678662729895, 0.97679006058125162, 0.97680115528326916, 0.97682333978020219, 0.97684551773058037, 0.97685660424938192, 0.97687877237138232, 0.9768898539734423, 0.97691201225682489, 0.97692308893701651, 0.97694523737154026, 0.97695630912474096, 0.97697844770013975, 0.97698951452121052, 0.97701164322723966, 0.97702270511104117, 0.97704482393739045, 0.97705588087879214, 0.97707798981519622, 0.97710009215257476, 0.97711114084519635, 0.97713323327545754, 0.97714427701194995, 0.97716635952477326, 0.97717739829995909, 0.97719947088503123, 0.97721050469375881, 0.97723256734073949, 0.97724359617783707, 0.97725462335658231, 0.97727667273668517, 0.97728769493689627, 0.97730973435476431, 0.97732075157127252, 0.97733176712538372, 0.97735379324414995, 0.97736480380763391, 0.97738681993996268, 0.97739782550763776, 0.97740882940889218, 0.97743083220980309, 0.97744183110830507, 0.97746382389852871, 0.97747481778909118, 0.97748581000917223, 0.97750778943561045, 0.977518776640798, 0.97754074603223284, 0.9775517282173195, 0.97756270872787943, 0.97758466472308092, 0.97759564020656897, 0.97761758614240957, 0.97762855659361214, 0.97763952536621324, 0.97765049245963853, 0.97767242160663903, 0.97768338365904794, 0.97769434402995514, 0.97770530271878153, 0.97772721504784177, 0.97773816868692209, 0.97776007091123163, 0.97777101949531176, 0.97778196639322368, 0.97779291160438708, 0.97781479696412466, 0.97782573711153076, 0.97783667556985399, 0.97784761233850515, 0.97785854741689027, 0.97788041250056879, 0.97789134250468179, 0.97790227081619774, 0.97791319743453531, 0.97793504558929867, 0.97794596712455739, 0.97796780510791503, 0.97797872155483356, 0.97798963630445701, 0.97800054935620173, 0.97801146070949097, 0.97802237036372341, 0.97803327831831111, 0.97804418457268072, 0.97805508912623396, 0.97807689312852886, 0.97808779257609868, 0.97809869032049612, 0.97810958636113188, 0.97812048069742097, 0.97813137332877464, 0.97814226425459672, 0.97815315347429455, 0.97816404098728815, 0.9781749267929829, 0.97819669328011616, 0.97820757396036528, 0.97821845293096132, 0.97822933019130021, 0.97824020574079684, 0.9782510795788486, 0.9782619517048744, 0.97827282211828803, 0.97828369081849109, 0.97829455780487673, 0.9783054230768804, 0.97831628663388959, 0.97832714847530544, 0.9783380086005603, 0.97834886700904344, 0.9783597237001489, 0.97837057867331467, 0.97838143192792826, 0.97839228346338936, 0.97840313327913186, 0.97841398137451685, 0.97842482774899053, 0.97843567240193885, 0.97844651533276661, 0.97845735654088573, 0.9784681960256949, 0.9784790337866015, 0.97848986982301489, 0.97850070413433099, 0.97851153671995439, 0.9785223675792859, 0.97853319671174177, 0.97854402411672059, 0.97855484979362239, 0.97856567374184067, 0.97857649596078922, 0.97858731644986852, 0.97859813520849137, 0.97860895223604638, 0.97861976753193103, 0.97861976753193103, 0.97863058109555734, 0.97864139292634222, 0.97865220302364564, 0.97866301138690437, 0.97866301138690437, 0.97867381801551157, 0.97868462290886371, 0.97869542606635662, 0.978706227487397, 0.97871702717138587, 0.9787278251177276, 0.97873862132579992, 0.97874941579504038, 0.97876020852481749, 0.97876020852481749, 0.97877099951454849, 0.9787817887636131, 0.97879257627143224, 0.97880336203739493, 0.97880336203739493, 0.97881414606088557, 0.97882492834132873, 0.97883570887810356, 0.97884648767060867, 0.97884648767060867, 0.9788572647182604, 0.97886804002043259, 0.9788788135765506, 0.97888958538596738, 0.97888958538596738, 0.97890035544813414, 0.97891112376240907, 0.97892189032820187, 0.97893265514490679, 0.97893265514490679, 0.97894341821192077, 0.97895417952863895, 0.97896493909446181, 0.9789756969087775, 0.9789756969087775, 0.97898645297099118, 0.97899720728049144, 0.97900795983667543, 0.97901871063893497, 0.97901871063893497, 0.97902945968667399, 0.97904020697927174, 0.97905095251612617, 0.97906169629665141, 0.97906169629665141, 0.97907243832022062, 0.97908317858623362, 0.97909391709408133, 0.97910465384315715, 0.97910465384315715, 0.97911538883286009, 0.97912612206258187, 0.97913685353170599, 0.97914758323963846, 0.97914758323963846, 0.97915831118576935, 0.9791690373694788, 0.9791797617901643, 0.9791797617901643, 0.97919048444724111, 0.97919048444724111, 0.97920120534006094, 0.97921192446803973, 0.97922264183056162, 0.97922264183056162, 0.97923335742701778, 0.97924407125680879, 0.97925478331930982, 0.97925478331930982, 0.9792654936139239, 0.9792654936139239, 0.97927620214003852, 0.97928690889704262, 0.97929761388431646, 0.97929761388431646, 0.97930831710126331, 0.97931901854726866, 0.97932971822171377, 0.97932971822171377, 0.97934041612400358, 0.97934041612400358, 0.97935111225351379, 0.97936180660964367, 0.97937249919177116, 0.97937249919177116, 0.97938318999928597, 0.97939387903158592, 0.97940456628805128, 0.97940456628805128, 0.97941525176807054, 0.97941525176807054, 0.97942593547103052, 0.97943661739632049, 0.97944729754332149, 0.97944729754332149, 0.97945797591143813, 0.97946865250004178, 0.97947932730852483, 0.97947932730852483, 0.97949000033626665, 0.97949000033626665, 0.9795006715826502, 0.97951134104707938, 0.97952200872892325, 0.97952200872892325, 0.97953267462758087, 0.97954333874242616, 0.97955400107285007, 0.97955400107285007, 0.97956466161824718, 0.97956466161824718, 0.97957532037798067, 0.97958597735144726, 0.97958597735144726, 0.97959663253802631, 0.97959663253802631, 0.97960728593710633, 0.97961793754807791, 0.97961793754807791, 0.97962858737031988, 0.97962858737031988, 0.97963923540319719, 0.97964988164612954, 0.97964988164612954, 0.97966052609847887, 0.97966052609847887, 0.97967116875961813, 0.9796818096289488, 0.9796924487058527, 0.9796924487058527, 0.97970308598970113, 0.97971372147987612, 0.97972435517577205, 0.97972435517577205, 0.97973498707675799, 0.97973498707675799, 0.97974561718222752, 0.9797562454915536, 0.97976687200412382, 0.97976687200412382, 0.97977749671931924, 0.97978811963650125, 0.97979874075507478, 0.97979874075507478, 0.97980936007441499, 0.97980936007441499, 0.97981997759389616, 0.97983059331290268, 0.97984120723081136, 0.97984120723081136, 0.97985181934701004, 0.9798624296608609, 0.97987303817176241, 0.97987303817176241, 0.97988364487907076, 0.97988364487907076, 0.97989424978219375, 0.97990485288049489, 0.97990485288049489, 0.97991545417335546, 0.97991545417335546, 0.97992605366014529, 0.97993665134025254, 0.97993665134025254, 0.97994724721304927, 0.97994724721304927, 0.97995784127790597, 0.97996843353423135, 0.97997902398136072, 0.97997902398136072, 0.97998961261870432, 0.98000019944561323, 0.98001078446148626, 0.98001078446148626, 0.98002136766569237, 0.98002136766569237, 0.98003194905760793, 0.98004252863660124, 0.98005310640205268, 0.98005310640205268, 0.9800636823533404, 0.98007425648984203, 0.98008482881092474, 0.98008482881092474, 0.98009539931596668, 0.98009539931596668, 0.9801059680043539, 0.98011653487544692, 0.98012709992862135, 0.98012709992862135, 0.98013766316326645, 0.9801482245787394, 0.98015878417441571, 0.98016934194967298, 0.98016934194967298, 0.98017989790388849, 0.98019045203642918, 0.98020100434668544, 0.98021155483399602, 0.98021155483399602, 0.98022210349777139, 0.98023265033735174, 0.98024319535212323, 0.98025373854146092, 0.98025373854146092, 0.98026427990474363, 0.98027481944132044, 0.98028535715057719, 0.98029589303189357, 0.98029589303189357, 0.98030642708462179, 0.980316959308141, 0.9803274897018236, 0.98033801826504441, 0.98033801826504441, 0.98034854499716384, 0.98035906989755262, 0.98036959296558868, 0.9803801142006473, 0.98039063360207901, 0.98040115116925863, 0.98041166690156401, 0.98042218079835519, 0.98043269285899814, 0.98043269285899814, 0.98044320308288002, 0.98045371146934945, 0.98046421801778316, 0.98047472272754965, 0.98047472272754965, 0.980485225598004, 0.98049572662853168, 0.98050622581850311, 0.98051672316726224, 0.98052721867419168, 0.9805377123386364, 0.98054820415999933, 0.98055869413762375, 0.98056918227087841, 0.98057966855913248, 0.98059015300175312, 0.98060063559809418, 0.98061111634754028, 0.98062159524942905, 0.98063207230315519, 0.98064254750806745, 0.98065302086352391, 0.98066349236890538, 0.98067396202356216, 0.98068442982686133, 0.98069489577817104, 0.98070535987685237, 0.98071582212226394, 0.98072628251376648, 0.98073674105074782, 0.98074719773254171, 0.98075765255851743, 0.98076810552804206, 0.98077855664046643, 0.9807890058951797, 0.98079945329151252, 0.98080989882884673, 0.98082034250651995, 0.98083078432391702, 0.98085166237530186, 0.98086209860800111, 0.98087253297786914, 0.98088296548424481, 0.98089339612650039, 0.98090382490398575, 0.98091425181606662, 0.98092467686210438, 0.98093510004145212, 0.98094552135347413, 0.98096635837295221, 0.98097677407913453, 0.9809871879154245, 0.98099759988116508, 0.98100800997573001, 0.98101841819846214, 0.98102882454874152, 0.98103922902589391, 0.98104963162929693, 0.98106003235830863, 0.98108082819054343, 0.98109122329249188, 0.98110161651746564, 0.98111200786481279, 0.98112239733390039, 0.98114317063469436, 0.98115355446511165, 0.98116393641468391, 0.98117431648276243, 0.98118469466870772, 0.98120544539158405, 0.98121581792723922, 0.98122618857815369, 0.98123655734370308, 0.98124692422322168, 0.98126765232162005, 0.98127801353920852, 0.98128837286816628, 0.98129873030787029, 0.98130908585766641, 0.98132979128492992, 0.98134014116110124, 0.98135048914477119, 0.98136083523527295, 0.98137117943197838, 0.98138152173422999, 0.98139186214137308, 0.98140220065275208, 0.98141253726771316, 0.98142287198563427, 0.98144353572768339, 0.98145386475051122, 0.98146419187367639, 0.98147451709651701, 0.98148484041839046, 0.98150548135662341, 0.98151579897167474, 0.98152611468313644, 0.98153642849038114, 0.98154674039272061, 0.98156735848012733, 0.98157766466389218, 0.98158796894013933, 0.98159827130823774, 0.9816085717675197, 0.98162916695701863, 0.98163946168592153, 0.98164975450340375, 0.98166004540879115, 0.98167033440141227, 0.98169090664581371, 0.98170118989626842, 0.98171147123134861, 0.98172175065039513, 0.98173202815275062, 0.98175257740478095, 0.98176284915312551, 0.98177311898215158, 0.9817833868912067, 0.98179365287960796, 0.9818141790918854, 0.98182443931442753, 0.98183469761369413, 0.98184495398903848, 0.98185520843977847, 0.98187571156483888, 0.98188596023783536, 0.98189620698360358, 0.98190645180146185, 0.98191669469077181, 0.98193717468106378, 0.98194741178072875, 0.98195764694918131, 0.98196788018577708, 0.98197811148984249, 0.98199856829770227, 0.98200879380020456, 0.98201901736750596, 0.98202923899897376, 0.98203945869391684, 0.98205989227163371, 0.982070106153073, 0.98208031809533591, 0.98209052809776731, 0.98210073615970939, 0.98212114645943882, 0.98213134869589458, 0.98214154898917683, 0.98215174733864175, 0.98216194374361132, 0.98218233071741279, 0.98219252128489898, 0.98220270990522784, 0.98221289657773869, 0.98222308130173996, 0.98224344490158766, 0.98225362377610004, 0.98226380069942931, 0.98227397567093133, 0.982294319755739, 0.98230448886771449, 0.98232482122742448, 0.98233498447384437, 0.98234514576372067, 0.98235530509640601, 0.98237561788750827, 0.98238577134458971, 0.9823959228417718, 0.98240607237840782, 0.98241621995381889, 0.98242636556733876, 0.98243650921827741, 0.98244665090597694, 0.98245679062976832, 0.98246692838897065, 0.98248719801090723, 0.98249732987230065, 0.98250745976640652, 0.98251758769256459, 0.98252771365009173, 0.98254795965656117, 0.98255807970414311, 0.9825681977803925, 0.98257831388465222, 0.98258842801621438, 0.98260865035860301, 0.98261875856808156, 0.98262886480215506, 0.98263896906018089, 0.98264907134145696, 0.98266926997108639, 0.98267936631808139, 0.98268946068562812, 0.98269955307305112, 0.98271973190479334, 0.98272981834775808, 0.98274998528447599, 0.98276006577687713, 0.98277014428439269, 0.9827802208063442, 0.9828003678908549, 0.98281043845204696, 0.98282050702496326, 0.98283057360890269, 0.98284063820320777, 0.98286076142015033, 0.98287082004142556, 0.98288087667033031, 0.98289093130618543, 0.98290098394830128, 0.98292108324859517, 0.98293112990539311, 0.98294117456573749, 0.98295121722891732, 0.9829612578942627, 0.98298133322872194, 0.98299136789644981, 0.98300140056361252, 0.98301143122951429, 0.98302145989345924, 0.98304151121279149, 0.98305153386680044, 0.98306155451611632, 0.98307157316006144, 0.9830815897979549, 0.98310161705277932, 0.9831116276683507, 0.98312163627512328, 0.98313164287238852, 0.98314164745947485, 0.98316165060033867, 0.98317164915273714, 0.98318164569218736, 0.98319164021801475, 0.98320163272952787, 0.98322161170684175, 0.98323159817126005, 0.98324158261860539, 0.98325156504817834, 0.98326154545929534, 0.98327152385125594, 0.98328150022338145, 0.98329147457496169, 0.98330144690534338, 0.98331141721379878, 0.98333135176218212, 0.98334131600074259, 0.98335127821461132, 0.9833612384031023, 0.9833711965655213, 0.98338115270118276, 0.98339110680937414, 0.98340105888941887, 0.98341100894061995, 0.98342095696228171, 0.9834408469141982, 0.98345078884306447, 0.9834607287396091, 0.98347066660313653, 0.98348060243295998, 0.9835004679886884, 0.98351039771319104, 0.9835203254012127, 0.9835302510520294, 0.98354017466495469, 0.98355009623930123, 0.9835600157743587, 0.98356993326942987, 0.9835798487238262, 0.98358976213683913, 0.98359967350776578, 0.9836095828359297, 0.98361949012060967, 0.98362939536111682, 0.98363929855675269, 0.98365909881059865, 0.98366899586741441, 0.9836788908765608, 0.98368878383732283, 0.98369867474901329, 0.98370856361091497, 0.98371845042236239, 0.98372833518261449, 0.9837382178909907, 0.98374809854678569, 0.9837579771492917, 0.98376785369781827, 0.98377772819164044, 0.98378760063007387, 0.98379747101242665, 0.98381720560600172, 0.98382706981584089, 0.98383693196676503, 0.98384679205807424, 0.98385665008906686, 0.98386650605902726, 0.98387635996725975, 0.98388621181305713, 0.98389606159571441, 0.98390590931453858, 0.9839157549688039, 0.98392559855781536, 0.98393544008086031, 0.98394527953722399, 0.98395511692622295, 0.98396495224712865, 0.98397478549925843, 0.98398461668187642, 0.98399444579427919, 0.98400427283578584, 0.98400427283578584, 0.98401409780565663, 0.98402392070319822, 0.9840337415277044, 0.98404356027844908, 0.98404356027844908, 0.98405337695474016, 0.98406319155587196, 0.98407300408111786, 0.98408281452978585, 0.98408281452978585, 0.98409262290114818, 0.98410242919450064, 0.98411223340913156, 0.98411223340913156, 0.98412203554432898, 0.98412203554432898, 0.98413183559940209, 0.98414163357362738, 0.98414163357362738, 0.98415142946626843, 0.98415142946626843, 0.98416122327664757, 0.98417101500403481, 0.98418080464771329, 0.98419059220698257, 0.98420037768114588, 0.98421016106945791, 0.98421994237121868, 0.98422972158571753, 0.98422972158571753, 0.98423949871222638, 0.98424927375004911, 0.98425904669848097, 0.9842688175567833, 0.98427858632424148, 0.98428835300016049, 0.98429811758380514, 0.98430788007446945, 0.98431764047144055, 0.98432739877401265, 0.98433715498144037, 0.98434690909302891, 0.98435666110805731, 0.9843664110258088, 0.98437615884556695, 0.98438590456660136, 0.98439564818822145, 0.98440538970968339, 0.98441512913028273, 0.98441512913028273, 0.98442486644931104, 0.9844346016660267, 0.98444433477971727, 0.98445406578967287, 0.98445406578967287, 0.98446379469517009, 0.98447352149549072, 0.98448324618991556, 0.98449296877772396, 0.98449296877772396, 0.98450268925819262, 0.98451240763060166, 0.98452212389422478, 0.98453183804836319, 0.98453183804836319, 0.98454155009227828, 0.98455126002524851, 0.98456096784655178, 0.98456096784655178, 0.98457067355547001, 0.98457067355547001, 0.98458037715128477, 0.98459007863326831, 0.98459007863326831, 0.98459977800070486, 0.98459977800070486, 0.98460947525286246, 0.98461917038901903, 0.98461917038901903, 0.98462886340845623, 0.98462886340845623, 0.98463855431045388, 0.98464824309428189, 0.98464824309428189, 0.98465792975921584, 0.98465792975921584, 0.98466761430453731, 0.98467729672950388, 0.98467729672950388, 0.98468697703341401, 0.98468697703341401, 0.98469665521553629, 0.98470633127515272, 0.98470633127515272, 0.98471600521151148, 0.98471600521151148, 0.98472567702390779, 0.98472567702390779, 0.98473534671160778, 0.98473534671160778, 0.98474501427388983, 0.98474501427388983, 0.98475467971003872, 0.98475467971003872, 0.98476434301929661, 0.98476434301929661, 0.9847740042009604, 0.9847740042009604, 0.98478366325430922, 0.98478366325430922, 0.98479332017860077, 0.98479332017860077, 0.9848029749731072, 0.9848029749731072, 0.9848126276371002, 0.9848126276371002, 0.98482227816986967, 0.98482227816986967, 0.98483192657066376, 0.98483192657066376, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.98486085897396802, 0.98486085897396802, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488013656966733, 0.98488013656966733, 0.98487049883962519, 0.98487049883962519, 0.98486085897396802, 0.9848512169734559, 0.9848512169734559, 0.98484157283877427, 0.98483192657066376, 0.98482227816986967, 0.9848126276371002, 0.9848029749731072, 0.98479332017860077, 0.98478366325430922, 0.9847740042009604, 0.98475467971003872, 0.98474501427388983, 0.98472567702390779, 0.98471600521151148, 0.98469665521553629, 0.98467729672950388, 0.98465792975921584, 0.98463855431045388, 0.98461917038901903])[np.newaxis,:]

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=90)
PD_tav90n = np.array([0.90653555629922788, 0.90653555629922788, 0.90653555629922788, 0.90653555629922788, 0.90653555629922788, 0.90653555629922788, 0.90663803031057333, 0.90674052763816237, 0.90682840108216167, 0.90693094183038703, 0.90703350602345822, 0.90710678054052052, 0.90718006705904697, 0.90726802674670992, 0.90734133972728293, 0.90741466476291688, 0.90748800187049561, 0.90754668025973184, 0.90762003913950962, 0.90767873496855644, 0.90775211567574843, 0.90779614993112212, 0.90784018856431914, 0.90789891355831065, 0.90794296242093009, 0.90798701567381468, 0.90803107332071353, 0.90807513536538109, 0.9081045125068905, 0.90814858188953607, 0.9081926556800124, 0.90822204065765044, 0.90826612180290289, 0.90829551168724665, 0.90833960019783921, 0.90836899499592882, 0.90839839176150372, 0.90842779049568001, 0.90845719119960178, 0.90848659387441155, 0.9085159985212341, 0.90856010919149477, 0.90860422430521404, 0.90863363685152387, 0.90867775937957729, 0.90872188636140638, 0.90875130682551997, 0.90878072927196041, 0.90882486666100948, 0.90885429406832663, 0.90888372346201263, 0.9089131548432331, 0.90894258821314344, 0.90897202357290474, 0.90900146092369494, 0.90903090026666233, 0.90906034160299098, 0.90907506301902741, 0.9091045073475682, 0.90911923026036989, 0.9091486775837776, 0.90917812690521282, 0.90919285231556812, 0.90922230463626907, 0.90923703154691426, 0.90926648686952882, 0.90928121528179595, 0.90929594419489512, 0.90932540352419577, 0.90934013394069213, 0.90935486485861328, 0.90936959627811087, 0.90939906062242626, 0.90941379354753871, 0.90944326090442318, 0.90945799533649185, 0.9094727302711787, 0.90948746570863082, 0.9095169380924254, 0.90953167503906207, 0.90954641248906587, 0.90956115044258246, 0.90959062786074718, 0.9096053673257023, 0.90963484776808823, 0.90964958874582058, 0.9096643302281191, 0.90969381470700772, 0.90970855770389358, 0.90973804521331414, 0.90975278972614837, 0.90976753474460104, 0.90979702629895931, 0.90981177283517078, 0.90984126742641569, 0.90985601548175321, 0.90988551311260468, 0.90991501277138931, 0.90992976336163267, 0.90995926606459432, 0.90998877079852458, 0.91001827756465126, 0.91004778636420403, 0.9100625415268917, 0.91009205337887233, 0.91012156726733584, 0.91015108319351212, 0.91018060115863886, 0.91021012116394362, 0.91023964321066264, 0.9102691673000336, 0.91029869343329683, 0.91034298646819267, 0.91037251771660266, 0.91041681843005418, 0.91044635480139213, 0.91049066320508598, 0.91052020470715855, 0.91056452081281669, 0.9105940674534565, 0.91063839127284929, 0.910682719726154, 0.9107270528176219, 0.91075661079080428, 0.91080095162204544, 0.91084529710286377, 0.91088964723754473, 0.91093400203039598, 0.91097836148572864, 0.91102272560785691, 0.91106709440112299, 0.91111146786985475, 0.91115584601840993, 0.91121502417039568, 0.91125941325548632, 0.91130380703495717, 0.91134820551319096, 0.91140741080096999, 0.91145182026011984, 0.91151104020512907, 0.9115554606692422, 0.91159988585716512, 0.91165912679690475, 0.91170356302437339, 0.91176281869972275, 0.9118072659910903, 0.91186653643459703, 0.91191099481432947, 0.9119702800587004, 0.91201474955139894, 0.91207404962950556, 0.91213335819885655, 0.91217784520475242, 0.91223716865982474, 0.91228166684248269, 0.91234100521656414, 0.91240035213080106, 0.9124597075961558, 0.91251907162361157, 0.91257844422418444, 0.91263782540892713, 0.91269721518891977, 0.91275661357526583, 0.91281602057911004, 0.91287543621163536, 0.9129348604840446, 0.91299429340757077, 0.9130537349934883, 0.91309832187441253, 0.91315777864672099, 0.91321724411257743, 0.91327671828337276, 0.91333620117052638, 0.91338081906288981, 0.91344031723125729, 0.91349982414756326, 0.91355933982334514, 0.91361886427019579, 0.91366351336832163, 0.91372305319248348, 0.91378260181971394, 0.91384215926171231, 0.91390172553021265, 0.91394640603106547, 0.91400598777428421, 0.91406557837645575, 0.91411027714890225, 0.91416988328279047, 0.91421459371769476, 0.91427421541979714, 0.91431893754461024, 0.91436366468781149, 0.9144083968544896, 0.91445313404972184, 0.91449787627861601, 0.91454262354627602, 0.91458737585782857, 0.91463213321839665, 0.91466197426632745, 0.91470674005336849, 0.91475151090316564, 0.91479628682089398, 0.91484106781172847, 0.91487092462657715, 0.91491571408415473, 0.91496050862872202, 0.91499037448711384, 0.91503517752160857, 0.91506504904480412, 0.91510986058378563, 0.91513973778151336, 0.91516961725177504, 0.91521444072160796, 0.91524432588007709, 0.91528915788956233, 0.91531904874603753, 0.91534894188447147, 0.91537883730644698, 0.91542368472448687, 0.91545358586221781, 0.91548348928901557, 0.9155133950064771, 0.91554330301619502, 0.91557321331975638, 0.91560312591875559, 0.91563304081478569, 0.91566295800944841, 0.91567791746926686, 0.91570783811488887, 0.91572279930108957, 0.91575272340126823, 0.91576768631565342, 0.91579761387401626, 0.91581257851839815, 0.9158425095385726, 0.91585747591476219, 0.91587244286863223, 0.91588741040037802, 0.91590237851020595, 0.91591734719830131, 0.91593231646489925, 0.91594728631016886, 0.91596225673433973, 0.91596225673433973, 0.91597722773760293, 0.91599219932016196, 0.91600717148221544, 0.91600717148221544, 0.91602214422397521, 0.91602214422397521, 0.91603711754564277, 0.91603711754564277, 0.91605209144742383, 0.91605209144742383, 0.91606706592951248, 0.91606706592951248, 0.91608204099212887, 0.91608204099212887, 0.91609701663546006, 0.91609701663546006, 0.91611199285972478, 0.91611199285972478, 0.91611199285972478, 0.9161269696651213, 0.9161269696651213, 0.9161269696651213, 0.91614194705185747, 0.91614194705185747, 0.91615692502012991, 0.91615692502012991, 0.91617190357015288, 0.91617190357015288, 0.91618688270212523, 0.91618688270212523, 0.91620186241625434, 0.91620186241625434, 0.91621684271275039, 0.91623182359180666, 0.91623182359180666, 0.91624680505364475, 0.91626178709846562, 0.91627676972646466, 0.91627676972646466, 0.91629175293785792, 0.91629175293785792, 0.91630673673284924, 0.91632172111164867, 0.91633670607445628, 0.91633670607445628, 0.91635169162148733, 0.91636667775293734, 0.91638166446901947, 0.91638166446901947, 0.916396651769944, 0.916396651769944, 0.91641163965591299, 0.9164266281271416, 0.91644161718382988, 0.91644161718382988, 0.91645660682618668, 0.91647159705442438, 0.91648658786874249, 0.91650157926935916, 0.91651657125647779, 0.91653156383030576, 0.91654655699105869, 0.91656155073893908, 0.91657654507415021, 0.91660653550743554, 0.91662153160592441, 0.91663652829258724, 0.91666652343126809, 0.91668152188371821, 0.91671152055586225, 0.91672652077598915, 0.91675652298538635, 0.91678652755505696, 0.91680153072552384, 0.91683153883877733, 0.91684654378198105, 0.91687655544263325, 0.9169065694703189, 0.91693658586675719, 0.91696660463364021, 0.91699662577268204, 0.91702664928558086, 0.91705667517404621, 0.91708670343979426, 0.9171017184646808, 0.91713175029956107, 0.91716178451601205, 0.91719182111574926, 0.91722186010050422, 0.91723688048779828, 0.91726692305330215, 0.91729696800814353, 0.9173270153540386, 0.91735706509272863, 0.91737209085991678, 0.91740214419105914, 0.917432199919342, 0.91746225804650938, 0.91747728801022332, 0.91750734973898296, 0.91752238150447374, 0.9175524468387688, 0.91756748040801261, 0.91758251457894513, 0.91761258472675367, 0.91762762070406845, 0.91764265728395267, 0.91767273225230994, 0.91768777064122287, 0.91771784922959787, 0.91773288942952203, 0.91776297164191845, 0.91777801365484479, 0.91779305627254026, 0.91782314332314185, 0.91783818775649895, 0.917853232795524, 0.91786827844042718, 0.91788332469143485, 0.91789837154878517, 0.9179134190126863, 0.91792846708336129, 0.91794351576103972, 0.9179585650459422, 0.9179585650459422, 0.91797361493828722, 0.91798866543830848, 0.91798866543830848, 0.91800371654621804, 0.91800371654621804, 0.91801876826225204, 0.91801876826225204, 0.91801876826225204, 0.91801876826225204, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91801876826225204, 0.91801876826225204, 0.91800371654621804, 0.91800371654621804, 0.91800371654621804, 0.91800371654621804, 0.91798866543830848, 0.91798866543830848, 0.91798866543830848, 0.91798866543830848, 0.91797361493828722, 0.91797361493828722, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.91794351576103972, 0.91794351576103972, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.9179134190126863, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91792846708336129, 0.91794351576103972, 0.91794351576103972, 0.91794351576103972, 0.91794351576103972, 0.91794351576103972, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.9179585650459422, 0.91797361493828722, 0.91797361493828722, 0.91797361493828722, 0.91797361493828722, 0.91798866543830848, 0.91798866543830848, 0.91800371654621804, 0.91800371654621804, 0.91800371654621804, 0.91800371654621804, 0.91801876826225204, 0.91801876826225204, 0.91801876826225204, 0.91801876826225204, 0.91801876826225204, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91803382058662297, 0.91804887351957032, 0.91804887351957032, 0.9180639270612998, 0.9180639270612998, 0.9180639270612998, 0.9180639270612998, 0.91807898121205311, 0.91807898121205311, 0.91807898121205311, 0.91807898121205311, 0.9180940359720432, 0.9180940359720432, 0.91810909134150032, 0.91810909134150032, 0.91810909134150032, 0.91810909134150032, 0.91812414732064374, 0.91812414732064374, 0.91812414732064374, 0.91812414732064374, 0.9181392039097076, 0.9181392039097076, 0.91815426110891418, 0.91815426110891418, 0.91815426110891418, 0.91815426110891418, 0.91816931891848452, 0.91816931891848452, 0.91816931891848452, 0.91816931891848452, 0.91818437733864677, 0.91818437733864677, 0.91819943636963397, 0.91819943636963397, 0.91819943636963397, 0.91821449601165694, 0.91821449601165694, 0.91822955626495739, 0.91822955626495739, 0.91824461712974803, 0.91824461712974803, 0.91825967860627289, 0.91825967860627289, 0.9182747406947418, 0.9182747406947418, 0.91828980339539168, 0.91828980339539168, 0.91830486670844014, 0.91830486670844014, 0.91830486670844014, 0.9183199306341252, 0.9183199306341252, 0.91833499517266559, 0.91833499517266559, 0.91833499517266559, 0.91835006032430255, 0.91835006032430255, 0.91836512608923804, 0.91836512608923804, 0.91836512608923804, 0.91838019246772817, 0.91838019246772817, 0.91839525945999068, 0.91839525945999068, 0.91839525945999068, 0.91841032706624059, 0.91841032706624059, 0.91842539528672451, 0.91842539528672451, 0.91844046412166036, 0.91844046412166036, 0.91845553357128451, 0.91845553357128451, 0.91847060363582111, 0.91848567431550099, 0.91848567431550099, 0.91850074561054385, 0.91850074561054385, 0.9185158175211896, 0.91853089004767363, 0.91853089004767363, 0.91854596319020687, 0.91854596319020687, 0.91856103694904001, 0.91857611132438777, 0.91857611132438777, 0.91859118631648751, 0.91859118631648751, 0.91860626192556372, 0.91862133815185287, 0.91863641499557824, 0.91863641499557824, 0.9186514924569873, 0.91866657053628664, 0.91868164923372553, 0.91868164923372553, 0.91869672854953288, 0.91869672854953288, 0.91871180848393497, 0.91872688903716981, 0.9187419702094598, 0.9187419702094598, 0.91875705200104252, 0.91877213441215844, 0.91878721744302261, 0.91880230109388328, 0.91880230109388328, 0.91881738536496382, 0.9188324702564965, 0.91884755576872301, 0.91886264190186939, 0.91886264190186939, 0.91887772865617556, 0.91889281603186557, 0.91890790402918021, 0.9189229926483462, 0.9189229926483462, 0.91893808188960657, 0.91895317175319535, 0.91896826223934025, 0.91898335334827075, 0.91899844508024109, 0.91901353743547154, 0.9190286304141928, 0.91904372401665591, 0.91905881824308788, 0.91905881824308788, 0.919073913093719, 0.91908900856879061, 0.91910410466854386, 0.91911920139321057, 0.91913429874301855, 0.91914939671821361, 0.91916449531902988, 0.91917959454571097, 0.91919469439848212, 0.91919469439848212, 0.91920979487758814, 0.9192248959832614, 0.91923999771573983, 0.91925510007526878, 0.91927020306207829, 0.91928530667640529, 0.91930041091849901, 0.91931551578857928, 0.91933062128690812, 0.91934572741370224, 0.91936083416921188, 0.91937594155367008, 0.91939104956732187, 0.91940615821040761, 0.91942126748316233, 0.91943637738582573, 0.91945148791863995, 0.91946659908184725, 0.91948171087567532, 0.91951193635620143, 0.91952705004337043, 0.91954216436213398, 0.91955727931272768, 0.91957239489539944, 0.91958751111039061, 0.91960262795793546, 0.9196177454382819, 0.91963286355167195, 0.91964798229834832, 0.91966310167854837, 0.91967822169252078, 0.9196933423405016, 0.91970846362273773, 0.91972358553948064, 0.91975383127741606, 0.91976895509910761, 0.91978407955627195, 0.91979920464915044, 0.91981433037798888, 0.91984458374452593, 0.9198597113827085, 0.91987483965783312, 0.9198899685701375, 0.91990509811988108, 0.91992022830728915, 0.9199353591326177, 0.91995049059611156, 0.91996562269801696, 0.91998075543858526, 0.92001102283666447, 0.92002615749467365, 0.92004129279233804, 0.92005642872987348, 0.92007156530756207, 0.9201018403843273, 0.92011697888391342, 0.92013211802462214, 0.92014725780670603, 0.92016239823041779, 0.920192681003699, 0.92020782335376783, 0.92022296634645939, 0.9202381099820186, 0.92025325426069615, 0.92028354474840057, 0.92029869095792372, 0.92031383781156606, 0.92032898530958041, 0.92034413345220634, 0.92037443167231781, 0.92038958175029906, 0.92040473247390175, 0.92041988384337703, 0.92043503585897479, 0.92046534182955242, 0.92048049578503122, 0.92049565038764181, 0.9205108056376391, 0.92052596153527388, 0.92055627527445494, 0.92057143311651646, 0.92058659160722422, 0.92060175074683626, 0.92061691053559336, 0.92064723206161669, 0.92066239379937198, 0.92067755618730396, 0.9206927192256652, 0.92070788291470695, 0.92073821224585739, 0.92075337788847433, 0.92076854418279486, 0.92078371112908064, 0.92079887872758093, 0.92081404697854774, 0.92082921588224331, 0.92084438543892289, 0.92085955564884703, 0.92087472651226865, 0.92090507020062784, 0.92092024302609299, 0.92093541650607158, 0.92095059064084128, 0.92096576543065789, 0.92098094087576998, 0.92099611697644024, 0.92101129373293911, 0.92102647114550362, 0.92104164921441922, 0.92107200732228123, 0.92108718736174211, 0.92110236805858947, 0.92111754941307022, 0.92113273142543783, 0.92116309742491531, 0.92117828141253388, 0.92119346605908592, 0.92120865136483698, 0.92122383733004898, 0.92123902395497903, 0.9212542112398896, 0.92126939918505135, 0.92128458779070455, 0.92129977705713928, 0.92133015757334857, 0.92134534882366803, 0.92136054073578477, 0.92137573331000311, 0.92139092654655519, 0.92140612044571624, 0.92142131500775648, 0.92143651023292794, 0.9214517061215044, 0.92146690267374076, 0.92149729777027289, 0.92151249631509757, 0.92152769552464275, 0.92154289539917145, 0.92155809593897509, 0.92157329714427572, 0.9215884990153802, 0.92160370155253346, 0.92161890475599861, 0.92163410862605533, 0.92164931316295773, 0.92166451836699159, 0.92167972423840416, 0.92169493077746856, 0.92171013798445889, 0.92172534585963184, 0.92174055440326508, 0.92175576361562428, 0.92177097349697934, 0.92178618404758417, 0.92181660715766811, 0.92183181971767314, 0.92184703294801662, 0.92186224684896878, 0.92187746142080029, 0.92189267666376618, 0.92190789257816086, 0.92192310916422837, 0.92193832642226192, 0.92195354435251897, 0.92196876295527208, 0.92198398223080114, 0.92199920217936204, 0.92201442280124013, 0.9220296440966933, 0.92204486606600988, 0.9220600887094561, 0.92207531202729376, 0.92209053601980473, 0.92210576068725725, 0.92212098602993509, 0.92213621204809482, 0.92215143874201821, 0.92216666611198339, 0.92218189415826202, 0.92219712288111266, 0.92221235228083409, 0.9222275823576821, 0.92224281311193801, 0.92225804454386906, 0.92227327665375847, 0.92228850944188212, 0.92230374290851114, 0.92231897705392807, 0.92233421187840336, 0.92236468356561707, 0.92237992042891415, 0.92239515797237337, 0.92241039619627418, 0.92242563510089137, 0.92244087468649139, 0.92245611495337898, 0.92247135590179496, 0.92248659753205042, 0.92250183984440293, 0.92251708283913847, 0.92253232651653705, 0.92254757087686912, 0.92256281592041589, 0.92257806164746137, 0.92260855515315354, 0.92262380293235902, 0.92263905139617752, 0.92265430054489339, 0.92266955037878773, 0.92268480089812621, 0.92270005210319883, 0.92271530399429569, 0.92273055657168079, 0.92274580983564003, 0.92276106378645872, 0.92277631842441699, 0.92279157374980691, 0.92280682976289541, 0.92282208646396202, 0.92283734385330785, 0.92285260193120644, 0.92286786069793481, 0.92288312015378349, 0.92289838029901994, 0.92292890265885075, 0.92294416487399888, 0.9229594277796811, 0.92297469137618404, 0.92298995566379627, 0.92300522064279245, 0.92302048631347045, 0.9230357526760905, 0.92305101973097159, 0.92306628747838282, 0.92308155591859919, 0.92309682505191759, 0.92311209487863999, 0.92312736539901685, 0.92314263661337004, 0.92317318112509505, 0.9231884544230512, 0.9232037284161082, 0.92321900310456906, 0.92323427848871664, 0.92324955456883318, 0.9232648313452172, 0.92328010881814992, 0.92329538698792335, 0.92331066585482091, 0.92332594541913227, 0.92334122568115951, 0.92335650664117375, 0.92337178829948718, 0.92338707065637093, 0.92341763746702443, 0.92343292192137449, 0.92344820707546293, 0.92346349292959062, 0.92347877948403267, 0.92349406673908452, 0.92350935469504203, 0.92352464335220152, 0.92353993271084012, 0.92355522277127444, 0.9235705135337624, 0.92358580499863141, 0.92360109716616212, 0.92361639003663487, 0.92363168361036208, 0.92364697788762395, 0.92366227286872593, 0.92367756855394267, 0.92369286494359315, 0.92370816203795869, 0.92372345983733595, 0.92373875834201558, 0.92375405755230466, 0.92376935746849198, 0.92378465809086219, 0.92379995941973114, 0.92381526145538317, 0.92383056419811393, 0.92384586764822374, 0.92386117180600846, 0.92387647667177131, 0.92389178224579882, 0.9239070885283851, 0.92392239551984567, 0.92393770322047186, 0.92396832075039192, 0.92398363058028521, 0.92399894112054726, 0.92401425237144608, 0.92402956433331251, 0.92404487700642879, 0.92406019039109166, 0.92407550448760922, 0.924090819296293, 0.92410613481741732, 0.92412145105129961, 0.92413676799823841, 0.92415208565853102, 0.9241674040324791, 0.92418272312038952, 0.92419804292255447, 0.92421336343930061, 0.92422868467090047, 0.92424400661764938, 0.92425932927988641, 0.92427465265789865, 0.92428997675196856, 0.92430530156242752, 0.92432062708957086, 0.92433595333369278, 0.92435128029510005, 0.92436660797410997, 0.92438193637102317, 0.92439726548612733, 0.9244125953197404, 0.92442792587216627, 0.92444325714370856, 0.92445858913468837, 0.9244739218453768, 0.92448925527611658, 0.9245045894271916, 0.9245199242989095, 0.92453525989158525, 0.92455059620552293, 0.92456593324102321, 0.92458127099840937, 0.9245966094779694, 0.92461194868002372, 0.92462728860487486, 0.92464262925283158, 0.92465797062420796, 0.9246733127193133, 0.92468865553844459, 0.92470399908192613, 0.92471934335004424, 0.9247346883431331, 0.92475003406149403, 0.92476538050544099, 0.9247807276752773, 0.92479607557130172, 0.92482677354323006, 0.92484212361973361, 0.92485747442368604, 0.92487282595540743, 0.92488817821519465, 0.92490353120336632, 0.92491888492022356, 0.92493423936609542, 0.92494959454129466, 0.92496495044611104, 0.9249803070808934, 0.92499566444592562, 0.9250110225415249, 0.92502638136802062, 0.92504174092572367, 0.92507246223599093, 0.92508782398918554, 0.92510318647484202, 0.92511854969328333, 0.9251339136448129, 0.92514927832975624, 0.92516464374841845, 0.92518000990112936, 0.92519537678819586, 0.92521074440994011, 0.92522611276667488, 0.92524148185872157, 0.92525685168639216, 0.92527222225002204, 0.92528759354990087, 0.92531833835973099, 0.92533371187031399, 0.9253490861184388, 0.92536446110442405, 0.92537983682857616, 0.9254105904927109, 0.92542596843331737, 0.92544134711338399, 0.92545672653322764, 0.9254721066931757, 0.9255028692346452, 0.92551825161681822, 0.92553363474037398, 0.92554901860563787, 0.92556440321292555, 0.9255951746548946, 0.92561056149021903, 0.92562594906886164, 0.92564133739114851, 0.92565672645740027, 0.92568750682311562, 0.92570289812323048, 0.9257182901686023, 0.92573368295957192, 0.92574907649645588, 0.92577986580928773, 0.92579526158588932, 0.92581065810969787, 0.92582605538106055, 0.92585685216773062, 0.92587225168369702, 0.92590305296252795, 0.92591845472604772, 0.92593385723940513, 0.92594926050293158, 0.92598006928180387, 0.92599547479781508, 0.92601088106530394, 0.92602628808461962, 0.92605710437999278, 0.9260725136567276, 0.92610333446992821, 0.9261187460070639, 0.92613415829832202, 0.92614957134404374, 0.92618039970020949, 0.92619581501130499, 0.92621123107820436, 0.92622664790122544, 0.92625748381695583, 0.92627290291034226, 0.92630374336983001, 0.92631916473660214, 0.92635000974584614, 0.92636543338900001, 0.92639628295404985, 0.92641170887661028, 0.92644256300349914, 0.92645799120850825, 0.92648884990329572, 0.92650428039376942, 0.92653514366253154, 0.92655057644150651, 0.92658144429033451, 0.92659687936086621, 0.92662775179586121, 0.92664318916100219, 0.92667406618826531, 0.92668950585106713, 0.92672038747674357, 0.92673582944028321, 0.92676671567048907, 0.92678215993784341, 0.92681305077876797, 0.92682849735300632, 0.9268593928107971, 0.92687484169502299, 0.92690574177586038, 0.92693664494217809, 0.92695209768324638, 0.92698300548296753, 0.92699846054228874, 0.92702937298160903, 0.92706028851746847, 0.92707574744746468, 0.92710666763333516, 0.9271221288899032, 0.92715305373204615, 0.92718398168185567, 0.92719944682300437, 0.92723037943954767, 0.92724584691563272, 0.92727678420521187, 0.9273077246136342, 0.92732319598830548, 0.92735414108029435, 0.9273696147983177, 0.92740056458019371, 0.92743151749220232, 0.92744699512288675, 0.92747795273536837, 0.92749343271787754, 0.92752439503723039, 0.92755536049801379, 0.92757084440734427, 0.9276018145856515, 0.92761730085533578, 0.92764827575756481, 0.92767925381264194, 0.92771023502344052, 0.92772572681311449, 0.9277567127628561, 0.92778770187547033, 0.92781869415385865, 0.92783419148109525, 0.9278651885135194, 0.92788068821941849, 0.92791169001236551, 0.92792719210015051, 0.92795819866016493, 0.92797370313310801, 0.9280047144666751, 0.92802022132802919, 0.92805123744172646, 0.92806674669478295, 0.92809776759512963, 0.92811327924316711, 0.92814430493676148, 0.9281753338295039, 0.9281908494764739, 0.92822188317343279, 0.92823740122416565, 0.92826843973194917, 0.92829948145065255, 0.92833052638319413, 0.92834605005558113, 0.92837709981444405, 0.92840815279454425, 0.92843920899885635, 0.92845473831100789, 0.92848579935719933, 0.92850133109197341, 0.92853239698673073, 0.92856346611760265, 0.92857900189751341, 0.92861007588815325, 0.9286256140996374, 0.92865669295678677, 0.9286877750620246, 0.92871886041835794, 0.92873440431662424, 0.92876549455523827, 0.92879658805250354, 0.92882768481139633, 0.92884323441490579, 0.92887433607196357, 0.92888988812627149, 0.92892099468829481, 0.92895210452411037, 0.92896766067063552, 0.92899877542284048, 0.92901433402928368, 0.92904545370474323, 0.92907657666620158, 0.92909213938012747, 0.92912326727632089, 0.9291388324593427, 0.92916996529718321, 0.92920110143329937, 0.92923224087076239, 0.92924781182847838, 0.92927895622377843, 0.92931010392817071, 0.92934125494474007, 0.92935683169607797, 0.92938798768674158, 0.92940356692687343, 0.92943472789864146, 0.9294658921950476, 0.92948147559096106, 0.92951264488016805, 0.92952823077425029, 0.9295594050632956, 0.92959058268950279, 0.92960617275501944, 0.92963735539283854, 0.92965294796594677, 0.9296841356224792, 0.929715326628762, 0.92973092338904861, 0.92976211942587805, 0.9297777187032239, 0.92980891977773694, 0.92984012421468576, 0.92985572769505331, 0.92988693718161031, 0.92990254318857879, 0.92993375773190845, 0.92996497565041114, 0.92998058587635146, 0.93001180886364387, 0.93002742162577579, 0.93005864968905472, 0.93008988114033109, 0.93010549813748455, 0.930136734676832, 0.93015235421982934, 0.93018359585448596, 0.93021484089008344, 0.9302304646842271, 0.93026171482729159, 0.93027734117699523, 0.93030859643482788, 0.93033985510657269, 0.93035548572368754, 0.93038674952242151, 0.93040238270486242, 0.93043365163794778, 0.93046492399801428, 0.93048056146418334, 0.93051183897090262, 0.93052747901224786, 0.9305587616729869, 0.93059004777387044, 0.93060569211539934, 0.93063698338269019, 0.93065263030928236, 0.93068392675042633, 0.93071522664494299, 0.93073087788826214, 0.93076218296908519, 0.93077783680741322, 0.93080914708202123, 0.9308404608233336, 0.93085611899503595, 0.93088743794266204, 0.93090309871939825, 0.93093442288086847, 0.93095008626642906, 0.93098141564929282, 0.93099708164744743, 0.93102841625930222, 0.93104408487383572, 0.93107542472224747, 0.93109109595697648, 0.93112244104956543, 0.93113811490828913, 0.93116946525268696, 0.93120081910252317, 0.93121649734305545, 0.9312478564574489, 0.93126353733216338, 0.93129490171877605, 0.93131058523153554, 0.93134195489806504, 0.93135764105270769, 0.93138901600686652, 0.93140470480724069, 0.93143608505675846, 0.93145177650674715, 0.93148316205935711, 0.93149885616282924, 0.93153024702631293, 0.93156164143467213, 0.9315773399692725, 0.93160873970147251, 0.93162444089994645, 0.93165584596379836, 0.93167154983005052, 0.93170296023339483, 0.93171866677134751, 0.93175008252201197, 0.93176579173559393, 0.93178150184193176, 0.93181292473462052, 0.93182863752184031, 0.93186006578022662, 0.9318757812522831, 0.93189149762015999, 0.93192293304515539, 0.93193865210314275, 0.93197009291232835, 0.93198581466441199, 0.93200153731541024, 0.93203298531590162, 0.93204871066628636, 0.93208016406955863, 0.93209589212335586, 0.93211162107915291, 0.93214308169858717, 0.93215881336311779, 0.93219027940402277, 0.93220601378130308, 0.93222174906372701, 0.93225322234576946, 0.93226896034630902, 0.93230043906863125, 0.93231617979131642, 0.93233192142229604, 0.93234766396199042, 0.93237915176939423, 0.93239489703800404, 0.93241064321713385, 0.9324263903072606, 0.93245788722231149, 0.93247363704812425, 0.93250513943857749, 0.93252089200414479, 0.93253664548387449, 0.93255239987822314, 0.93258391141257979, 0.93259966855350618, 0.93261542661085373, 0.93263118558512836, 0.932646945476725, 0.93267846801382293, 0.93269423066022417, 0.93270999422581591, 0.9327257587110398, 0.93275729044224998, 0.93277305768914354, 0.93280459494784917, 0.93282036496057064, 0.93283613589614323, 0.93285190775504279, 0.93286768053772562, 0.9328834542446619, 0.93289922887628984, 0.93291500443310493, 0.93293078091555526, 0.93296233665919981, 0.93297811592134627, 0.93299389611096173, 0.93300967722853456, 0.93302545927455527, 0.93304124224944351, 0.9330570261536888, 0.93307281098774308, 0.93308859675209721, 0.93310438344721769, 0.93313595963155826, 0.93315174912174426, 0.93316753954455822, 0.93318333090046923, 0.93319912318994436, 0.93321491641343901, 0.9332307105714609, 0.93324650566445266, 0.93326230169290281, 0.93327809865727018, 0.93329389655801898, 0.93330969539563791, 0.93332549517058372, 0.93334129588336312, 0.93335709753439611, 0.93337290012419016, 0.93338870365322824, 0.93340450812195908, 0.9334203135308784, 0.93343611988046693, 0.93345192717114145, 0.9334677354034554, 0.93348354457784766, 0.93349935469479084, 0.93351516575477278, 0.93353097775825744, 0.93354679070574609, 0.93356260459769946, 0.93357841943459929, 0.93359423521691798, 0.9336100519451509, 0.93362586961976202, 0.9336416882412415, 0.93365750781006707, 0.93367332832672778, 0.93368914979168571, 0.93370497220542192, 0.93372079556844945, 0.93373661988122636, 0.93375244514422451, 0.93375244514422451, 0.93376827135795237, 0.93378409852288813, 0.93379992663950406, 0.93381575570827713, 0.93381575570827713, 0.93383158572972447, 0.93384741670429983, 0.9338632486325118, 0.93387908151481458, 0.93389491535172087, 0.9339107501437327, 0.93392658589128763, 0.93394242259491966, 0.93395826025508799, 0.93395826025508799, 0.93397409887229199, 0.93398993844701705, 0.93400577897975601, 0.9340216204709979, 0.9340216204709979, 0.93403746292121081, 0.9340533063309171, 0.93406915070059848, 0.93408499603073003, 0.93408499603073003, 0.934100842321821, 0.93411668957434246, 0.93413253778882854, 0.9341483869657039, 0.9341483869657039, 0.93416423710553076, 0.93418008820876408, 0.93419594027589759, 0.93421179330743909, 0.93421179330743909, 0.93422764730386088, 0.93424350226567698, 0.93425935819339556, 0.93427521508747546, 0.93427521508747546, 0.93429107294844216, 0.9343069317767867, 0.93432279157299392, 0.93433865233756586, 0.93433865233756586, 0.93435451407101144, 0.93437037677381785, 0.93438624044646101, 0.93440210508948152, 0.93440210508948152, 0.93441797070336552, 0.93443383728859153, 0.93444970484568224, 0.93446557337512681, 0.93446557337512681, 0.93448144287744306, 0.93449731335309449, 0.93451318480261114, 0.93452905722650037, 0.93452905722650037, 0.93454493062525179, 0.93456080499937033, 0.93457668034934394, 0.93457668034934394, 0.93459255667572627, 0.93459255667572627, 0.93460843397895588, 0.93462431225957299, 0.93464019151807864, 0.93464019151807864, 0.93465607175496812, 0.934671952970756, 0.93468783516595977, 0.93468783516595977, 0.93470371834106436, 0.93470371834106436, 0.9347196024965766, 0.93473548763303116, 0.93475137375089312, 0.93475137375089312, 0.93476726085070116, 0.93478314893295211, 0.93479903799815955, 0.93479903799815955, 0.93481492804682675, 0.93481492804682675, 0.93483081907946486, 0.93484671109659612, 0.93486260409872468, 0.93486260409872468, 0.93487849808634538, 0.93489439305998112, 0.9349102890201435, 0.9349102890201435, 0.93492618596735122, 0.93492618596735122, 0.93494208390210076, 0.9349579828249136, 0.93497388273629967, 0.93497388273629967, 0.93498978363679441, 0.93500568552688179, 0.93502158840709704, 0.93502158840709704, 0.93503749227792043, 0.93503749227792043, 0.93505339713990177, 0.93506930299356461, 0.93508520983938137, 0.93508520983938137, 0.93510111767792192, 0.93511702650965445, 0.93513293633512795, 0.93513293633512795, 0.93514884715486224, 0.93514884715486224, 0.93516475896935414, 0.93518067177911579, 0.93518067177911579, 0.93519658558469887, 0.93519658558469887, 0.93521250038658055, 0.93522841618532737, 0.93522841618532737, 0.93524433298143816, 0.93524433298143816, 0.93526025077541808, 0.93527616956781856, 0.93527616956781856, 0.93529208935914754, 0.93529208935914754, 0.93530801014990117, 0.9353239319406389, 0.93533985473186909, 0.93533985473186909, 0.93535577852411333, 0.93537170331790476, 0.9353876291137555, 0.9353876291137555, 0.93540355591218383, 0.93540355591218383, 0.93541948371373662, 0.93543541251892437, 0.93545134232826166, 0.93545134232826166, 0.93546727314231215, 0.93548320496156256, 0.93549913778655824, 0.93549913778655824, 0.93551507161783487, 0.93551507161783487, 0.93553100645590215, 0.93554694230128443, 0.93556287915453717, 0.93556287915453717, 0.9355788170161683, 0.93559475588671281, 0.93561069576669731, 0.93561069576669731, 0.93562663665664869, 0.93562663665664869, 0.93564257855712551, 0.9356585214686125, 0.9356585214686125, 0.93567446539167087, 0.93567446539167087, 0.9356904103268473, 0.93570635627463228, 0.93570635627463228, 0.93572230323559702, 0.93572230323559702, 0.93573825121023457, 0.93575420019912969, 0.93577015020277377, 0.93577015020277377, 0.9357861012217249, 0.93580205325650079, 0.935818006307646, 0.935818006307646, 0.93583396037571087, 0.93583396037571087, 0.93584991546121143, 0.93586587156469347, 0.93588182868669068, 0.93588182868669068, 0.93589778682773372, 0.93591374598837296, 0.93592970616913229, 0.93592970616913229, 0.93594566737056484, 0.93594566737056484, 0.9359616295932135, 0.9359775928376084, 0.93599355710428445, 0.93599355710428445, 0.93600952239379209, 0.93602548870667235, 0.93604145604345679, 0.93605742440469786, 0.93605742440469786, 0.93607339379093235, 0.93608936420270383, 0.93610533564057474, 0.93612130810504224, 0.93612130810504224, 0.93613728159669574, 0.93615325611606381, 0.93616923166367449, 0.93618520824009988, 0.93618520824009988, 0.93620118584587697, 0.93621716448154402, 0.93623314414766035, 0.93624912484475942, 0.93624912484475942, 0.93626510657340034, 0.9362810893341188, 0.93629707312748245, 0.9363130579540444, 0.9363130579540444, 0.93632904381430737, 0.93634503070886743, 0.93636101863825161, 0.93637700760303366, 0.93639299760374906, 0.93640898864093813, 0.93642498071516955, 0.93644097382700042, 0.93645696797695432, 0.93645696797695432, 0.93647296316563211, 0.93648895939354559, 0.93650495666126754, 0.93652095496935739, 0.93652095496935739, 0.9365369543183425, 0.93655295470880962, 0.93656895614132307, 0.93658495861639923, 0.93660096213462685, 0.93661696669653205, 0.93663297230270204, 0.93664897895369181, 0.93666498665005415, 0.9366809953923585, 0.93669700518114485, 0.93671301601698065, 0.93672902790043733, 0.93674504083205568, 0.93676105481241589, 0.93677706984208586, 0.93679308592160559, 0.93680910305154141, 0.93682512123246742, 0.93684114046494049, 0.93685716074953884, 0.93687318208680848, 0.93688920447732216, 0.93690522792164421, 0.93692125242035373, 0.93693727797400062, 0.93695330458315185, 0.93696933224838008, 0.93698536097025586, 0.9370013907493463, 0.93701742158621459, 0.93703345348145417, 0.93704948643558439, 0.93706552044922364, 0.93709759165727036, 0.93711362885279814, 0.93712966711012191, 0.93714570642978945, 0.93716174681236764, 0.93717778825846376, 0.93719383076861107, 0.93720987434342362, 0.93722591898343288, 0.93724196468925847, 0.93727405930057606, 0.93729010820723047, 0.93730615818199392, 0.93732220922542508, 0.93733826133812714, 0.9373543145206642, 0.93737036877362323, 0.93738642409755824, 0.93740248049307906, 0.93741853796075292, 0.93745065611489076, 0.9374667168025238, 0.93748277856465356, 0.93749884140181672, 0.93751490531464277, 0.93754703636958003, 0.93756310351284933, 0.93757917173410887, 0.9375952410339583, 0.93761131141295062, 0.93764345541077032, 0.93765952903077654, 0.93767560373228465, 0.93769167951589272, 0.93770775638218651, 0.93773991336520024, 0.93775599348309202, 0.93777207468602697, 0.93778815697461204, 0.93780424034942422, 0.93783641036012522, 0.93785249699718898, 0.93786858472287871, 0.93788467353773086, 0.93790076344240692, 0.93791685443748474, 0.93793294652352788, 0.9379490397011514, 0.93796513397094516, 0.93798122933353045, 0.93801342333942483, 0.93802952198392697, 0.93804562172361394, 0.9380617225590494, 0.93807782449086818, 0.93811003164602047, 0.93812613687056312, 0.93814224319387418, 0.93815835061658615, 0.93817445913926767, 0.93820667948699388, 0.93822279131325059, 0.93823890424190604, 0.93825501827358426, 0.93827113340886736, 0.93830336699270223, 0.93831948544246535, 0.93833560499829427, 0.93835172566076452, 0.93836784743049118, 0.93840009429417048, 0.93841621938934772, 0.9384323455942376, 0.93844847290943434, 0.93846460133555321, 0.93849686152307576, 0.93851299328566051, 0.9385291261616322, 0.93854526015160955, 0.93856139525620241, 0.93859366881168893, 0.93860980726381238, 0.93862594683300959, 0.93864208751992873, 0.93865822932513443, 0.93869051629300337, 0.93870666145688242, 0.93872280774157213, 0.93873895514765249, 0.93875510367578185, 0.93878740410064121, 0.93880355599861265, 0.938819709021122, 0.93883586316876499, 0.938852018442211, 0.93888433236889512, 0.9389004910234181, 0.93891665080619391, 0.93893281171789478, 0.93894897375911468, 0.93898130123271339, 0.938997466666322, 0.93901363323197351, 0.93902980093032007, 0.93904596976198396, 0.93907831082773607, 0.9390944830631105, 0.93911065643432834, 0.93912683094201932, 0.9391430065868005, 0.93917536129024837, 0.93919154035016683, 0.93920772054973822, 0.93922390188959792, 0.93924008437037443, 0.9392724527572327, 0.93928863866460766, 0.93930482571543861, 0.93932101391040002, 0.93935339373521731, 0.93936958536636062, 0.93940197206932219, 0.93941816714243909, 0.93943436336414454, 0.93945056073510458, 0.93948295892736844, 0.93949915974996567, 0.9395153617243881, 0.93953156485127165, 0.93954776913129678, 0.93956397456511442, 0.93958018115332742, 0.93959638889662234, 0.93961259779563078, 0.93962880785101532, 0.93966123143349067, 0.9396774449618831, 0.93969365964924711, 0.93970987549625018, 0.93972609250353167, 0.93975853000156773, 0.93977475049360415, 0.9397909721485519, 0.93980719496705944, 0.93982341894976384, 0.93985587041044594, 0.93987209788975068, 0.93988832653587318, 0.93990455634951986, 0.93992078733130224, 0.93995325280200714, 0.93996948729225072, 0.93998572295329752, 0.94000195978580448, 0.94003443696787492, 0.94005067731877778, 0.9400831615435925, 0.94009940541886416, 0.94011565047024526, 0.94013189669841646, 0.94016439268777319, 0.94018064245030775, 0.94019689339230816, 0.94021314551442325, 0.94022939881735068, 0.94026190896828754, 0.94027816581763668, 0.94029442385047679, 0.94031068306747012, 0.9403269434692989, 0.94035946783016866, 0.94037573179054634, 0.94039199693845077, 0.94040826327456739, 0.94042453079957788, 0.94045706941898022, 0.94047334051470699, 0.94048961280205789, 0.94050588628166154, 0.94052216095424246, 0.94055471388099765, 0.94057099213656037, 0.94058727158779043, 0.94060355223540215, 0.94061983408007599, 0.94065240136328876, 0.94066868680322868, 0.94068497344297453, 0.94070126128318277, 0.94071755032456761, 0.94075013201362123, 0.9407664246626557, 0.94078271851560802, 0.94079901357317153, 0.94081530983603712, 0.94084790598047341, 0.94086420586343311, 0.94088050695446179, 0.94089680925423858, 0.94091311276349676, 0.94092941748290271, 0.9409457234131734, 0.94096203055497829, 0.94097833890905047, 0.94099464847605563, 0.94102727125167207, 0.94104358446170222, 0.94105989888746377, 0.94107621452966195, 0.94109253138900595, 0.9411088494661729, 0.94112516876190289, 0.94114148927687191, 0.94115781101178453, 0.94117413396735394, 0.94120678354326359, 0.9412231101649986, 0.94123943801022092, 0.94125576707962699, 0.9412720973739136, 0.94130476163997379, 0.94132109561315813, 0.94133743081408805, 0.94135376724344477, 0.94137010490192752, 0.94138644379027925, 0.94140278390918386, 0.94141912525935678, 0.94143546784155097, 0.94145181165643521, 0.94146815670473205, 0.94148450298717234, 0.94150085050446608, 0.94151719925732502, 0.94153354924648647, 0.9415662529364982, 0.94158260663879756, 0.94159896158027323, 0.94161531776161111, 0.94163167518355784, 0.94164803384679441, 0.94166439375210498, 0.94168075490017622, 0.94169711729173178, 0.94171348092749541, 0.94172984580818775, 0.94174621193455132, 0.9417625793072858, 0.94177894792713612, 0.94179531779484027, 0.94182806127663266, 0.94184443489220626, 0.94186080975853037, 0.94187718587633806, 0.94189356324636608, 0.9419099418693021, 0.94192632174593349, 0.94194270287697079, 0.94195908526315142, 0.9419754689051969, 0.94199185380385841, 0.94200823995984906, 0.94202462737393899, 0.94204101604680246, 0.94205740597925569, 0.94207379717197437, 0.94209018962572355, 0.9421065833412301, 0.94212297831924174, 0.94213937456050889, 0.94213937456050889, 0.94215577206572187, 0.94217217083570515, 0.94218857087112662, 0.94220497217275323, 0.94220497217275323, 0.94222137474134815, 0.94223777857762858, 0.94225418368234104, 0.94227059005625324, 0.94227059005625324, 0.9422869977000885, 0.94230340661458745, 0.94231981680050636, 0.94231981680050636, 0.94233622825859475, 0.94233622825859475, 0.9423526409896229, 0.94236905499431733, 0.94236905499431733, 0.94238547027338948, 0.94238547027338948, 0.94240188682767267, 0.94241830465784615, 0.94243472376468074, 0.94245114414893827, 0.94246756581138624, 0.94248398875275141, 0.94250041297377352, 0.94251683847525669, 0.94251683847525669, 0.94253326525789582, 0.94254969332250005, 0.94256612266981643, 0.94258255330058383, 0.94259898521556174, 0.94261541841549135, 0.94263185290118423, 0.94264828867333639, 0.9426647257327756, 0.94268116408021785, 0.9426976037164303, 0.94271404464217079, 0.94273048685823635, 0.94274693036535318, 0.94276337516430031, 0.94277982125582216, 0.94279626864072585, 0.94281271731974803, 0.94282916729364885, 0.94282916729364885, 0.94284561856323101, 0.94286207112921894, 0.94287852499240776, 0.94289498015356144, 0.94289498015356144, 0.94291143661345356, 0.94292789437285995, 0.94294435343254102, 0.9429608137932709, 0.9429608137932709, 0.94297727545580989, 0.9429937384209629, 0.94301020268945979, 0.94302666826213477, 0.94302666826213477, 0.9430431351397307, 0.94305960332300054, 0.94307607281276362, 0.94307607281276362, 0.94309254360975214, 0.94309254360975214, 0.94310901571479477, 0.94312548912862337, 0.94312548912862337, 0.94314196385204285, 0.94314196385204285, 0.94315843988584069, 0.94317491723078739, 0.94317491723078739, 0.94319139588765277, 0.94319139588765277, 0.94320787585724419, 0.94322435714033181, 0.94322435714033181, 0.94324083973769379, 0.94324083973769379, 0.94325732365010917, 0.94327380887836354, 0.94327380887836354, 0.94329029542327103, 0.94329029542327103, 0.94330678328559681, 0.94332327246613656, 0.94332327246613656, 0.94333976296563704, 0.94333976296563704, 0.94335625478494145, 0.94335625478494145, 0.9433727479248144, 0.9433727479248144, 0.94338924238605271, 0.94338924238605271, 0.9434057381694344, 0.9434057381694344, 0.94342223527575697, 0.94342223527575697, 0.94343873370581788, 0.94343873370581788, 0.94345523346041149, 0.94345523346041149, 0.94347173454031275, 0.94347173454031275, 0.94348823694634643, 0.94348823694634643, 0.94350474067924728, 0.94350474067924728, 0.94352124573987561, 0.94352124573987561, 0.94353775212898405, 0.94353775212898405, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94358727927532482, 0.94358727927532482, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94362030402998776, 0.94362030402998776, 0.94360379098640079, 0.94360379098640079, 0.94358727927532482, 0.94357076889594704, 0.94357076889594704, 0.94355425984742158, 0.94353775212898405, 0.94352124573987561, 0.94350474067924728, 0.94348823694634643, 0.94347173454031275, 0.94345523346041149, 0.94343873370581788, 0.9434057381694344, 0.94338924238605271, 0.94335625478494145, 0.94333976296563704, 0.94330678328559681, 0.94327380887836354, 0.94324083973769379, 0.94320787585724419, 0.94317491723078739])[np.newaxis,:]

### PROSAIL-5

# Refractive Index:
P5_refractive = np.array([1.495500, 1.495840, 1.495980, 1.496390, 1.497070, 1.497800, 1.498580, 1.499500, 1.500610, 1.501600,
              1.502420, 1.503080, 1.504080, 1.505250, 1.506470, 1.507640, 1.508800, 1.509940, 1.511010, 1.512190,
              1.513360, 1.514450, 1.515580, 1.516760, 1.518120, 1.519490, 1.520560, 1.521230, 1.521940, 1.522760,
              1.523470, 1.524120, 1.524860, 1.525590, 1.526160, 1.526750, 1.527250, 1.527580, 1.527920, 1.528250,
              1.528590, 1.528970, 1.529220, 1.529370, 1.529440, 1.529460, 1.529290, 1.529090, 1.528870, 1.528620,
              1.528250, 1.527780, 1.527340, 1.526820, 1.526240, 1.525590, 1.524940, 1.524300, 1.523690, 1.523060,
              1.522410, 1.521690, 1.520990, 1.520310, 1.519640, 1.518970, 1.518370, 1.517780, 1.517330, 1.516980,
              1.516640, 1.516310, 1.515960, 1.515660, 1.515350, 1.515040, 1.514780, 1.514490, 1.514200, 1.513880,
              1.513530, 1.513090, 1.512560, 1.511920, 1.511170, 1.510280, 1.509240, 1.508050, 1.506700, 1.505160,
              1.503420, 1.501540, 1.499440, 1.497160, 1.494740, 1.492160, 1.489460, 1.486640, 1.483720, 1.480710,
              1.477620, 1.474450, 1.471280, 1.468110, 1.464950, 1.461820, 1.458800, 1.455930, 1.453170, 1.450550,
              1.448090, 1.445780, 1.443630, 1.441710, 1.440000, 1.438500, 1.437180, 1.436040, 1.435100, 1.434310,
              1.433660, 1.433160, 1.432770, 1.432500, 1.432320, 1.432200, 1.432150, 1.432130, 1.432110, 1.432100,
              1.432080, 1.432040, 1.431990, 1.431920, 1.431830, 1.431700, 1.431530, 1.431360, 1.431150, 1.430930,
              1.430680, 1.430420, 1.430180, 1.429950, 1.429710, 1.429470, 1.429230, 1.428980, 1.428740, 1.428480,
              1.428220, 1.427940, 1.427630, 1.427300, 1.426930, 1.426530, 1.426080, 1.425600, 1.425080, 1.424540,
              1.423980, 1.423390, 1.422780, 1.422160, 1.421550, 1.420920, 1.420290, 1.419660, 1.419030, 1.418410,
              1.417790, 1.417200, 1.416630, 1.416080, 1.415560, 1.415080, 1.414620, 1.414170, 1.413750, 1.413360,
              1.413000, 1.412670, 1.412360, 1.412080, 1.411810, 1.411560, 1.411320, 1.411090, 1.410870, 1.410640,
              1.410430, 1.410230, 1.410040, 1.409850, 1.409660, 1.409470, 1.409280, 1.409110, 1.408940, 1.408760,
              1.408580, 1.408400, 1.408240, 1.408080, 1.407930, 1.407800, 1.407700, 1.407620, 1.407570, 1.407540,
              1.407520, 1.407520, 1.407540, 1.407590, 1.407680, 1.407760, 1.407860, 1.407970, 1.408070, 1.408160,
              1.408230, 1.408280, 1.408310, 1.408310, 1.408300, 1.408250, 1.408180, 1.408070, 1.407950, 1.407820,
              1.407720, 1.407650, 1.407620, 1.407670, 1.407790, 1.407990, 1.408310, 1.408750, 1.409320, 1.410010,
              1.410830, 1.411780, 1.412860, 1.414040, 1.415300, 1.416620, 1.417960, 1.419290, 1.420580, 1.421800,
              1.422950, 1.424030, 1.425070, 1.426110, 1.427210, 1.428450, 1.429870, 1.431530, 1.433480, 1.435730,
              1.438280, 1.441120, 1.444200, 1.447480, 1.450920, 1.454430, 1.457950, 1.461460, 1.464880, 1.468190,
              1.471370, 1.474420, 1.477360, 1.480190, 1.482970, 1.485720, 1.488390, 1.490920, 1.493210, 1.495080,
              1.496320, 1.496670, 1.495840, 1.493620, 1.489950, 1.484710, 1.478020, 1.470250, 1.461790, 1.453020,
              1.444470, 1.436620, 1.429660, 1.423750, 1.419020, 1.415450, 1.412890, 1.411250, 1.410420, 1.410230,
              1.410580, 1.411340, 1.412410, 1.413730, 1.415230, 1.416860, 1.418590, 1.420400, 1.422270, 1.424170,
              1.426110, 1.428090, 1.430080, 1.432100, 1.434130, 1.436160, 1.438190, 1.440210, 1.442230, 1.444220,
              1.446180, 1.448110, 1.450000, 1.451850, 1.453640, 1.455390, 1.457090, 1.458720, 1.460300, 1.461810,
              1.463260, 1.464630, 1.465930, 1.467150, 1.468310, 1.469390, 1.470390, 1.471310, 1.472160, 1.472920,
              1.473620, 1.474230, 1.474770, 1.475230, 1.475620, 1.475940, 1.476190, 1.476380, 1.476510, 1.476590,
              1.476630, 1.476630, 1.476590, 1.476520, 1.476420, 1.476300, 1.476160, 1.476000, 1.475820, 1.475640,
              1.475440, 1.475260, 1.475070, 1.474880, 1.474690, 1.474500, 1.474310, 1.474120, 1.473930, 1.473730,
              1.473510, 1.473310, 1.473100, 1.472890, 1.472690, 1.472500, 1.472300, 1.472100, 1.471920, 1.471750,
              1.471580, 1.471400, 1.471230, 1.471070, 1.470920, 1.470750, 1.470560, 1.470380, 1.470210, 1.470030,
              1.469860, 1.469700, 1.469530, 1.469340, 1.469150, 1.468960, 1.468770, 1.468580, 1.468400, 1.468240,
              1.468080, 1.467920, 1.467750, 1.467570, 1.467380, 1.467200, 1.467010, 1.466840, 1.466670, 1.466520,
              1.466370, 1.466220, 1.466060, 1.465890, 1.465730, 1.465570, 1.465390, 1.465230, 1.465080, 1.464930,
              1.464790, 1.464640, 1.464470, 1.464310, 1.464140, 1.463960, 1.463790, 1.463630, 1.463470, 1.463300,
              1.463150, 1.462990, 1.462840, 1.462700, 1.462580, 1.462470, 1.462350, 1.462200, 1.462050, 1.461890,
              1.461740, 1.461610, 1.461460, 1.461310, 1.461150, 1.461000, 1.460850, 1.460700, 1.460550, 1.460410,
              1.460270, 1.460140, 1.460020, 1.459880, 1.459750, 1.459610, 1.459490, 1.459380, 1.459260, 1.459110,
              1.458940, 1.458760, 1.458580, 1.458440, 1.458330, 1.458240, 1.458170, 1.458100, 1.458020, 1.457910,
              1.457760, 1.457590, 1.457420, 1.457260, 1.457090, 1.456940, 1.456790, 1.456640, 1.456490, 1.456340,
              1.456200, 1.456070, 1.455930, 1.455780, 1.455620, 1.455460, 1.455290, 1.455130, 1.454980, 1.454840,
              1.454700, 1.454550, 1.454400, 1.454250, 1.454090, 1.453930, 1.453780, 1.453640, 1.453500, 1.453360,
              1.453220, 1.453090, 1.452950, 1.452810, 1.452670, 1.452530, 1.452390, 1.452240, 1.452080, 1.451930,
              1.451780, 1.451630, 1.451490, 1.451360, 1.451230, 1.451100, 1.450950, 1.450800, 1.450650, 1.450490,
              1.450330, 1.450190, 1.450040, 1.449860, 1.449680, 1.449520, 1.449370, 1.449220, 1.449080, 1.448930,
              1.448800, 1.448680, 1.448510, 1.448300, 1.448100, 1.447940, 1.447790, 1.447680, 1.447590, 1.447430,
              1.447200, 1.446910, 1.446670, 1.446510, 1.446370, 1.446200, 1.446080, 1.446090, 1.446130, 1.446010,
              1.445740, 1.445500, 1.445310, 1.445160, 1.445030, 1.444940, 1.444840, 1.444690, 1.444550, 1.444550,
              1.444500, 1.444250, 1.444000, 1.443840, 1.443710, 1.443620, 1.443570, 1.443490, 1.443440, 1.443460,
              1.443450, 1.443380, 1.443240, 1.443040, 1.442830, 1.442720, 1.442640, 1.442500, 1.442330, 1.442160,
              1.441990, 1.441810, 1.441660, 1.441540, 1.441470, 1.441430, 1.441460, 1.441530, 1.441580, 1.441570,
              1.441500, 1.441430, 1.441310, 1.441150, 1.440950, 1.440740, 1.440520, 1.440310, 1.440120, 1.440020,
              1.439930, 1.439740, 1.439540, 1.439400, 1.439300, 1.439240, 1.439180, 1.439160, 1.439110, 1.439010,
              1.438880, 1.438720, 1.438590, 1.438490, 1.438420, 1.438370, 1.438310, 1.438150, 1.437960, 1.437770,
              1.437570, 1.437370, 1.437200, 1.437090, 1.437010, 1.436930, 1.436820, 1.436680, 1.436550, 1.436480,
              1.436440, 1.436380, 1.436340, 1.436330, 1.436330, 1.436350, 1.436340, 1.436250, 1.436150, 1.436060,
              1.435940, 1.435760, 1.435570, 1.435400, 1.435260, 1.435170, 1.435100, 1.435030, 1.434940, 1.434880,
              1.434790, 1.434680, 1.434540, 1.434370, 1.434220, 1.434210, 1.434210, 1.434110, 1.433990, 1.433890,
              1.433790, 1.433680, 1.433560, 1.433440, 1.433350, 1.433350, 1.433370, 1.433350, 1.433300, 1.433200,
              1.433060, 1.432940, 1.432810, 1.432680, 1.432530, 1.432380, 1.432230, 1.432090, 1.431950, 1.431820,
              1.431700, 1.431570, 1.431480, 1.431430, 1.431370, 1.431300, 1.431200, 1.431050, 1.430880, 1.430720,
              1.430560, 1.430410, 1.430300, 1.430250, 1.430210, 1.430120, 1.429980, 1.429750, 1.429520, 1.429400,
              1.429310, 1.429210, 1.429110, 1.429040, 1.428950, 1.428810, 1.428650, 1.428460, 1.428320, 1.428320,
              1.428380, 1.428420, 1.428420, 1.428370, 1.428300, 1.428260, 1.428170, 1.427990, 1.427800, 1.427640,
              1.427520, 1.427380, 1.427210, 1.427010, 1.426830, 1.426750, 1.426700, 1.426630, 1.426550, 1.426440,
              1.426310, 1.426190, 1.426050, 1.425910, 1.425800, 1.425710, 1.425630, 1.425570, 1.425520, 1.425400,
              1.425200, 1.425000, 1.424890, 1.424810, 1.424670, 1.424420, 1.424130, 1.423870, 1.423680, 1.423540,
              1.423410, 1.423290, 1.423160, 1.422990, 1.422810, 1.422600, 1.422450, 1.422380, 1.422330, 1.422300,
              1.422250, 1.422200, 1.422150, 1.422130, 1.422080, 1.421950, 1.421770, 1.421640, 1.421560, 1.421520,
              1.421470, 1.421260, 1.421000, 1.420780, 1.420670, 1.420640, 1.420650, 1.420660, 1.420640, 1.420610,
              1.420520, 1.420300, 1.420050, 1.419870, 1.419830, 1.419930, 1.420140, 1.420380, 1.420520, 1.420480,
              1.420300, 1.419990, 1.419600, 1.419190, 1.418880, 1.418740, 1.418740, 1.418770, 1.418790, 1.418720,
              1.418610, 1.418480, 1.418270, 1.418100, 1.417950, 1.417830, 1.417760, 1.417710, 1.417630, 1.417480,
              1.417330, 1.417270, 1.417230, 1.417160, 1.417020, 1.416850, 1.416680, 1.416540, 1.416410, 1.416270,
              1.416070, 1.415820, 1.415600, 1.415480, 1.415400, 1.415270, 1.415130, 1.415110, 1.415080, 1.414970,
              1.414850, 1.414730, 1.414610, 1.414540, 1.414460, 1.414330, 1.414150, 1.413900, 1.413640, 1.413450,
              1.413280, 1.413040, 1.412850, 1.412830, 1.412830, 1.412760, 1.412620, 1.412440, 1.412260, 1.412190,
              1.412160, 1.412140, 1.412070, 1.411950, 1.411800, 1.411640, 1.411500, 1.411360, 1.411240, 1.411180,
              1.411140, 1.411090, 1.410990, 1.410810, 1.410600, 1.410400, 1.410250, 1.410210, 1.410220, 1.410280,
              1.410270, 1.410120, 1.409900, 1.409680, 1.409470, 1.409280, 1.409150, 1.409120, 1.409120, 1.409060,
              1.408950, 1.408770, 1.408560, 1.408330, 1.408120, 1.407980, 1.407880, 1.407770, 1.407720, 1.407780,
              1.407850, 1.407790, 1.407690, 1.407610, 1.407490, 1.407280, 1.407040, 1.406800, 1.406590, 1.406440,
              1.406370, 1.406230, 1.406150, 1.405910, 1.405660, 1.405560, 1.405470, 1.405500, 1.405540, 1.405600,
              1.405690, 1.405780, 1.405780, 1.405660, 1.405510, 1.405310, 1.405130, 1.405000, 1.404880, 1.404800,
              1.404630, 1.404510, 1.404400, 1.404390, 1.404440, 1.404530, 1.404490, 1.404360, 1.404200, 1.404030,
              1.404030, 1.404120, 1.404150, 1.404000, 1.403660, 1.403390, 1.403220, 1.403080, 1.403050, 1.403150,
              1.403300, 1.403360, 1.403280, 1.403170, 1.402840, 1.402320, 1.401760, 1.401340, 1.401060, 1.401000,
              1.400780, 1.400690, 1.400450, 1.400220, 1.400050, 1.400260, 1.400440, 1.400910, 1.401150, 1.401480,
              1.401620, 1.401510, 1.401030, 1.400220, 1.399640, 1.399230, 1.398870, 1.399210, 1.399450, 1.399740,
              1.400030, 1.400040, 1.400000, 1.400320, 1.400170, 1.399870, 1.400220, 1.400460, 1.400840, 1.400940,
              1.401890, 1.401510, 1.401030, 1.400060, 1.400110, 1.398800, 1.397830, 1.397120, 1.395990, 1.396760,
              1.395780, 1.395500, 1.395210, 1.395360, 1.394530, 1.395990, 1.396080, 1.395000, 1.394610, 1.394200,
              1.393850, 1.393560, 1.392650, 1.392640, 1.393000, 1.394320, 1.394360, 1.394440, 1.394370, 1.393690,
              1.393320, 1.393450, 1.393410, 1.393500, 1.393350, 1.393110, 1.392850, 1.392550, 1.392020, 1.391770,
              1.391540, 1.391050, 1.390450, 1.389820, 1.389200, 1.387980, 1.387220, 1.386490, 1.385850, 1.385200,
              1.384360, 1.383840, 1.382950, 1.382270, 1.381000, 1.380150, 1.379390, 1.378470, 1.377650, 1.377120,
              1.376490, 1.375810, 1.375110, 1.374290, 1.373340, 1.372540, 1.371690, 1.371090, 1.370690, 1.370310,
              1.370020, 1.369980, 1.369710, 1.369190, 1.368530, 1.368020, 1.367540, 1.367020, 1.366730, 1.366220,
              1.365700, 1.365890, 1.365850, 1.365600, 1.365640, 1.365390, 1.364990, 1.365300, 1.365150, 1.364910,
              1.365050, 1.364620, 1.364150, 1.364440, 1.364000, 1.364460, 1.364300, 1.364390, 1.364720, 1.364630,
              1.364940, 1.364380, 1.364100, 1.363540, 1.363560, 1.363310, 1.363080, 1.363500, 1.363480, 1.364280,
              1.364200, 1.364650, 1.364330, 1.364220, 1.363670, 1.363970, 1.363830, 1.363970, 1.364030, 1.364000,
              1.364580, 1.364520, 1.365020, 1.365000, 1.365190, 1.365700, 1.365640, 1.366040, 1.365730, 1.366160,
              1.366520, 1.366660, 1.367050, 1.366640, 1.366920, 1.367340, 1.367270, 1.368000, 1.368600, 1.368650,
              1.368910, 1.369270, 1.369000, 1.369380, 1.369760, 1.369510, 1.369670, 1.369780, 1.369630, 1.369810,
              1.370020, 1.370580, 1.370510, 1.370860, 1.371180, 1.371710, 1.371780, 1.372090, 1.372120, 1.372420,
              1.372340, 1.372150, 1.372310, 1.372350, 1.372550, 1.372340, 1.372290, 1.372680, 1.372900, 1.373040,
              1.373020, 1.373050, 1.373100, 1.373400, 1.373460, 1.373620, 1.373710, 1.373800, 1.373560, 1.373470,
              1.373450, 1.373530, 1.373610, 1.373800, 1.373750, 1.373860, 1.373620, 1.373670, 1.373550, 1.373540,
              1.373520, 1.373440, 1.373380, 1.373450, 1.373540, 1.373240, 1.373300, 1.373180, 1.373190, 1.373460,
              1.373600, 1.373930, 1.374170, 1.374120, 1.373800, 1.373720, 1.373690, 1.373650, 1.373520, 1.373700,
              1.373800, 1.374110, 1.374310, 1.374450, 1.374450, 1.374320, 1.374020, 1.374050, 1.374070, 1.374120,
              1.374190, 1.374210, 1.374130, 1.374330, 1.374290, 1.374340, 1.374170, 1.374140, 1.374010, 1.374050,
              1.373820, 1.373650, 1.373410, 1.373300, 1.373100, 1.373040, 1.373010, 1.373080, 1.373060, 1.373250,
              1.373100, 1.373050, 1.372890, 1.372770, 1.372710, 1.372610, 1.372500, 1.372610, 1.372480, 1.372640,
              1.372580, 1.372410, 1.371960, 1.371850, 1.371610, 1.371520, 1.371220, 1.371270, 1.371110, 1.371060,
              1.370760, 1.370830, 1.370740, 1.370820, 1.370770, 1.371030, 1.371230, 1.371530, 1.371470, 1.371620,
              1.371460, 1.371430, 1.371220, 1.371350, 1.370950, 1.370800, 1.370430, 1.370400, 1.370030, 1.369800,
              1.369520, 1.369440, 1.369160, 1.369030, 1.368680, 1.368670, 1.368440, 1.368510, 1.368380, 1.368350,
              1.368300, 1.368700, 1.368150, 1.367860, 1.367410, 1.367030, 1.366550, 1.366510, 1.366410, 1.366310,
              1.365960, 1.365900, 1.365610, 1.365490, 1.365440, 1.365480, 1.365390, 1.365410, 1.365160, 1.365110,
              1.364820, 1.364780, 1.364700, 1.364800, 1.364690, 1.364680, 1.364630, 1.364730, 1.364650, 1.364360,
              1.364040, 1.363810, 1.363500, 1.363430, 1.363220, 1.363120, 1.362840, 1.362870, 1.362720, 1.362930,
              1.362910, 1.362710, 1.362500, 1.362490, 1.362340, 1.362180, 1.361960, 1.362040, 1.361900, 1.361890,
              1.361600, 1.361470, 1.361250, 1.361160, 1.361160, 1.361250, 1.361310, 1.361670, 1.361720, 1.361810,
              1.361780, 1.361760, 1.361540, 1.361600, 1.361520, 1.361580, 1.361810, 1.361730, 1.361570, 1.361620,
              1.361310, 1.361180, 1.361230, 1.361560, 1.361620, 1.361670, 1.361820, 1.362130, 1.362330, 1.362500,
              1.362610, 1.362590, 1.362480, 1.362760, 1.363330, 1.363760, 1.363760, 1.363620, 1.363500, 1.363330,
              1.363040, 1.362900, 1.363160, 1.363610, 1.364110, 1.364630, 1.365140, 1.365360, 1.364850, 1.364030,
              1.362960, 1.362060, 1.361490, 1.360820, 1.360810, 1.361070, 1.361730, 1.362820, 1.363790, 1.364510,
              1.364900, 1.364590, 1.363750, 1.362520, 1.361280, 1.360060, 1.359470, 1.359320, 1.359890, 1.360690,
              1.361430, 1.362280, 1.362720, 1.362690, 1.362420, 1.362210, 1.361870, 1.361630, 1.361630, 1.361750,
              1.361890, 1.362090, 1.362250, 1.362600, 1.362970, 1.363490, 1.363730, 1.363880, 1.363590, 1.363220,
              1.362930, 1.362500, 1.362350, 1.362470, 1.362770, 1.363390, 1.363840, 1.364500, 1.364960, 1.365180,
              1.365200, 1.364960, 1.364480, 1.364250, 1.363870, 1.363800, 1.363640, 1.363420, 1.363160, 1.363210,
              1.363140, 1.363030, 1.362410, 1.362360, 1.362360, 1.362290, 1.362600, 1.362890, 1.362930, 1.363060,
              1.362850, 1.362210, 1.361510, 1.360720, 1.360150, 1.359760, 1.359680, 1.359920, 1.359720, 1.359700,
              1.359560, 1.359960, 1.359290, 1.359680, 1.360240, 1.361340, 1.362470, 1.363360, 1.363850, 1.364480,
              1.364310, 1.364800, 1.362920, 1.363170, 1.363510, 1.364480, 1.364760, 1.366240, 1.366830, 1.368440,
              1.365350, 1.365770, 1.366360, 1.366330, 1.367160, 1.366830, 1.368000, 1.362580, 1.361980, 1.362420,
              1.362760, 1.361680, 1.362840, 1.356230, 1.355700, 1.355800, 1.355950, 1.355470, 1.350790, 1.350400,
              1.351160, 1.352050, 1.352490, 1.349330, 1.350350, 1.352460, 1.354640, 1.357780, 1.355580, 1.358290,
              1.360130, 1.361010, 1.359540, 1.359920, 1.360570, 1.361160, 1.359780, 1.360060, 1.360120, 1.360620,
              1.359860, 1.360040, 1.360330, 1.360850, 1.360640, 1.361350, 1.361540, 1.361420, 1.360590, 1.359970,
              1.359080, 1.357750, 1.356600, 1.355370, 1.353940, 1.353010, 1.351900, 1.350970, 1.349990, 1.349340,
              1.348570, 1.347920, 1.346830, 1.345590, 1.344540, 1.343220, 1.342090, 1.341340, 1.340230, 1.339040,
              1.337970, 1.336280, 1.334310, 1.332780, 1.331000, 1.329560, 1.328850, 1.328240, 1.327230, 1.327270,
              1.326120, 1.325910, 1.324360, 1.323060, 1.322620, 1.321710, 1.320280, 1.319960, 1.318460, 1.317700,
              1.316410, 1.314680, 1.314910, 1.313770, 1.314370, 1.313940, 1.313520, 1.314040, 1.313740, 1.314120,
              1.313290, 1.314540, 1.313460, 1.311880, 1.312240, 1.310800, 1.310350, 1.309020, 1.309520, 1.308690,
              1.309400, 1.308900, 1.308040, 1.308920, 1.307820, 1.307990, 1.306800, 1.306980, 1.306090, 1.306730,
              1.306460, 1.306980, 1.306500, 1.306880, 1.306110, 1.306040, 1.304730, 1.304760, 1.303490, 1.303770,
              1.302740, 1.301750, 1.301990, 1.302510, 1.301480, 1.301880, 1.301150, 1.301520, 1.301020, 1.301790,
              1.301250, 1.301710, 1.300910, 1.301350, 1.300550, 1.300890, 1.300300, 1.300820, 1.300200, 1.300790,
              1.300630, 1.301300, 1.301770, 1.300900, 1.301310, 1.300990, 1.301780, 1.301370, 1.302040, 1.302600,
              1.301940, 1.301470, 1.300440, 1.300110, 1.298890, 1.298790, 1.298970, 1.298480, 1.299300, 1.298780,
              1.298970, 1.299010, 1.298070, 1.298350, 1.298030, 1.298860, 1.299850, 1.300010, 1.300950, 1.301040,
              1.301730, 1.301950, 1.301170, 1.300820, 1.300800, 1.300220, 1.300760, 1.300300, 1.300590, 1.300730,
              1.300870, 1.301010, 1.301140, 1.301270, 1.301390, 1.301510, 1.301620, 1.301730, 1.301840, 1.301940,
              1.302040, 1.302130, 1.302220, 1.302310, 1.302390, 1.302470, 1.302550, 1.302620, 1.302680, 1.302750,
              1.302810, 1.302860, 1.302910, 1.302960, 1.303010, 1.303050, 1.303090, 1.303120, 1.303150, 1.303180,
              1.303200, 1.303230, 1.303240, 1.303260, 1.303270, 1.303280, 1.303280, 1.303280, 1.303280, 1.303280,
              1.303270, 1.303260, 1.303250, 1.303230, 1.303210, 1.303190, 1.303160, 1.303130, 1.303100, 1.303070,
              1.303040, 1.303000, 1.302960, 1.302910, 1.302870, 1.302820, 1.302770, 1.302710, 1.302660, 1.302600,
              1.302540, 1.302480, 1.302410, 1.302340, 1.302280, 1.302200, 1.302130, 1.302050, 1.301980, 1.301900,
              1.301820, 1.301730, 1.301650, 1.301560, 1.301470, 1.301380, 1.301290, 1.301190, 1.301100, 1.301000,
              1.300900, 1.300800, 1.300700, 1.300500, 1.300400, 1.300300, 1.300200, 1.300100, 1.299900, 1.299800,
              1.299700, 1.299600, 1.299500, 1.299300, 1.299200, 1.299100, 1.299000, 1.298900, 1.298700, 1.298600,
              1.298500, 1.298400, 1.298300, 1.298100, 1.298000, 1.297900, 1.297800, 1.297700, 1.297500, 1.297400,
              1.297300, 1.297200, 1.297000, 1.296900, 1.296700, 1.296600, 1.296500, 1.296400, 1.296200, 1.296100,
              1.296000, 1.295900, 1.295800, 1.295700, 1.295600, 1.295500, 1.295400, 1.295300, 1.295100, 1.295000,
              1.294900, 1.294800, 1.294700, 1.294500, 1.294400, 1.294300, 1.294200, 1.294100, 1.293900, 1.293800,
              1.293700, 1.293600, 1.293500, 1.293300, 1.293200, 1.293100, 1.293000, 1.292800, 1.292700, 1.292500,
              1.292400, 1.292300, 1.292200, 1.292000, 1.291900, 1.291800, 1.291700, 1.291600, 1.291400, 1.291300,
              1.291200, 1.291100, 1.291000, 1.290800, 1.290700, 1.290600, 1.290500, 1.290400, 1.290200, 1.290100,
              1.290000, 1.289900, 1.289800, 1.289600, 1.289500, 1.289400, 1.289300, 1.289200, 1.289000, 1.288900,
              1.288800, 1.288700, 1.288600, 1.288400, 1.288300, 1.288200, 1.288100, 1.288000, 1.287800, 1.287700,
              1.287600, 1.287500, 1.287400, 1.287300, 1.287200, 1.287100, 1.287000, 1.286900, 1.286700, 1.286600,
              1.286500, 1.286400, 1.286300, 1.286200, 1.286100, 1.286000, 1.285900, 1.285800, 1.285600, 1.285500,
              1.285400, 1.285300, 1.285200, 1.285000, 1.284900, 1.284800, 1.284700, 1.284600, 1.284500, 1.284400,
              1.284300, 1.284200, 1.284100, 1.284000, 1.283900, 1.283800, 1.283700, 1.283600, 1.283400, 1.283300,
              1.283200, 1.283100, 1.283000, 1.282900, 1.282800, 1.282700, 1.282600, 1.282500, 1.282400, 1.282300,
              1.282200, 1.282100, 1.282000, 1.281800, 1.281700, 1.281600, 1.281500, 1.281400, 1.281300, 1.281200,
              1.281100, 1.281000, 1.280900, 1.280800, 1.280700, 1.280600, 1.280500, 1.280400, 1.280300, 1.280200,
              1.280100, 1.280000, 1.279900, 1.279900, 1.279800, 1.279700, 1.279600, 1.279500, 1.279500, 1.279400,
              1.279300, 1.279200, 1.279100, 1.279100, 1.279000, 1.278900, 1.278800, 1.278800, 1.278700, 1.278700,
              1.278600, 1.278500, 1.278500, 1.278400, 1.278400, 1.278300, 1.278200, 1.278100, 1.278000, 1.277900,
              1.277800, 1.277700, 1.277600, 1.277600, 1.277500, 1.277400, 1.277300, 1.277200, 1.277100, 1.277000,
              1.276900, 1.276800, 1.276700, 1.276600, 1.276500, 1.276400, 1.276300, 1.276200, 1.276100, 1.276000,
              1.275900, 1.275800, 1.275700, 1.275700, 1.275600, 1.275500, 1.275400, 1.275300, 1.275300, 1.275200,
              1.275100, 1.275000, 1.274900, 1.274900, 1.274800, 1.274700, 1.274600, 1.274500, 1.274500, 1.274400,
              1.274300, 1.274200, 1.274200, 1.274100, 1.274100, 1.274000, 1.273900, 1.273900, 1.273800, 1.273800,
              1.273700, 1.273600, 1.273600, 1.273500, 1.273500, 1.273400, 1.273300, 1.273300, 1.273200, 1.273200,
              1.273100, 1.273000, 1.273000, 1.272900, 1.272900, 1.272800, 1.272700, 1.272700, 1.272600, 1.272600,
              1.272500, 1.272500, 1.272400, 1.272400, 1.272300, 1.272300, 1.272200, 1.272200, 1.272100, 1.272100,
              1.272000, 1.272000, 1.271900, 1.271900, 1.271800, 1.271800, 1.271700, 1.271700, 1.271600, 1.271600,
              1.271500, 1.271500, 1.271400, 1.271400, 1.271300, 1.271300, 1.271300, 1.271300, 1.271200, 1.271200,
              1.271200, 1.271200, 1.271100, 1.271100, 1.271000, 1.271000, 1.271000, 1.271000, 1.270900, 1.270900,
              1.270900, 1.270900, 1.270900, 1.270800, 1.270800, 1.270800, 1.270800, 1.270800, 1.270800, 1.270800,
              1.270800, 1.270800, 1.270800, 1.270800, 1.270800, 1.270800, 1.270800, 1.270900, 1.270900, 1.271000,
              1.271000, 1.271100, 1.271200, 1.271200, 1.271300, 1.271400, 1.271500, 1.271600, 1.271700, 1.271800,
              1.271900, 1.272000, 1.272200, 1.272300, 1.272500, 1.272600, 1.272800, 1.273000, 1.273200, 1.273400,
              1.273600])

P5_k_Cab = np.array([0.026760, 0.031130, 0.035610, 0.039720, 0.043210, 0.046060, 0.048150, 0.050070, 0.051890, 0.053460,
        0.055260, 0.057210, 0.058910, 0.060040, 0.061000, 0.061890, 0.062590, 0.063180, 0.063670, 0.064160,
        0.064750, 0.065550, 0.066280, 0.066900, 0.067180, 0.067470, 0.067950, 0.068540, 0.068970, 0.069310,
        0.069790, 0.070370, 0.070820, 0.071140, 0.071410, 0.071600, 0.071740, 0.071770, 0.071710, 0.071550,
        0.071200, 0.070480, 0.069630, 0.068830, 0.067890, 0.066850, 0.065830, 0.064800, 0.063580, 0.062250,
        0.060900, 0.059560, 0.058120, 0.056770, 0.055530, 0.054390, 0.053300, 0.052240, 0.051340, 0.050560,
        0.049900, 0.049340, 0.048910, 0.048520, 0.048120, 0.047670, 0.047290, 0.046980, 0.046730, 0.046470,
        0.046220, 0.046060, 0.045890, 0.045700, 0.045520, 0.045350, 0.045190, 0.044920, 0.044660, 0.044420,
        0.044130, 0.043730, 0.043250, 0.042750, 0.042160, 0.041490, 0.040730, 0.039890, 0.038950, 0.037910,
        0.036830, 0.035710, 0.034550, 0.033350, 0.032150, 0.030940, 0.029720, 0.028500, 0.027300, 0.026150,
        0.025020, 0.023950, 0.022940, 0.021990, 0.021090, 0.020250, 0.019460, 0.018730, 0.018040, 0.017400,
        0.016800, 0.016220, 0.015670, 0.015150, 0.014660, 0.014180, 0.013730, 0.013310, 0.012910, 0.012540,
        0.012200, 0.011890, 0.011610, 0.011360, 0.011140, 0.010960, 0.010800, 0.010670, 0.010570, 0.010490,
        0.010440, 0.010410, 0.010400, 0.010410, 0.010430, 0.010460, 0.010500, 0.010550, 0.010610, 0.010670,
        0.010730, 0.010800, 0.010870, 0.010940, 0.011000, 0.011070, 0.011120, 0.011180, 0.011240, 0.011300,
        0.011360, 0.011420, 0.011500, 0.011590, 0.011700, 0.011820, 0.011960, 0.012120, 0.012300, 0.012490,
        0.012710, 0.012930, 0.013180, 0.013440, 0.013710, 0.014000, 0.014310, 0.014640, 0.014990, 0.015350,
        0.015720, 0.016110, 0.016490, 0.016880, 0.017260, 0.017630, 0.017990, 0.018330, 0.018660, 0.018980,
        0.019280, 0.019580, 0.019860, 0.020130, 0.020380, 0.020630, 0.020860, 0.021070, 0.021280, 0.021460,
        0.021640, 0.021800, 0.021940, 0.022080, 0.022190, 0.022300, 0.022400, 0.022500, 0.022590, 0.022690,
        0.022790, 0.022910, 0.023040, 0.023190, 0.023370, 0.023560, 0.023780, 0.024030, 0.024300, 0.024580,
        0.024890, 0.025200, 0.025520, 0.025860, 0.026200, 0.026540, 0.026870, 0.027190, 0.027500, 0.027780,
        0.028030, 0.028260, 0.028450, 0.028620, 0.028770, 0.028880, 0.028980, 0.029050, 0.029100, 0.029160,
        0.029210, 0.029280, 0.029380, 0.029510, 0.029690, 0.029930, 0.030220, 0.030590, 0.031020, 0.031520,
        0.032070, 0.032680, 0.033350, 0.034050, 0.034780, 0.035520, 0.036260, 0.036980, 0.037670, 0.038310,
        0.038900, 0.039430, 0.039930, 0.040430, 0.040950, 0.041520, 0.042170, 0.042930, 0.043800, 0.044780,
        0.045880, 0.047090, 0.048370, 0.049700, 0.051060, 0.052390, 0.053680, 0.054880, 0.055950, 0.056880,
        0.057650, 0.058260, 0.058710, 0.059000, 0.059140, 0.059140, 0.058990, 0.058680, 0.058190, 0.057480,
        0.056500, 0.055220, 0.053610, 0.051680, 0.049410, 0.046890, 0.044160, 0.041280, 0.038340, 0.035410,
        0.032540, 0.029780, 0.027170, 0.024730, 0.022470, 0.020390, 0.018500, 0.016780, 0.015230, 0.013840,
        0.012590, 0.011470, 0.010480, 0.009594, 0.008804, 0.008099, 0.007465, 0.006892, 0.006371, 0.005897,
        0.005461, 0.005060, 0.004691, 0.004348, 0.004029, 0.003732, 0.003456, 0.003199, 0.002960, 0.002736,
        0.002528, 0.002334, 0.002153, 0.001985, 0.001828, 0.001683, 0.001549, 0.001424, 0.001309, 0.001202,
        0.001103, 0.001012, 0.000927, 0.000848, 0.000777, 0.000711, 0.000651, 0.000595, 0.000544, 0.000497,
        0.000454, 0.000415, 0.000379, 0.000347, 0.000318, 0.000291, 0.000267, 0.000245, 0.000226, 0.000208,
        0.000192, 0.000179, 0.000167, 0.000156, 0.000146, 0.000137, 0.000128, 0.000121, 0.000114, 0.000108,
        0.000104, 0.000099, 0.000094, 0.000090, 0.000085, 0.000081, 0.000077, 0.000073, 0.000068, 0.000065,
        0.000061, 0.000057, 0.000053, 0.000050, 0.000046, 0.000043, 0.000040, 0.000037, 0.000034, 0.000031,
        0.000028, 0.000025, 0.000023, 0.000020, 0.000018, 0.000016, 0.000014, 0.000012, 0.000010, 0.000009,
        0.000007, 0.000006, 0.000005, 0.000004, 0.000003, 0.000002, 0.000001, 0.000001, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
        0.000000])

P5_k_Car = np.array([0.289500, 0.279600, 0.269300, 0.260100, 0.252500, 0.245600, 0.240300, 0.235200, 0.230300, 0.225500,
         0.220300, 0.215100, 0.210500, 0.206900, 0.203500, 0.200200, 0.197100, 0.194300, 0.191400, 0.188900,
         0.186600, 0.184400, 0.182300, 0.180500, 0.179200, 0.177700, 0.176200, 0.174800, 0.173500, 0.172400,
         0.171500, 0.170700, 0.170100, 0.169400, 0.168800, 0.168200, 0.167800, 0.167400, 0.167000, 0.166700,
         0.166400, 0.165900, 0.165300, 0.164700, 0.164100, 0.163200, 0.162400, 0.161500, 0.160500, 0.159200,
         0.157700, 0.156100, 0.154400, 0.152800, 0.151300, 0.149700, 0.148300, 0.146800, 0.145400, 0.144000,
         0.142500, 0.141100, 0.139700, 0.138400, 0.137100, 0.135800, 0.134700, 0.133500, 0.132500, 0.131600,
         0.130800, 0.130100, 0.129600, 0.129200, 0.128800, 0.128500, 0.128200, 0.128000, 0.127700, 0.127400,
         0.127000, 0.126500, 0.126000, 0.125300, 0.124400, 0.123400, 0.122300, 0.121000, 0.119700, 0.118200,
         0.116600, 0.115000, 0.113200, 0.111400, 0.109600, 0.107600, 0.105600, 0.103500, 0.101300, 0.099000,
         0.096600, 0.094070, 0.091430, 0.088710, 0.085890, 0.082970, 0.079970, 0.076900, 0.073800, 0.070670,
         0.067560, 0.064460, 0.061380, 0.058360, 0.055410, 0.052560, 0.049820, 0.047190, 0.044670, 0.042280,
         0.040000, 0.037820, 0.035750, 0.033790, 0.031960, 0.030240, 0.028630, 0.027140, 0.025750, 0.024450,
         0.023230, 0.022090, 0.021030, 0.020040, 0.019110, 0.018260, 0.017450, 0.016700, 0.015990, 0.015330,
         0.014720, 0.014120, 0.013530, 0.012960, 0.012400, 0.011860, 0.011340, 0.010830, 0.010330, 0.009850,
         0.009384, 0.008932, 0.008493, 0.008069, 0.007658, 0.007261, 0.006877, 0.006506, 0.006148, 0.005802,
         0.005469, 0.005148, 0.004839, 0.004541, 0.004256, 0.003981, 0.003718, 0.003466, 0.003225, 0.002994,
         0.002774, 0.002564, 0.002364, 0.002174, 0.001993, 0.001822, 0.001659, 0.001506, 0.001362, 0.001226,
         0.001099, 0.000979, 0.000868, 0.000765, 0.000669, 0.000580, 0.000499, 0.000425, 0.000357, 0.000296,
         0.000241, 0.000193, 0.000150, 0.000113, 0.000082, 0.000056, 0.000035, 0.000020, 0.000009, 0.000002,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
         0.000000])

P5_k_Brown = np.array([5.272e-01, 5.262e-01, 5.252e-01, 5.242e-01, 5.232e-01, 5.222e-01, 5.212e-01, 5.202e-01, 5.192e-01, 5.182e-01,
            5.172e-01, 5.162e-01, 5.152e-01, 5.142e-01, 5.132e-01, 5.122e-01, 5.112e-01, 5.102e-01, 5.092e-01, 5.082e-01,
            5.072e-01, 5.062e-01, 5.052e-01, 5.042e-01, 5.032e-01, 5.022e-01, 5.012e-01, 5.002e-01, 4.992e-01, 4.982e-01,
            4.972e-01, 4.960e-01, 4.948e-01, 4.936e-01, 4.924e-01, 4.912e-01, 4.900e-01, 4.888e-01, 4.876e-01, 4.864e-01,
            4.852e-01, 4.840e-01, 4.829e-01, 4.817e-01, 4.805e-01, 4.793e-01, 4.781e-01, 4.769e-01, 4.757e-01, 4.745e-01,
            4.733e-01, 4.720e-01, 4.708e-01, 4.695e-01, 4.683e-01, 4.670e-01, 4.658e-01, 4.645e-01, 4.633e-01, 4.620e-01,
            4.608e-01, 4.597e-01, 4.587e-01, 4.577e-01, 4.566e-01, 4.556e-01, 4.546e-01, 4.535e-01, 4.525e-01, 4.515e-01,
            4.504e-01, 4.494e-01, 4.484e-01, 4.473e-01, 4.463e-01, 4.453e-01, 4.442e-01, 4.432e-01, 4.422e-01, 4.411e-01,
            4.401e-01, 4.388e-01, 4.375e-01, 4.362e-01, 4.350e-01, 4.337e-01, 4.324e-01, 4.311e-01, 4.298e-01, 4.285e-01,
            4.272e-01, 4.260e-01, 4.247e-01, 4.234e-01, 4.221e-01, 4.208e-01, 4.195e-01, 4.183e-01, 4.170e-01, 4.157e-01,
            4.144e-01, 4.135e-01, 4.127e-01, 4.118e-01, 4.109e-01, 4.100e-01, 4.092e-01, 4.083e-01, 4.074e-01, 4.065e-01,
            4.057e-01, 4.047e-01, 4.038e-01, 4.028e-01, 4.019e-01, 4.009e-01, 4.000e-01, 3.990e-01, 3.981e-01, 3.971e-01,
            3.962e-01, 3.952e-01, 3.943e-01, 3.933e-01, 3.924e-01, 3.914e-01, 3.905e-01, 3.895e-01, 3.886e-01, 3.876e-01,
            3.867e-01, 3.846e-01, 3.824e-01, 3.803e-01, 3.782e-01, 3.760e-01, 3.739e-01, 3.718e-01, 3.696e-01, 3.675e-01,
            3.654e-01, 3.639e-01, 3.625e-01, 3.611e-01, 3.597e-01, 3.582e-01, 3.568e-01, 3.554e-01, 3.540e-01, 3.525e-01,
            3.511e-01, 3.500e-01, 3.489e-01, 3.478e-01, 3.467e-01, 3.456e-01, 3.445e-01, 3.434e-01, 3.423e-01, 3.412e-01,
            3.401e-01, 3.383e-01, 3.366e-01, 3.348e-01, 3.330e-01, 3.312e-01, 3.294e-01, 3.276e-01, 3.258e-01, 3.241e-01,
            3.223e-01, 3.202e-01, 3.182e-01, 3.162e-01, 3.141e-01, 3.121e-01, 3.100e-01, 3.080e-01, 3.059e-01, 3.039e-01,
            3.019e-01, 2.999e-01, 2.979e-01, 2.959e-01, 2.940e-01, 2.920e-01, 2.900e-01, 2.881e-01, 2.861e-01, 2.841e-01,
            2.821e-01, 2.803e-01, 2.784e-01, 2.766e-01, 2.747e-01, 2.728e-01, 2.710e-01, 2.691e-01, 2.673e-01, 2.654e-01,
            2.636e-01, 2.618e-01, 2.601e-01, 2.584e-01, 2.566e-01, 2.549e-01, 2.532e-01, 2.515e-01, 2.497e-01, 2.480e-01,
            2.463e-01, 2.447e-01, 2.431e-01, 2.414e-01, 2.398e-01, 2.382e-01, 2.366e-01, 2.350e-01, 2.334e-01, 2.318e-01,
            2.302e-01, 2.288e-01, 2.273e-01, 2.258e-01, 2.244e-01, 2.229e-01, 2.215e-01, 2.200e-01, 2.185e-01, 2.171e-01,
            2.156e-01, 2.143e-01, 2.129e-01, 2.115e-01, 2.102e-01, 2.088e-01, 2.074e-01, 2.061e-01, 2.047e-01, 2.033e-01,
            2.020e-01, 2.007e-01, 1.994e-01, 1.981e-01, 1.968e-01, 1.955e-01, 1.942e-01, 1.929e-01, 1.916e-01, 1.903e-01,
            1.890e-01, 1.878e-01, 1.865e-01, 1.853e-01, 1.841e-01, 1.829e-01, 1.816e-01, 1.804e-01, 1.792e-01, 1.780e-01,
            1.768e-01, 1.755e-01, 1.742e-01, 1.729e-01, 1.717e-01, 1.704e-01, 1.691e-01, 1.679e-01, 1.666e-01, 1.653e-01,
            1.641e-01, 1.627e-01, 1.613e-01, 1.600e-01, 1.586e-01, 1.572e-01, 1.559e-01, 1.545e-01, 1.532e-01, 1.518e-01,
            1.504e-01, 1.491e-01, 1.478e-01, 1.464e-01, 1.451e-01, 1.437e-01, 1.424e-01, 1.411e-01, 1.397e-01, 1.384e-01,
            1.370e-01, 1.358e-01, 1.345e-01, 1.333e-01, 1.320e-01, 1.308e-01, 1.295e-01, 1.283e-01, 1.270e-01, 1.258e-01,
            1.245e-01, 1.234e-01, 1.223e-01, 1.212e-01, 1.200e-01, 1.189e-01, 1.178e-01, 1.167e-01, 1.156e-01, 1.144e-01,
            1.133e-01, 1.122e-01, 1.111e-01, 1.100e-01, 1.089e-01, 1.078e-01, 1.067e-01, 1.056e-01, 1.046e-01, 1.035e-01,
            1.024e-01, 1.013e-01, 1.003e-01, 9.931e-02, 9.829e-02, 9.727e-02, 9.625e-02, 9.524e-02, 9.422e-02, 9.320e-02,
            9.218e-02, 9.120e-02, 9.022e-02, 8.924e-02, 8.827e-02, 8.729e-02, 8.631e-02, 8.533e-02, 8.435e-02, 8.337e-02,
            8.239e-02, 8.155e-02, 8.070e-02, 7.985e-02, 7.901e-02, 7.816e-02, 7.732e-02, 7.647e-02, 7.562e-02, 7.478e-02,
            7.393e-02, 7.319e-02, 7.245e-02, 7.171e-02, 7.097e-02, 7.023e-02, 6.949e-02, 6.875e-02, 6.801e-02, 6.727e-02,
            6.653e-02, 6.586e-02, 6.519e-02, 6.452e-02, 6.385e-02, 6.318e-02, 6.251e-02, 6.184e-02, 6.117e-02, 6.050e-02,
            5.983e-02, 5.913e-02, 5.843e-02, 5.773e-02, 5.704e-02, 5.634e-02, 5.564e-02, 5.494e-02, 5.424e-02, 5.354e-02,
            5.284e-02, 5.226e-02, 5.167e-02, 5.109e-02, 5.050e-02, 4.992e-02, 4.933e-02, 4.874e-02, 4.816e-02, 4.757e-02,
            4.699e-02, 4.646e-02, 4.594e-02, 4.542e-02, 4.490e-02, 4.437e-02, 4.385e-02, 4.333e-02, 4.281e-02, 4.228e-02,
            4.176e-02, 4.128e-02, 4.081e-02, 4.033e-02, 3.985e-02, 3.937e-02, 3.889e-02, 3.841e-02, 3.793e-02, 3.746e-02,
            3.698e-02, 3.657e-02, 3.615e-02, 3.574e-02, 3.533e-02, 3.492e-02, 3.451e-02, 3.409e-02, 3.368e-02, 3.327e-02,
            3.286e-02, 3.249e-02, 3.212e-02, 3.175e-02, 3.139e-02, 3.102e-02, 3.065e-02, 3.028e-02, 2.991e-02, 2.954e-02,
            2.918e-02, 2.885e-02, 2.852e-02, 2.819e-02, 2.786e-02, 2.753e-02, 2.720e-02, 2.688e-02, 2.655e-02, 2.622e-02,
            2.589e-02, 2.559e-02, 2.529e-02, 2.499e-02, 2.469e-02, 2.440e-02, 2.410e-02, 2.380e-02, 2.350e-02, 2.320e-02,
            2.290e-02, 2.264e-02, 2.238e-02, 2.212e-02, 2.186e-02, 2.159e-02, 2.133e-02, 2.107e-02, 2.081e-02, 2.055e-02,
            2.029e-02, 2.006e-02, 1.983e-02, 1.961e-02, 1.938e-02, 1.915e-02, 1.893e-02, 1.870e-02, 1.847e-02, 1.825e-02,
            1.802e-02, 1.782e-02, 1.762e-02, 1.742e-02, 1.723e-02, 1.703e-02, 1.683e-02, 1.663e-02, 1.643e-02, 1.623e-02,
            1.604e-02, 1.586e-02, 1.568e-02, 1.551e-02, 1.533e-02, 1.516e-02, 1.498e-02, 1.481e-02, 1.463e-02, 1.446e-02,
            1.428e-02, 1.414e-02, 1.400e-02, 1.385e-02, 1.371e-02, 1.357e-02, 1.343e-02, 1.328e-02, 1.314e-02, 1.300e-02,
            1.286e-02, 1.275e-02, 1.265e-02, 1.255e-02, 1.245e-02, 1.235e-02, 1.225e-02, 1.215e-02, 1.205e-02, 1.195e-02,
            1.185e-02, 1.175e-02, 1.165e-02, 1.155e-02, 1.145e-02, 1.135e-02, 1.125e-02, 1.115e-02, 1.105e-02, 1.096e-02,
            1.086e-02, 1.076e-02, 1.066e-02, 1.056e-02, 1.047e-02, 1.037e-02, 1.027e-02, 1.017e-02, 1.008e-02, 9.980e-03,
            9.884e-03, 9.787e-03, 9.691e-03, 9.595e-03, 9.500e-03, 9.404e-03, 9.309e-03, 9.214e-03, 9.120e-03, 9.025e-03,
            8.931e-03, 8.837e-03, 8.743e-03, 8.650e-03, 8.557e-03, 8.464e-03, 8.371e-03, 8.279e-03, 8.187e-03, 8.095e-03,
            8.004e-03, 7.913e-03, 7.822e-03, 7.732e-03, 7.641e-03, 7.552e-03, 7.462e-03, 7.373e-03, 7.284e-03, 7.195e-03,
            7.107e-03, 7.019e-03, 6.932e-03, 6.844e-03, 6.758e-03, 6.671e-03, 6.585e-03, 6.499e-03, 6.414e-03, 6.329e-03,
            6.244e-03, 6.160e-03, 6.076e-03, 5.993e-03, 5.910e-03, 5.827e-03, 5.745e-03, 5.663e-03, 5.581e-03, 5.500e-03,
            5.419e-03, 5.339e-03, 5.259e-03, 5.180e-03, 5.101e-03, 5.023e-03, 4.945e-03, 4.867e-03, 4.790e-03, 4.713e-03,
            4.637e-03, 4.561e-03, 4.486e-03, 4.411e-03, 4.337e-03, 4.263e-03, 4.190e-03, 4.117e-03, 4.044e-03, 3.972e-03,
            3.901e-03, 3.830e-03, 3.760e-03, 3.690e-03, 3.620e-03, 3.552e-03, 3.483e-03, 3.416e-03, 3.348e-03, 3.282e-03,
            3.215e-03, 3.150e-03, 3.085e-03, 3.020e-03, 2.956e-03, 2.893e-03, 2.830e-03, 2.768e-03, 2.706e-03, 2.645e-03,
            2.585e-03, 2.525e-03, 2.465e-03, 2.407e-03, 2.348e-03, 2.291e-03, 2.234e-03, 2.178e-03, 2.122e-03, 2.067e-03,
            2.012e-03, 1.959e-03, 1.905e-03, 1.853e-03, 1.801e-03, 1.750e-03, 1.699e-03, 1.649e-03, 1.600e-03, 1.551e-03,
            1.503e-03, 1.456e-03, 1.409e-03, 1.363e-03, 1.318e-03, 1.274e-03, 1.230e-03, 1.187e-03, 1.144e-03, 1.102e-03,
            1.061e-03, 1.021e-03, 9.811e-04, 9.422e-04, 9.040e-04, 8.665e-04, 8.297e-04, 7.937e-04, 7.584e-04, 7.239e-04,
            6.901e-04, 6.571e-04, 6.248e-04, 5.933e-04, 5.626e-04, 5.326e-04, 5.034e-04, 4.750e-04, 4.473e-04, 4.205e-04,
            3.944e-04, 3.691e-04, 3.446e-04, 3.210e-04, 2.981e-04, 2.760e-04, 2.548e-04, 2.344e-04, 2.148e-04, 1.960e-04,
            1.780e-04, 1.609e-04, 1.446e-04, 1.292e-04, 1.146e-04, 1.009e-04, 8.804e-05, 7.603e-05, 6.488e-05, 5.460e-05,
            4.519e-05, 3.666e-05, 2.901e-05, 2.225e-05, 1.637e-05, 1.138e-05, 7.297e-06, 4.111e-06, 1.830e-06, 4.581e-07,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0])

P5_k_Cw = np.array([5.8e-05, 5.8e-05, 5.9e-05, 6e-05, 6.1e-05, 6.2e-05, 6.3e-05, 6.4e-05, 6.5e-05, 6.6e-05,
        6.7e-05, 6.8e-05, 6.9e-05, 7.1e-05, 7.2e-05, 7.3e-05, 7.4e-05, 7.5e-05, 7.6e-05, 7.7e-05,
        7.9e-05, 8.1e-05, 8.2e-05, 8.3e-05, 8.4e-05, 8.6e-05, 8.7e-05, 8.8e-05, 8.9e-05, 9.1e-05,
        9.2e-05, 9.3e-05, 9.4e-05, 9.6e-05, 9.7e-05, 9.8e-05, 9.9e-05, 0.0001, 0.000102, 0.000103,
        0.000104, 0.000105, 0.000106, 0.000107, 0.000108, 0.000109, 0.00011, 0.000111, 0.000112, 0.000113,
        0.000114, 0.000115, 0.000116, 0.000117, 0.000118, 0.000119, 0.00012, 0.000121, 0.000122, 0.000123,
        0.000124, 0.000125, 0.000126, 0.000127, 0.000128, 0.000129, 0.00013, 0.000132, 0.000133, 0.000134,
        0.000135, 0.000136, 0.000138, 0.00014, 0.000141, 0.000142, 0.000144, 0.000146, 0.000148, 0.00015,
        0.000152, 0.000154, 0.000157, 0.00016, 0.000162, 0.000164, 0.000167, 0.00017, 0.000174, 0.000177,
        0.000181, 0.000185, 0.000189, 0.000193, 0.000198, 0.000203, 0.000209, 0.000216, 0.000223, 0.00023,
        0.000238, 0.000246, 0.000255, 0.000264, 0.000273, 0.000282, 0.000291, 0.0003, 0.00031, 0.000319,
        0.000329, 0.000339, 0.000349, 0.000359, 0.000368, 0.000377, 0.000386, 0.000396, 0.000404, 0.000407,
        0.000409, 0.000414, 0.000416, 0.000411, 0.000409, 0.000418, 0.000427, 0.000427, 0.000423, 0.000424,
        0.000429, 0.000437, 0.000445, 0.000451, 0.000456, 0.000463, 0.00047, 0.000475, 0.00048, 0.000488,
        0.000495, 0.000498, 0.000503, 0.000514, 0.000527, 0.000536, 0.000544, 0.000553, 0.000564, 0.000576,
        0.000588, 0.0006, 0.000611, 0.000622, 0.000631, 0.000639, 0.000646, 0.000652, 0.000658, 0.000665,
        0.000672, 0.000679, 0.000686, 0.000692, 0.000699, 0.000708, 0.000718, 0.000726, 0.000734, 0.000745,
        0.000759, 0.000773, 0.000787, 0.000802, 0.000819, 0.000839, 0.000858, 0.000875, 0.000896, 0.000924,
        0.000952, 0.000975, 0.001, 0.00104, 0.00108, 0.00112, 0.00116, 0.0012, 0.00125, 0.0013,
        0.00136, 0.00141, 0.00146, 0.00151, 0.00157, 0.00164, 0.0017, 0.00176, 0.00186, 0.00204,
        0.00222, 0.00232, 0.00237, 0.0024, 0.00245, 0.00252, 0.00259, 0.00263, 0.00265, 0.00267,
        0.00269, 0.0027, 0.00272, 0.00273, 0.00274, 0.00275, 0.00276, 0.00277, 0.00279, 0.0028,
        0.00281, 0.00282, 0.00284, 0.00285, 0.00287, 0.00288, 0.00289, 0.00291, 0.00292, 0.00294,
        0.00296, 0.00297, 0.00299, 0.003, 0.00301, 0.00302, 0.00304, 0.00306, 0.00308, 0.00309,
        0.00311, 0.00313, 0.00314, 0.00316, 0.00318, 0.0032, 0.00322, 0.00324, 0.00326, 0.00329,
        0.00332, 0.00334, 0.00336, 0.00339, 0.00342, 0.00346, 0.00351, 0.00357, 0.00364, 0.00371,
        0.00379, 0.00387, 0.00393, 0.00398, 0.00402, 0.00405, 0.00407, 0.00409, 0.0041, 0.00411,
        0.00412, 0.00414, 0.00415, 0.00416, 0.00417, 0.0042, 0.00422, 0.00425, 0.00427, 0.00429,
        0.00432, 0.00435, 0.00438, 0.00442, 0.00446, 0.0045, 0.00455, 0.00459, 0.00465, 0.0047,
        0.00476, 0.00483, 0.0049, 0.00499, 0.00507, 0.00515, 0.00524, 0.00535, 0.00547, 0.00559,
        0.00572, 0.00585, 0.006, 0.00615, 0.0063, 0.00646, 0.00663, 0.0068, 0.00699, 0.0072,
        0.00742, 0.00765, 0.00789, 0.00816, 0.00845, 0.00876, 0.00911, 0.00948, 0.00987, 0.0103,
        0.0107, 0.0112, 0.0117, 0.0122, 0.0127, 0.0132, 0.0137, 0.0143, 0.0149, 0.0155,
        0.0162, 0.017, 0.0179, 0.0189, 0.0199, 0.021, 0.0221, 0.0231, 0.0239, 0.0247,
        0.0253, 0.0258, 0.0262, 0.0265, 0.0267, 0.0269, 0.027, 0.0271, 0.0272, 0.0273,
        0.0273, 0.0274, 0.0274, 0.0274, 0.0275, 0.0275, 0.0275, 0.0276, 0.0276, 0.0277,
        0.0277, 0.0277, 0.0277, 0.0277, 0.0277, 0.0277, 0.0277, 0.0277, 0.0276, 0.0276,
        0.0275, 0.0275, 0.0275, 0.0274, 0.0273, 0.0272, 0.0271, 0.027, 0.0269, 0.0268,
        0.0266, 0.0264, 0.0263, 0.0262, 0.0261, 0.0259, 0.0256, 0.0252, 0.0251, 0.025,
        0.0247, 0.0245, 0.0241, 0.0239, 0.0237, 0.0236, 0.0234, 0.0232, 0.023, 0.0228,
        0.0225, 0.0224, 0.0224, 0.0222, 0.022, 0.022, 0.022, 0.022, 0.0218, 0.0219,
        0.0219, 0.0219, 0.022, 0.0221, 0.0222, 0.0223, 0.0225, 0.0228, 0.023, 0.0231,
        0.0233, 0.0239, 0.0245, 0.0248, 0.0252, 0.0262, 0.0277, 0.0283, 0.0291, 0.0311,
        0.0321, 0.033, 0.0346, 0.0361, 0.0366, 0.037, 0.0379, 0.0383, 0.0385, 0.0391,
        0.0395, 0.0397, 0.04, 0.0404, 0.0406, 0.0407, 0.0411, 0.0413, 0.0415, 0.042,
        0.042, 0.0422, 0.0425, 0.0427, 0.0428, 0.0431, 0.0436, 0.0437, 0.0438, 0.0443,
        0.0445, 0.0447, 0.045, 0.0453, 0.0455, 0.0461, 0.0466, 0.0469, 0.0471, 0.0471,
        0.0475, 0.0483, 0.0487, 0.0489, 0.0496, 0.0501, 0.0505, 0.0512, 0.0515, 0.052,
        0.053, 0.0535, 0.0539, 0.0546, 0.0553, 0.0557, 0.056, 0.0565, 0.0575, 0.0579,
        0.0583, 0.0592, 0.0598, 0.0601, 0.0604, 0.0609, 0.0619, 0.0623, 0.0627, 0.0636,
        0.0641, 0.0646, 0.0656, 0.0664, 0.0667, 0.067, 0.0677, 0.069, 0.0699, 0.0704,
        0.0708, 0.0719, 0.0736, 0.0749, 0.0756, 0.0763, 0.0779, 0.0809, 0.0829, 0.0841,
        0.0853, 0.088, 0.0927, 0.0958, 0.0982, 0.101, 0.104, 0.107, 0.111, 0.119,
        0.125, 0.128, 0.133, 0.137, 0.141, 0.147, 0.156, 0.164, 0.169, 0.173,
        0.182, 0.196, 0.205, 0.211, 0.219, 0.229, 0.239, 0.247, 0.254, 0.27,
        0.298, 0.315, 0.327, 0.344, 0.362, 0.379, 0.393, 0.407, 0.418, 0.427,
        0.439, 0.454, 0.461, 0.463, 0.466, 0.47, 0.473, 0.476, 0.477, 0.479,
        0.48, 0.481, 0.483, 0.484, 0.486, 0.487, 0.487, 0.486, 0.486, 0.484,
        0.482, 0.48, 0.479, 0.476, 0.474, 0.471, 0.468, 0.464, 0.46, 0.457,
        0.453, 0.448, 0.443, 0.44, 0.436, 0.432, 0.426, 0.422, 0.417, 0.412,
        0.407, 0.402, 0.396, 0.391, 0.387, 0.382, 0.376, 0.37, 0.364, 0.358,
        0.352, 0.346, 0.34, 0.335, 0.33, 0.324, 0.319, 0.314, 0.309, 0.302,
        0.296, 0.29, 0.284, 0.278, 0.272, 0.267, 0.262, 0.257, 0.251, 0.244,
        0.239, 0.236, 0.233, 0.23, 0.225, 0.22, 0.215, 0.211, 0.206, 0.202,
        0.198, 0.194, 0.19, 0.187, 0.184, 0.182, 0.179, 0.175, 0.171, 0.169,
        0.166, 0.164, 0.161, 0.159, 0.156, 0.154, 0.153, 0.152, 0.151, 0.15,
        0.148, 0.146, 0.145, 0.144, 0.144, 0.143, 0.143, 0.142, 0.141, 0.141,
        0.141, 0.141, 0.141, 0.141, 0.141, 0.141, 0.143, 0.144, 0.144, 0.144,
        0.144, 0.146, 0.148, 0.15, 0.152, 0.153, 0.155, 0.156, 0.158, 0.16,
        0.163, 0.166, 0.168, 0.169, 0.171, 0.174, 0.178, 0.182, 0.187, 0.189,
        0.191, 0.193, 0.197, 0.201, 0.203, 0.205, 0.208, 0.212, 0.217, 0.22,
        0.222, 0.225, 0.23, 0.234, 0.235, 0.234, 0.235, 0.24, 0.245, 0.249,
        0.253, 0.258, 0.265, 0.272, 0.277, 0.281, 0.289, 0.302, 0.316, 0.327,
        0.338, 0.353, 0.377, 0.404, 0.428, 0.45, 0.471, 0.493, 0.52, 0.557,
        0.605, 0.652, 0.686, 0.716, 0.754, 0.806, 0.86, 0.898, 0.925, 0.949,
        0.977, 1.01, 1.04, 1.07, 1.1, 1.12, 1.13, 1.14, 1.15, 1.16,
        1.17, 1.18, 1.19, 1.19, 1.2, 1.2, 1.2, 1.2, 1.21, 1.21,
        1.21, 1.21, 1.22, 1.23, 1.23, 1.23, 1.23, 1.23, 1.23, 1.24,
        1.24, 1.24, 1.24, 1.25, 1.25, 1.26, 1.26, 1.26, 1.26, 1.26,
        1.27, 1.27, 1.27, 1.27, 1.28, 1.28, 1.28, 1.28, 1.28, 1.28,
        1.27, 1.27, 1.27, 1.27, 1.27, 1.27, 1.26, 1.26, 1.26, 1.26,
        1.26, 1.25, 1.25, 1.24, 1.24, 1.24, 1.24, 1.23, 1.22, 1.22,
        1.21, 1.21, 1.21, 1.21, 1.2, 1.2, 1.2, 1.2, 1.2, 1.19,
        1.19, 1.18, 1.18, 1.18, 1.17, 1.17, 1.16, 1.16, 1.16, 1.16,
        1.16, 1.15, 1.15, 1.14, 1.14, 1.13, 1.13, 1.13, 1.12, 1.12,
        1.12, 1.11, 1.11, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1,
        1.09, 1.09, 1.09, 1.08, 1.08, 1.08, 1.08, 1.08, 1.08, 1.08,
        1.08, 1.08, 1.09, 1.09, 1.1, 1.1, 1.11, 1.11, 1.11, 1.12,
        1.12, 1.13, 1.14, 1.15, 1.16, 1.16, 1.17, 1.18, 1.18, 1.19,
        1.2, 1.21, 1.22, 1.23, 1.24, 1.25, 1.27, 1.28, 1.3, 1.31,
        1.32, 1.34, 1.35, 1.37, 1.39, 1.42, 1.44, 1.47, 1.49, 1.51,
        1.53, 1.55, 1.58, 1.61, 1.64, 1.67, 1.7, 1.73, 1.76, 1.79,
        1.83, 1.87, 1.91, 1.94, 1.97, 2.01, 2.05, 2.1, 2.15, 2.2,
        2.24, 2.28, 2.31, 2.36, 2.41, 2.48, 2.54, 2.59, 2.63, 2.67,
        2.7, 2.74, 2.78, 2.83, 2.89, 2.96, 3.03, 3.1, 3.15, 3.18,
        3.23, 3.27, 3.32, 3.36, 3.41, 3.45, 3.5, 3.54, 3.6, 3.65,
        3.7, 3.75, 3.8, 3.87, 3.93, 3.99, 4.06, 4.13, 4.22, 4.3,
        4.39, 4.5, 4.63, 4.74, 4.9, 5.09, 5.26, 5.48, 5.72, 6.01,
        6.24, 6.58, 6.93, 7.31, 7.63, 8.09, 8.55, 9.03, 9.59, 10.0,
        10.6, 11.2, 11.8, 12.5, 13.2, 13.7, 14.3, 15.1, 15.8, 16.5,
        17.1, 17.8, 18.5, 19.2, 19.8, 20.3, 20.9, 21.5, 22.0, 22.6,
        23.1, 23.6, 24.1, 24.5, 24.9, 25.3, 25.7, 26.1, 26.4, 26.7,
        27.0, 27.3, 27.6, 27.8, 28.1, 28.3, 28.6, 28.7, 28.9, 29.1,
        29.3, 29.4, 29.6, 29.7, 29.8, 29.9, 30.0, 30.1, 30.2, 30.3,
        30.4, 30.4, 30.5, 30.5, 30.5, 30.5, 30.6, 30.6, 30.6, 30.6,
        30.5, 30.5, 30.5, 30.4, 30.4, 30.4, 30.3, 30.2, 30.1, 30.1,
        30.0, 29.8, 29.7, 29.6, 29.4, 29.2, 29.0, 28.7, 28.5, 28.3,
        28.0, 27.8, 27.5, 27.2, 27.0, 26.6, 26.4, 26.1, 25.8, 25.6,
        25.2, 25.0, 24.7, 24.4, 24.1, 23.9, 23.6, 23.3, 23.1, 22.7,
        22.5, 22.2, 21.9, 21.6, 21.4, 21.1, 20.8, 20.5, 20.3, 20.0,
        19.7, 19.5, 19.2, 19.0, 18.7, 18.5, 18.3, 18.0, 17.8, 17.6,
        17.3, 17.1, 16.9, 16.7, 16.5, 16.2, 16.1, 15.8, 15.6, 15.4,
        15.2, 15.0, 14.9, 14.7, 14.5, 14.3, 14.1, 13.9, 13.8, 13.6,
        13.5, 13.3, 13.2, 13.0, 12.8, 12.7, 12.5, 12.4, 12.2, 12.1,
        11.9, 11.8, 11.7, 11.5, 11.4, 11.3, 11.1, 11.0, 10.9, 10.8,
        10.6, 10.5, 10.4, 10.3, 10.2, 10.1, 10.0, 9.91, 9.84, 9.75,
        9.66, 9.56, 9.48, 9.38, 9.3, 9.2, 9.13, 9.05, 8.98, 8.9,
        8.82, 8.74, 8.66, 8.59, 8.51, 8.45, 8.36, 8.3, 8.23, 8.16,
        8.1, 8.04, 7.96, 7.89, 7.83, 7.77, 7.71, 7.65, 7.61, 7.55,
        7.49, 7.43, 7.37, 7.31, 7.25, 7.2, 7.16, 7.12, 7.08, 7.04,
        6.99, 6.94, 6.91, 6.86, 6.83, 6.78, 6.74, 6.71, 6.7, 6.65,
        6.63, 6.6, 6.57, 6.53, 6.5, 6.47, 6.45, 6.42, 6.4, 6.36,
        6.35, 6.31, 6.28, 6.25, 6.21, 6.19, 6.16, 6.13, 6.12, 6.09,
        6.08, 6.05, 6.05, 6.02, 6.0, 5.98, 5.97, 5.95, 5.94, 5.92,
        5.91, 5.89, 5.88, 5.85, 5.83, 5.8, 5.79, 5.75, 5.75, 5.72,
        5.7, 5.69, 5.68, 5.66, 5.66, 5.64, 5.65, 5.63, 5.63, 5.62,
        5.62, 5.6, 5.61, 5.6, 5.6, 5.58, 5.58, 5.56, 5.56, 5.55,
        5.55, 5.54, 5.54, 5.53, 5.53, 5.53, 5.53, 5.53, 5.53, 5.52,
        5.52, 5.52, 5.53, 5.52, 5.52, 5.52, 5.52, 5.51, 5.53, 5.51,
        5.52, 5.51, 5.52, 5.51, 5.52, 5.52, 5.54, 5.54, 5.54, 5.56,
        5.57, 5.58, 5.61, 5.61, 5.63, 5.64, 5.66, 5.67, 5.69, 5.7,
        5.73, 5.75, 5.77, 5.78, 5.8, 5.81, 5.83, 5.84, 5.88, 5.89,
        5.93, 5.95, 5.97, 6.0, 6.02, 6.05, 6.09, 6.1, 6.14, 6.17,
        6.2, 6.22, 6.26, 6.28, 6.33, 6.37, 6.39, 6.44, 6.49, 6.52,
        6.57, 6.62, 6.66, 6.69, 6.75, 6.8, 6.84, 6.9, 6.95, 7.0,
        7.05, 7.11, 7.18, 7.24, 7.27, 7.34, 7.41, 7.48, 7.54, 7.59,
        7.67, 7.73, 7.78, 7.83, 7.89, 7.95, 8.0, 8.04, 8.1, 8.16,
        8.21, 8.24, 8.26, 8.32, 8.35, 8.39, 8.43, 8.45, 8.48, 8.51,
        8.54, 8.56, 8.59, 8.62, 8.64, 8.67, 8.69, 8.72, 8.74, 8.76,
        8.78, 8.78, 8.78, 8.79, 8.8, 8.81, 8.81, 8.81, 8.8, 8.79,
        8.79, 8.78, 8.77, 8.75, 8.75, 8.74, 8.74, 8.73, 8.74, 8.75,
        8.76, 8.78, 8.79, 8.79, 8.8, 8.79, 8.81, 8.82, 8.84, 8.85,
        8.85, 8.86, 8.87, 8.87, 8.88, 8.89, 8.9, 8.92, 8.95, 8.97,
        9.01, 9.03, 9.11, 9.15, 9.2, 9.26, 9.31, 9.38, 9.46, 9.54,
        9.63, 9.72, 9.82, 9.93, 10.1, 10.2, 10.3, 10.4, 10.6, 10.7,
        10.9, 11.1, 11.4, 11.6, 11.8, 12.1, 12.4, 12.7, 13.0, 13.3,
        13.8, 14.1, 14.8, 15.3, 15.9, 16.4, 17.1, 17.7, 18.5, 19.2,
        20.5, 21.5, 22.5, 23.7, 24.8, 26.2, 27.5, 29.7, 31.4, 33.2,
        35.0, 37.2, 39.3, 42.7, 45.3, 47.9, 50.6, 53.6, 57.6, 60.9,
        64.0, 67.2, 70.6, 75.0, 78.4, 81.6, 84.7, 87.5, 91.9, 94.6,
        97.2, 100.0, 103.0, 106.0, 108.0, 110.0, 112.0, 114.0, 116.0, 117.0,
        119.0, 120.0, 122.0, 123.0, 124.0, 125.0, 126.0, 126.0, 128.0, 128.0,
        129.0, 129.0, 130.0, 130.0, 130.0, 130.0, 131.0, 131.0, 131.0, 130.0,
        130.0, 130.0, 130.0, 130.0, 129.0, 129.0, 128.0, 127.0, 127.0, 126.0,
        126.0, 125.0, 124.0, 123.0, 122.0, 122.0, 121.0, 120.0, 119.0, 118.0,
        117.0, 116.0, 115.0, 114.0, 113.0, 112.0, 111.0, 110.0, 109.0, 108.0,
        107.0, 106.0, 104.0, 104.0, 102.0, 101.0, 101.0, 99.3, 98.3, 97.1,
        96.3, 94.9, 94.1, 93.4, 92.1, 91.2, 90.1, 89.3, 88.0, 87.2,
        86.1, 85.3, 84.6, 83.4, 82.6, 81.5, 80.8, 79.7, 79.0, 78.0,
        77.2, 76.3, 75.6, 74.6, 73.9, 73.0, 72.3, 71.4, 70.8, 69.9,
        69.2, 68.7, 67.8, 66.9, 66.3, 65.5, 64.9, 64.1, 63.6, 62.8,
        62.3, 61.6, 61.1, 60.3, 59.8, 59.1, 58.6, 57.9, 57.5, 56.8,
        56.3, 55.7, 55.0, 54.6, 54.0, 53.6, 52.9, 52.6, 52.0, 51.4,
        51.0, 50.5, 50.1, 49.5, 49.2, 48.6, 48.1, 47.7, 47.2, 46.8,
        46.3, 45.8, 45.5, 45.0, 44.7, 44.3, 43.8, 43.5, 43.0, 42.7,
        42.3, 41.9, 41.6, 41.2, 40.7, 40.5, 40.0, 39.8, 39.3, 38.9,
        38.7, 38.3, 37.9, 37.6, 37.3, 36.9, 36.6, 36.3, 35.9, 35.7,
        35.4, 35.0, 34.8, 34.5, 34.1, 33.9, 33.6, 33.3, 33.1, 32.8,
        32.5, 32.3, 32.0, 31.7, 31.5, 31.3, 31.0, 30.7, 30.5, 30.3,
        30.0, 29.8, 29.6, 29.3, 29.1, 28.9, 28.6, 28.4, 28.2, 28.0,
        27.8, 27.5, 27.4, 27.1, 26.9, 26.7, 26.6, 26.4, 26.2, 26.0,
        25.8, 25.7, 25.5, 25.3, 25.2, 25.0, 24.8, 24.7, 24.5, 24.4,
        24.2, 24.0, 23.9, 23.7, 23.6, 23.4, 23.3, 23.2, 23.0, 22.9,
        22.8, 22.6, 22.5, 22.4, 22.3, 22.1, 22.0, 21.9, 21.8, 21.7,
        21.6, 21.5, 21.4, 21.3, 21.2, 21.1, 21.0, 20.9, 20.8, 20.8,
        20.7, 20.6, 20.5, 20.4, 20.3, 20.3, 20.2, 20.1, 20.0, 19.9,
        19.9, 19.8, 19.8, 19.7, 19.6, 19.6, 19.5, 19.5, 19.4, 19.4,
        19.3, 19.3, 19.2, 19.2, 19.1, 19.1, 19.0, 19.0, 19.0, 18.9,
        18.8, 18.8, 18.7, 18.7, 18.7, 18.6, 18.6, 18.5, 18.5, 18.4,
        18.4, 18.4, 18.4, 18.4, 18.4, 18.4, 18.4, 18.4, 18.3, 18.3,
        18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3,
        18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.3, 18.4, 18.4,
        18.4, 18.4, 18.4, 18.4, 18.4, 18.4, 18.5, 18.5, 18.5, 18.5,
        18.6, 18.6, 18.6, 18.6, 18.6, 18.7, 18.7, 18.7, 18.8, 18.8,
        18.9, 18.9, 19.0, 19.0, 19.1, 19.1, 19.2, 19.2, 19.3, 19.3,
        19.4, 19.5, 19.5, 19.6, 19.7, 19.7, 19.8, 19.8, 19.9, 20.0,
        20.0, 20.1, 20.2, 20.3, 20.4, 20.5, 20.5, 20.6, 20.7, 20.8,
        20.9, 20.9, 21.0, 21.1, 21.3, 21.4, 21.5, 21.5, 21.6, 21.7,
        21.8, 21.9, 22.0, 22.1, 22.2, 22.3, 22.5, 22.6, 22.8, 22.9,
        23.0, 23.1, 23.3, 23.4, 23.5, 23.6, 23.8, 23.9, 24.1, 24.2,
        24.3, 24.4, 24.6, 24.7, 24.9, 25.0, 25.2, 25.3, 25.5, 25.6,
        25.8, 25.9, 26.1, 26.2, 26.5, 26.6, 26.8, 27.0, 27.1, 27.3,
        27.4, 27.6, 27.9, 28.0, 28.2, 28.4, 28.6, 28.7, 29.0, 29.2,
        29.3, 29.5, 29.7, 29.9, 30.0, 30.4, 30.5, 30.7, 30.9, 31.1,
        31.4, 31.6, 31.8, 32.0, 32.2, 32.4, 32.7, 32.9, 33.1, 33.3,
        33.5, 33.9, 34.0, 34.3, 34.5, 34.7, 34.9, 35.3, 35.5, 35.7,
        35.9, 36.1, 36.6, 36.8, 37.0, 37.2, 37.6, 37.8, 38.0, 38.3,
        38.5, 38.9, 39.1, 39.4, 39.6, 40.1, 40.2, 40.5, 40.8, 41.0,
        41.5, 41.7, 42.0, 42.2, 42.7, 42.9, 43.2, 43.4, 43.9, 44.1,
        44.4, 44.6, 45.1, 45.4, 45.6, 45.9, 46.4, 46.6, 46.9, 47.1,
        47.6, 47.9, 48.2, 48.4, 48.9, 49.2, 49.4, 50.0, 50.2, 50.5,
        50.8, 51.3, 51.6, 51.9, 52.5, 52.7, 53.1, 53.4, 54.0, 54.3,
        54.6, 55.2, 55.6, 55.9, 56.2, 56.9, 57.1, 57.5, 58.1, 58.4,
        58.8, 59.5, 59.8, 60.1, 60.4, 61.1, 61.5, 61.8, 62.5, 62.9,
        63.2, 63.9, 64.3, 64.6, 65.4, 65.7, 66.1, 66.9, 67.2, 67.6,
        68.4, 68.8, 69.2, 70.1, 70.5, 70.8, 71.7, 72.1, 72.5, 73.4,
        73.8, 74.2, 75.1, 75.5, 75.9, 76.7, 77.2, 78.0, 78.4, 78.8,
        79.7, 80.0, 80.5, 81.4, 81.7, 82.1, 82.9, 83.4, 84.2, 84.7,
        85.1, 85.8, 86.2, 86.4, 87.1, 87.6, 88.8, 89.0, 89.4, 90.6,
        90.9, 91.3, 92.0, 92.4, 93.1, 93.3, 93.6, 94.2, 94.5, 95.0,
        95.3])

P5_k_Cm = np.array([109.7, 103.7, 97.98, 92.44, 87.13, 82.31, 78.06, 74.04, 70.13, 66.54,
        63.0, 59.54, 56.16, 53.0, 50.01, 47.23, 44.63, 42.2, 39.96, 37.8,
        35.67, 33.62, 31.7, 29.93, 28.32, 26.79, 25.35, 24.02, 22.76, 21.5,
        20.24, 19.01, 17.85, 16.76, 15.75, 14.81, 13.92, 13.12, 12.33, 11.61,
        10.96, 10.41, 9.924, 9.41, 8.947, 8.508, 8.087, 7.64, 7.268, 6.939,
        6.66, 6.422, 6.222, 6.01, 5.782, 5.573, 5.37, 5.173, 4.946, 4.761,
        4.575, 4.419, 4.259, 4.117, 4.006, 3.945, 3.853, 3.784, 3.671, 3.554,
        3.462, 3.363, 3.282, 3.184, 3.102, 3.051, 2.983, 2.947, 2.913, 2.869,
        2.803, 2.777, 2.751, 2.726, 2.702, 2.679, 2.656, 2.634, 2.613, 2.593,
        2.573, 2.554, 2.536, 2.519, 2.502, 2.486, 2.471, 2.457, 2.443, 2.43,
        2.417, 2.405, 2.394, 2.384, 2.374, 2.365, 2.356, 2.348, 2.341, 2.334,
        2.328, 2.323, 2.318, 2.314, 2.31, 2.307, 2.304, 2.302, 2.301, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3, 2.3,
        2.3, 2.3, 2.301, 2.301, 2.302, 2.303, 2.305, 2.306, 2.308, 2.31,
        2.312, 2.315, 2.317, 2.32, 2.323, 2.327, 2.33, 2.334, 2.338, 2.342,
        2.346, 2.35, 2.354, 2.359, 2.364, 2.369, 2.374, 2.379, 2.384, 2.389,
        2.395, 2.4, 2.406, 2.412, 2.418, 2.423, 2.43, 2.436, 2.442, 2.448,
        2.454, 2.461, 2.467, 2.473, 2.48, 2.486, 2.493, 2.499, 2.506, 2.512,
        2.519, 2.525, 2.532, 2.538, 2.545, 2.551, 2.558, 2.564, 2.57, 2.577,
        2.583, 2.589, 2.595, 2.601, 2.607, 2.613, 2.619, 2.625, 2.631, 2.636,
        2.642, 2.647, 2.652, 2.657, 2.662, 2.667, 2.672, 2.677, 2.681, 2.685,
        2.689, 2.693, 2.697, 2.701, 2.704, 2.707, 2.711, 2.713, 2.716, 2.719,
        2.721, 2.723, 2.725, 2.726, 2.728, 2.729, 2.73, 2.73, 2.731, 2.731,
        2.721, 2.736, 2.728, 2.719, 2.712, 2.698, 2.702, 2.691, 2.688, 2.686,
        2.682, 2.676, 2.675, 2.677, 2.67, 2.671, 2.668, 2.67, 2.674, 2.674,
        2.683, 2.674, 2.675, 2.682, 2.683, 2.665, 2.661, 2.668, 2.67, 2.674,
        2.664, 2.661, 2.665, 2.668, 2.681, 2.686, 2.684, 2.697, 2.712, 2.72,
        2.717, 2.726, 2.744, 2.743, 2.751, 2.763, 2.778, 2.793, 2.818, 2.835,
        2.865, 2.879, 2.899, 2.918, 2.936, 2.953, 2.966, 2.977, 2.981, 2.942,
        2.887, 2.864, 2.877, 2.886, 2.888, 2.891, 2.899, 2.887, 2.884, 2.9,
        2.929, 2.969, 3.014, 3.053, 3.075, 3.111, 3.128, 3.13, 3.103, 3.051,
        2.979, 2.941, 2.92, 2.931, 2.95, 2.978, 3.025, 3.048, 3.066, 3.087,
        3.099, 3.09, 3.088, 3.081, 3.085, 3.071, 3.065, 3.069, 3.067, 3.085,
        3.094, 3.11, 3.136, 3.149, 3.158, 3.191, 3.23, 3.265, 3.298, 3.356,
        3.419, 3.476, 3.534, 3.584, 3.632, 3.708, 3.775, 3.847, 3.931, 3.987,
        4.071, 4.156, 4.242, 4.32, 4.395, 4.48, 4.561, 4.638, 4.708, 4.782,
        4.846, 4.906, 4.974, 5.026, 5.071, 5.131, 5.179, 5.22, 5.271, 5.322,
        5.358, 5.403, 5.441, 5.46, 5.481, 5.5, 5.523, 5.548, 5.56, 5.575,
        5.582, 5.597, 5.611, 5.639, 5.653, 5.675, 5.682, 5.685, 5.68, 5.689,
        5.711, 5.723, 5.715, 5.716, 5.732, 5.741, 5.743, 5.752, 5.745, 5.744,
        5.757, 5.766, 5.78, 5.787, 5.798, 5.81, 5.808, 5.815, 5.825, 5.824,
        5.827, 5.854, 5.878, 5.9, 5.908, 5.922, 5.94, 5.962, 5.963, 5.966,
        5.982, 5.99, 5.994, 6.016, 6.014, 6.025, 6.008, 6.022, 6.021, 6.027,
        6.027, 6.035, 6.025, 6.009, 5.989, 5.987, 5.984, 5.971, 5.971, 5.973,
        5.951, 5.952, 5.939, 5.933, 5.931, 5.925, 5.909, 5.897, 5.884, 5.881,
        5.876, 5.856, 5.843, 5.83, 5.818, 5.807, 5.799, 5.792, 5.776, 5.783,
        5.776, 5.767, 5.762, 5.769, 5.756, 5.762, 5.737, 5.74, 5.757, 5.756,
        5.751, 5.754, 5.751, 5.75, 5.744, 5.744, 5.754, 5.744, 5.735, 5.74,
        5.732, 5.728, 5.731, 5.724, 5.724, 5.715, 5.697, 5.693, 5.703, 5.7,
        5.713, 5.728, 5.731, 5.735, 5.743, 5.754, 5.753, 5.744, 5.746, 5.746,
        5.746, 5.75, 5.749, 5.743, 5.74, 5.747, 5.739, 5.755, 5.749, 5.753,
        5.745, 5.732, 5.735, 5.724, 5.725, 5.712, 5.702, 5.7, 5.699, 5.686,
        5.685, 5.672, 5.659, 5.627, 5.613, 5.59, 5.591, 5.563, 5.552, 5.525,
        5.517, 5.506, 5.494, 5.459, 5.45, 5.438, 5.428, 5.407, 5.391, 5.382,
        5.376, 5.358, 5.347, 5.333, 5.319, 5.301, 5.292, 5.284, 5.274, 5.258,
        5.253, 5.249, 5.233, 5.222, 5.211, 5.204, 5.21, 5.2, 5.193, 5.186,
        5.177, 5.175, 5.178, 5.173, 5.152, 5.135, 5.139, 5.128, 5.121, 5.114,
        5.126, 5.107, 5.104, 5.1, 5.109, 5.114, 5.112, 5.128, 5.136, 5.131,
        5.152, 5.175, 5.193, 5.2, 5.244, 5.257, 5.273, 5.289, 5.335, 5.366,
        5.389, 5.427, 5.453, 5.49, 5.522, 5.562, 5.605, 5.652, 5.698, 5.744,
        5.743, 5.642, 5.689, 5.722, 5.755, 5.798, 5.847, 5.875, 5.918, 5.971,
        6.022, 6.061, 6.116, 6.173, 6.214, 6.266, 6.319, 6.381, 6.426, 6.486,
        6.541, 6.579, 6.616, 6.666, 6.728, 6.771, 6.807, 6.858, 6.907, 6.959,
        7.006, 7.052, 7.093, 7.136, 7.164, 7.199, 7.232, 7.266, 7.315, 7.34,
        7.361, 7.399, 7.44, 7.473, 7.505, 7.525, 7.557, 7.579, 7.604, 7.633,
        7.653, 7.674, 7.691, 7.699, 7.708, 7.721, 7.73, 7.729, 7.712, 7.702,
        7.695, 7.67, 7.644, 7.618, 7.585, 7.555, 7.517, 7.479, 7.451, 7.435,
        7.408, 7.379, 7.363, 7.347, 7.332, 7.332, 7.332, 7.304, 7.295, 7.296,
        7.291, 7.292, 7.292, 7.281, 7.283, 7.264, 7.25, 7.24, 7.228, 7.21,
        7.186, 7.164, 7.143, 7.114, 7.101, 7.069, 7.038, 7.003, 6.974, 6.928,
        6.889, 6.839, 6.793, 6.764, 6.729, 6.694, 6.661, 6.613, 6.572, 6.546,
        6.522, 6.507, 6.482, 6.484, 6.479, 6.494, 6.496, 6.491, 6.461, 6.44,
        6.43, 6.413, 6.421, 6.399, 6.379, 6.365, 6.372, 6.346, 6.321, 6.31,
        6.314, 6.282, 6.277, 6.27, 6.258, 6.242, 6.234, 6.221, 6.231, 6.221,
        6.205, 6.192, 6.192, 6.179, 6.159, 6.143, 6.143, 6.12, 6.098, 6.087,
        6.063, 6.056, 6.053, 6.04, 6.044, 6.007, 5.996, 5.994, 5.997, 5.975,
        5.954, 5.946, 5.927, 5.914, 5.89, 5.873, 5.832, 5.794, 5.768, 5.728,
        5.681, 5.68, 5.655, 5.648, 5.62, 5.594, 5.567, 5.557, 5.552, 5.553,
        5.539, 5.523, 5.507, 5.505, 5.487, 5.474, 5.462, 5.45, 5.448, 5.441,
        5.44, 5.442, 5.449, 5.466, 5.461, 5.452, 5.445, 5.412, 5.379, 5.28,
        5.228, 5.199, 5.171, 5.139, 5.124, 5.112, 5.129, 5.144, 5.173, 5.176,
        5.185, 5.183, 5.2, 5.202, 5.204, 5.224, 5.244, 5.297, 5.318, 5.375,
        5.441, 5.491, 5.561, 5.629, 5.687, 5.757, 5.83, 5.911, 5.998, 6.09,
        6.193, 6.33, 6.449, 6.581, 6.71, 6.838, 6.97, 7.107, 7.238, 7.388,
        7.506, 7.635, 7.767, 7.874, 7.977, 8.071, 8.15, 8.22, 8.292, 8.35,
        8.449, 8.521, 8.583, 8.666, 8.723, 8.759, 8.821, 8.864, 8.909, 8.941,
        8.949, 8.955, 8.983, 9.022, 9.043, 9.044, 9.028, 9.034, 9.052, 9.048,
        9.041, 9.037, 9.036, 9.035, 9.021, 9.016, 9.008, 8.97, 8.974, 8.953,
        8.957, 8.937, 8.923, 8.912, 8.895, 8.891, 8.88, 8.867, 8.855, 8.852,
        8.861, 8.864, 8.876, 8.869, 8.872, 8.855, 8.828, 8.839, 8.855, 8.856,
        8.833, 8.842, 8.843, 8.83, 8.808, 8.818, 8.807, 8.797, 8.794, 8.791,
        8.795, 8.771, 8.754, 8.759, 8.76, 8.746, 8.762, 8.778, 8.79, 8.795,
        8.811, 8.848, 8.874, 8.885, 8.913, 8.944, 8.98, 8.988, 9.001, 9.034,
        9.076, 9.111, 9.141, 9.171, 9.214, 9.255, 9.303, 9.356, 9.406, 9.448,
        9.516, 9.578, 9.638, 9.692, 9.763, 9.845, 9.953, 10.04, 10.14, 10.27,
        10.39, 10.52, 10.63, 10.77, 10.91, 11.03, 11.19, 11.35, 11.5, 11.65,
        11.81, 12.01, 12.17, 12.34, 12.51, 12.69, 12.87, 13.07, 13.25, 13.46,
        13.64, 13.84, 14.03, 14.23, 14.41, 14.61, 14.81, 14.99, 15.17, 15.34,
        15.54, 15.71, 15.91, 16.07, 16.22, 16.37, 16.53, 16.67, 16.78, 16.9,
        16.98, 17.08, 17.18, 17.25, 17.34, 17.39, 17.48, 17.55, 17.61, 17.67,
        17.71, 17.77, 17.83, 17.87, 17.94, 17.95, 17.99, 18.05, 18.09, 18.13,
        18.2, 18.27, 18.3, 18.35, 18.41, 18.46, 18.52, 18.56, 18.61, 18.66,
        18.71, 18.76, 18.81, 18.85, 18.9, 18.96, 19.03, 19.07, 19.11, 19.16,
        19.21, 19.27, 19.29, 19.32, 19.35, 19.36, 19.4, 19.43, 19.47, 19.51,
        19.53, 19.56, 19.6, 19.61, 19.62, 19.66, 19.66, 19.69, 19.7, 19.72,
        19.74, 19.74, 19.76, 19.78, 19.79, 19.82, 19.82, 19.83, 19.86, 19.88,
        19.89, 19.89, 19.93, 19.93, 19.97, 20.01, 20.01, 20.04, 20.07, 20.11,
        20.13, 20.15, 20.17, 20.19, 20.22, 20.23, 20.23, 20.26, 20.27, 20.29,
        20.28, 20.27, 20.29, 20.29, 20.31, 20.29, 20.26, 20.3, 20.3, 20.3,
        20.3, 20.31, 20.29, 20.29, 20.26, 20.25, 20.23, 20.2, 20.16, 20.15,
        20.12, 20.09, 20.07, 20.03, 19.98, 19.95, 19.91, 19.86, 19.8, 19.75,
        19.69, 19.64, 19.59, 19.53, 19.47, 19.41, 19.36, 19.31, 19.22, 19.18,
        19.12, 19.05, 18.99, 18.9, 18.85, 18.81, 18.74, 18.67, 18.61, 18.58,
        18.52, 18.46, 18.4, 18.34, 18.29, 18.24, 18.18, 18.13, 18.07, 18.03,
        17.98, 17.92, 17.87, 17.82, 17.8, 17.75, 17.73, 17.68, 17.68, 17.66,
        17.63, 17.62, 17.63, 17.64, 17.64, 17.66, 17.7, 17.74, 17.79, 17.86,
        17.95, 18.03, 18.14, 18.25, 18.36, 18.51, 18.66, 18.81, 18.95, 19.13,
        19.31, 19.51, 19.72, 19.94, 20.17, 20.4, 20.65, 20.89, 21.14, 21.4,
        21.63, 21.86, 22.1, 22.36, 22.62, 22.9, 23.13, 23.39, 23.61, 23.86,
        24.1, 24.34, 24.55, 24.79, 24.99, 25.21, 25.41, 25.62, 25.83, 26.05,
        26.26, 26.43, 26.57, 26.74, 26.88, 27.01, 27.18, 27.32, 27.42, 27.54,
        27.63, 27.77, 27.94, 28.04, 28.21, 28.36, 28.5, 28.63, 28.78, 28.96,
        29.13, 29.22, 29.37, 29.47, 29.6, 29.7, 29.82, 29.97, 30.06, 30.18,
        30.28, 30.4, 30.53, 30.6, 30.66, 30.7, 30.76, 30.78, 30.75, 30.74,
        30.72, 30.65, 30.58, 30.51, 30.45, 30.34, 30.29, 30.23, 30.15, 30.04,
        30.0, 29.98, 29.91, 29.86, 29.84, 29.81, 29.76, 29.73, 29.76, 29.77,
        29.79, 29.81, 29.85, 29.89, 29.99, 30.0, 30.05, 30.07, 30.11, 30.17,
        30.22, 30.23, 30.29, 30.28, 30.29, 30.27, 30.27, 30.24, 30.19, 30.1,
        30.1, 30.03, 29.93, 29.83, 29.84, 29.75, 29.66, 29.58, 29.48, 29.3,
        29.26, 29.2, 29.13, 29.02, 28.9, 28.82, 28.72, 28.73, 28.7, 28.65,
        28.58, 28.54, 28.5, 28.46, 28.38, 28.34, 28.23, 28.2, 28.17, 28.09,
        28.03, 28.03, 28.01, 27.94, 27.91, 27.9, 27.84, 27.79, 27.81, 27.82,
        27.81, 27.81, 27.83, 27.85, 27.85, 27.82, 27.82, 27.79, 27.79, 27.78,
        27.83, 27.84, 27.88, 27.91, 27.99, 28.04, 28.12, 28.11, 28.19, 28.19,
        28.17, 28.17, 28.31, 28.37, 28.48, 28.53, 28.59, 28.7, 28.74, 28.87,
        28.98, 29.1, 29.23, 29.34, 29.44, 29.59, 29.73, 29.87, 30.02, 30.16,
        30.35, 30.43, 30.64, 30.84, 30.98, 31.22, 31.32, 31.51, 31.64, 31.84,
        32.04, 32.21, 32.33, 32.55, 32.82, 33.15, 33.39, 33.6, 33.84, 34.1,
        34.26, 34.5, 34.7, 35.0, 35.2, 35.4, 35.6, 35.8, 36.0, 36.2,
        36.4, 36.6, 36.7, 36.8, 37.0, 37.1, 37.4, 37.6, 37.9, 38.0,
        38.1, 38.2, 38.3, 38.6, 38.7, 38.8, 38.8, 38.8, 38.8, 38.9,
        39.0, 39.0, 39.1, 39.0, 39.2, 39.3, 39.5, 39.4, 39.5, 39.6,
        39.5, 39.6, 39.6, 39.5, 39.4, 39.4, 39.2, 39.3, 38.9, 39.2,
        38.7])

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=40)
P5_t12 = np.array([0.95900848714834741, 0.95896439627828767, 0.95894623798203182, 0.95889304928078034, 0.95880479831992249, 0.95871000905799075, 0.9586086711703824, 0.95848907001894701, 0.95834466180351374, 0.95821576710158018, 0.95810893599840197, 0.95802290417215397, 0.95789247530421939, 0.95773975524562371, 0.9575803734327637, 0.95742739453713255, 0.95727559891191749, 0.95712630045954206, 0.95698606170431799, 0.95683128542609841, 0.95667769661589941, 0.95653449882360875, 0.95638593374392389, 0.95623067347406476, 0.956051576167117, 0.95587099686103172, 0.95572984577976272, 0.9556414104517138, 0.9555476526702642, 0.95543931447404673, 0.95534546234556861, 0.95525950315865948, 0.95516159757503594, 0.9550649688929258, 0.9549894873190895, 0.95491132798776301, 0.95484506799955038, 0.95480132473583668, 0.9547562462264092, 0.95471248416058241, 0.95466738630469439, 0.95461697122421441, 0.95458379674210547, 0.95456388951599613, 0.95455459882642546, 0.95455194426765622, 0.95457450693992518, 0.95460104813261859, 0.95463023953626369, 0.95466340661151139, 0.95471248416058241, 0.95477480915608615, 0.95483313893825394, 0.95490205287331287, 0.95497889118775636, 0.9550649688929258, 0.95515101036421046, 0.95523569262898822, 0.95531637255248991, 0.95539966397097076, 0.95548556353005976, 0.95558067098177668, 0.95567309328462069, 0.95576283398422246, 0.95585121537650075, 0.955939557367948, 0.95601863607391413, 0.95609636583723223, 0.95615563056627095, 0.95620171295843226, 0.95624646830853033, 0.95628989750818438, 0.95633594819967926, 0.95637541154078809, 0.95641618189862909, 0.95645694368017764, 0.95649112436038164, 0.95652924183208055, 0.95656735177341123, 0.95660939537316469, 0.95665537003657508, 0.95671315113451239, 0.95678272794952368, 0.95686671145606672, 0.95696508248285062, 0.95708174990029549, 0.9572179890142698, 0.95737375674161662, 0.9575503106233475, 0.95775150745881832, 0.95797856883588806, 0.95822358153015408, 0.95849687254396398, 0.9587931147264751, 0.95910700293868834, 0.9594410210735469, 0.95978987970250318, 0.96015347623521097, 0.96052913168702125, 0.96091546698286301, 0.96131111065855335, 0.96171597545010534, 0.96211979287889182, 0.96252255051274238, 0.96292297035705798, 0.96331852595823297, 0.96369916606714479, 0.96405996686512774, 0.96440607196266204, 0.96473382645998107, 0.96504085421620089, 0.96532852801375724, 0.9655957210440731, 0.96583387457195702, 0.96604561523941235, 0.96623106791286373, 0.96639404491610903, 0.96653463022068753, 0.96665043413329654, 0.96674767641744619, 0.96682762937878441, 0.96688909685855906, 0.96693702044773566, 0.96697018749758701, 0.96699229394118513, 0.96700702938076055, 0.96701316863007092, 0.96701562424459298, 0.96701807981041876, 0.96701930757507437, 0.96702176306785403, 0.96702667390731645, 0.96703281218265646, 0.96704140525659277, 0.96705245261735751, 0.96706840817352402, 0.96708927002246925, 0.96711012834575605, 0.96713588963899844, 0.96716287188212202, 0.96719352633901423, 0.9672253988609375, 0.96725481230147692, 0.96728299355600611, 0.9673123931624944, 0.96734178569573137, 0.96737117114957549, 0.96740177346273504, 0.96743114444379474, 0.96746295499645962, 0.96749475721095124, 0.96752899641573442, 0.96756689280437513, 0.96760722105571872, 0.96765242153780473, 0.9677012678214808, 0.96775619613293118, 0.96781475856087895, 0.96787816878515487, 0.96794398212671651, 0.96801219446498943, 0.96808401850537207, 0.9681582312782584, 0.96823361264651864, 0.96830773084890143, 0.96838422975951555, 0.96846067836417005, 0.96853707654897303, 0.96861342419983709, 0.96868851053507554, 0.9687635477080121, 0.96883490829845931, 0.96890380742148363, 0.96897024938912157, 0.96903303137249075, 0.96909095296459791, 0.96914643317538673, 0.96920068075093446, 0.96925128809871308, 0.96929826009605025, 0.96934160128287661, 0.96938131585929455, 0.96941861054163125, 0.9694522852663392, 0.96948474760878012, 0.9695147968217368, 0.96954363635955498, 0.96957126715982234, 0.96959769012232899, 0.96962530732908792, 0.96965051696455107, 0.96967452074580385, 0.96969731945891602, 0.96972011341478925, 0.96974290261019558, 0.96976568704190336, 0.96978846670668828, 0.96980884446872107, 0.9698292184096603, 0.96985078665028923, 0.9698723506017326, 0.9698939102612244, 0.96991307079765143, 0.96993222793879774, 0.96995018467329186, 0.9699657447600829, 0.96997771253005138, 0.96998728578928139, 0.96999326864432001, 0.96999685819781989, 0.96999925116699837, 0.96999925116699837, 0.96999685819781989, 0.96999087554219021, 0.96998010592459438, 0.9699705320274975, 0.9699585634604595, 0.96994539650279865, 0.96993342514734326, 0.96992264979275544, 0.96991426821846327, 0.9699082809817785, 0.96990468848062461, 0.96990468848062461, 0.96990588599427197, 0.96991187336357343, 0.96992025512357005, 0.96993342514734326, 0.96994779061459879, 0.96996335104666864, 0.96997531908234746, 0.96998369591674971, 0.96998728578928139, 0.96998130260193838, 0.96996694159686592, 0.96994300233789532, 0.96990468848062461, 0.96985198476015133, 0.96978367138409294, 0.96970091882093301, 0.96960249361425399, 0.96948835394661137, 0.96935845162626766, 0.96921634737928131, 0.96906440926676862, 0.96890501580501964, 0.96874297789749109, 0.96858192177700719, 0.96842549399252598, 0.9682773602213276, 0.96813755373445565, 0.96800610567482936, 0.96787938788185379, 0.96775253502888048, 0.96761821732922026, 0.96746662490843505, 0.96729279421037484, 0.96708927002246925, 0.96684976116086574, 0.96657283261038862, 0.96625824516702175, 0.96590697024859162, 0.96552493622381352, 0.9651168797972034, 0.96468758773397545, 0.96424817349281289, 0.96380611869849786, 0.96336395279008913, 0.96293182825754486, 0.96251239941890765, 0.96210834258898725, 0.96171980199473817, 0.96134435636624116, 0.96098211613639728, 0.96062548035720985, 0.96027192548230877, 0.95992793278112665, 0.95960132634392903, 0.95930516143568745, 0.95906293697075173, 0.95890213142127678, 0.95885671601756639, 0.95896439627828767, 0.95925208238634874, 0.95972662145182497, 0.96040186475893119, 0.96125994982235075, 0.96225077418371896, 0.96332231206846441, 0.96442485749186047, 0.96549139335466971, 0.96646312381478083, 0.96731851719041995, 0.96804019886222681, 0.96861463565925487, 0.96904630770186739, 0.96935484105361469, 0.96955204646840887, 0.96965171727866217, 0.96967452074580385, 0.96963251067400702, 0.96954123335323972, 0.96941259611942832, 0.96925369740048828, 0.96907285566800239, 0.96887601104879295, 0.96866671633620316, 0.96844733382505765, 0.96822024206916779, 0.9679890553955568, 0.96775253502888048, 0.96751065518894264, 0.9672670658179956, 0.96701930757507437, 0.9667698223513943, 0.96651983910163197, 0.96626936147415898, 0.9660196305897466, 0.96576941732884769, 0.96552245185801933, 0.96527875847607014, 0.96503836084999328, 0.96480253089284473, 0.96457129739352832, 0.96434719421585036, 0.96412775025499242, 0.96391424812930337, 0.96370923560278576, 0.96351023162262006, 0.96331978800589679, 0.96313667726475749, 0.96296345929562488, 0.96279890426314885, 0.962644310310383, 0.96249717149806346, 0.96236005119463897, 0.96223297748555048, 0.96211597621049649, 0.96200779787387392, 0.96191100939552299, 0.9618218085451109, 0.96174403459843849, 0.96167515313945595, 0.96161645239534854, 0.96156666714643979, 0.96152580592191217, 0.96149387570468037, 0.96146960441080798, 0.96145299558356068, 0.96144277389793786, 0.96143766280696197, 0.96143766280696197, 0.96144277389793786, 0.96145171790905259, 0.96146449418865043, 0.96147982435842538, 0.96149770767258569, 0.96151814326034257, 0.96154113012556719, 0.96156411363109129, 0.96158964691630799, 0.96161262332171016, 0.96163687254154984, 0.96166111800752307, 0.96168535971698255, 0.96170959766726383, 0.96173383185569461, 0.96175806227961769, 0.96178228893636342, 0.9618077866075696, 0.96183582921761623, 0.96186131810674946, 0.96188807693427414, 0.96191483114227261, 0.96194030704226641, 0.96196450526035182, 0.96198997297437483, 0.96201543648587073, 0.96203835005045291, 0.96205998750920874, 0.96208162192540614, 0.96210452563590398, 0.9621261537819612, 0.96214650689943115, 0.96216558549316566, 0.96218720502689681, 0.96221136442115129, 0.96223424874706764, 0.9622558585735449, 0.96227873623093363, 0.96230033975526985, 0.96232066968514385, 0.96234226725995009, 0.9623664020954612, 0.96239053309623135, 0.9624146602595518, 0.96243878358271151, 0.96246290306301141, 0.96248574954971722, 0.96250605463854133, 0.96252635699686939, 0.9625466566230737, 0.96256822198052172, 0.96259105252245369, 0.96261514766935818, 0.96263797108755467, 0.96266205870980859, 0.96268360751423421, 0.96270515322014893, 0.96272416156242357, 0.96274316748949018, 0.96276217100001948, 0.96278243874617386, 0.96280397021034214, 0.96282423227737879, 0.96284449158840413, 0.96286728001698629, 0.96288753346607248, 0.9629065185669694, 0.9629255012397604, 0.9629432162091458, 0.96296219418377649, 0.96298369961485164, 0.96300393716519639, 0.96302543652671935, 0.96304819714533962, 0.96306969006136456, 0.96308991582564729, 0.9631101388124288, 0.96313162269073505, 0.96315057644692736, 0.96317079109135062, 0.96318973979203082, 0.96320742303711804, 0.96322257840601422, 0.96323646944970553, 0.9632516218118633, 0.96327056005702061, 0.96328949584808765, 0.96330969131874522, 0.96332862203372294, 0.96334502666495969, 0.96336395279008913, 0.96338287645441356, 0.96340305898248013, 0.96342197755683423, 0.96344089366621466, 0.96345980730924807, 0.963478718484579, 0.96349636668725758, 0.96351401273798842, 0.96353039642868366, 0.96354551818695899, 0.96356315823712591, 0.96357953635309479, 0.96359717224396191, 0.96361228700405854, 0.96362614080723175, 0.96364125252612642, 0.96366013994191324, 0.9636815426790114, 0.96370420092333353, 0.96372685558866678, 0.96374447340804037, 0.96375831445980908, 0.96376963796099813, 0.96377844450882433, 0.96378725051420611, 0.96379731385596457, 0.96381114979335603, 0.96383001481982677, 0.96385139216742066, 0.96387276630887042, 0.96389288021728103, 0.96391424812930337, 0.96393309950193973, 0.96395194837246623, 0.96397079473950198, 0.96398963860166054, 0.964008479957568, 0.96402606296066651, 0.96404238807802867, 0.96405996686512774, 0.96407879885213121, 0.96409888353524875, 0.9641189653576655, 0.96414029915763688, 0.96416037507457308, 0.96417919364395688, 0.96419675536830585, 0.96421431489615417, 0.96423312623726432, 0.96425193505419804, 0.96427074134557, 0.96429079860438616, 0.96431085298639951, 0.96432965135531656, 0.96434719421585036, 0.96436473487018359, 0.96438227331720172, 0.96439980955575366, 0.96441609122737315, 0.9644336232035513, 0.9644511529679386, 0.96446868051941692, 0.96448620585683109, 0.96450372897905834, 0.96452250129339456, 0.96454252228944493, 0.96456128934122831, 0.96458005384446199, 0.96459881579774442, 0.96461632465228653, 0.96463258088331505, 0.96464883519609856, 0.96466508758972536, 0.96468383796566182, 0.96470258578388424, 0.96472133104299884, 0.96474132316375316, 0.96476131236949469, 0.96477880053195897, 0.96479753536950896, 0.96482001378701088, 0.96484248850669119, 0.96486246292897226, 0.96488118629306663, 0.96489990708462092, 0.96491737750114959, 0.96493609331512376, 0.96495231160303063, 0.96496728061174852, 0.9649884838817786, 0.96501467157996323, 0.96503960753884166, 0.96505955299793722, 0.96507824919364427, 0.96509195809278447, 0.9651031734294383, 0.9651231095038928, 0.96515176244606748, 0.96518788137866829, 0.96521776557217487, 0.96523768467320503, 0.96525511146041632, 0.96527626951312828, 0.96529120259668022, 0.96528995823668029, 0.96528498068099744, 0.96529991279260829, 0.965333503948545, 0.96536335566338249, 0.96538698353417773, 0.96540563415743208, 0.96542179591783461, 0.96543298367893637, 0.96544541342070511, 0.96546405585367645, 0.96548145309681455, 0.96548145309681455, 0.9654876658452598, 0.96551872522195525, 0.9655497773178815, 0.96556964683526836, 0.96558578861906841, 0.96559696254466598, 0.96560316987247308, 0.9656131009896789, 0.96561930755829217, 0.96561682496589485, 0.96561806626793945, 0.96562675505507389, 0.9656441309113214, 0.96566894958747984, 0.96569500416024234, 0.96570864973295034, 0.96571857289557483, 0.96573593662550827, 0.96575701806539693, 0.96577809611504073, 0.96579917077234301, 0.96582148141549673, 0.96584007070931444, 0.96585494023938701, 0.96586361334962523, 0.96586856915373587, 0.9658648523183061, 0.96585617929043566, 0.96584998391756294, 0.96585122301566595, 0.96585989637298075, 0.96586856915373587, 0.96588343543609323, 0.96590325450827463, 0.96592802410698286, 0.96595402710997269, 0.96598126277020413, 0.96600725511443608, 0.9660307675067823, 0.96604314073560005, 0.96605427563008228, 0.96607777948138884, 0.96610251575908535, 0.96611982833323995, 0.96613219303491227, 0.96613961128661929, 0.96614702911124439, 0.96614950162452828, 0.96615568270005836, 0.96616804396088229, 0.96618411182482211, 0.96620388490133213, 0.96621994828558377, 0.96623230336753296, 0.96624095121712639, 0.96624712789558487, 0.96625453951700857, 0.96627430174549755, 0.9662977654314403, 0.96632122481471894, 0.96634591425081273, 0.96637059891265586, 0.96639157711888557, 0.96640514941191469, 0.96641501926182238, 0.96642488834629103, 0.96643845708723342, 0.9664557242993872, 0.96647175603779178, 0.96648038767378874, 0.96648531977360497, 0.96649271756377608, 0.96649764918415415, 0.9664988820592767, 0.9664988820592767, 0.96649641629704186, 0.96649764918415415, 0.96650874462860548, 0.96652107176087521, 0.96653216515417328, 0.9665469548330351, 0.96656913610937845, 0.96659254545581119, 0.96661348698172267, 0.96663073033385261, 0.9666418141002856, 0.96665043413329654, 0.96665905357619708, 0.9666701348497363, 0.9666775218232071, 0.96668860146982982, 0.96670214193390291, 0.96671937314100931, 0.96674029356976698, 0.96675874987371935, 0.96675998019734477, 0.96675998019734477, 0.96677228276905947, 0.96678704425969775, 0.96679934417187852, 0.96681164287446675, 0.96682517004972746, 0.96683992529767182, 0.9668546788017407, 0.96686574278491666, 0.96686574278491666, 0.96686328420681544, 0.96686574278491666, 0.96687188901807586, 0.96688418057520764, 0.96690138671792036, 0.9669161329476651, 0.96693210605752333, 0.96694807711518482, 0.9669665027073121, 0.96698492556445537, 0.9670033456851358, 0.96702053532755472, 0.96703772258370302, 0.96705368004096171, 0.96706840817352402, 0.96708436166923395, 0.96709540518951653, 0.96710154005152626, 0.96710890148319928, 0.96711748926474872, 0.96712975648624566, 0.96714815502821583, 0.96716900338502065, 0.96718862213968826, 0.96720823776213094, 0.96722662456186559, 0.96724010646348513, 0.96724623411046973, 0.96725113600744961, 0.96726216455852565, 0.96727931810816237, 0.96730749371911084, 0.96733566283490136, 0.96735035718466866, 0.96736137678527068, 0.96737361961765089, 0.9673858612198144, 0.96739442960911948, 0.96740544522333083, 0.96742257864059455, 0.96744215673205314, 0.96746540161677852, 0.96748252657725986, 0.96748252657725986, 0.96747518760461038, 0.96747029470939561, 0.96747029470939561, 0.96747641079756863, 0.9674849728027507, 0.96748986510560264, 0.96750087206484925, 0.96752288298236333, 0.96754611238530153, 0.96756567052574438, 0.96758033705268109, 0.96759744574804341, 0.96761821732922026, 0.96764264989864834, 0.96766463497039512, 0.96767440482310352, 0.96768051057767623, 0.96768905811268213, 0.96769882597907764, 0.96771225549737216, 0.96772812480782233, 0.96774277153738986, 0.96775985712500645, 0.96777694027378047, 0.96779036103609384, 0.9678013405389454, 0.96781109924988407, 0.96781841775970023, 0.96782451617510601, 0.9678391511003599, 0.96786353865096419, 0.96788792120907963, 0.96790132948669194, 0.96791108001172299, 0.96792814150559148, 0.96795860236191111, 0.96799392715452459, 0.96802558870008237, 0.96804872062252034, 0.968065762298151, 0.96808158450769588, 0.96809618773993789, 0.96811200586600521, 0.96813268790148088, 0.96815458256427123, 0.96818012118216734, 0.96819835965076029, 0.96820686996558403, 0.9682129483836478, 0.96821659528316151, 0.96822267319676747, 0.96822875079501858, 0.96823482807785843, 0.96823725890265877, 0.9682433357438176, 0.96825913405391328, 0.96828100511372273, 0.96829679833312376, 0.96830651617550567, 0.96831137479321738, 0.96831744778078754, 0.96834295087453526, 0.96837451839819899, 0.9684012226897617, 0.96841457253422714, 0.96841821313451837, 0.96841699961377192, 0.96841578608034096, 0.96841821313451837, 0.96842185362062116, 0.96843277439368036, 0.96845946528776206, 0.96848978838595334, 0.9685116160966164, 0.96851646613928943, 0.9685043406509426, 0.96847887298566659, 0.96844976021920059, 0.96843277439368036, 0.96843762774060127, 0.96845946528776206, 0.9684970647473542, 0.96854434993281546, 0.96859403911384256, 0.9686315947510612, 0.96864855134037531, 0.96864855134037531, 0.96864491799625208, 0.96864249570297589, 0.96865097350591811, 0.96866429450288027, 0.96868003550553694, 0.9687054587139643, 0.96872603527366541, 0.96874418798885242, 0.96875870808577302, 0.9687671772901062, 0.96877322633720231, 0.96878290414581714, 0.96880104782445031, 0.9688191886158628, 0.96882644412366581, 0.96883128087203396, 0.96883974468718714, 0.96885667042886514, 0.96887721972824514, 0.96889776531078009, 0.96891468240983314, 0.96893038888507721, 0.96894730111612115, 0.96897145706402033, 0.96900164474390316, 0.9690282032287022, 0.96904268703984786, 0.96905234188005684, 0.96906802923061719, 0.96908492085589015, 0.96908733373820044, 0.96909095296459791, 0.96910422246471273, 0.96911869649618143, 0.96913316866235533, 0.96914763896242706, 0.96915607910871926, 0.96916572421210678, 0.96918139573440387, 0.9692030911443088, 0.96923321667756202, 0.96926453861467055, 0.96928742216140851, 0.96930789293019959, 0.96933678642958021, 0.9693596551243957, 0.96936206208151343, 0.96936206208151343, 0.96937048602039633, 0.96938733197956128, 0.96940898730929603, 0.96943063840579069, 0.96943905713283685, 0.96944266496256504, 0.96944507011698544, 0.96945348774544549, 0.96946791647413155, 0.96948594973449176, 0.96950518196449409, 0.96952200741420014, 0.96953883029445553, 0.96955324786005048, 0.96956045593433171, 0.96956526105470531, 0.96957126715982234, 0.96958327838535008, 0.96960489528136817, 0.96963010961164253, 0.96965411786740485, 0.96967212060465724, 0.96967692083426649, 0.9696757207966199, 0.96966852029417983, 0.96966972041084176, 0.96968772058040353, 0.9697141154667599, 0.96974050397179434, 0.96976568704190336, 0.96978846670668828, 0.96980405004486414, 0.96980764588258461, 0.96980764588258461, 0.96981483720104245, 0.9698280200483621, 0.96984958852720404, 0.96987474633144943, 0.96990229341356549, 0.96992743897192502, 0.96994419942698196, 0.96995616958766417, 0.96996933523057771, 0.96997531908234746, 0.96996813842035867, 0.96995976037693321, 0.96996694159686592, 0.9699789092339709, 0.96998848238687885, 0.97000284052104879, 0.97002796264750013, 0.97005666646244049, 0.97008536260526013, 0.97011046543154411, 0.97012839241992566, 0.97013675732013394, 0.97015348515770872, 0.97016304274661724, 0.97019171038136964, 0.97022156430963513, 0.970233503538941, 0.97024424770047601, 0.97024066643382412, 0.97023589122413412, 0.97022872800787197, 0.9702179822798066, 0.9702072354676613, 0.9702072354676613, 0.97022156430963513, 0.97023947265149479, 0.97026334575302287, 0.97028482696104457, 0.97030033846478414, 0.97031465476343637, 0.97032419788879898, 0.97034447417679559, 0.97035878451323709, 0.9703719006214736, 0.97037309291429008, 0.97036713131577024, 0.97035639959153552, 0.97036116938116213, 0.97037666971205883, 0.97039574392249806, 0.9704160064969215, 0.9704160064969215, 0.97040527973615931, 0.97040170390696112, 0.97041958184152566, 0.97046009394140065, 0.97049225421428253, 0.97051249822892283, 0.97052916684057622, 0.97053273834149978, 0.97052083286562918, 0.97050297211971948, 0.97049582697089121, 0.97050535372802471, 0.97051845160837613, 0.97055773544274238, 0.97061960735604536, 0.97068619768474118, 0.9707361125044125, 0.97076937573251243, 0.97077650217965961, 0.97080262829356356, 0.97081331434962836, 0.97084180510315121, 0.97086910137208227, 0.97088927223570598, 0.97086435471328192, 0.97084299204748425, 0.97078719093175414, 0.9707586851434199, 0.97071947689353333, 0.97070283861987372, 0.9707159117732983, 0.97077293901731976, 0.97086910137208227, 0.97093790337252939, 0.9709865115222297, 0.97102917286922774, 0.97098888206287803, 0.97096043196046899, 0.97092604423793916, 0.97089164501908809, 0.97089045863422752, 0.97089520409175167, 0.97085723431574356, 0.97087503438853173, 0.97091062531941397, 0.97086910137208227, 0.97084061814517442, 0.97079550364329059, 0.97078362813689356, 0.97067074300590395, 0.9707159117732983, 0.97077293901731976, 0.97088808582353148, 0.97088215355785146, 0.97103746606818409, 0.9711523168563776, 0.97123630084148938, 0.97136982198481991, 0.97127885770775158, 0.97139461617896961, 0.97142766559367666, 0.97146188387530974, 0.97144418622191819, 0.97154207401227399, 0.97136982198481991, 0.9713591940312275, 0.97148665533886447, 0.97153264321740396, 0.97158096661839932, 0.97162219976224351, 0.97165635141497875, 0.97176344060093067, 0.97176461676105685, 0.97172226616917623, 0.97156682560814456, 0.97156211149209493, 0.97155268259126637, 0.97156093292825429, 0.97164104350581859, 0.97168460596580764, 0.97166930241687977, 0.9716740114528194, 0.97166341580745452, 0.97168107458731834, 0.97170932209045868, 0.97173991445546559, 0.97177520157130326, 0.97183751129202856, 0.97186688897679674, 0.9718939086852395, 0.97195144758039531, 0.97202185726752033, 0.97209573270271388, 0.97216838064927613, 0.97231117368704434, 0.97240001956404143, 0.97248528066026585, 0.97255996731778238, 0.9726357607579954, 0.97273361912576051, 0.97279414709766765, 0.97289765228129299, 0.97297665748319828, 0.97312403114920909, 0.97322253553967231, 0.97331052044123378, 0.97341691494955007, 0.97351163972606769, 0.97357281142613195, 0.97364547085046038, 0.97372383080183667, 0.97380442361551089, 0.97389873940562699, 0.97400788196004839, 0.97409968647569634, 0.97419712326232255, 0.97426583654753607, 0.97431161516764875, 0.97435508241524815, 0.97438824005888947, 0.97439281252548582, 0.97442367032013566, 0.97448306892704539, 0.97455840017945372, 0.97461656517854633, 0.974671272390774, 0.97473049872726358, 0.97476351078905166, 0.97482153515317649, 0.97488065605737295, 0.97485905901546288, 0.9748636062232281, 0.9748920206873789, 0.9748874750203288, 0.97491588139216367, 0.97496131152938093, 0.97492610532623913, 0.97494314243855529, 0.97497039459193802, 0.97495449858364081, 0.97500331240156501, 0.97505663432370471, 0.97502373760340133, 0.97507364475674818, 0.97502146838411685, 0.97503962040468495, 0.9750294103807533, 0.9749919629015058, 0.97500217752115759, 0.97496698855935737, 0.9750305448897818, 0.97506230485547873, 0.97512578832845753, 0.97512352189942209, 0.9751518477974993, 0.97517789904653052, 0.97513032100021568, 0.97513258724292395, 0.9750418891285646, 0.97505096340461339, 0.97499990771394007, 0.97503621720272049, 0.97504869492853075, 0.97511105542977017, 0.97507704642487802, 0.97509291903105366, 0.97507704642487802, 0.97507024294910505, 0.97507364475674818, 0.97500785176851668, 0.97501466035483408, 0.97495790512602076, 0.9749601760770451, 0.97493859954820006, 0.97488065605737295, 0.9748874750203288, 0.97484200479217731, 0.97487724636786355, 0.97482835892007258, 0.9747874080149308, 0.97477147728361291, 0.97472708294990562, 0.97477375328670235, 0.97474188365469006, 0.97469405665454179, 0.97470202969920283, 0.97461884534924681, 0.97455041364925044, 0.97454470852718778, 0.97451503574757392, 0.97447393335716359, 0.97450476200038061, 0.97446137035829017, 0.97441795674913767, 0.97444652080469041, 0.97442824090342661, 0.97441567121438732, 0.97443281124355985, 0.97441224279831873, 0.97438824005888947, 0.97432420004198317, 0.97433220764404482, 0.97429216221260428, 0.97425553302243484, 0.97419483188326039, 0.97418681158125997, 0.97415128421817165, 0.97414784531749699, 0.97411344885464757, 0.97412262256986726, 0.97414440628120491, 0.97412606246466682, 0.97412147590815135, 0.97409853951298042, 0.97412262256986726, 0.97412835565258127, 0.97408362762875444, 0.9740583863433927, 0.97404231992026491, 0.97404461530382769, 0.9740411722059511, 0.97403543340913046, 0.97400099274720819, 0.9739941029943594, 0.97397572768098162, 0.973965389880871, 0.9739550508670729, 0.97398261887327264, 0.97399295464973268, 0.97399525132399978, 0.97398606426703283, 0.97397687625051177, 0.9739550508670729, 0.97396079491344245, 0.97394815751712815, 0.97397572768098162, 0.97396998460855333, 0.97398376735284853, 0.97398491581743663, 0.97398721270164146, 0.97399639963863471, 0.97400328921149248, 0.97399525132399978, 0.97398491581743663, 0.97401936278113532, 0.97401247446854744, 0.97402625055341774, 0.97402510262890063, 0.9739941029943594, 0.97397802480503959, 0.9739401145941331, 0.97391253328961203, 0.97391828010554138, 0.9739550508670729, 0.97396424116148728, 0.97396768727468541, 0.97397228188248552, 0.97398721270164146, 0.97396653858527205, 0.9739550508670729, 0.97391942942384901, 0.97389644021558996, 0.97388034421092939, 0.97388034421092939, 0.97389529059814428, 0.97392977261517222, 0.97392632501941667, 0.97392402654741705, 0.97391828010554138, 0.97391023445851532, 0.97390793556759236, 0.97391713077227693, 0.97389414096574933, 0.97389873940562699, 0.97389299131839879, 0.97391253328961203, 0.97391598142405345, 0.97393092178382168, 0.97392632501941667, 0.97395275314366714, 0.97397228188248552, 0.97399984449256261, 0.97401247446854744, 0.97403543340913046, 0.97404231992026491, 0.97404576297307832, 0.97403772897290497, 0.97404002447662041, 0.97401821476655936, 0.97403543340913046, 0.9740411722059511, 0.97405953383236743, 0.97407330252778168, 0.97408018606375091, 0.97409165742075021, 0.974104274176116, 0.97409165742075021, 0.97410656793604455, 0.97408821617156505, 0.97409509853455811, 0.97411459562172953, 0.97416618455378168, 0.97417879054008294, 0.9742062881749266, 0.97421659754686896, 0.97425095328487299, 0.97424522827284887, 0.9742635469811296, 0.9742692707837316, 0.97430360565718832, 0.97429559540491484, 0.97430589416445468, 0.97429673977207321, 0.97430246138084853, 0.97427270488381468, 0.97424980831269514, 0.97421545212149097, 0.97422232444728962, 0.97420514261367908, 0.97422346978206276, 0.97422690569579051, 0.97425095328487299, 0.97423606746777636, 0.97428186181848697, 0.97429902846099559, 0.97434135828008994, 0.97434478951852999, 0.97438709690429581, 0.97441338561886615, 0.97444537842488099, 0.97445451703756458, 0.97448649451458791, 0.97450133714377452, 0.97454128527092843, 0.97454242637159805, 0.97456866747682347, 0.97456068190790601, 0.97457551165494094, 0.97457893353792091, 0.97458463637085091, 0.97453900302383301, 0.97460174257885601, 0.97463480483187448, 0.9746860828591406, 0.97472936015014444, 0.97478399454027409, 0.97478854580908969, 0.97479992290541617, 0.97481129846460335, 0.97485110080899706, 0.97485792217501988, 0.97489088429373527, 0.97490451999993144, 0.97491020088884328, 0.97490565620855907, 0.97491588139216367, 0.9749136092371099, 0.97494200673912512, 0.97494768508189256, 0.97498061185520468, 0.974985152459243, 0.9749942329252349, 0.97498288218813745, 0.97499536791390529, 0.97499650288711082, 0.97500217752115759, 0.97499082786644864, 0.97499990771394007, 0.97503281386140406, 0.97506910898222821, 0.97509518629808734, 0.97513032100021568, 0.97513825257792597, 0.97516204274381224, 0.97517336898528828, 0.97520507418757307, 0.97520167778506084, 0.97521865839667443, 0.97519488455986358, 0.97519714903050914, 0.97521979031290595, 0.97524355695588261, 0.97524468852942203, 0.9752616602621289, 0.97527975957695923, 0.97530463961352787, 0.97529559320147752, 0.97531142376687463, 0.97531255440444975, 0.97534533609893503, 0.97536002707461678, 0.97538488270419577, 0.9753950487333376, 0.9753950487333376, 0.97538488270419577, 0.97537810464713015, 0.9753374244792713, 0.97533177285351325, 0.97532159894282289, 0.97532499038698395, 0.97532725127165132, 0.97535211687759127, 0.97534533609893503, 0.97535437701207106, 0.97534759642102287, 0.97532159894282289, 0.97533064248149359, 0.97534872655861637, 0.97534307571432399, 0.97537810464713015, 0.97539278972532872, 0.97538714193135567, 0.97534985668057206, 0.97534307571432399, 0.9753374244792713, 0.97532046843018838, 0.97528541479393405, 0.97526279158626383, 0.97524355695588261, 0.97523110861867257, 0.97523337209292704, 0.97524582008736793, 0.97521413057605988, 0.97514958208292812, 0.97510085419420689, 0.97510085419420689, 0.97511672223971579, 0.97513032100021568, 0.97514958208292812, 0.97518242885895756, 0.97519828124248842, 0.97516883867525705, 0.97511785555514352, 0.97506117078011312, 0.97500217752115759, 0.97494427812255069, 0.97491928950905105, 0.97497720623988071, 0.97507024294910505, 0.97519148773721143, 0.97529333144237806, 0.975357767096517, 0.97543344228463347, 0.97543457123253141, 0.97540521349436238, 0.97533064248149359, 0.97520733837808937, 0.97509745350307087, 0.97501579506507341, 0.97497152990522806, 0.97500671694998264, 0.97510198772689316, 0.97524129376207236, 0.97538149374608463, 0.97551919761333228, 0.9755857082527768, 0.97560260900156659, 0.97553836731141386, 0.97544811738455073, 0.97536454684317164, 0.97526844797305179, 0.97521865839667443, 0.97522205409864338, 0.97525260910779266, 0.97527636625956027, 0.97531481563274758, 0.97534194549857189, 0.97534194549857189, 0.97532838169055802, 0.97531255440444975, 0.97528993868667002, 0.97527184161799074, 0.97523224036358669, 0.97519035543187216, 0.97513145412933022, 0.97510425474570994, 0.97508725059204304, 0.97512012213942967, 0.97516204274381224, 0.97519488455986358, 0.97524355695588261, 0.97526052892239701, 0.97524695162973685, 0.9752129985819874, 0.97514278456634429, 0.97509178537427221, 0.97501692975982956, 0.97496471779372063, 0.97493973529393774, 0.97493746378700918, 0.97496471779372063, 0.97501919910292689, 0.97504529209824242, 0.97508838431086531, 0.9750963199083359, 0.97511445556230303, 0.97513938559833224, 0.97516883867525705, 0.97516317543792386, 0.97517110386136863, 0.97518356127318107, 0.97525374055664782, 0.97525939756708091, 0.97525939756708091, 0.97526731672687739, 0.97523224036358669, 0.97519941343890448, 0.97519488455986358, 0.97518016398384844, 0.97520394206896432, 0.97527636625956027, 0.9753555070558555, 0.9754447310582105, 0.97550904711070618, 0.9755530234260289, 0.97556204125204493, 0.97553498475367184, 0.97555753246491739, 0.97555978688995659, 0.97557556610256846, 0.97553047445655294, 0.97560598872595461, 0.97556204125204493, 0.97549889533549217, 0.97537471540734333, 0.97524695162973685, 0.97514618339454739, 0.97509065170197762, 0.97501919910292689, 0.97503848601951126, 0.97498288218813745, 0.97519601680296764, 0.9751677060588827, 0.9751291878555669, 0.97501919910292689, 0.97498742266850591, 0.97481926044114831, 0.97475212877746265, 0.97456866747682347, 0.97492042551714964, 0.97487269989946301, 0.97480561087718753, 0.97480902347576681, 0.97471455725209699, 0.97475212877746265, 0.97461884534924681, 0.97523450380668408, 0.97530237810417886, 0.97525260910779266, 0.97521413057605988, 0.97533629418537149, 0.97520507418757307, 0.97594997298813191, 0.97600940088407062, 0.97599819150163269, 0.97598137443736643, 0.97603517640732351, 0.97655780800579217, 0.97660120096413716, 0.97651661750585628, 0.97641744681826648, 0.97636837130365828, 0.97672012638624173, 0.97660676237677746, 0.97637171835434655, 0.97612812212874245, 0.97577591798513796, 0.97602285003670608, 0.9757185649597695, 0.97551130288794696, 0.97541198929701023, 0.97557782002394822, 0.97553498475367184, 0.97546166127845002, 0.9753950487333376, 0.97555076881219238, 0.97551919761333228, 0.97551243075299932, 0.97545601826381156, 0.97554174972763463, 0.9755214531077232, 0.97548874228808913, 0.97543005534688676, 0.97545376094815472, 0.97537358562945542, 0.97535211687759127, 0.97536567674620489, 0.97545940411965881, 0.97552934684296566, 0.97562964282482223, 0.97577929041008582, 0.97590845906574197, 0.97604638052204284, 0.97620642433730731, 0.97631033269766265, 0.97643416995883747, 0.97653777215796, 0.9766467925466209, 0.97671901579724396, 0.97680448337497205, 0.97687655585421407, 0.97699726031711653, 0.97713433772348512, 0.97725021268412238, 0.97739562452740025, 0.9775198752693316, 0.97760222469180336, 0.97772392862774826, 0.97785417358840354, 0.97797108022016865, 0.9781553311134501, 0.9783694932533199, 0.97853536233095995, 0.9787278251177276, 0.97888312250994458, 0.97895955953045066, 0.97902516027816244, 0.97913363427586808, 0.97912934168820809, 0.97925264104822585, 0.97927513136702526, 0.97944088966854936, 0.97957958338175222, 0.97962645754899436, 0.97972329188694318, 0.97987515965753302, 0.97990909361432876, 0.98006791222574829, 0.9801482245787394, 0.98028430346190698, 0.98046631910685178, 0.98044215214316066, 0.9805618407712916, 0.98049887657881596, 0.98054400765266658, 0.98058805626091339, 0.98053351509399822, 0.9805649872389437, 0.98052511972018042, 0.98061216432088194, 0.98048102467058762, 0.98059434626188546, 0.98075974330095883, 0.9807220985796834, 0.98087253297786914, 0.98091946457237844, 0.98105795236249072, 0.98100592810653842, 0.98109226269946748, 0.98101841819846214, 0.98107043121227566, 0.98115978386059921, 0.98106835159151062, 0.98118261918211747, 0.98116497450617779, 0.98128837286816628, 0.98126972471620399, 0.98136186974017603, 0.98129562327436992, 0.98132358045109536, 0.98126972471620399, 0.98131943951689993, 0.98128008555610313, 0.98135980071143958, 0.9813670419806011, 0.98150238570101411, 0.98149928987414481, 0.98163019651590588, 0.98160136164647915, 0.98170735892720307, 0.98180904825958848, 0.98178441357647772, 0.98173100048879425, 0.98183674904270191, 0.98179570584676412, 0.98187058650583547, 0.98183264610773846, 0.98188391065738967, 0.98180494324773915, 0.98186033494322356, 0.98181315296386817, 0.98189518239576756, 0.98185008145502595, 0.98193205540723694, 0.98189723155214947, 0.98195764694918131, 0.98190440299215431, 0.98196788018577708, 0.98190747617719554, 0.98192386356544281, 0.98185520843977847, 0.9818069957921064, 0.98189620698360358, 0.98185418308132599, 0.98188698499915184, 0.98180596952953314, 0.98184803052637193, 0.98177927995802272, 0.98172175065039513, 0.98178954671476659, 0.98183777472834421, 0.98194331717256644, 0.98197708844641185, 0.98210175685915246, 0.98211196278577628, 0.98209359072014124, 0.98214358881459618, 0.98205989227163371, 0.98211298327163965, 0.98209359072014124, 0.98208950718483978, 0.98218538809206868, 0.98215684578423579, 0.98218946431907406, 0.98210481884100431, 0.9820036812908105, 0.98198731801062977, 0.98189108385166135, 0.98188186099986141, 0.98181110065018096, 0.98178852012552043, 0.98186853634738536, 0.98190440299215431, 0.98190645180146185, 0.98196583369304447, 0.98191054918865195, 0.98195764694918131, 0.9819279596407342, 0.98191362202651433, 0.98189928063141252, 0.98188493545724698, 0.98187161155616254, 0.98185828439960632, 0.98184597952073049, 0.98183367187033965, 0.98182238742375705, 0.98181110065018096, 0.98179981155047347, 0.98178954671476659, 0.98177927995802272, 0.98177003823501063, 0.98176079495697921, 0.98175155012441195, 0.98174333119079193, 0.98173511102960997, 0.98172688964120391, 0.98171969491990696, 0.98171352726845873, 0.98170633080326442, 0.98170016165739793, 0.98169502017579824, 0.98168987821545017, 0.98168473577643911, 0.98167959285884876, 0.98167547818024892, 0.98167136319545545, 0.98166827675593571, 0.98166519014423426, 0.98166210336034809, 0.98166004540879115, 0.98165695833797062, 0.98165592927612721, 0.98165387109504387, 0.98165284197581715, 0.98165181283745973, 0.98165181283745973, 0.98165181283745973, 0.98165181283745973, 0.98165181283745973, 0.98165284197581715, 0.98165387109504387, 0.98165490019514612, 0.98165695833797062, 0.98165901640430453, 0.98166107439412875, 0.98166416123540334, 0.98166724790450388, 0.98167033440141227, 0.98167342072611741, 0.9816765068786063, 0.9816806214806395, 0.98168473577643911, 0.98168987821545017, 0.98169399182202988, 0.98169913339939452, 0.98170427449793363, 0.98171044318405354, 0.98171558322893604, 0.98172175065039513, 0.98172791738185072, 0.98173408342317237, 0.98174127626556917, 0.98174846816817096, 0.98175463190795487, 0.98176284915312551, 0.98177003823501063, 0.9817782531767103, 0.98178544024255143, 0.98179365287960796, 0.98180186428703942, 0.98181110065018096, 0.98181930944352547, 0.98182854286497179, 0.98183777472834421, 0.98184700503317446, 0.98185623377897724, 0.98186648611190308, 0.98187571156483888, 0.98188596023783536, 0.98189620698360358, 0.98190645180146185, 0.98191669469077181, 0.98193717468106378, 0.98194741178072875, 0.98195764694918131, 0.98196788018577708, 0.98197811148984249, 0.98199856829770227, 0.98200879380020456, 0.98201901736750596, 0.98202923899897376, 0.98203945869391684, 0.98205989227163371, 0.982070106153073, 0.98208031809533591, 0.98209052809776731, 0.98210073615970939, 0.98212114645943882, 0.98213134869589458, 0.98214154898917683, 0.98215174733864175, 0.98216194374361132, 0.98218233071741279, 0.98219252128489898, 0.98220270990522784, 0.98221289657773869, 0.98222308130173996, 0.98224344490158766, 0.98225362377610004, 0.98226380069942931, 0.98227397567093133, 0.982294319755739, 0.98230448886771449, 0.98232482122742448, 0.98233498447384437, 0.98234514576372067, 0.98235530509640601, 0.98237561788750827, 0.98238577134458971, 0.9823959228417718, 0.98240607237840782, 0.98241621995381889, 0.98242636556733876, 0.98243650921827741, 0.98244665090597694, 0.98245679062976832, 0.98246692838897065, 0.98248719801090723, 0.98249732987230065, 0.98250745976640652, 0.98251758769256459, 0.98252771365009173, 0.98254795965656117, 0.98255807970414311, 0.9825681977803925, 0.98257831388465222, 0.98258842801621438, 0.98260865035860301, 0.98261875856808156, 0.98262886480215506, 0.98263896906018089, 0.98264907134145696, 0.98266926997108639, 0.98267936631808139, 0.98268946068562812, 0.98269955307305112, 0.98271973190479334, 0.98272981834775808, 0.98274998528447599, 0.98276006577687713, 0.98277014428439269, 0.9827802208063442, 0.9828003678908549, 0.98281043845204696, 0.98282050702496326, 0.98283057360890269, 0.98284063820320777, 0.98286076142015033, 0.98287082004142556, 0.98288087667033031, 0.98289093130618543, 0.98290098394830128, 0.98292108324859517, 0.98293112990539311, 0.98294117456573749, 0.98295121722891732, 0.9829612578942627, 0.98298133322872194, 0.98299136789644981, 0.98300140056361252, 0.98301143122951429, 0.98302145989345924, 0.98304151121279149, 0.98305153386680044, 0.98306155451611632, 0.98307157316006144, 0.9830815897979549, 0.98310161705277932, 0.9831116276683507, 0.98312163627512328, 0.98313164287238852, 0.98314164745947485, 0.98316165060033867, 0.98317164915273714, 0.98318164569218736, 0.98319164021801475, 0.98320163272952787, 0.98322161170684175, 0.98323159817126005, 0.98324158261860539, 0.98325156504817834, 0.98326154545929534, 0.98327152385125594, 0.98328150022338145, 0.98329147457496169, 0.98330144690534338, 0.98331141721379878, 0.98333135176218212, 0.98334131600074259, 0.98335127821461132, 0.9833612384031023, 0.9833711965655213, 0.98338115270118276, 0.98339110680937414, 0.98340105888941887, 0.98341100894061995, 0.98342095696228171, 0.9834408469141982, 0.98345078884306447, 0.9834607287396091, 0.98347066660313653, 0.98348060243295998, 0.9835004679886884, 0.98351039771319104, 0.9835203254012127, 0.9835302510520294, 0.98354017466495469, 0.98355009623930123, 0.9835600157743587, 0.98356993326942987, 0.9835798487238262, 0.98358976213683913, 0.98359967350776578, 0.9836095828359297, 0.98361949012060967, 0.98362939536111682, 0.98363929855675269, 0.98365909881059865, 0.98366899586741441, 0.9836788908765608, 0.98368878383732283, 0.98369867474901329, 0.98370856361091497, 0.98371845042236239, 0.98372833518261449, 0.9837382178909907, 0.98374809854678569, 0.9837579771492917, 0.98376785369781827, 0.98377772819164044, 0.98378760063007387, 0.98379747101242665, 0.98381720560600172, 0.98382706981584089, 0.98383693196676503, 0.98384679205807424, 0.98385665008906686, 0.98386650605902726, 0.98387635996725975, 0.98388621181305713, 0.98389606159571441, 0.98390590931453858, 0.9839157549688039, 0.98392559855781536, 0.98393544008086031, 0.98394527953722399, 0.98395511692622295, 0.98396495224712865, 0.98397478549925843, 0.98398461668187642, 0.98399444579427919, 0.98400427283578584, 0.98400427283578584, 0.98401409780565663, 0.98402392070319822, 0.9840337415277044, 0.98404356027844908, 0.98404356027844908, 0.98405337695474016, 0.98406319155587196, 0.98407300408111786, 0.98408281452978585, 0.98408281452978585, 0.98409262290114818, 0.98410242919450064, 0.98411223340913156, 0.98411223340913156, 0.98412203554432898, 0.98412203554432898, 0.98413183559940209, 0.98414163357362738, 0.98414163357362738, 0.98415142946626843, 0.98415142946626843, 0.98416122327664757, 0.98417101500403481, 0.98418080464771329, 0.98419059220698257, 0.98420037768114588, 0.98421016106945791, 0.98421994237121868, 0.98422972158571753, 0.98422972158571753, 0.98423949871222638, 0.98424927375004911, 0.98425904669848097, 0.9842688175567833, 0.98427858632424148, 0.98428835300016049, 0.98429811758380514, 0.98430788007446945, 0.98431764047144055, 0.98432739877401265, 0.98433715498144037, 0.98434690909302891, 0.98435666110805731, 0.9843664110258088, 0.98437615884556695, 0.98438590456660136, 0.98439564818822145, 0.98440538970968339, 0.98441512913028273, 0.98441512913028273, 0.98442486644931104, 0.9844346016660267, 0.98444433477971727, 0.98445406578967287, 0.98445406578967287, 0.98446379469517009, 0.98447352149549072, 0.98448324618991556, 0.98449296877772396, 0.98449296877772396, 0.98450268925819262, 0.98451240763060166, 0.98452212389422478, 0.98453183804836319, 0.98453183804836319, 0.98454155009227828, 0.98455126002524851, 0.98456096784655178, 0.98456096784655178, 0.98457067355547001, 0.98457067355547001, 0.98458037715128477, 0.98459007863326831, 0.98459007863326831, 0.98459977800070486, 0.98459977800070486, 0.98460947525286246, 0.98461917038901903, 0.98461917038901903, 0.98462886340845623, 0.98462886340845623, 0.98463855431045388, 0.98464824309428189, 0.98464824309428189, 0.98465792975921584, 0.98465792975921584, 0.98466761430453731, 0.98467729672950388, 0.98467729672950388, 0.98468697703341401, 0.98468697703341401, 0.98469665521553629, 0.98470633127515272, 0.98470633127515272, 0.98471600521151148, 0.98471600521151148, 0.98472567702390779, 0.98472567702390779, 0.98473534671160778, 0.98473534671160778, 0.98474501427388983, 0.98474501427388983, 0.98475467971003872, 0.98475467971003872, 0.98476434301929661, 0.98476434301929661, 0.9847740042009604, 0.9847740042009604, 0.98478366325430922, 0.98478366325430922, 0.98479332017860077, 0.98479332017860077, 0.9848029749731072, 0.9848029749731072, 0.9848126276371002, 0.9848126276371002, 0.98482227816986967, 0.98482227816986967, 0.98483192657066376, 0.98483192657066376, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.98486085897396802, 0.98486085897396802, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488013656966733, 0.98488013656966733, 0.98487049883962519, 0.98487049883962519, 0.98486085897396802, 0.9848512169734559, 0.9848512169734559, 0.98484157283877427, 0.98483192657066376, 0.98482227816986967, 0.9848126276371002, 0.9848029749731072, 0.98479332017860077, 0.98478366325430922, 0.9847740042009604, 0.98475467971003872, 0.98474501427388983, 0.98472567702390779, 0.98471600521151148, 0.98469665521553629, 0.98467729672950388, 0.98465792975921584, 0.98463855431045388, 0.98461917038901903])

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=90)
P5_tav90n = np.array([0.90888372346201263, 0.90883369467470709, 0.90881309625401641, 0.90875277790074938, 0.90865275606710183, 0.90854540514121274, 0.90843073047741585, 0.90829551168724665, 0.90813242260430438, 0.90798701567381468, 0.90786661384714373, 0.90776972885279639, 0.90762297374667456, 0.9074513318066586, 0.90727242518589846, 0.90710091813772542, 0.90693094183038703, 0.90676395887721217, 0.90660728566099813, 0.90643456897787589, 0.9062633811646299, 0.90610395670740296, 0.90593874090499327, 0.90576627868345461, 0.90556758952580174, 0.90536752666329434, 0.90521133388458541, 0.9051135579591415, 0.90500996733335226, 0.90489035642609594, 0.90478681591980537, 0.90469204565007644, 0.90458417696098903, 0.90447779055171496, 0.90439473866518394, 0.90430878831066874, 0.90423596145862595, 0.90418790197638077, 0.90413839133086649, 0.90409034190872251, 0.90404084161932663, 0.90398552397741971, 0.90394913436440172, 0.90392730195662696, 0.90391711384860418, 0.90391420300137582, 0.90393894578053602, 0.90396805660947455, 0.90400008061631532, 0.9040364741987883, 0.90409034190872251, 0.90415877743026929, 0.90422285383524792, 0.90429859186518524, 0.90438308344837814, 0.90447779055171496, 0.90457251698543839, 0.9046658050074563, 0.90475473765418235, 0.90484660408443585, 0.90494140606749474, 0.90504644024783332, 0.90514857978165497, 0.90524782276764482, 0.90534562727532386, 0.9054434526419286, 0.90553107518195475, 0.90561725371320678, 0.90568299402700969, 0.90573413192690477, 0.90578381423304499, 0.90583204047281429, 0.90588319509376602, 0.90592704648656963, 0.90597236403270354, 0.90601768609557509, 0.90605570163379201, 0.90609810733439611, 0.90614051699690157, 0.90618731846746337, 0.90623851310872139, 0.9063028802958375, 0.90638042565488153, 0.90647408306565203, 0.90658386257382806, 0.90671416895307455, 0.90686648491182975, 0.90704083293557591, 0.90723870492613523, 0.90746453268161198, 0.90771982666868167, 0.90799582685155156, 0.90830432903560965, 0.90863951959807276, 0.90899557329420322, 0.90937548898638343, 0.90977343289358581, 0.91018945694595299, 0.91062066118926255, 0.91106561536604569, 0.91152288520059055, 0.91199251420905114, 0.91246267559409011, 0.91293337477184511, 0.91340312985160943, 0.913868962989555, 0.91431893754461024, 0.91474703359021303, 0.91515915917858226, 0.91555078037697457, 0.91591884409892588, 0.91626478357739838, 0.91658704145838465, 0.91687505480339337, 0.91713175029956107, 0.91735706509272863, 0.91755545350448875, 0.91772687327707392, 0.91786827844042718, 0.91798716036095396, 0.91808500304292484, 0.91816028415948625, 0.91821901402344985, 0.91825967860627289, 0.91828679080627507, 0.91830486670844014, 0.91831239859468972, 0.91831541139207662, 0.91831842421398058, 0.9183199306341252, 0.91832294349279686, 0.91832896928369712, 0.91833650166024239, 0.91834704724491512, 0.91836060629535066, 0.91838019246772817, 0.91840580671988459, 0.91843142274695011, 0.91846306852667337, 0.91849622415740195, 0.91853390462688844, 0.91857309639998097, 0.91860927712143836, 0.91864395364905449, 0.91868014133616016, 0.91871633258492125, 0.91875252739852931, 0.91879023412359218, 0.91882643622541071, 0.91886565920302743, 0.91890488637997114, 0.91894713573306408, 0.91899391749522075, 0.91904372401665591, 0.91909957577301316, 0.91915996567308311, 0.91922791627960709, 0.91930041091849901, 0.91937896310605793, 0.9194605545408977, 0.91954518730169055, 0.91963437539783843, 0.91972660999898548, 0.91982038084764928, 0.91991266313385878, 0.92000799598179606, 0.92010335420544709, 0.9201987378666262, 0.92029414702745282, 0.92038806671345164, 0.92048201121616824, 0.92057143311651646, 0.92065784520978722, 0.92074124532225499, 0.92082011446168743, 0.92089293241135062, 0.92096273042027832, 0.9210310244972566, 0.92109477762798375, 0.92115398734851706, 0.92120865136483698, 0.92125876755410285, 0.92130585294877876, 0.92134838715314216, 0.92138940719309148, 0.92142739301823195, 0.92146386331018604, 0.92149881759485375, 0.92153225541716222, 0.92156721658228058, 0.9215991407214319, 0.92162954739503067, 0.92165843620530352, 0.92168732742446702, 0.92171622105433382, 0.92174511709674722, 0.92177401555354477, 0.92179987411558317, 0.92182573461324435, 0.92185311842790896, 0.92188050441568747, 0.92190789257816086, 0.92193223943839697, 0.92195658801926594, 0.92197941637747971, 0.92199920217936204, 0.92201442280124013, 0.92202659978370582, 0.92203421061672253, 0.92203877719740213, 0.92204182161822956, 0.92204182161822956, 0.92203877719740213, 0.92203116626330228, 0.92201746700642795, 0.92200529034730039, 0.92199007012944389, 0.92197332866727399, 0.92195810986272031, 0.92194441351368328, 0.92193376117427861, 0.92192615256207566, 0.92192158747538822, 0.92192158747538822, 0.92192310916422837, 0.92193071770923252, 0.92194136995452414, 0.92195810986272031, 0.92197637250892117, 0.92199615813579749, 0.9220113786229841, 0.92202203336475108, 0.92202659978370582, 0.92201898911914126, 0.92200072421124657, 0.92197028485254506, 0.92192158747538822, 0.9218546398146592, 0.92176793146717229, 0.92166299781656036, 0.92153833536697727, 0.92139396527337292, 0.92122991190083869, 0.92105075637091016, 0.92085955564884703, 0.92065936139982207, 0.9204562497667812, 0.92025476872394574, 0.92005945599419703, 0.91987483965783312, 0.91970090290232487, 0.91953763000017175, 0.91938047389168964, 0.91922338584449315, 0.91905730879235692, 0.91887018520136299, 0.91865601581588341, 0.91840580671988459, 0.91811210248854447, 0.91777350098747168, 0.91739012257104524, 0.91696360265023924, 0.91650157926935916, 0.91601016598418594, 0.91549545130103493, 0.91497096142163903, 0.91444567750108996, 0.91392257581162739, 0.91341354197362534, 0.91292148926888328, 0.91244931977195232, 0.91199696118214013, 0.91156138375460261, 0.91114253208220297, 0.91073148638203461, 0.91032526870177954, 0.90993123844856627, 0.90955820281159283, 0.90922083197272086, 0.90894553165955805, 0.90876307556614933, 0.9087115896670781, 0.90883369467470709, 0.90916045707252191, 0.9097011861423161, 0.91047441625421488, 0.91146366357842545, 0.91261555645798975, 0.91387343045137259, 0.91518156967654307, 0.91646110383313117, 0.91763964991976132, 0.91868768088583252, 0.91957995292383821, 0.92029566166449828, 0.92083680057894945, 0.92122535596285027, 0.92147450119881469, 0.92160066099180737, 0.92162954739503067, 0.92157633746522905, 0.92146082397318763, 0.92129825810075294, 0.92109781378049249, 0.92087017518461289, 0.92062297463292564, 0.92036079715392627, 0.92008670252563118, 0.9198037423010198, 0.91951647039604523, 0.91922338584449315, 0.91892450154447636, 0.91862435347119176, 0.9183199306341252, 0.91801425268357884, 0.91770882539953602, 0.91740364692052401, 0.91710021693542221, 0.91679702971236843, 0.91649858094232273, 0.91620485842895494, 0.91591585030346601, 0.91563304081478569, 0.91535641552582825, 0.91508894789670925, 0.91482763298148373, 0.91457394963444738, 0.91433086429189847, 0.91409537700335275, 0.91387045213797369, 0.91365458315324144, 0.91345073030979207, 0.9132573882223467, 0.91307602782378106, 0.91290366166305748, 0.91274324818739472, 0.91259477319378868, 0.912458223605217, 0.9123321039162815, 0.9122193707290861, 0.91211556473582922, 0.91202512645258016, 0.91194508279524689, 0.91187690963104395, 0.9118191194040165, 0.91177170777827832, 0.91173467120284635, 0.91170652560797116, 0.91168726919099008, 0.91167541953037778, 0.91166949482636361, 0.91166949482636361, 0.91167541953037778, 0.911685787964993, 0.91170060046183332, 0.9117183761530111, 0.91173911541798147, 0.91176281869972275, 0.911789486504894, 0.91181615601912069, 0.91184579081831829, 0.91187246394371579, 0.91190062076683098, 0.91192877949868079, 0.91195694014041528, 0.91198510269318644, 0.91201326715814179, 0.91204143353645051, 0.91206960182924046, 0.91209925473332665, 0.91213187538104978, 0.91216153274700806, 0.91219267527026826, 0.91222382013989289, 0.91225348410335649, 0.91228166684248269, 0.91231133496268524, 0.91234100521656414, 0.91236771027046693, 0.9123929332991072, 0.91241815787204161, 0.91244486792755075, 0.91247009568257065, 0.91249384086505603, 0.91251610321872145, 0.91254133534357296, 0.9125695377871309, 0.91259625767776487, 0.91262149472675458, 0.91264821799964113, 0.9126734582447793, 0.91269721518891977, 0.91272245845087963, 0.91275067334902282, 0.91277889019124059, 0.9128071089787273, 0.91283532971268511, 0.91286355239429884, 0.91289029146931011, 0.91291406100521133, 0.91293783192466404, 0.91296160422837858, 0.91298686381863559, 0.91301361097228684, 0.91304184598276739, 0.91306859674478613, 0.91309683556639243, 0.9131221035408339, 0.91314737308432137, 0.91316967104404545, 0.9131919702266218, 0.91321427063264227, 0.91323805908159028, 0.91326333583539543, 0.91328712715909022, 0.91331091987772117, 0.91333768835448392, 0.91336148403978945, 0.91338379376372858, 0.91340610471629913, 0.91342692938107439, 0.91344924271074091, 0.91347453263850253, 0.91349833636794564, 0.91352362936609244, 0.91355041191310948, 0.91357570817137257, 0.91359951786218141, 0.91362332895761467, 0.91364862978639305, 0.91367095536532561, 0.91369477067908988, 0.91371709881412455, 0.91373793952354632, 0.9137558038473359, 0.91377218017396267, 0.91379004601766622, 0.91381237943813298, 0.9138347140990013, 0.91385853910515813, 0.91388087633148662, 0.91390023626583361, 0.91392257581162739, 0.9139449166008855, 0.91396874814736306, 0.9139910915084154, 0.91401343611484054, 0.91403578196725843, 0.9140581290663069, 0.91407898748403149, 0.91409984698875268, 0.9141192175026126, 0.91413709880957039, 0.914157961345061, 0.91417733467447582, 0.91419819931050372, 0.91421608415171973, 0.91423247929321372, 0.91425036567011397, 0.9142727247686766, 0.91429806659549251, 0.91432490087364005, 0.91435173695864813, 0.91437261071910714, 0.91438901229849856, 0.9144024322751696, 0.91441287034763952, 0.91442330869391819, 0.91443523856787523, 0.91445164272881008, 0.91447401312981635, 0.91449936777299046, 0.91452472403423368, 0.91454859022961399, 0.91457394963444738, 0.91459632692585346, 0.91461870547977708, 0.9146410852968454, 0.91466346637771578, 0.91468584872302827, 0.91470674005336849, 0.91472614013304454, 0.91474703359021303, 0.914769420661806, 0.91479330160193484, 0.91481718398497813, 0.91484256059885194, 0.91486644596040578, 0.9148888397995053, 0.91490974186268081, 0.9149306450335305, 0.91495304251780984, 0.91497544127491892, 0.91499784130552053, 0.91502173607589832, 0.9150456322967645, 0.91506803632187406, 0.91508894789670925, 0.91510986058378563, 0.91513077438364665, 0.91515168929682555, 0.91517111128497097, 0.91519202834677016, 0.91521294652345109, 0.91523386581556854, 0.91525478622363876, 0.91527570774821498, 0.91529812490699125, 0.91532203795716727, 0.91534445776817175, 0.91536687886353096, 0.91538930124391227, 0.91541022995890242, 0.91542966476898169, 0.9154491005456693, 0.91546853728938204, 0.9154909655035699, 0.9155133950064771, 0.91553582579878112, 0.91555975339919105, 0.91558368246821731, 0.91560462160898337, 0.91562705765173846, 0.91565398260959485, 0.9156809094302587, 0.91570484594673152, 0.91572728776923151, 0.91574973088755562, 0.91577067896769582, 0.91579312459319973, 0.91581257851839815, 0.91583053685340332, 0.91585597925115025, 0.91588741040037802, 0.91591734719830131, 0.91594129830260662, 0.91596375380860817, 0.91598022200775864, 0.91599369651028251, 0.91601765234056542, 0.91605209144742383, 0.91609551904498976, 0.91613146282009017, 0.91615542719712728, 0.91617639724862732, 0.91620186241625434, 0.91621983884194513, 0.91621834077443465, 0.916212348562641, 0.91623032547767946, 0.91627077660526646, 0.91630673673284924, 0.91633520755188824, 0.9163576860039222, 0.91637716839279404, 0.91639065677937803, 0.91640564443130978, 0.91642812700646603, 0.91644911193178968, 0.91644911193178968, 0.91645660682618668, 0.9164940834957529, 0.91653156383030576, 0.91655555316931392, 0.91657504561419567, 0.91658854096534859, 0.91659603858835048, 0.916608035090823, 0.91661553309595767, 0.91661253387626529, 0.91661403348317172, 0.91662453089619711, 0.91664552658699072, 0.91667552243206862, 0.91670702060477638, 0.91672352068479679, 0.91673552119107671, 0.91675652298538635, 0.9167820267190705, 0.91680753215909361, 0.91683303930648963, 0.91686004873646254, 0.91688255805874974, 0.9169005664753358, 0.91691107177873921, 0.91691707493953833, 0.91691257256005831, 0.91690206721520406, 0.91689456357509092, 0.91689606429127046, 0.9169065694703189, 0.91691707493953833, 0.9169350849906549, 0.91695909971959655, 0.91698912026544299, 0.91702064439300535, 0.91705367247824887, 0.91708520197002041, 0.91711373091294957, 0.91712874700892977, 0.91714226200432591, 0.91717079524560718, 0.91720083256067397, 0.91722186010050422, 0.91723688048779828, 0.91724589300667247, 0.91725490574047686, 0.91725791003285162, 0.91726542086829954, 0.91728044298719413, 0.91729997263510343, 0.91732401051179779, 0.91734354241409533, 0.9173585676425019, 0.917369085658579, 0.91737659870684063, 0.91738561456239442, 0.91740965789833151, 0.91743821135280768, 0.91746676697259522, 0.91749682786063236, 0.91752689115131181, 0.9175524468387688, 0.91756898379802609, 0.91758101113477186, 0.91759303885671906, 0.9176095776035782, 0.91763062797183426, 0.91765017579992625, 0.91766070197551775, 0.91766671706566438, 0.91767573988182327, 0.91768175521325557, 0.9176832590611943, 0.9176832590611943, 0.91768025137134535, 0.91768175521325557, 0.91769529006194994, 0.91771032935611907, 0.91772386523709393, 0.91774191383943626, 0.91776898837453147, 0.91779756917580979, 0.91782314332314185, 0.91784420569941805, 0.91785774642536588, 0.91786827844042718, 0.91787881075247735, 0.91789235273307168, 0.91790138099303009, 0.9179149237924441, 0.91793147677033171, 0.91795254525909886, 0.91797813002448136, 0.91800070627599528, 0.91800221140806437, 0.91800221140806437, 0.91801726306327636, 0.91803532585253178, 0.91805037884634455, 0.91806543244897143, 0.91808199211530472, 0.91810005804667838, 0.91811812485581179, 0.9181316755389235, 0.9181316755389235, 0.91812866423330985, 0.9181316755389235, 0.9181392039097076, 0.91815426110891418, 0.91817534221326547, 0.9181934126839264, 0.91821299001994738, 0.91823256838898815, 0.91825516009907049, 0.918277753185889, 0.91830034765020863, 0.91832143706039993, 0.91834252767183266, 0.91836211288717562, 0.91838019246772817, 0.91839977967738529, 0.91841334066119196, 0.9184208747560727, 0.9184299158726803, 0.91844046412166036, 0.91845553357128451, 0.91847813889874808, 0.91850375994341593, 0.91852787549309944, 0.91855199261977361, 0.91857460385910761, 0.91859118631648751, 0.91859872404388387, 0.91860475433688116, 0.91861832285720002, 0.91863943043844032, 0.91867410980772968, 0.91870879244755776, 0.91872688903716981, 0.91874046206436577, 0.91875554379400981, 0.91877062614315763, 0.91878118415629417, 0.91879475919094034, 0.91881587690993605, 0.91884001293501083, 0.91886867652903947, 0.91888979850700137, 0.91888979850700137, 0.91888074608159198, 0.91887471125560749, 0.91887471125560749, 0.91888225480362462, 0.91889281603186557, 0.91889885115617942, 0.91891243054962501, 0.91893959084795929, 0.91896826223934025, 0.91899240831267703, 0.91901051891454655, 0.91903164908478174, 0.91905730879235692, 0.91908749899318232, 0.91911467231018207, 0.91912674998995558, 0.91913429874301855, 0.91914486725997691, 0.91915694594040542, 0.91917355477992069, 0.91919318438502762, 0.9192113049599514, 0.91923244677113458, 0.91925358981109095, 0.91927020306207829, 0.91928379628672985, 0.91929587957993841, 0.91930494231357096, 0.91931249476430854, 0.91933062128690812, 0.91936083416921188, 0.91939104956732187, 0.91940766910934391, 0.91941975652753738, 0.91944091047948984, 0.91947868846644953, 0.91952251587091094, 0.919561813921147, 0.91959053442928285, 0.91961169837019174, 0.91963135171184318, 0.91964949420785724, 0.919669149608073, 0.91969485444018018, 0.91972207331924249, 0.91975383127741606, 0.91977651724823906, 0.91978710452397971, 0.91979466705451807, 0.91979920464915044, 0.91980676743405909, 0.91981433037798888, 0.91982189348097143, 0.91982491876670525, 0.91983248209240309, 0.9198521474840099, 0.91987937826460753, 0.91989904622347296, 0.91991115011831037, 0.91991720221877993, 0.91992476748789875, 0.91995654336025001, 0.91999588881804661, 0.92002918450302862, 0.92004583350639757, 0.92005037427805858, 0.92004886068110181, 0.92004734709054858, 0.92005037427805858, 0.92005491510732429, 0.92006853794080024, 0.9201018403843273, 0.92013968783547873, 0.92016694048268088, 0.92017299690891052, 0.9201578560359176, 0.9201260622913876, 0.92008973004611161, 0.92006853794080024, 0.92007459269993874, 0.9201018403843273, 0.92014877182019861, 0.92020782335376783, 0.92026991371034184, 0.92031686725961392, 0.92033807411778712, 0.92033807411778712, 0.92033352968467286, 0.92033050009482986, 0.92034110377209644, 0.92035776733192109, 0.92037746163627543, 0.92040927781691684, 0.92043503585897479, 0.92045776509440436, 0.92047594953044543, 0.92048655754840347, 0.9204941348982536, 0.920506258994645, 0.92052899279253531, 0.92055172804828533, 0.92056082255897898, 0.92056688569580225, 0.92057749643494613, 0.92059871886698574, 0.9206244906734975, 0.92065026435716468, 0.92067149115409297, 0.92069120289255779, 0.9207124321483392, 0.92074276187022741, 0.92078067768765604, 0.92081404697854774, 0.92083224974133548, 0.92084438543892289, 0.92086410683924658, 0.92088534650562637, 0.92088838084829683, 0.92089293241135062, 0.92090962197955439, 0.92092782968424625, 0.92094603833164446, 0.92096424792219067, 0.92097487061906991, 0.92098701123735949, 0.92100674063711185, 0.92103406009790345, 0.92107200732228123, 0.92111147679235028, 0.92114032267841495, 0.92116613416973159, 0.92120257716341791, 0.92123143056003087, 0.92123446789821306, 0.92123446789821306, 0.92124509878973382, 0.92126636154317887, 0.9212937012712592, 0.92132104314073326, 0.92133167666861504, 0.92133623399407527, 0.92133927224414203, 0.9213499063277959, 0.92136813694011455, 0.92139092654655519, 0.92141523710338025, 0.92143651023292794, 0.92145778466273931, 0.92147602092375469, 0.92148513941283894, 0.92149121853840643, 0.92149881759485375, 0.92151401620613216, 0.92154137538178926, 0.92157329714427572, 0.92160370155253346, 0.92162650660768619, 0.92163258820904725, 0.92163106779870563, 0.9216219454766722, 0.92162346584701726, 0.92164627220221906, 0.92167972423840416, 0.92171317950602893, 0.92174511709674722, 0.92177401555354477, 0.92179378957395308, 0.92179835297012502, 0.92179835297012502, 0.92180747994331158, 0.92182421335389964, 0.92185159704787911, 0.92188354743742962, 0.92191854411786422, 0.92195050071267781, 0.92197180675654233, 0.92198702616665895, 0.92200376829521713, 0.9220113786229841, 0.92200224624985849, 0.92199159212093706, 0.92200072421124657, 0.92201594490047367, 0.92202812193683437, 0.92204638830001195, 0.92207835677180949, 0.92211489581181971, 0.92215143874201821, 0.92218341700009476, 0.9222062604397061, 0.92221692123277577, 0.92223824381450581, 0.92225042874317198, 0.92228698613254734, 0.92232507090221327, 0.92234030599838546, 0.92235401816585205, 0.92234944738219116, 0.92234335309914739, 0.92233421187840336, 0.92232050050581116, 0.92230678968328683, 0.92230678968328683, 0.92232507090221327, 0.92234792380124253, 0.92237839671198119, 0.92240582465764276, 0.92242563510089137, 0.92244392268536779, 0.92245611495337898, 0.92248202497136611, 0.92250031558246937, 0.92251708283913847, 0.92251860717615031, 0.92251098555934619, 0.92249726707905833, 0.92250336411316713, 0.92252318022816771, 0.92254757087686912, 0.92257348785756466, 0.92257348785756466, 0.92255976685703367, 0.92255519331322522, 0.92257806164746137, 0.9226299022357225, 0.9226710753998657, 0.92269700180730996, 0.92271835445485306, 0.92272293019717011, 0.92270767796296971, 0.92268480089812621, 0.92267565050424982, 0.92268785108427553, 0.92270462759847827, 0.92275496212369179, 0.92283429232036551, 0.92291974566109813, 0.9229838498658024, 0.9230265927754624, 0.9230357526760905, 0.92306934111098871, 0.92308308280073537, 0.92311973005210712, 0.92315485408469189, 0.92318081768720628, 0.92314874529347324, 0.92312125710761272, 0.9230494929943196, 0.92301285339165906, 0.92296248044370821, 0.92294111237573651, 0.92295790145802981, 0.92303117269463186, 0.92315485408469189, 0.92324344405325487, 0.92330608212153531, 0.92336109106533071, 0.92330913793674319, 0.92327246999459667, 0.92322816825155507, 0.92318387236068855, 0.92318234502046925, 0.9231884544230512, 0.92313958231496762, 0.92316249022996433, 0.92320831074962306, 0.92315485408469189, 0.92311820300353375, 0.92306018029629733, 0.92304491282593526, 0.92289990635148156, 0.92295790145802981, 0.92303117269463186, 0.92317929036088031, 0.92317165383351907, 0.92337178829948718, 0.92352005668140591, 0.92362862483933728, 0.92380148959148478, 0.92368368702526071, 0.92383362483154274, 0.92387647667177131, 0.92392086478879765, 0.92389790467379385, 0.92402497067007827, 0.92380148959148478, 0.92378771830011641, 0.9239530116305551, 0.9240127212143644, 0.92407550448760922, 0.92412910943562077, 0.9241735315819557, 0.92431296423639342, 0.92431449679268396, 0.92425932927988641, 0.92405712765721959, 0.92405100227488268, 0.92403875185180562, 0.92404947094709444, 0.92415361746380964, 0.92421029927876608, 0.92419038293218125, 0.9241965109101975, 0.92418272312038952, 0.92420570309159089, 0.92424247439078777, 0.92428231461539867, 0.92432829012198103, 0.92440952929552367, 0.92444785666545581, 0.92448312181739745, 0.92455826463306112, 0.92465029984807701, 0.92474696485978636, 0.92484212361973361, 0.9250294532210529, 0.92514620533408154, 0.92525838870963106, 0.92535677351917056, 0.92545672653322764, 0.92558594291036778, 0.92566596025439007, 0.92580295975437166, 0.9259076734128715, 0.92610333446992821, 0.92623435659638353, 0.92635155207599618, 0.92649347897039058, 0.92662003340026478, 0.92670185813323158, 0.92679914951971365, 0.92690419669856572, 0.92701237075696352, 0.92713913716867891, 0.92728606600013042, 0.92740985012500432, 0.92754142565172537, 0.92763433666156159, 0.92769629308787505, 0.92775516339027841, 0.92780009840677335, 0.92780629686242944, 0.92784813975322611, 0.92792874235263589, 0.92803107660510531, 0.92811017684964581, 0.92818464312159243, 0.9282653357367372, 0.92831034681131175, 0.92838952061977298, 0.92847026843033154, 0.9284407618937589, 0.92844697355405492, 0.92848579935719933, 0.9284795868895197, 0.92851841693379567, 0.92858055552005703, 0.92853239698673073, 0.92855569853133435, 0.92859298479209473, 0.9285712339063078, 0.92863804525291571, 0.92871108877432051, 0.92866601724716547, 0.92873440431662424, 0.92866290911788885, 0.9286877750620246, 0.92867378771252185, 0.92862250639244415, 0.92863649133036041, 0.92858832375430889, 0.92867534182995859, 0.92871886041835794, 0.92880591673755375, 0.92880280714324848, 0.92884167941781715, 0.92887744641742243, 0.92881213602404966, 0.9288152457162463, 0.92869088345131479, 0.92870331733361544, 0.92863338350957325, 0.92868311253905178, 0.92870020881426041, 0.92878570495759327, 0.92873906764479641, 0.92876083081179395, 0.92873906764479641, 0.92872974106170125, 0.92873440431662424, 0.92864426102431619, 0.92865358492495431, 0.92857589467672719, 0.92857900189751341, 0.92854948460805264, 0.92847026843033154, 0.9284795868895197, 0.92841746931716607, 0.92846560930976407, 0.92839883656210953, 0.92834294525675476, 0.9283212125658109, 0.92826067980410554, 0.9283243171394403, 0.92828085603396537, 0.92821567617761214, 0.92822653850446546, 0.92811327924316711, 0.92802022132802919, 0.92801246779777058, 0.92797215265000321, 0.92791634055529482, 0.92795819866016493, 0.92789928891407514, 0.92784039063388524, 0.92787913821312573, 0.92785433919139881, 0.92783729104164925, 0.9278605387564538, 0.92783264171271451, 0.92780009840677335, 0.92771333331819716, 0.92772417759860515, 0.92766996006490277, 0.92762039820376097, 0.92753832910565237, 0.92752749144189295, 0.92747950069831586, 0.92747485683299913, 0.92742842206006748, 0.92744080397659889, 0.92747021303823973, 0.92744544732455425, 0.92743925620962098, 0.92740830251464013, 0.92744080397659889, 0.92744854292903989, 0.92738818429198533, 0.92735414108029435, 0.92733247918785233, 0.92733557365016961, 0.92733093196840177, 0.92732319598830548, 0.92727678420521187, 0.92726750269097669, 0.92724275335810402, 0.92722883273476864, 0.92721491274211343, 0.92725203412417956, 0.92726595579922799, 0.9272690495905318, 0.92725667461238337, 0.92724430013297743, 0.92721491274211343, 0.92722264599352067, 0.92720563309727189, 0.92724275335810402, 0.92723501960059007, 0.92725358094578625, 0.92725512777519015, 0.92725822145738812, 0.9272705964978698, 0.92727987810565748, 0.9272690495905318, 0.92725512777519015, 0.92730153628230605, 0.92729225401939186, 0.92731081882611832, 0.92730927171598088, 0.92726750269097669, 0.92724584691563272, 0.92719480719898473, 0.92715769272633619, 0.92716542453889561, 0.92721491274211343, 0.92722728603778193, 0.92723192615211025, 0.92723811308023341, 0.92725822145738812, 0.92723037943954767, 0.92721491274211343, 0.92716697092472877, 0.92713604468447408, 0.92711439816461416, 0.92711439816461416, 0.92713449845401386, 0.92718088874695304, 0.92717624940290666, 0.92717315654575128, 0.92716542453889561, 0.92715460005570505, 0.92715150741615504, 0.927163878160842, 0.92713295223133374, 0.92713913716867891, 0.92713140601640864, 0.92715769272633619, 0.92716233179055463, 0.92718243521050969, 0.92717624940290666, 0.92721181949604115, 0.92723811308023341, 0.92727523726667771, 0.92729225401939186, 0.92732319598830548, 0.92733247918785233, 0.92733712089305009, 0.92732629035692082, 0.92732938475676918, 0.92729998921898438, 0.92732319598830548, 0.92733093196840177, 0.9273556884169305, 0.92737425706616783, 0.92738354181298788, 0.9273990170167935, 0.9274160406447618, 0.9273990170167935, 0.92741913595160896, 0.92739437437351346, 0.92740365973050076, 0.92742996977222125, 0.92749962493057292, 0.92751665416299245, 0.92755381215032484, 0.92756774756257254, 0.92761420353840707, 0.92760646038389849, 0.92763123917135726, 0.92763898295598868, 0.92768544980225154, 0.92767460690327375, 0.92768854784439414, 0.92767615586517294, 0.92768390079301766, 0.92764362932130762, 0.92761265489176137, 0.92756619915198324, 0.92757548973348058, 0.92755226381049438, 0.9275770381912557, 0.92758168361177917, 0.92761420353840707, 0.92759407174600228, 0.92765601997563985, 0.92767925381264194, 0.92773657153593492, 0.92774121939281828, 0.92779854881265456, 0.92783419148109525, 0.9278775882147573, 0.92788998842385606, 0.92793339315776535, 0.92795354747339964, 0.92800781577522051, 0.92800936644143994, 0.92804503396385551, 0.9280341781845719, 0.92805433922851299, 0.92805899196854069, 0.92806674669478295, 0.9280047144666751, 0.92809001207066233, 0.92813499689289691, 0.92820481424349621, 0.92826378375115948, 0.92833828811885066, 0.92834449765215188, 0.92836002204862855, 0.92837554725001692, 0.9284298917988385, 0.92843920899885635, 0.92848424622815917, 0.92850288430989725, 0.92851065052077819, 0.92850443753589806, 0.92851841693379567, 0.9285153103443301, 0.92855414503836642, 0.92856191258414833, 0.92860696834318035, 0.92861318346556365, 0.9286256140996374, 0.92861007588815325, 0.92862716796539957, 0.9286287218392737, 0.92863649133036041, 0.92862095255102117, 0.92863338350957325, 0.92867845008922056, 0.92872818665966728, 0.92876393996594619, 0.92881213602404966, 0.92882302008951212, 0.92885567468561092, 0.92887122575919345, 0.92891477311407789, 0.9289101070193404, 0.9289334382295944, 0.92890077505076651, 0.92890388567424098, 0.92893499370910215, 0.92896766067063552, 0.928969216330361, 0.92899255220999244, 0.92901744584904666, 0.92905167803405531, 0.92903922950687357, 0.92906101477452896, 0.9290625709267013, 0.92910770291670963, 0.92912793674475025, 0.92916218177862508, 0.92917619226044335, 0.92917619226044335, 0.92916218177862508, 0.92915284182840008, 0.92909680835470576, 0.92908902677154381, 0.92907502044003487, 0.92907968914318573, 0.92908280165307444, 0.92911704143368978, 0.92910770291670963, 0.92912015433854434, 0.92911081572278176, 0.92907502044003487, 0.92908747047959517, 0.92911237213815423, 0.92910459014356239, 0.92915284182840008, 0.92917307876232036, 0.9291652951613163, 0.92911392856177011, 0.92910459014356239, 0.92909680835470576, 0.92907346422209547, 0.92902522554209965, 0.92899410800089821, 0.92896766067063552, 0.92895054895451201, 0.9289536601018844, 0.92897077199828715, 0.92892721639345299, 0.92883856944813714, 0.92877171299390571, 0.92877171299390571, 0.92879347855604188, 0.92881213602404966, 0.92883856944813714, 0.92888366720644178, 0.92890544099823946, 0.92886500523171855, 0.92879503330018998, 0.92871730607327763, 0.92863649133036041, 0.92855725203239636, 0.92852307687864954, 0.92860230708653224, 0.92872974106170125, 0.9288961091769049, 0.9290361174572227, 0.92912482375756833, 0.92922912677836478, 0.92923068382043417, 0.92919020341028535, 0.92908747047959517, 0.92891788388481555, 0.92876704915269159, 0.92865513893681118, 0.92859453848756723, 0.92864270706929919, 0.92877326762393619, 0.92896454937578632, 0.92915751176642347, 0.9293474855457966, 0.92943940233108546, 0.929462775615708, 0.92937396708028186, 0.92924936896969745, 0.92913416281796046, 0.92900188707849274, 0.9289334382295944, 0.92893810469266225, 0.92898010617794369, 0.92901277813170524, 0.92906568325572791, 0.9291030337693339, 0.9291030337693339, 0.92908435792035715, 0.9290625709267013, 0.92903144944432581, 0.92900655462349446, 0.92895210452411037, 0.92889455390197828, 0.92881369086606069, 0.92877637690845694, 0.92875305806892938, 0.92879814281295614, 0.92885567468561092, 0.92890077505076651, 0.92896766067063552, 0.92899099642728278, 0.92897232767440263, 0.9289256609548906, 0.92882923973501363, 0.92875927624692012, 0.92865669295678677, 0.9285852164363011, 0.92855103807673134, 0.92854793114745682, 0.9285852164363011, 0.92865980102109913, 0.92869554609619476, 0.92875461260121395, 0.92876549455523827, 0.92879036909221036, 0.92882457498865223, 0.92886500523171855, 0.92885722975621932, 0.92886811547911619, 0.92888522242412641, 0.92898166190325715, 0.928989440652781, 0.928989440652781, 0.9290003312465599, 0.92895210452411037, 0.92890699633043017, 0.92890077505076651, 0.92888055679558401, 0.92891321774098934, 0.92901277813170524, 0.92912171080331074, 0.92924469757083239, 0.92933346687991347, 0.92939421928317234, 0.92940668287452988, 0.92936929369414623, 0.92940045101243141, 0.92940356692687343, 0.92942537925816637, 0.92936306262875534, 0.92946745049719348, 0.92940668287452988, 0.92931944888521545, 0.92914817196456301, 0.92897232767440263, 0.92883390455483794, 0.92875772169021087, 0.92865980102109913, 0.92868622087957242, 0.92861007588815325, 0.92890233035841829, 0.92886345012027571, 0.92881058119019078, 0.92865980102109913, 0.92861629107541699, 0.9283864153701008, 0.92829482498804194, 0.92804503396385551, 0.92852463020976894, 0.92845939726203963, 0.92836778454868729, 0.92837244214532966, 0.92824360866899358, 0.92829482498804194, 0.92811327924316711, 0.92895521568787265, 0.92904856585296991, 0.92898010617794369, 0.92892721639345299, 0.92909525202162491, 0.92891477311407789, 0.92994468361929816, 0.93002742162577579, 0.93001180886364387, 0.92998839130618505, 0.93006333419067899, 0.93079505702964493, 0.93085611899503595, 0.93073713862765728, 0.93059786983700699, 0.93052904306363093, 0.93102371584510668, 0.93086394840633524, 0.93053373526933414, 0.93019296900791237, 0.92970284982407414, 0.93004615805736313, 0.92962332279206994, 0.92933658208098013, 0.92919954454810982, 0.92942849543842132, 0.92936929369414623, 0.92926805530917722, 0.92917619226044335, 0.92939110346835641, 0.9293474855457966, 0.92933813969395351, 0.92926026918971139, 0.92937864054109132, 0.92935060089605503, 0.92930543156142631, 0.9292244557017364, 0.92925715479979676, 0.92914661535976784, 0.92911704143368978, 0.92913571935685213, 0.92926494083658562, 0.92936150488314118, 0.92950017676477992, 0.92970752856298045, 0.92988693718161031, 0.93007894974679639, 0.93030234511026511, 0.93044772377568197, 0.93062133731820051, 0.93076687902969579, 0.9309203265777426, 0.93102214905782088, 0.93114281723661074, 0.93124472038793549, 0.93141568749273795, 0.93161030978133419, 0.93177521769223826, 0.93198267024209969, 0.93216038657927491, 0.93227840358193237, 0.93245316245248366, 0.93264064140997061, 0.93280932585479359, 0.93307596806617732, 0.93338712325804474, 0.9336290332682976, 0.9339107501437327, 0.93413887734405421, 0.93425143010877743, 0.93434816926134034, 0.93450842326548766, 0.93450207468567714, 0.93468465864855188, 0.93471801403689192, 0.9349643426708093, 0.93517112397378632, 0.93524114954239468, 0.93538603648905849, 0.93561388386387689, 0.93566489891641769, 0.93590417036959894, 0.93602548870667235, 0.93623154613465998, 0.93650815623964523, 0.93647136360000072, 0.93665378115282616, 0.93655775502912919, 0.93662656993488436, 0.93669380313963535, 0.93661056474650062, 0.93665858344603026, 0.93659776134750516, 0.93673062914642791, 0.93653055445380962, 0.93670340938980923, 0.93695651003169655, 0.93689881841742884, 0.93712966711012191, 0.93720185242289777, 0.93741532638143499, 0.93733505083002611, 0.93746832293038218, 0.9373543145206642, 0.93743459650117211, 0.93757274431621074, 0.93743138470723808, 0.93760809725079408, 0.93758077861555922, 0.93777207468602697, 0.93774312930200332, 0.93788628247915529, 0.93778333217400545, 0.9378267589001692, 0.93774312930200332, 0.93782032481106636, 0.93775920963685788, 0.9378830646072186, 0.93789432734974332, 0.9381052002928395, 0.93810036903845861, 0.93830497878792574, 0.93825985269824619, 0.93842589497908513, 0.93858560000432822, 0.93854687361189737, 0.93846298844294518, 0.93862917488096442, 0.93856462241093142, 0.93868244413116719, 0.93862271882977955, 0.93870343233445552, 0.93857914515936569, 0.93866630064730761, 0.93859205502787968, 0.9387211930626369, 0.9386501582827026, 0.93877932857315016, 0.93872442243169163, 0.938819709021122, 0.93873572557669482, 0.93883586316876499, 0.93874056994997113, 0.93876640831342084, 0.93865822932513443, 0.93858237255953991, 0.93872280774157213, 0.938656615094274, 0.93870827603490503, 0.93858075885386416, 0.93864692994403442, 0.93853880642190501, 0.93844847290943434, 0.93855494108057125, 0.93863078892170282, 0.93879709510451603, 0.93885040286418109, 0.93904758670748767, 0.93906375678652565, 0.93903465146078913, 0.93911389124491973, 0.93898130123271339, 0.939065373856806, 0.93903465146078913, 0.93902818410949196, 0.93918021488859726, 0.93913491862223331, 0.93918668651254711, 0.93905243761211088, 0.93889241155515746, 0.93886655915135475, 0.93871473445907938, 0.93870020325685932, 0.93858882749378392, 0.93855332756452958, 0.93867921534481324, 0.93873572557669482, 0.93873895514765249, 0.93883263224920555, 0.93874541442422132, 0.938819709021122, 0.93877286835341645, 0.93875025899949238, 0.93872765184560647, 0.93870504689005685, 0.93868405854112624, 0.93866307208487276, 0.9386437016501038, 0.93862433282580415, 0.93860657948402815, 0.93858882749378392, 0.93857107685422858, 0.93855494108057125, 0.93853880642190501, 0.93852428618190642, 0.93850976684409271, 0.93849524840801923, 0.93848234388816443, 0.93846944008012945, 0.93845653698360476, 0.93844524735755019, 0.93843557096843322, 0.93842428235304132, 0.93841460682989597, 0.9384065441991154, 0.93839848184566377, 0.93839041976946902, 0.93838235797046465, 0.93837590873077581, 0.93836945966837715, 0.93836462298792489, 0.93835978640717432, 0.93835494992610347, 0.93835172566076452, 0.9383468893457737, 0.9383452772629356, 0.93834205313044561, 0.93834044108079173, 0.93833882904222599, 0.93833882904222599, 0.93833882904222599, 0.93833882904222599, 0.93833882904222599, 0.93834044108079173, 0.93834205313044561, 0.93834366519116219, 0.9383468893457737, 0.93835011354469644, 0.93835333778789876, 0.9383581742357423, 0.93836301078326878, 0.93836784743049118, 0.93837268417741393, 0.93837752102407668, 0.93838397030809051, 0.93839041976946902, 0.93839848184566377, 0.9384049317062455, 0.93841299428156266, 0.93842105713426083, 0.93843073292381163, 0.93843879638705241, 0.93844847290943434, 0.93845814983175813, 0.93846782715415633, 0.93847911786943827, 0.93849040912962511, 0.93850008778653549, 0.93851299328566051, 0.93852428618190642, 0.93853719301732785, 0.93854848708333538, 0.93856139525620241, 0.93857430414280085, 0.93858882749378392, 0.93860173789815882, 0.93861626295741707, 0.93863078892170282, 0.93864531579148058, 0.93865984356719268, 0.93867598660327212, 0.93869051629300337, 0.93870666145688242, 0.93872280774157213, 0.93873895514765249, 0.93875510367578185, 0.93878740410064121, 0.93880355599861265, 0.938819709021122, 0.93883586316876499, 0.938852018442211, 0.93888433236889512, 0.9389004910234181, 0.93891665080619391, 0.93893281171789478, 0.93894897375911468, 0.93898130123271339, 0.938997466666322, 0.93901363323197351, 0.93902980093032007, 0.93904596976198396, 0.93907831082773607, 0.9390944830631105, 0.93911065643432834, 0.93912683094201932, 0.9391430065868005, 0.93917536129024837, 0.93919154035016683, 0.93920772054973822, 0.93922390188959792, 0.93924008437037443, 0.9392724527572327, 0.93928863866460766, 0.93930482571543861, 0.93932101391040002, 0.93935339373521731, 0.93936958536636062, 0.93940197206932219, 0.93941816714243909, 0.93943436336414454, 0.93945056073510458, 0.93948295892736844, 0.93949915974996567, 0.9395153617243881, 0.93953156485127165, 0.93954776913129678, 0.93956397456511442, 0.93958018115332742, 0.93959638889662234, 0.93961259779563078, 0.93962880785101532, 0.93966123143349067, 0.9396774449618831, 0.93969365964924711, 0.93970987549625018, 0.93972609250353167, 0.93975853000156773, 0.93977475049360415, 0.9397909721485519, 0.93980719496705944, 0.93982341894976384, 0.93985587041044594, 0.93987209788975068, 0.93988832653587318, 0.93990455634951986, 0.93992078733130224, 0.93995325280200714, 0.93996948729225072, 0.93998572295329752, 0.94000195978580448, 0.94003443696787492, 0.94005067731877778, 0.9400831615435925, 0.94009940541886416, 0.94011565047024526, 0.94013189669841646, 0.94016439268777319, 0.94018064245030775, 0.94019689339230816, 0.94021314551442325, 0.94022939881735068, 0.94026190896828754, 0.94027816581763668, 0.94029442385047679, 0.94031068306747012, 0.9403269434692989, 0.94035946783016866, 0.94037573179054634, 0.94039199693845077, 0.94040826327456739, 0.94042453079957788, 0.94045706941898022, 0.94047334051470699, 0.94048961280205789, 0.94050588628166154, 0.94052216095424246, 0.94055471388099765, 0.94057099213656037, 0.94058727158779043, 0.94060355223540215, 0.94061983408007599, 0.94065240136328876, 0.94066868680322868, 0.94068497344297453, 0.94070126128318277, 0.94071755032456761, 0.94075013201362123, 0.9407664246626557, 0.94078271851560802, 0.94079901357317153, 0.94081530983603712, 0.94084790598047341, 0.94086420586343311, 0.94088050695446179, 0.94089680925423858, 0.94091311276349676, 0.94092941748290271, 0.9409457234131734, 0.94096203055497829, 0.94097833890905047, 0.94099464847605563, 0.94102727125167207, 0.94104358446170222, 0.94105989888746377, 0.94107621452966195, 0.94109253138900595, 0.9411088494661729, 0.94112516876190289, 0.94114148927687191, 0.94115781101178453, 0.94117413396735394, 0.94120678354326359, 0.9412231101649986, 0.94123943801022092, 0.94125576707962699, 0.9412720973739136, 0.94130476163997379, 0.94132109561315813, 0.94133743081408805, 0.94135376724344477, 0.94137010490192752, 0.94138644379027925, 0.94140278390918386, 0.94141912525935678, 0.94143546784155097, 0.94145181165643521, 0.94146815670473205, 0.94148450298717234, 0.94150085050446608, 0.94151719925732502, 0.94153354924648647, 0.9415662529364982, 0.94158260663879756, 0.94159896158027323, 0.94161531776161111, 0.94163167518355784, 0.94164803384679441, 0.94166439375210498, 0.94168075490017622, 0.94169711729173178, 0.94171348092749541, 0.94172984580818775, 0.94174621193455132, 0.9417625793072858, 0.94177894792713612, 0.94179531779484027, 0.94182806127663266, 0.94184443489220626, 0.94186080975853037, 0.94187718587633806, 0.94189356324636608, 0.9419099418693021, 0.94192632174593349, 0.94194270287697079, 0.94195908526315142, 0.9419754689051969, 0.94199185380385841, 0.94200823995984906, 0.94202462737393899, 0.94204101604680246, 0.94205740597925569, 0.94207379717197437, 0.94209018962572355, 0.9421065833412301, 0.94212297831924174, 0.94213937456050889, 0.94213937456050889, 0.94215577206572187, 0.94217217083570515, 0.94218857087112662, 0.94220497217275323, 0.94220497217275323, 0.94222137474134815, 0.94223777857762858, 0.94225418368234104, 0.94227059005625324, 0.94227059005625324, 0.9422869977000885, 0.94230340661458745, 0.94231981680050636, 0.94231981680050636, 0.94233622825859475, 0.94233622825859475, 0.9423526409896229, 0.94236905499431733, 0.94236905499431733, 0.94238547027338948, 0.94238547027338948, 0.94240188682767267, 0.94241830465784615, 0.94243472376468074, 0.94245114414893827, 0.94246756581138624, 0.94248398875275141, 0.94250041297377352, 0.94251683847525669, 0.94251683847525669, 0.94253326525789582, 0.94254969332250005, 0.94256612266981643, 0.94258255330058383, 0.94259898521556174, 0.94261541841549135, 0.94263185290118423, 0.94264828867333639, 0.9426647257327756, 0.94268116408021785, 0.9426976037164303, 0.94271404464217079, 0.94273048685823635, 0.94274693036535318, 0.94276337516430031, 0.94277982125582216, 0.94279626864072585, 0.94281271731974803, 0.94282916729364885, 0.94282916729364885, 0.94284561856323101, 0.94286207112921894, 0.94287852499240776, 0.94289498015356144, 0.94289498015356144, 0.94291143661345356, 0.94292789437285995, 0.94294435343254102, 0.9429608137932709, 0.9429608137932709, 0.94297727545580989, 0.9429937384209629, 0.94301020268945979, 0.94302666826213477, 0.94302666826213477, 0.9430431351397307, 0.94305960332300054, 0.94307607281276362, 0.94307607281276362, 0.94309254360975214, 0.94309254360975214, 0.94310901571479477, 0.94312548912862337, 0.94312548912862337, 0.94314196385204285, 0.94314196385204285, 0.94315843988584069, 0.94317491723078739, 0.94317491723078739, 0.94319139588765277, 0.94319139588765277, 0.94320787585724419, 0.94322435714033181, 0.94322435714033181, 0.94324083973769379, 0.94324083973769379, 0.94325732365010917, 0.94327380887836354, 0.94327380887836354, 0.94329029542327103, 0.94329029542327103, 0.94330678328559681, 0.94332327246613656, 0.94332327246613656, 0.94333976296563704, 0.94333976296563704, 0.94335625478494145, 0.94335625478494145, 0.9433727479248144, 0.9433727479248144, 0.94338924238605271, 0.94338924238605271, 0.9434057381694344, 0.9434057381694344, 0.94342223527575697, 0.94342223527575697, 0.94343873370581788, 0.94343873370581788, 0.94345523346041149, 0.94345523346041149, 0.94347173454031275, 0.94347173454031275, 0.94348823694634643, 0.94348823694634643, 0.94350474067924728, 0.94350474067924728, 0.94352124573987561, 0.94352124573987561, 0.94353775212898405, 0.94353775212898405, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94358727927532482, 0.94358727927532482, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94362030402998776, 0.94362030402998776, 0.94360379098640079, 0.94360379098640079, 0.94358727927532482, 0.94357076889594704, 0.94357076889594704, 0.94355425984742158, 0.94353775212898405, 0.94352124573987561, 0.94350474067924728, 0.94348823694634643, 0.94347173454031275, 0.94345523346041149, 0.94343873370581788, 0.9434057381694344, 0.94338924238605271, 0.94335625478494145, 0.94333976296563704, 0.94330678328559681, 0.94327380887836354, 0.94324083973769379, 0.94320787585724419, 0.94317491723078739])


###### PROSAIL 4

# Refractive Index:
P4_refractive = np.array([1.4963, 1.4970, 1.4976, 1.4984, 1.4995, 1.5006, 1.5017, 1.5029, 1.5044, 1.5057,
                        1.5069, 1.5079, 1.5093, 1.5108, 1.5124, 1.5139, 1.5154, 1.5168, 1.5182, 1.5197,
                        1.5212, 1.5225, 1.5239, 1.5253, 1.5268, 1.5284, 1.5296, 1.5303, 1.5312, 1.5321,
                        1.5329, 1.5336, 1.5344, 1.5351, 1.5358, 1.5364, 1.5370, 1.5374, 1.5378, 1.5383,
                        1.5388, 1.5394, 1.5399, 1.5404, 1.5408, 1.5413, 1.5415, 1.5418, 1.5421, 1.5425,
                        1.5428, 1.5430, 1.5433, 1.5435, 1.5436, 1.5437, 1.5436, 1.5435, 1.5435, 1.5433,
                        1.5430, 1.5426, 1.5421, 1.5416, 1.5411, 1.5406, 1.5401, 1.5396, 1.5393, 1.5390,
                        1.5388, 1.5385, 1.5382, 1.5381, 1.5379, 1.5377, 1.5376, 1.5375, 1.5374, 1.5373,
                        1.5371, 1.5369, 1.5366, 1.5362, 1.5357, 1.5350, 1.5343, 1.5333, 1.5322, 1.5310,
                        1.5294, 1.5278, 1.5258, 1.5237, 1.5213, 1.5188, 1.5160, 1.5131, 1.5100, 1.5068,
                        1.5035, 1.5000, 1.4964, 1.4928, 1.4892, 1.4855, 1.4819, 1.4784, 1.4750, 1.4716,
                        1.4684, 1.4654, 1.4625, 1.4598, 1.4573, 1.4550, 1.4529, 1.4510, 1.4493, 1.4478,
                        1.4465, 1.4453, 1.4443, 1.4434, 1.4426, 1.4419, 1.4414, 1.4409, 1.4404, 1.4400,
                        1.4396, 1.4392, 1.4388, 1.4384, 1.4380, 1.4376, 1.4372, 1.4368, 1.4363, 1.4359,
                        1.4355, 1.4350, 1.4346, 1.4341, 1.4337, 1.4333, 1.4329, 1.4324, 1.4320, 1.4316,
                        1.4311, 1.4307, 1.4302, 1.4297, 1.4292, 1.4287, 1.4281, 1.4275, 1.4268, 1.4262,
                        1.4255, 1.4248, 1.4241, 1.4234, 1.4227, 1.4220, 1.4213, 1.4206, 1.4199, 1.4192,
                        1.4186, 1.4179, 1.4173, 1.4167, 1.4161, 1.4156, 1.4151, 1.4146, 1.4141, 1.4137,
                        1.4133, 1.4129, 1.4126, 1.4123, 1.4120, 1.4117, 1.4115, 1.4112, 1.4110, 1.4107,
                        1.4105, 1.4103, 1.4101, 1.4099, 1.4097, 1.4095, 1.4093, 1.4091, 1.4089, 1.4088,
                        1.4086, 1.4084, 1.4082, 1.4081, 1.4079, 1.4078, 1.4077, 1.4076, 1.4076, 1.4075,
                        1.4075, 1.4075, 1.4075, 1.4076, 1.4077, 1.4078, 1.4079, 1.4080, 1.4081, 1.4082,
                        1.4082, 1.4083, 1.4083, 1.4083, 1.4083, 1.4083, 1.4082, 1.4081, 1.4079, 1.4078,
                        1.4077, 1.4076, 1.4076, 1.4077, 1.4078, 1.4080, 1.4083, 1.4088, 1.4093, 1.4100,
                        1.4108, 1.4118, 1.4129, 1.4140, 1.4153, 1.4166, 1.4180, 1.4193, 1.4206, 1.4218,
                        1.4229, 1.4240, 1.4251, 1.4261, 1.4272, 1.4285, 1.4299, 1.4315, 1.4335, 1.4357,
                        1.4383, 1.4411, 1.4442, 1.4475, 1.4509, 1.4544, 1.4580, 1.4615, 1.4649, 1.4682,
                        1.4714, 1.4744, 1.4774, 1.4802, 1.4830, 1.4857, 1.4884, 1.4909, 1.4932, 1.4951,
                        1.4963, 1.4967, 1.4958, 1.4936, 1.4899, 1.4847, 1.4780, 1.4703, 1.4618, 1.4530,
                        1.4445, 1.4366, 1.4297, 1.4238, 1.4190, 1.4154, 1.4129, 1.4113, 1.4104, 1.4102,
                        1.4106, 1.4113, 1.4124, 1.4137, 1.4152, 1.4169, 1.4186, 1.4204, 1.4223, 1.4242,
                        1.4261, 1.4281, 1.4301, 1.4321, 1.4341, 1.4362, 1.4382, 1.4402, 1.4422, 1.4442,
                        1.4462, 1.4481, 1.4500, 1.4518, 1.4536, 1.4554, 1.4571, 1.4587, 1.4603, 1.4618,
                        1.4633, 1.4646, 1.4659, 1.4672, 1.4683, 1.4694, 1.4704, 1.4713, 1.4722, 1.4729,
                        1.4736, 1.4742, 1.4748, 1.4752, 1.4756, 1.4759, 1.4762, 1.4764, 1.4765, 1.4766,
                        1.4766, 1.4766, 1.4766, 1.4765, 1.4764, 1.4763, 1.4762, 1.4760, 1.4758, 1.4756,
                        1.4754, 1.4753, 1.4751, 1.4749, 1.4747, 1.4745, 1.4743, 1.4741, 1.4739, 1.4737,
                        1.4735, 1.4733, 1.4731, 1.4729, 1.4727, 1.4725, 1.4723, 1.4721, 1.4719, 1.4717,
                        1.4716, 1.4714, 1.4712, 1.4711, 1.4709, 1.4707, 1.4706, 1.4704, 1.4702, 1.4700,
                        1.4699, 1.4697, 1.4695, 1.4693, 1.4691, 1.4690, 1.4688, 1.4686, 1.4684, 1.4682,
                        1.4681, 1.4679, 1.4677, 1.4676, 1.4674, 1.4672, 1.4670, 1.4668, 1.4667, 1.4665,
                        1.4664, 1.4662, 1.4661, 1.4659, 1.4657, 1.4656, 1.4654, 1.4652, 1.4651, 1.4649,
                        1.4648, 1.4646, 1.4645, 1.4643, 1.4641, 1.4640, 1.4638, 1.4636, 1.4635, 1.4633,
                        1.4631, 1.4630, 1.4628, 1.4627, 1.4626, 1.4625, 1.4623, 1.4622, 1.4620, 1.4619,
                        1.4617, 1.4616, 1.4615, 1.4613, 1.4612, 1.4610, 1.4608, 1.4607, 1.4606, 1.4604,
                        1.4603, 1.4601, 1.4600, 1.4599, 1.4597, 1.4596, 1.4595, 1.4594, 1.4593, 1.4591,
                        1.4589, 1.4588, 1.4586, 1.4584, 1.4583, 1.4582, 1.4582, 1.4581, 1.4580, 1.4579,
                        1.4578, 1.4576, 1.4574, 1.4573, 1.4571, 1.4569, 1.4568, 1.4566, 1.4565, 1.4563,
                        1.4562, 1.4561, 1.4559, 1.4558, 1.4556, 1.4555, 1.4553, 1.4551, 1.4550, 1.4548,
                        1.4547, 1.4545, 1.4544, 1.4543, 1.4541, 1.4539, 1.4538, 1.4536, 1.4535, 1.4534,
                        1.4532, 1.4531, 1.4529, 1.4528, 1.4527, 1.4525, 1.4524, 1.4522, 1.4521, 1.4519,
                        1.4518, 1.4516, 1.4515, 1.4514, 1.4512, 1.4511, 1.4510, 1.4508, 1.4506, 1.4505,
                        1.4503, 1.4502, 1.4500, 1.4499, 1.4497, 1.4495, 1.4494, 1.4492, 1.4491, 1.4489,
                        1.4488, 1.4487, 1.4485, 1.4483, 1.4481, 1.4479, 1.4478, 1.4477, 1.4476, 1.4474,
                        1.4472, 1.4469, 1.4467, 1.4465, 1.4464, 1.4462, 1.4461, 1.4461, 1.4461, 1.4460,
                        1.4457, 1.4455, 1.4453, 1.4452, 1.4450, 1.4449, 1.4448, 1.4447, 1.4445, 1.4445,
                        1.4445, 1.4442, 1.4440, 1.4438, 1.4437, 1.4436, 1.4436, 1.4435, 1.4434, 1.4435,
                        1.4435, 1.4434, 1.4432, 1.4430, 1.4428, 1.4427, 1.4426, 1.4425, 1.4423, 1.4422,
                        1.4420, 1.4418, 1.4417, 1.4415, 1.4415, 1.4414, 1.4415, 1.4415, 1.4416, 1.4416,
                        1.4415, 1.4414, 1.4413, 1.4411, 1.4409, 1.4407, 1.4405, 1.4403, 1.4401, 1.4400,
                        1.4399, 1.4397, 1.4395, 1.4394, 1.4393, 1.4392, 1.4392, 1.4392, 1.4391, 1.4390,
                        1.4389, 1.4387, 1.4386, 1.4385, 1.4384, 1.4384, 1.4383, 1.4382, 1.4380, 1.4378,
                        1.4376, 1.4374, 1.4372, 1.4371, 1.4370, 1.4369, 1.4368, 1.4367, 1.4365, 1.4365,
                        1.4364, 1.4364, 1.4363, 1.4363, 1.4363, 1.4363, 1.4363, 1.4363, 1.4361, 1.4361,
                        1.4359, 1.4358, 1.4356, 1.4354, 1.4353, 1.4352, 1.4351, 1.4350, 1.4349, 1.4349,
                        1.4348, 1.4347, 1.4345, 1.4344, 1.4342, 1.4342, 1.4342, 1.4341, 1.4340, 1.4339,
                        1.4338, 1.4337, 1.4336, 1.4334, 1.4334, 1.4334, 1.4334, 1.4334, 1.4333, 1.4332,
                        1.4331, 1.4329, 1.4328, 1.4327, 1.4325, 1.4324, 1.4322, 1.4321, 1.4320, 1.4318,
                        1.4317, 1.4316, 1.4315, 1.4314, 1.4314, 1.4313, 1.4312, 1.4310, 1.4309, 1.4307,
                        1.4306, 1.4304, 1.4303, 1.4303, 1.4302, 1.4301, 1.4300, 1.4297, 1.4295, 1.4294,
                        1.4293, 1.4292, 1.4291, 1.4290, 1.4290, 1.4288, 1.4286, 1.4285, 1.4283, 1.4283,
                        1.4284, 1.4284, 1.4284, 1.4284, 1.4283, 1.4283, 1.4282, 1.4280, 1.4278, 1.4276,
                        1.4275, 1.4274, 1.4272, 1.4270, 1.4268, 1.4268, 1.4267, 1.4266, 1.4266, 1.4264,
                        1.4263, 1.4262, 1.4261, 1.4259, 1.4258, 1.4257, 1.4256, 1.4256, 1.4255, 1.4254,
                        1.4252, 1.4250, 1.4249, 1.4248, 1.4247, 1.4244, 1.4241, 1.4239, 1.4237, 1.4235,
                        1.4234, 1.4233, 1.4232, 1.4230, 1.4228, 1.4226, 1.4224, 1.4224, 1.4223, 1.4223,
                        1.4223, 1.4222, 1.4222, 1.4221, 1.4221, 1.4219, 1.4218, 1.4216, 1.4216, 1.4215,
                        1.4215, 1.4213, 1.4210, 1.4208, 1.4207, 1.4206, 1.4207, 1.4207, 1.4206, 1.4206,
                        1.4205, 1.4203, 1.4201, 1.4199, 1.4198, 1.4199, 1.4201, 1.4204, 1.4205, 1.4205,
                        1.4203, 1.4200, 1.4196, 1.4192, 1.4189, 1.4187, 1.4187, 1.4188, 1.4188, 1.4187,
                        1.4186, 1.4185, 1.4183, 1.4181, 1.4180, 1.4178, 1.4178, 1.4177, 1.4176, 1.4175,
                        1.4173, 1.4173, 1.4172, 1.4172, 1.4170, 1.4168, 1.4167, 1.4165, 1.4164, 1.4163,
                        1.4161, 1.4158, 1.4156, 1.4155, 1.4154, 1.4153, 1.4151, 1.4151, 1.4151, 1.4150,
                        1.4148, 1.4147, 1.4146, 1.4145, 1.4145, 1.4143, 1.4142, 1.4139, 1.4136, 1.4134,
                        1.4133, 1.4130, 1.4129, 1.4128, 1.4128, 1.4128, 1.4126, 1.4124, 1.4123, 1.4122,
                        1.4122, 1.4121, 1.4121, 1.4120, 1.4118, 1.4116, 1.4115, 1.4114, 1.4112, 1.4112,
                        1.4111, 1.4111, 1.4110, 1.4108, 1.4106, 1.4104, 1.4103, 1.4102, 1.4102, 1.4103,
                        1.4103, 1.4101, 1.4099, 1.4097, 1.4095, 1.4093, 1.4092, 1.4091, 1.4091, 1.4091,
                        1.4090, 1.4088, 1.4086, 1.4083, 1.4081, 1.4080, 1.4079, 1.4078, 1.4077, 1.4078,
                        1.4078, 1.4078, 1.4077, 1.4076, 1.4075, 1.4073, 1.4070, 1.4068, 1.4066, 1.4064,
                        1.4064, 1.4062, 1.4061, 1.4059, 1.4057, 1.4056, 1.4055, 1.4055, 1.4055, 1.4056,
                        1.4057, 1.4058, 1.4058, 1.4057, 1.4055, 1.4053, 1.4051, 1.4050, 1.4049, 1.4048,
                        1.4046, 1.4045, 1.4044, 1.4044, 1.4044, 1.4045, 1.4045, 1.4044, 1.4042, 1.4040,
                        1.4040, 1.4041, 1.4042, 1.4040, 1.4037, 1.4034, 1.4032, 1.4031, 1.4030, 1.4031,
                        1.4033, 1.4034, 1.4033, 1.4032, 1.4028, 1.4023, 1.4018, 1.4013, 1.4011, 1.4010,
                        1.4008, 1.4007, 1.4004, 1.4002, 1.4000, 1.4003, 1.4004, 1.4009, 1.4012, 1.4015,
                        1.4016, 1.4015, 1.4010, 1.4002, 1.3996, 1.3992, 1.3989, 1.3992, 1.3995, 1.3997,
                        1.4000, 1.4000, 1.4000, 1.4003, 1.4002, 1.3999, 1.4002, 1.4005, 1.4008, 1.4009,
                        1.4019, 1.4015, 1.4010, 1.4001, 1.4001, 1.3988, 1.3978, 1.3971, 1.3960, 1.3968,
                        1.3958, 1.3955, 1.3952, 1.3954, 1.3945, 1.3960, 1.3961, 1.3950, 1.3946, 1.3942,
                        1.3938, 1.3936, 1.3927, 1.3926, 1.3930, 1.3943, 1.3944, 1.3944, 1.3944, 1.3937,
                        1.3933, 1.3934, 1.3934, 1.3935, 1.3934, 1.3931, 1.3928, 1.3926, 1.3920, 1.3918,
                        1.3915, 1.3910, 1.3905, 1.3898, 1.3892, 1.3880, 1.3872, 1.3865, 1.3858, 1.3852,
                        1.3844, 1.3838, 1.3829, 1.3823, 1.3810, 1.3801, 1.3794, 1.3785, 1.3776, 1.3771,
                        1.3765, 1.3758, 1.3751, 1.3743, 1.3733, 1.3725, 1.3717, 1.3711, 1.3707, 1.3703,
                        1.3700, 1.3700, 1.3697, 1.3692, 1.3685, 1.3680, 1.3675, 1.3670, 1.3667, 1.3662,
                        1.3657, 1.3659, 1.3658, 1.3656, 1.3656, 1.3654, 1.3650, 1.3653, 1.3651, 1.3649,
                        1.3651, 1.3646, 1.3642, 1.3644, 1.3640, 1.3645, 1.3643, 1.3644, 1.3647, 1.3646,
                        1.3649, 1.3644, 1.3641, 1.3635, 1.3636, 1.3633, 1.3631, 1.3635, 1.3635, 1.3643,
                        1.3642, 1.3646, 1.3643, 1.3642, 1.3637, 1.3640, 1.3638, 1.3640, 1.3640, 1.3640,
                        1.3646, 1.3645, 1.3650, 1.3650, 1.3652, 1.3657, 1.3656, 1.3660, 1.3657, 1.3662,
                        1.3665, 1.3667, 1.3671, 1.3666, 1.3669, 1.3673, 1.3673, 1.3680, 1.3686, 1.3686,
                        1.3689, 1.3693, 1.3690, 1.3694, 1.3698, 1.3695, 1.3697, 1.3698, 1.3696, 1.3698,
                        1.3700, 1.3706, 1.3705, 1.3709, 1.3712, 1.3717, 1.3718, 1.3721, 1.3721, 1.3724,
                        1.3723, 1.3721, 1.3723, 1.3724, 1.3726, 1.3723, 1.3723, 1.3727, 1.3729, 1.3730,
                        1.3730, 1.3731, 1.3731, 1.3734, 1.3735, 1.3736, 1.3737, 1.3738, 1.3736, 1.3735,
                        1.3735, 1.3735, 1.3736, 1.3738, 1.3738, 1.3739, 1.3736, 1.3737, 1.3735, 1.3735,
                        1.3735, 1.3734, 1.3734, 1.3734, 1.3735, 1.3732, 1.3733, 1.3732, 1.3732, 1.3735,
                        1.3736, 1.3739, 1.3742, 1.3741, 1.3738, 1.3737, 1.3737, 1.3736, 1.3735, 1.3737,
                        1.3738, 1.3741, 1.3743, 1.3744, 1.3745, 1.3743, 1.3740, 1.3741, 1.3741, 1.3741,
                        1.3742, 1.3742, 1.3741, 1.3743, 1.3743, 1.3743, 1.3742, 1.3741, 1.3740, 1.3741,
                        1.3738, 1.3736, 1.3734, 1.3733, 1.3731, 1.3730, 1.3730, 1.3731, 1.3731, 1.3733,
                        1.3731, 1.3730, 1.3729, 1.3728, 1.3727, 1.3726, 1.3725, 1.3726, 1.3725, 1.3726,
                        1.3726, 1.3724, 1.3720, 1.3719, 1.3716, 1.3715, 1.3712, 1.3713, 1.3711, 1.3711,
                        1.3708, 1.3708, 1.3707, 1.3708, 1.3708, 1.3710, 1.3712, 1.3715, 1.3715, 1.3716,
                        1.3715, 1.3714, 1.3712, 1.3713, 1.3710, 1.3708, 1.3704, 1.3704, 1.3700, 1.3698,
                        1.3695, 1.3694, 1.3692, 1.3690, 1.3687, 1.3687, 1.3684, 1.3685, 1.3684, 1.3684,
                        1.3683, 1.3687, 1.3682, 1.3679, 1.3674, 1.3670, 1.3665, 1.3665, 1.3664, 1.3663,
                        1.3660, 1.3659, 1.3656, 1.3655, 1.3654, 1.3655, 1.3654, 1.3654, 1.3652, 1.3651,
                        1.3648, 1.3648, 1.3647, 1.3648, 1.3647, 1.3647, 1.3646, 1.3647, 1.3646, 1.3644,
                        1.3640, 1.3638, 1.3635, 1.3634, 1.3632, 1.3631, 1.3628, 1.3629, 1.3627, 1.3629,
                        1.3629, 1.3627, 1.3625, 1.3625, 1.3623, 1.3622, 1.3620, 1.3620, 1.3619, 1.3619,
                        1.3616, 1.3615, 1.3612, 1.3612, 1.3612, 1.3613, 1.3613, 1.3617, 1.3617, 1.3618,
                        1.3618, 1.3618, 1.3615, 1.3616, 1.3615, 1.3616, 1.3618, 1.3617, 1.3616, 1.3616,
                        1.3613, 1.3612, 1.3612, 1.3616, 1.3616, 1.3617, 1.3618, 1.3621, 1.3623, 1.3625,
                        1.3626, 1.3626, 1.3625, 1.3628, 1.3633, 1.3638, 1.3638, 1.3636, 1.3635, 1.3633,
                        1.3630, 1.3629, 1.3632, 1.3636, 1.3641, 1.3646, 1.3651, 1.3654, 1.3649, 1.3640,
                        1.3630, 1.3621, 1.3615, 1.3608, 1.3608, 1.3611, 1.3617, 1.3628, 1.3638, 1.3645,
                        1.3649, 1.3646, 1.3638, 1.3625, 1.3613, 1.3601, 1.3595, 1.3593, 1.3599, 1.3607,
                        1.3614, 1.3623, 1.3627, 1.3627, 1.3624, 1.3622, 1.3619, 1.3616, 1.3616, 1.3617,
                        1.3619, 1.3621, 1.3623, 1.3626, 1.3630, 1.3635, 1.3637, 1.3639, 1.3636, 1.3632,
                        1.3629, 1.3625, 1.3624, 1.3625, 1.3628, 1.3634, 1.3638, 1.3645, 1.3650, 1.3652,
                        1.3652, 1.3650, 1.3645, 1.3642, 1.3639, 1.3638, 1.3636, 1.3634, 1.3632, 1.3632,
                        1.3631, 1.3630, 1.3624, 1.3624, 1.3624, 1.3623, 1.3626, 1.3629, 1.3629, 1.3631,
                        1.3628, 1.3622, 1.3615, 1.3607, 1.3602, 1.3598, 1.3597, 1.3599, 1.3597, 1.3597,
                        1.3596, 1.3600, 1.3593, 1.3597, 1.3602, 1.3613, 1.3625, 1.3634, 1.3638, 1.3645,
                        1.3643, 1.3648, 1.3629, 1.3632, 1.3635, 1.3645, 1.3648, 1.3662, 1.3668, 1.3684,
                        1.3653, 1.3658, 1.3664, 1.3663, 1.3672, 1.3668, 1.3680, 1.3626, 1.3620, 1.3624,
                        1.3628, 1.3617, 1.3628, 1.3562, 1.3557, 1.3558, 1.3559, 1.3555, 1.3508, 1.3504,
                        1.3512, 1.3521, 1.3525, 1.3493, 1.3504, 1.3525, 1.3546, 1.3578, 1.3556, 1.3583,
                        1.3601, 1.3610, 1.3595, 1.3599, 1.3606, 1.3612, 1.3598, 1.3601, 1.3601, 1.3606,
                        1.3599, 1.3600, 1.3603, 1.3608, 1.3606, 1.3614, 1.3615, 1.3614, 1.3606, 1.3600,
                        1.3591, 1.3577, 1.3566, 1.3554, 1.3539, 1.3530, 1.3519, 1.3510, 1.3500, 1.3493,
                        1.3486, 1.3479, 1.3468, 1.3456, 1.3445, 1.3432, 1.3421, 1.3413, 1.3402, 1.3390,
                        1.3380, 1.3363, 1.3343, 1.3328, 1.3310, 1.3296, 1.3289, 1.3282, 1.3272, 1.3273,
                        1.3261, 1.3259, 1.3244, 1.3231, 1.3226, 1.3217, 1.3203, 1.3200, 1.3185, 1.3177,
                        1.3164, 1.3147, 1.3149, 1.3138, 1.3144, 1.3139, 1.3135, 1.3140, 1.3137, 1.3141,
                        1.3133, 1.3145, 1.3135, 1.3119, 1.3122, 1.3108, 1.3104, 1.3090, 1.3095, 1.3087,
                        1.3094, 1.3089, 1.3080, 1.3089, 1.3078, 1.3080, 1.3068, 1.3070, 1.3061, 1.3067,
                        1.3065, 1.3070, 1.3065, 1.3069, 1.3061, 1.3060, 1.3047, 1.3048, 1.3035, 1.3038,
                        1.3027, 1.3018, 1.3020, 1.3025, 1.3015, 1.3019, 1.3012, 1.3015, 1.3010, 1.3018,
                        1.3013, 1.3017, 1.3009, 1.3014, 1.3006, 1.3009, 1.3003, 1.3008, 1.3002, 1.3008,
                        1.3006, 1.3013, 1.3018, 1.3009, 1.3013, 1.3010, 1.3018, 1.3014, 1.3020, 1.3026,
                        1.3019, 1.3015, 1.3004, 1.3001, 1.2989, 1.2988, 1.2990, 1.2985, 1.2993, 1.2988,
                        1.2990, 1.2990, 1.2981, 1.2983, 1.2980, 1.2989, 1.2999, 1.3000, 1.3010, 1.3010,
                        1.3017, 1.3019, 1.3012, 1.3008, 1.3008, 1.3002, 1.3008, 1.3003, 1.3006, 1.3007,
                        1.3009, 1.3010, 1.3011, 1.3013, 1.3014, 1.3015, 1.3016, 1.3017, 1.3018, 1.3019,
                        1.3020, 1.3021, 1.3022, 1.3023, 1.3024, 1.3025, 1.3025, 1.3026, 1.3027, 1.3027,
                        1.3028, 1.3029, 1.3029, 1.3030, 1.3030, 1.3030, 1.3031, 1.3031, 1.3032, 1.3032,
                        1.3032, 1.3032, 1.3032, 1.3033, 1.3033, 1.3033, 1.3033, 1.3033, 1.3033, 1.3033,
                        1.3033, 1.3033, 1.3032, 1.3032, 1.3032, 1.3032, 1.3032, 1.3031, 1.3031, 1.3031,
                        1.3030, 1.3030, 1.3030, 1.3029, 1.3029, 1.3028, 1.3028, 1.3027, 1.3027, 1.3026,
                        1.3025, 1.3025, 1.3024, 1.3023, 1.3023, 1.3022, 1.3021, 1.3021, 1.3020, 1.3019,
                        1.3018, 1.3017, 1.3016, 1.3016, 1.3015, 1.3014, 1.3013, 1.3012, 1.3011, 1.3010,
                        1.3009, 1.3008, 1.3007, 1.3005, 1.3004, 1.3003, 1.3002, 1.3001, 1.2999, 1.2998,
                        1.2997, 1.2996, 1.2995, 1.2993, 1.2992, 1.2991, 1.2990, 1.2989, 1.2987, 1.2986,
                        1.2985, 1.2984, 1.2983, 1.2981, 1.2980, 1.2979, 1.2978, 1.2977, 1.2975, 1.2974,
                        1.2973, 1.2972, 1.2970, 1.2969, 1.2967, 1.2966, 1.2965, 1.2964, 1.2962, 1.2961,
                        1.2960, 1.2959, 1.2958, 1.2957, 1.2956, 1.2955, 1.2954, 1.2953, 1.2951, 1.2950,
                        1.2949, 1.2948, 1.2947, 1.2945, 1.2944, 1.2943, 1.2942, 1.2941, 1.2939, 1.2938,
                        1.2937, 1.2936, 1.2935, 1.2933, 1.2932, 1.2931, 1.2930, 1.2928, 1.2927, 1.2925,
                        1.2924, 1.2923, 1.2922, 1.2920, 1.2919, 1.2918, 1.2917, 1.2916, 1.2914, 1.2913,
                        1.2912, 1.2911, 1.2910, 1.2908, 1.2907, 1.2906, 1.2905, 1.2904, 1.2902, 1.2901,
                        1.2900, 1.2899, 1.2898, 1.2896, 1.2895, 1.2894, 1.2893, 1.2892, 1.2890, 1.2889,
                        1.2888, 1.2887, 1.2886, 1.2884, 1.2883, 1.2882, 1.2881, 1.2880, 1.2878, 1.2877,
                        1.2876, 1.2875, 1.2874, 1.2873, 1.2872, 1.2871, 1.2870, 1.2869, 1.2867, 1.2866,
                        1.2865, 1.2864, 1.2863, 1.2862, 1.2861, 1.2860, 1.2859, 1.2858, 1.2856, 1.2855,
                        1.2854, 1.2853, 1.2852, 1.2850, 1.2849, 1.2848, 1.2847, 1.2846, 1.2845, 1.2844,
                        1.2843, 1.2842, 1.2841, 1.2840, 1.2839, 1.2838, 1.2837, 1.2836, 1.2834, 1.2833,
                        1.2832, 1.2831, 1.2830, 1.2829, 1.2828, 1.2827, 1.2826, 1.2825, 1.2824, 1.2823,
                        1.2822, 1.2821, 1.2820, 1.2818, 1.2817, 1.2816, 1.2815, 1.2814, 1.2813, 1.2812,
                        1.2811, 1.2810, 1.2809, 1.2808, 1.2807, 1.2806, 1.2805, 1.2804, 1.2803, 1.2802,
                        1.2801, 1.2800, 1.2799, 1.2799, 1.2798, 1.2797, 1.2796, 1.2795, 1.2795, 1.2794,
                        1.2793, 1.2792, 1.2791, 1.2791, 1.2790, 1.2789, 1.2788, 1.2788, 1.2787, 1.2787,
                        1.2786, 1.2785, 1.2785, 1.2784, 1.2784, 1.2783, 1.2782, 1.2781, 1.2780, 1.2779,
                        1.2778, 1.2777, 1.2776, 1.2776, 1.2775, 1.2774, 1.2773, 1.2772, 1.2771, 1.2770,
                        1.2769, 1.2768, 1.2767, 1.2766, 1.2765, 1.2764, 1.2763, 1.2762, 1.2761, 1.2760,
                        1.2759, 1.2758, 1.2757, 1.2757, 1.2756, 1.2755, 1.2754, 1.2753, 1.2753, 1.2752,
                        1.2751, 1.2750, 1.2749, 1.2749, 1.2748, 1.2747, 1.2746, 1.2745, 1.2745, 1.2744,
                        1.2743, 1.2742, 1.2742, 1.2741, 1.2741, 1.2740, 1.2739, 1.2739, 1.2738, 1.2738,
                        1.2737, 1.2736, 1.2736, 1.2735, 1.2735, 1.2734, 1.2733, 1.2733, 1.2732, 1.2732,
                        1.2731, 1.2730, 1.2730, 1.2729, 1.2729, 1.2728, 1.2727, 1.2727, 1.2726, 1.2726,
                        1.2725, 1.2725, 1.2724, 1.2724, 1.2723, 1.2723, 1.2722, 1.2722, 1.2721, 1.2721,
                        1.2720, 1.2720, 1.2719, 1.2719, 1.2718, 1.2718, 1.2717, 1.2717, 1.2716, 1.2716,
                        1.2715, 1.2715, 1.2714, 1.2714, 1.2713, 1.2713, 1.2713, 1.2713, 1.2712, 1.2712,
                        1.2712, 1.2712, 1.2711, 1.2711, 1.2710, 1.2710, 1.2710, 1.2710, 1.2709, 1.2709,
                        1.2709, 1.2709, 1.2709, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708,
                        1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2708, 1.2709, 1.2709, 1.2710,
                        1.2710, 1.2711, 1.2712, 1.2712, 1.2713, 1.2714, 1.2715, 1.2716, 1.2717, 1.2718,
                        1.2719, 1.2720, 1.2722, 1.2723, 1.2725, 1.2726, 1.2728, 1.2730, 1.2732, 1.2734,
                        1.2736])

P4_k_Cab = np.array([1.290E-01, 1.310E-01, 1.332E-01, 1.355E-01, 1.376E-01, 1.393E-01, 1.405E-01, 1.415E-01, 1.425E-01, 1.432E-01,
                1.440E-01, 1.451E-01, 1.463E-01, 1.471E-01, 1.478E-01, 1.485E-01, 1.490E-01, 1.493E-01, 1.496E-01, 1.499E-01,
                1.505E-01, 1.515E-01, 1.525E-01, 1.534E-01, 1.539E-01, 1.543E-01, 1.549E-01, 1.557E-01, 1.563E-01, 1.568E-01,
                1.576E-01, 1.587E-01, 1.596E-01, 1.603E-01, 1.609E-01, 1.614E-01, 1.619E-01, 1.622E-01, 1.624E-01, 1.626E-01,
                1.624E-01, 1.616E-01, 1.606E-01, 1.598E-01, 1.587E-01, 1.574E-01, 1.561E-01, 1.549E-01, 1.532E-01, 1.512E-01,
                1.489E-01, 1.465E-01, 1.438E-01, 1.412E-01, 1.387E-01, 1.363E-01, 1.339E-01, 1.315E-01, 1.293E-01, 1.271E-01,
                1.252E-01, 1.234E-01, 1.218E-01, 1.202E-01, 1.186E-01, 1.170E-01, 1.155E-01, 1.142E-01, 1.131E-01, 1.121E-01,
                1.112E-01, 1.105E-01, 1.100E-01, 1.095E-01, 1.091E-01, 1.087E-01, 1.084E-01, 1.079E-01, 1.074E-01, 1.070E-01,
                1.064E-01, 1.055E-01, 1.044E-01, 1.032E-01, 1.017E-01, 9.992E-02, 9.796E-02, 9.578E-02, 9.338E-02, 9.074E-02,
                8.801E-02, 8.520E-02, 8.234E-02, 7.941E-02, 7.651E-02, 7.362E-02, 7.073E-02, 6.787E-02, 6.506E-02, 6.233E-02,
                5.966E-02, 5.707E-02, 5.458E-02, 5.217E-02, 4.986E-02, 4.763E-02, 4.548E-02, 4.342E-02, 4.144E-02, 3.955E-02,
                3.773E-02, 3.598E-02, 3.431E-02, 3.270E-02, 3.117E-02, 2.971E-02, 2.834E-02, 2.704E-02, 2.583E-02, 2.469E-02,
                2.363E-02, 2.264E-02, 2.172E-02, 2.087E-02, 2.010E-02, 1.940E-02, 1.877E-02, 1.821E-02, 1.770E-02, 1.725E-02,
                1.685E-02, 1.650E-02, 1.618E-02, 1.591E-02, 1.567E-02, 1.546E-02, 1.528E-02, 1.512E-02, 1.498E-02, 1.486E-02,
                1.475E-02, 1.465E-02, 1.456E-02, 1.447E-02, 1.439E-02, 1.430E-02, 1.422E-02, 1.414E-02, 1.406E-02, 1.398E-02,
                1.392E-02, 1.386E-02, 1.382E-02, 1.380E-02, 1.379E-02, 1.381E-02, 1.384E-02, 1.390E-02, 1.398E-02, 1.409E-02,
                1.421E-02, 1.435E-02, 1.451E-02, 1.469E-02, 1.489E-02, 1.511E-02, 1.535E-02, 1.561E-02, 1.589E-02, 1.619E-02,
                1.650E-02, 1.683E-02, 1.716E-02, 1.749E-02, 1.782E-02, 1.814E-02, 1.846E-02, 1.876E-02, 1.905E-02, 1.933E-02,
                1.960E-02, 1.986E-02, 2.011E-02, 2.035E-02, 2.058E-02, 2.079E-02, 2.100E-02, 2.120E-02, 2.138E-02, 2.155E-02,
                2.171E-02, 2.185E-02, 2.199E-02, 2.211E-02, 2.222E-02, 2.231E-02, 2.241E-02, 2.250E-02, 2.259E-02, 2.269E-02,
                2.279E-02, 2.291E-02, 2.304E-02, 2.319E-02, 2.337E-02, 2.356E-02, 2.378E-02, 2.403E-02, 2.430E-02, 2.459E-02,
                2.489E-02, 2.520E-02, 2.552E-02, 2.586E-02, 2.620E-02, 2.654E-02, 2.687E-02, 2.719E-02, 2.750E-02, 2.778E-02,
                2.803E-02, 2.826E-02, 2.845E-02, 2.862E-02, 2.877E-02, 2.888E-02, 2.898E-02, 2.905E-02, 2.910E-02, 2.916E-02,
                2.921E-02, 2.928E-02, 2.938E-02, 2.951E-02, 2.969E-02, 2.993E-02, 3.022E-02, 3.059E-02, 3.103E-02, 3.152E-02,
                3.208E-02, 3.269E-02, 3.335E-02, 3.405E-02, 3.478E-02, 3.552E-02, 3.626E-02, 3.698E-02, 3.767E-02, 3.831E-02,
                3.890E-02, 3.943E-02, 3.993E-02, 4.043E-02, 4.095E-02, 4.152E-02, 4.217E-02, 4.293E-02, 4.380E-02, 4.479E-02,
                4.588E-02, 4.709E-02, 4.837E-02, 4.970E-02, 5.106E-02, 5.239E-02, 5.368E-02, 5.488E-02, 5.595E-02, 5.688E-02,
                5.765E-02, 5.826E-02, 5.871E-02, 5.900E-02, 5.914E-02, 5.914E-02, 5.899E-02, 5.868E-02, 5.819E-02, 5.748E-02,
                5.650E-02, 5.522E-02, 5.361E-02, 5.168E-02, 4.941E-02, 4.689E-02, 4.416E-02, 4.128E-02, 3.834E-02, 3.541E-02,
                3.254E-02, 2.978E-02, 2.717E-02, 2.473E-02, 2.247E-02, 2.039E-02, 1.850E-02, 1.678E-02, 1.523E-02, 1.384E-02,
                1.259E-02, 1.147E-02, 1.048E-02, 9.594E-03, 8.804E-03, 8.099E-03, 7.465E-03, 6.892E-03, 6.371E-03, 5.897E-03,
                5.461E-03, 5.061E-03, 4.691E-03, 4.348E-03, 4.029E-03, 3.733E-03, 3.456E-03, 3.199E-03, 2.960E-03, 2.736E-03,
                2.528E-03, 2.334E-03, 2.153E-03, 1.985E-03, 1.829E-03, 1.683E-03, 1.549E-03, 1.424E-03, 1.309E-03, 1.202E-03,
                1.103E-03, 1.012E-03, 9.268E-04, 8.485E-04, 7.767E-04, 7.109E-04, 6.505E-04, 5.948E-04, 5.437E-04, 4.967E-04,
                4.539E-04, 4.150E-04, 3.794E-04, 3.471E-04, 3.177E-04, 2.909E-04, 2.666E-04, 2.450E-04, 2.255E-04, 2.079E-04,
                1.924E-04, 1.788E-04, 1.667E-04, 1.556E-04, 1.456E-04, 1.365E-04, 1.282E-04, 1.209E-04, 1.142E-04, 1.083E-04,
                1.036E-04, 9.885E-05, 9.424E-05, 8.971E-05, 8.527E-05, 8.092E-05, 7.667E-05, 7.252E-05, 6.846E-05, 6.451E-05,
                6.065E-05, 5.690E-05, 5.325E-05, 4.971E-05, 4.628E-05, 4.295E-05, 3.974E-05, 3.664E-05, 3.365E-05, 3.078E-05,
                2.802E-05, 2.539E-05, 2.287E-05, 2.048E-05, 1.821E-05, 1.606E-05, 1.404E-05, 1.215E-05, 1.040E-05, 8.767E-06,
                7.272E-06, 5.912E-06, 4.688E-06, 3.602E-06, 2.656E-06, 1.851E-06, 1.189E-06, 6.710E-07, 2.990E-07, 7.500E-08,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
                    0.000000])

P4_k_Cw = np.array([5.800E-05, 5.852E-05, 5.900E-05, 5.989E-05, 6.100E-05, 6.203E-05, 6.300E-05, 6.399E-05, 6.500E-05, 6.603E-05,
                6.700E-05, 6.790E-05, 6.900E-05, 7.050E-05, 7.200E-05, 7.312E-05, 7.400E-05, 7.490E-05, 7.600E-05, 7.740E-05,
                7.900E-05, 8.063E-05, 8.200E-05, 8.297E-05, 8.400E-05, 8.551E-05, 8.700E-05, 8.800E-05, 8.900E-05, 9.050E-05,
                9.200E-05, 9.300E-05, 9.400E-05, 9.550E-05, 9.700E-05, 9.801E-05, 9.900E-05, 1.005E-04, 1.020E-04, 1.031E-04,
                1.040E-04, 1.050E-04, 1.060E-04, 1.070E-04, 1.080E-04, 1.090E-04, 1.100E-04, 1.110E-04, 1.120E-04, 1.130E-04,
                1.140E-04, 1.150E-04, 1.160E-04, 1.170E-04, 1.180E-04, 1.190E-04, 1.200E-04, 1.210E-04, 1.220E-04, 1.230E-04,
                1.240E-04, 1.250E-04, 1.260E-04, 1.270E-04, 1.280E-04, 1.289E-04, 1.300E-04, 1.315E-04, 1.330E-04, 1.340E-04,
                1.350E-04, 1.364E-04, 1.380E-04, 1.396E-04, 1.410E-04, 1.424E-04, 1.440E-04, 1.459E-04, 1.480E-04, 1.499E-04,
                1.520E-04, 1.544E-04, 1.570E-04, 1.596E-04, 1.620E-04, 1.643E-04, 1.670E-04, 1.704E-04, 1.740E-04, 1.775E-04,
                1.810E-04, 1.849E-04, 1.890E-04, 1.934E-04, 1.980E-04, 2.031E-04, 2.090E-04, 2.158E-04, 2.230E-04, 2.303E-04,
                2.380E-04, 2.463E-04, 2.550E-04, 2.640E-04, 2.730E-04, 2.819E-04, 2.910E-04, 3.004E-04, 3.100E-04, 3.194E-04,
                3.290E-04, 3.390E-04, 3.490E-04, 3.588E-04, 3.680E-04, 3.767E-04, 3.860E-04, 3.962E-04, 4.040E-04, 4.069E-04,
                4.090E-04, 4.138E-04, 4.160E-04, 4.112E-04, 4.090E-04, 4.176E-04, 4.270E-04, 4.268E-04, 4.230E-04, 4.237E-04,
                4.290E-04, 4.371E-04, 4.450E-04, 4.506E-04, 4.560E-04, 4.631E-04, 4.700E-04, 4.748E-04, 4.800E-04, 4.879E-04,
                4.950E-04, 4.983E-04, 5.030E-04, 5.141E-04, 5.270E-04, 5.363E-04, 5.440E-04, 5.532E-04, 5.640E-04, 5.759E-04,
                5.880E-04, 5.998E-04, 6.110E-04, 6.215E-04, 6.310E-04, 6.391E-04, 6.460E-04, 6.520E-04, 6.580E-04, 6.647E-04,
                6.720E-04, 6.793E-04, 6.860E-04, 6.920E-04, 6.990E-04, 7.084E-04, 7.180E-04, 7.257E-04, 7.340E-04, 7.455E-04,
                7.590E-04, 7.729E-04, 7.870E-04, 8.020E-04, 8.190E-04, 8.386E-04, 8.580E-04, 8.754E-04, 8.960E-04, 9.238E-04,
                9.520E-04, 9.745E-04, 1.000E-03, 1.037E-03, 1.079E-03, 1.119E-03, 1.159E-03, 1.204E-03, 1.253E-03, 1.304E-03,
                1.356E-03, 1.408E-03, 1.459E-03, 1.510E-03, 1.567E-03, 1.635E-03, 1.700E-03, 1.758E-03, 1.860E-03, 2.042E-03,
                2.224E-03, 2.323E-03, 2.366E-03, 2.400E-03, 2.448E-03, 2.519E-03, 2.587E-03, 2.629E-03, 2.653E-03, 2.674E-03,
                2.691E-03, 2.704E-03, 2.715E-03, 2.727E-03, 2.740E-03, 2.753E-03, 2.764E-03, 2.775E-03, 2.785E-03, 2.797E-03,
                2.810E-03, 2.824E-03, 2.839E-03, 2.854E-03, 2.868E-03, 2.881E-03, 2.893E-03, 2.907E-03, 2.922E-03, 2.938E-03,
                2.955E-03, 2.972E-03, 2.988E-03, 3.000E-03, 3.011E-03, 3.023E-03, 3.038E-03, 3.057E-03, 3.076E-03, 3.094E-03,
                3.111E-03, 3.127E-03, 3.144E-03, 3.162E-03, 3.181E-03, 3.202E-03, 3.223E-03, 3.242E-03, 3.263E-03, 3.289E-03,
                3.315E-03, 3.338E-03, 3.362E-03, 3.390E-03, 3.423E-03, 3.461E-03, 3.508E-03, 3.567E-03, 3.636E-03, 3.712E-03,
                3.791E-03, 3.866E-03, 3.931E-03, 3.981E-03, 4.019E-03, 4.049E-03, 4.072E-03, 4.087E-03, 4.098E-03, 4.109E-03,
                4.122E-03, 4.137E-03, 4.150E-03, 4.160E-03, 4.173E-03, 4.196E-03, 4.223E-03, 4.248E-03, 4.270E-03, 4.293E-03,
                4.318E-03, 4.347E-03, 4.381E-03, 4.418E-03, 4.458E-03, 4.500E-03, 4.545E-03, 4.594E-03, 4.646E-03, 4.701E-03,
                4.760E-03, 4.827E-03, 4.903E-03, 4.986E-03, 5.071E-03, 5.154E-03, 5.244E-03, 5.351E-03, 5.470E-03, 5.594E-03,
                5.722E-03, 5.855E-03, 5.995E-03, 6.146E-03, 6.303E-03, 6.463E-03, 6.628E-03, 6.804E-03, 6.993E-03, 7.197E-03,
                7.415E-03, 7.647E-03, 7.893E-03, 8.157E-03, 8.445E-03, 8.763E-03, 9.109E-03, 9.479E-03, 9.871E-03, 1.029E-02,
                1.072E-02, 1.119E-02, 1.168E-02, 1.218E-02, 1.268E-02, 1.319E-02, 1.372E-02, 1.428E-02, 1.487E-02, 1.551E-02,
                1.621E-02, 1.699E-02, 1.787E-02, 1.886E-02, 1.992E-02, 2.101E-02, 2.207E-02, 2.306E-02, 2.394E-02, 2.469E-02,
                2.532E-02, 2.583E-02, 2.623E-02, 2.652E-02, 2.672E-02, 2.689E-02, 2.702E-02, 2.713E-02, 2.722E-02, 2.728E-02,
                2.733E-02, 2.738E-02, 2.741E-02, 2.745E-02, 2.748E-02, 2.751E-02, 2.754E-02, 2.758E-02, 2.763E-02, 2.767E-02,
                2.771E-02, 2.773E-02, 2.773E-02, 2.774E-02, 2.774E-02, 2.773E-02, 2.770E-02, 2.766E-02, 2.761E-02, 2.757E-02,
                2.754E-02, 2.752E-02, 2.748E-02, 2.741E-02, 2.731E-02, 2.720E-02, 2.710E-02, 2.701E-02, 2.690E-02, 2.675E-02,
                2.659E-02, 2.645E-02, 2.633E-02, 2.624E-02, 2.613E-02, 2.593E-02, 2.558E-02, 2.523E-02, 2.513E-02, 2.501E-02,
                2.466E-02, 2.447E-02, 2.412E-02, 2.389E-02, 2.374E-02, 2.355E-02, 2.337E-02, 2.318E-02, 2.304E-02, 2.281E-02,
                2.246E-02, 2.243E-02, 2.238E-02, 2.222E-02, 2.204E-02, 2.201E-02, 2.204E-02, 2.196E-02, 2.177E-02, 2.190E-02,
                2.188E-02, 2.188E-02, 2.198E-02, 2.210E-02, 2.223E-02, 2.233E-02, 2.248E-02, 2.276E-02, 2.304E-02, 2.311E-02,
                2.329E-02, 2.388E-02, 2.446E-02, 2.475E-02, 2.516E-02, 2.620E-02, 2.769E-02, 2.830E-02, 2.914E-02, 3.108E-02,
                3.214E-02, 3.297E-02, 3.459E-02, 3.606E-02, 3.662E-02, 3.702E-02, 3.788E-02, 3.829E-02, 3.854E-02, 3.909E-02,
                3.949E-02, 3.972E-02, 4.000E-02, 4.040E-02, 4.057E-02, 4.075E-02, 4.115E-02, 4.127E-02, 4.149E-02, 4.204E-02,
                4.199E-02, 4.223E-02, 4.254E-02, 4.272E-02, 4.280E-02, 4.306E-02, 4.360E-02, 4.369E-02, 4.379E-02, 4.433E-02,
                4.454E-02, 4.466E-02, 4.505E-02, 4.527E-02, 4.552E-02, 4.605E-02, 4.658E-02, 4.691E-02, 4.705E-02, 4.713E-02,
                4.752E-02, 4.833E-02, 4.867E-02, 4.894E-02, 4.960E-02, 5.006E-02, 5.050E-02, 5.115E-02, 5.153E-02, 5.204E-02,
                5.298E-02, 5.346E-02, 5.386E-02, 5.465E-02, 5.528E-02, 5.566E-02, 5.596E-02, 5.653E-02, 5.745E-02, 5.789E-02,
                5.831E-02, 5.924E-02, 5.982E-02, 6.009E-02, 6.035E-02, 6.094E-02, 6.185E-02, 6.226E-02, 6.269E-02, 6.360E-02,
                6.407E-02, 6.458E-02, 6.562E-02, 6.636E-02, 6.672E-02, 6.699E-02, 6.769E-02, 6.900E-02, 6.989E-02, 7.037E-02,
                7.085E-02, 7.187E-02, 7.358E-02, 7.486E-02, 7.562E-02, 7.630E-02, 7.792E-02, 8.085E-02, 8.292E-02, 8.410E-02,
                8.528E-02, 8.801E-02, 9.268E-02, 9.584E-02, 9.819E-02, 1.012E-01, 1.042E-01, 1.066E-01, 1.113E-01, 1.194E-01,
                1.246E-01, 1.281E-01, 1.327E-01, 1.374E-01, 1.410E-01, 1.465E-01, 1.557E-01, 1.635E-01, 1.688E-01, 1.732E-01,
                1.818E-01, 1.963E-01, 2.050E-01, 2.106E-01, 2.187E-01, 2.287E-01, 2.386E-01, 2.468E-01, 2.542E-01, 2.701E-01,
                2.976E-01, 3.153E-01, 3.274E-01, 3.438E-01, 3.622E-01, 3.785E-01, 3.930E-01, 4.068E-01, 4.184E-01, 4.273E-01,
                4.385E-01, 4.538E-01, 4.611E-01, 4.633E-01, 4.663E-01, 4.701E-01, 4.733E-01, 4.756E-01, 4.772E-01, 4.785E-01,
                4.800E-01, 4.814E-01, 4.827E-01, 4.843E-01, 4.864E-01, 4.870E-01, 4.867E-01, 4.864E-01, 4.857E-01, 4.841E-01,
                4.821E-01, 4.804E-01, 4.786E-01, 4.764E-01, 4.738E-01, 4.710E-01, 4.677E-01, 4.641E-01, 4.604E-01, 4.570E-01,
                4.532E-01, 4.482E-01, 4.434E-01, 4.397E-01, 4.362E-01, 4.316E-01, 4.265E-01, 4.215E-01, 4.168E-01, 4.121E-01,
                4.072E-01, 4.017E-01, 3.963E-01, 3.915E-01, 3.868E-01, 3.816E-01, 3.760E-01, 3.701E-01, 3.640E-01, 3.581E-01,
                3.521E-01, 3.461E-01, 3.402E-01, 3.349E-01, 3.297E-01, 3.243E-01, 3.191E-01, 3.141E-01, 3.086E-01, 3.022E-01,
                2.957E-01, 2.897E-01, 2.840E-01, 2.782E-01, 2.724E-01, 2.672E-01, 2.621E-01, 2.566E-01, 2.506E-01, 2.444E-01,
                2.391E-01, 2.357E-01, 2.331E-01, 2.299E-01, 2.251E-01, 2.198E-01, 2.151E-01, 2.109E-01, 2.064E-01, 2.020E-01,
                1.981E-01, 1.944E-01, 1.904E-01, 1.868E-01, 1.841E-01, 1.818E-01, 1.790E-01, 1.752E-01, 1.715E-01, 1.687E-01,
                1.664E-01, 1.639E-01, 1.613E-01, 1.586E-01, 1.562E-01, 1.545E-01, 1.532E-01, 1.522E-01, 1.510E-01, 1.495E-01,
                1.475E-01, 1.457E-01, 1.447E-01, 1.442E-01, 1.438E-01, 1.433E-01, 1.426E-01, 1.418E-01, 1.412E-01, 1.410E-01,
                1.409E-01, 1.408E-01, 1.406E-01, 1.405E-01, 1.408E-01, 1.414E-01, 1.426E-01, 1.435E-01, 1.438E-01, 1.439E-01,
                1.443E-01, 1.456E-01, 1.475E-01, 1.498E-01, 1.519E-01, 1.534E-01, 1.547E-01, 1.561E-01, 1.580E-01, 1.604E-01,
                1.632E-01, 1.659E-01, 1.677E-01, 1.693E-01, 1.712E-01, 1.739E-01, 1.777E-01, 1.824E-01, 1.866E-01, 1.890E-01,
                1.906E-01, 1.929E-01, 1.967E-01, 2.005E-01, 2.031E-01, 2.051E-01, 2.079E-01, 2.123E-01, 2.166E-01, 2.196E-01,
                2.219E-01, 2.251E-01, 2.298E-01, 2.337E-01, 2.346E-01, 2.342E-01, 2.353E-01, 2.397E-01, 2.450E-01, 2.491E-01,
                2.528E-01, 2.578E-01, 2.650E-01, 2.719E-01, 2.765E-01, 2.811E-01, 2.891E-01, 3.023E-01, 3.164E-01, 3.271E-01,
                3.378E-01, 3.533E-01, 3.770E-01, 4.037E-01, 4.281E-01, 4.502E-01, 4.712E-01, 4.932E-01, 5.202E-01, 5.572E-01,
                6.052E-01, 6.520E-01, 6.863E-01, 7.159E-01, 7.535E-01, 8.064E-01, 8.597E-01, 8.981E-01, 9.253E-01, 9.493E-01,
                9.769E-01, 1.008E+00, 1.041E+00, 1.073E+00, 1.100E+00, 1.119E+00, 1.131E+00, 1.140E+00, 1.150E+00, 1.160E+00,
                1.170E+00, 1.181E+00, 1.190E+00, 1.194E+00, 1.196E+00, 1.197E+00, 1.200E+00, 1.203E+00, 1.205E+00, 1.206E+00,
                1.207E+00, 1.213E+00, 1.223E+00, 1.232E+00, 1.234E+00, 1.232E+00, 1.229E+00, 1.230E+00, 1.233E+00, 1.236E+00,
                1.239E+00, 1.241E+00, 1.244E+00, 1.248E+00, 1.252E+00, 1.256E+00, 1.258E+00, 1.260E+00, 1.262E+00, 1.265E+00,
                1.267E+00, 1.270E+00, 1.272E+00, 1.275E+00, 1.277E+00, 1.280E+00, 1.282E+00, 1.283E+00, 1.283E+00, 1.279E+00,
                1.272E+00, 1.266E+00, 1.267E+00, 1.271E+00, 1.273E+00, 1.271E+00, 1.265E+00, 1.260E+00, 1.258E+00, 1.258E+00,
                1.257E+00, 1.252E+00, 1.247E+00, 1.243E+00, 1.243E+00, 1.243E+00, 1.240E+00, 1.233E+00, 1.224E+00, 1.216E+00,
                1.214E+00, 1.214E+00, 1.213E+00, 1.210E+00, 1.205E+00, 1.200E+00, 1.199E+00, 1.198E+00, 1.197E+00, 1.194E+00,
                1.189E+00, 1.184E+00, 1.180E+00, 1.176E+00, 1.171E+00, 1.166E+00, 1.161E+00, 1.158E+00, 1.157E+00, 1.157E+00,
                1.155E+00, 1.152E+00, 1.148E+00, 1.142E+00, 1.138E+00, 1.133E+00, 1.130E+00, 1.126E+00, 1.123E+00, 1.120E+00,
                1.116E+00, 1.111E+00, 1.107E+00, 1.103E+00, 1.101E+00, 1.101E+00, 1.101E+00, 1.101E+00, 1.100E+00, 1.098E+00,
                1.094E+00, 1.089E+00, 1.085E+00, 1.084E+00, 1.083E+00, 1.083E+00, 1.082E+00, 1.081E+00, 1.080E+00, 1.079E+00,
                1.080E+00, 1.083E+00, 1.087E+00, 1.093E+00, 1.099E+00, 1.104E+00, 1.107E+00, 1.109E+00, 1.111E+00, 1.115E+00,
                1.121E+00, 1.129E+00, 1.137E+00, 1.147E+00, 1.156E+00, 1.164E+00, 1.170E+00, 1.175E+00, 1.181E+00, 1.188E+00,
                1.196E+00, 1.206E+00, 1.216E+00, 1.227E+00, 1.239E+00, 1.252E+00, 1.267E+00, 1.283E+00, 1.297E+00, 1.310E+00,
                1.323E+00, 1.336E+00, 1.351E+00, 1.370E+00, 1.392E+00, 1.416E+00, 1.440E+00, 1.465E+00, 1.489E+00, 1.511E+00,
                1.532E+00, 1.555E+00, 1.580E+00, 1.610E+00, 1.642E+00, 1.672E+00, 1.701E+00, 1.728E+00, 1.758E+00, 1.791E+00,
                1.831E+00, 1.872E+00, 1.911E+00, 1.943E+00, 1.974E+00, 2.007E+00, 2.047E+00, 2.098E+00, 2.153E+00, 2.203E+00,
                2.243E+00, 2.277E+00, 2.312E+00, 2.357E+00, 2.415E+00, 2.479E+00, 2.540E+00, 2.590E+00, 2.631E+00, 2.666E+00,
                2.701E+00, 2.738E+00, 2.780E+00, 2.829E+00, 2.889E+00, 2.960E+00, 3.033E+00, 3.097E+00, 3.146E+00, 3.181E+00,
                3.226E+00, 3.267E+00, 3.319E+00, 3.363E+00, 3.412E+00, 3.449E+00, 3.504E+00, 3.544E+00, 3.600E+00, 3.648E+00,
                3.701E+00, 3.752E+00, 3.802E+00, 3.871E+00, 3.927E+00, 3.985E+00, 4.064E+00, 4.125E+00, 4.216E+00, 4.302E+00,
                4.389E+00, 4.504E+00, 4.630E+00, 4.737E+00, 4.904E+00, 5.092E+00, 5.260E+00, 5.479E+00, 5.720E+00, 6.006E+00,
                6.242E+00, 6.580E+00, 6.927E+00, 7.313E+00, 7.633E+00, 8.089E+00, 8.545E+00, 9.030E+00, 9.591E+00, 1.002E+01,
                1.063E+01, 1.122E+01, 1.184E+01, 1.245E+01, 1.316E+01, 1.369E+01, 1.434E+01, 1.509E+01, 1.578E+01, 1.646E+01,
                1.714E+01, 1.781E+01, 1.854E+01, 1.919E+01, 1.980E+01, 2.029E+01, 2.089E+01, 2.146E+01, 2.202E+01, 2.260E+01,
                2.313E+01, 2.360E+01, 2.407E+01, 2.450E+01, 2.493E+01, 2.533E+01, 2.571E+01, 2.606E+01, 2.641E+01, 2.673E+01,
                2.701E+01, 2.729E+01, 2.756E+01, 2.782E+01, 2.806E+01, 2.835E+01, 2.856E+01, 2.875E+01, 2.892E+01, 2.908E+01,
                2.926E+01, 2.940E+01, 2.956E+01, 2.966E+01, 2.982E+01, 2.993E+01, 3.003E+01, 3.014E+01, 3.023E+01, 3.029E+01,
                3.036E+01, 3.042E+01, 3.046E+01, 3.049E+01, 3.052E+01, 3.053E+01, 3.055E+01, 3.056E+01, 3.056E+01, 3.055E+01,
                3.054E+01, 3.051E+01, 3.049E+01, 3.045E+01, 3.041E+01, 3.035E+01, 3.029E+01, 3.023E+01, 3.014E+01, 3.006E+01,
                2.998E+01, 2.983E+01, 2.971E+01, 2.957E+01, 2.936E+01, 2.917E+01, 2.899E+01, 2.872E+01, 2.851E+01, 2.829E+01,
                2.800E+01, 2.777E+01, 2.754E+01, 2.722E+01, 2.699E+01, 2.664E+01, 2.638E+01, 2.611E+01, 2.581E+01, 2.555E+01,
                2.522E+01, 2.497E+01, 2.468E+01, 2.443E+01, 2.413E+01, 2.388E+01, 2.364E+01, 2.332E+01, 2.307E+01, 2.274E+01,
                2.250E+01, 2.218E+01, 2.193E+01, 2.163E+01, 2.139E+01, 2.107E+01, 2.082E+01, 2.052E+01, 2.025E+01, 2.001E+01,
                1.972E+01, 1.951E+01, 1.924E+01, 1.900E+01, 1.874E+01, 1.847E+01, 1.827E+01, 1.802E+01, 1.784E+01, 1.758E+01,
                1.734E+01, 1.712E+01, 1.688E+01, 1.671E+01, 1.647E+01, 1.623E+01, 1.606E+01, 1.583E+01, 1.562E+01, 1.545E+01,
                1.525E+01, 1.504E+01, 1.489E+01, 1.468E+01, 1.447E+01, 1.432E+01, 1.413E+01, 1.395E+01, 1.381E+01, 1.364E+01,
                1.348E+01, 1.329E+01, 1.316E+01, 1.298E+01, 1.282E+01, 1.265E+01, 1.254E+01, 1.238E+01, 1.223E+01, 1.206E+01,
                1.193E+01, 1.181E+01, 1.166E+01, 1.152E+01, 1.137E+01, 1.126E+01, 1.114E+01, 1.100E+01, 1.088E+01, 1.075E+01,
                1.064E+01, 1.054E+01, 1.044E+01, 1.032E+01, 1.022E+01, 1.011E+01, 1.001E+01, 9.912E+00, 9.839E+00, 9.754E+00,
                9.660E+00, 9.563E+00, 9.477E+00, 9.383E+00, 9.305E+00, 9.202E+00, 9.133E+00, 9.047E+00, 8.977E+00, 8.898E+00,
                8.820E+00, 8.742E+00, 8.665E+00, 8.588E+00, 8.509E+00, 8.448E+00, 8.364E+00, 8.295E+00, 8.234E+00, 8.157E+00,
                8.104E+00, 8.036E+00, 7.959E+00, 7.890E+00, 7.834E+00, 7.773E+00, 7.712E+00, 7.654E+00, 7.609E+00, 7.548E+00,
                7.495E+00, 7.432E+00, 7.374E+00, 7.315E+00, 7.252E+00, 7.203E+00, 7.164E+00, 7.124E+00, 7.084E+00, 7.041E+00,
                6.987E+00, 6.943E+00, 6.910E+00, 6.865E+00, 6.828E+00, 6.776E+00, 6.742E+00, 6.714E+00, 6.695E+00, 6.654E+00,
                6.630E+00, 6.599E+00, 6.567E+00, 6.526E+00, 6.501E+00, 6.474E+00, 6.449E+00, 6.420E+00, 6.401E+00, 6.363E+00,
                6.345E+00, 6.309E+00, 6.282E+00, 6.250E+00, 6.214E+00, 6.186E+00, 6.163E+00, 6.130E+00, 6.121E+00, 6.091E+00,
                6.076E+00, 6.053E+00, 6.048E+00, 6.016E+00, 6.005E+00, 5.982E+00, 5.973E+00, 5.947E+00, 5.940E+00, 5.919E+00,
                5.911E+00, 5.887E+00, 5.875E+00, 5.846E+00, 5.826E+00, 5.798E+00, 5.787E+00, 5.751E+00, 5.746E+00, 5.718E+00,
                5.705E+00, 5.685E+00, 5.684E+00, 5.657E+00, 5.658E+00, 5.644E+00, 5.648E+00, 5.626E+00, 5.626E+00, 5.619E+00,
                5.618E+00, 5.603E+00, 5.614E+00, 5.597E+00, 5.603E+00, 5.582E+00, 5.584E+00, 5.564E+00, 5.563E+00, 5.547E+00,
                5.545E+00, 5.536E+00, 5.542E+00, 5.529E+00, 5.532E+00, 5.525E+00, 5.533E+00, 5.528E+00, 5.529E+00, 5.516E+00,
                5.524E+00, 5.516E+00, 5.526E+00, 5.520E+00, 5.520E+00, 5.516E+00, 5.522E+00, 5.511E+00, 5.527E+00, 5.511E+00,
                5.519E+00, 5.515E+00, 5.520E+00, 5.510E+00, 5.518E+00, 5.523E+00, 5.538E+00, 5.535E+00, 5.544E+00, 5.557E+00,
                5.571E+00, 5.583E+00, 5.606E+00, 5.607E+00, 5.629E+00, 5.636E+00, 5.664E+00, 5.670E+00, 5.693E+00, 5.702E+00,
                5.733E+00, 5.752E+00, 5.766E+00, 5.776E+00, 5.797E+00, 5.811E+00, 5.829E+00, 5.842E+00, 5.877E+00, 5.891E+00,
                5.930E+00, 5.945E+00, 5.972E+00, 5.999E+00, 6.025E+00, 6.051E+00, 6.087E+00, 6.096E+00, 6.136E+00, 6.166E+00,
                6.198E+00, 6.219E+00, 6.256E+00, 6.284E+00, 6.335E+00, 6.369E+00, 6.392E+00, 6.445E+00, 6.493E+00, 6.517E+00,
                6.571E+00, 6.617E+00, 6.658E+00, 6.689E+00, 6.748E+00, 6.796E+00, 6.842E+00, 6.897E+00, 6.955E+00, 7.003E+00,
                7.054E+00, 7.111E+00, 7.179E+00, 7.235E+00, 7.274E+00, 7.339E+00, 7.414E+00, 7.481E+00, 7.536E+00, 7.594E+00,
                7.669E+00, 7.734E+00, 7.776E+00, 7.833E+00, 7.893E+00, 7.952E+00, 8.000E+00, 8.045E+00, 8.103E+00, 8.155E+00,
                8.205E+00, 8.241E+00, 8.264E+00, 8.321E+00, 8.352E+00, 8.394E+00, 8.430E+00, 8.448E+00, 8.477E+00, 8.512E+00,
                8.535E+00, 8.562E+00, 8.593E+00, 8.618E+00, 8.640E+00, 8.670E+00, 8.689E+00, 8.720E+00, 8.738E+00, 8.755E+00,
                8.777E+00, 8.778E+00, 8.778E+00, 8.794E+00, 8.805E+00, 8.807E+00, 8.809E+00, 8.811E+00, 8.799E+00, 8.795E+00,
                8.789E+00, 8.779E+00, 8.767E+00, 8.754E+00, 8.750E+00, 8.738E+00, 8.739E+00, 8.735E+00, 8.744E+00, 8.753E+00,
                8.755E+00, 8.780E+00, 8.787E+00, 8.790E+00, 8.798E+00, 8.794E+00, 8.811E+00, 8.820E+00, 8.836E+00, 8.845E+00,
                8.854E+00, 8.858E+00, 8.868E+00, 8.869E+00, 8.884E+00, 8.888E+00, 8.900E+00, 8.922E+00, 8.951E+00, 8.973E+00,
                9.010E+00, 9.034E+00, 9.110E+00, 9.146E+00, 9.195E+00, 9.259E+00, 9.315E+00, 9.380E+00, 9.457E+00, 9.535E+00,
                9.633E+00, 9.723E+00, 9.824E+00, 9.935E+00, 1.005E+01, 1.018E+01, 1.031E+01, 1.042E+01, 1.059E+01, 1.075E+01,
                1.094E+01, 1.110E+01, 1.139E+01, 1.160E+01, 1.184E+01, 1.208E+01, 1.235E+01, 1.266E+01, 1.301E+01, 1.334E+01,
                1.375E+01, 1.412E+01, 1.478E+01, 1.529E+01, 1.586E+01, 1.641E+01, 1.709E+01, 1.774E+01, 1.853E+01, 1.925E+01,
                2.051E+01, 2.148E+01, 2.250E+01, 2.367E+01, 2.483E+01, 2.622E+01, 2.751E+01, 2.972E+01, 3.144E+01, 3.317E+01,
                3.504E+01, 3.725E+01, 3.927E+01, 4.269E+01, 4.530E+01, 4.789E+01, 5.060E+01, 5.360E+01, 5.761E+01, 6.088E+01,
                6.401E+01, 6.720E+01, 7.059E+01, 7.497E+01, 7.841E+01, 8.157E+01, 8.469E+01, 8.752E+01, 9.189E+01, 9.456E+01,
                9.722E+01, 9.995E+01, 1.033E+02, 1.057E+02, 1.078E+02, 1.097E+02, 1.123E+02, 1.140E+02, 1.157E+02, 1.171E+02,
                1.190E+02, 1.203E+02, 1.215E+02, 1.226E+02, 1.240E+02, 1.248E+02, 1.257E+02, 1.265E+02, 1.275E+02, 1.281E+02,
                1.286E+02, 1.292E+02, 1.296E+02, 1.299E+02, 1.303E+02, 1.304E+02, 1.306E+02, 1.306E+02, 1.306E+02, 1.305E+02,
                1.304E+02, 1.301E+02, 1.299E+02, 1.296E+02, 1.291E+02, 1.287E+02, 1.282E+02, 1.275E+02, 1.270E+02, 1.264E+02,
                1.256E+02, 1.249E+02, 1.242E+02, 1.232E+02, 1.224E+02, 1.216E+02, 1.206E+02, 1.197E+02, 1.190E+02, 1.178E+02,
                1.170E+02, 1.157E+02, 1.149E+02, 1.140E+02, 1.128E+02, 1.118E+02, 1.110E+02, 1.097E+02, 1.088E+02, 1.076E+02,
                1.066E+02, 1.058E+02, 1.044E+02, 1.036E+02, 1.023E+02, 1.014E+02, 1.005E+02, 9.928E+01, 9.831E+01, 9.711E+01,
                9.631E+01, 9.488E+01, 9.412E+01, 9.341E+01, 9.206E+01, 9.121E+01, 9.009E+01, 8.929E+01, 8.804E+01, 8.725E+01,
                8.611E+01, 8.532E+01, 8.460E+01, 8.336E+01, 8.262E+01, 8.151E+01, 8.076E+01, 7.973E+01, 7.904E+01, 7.800E+01,
                7.723E+01, 7.628E+01, 7.557E+01, 7.463E+01, 7.392E+01, 7.298E+01, 7.234E+01, 7.141E+01, 7.082E+01, 6.986E+01,
                6.924E+01, 6.865E+01, 6.779E+01, 6.688E+01, 6.634E+01, 6.548E+01, 6.490E+01, 6.412E+01, 6.358E+01, 6.281E+01,
                6.232E+01, 6.156E+01, 6.105E+01, 6.029E+01, 5.980E+01, 5.907E+01, 5.857E+01, 5.788E+01, 5.746E+01, 5.680E+01,
                5.632E+01, 5.566E+01, 5.503E+01, 5.463E+01, 5.398E+01, 5.356E+01, 5.294E+01, 5.256E+01, 5.197E+01, 5.138E+01,
                5.098E+01, 5.047E+01, 5.006E+01, 4.951E+01, 4.915E+01, 4.860E+01, 4.806E+01, 4.773E+01, 4.718E+01, 4.685E+01,
                4.635E+01, 4.584E+01, 4.553E+01, 4.503E+01, 4.473E+01, 4.426E+01, 4.379E+01, 4.348E+01, 4.302E+01, 4.273E+01,
                4.228E+01, 4.186E+01, 4.155E+01, 4.115E+01, 4.072E+01, 4.046E+01, 4.002E+01, 3.975E+01, 3.934E+01, 3.894E+01,
                3.868E+01, 3.827E+01, 3.790E+01, 3.762E+01, 3.726E+01, 3.687E+01, 3.664E+01, 3.628E+01, 3.592E+01, 3.568E+01,
                3.536E+01, 3.499E+01, 3.479E+01, 3.447E+01, 3.413E+01, 3.392E+01, 3.363E+01, 3.329E+01, 3.309E+01, 3.280E+01,
                3.251E+01, 3.231E+01, 3.200E+01, 3.172E+01, 3.154E+01, 3.127E+01, 3.097E+01, 3.071E+01, 3.052E+01, 3.025E+01,
                2.999E+01, 2.980E+01, 2.958E+01, 2.929E+01, 2.906E+01, 2.888E+01, 2.865E+01, 2.840E+01, 2.822E+01, 2.799E+01,
                2.776E+01, 2.751E+01, 2.737E+01, 2.713E+01, 2.692E+01, 2.671E+01, 2.657E+01, 2.637E+01, 2.617E+01, 2.597E+01,
                2.584E+01, 2.565E+01, 2.547E+01, 2.528E+01, 2.518E+01, 2.501E+01, 2.485E+01, 2.466E+01, 2.455E+01, 2.438E+01,
                2.420E+01, 2.401E+01, 2.386E+01, 2.374E+01, 2.358E+01, 2.342E+01, 2.328E+01, 2.318E+01, 2.304E+01, 2.289E+01,
                2.275E+01, 2.262E+01, 2.252E+01, 2.239E+01, 2.227E+01, 2.214E+01, 2.202E+01, 2.194E+01, 2.183E+01, 2.172E+01,
                2.162E+01, 2.150E+01, 2.140E+01, 2.133E+01, 2.123E+01, 2.112E+01, 2.102E+01, 2.091E+01, 2.085E+01, 2.077E+01,
                2.067E+01, 2.058E+01, 2.049E+01, 2.040E+01, 2.033E+01, 2.027E+01, 2.018E+01, 2.010E+01, 2.002E+01, 1.995E+01,
                1.987E+01, 1.983E+01, 1.976E+01, 1.969E+01, 1.963E+01, 1.958E+01, 1.952E+01, 1.946E+01, 1.942E+01, 1.938E+01,
                1.933E+01, 1.928E+01, 1.923E+01, 1.918E+01, 1.913E+01, 1.909E+01, 1.904E+01, 1.900E+01, 1.896E+01, 1.889E+01,
                1.884E+01, 1.880E+01, 1.874E+01, 1.870E+01, 1.866E+01, 1.860E+01, 1.856E+01, 1.852E+01, 1.849E+01, 1.845E+01,
                1.843E+01, 1.839E+01, 1.837E+01, 1.837E+01, 1.838E+01, 1.837E+01, 1.836E+01, 1.835E+01, 1.835E+01, 1.835E+01,
                1.834E+01, 1.833E+01, 1.833E+01, 1.833E+01, 1.834E+01, 1.833E+01, 1.834E+01, 1.834E+01, 1.832E+01, 1.831E+01,
                1.829E+01, 1.828E+01, 1.828E+01, 1.829E+01, 1.829E+01, 1.830E+01, 1.832E+01, 1.835E+01, 1.836E+01, 1.837E+01,
                1.837E+01, 1.838E+01, 1.837E+01, 1.840E+01, 1.842E+01, 1.843E+01, 1.846E+01, 1.849E+01, 1.851E+01, 1.854E+01,
                1.857E+01, 1.858E+01, 1.860E+01, 1.864E+01, 1.865E+01, 1.867E+01, 1.870E+01, 1.875E+01, 1.879E+01, 1.883E+01,
                1.888E+01, 1.893E+01, 1.897E+01, 1.903E+01, 1.908E+01, 1.913E+01, 1.919E+01, 1.924E+01, 1.929E+01, 1.934E+01,
                1.940E+01, 1.946E+01, 1.951E+01, 1.961E+01, 1.966E+01, 1.973E+01, 1.980E+01, 1.985E+01, 1.991E+01, 1.997E+01,
                2.004E+01, 2.013E+01, 2.020E+01, 2.027E+01, 2.038E+01, 2.046E+01, 2.054E+01, 2.062E+01, 2.071E+01, 2.079E+01,
                2.087E+01, 2.094E+01, 2.103E+01, 2.111E+01, 2.126E+01, 2.135E+01, 2.145E+01, 2.153E+01, 2.164E+01, 2.174E+01,
                2.183E+01, 2.192E+01, 2.202E+01, 2.212E+01, 2.223E+01, 2.234E+01, 2.245E+01, 2.264E+01, 2.276E+01, 2.287E+01,
                2.301E+01, 2.313E+01, 2.327E+01, 2.338E+01, 2.351E+01, 2.363E+01, 2.377E+01, 2.385E+01, 2.409E+01, 2.418E+01,
                2.433E+01, 2.444E+01, 2.459E+01, 2.470E+01, 2.485E+01, 2.495E+01, 2.523E+01, 2.534E+01, 2.549E+01, 2.564E+01,
                2.579E+01, 2.592E+01, 2.611E+01, 2.623E+01, 2.653E+01, 2.664E+01, 2.681E+01, 2.695E+01, 2.712E+01, 2.727E+01,
                2.744E+01, 2.756E+01, 2.789E+01, 2.802E+01, 2.819E+01, 2.838E+01, 2.855E+01, 2.869E+01, 2.903E+01, 2.916E+01,
                2.934E+01, 2.951E+01, 2.969E+01, 2.988E+01, 3.002E+01, 3.038E+01, 3.054E+01, 3.073E+01, 3.092E+01, 3.107E+01,
                3.145E+01, 3.160E+01, 3.180E+01, 3.199E+01, 3.219E+01, 3.238E+01, 3.272E+01, 3.290E+01, 3.311E+01, 3.331E+01,
                3.348E+01, 3.388E+01, 3.404E+01, 3.426E+01, 3.447E+01, 3.468E+01, 3.486E+01, 3.528E+01, 3.547E+01, 3.570E+01,
                3.592E+01, 3.610E+01, 3.656E+01, 3.675E+01, 3.697E+01, 3.716E+01, 3.761E+01, 3.777E+01, 3.801E+01, 3.827E+01,
                3.848E+01, 3.892E+01, 3.913E+01, 3.938E+01, 3.957E+01, 4.007E+01, 4.024E+01, 4.050E+01, 4.078E+01, 4.096E+01,
                4.147E+01, 4.167E+01, 4.196E+01, 4.220E+01, 4.268E+01, 4.293E+01, 4.319E+01, 4.342E+01, 4.388E+01, 4.413E+01,
                4.439E+01, 4.464E+01, 4.513E+01, 4.538E+01, 4.565E+01, 4.590E+01, 4.638E+01, 4.663E+01, 4.690E+01, 4.714E+01,
                4.764E+01, 4.787E+01, 4.817E+01, 4.836E+01, 4.894E+01, 4.917E+01, 4.940E+01, 4.997E+01, 5.021E+01, 5.050E+01,
                5.078E+01, 5.131E+01, 5.159E+01, 5.191E+01, 5.246E+01, 5.275E+01, 5.310E+01, 5.339E+01, 5.401E+01, 5.429E+01,
                5.462E+01, 5.523E+01, 5.555E+01, 5.588E+01, 5.618E+01, 5.686E+01, 5.713E+01, 5.746E+01, 5.808E+01, 5.841E+01,
                5.878E+01, 5.946E+01, 5.976E+01, 6.009E+01, 6.039E+01, 6.107E+01, 6.146E+01, 6.180E+01, 6.250E+01, 6.286E+01,
                6.316E+01, 6.392E+01, 6.427E+01, 6.462E+01, 6.539E+01, 6.574E+01, 6.609E+01, 6.685E+01, 6.725E+01, 6.759E+01,
                6.842E+01, 6.881E+01, 6.918E+01, 7.009E+01, 7.046E+01, 7.084E+01, 7.174E+01, 7.212E+01, 7.249E+01, 7.340E+01,
                7.381E+01, 7.423E+01, 7.514E+01, 7.554E+01, 7.591E+01, 7.675E+01, 7.718E+01, 7.801E+01, 7.839E+01, 7.880E+01,
                7.970E+01, 8.005E+01, 8.046E+01, 8.136E+01, 8.173E+01, 8.215E+01, 8.295E+01, 8.338E+01, 8.423E+01, 8.474E+01,
                8.510E+01, 8.584E+01, 8.617E+01, 8.637E+01, 8.708E+01, 8.762E+01, 8.884E+01, 8.904E+01, 8.945E+01, 9.055E+01,
                9.089E+01, 9.134E+01, 9.204E+01, 9.244E+01, 9.308E+01, 9.333E+01, 9.358E+01, 9.416E+01, 9.448E+01, 9.499E+01,
                9.530E+01])

P4_k_Cm = np.array([1.097E+02, 1.037E+02, 9.798E+01, 9.244E+01, 8.713E+01, 8.231E+01, 7.806E+01, 7.404E+01, 7.013E+01, 6.654E+01,
                6.300E+01, 5.954E+01, 5.616E+01, 5.301E+01, 5.001E+01, 4.723E+01, 4.463E+01, 4.220E+01, 3.996E+01, 3.780E+01,
                3.567E+01, 3.362E+01, 3.170E+01, 2.993E+01, 2.832E+01, 2.679E+01, 2.535E+01, 2.402E+01, 2.276E+01, 2.150E+01,
                2.024E+01, 1.901E+01, 1.785E+01, 1.676E+01, 1.575E+01, 1.481E+01, 1.392E+01, 1.312E+01, 1.233E+01, 1.161E+01,
                1.096E+01, 1.041E+01, 9.924E+00, 9.410E+00, 8.947E+00, 8.508E+00, 8.087E+00, 7.640E+00, 7.269E+00, 6.939E+00,
                6.660E+00, 6.422E+00, 6.222E+00, 6.010E+00, 5.782E+00, 5.573E+00, 5.370E+00, 5.173E+00, 4.946E+00, 4.761E+00,
                4.575E+00, 4.419E+00, 4.259E+00, 4.117E+00, 4.006E+00, 3.945E+00, 3.853E+00, 3.784E+00, 3.671E+00, 3.554E+00,
                3.462E+00, 3.364E+00, 3.282E+00, 3.184E+00, 3.102E+00, 3.051E+00, 2.983E+00, 2.947E+00, 2.913E+00, 2.869E+00,
                2.803E+00, 2.777E+00, 2.751E+00, 2.726E+00, 2.702E+00, 2.679E+00, 2.656E+00, 2.634E+00, 2.613E+00, 2.593E+00,
                2.573E+00, 2.554E+00, 2.536E+00, 2.519E+00, 2.502E+00, 2.486E+00, 2.471E+00, 2.457E+00, 2.443E+00, 2.430E+00,
                2.417E+00, 2.405E+00, 2.394E+00, 2.384E+00, 2.374E+00, 2.365E+00, 2.356E+00, 2.348E+00, 2.341E+00, 2.334E+00,
                2.328E+00, 2.323E+00, 2.318E+00, 2.314E+00, 2.310E+00, 2.307E+00, 2.304E+00, 2.303E+00, 2.301E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00, 2.300E+00,
                2.300E+00, 2.300E+00, 2.301E+00, 2.301E+00, 2.302E+00, 2.303E+00, 2.305E+00, 2.306E+00, 2.308E+00, 2.310E+00,
                2.312E+00, 2.315E+00, 2.318E+00, 2.320E+00, 2.323E+00, 2.327E+00, 2.330E+00, 2.334E+00, 2.338E+00, 2.342E+00,
                2.346E+00, 2.350E+00, 2.354E+00, 2.359E+00, 2.364E+00, 2.369E+00, 2.374E+00, 2.379E+00, 2.384E+00, 2.389E+00,
                2.395E+00, 2.400E+00, 2.406E+00, 2.412E+00, 2.418E+00, 2.424E+00, 2.430E+00, 2.436E+00, 2.442E+00, 2.448E+00,
                2.454E+00, 2.461E+00, 2.467E+00, 2.473E+00, 2.480E+00, 2.486E+00, 2.493E+00, 2.499E+00, 2.506E+00, 2.512E+00,
                2.519E+00, 2.525E+00, 2.532E+00, 2.538E+00, 2.545E+00, 2.551E+00, 2.558E+00, 2.564E+00, 2.570E+00, 2.577E+00,
                2.583E+00, 2.589E+00, 2.595E+00, 2.601E+00, 2.607E+00, 2.613E+00, 2.619E+00, 2.625E+00, 2.631E+00, 2.636E+00,
                2.642E+00, 2.647E+00, 2.652E+00, 2.657E+00, 2.662E+00, 2.667E+00, 2.672E+00, 2.677E+00, 2.681E+00, 2.685E+00,
                2.689E+00, 2.693E+00, 2.697E+00, 2.701E+00, 2.704E+00, 2.708E+00, 2.711E+00, 2.714E+00, 2.716E+00, 2.719E+00,
                2.721E+00, 2.723E+00, 2.725E+00, 2.726E+00, 2.728E+00, 2.729E+00, 2.730E+00, 2.730E+00, 2.731E+00, 2.731E+00,
                2.721E+00, 2.736E+00, 2.728E+00, 2.719E+00, 2.712E+00, 2.698E+00, 2.702E+00, 2.691E+00, 2.688E+00, 2.686E+00,
                2.682E+00, 2.676E+00, 2.675E+00, 2.677E+00, 2.670E+00, 2.671E+00, 2.668E+00, 2.670E+00, 2.674E+00, 2.674E+00,
                2.683E+00, 2.674E+00, 2.675E+00, 2.682E+00, 2.683E+00, 2.665E+00, 2.661E+00, 2.668E+00, 2.670E+00, 2.674E+00,
                2.664E+00, 2.661E+00, 2.665E+00, 2.668E+00, 2.681E+00, 2.686E+00, 2.684E+00, 2.697E+00, 2.712E+00, 2.720E+00,
                2.717E+00, 2.726E+00, 2.744E+00, 2.743E+00, 2.751E+00, 2.763E+00, 2.778E+00, 2.793E+00, 2.818E+00, 2.835E+00,
                2.865E+00, 2.879E+00, 2.899E+00, 2.918E+00, 2.936E+00, 2.953E+00, 2.966E+00, 2.977E+00, 2.981E+00, 2.942E+00,
                2.888E+00, 2.864E+00, 2.877E+00, 2.886E+00, 2.888E+00, 2.891E+00, 2.899E+00, 2.887E+00, 2.884E+00, 2.900E+00,
                2.929E+00, 2.969E+00, 3.014E+00, 3.053E+00, 3.075E+00, 3.111E+00, 3.128E+00, 3.130E+00, 3.103E+00, 3.051E+00,
                2.980E+00, 2.941E+00, 2.920E+00, 2.931E+00, 2.950E+00, 2.979E+00, 3.025E+00, 3.048E+00, 3.066E+00, 3.087E+00,
                3.099E+00, 3.090E+00, 3.088E+00, 3.081E+00, 3.086E+00, 3.071E+00, 3.065E+00, 3.069E+00, 3.067E+00, 3.085E+00,
                3.094E+00, 3.110E+00, 3.136E+00, 3.149E+00, 3.158E+00, 3.191E+00, 3.230E+00, 3.266E+00, 3.298E+00, 3.356E+00,
                3.419E+00, 3.476E+00, 3.534E+00, 3.584E+00, 3.632E+00, 3.708E+00, 3.775E+00, 3.847E+00, 3.931E+00, 3.987E+00,
                4.071E+00, 4.156E+00, 4.242E+00, 4.320E+00, 4.395E+00, 4.480E+00, 4.561E+00, 4.638E+00, 4.708E+00, 4.782E+00,
                4.846E+00, 4.906E+00, 4.974E+00, 5.026E+00, 5.071E+00, 5.131E+00, 5.179E+00, 5.220E+00, 5.271E+00, 5.322E+00,
                5.358E+00, 5.403E+00, 5.441E+00, 5.460E+00, 5.481E+00, 5.500E+00, 5.523E+00, 5.548E+00, 5.560E+00, 5.575E+00,
                5.582E+00, 5.597E+00, 5.611E+00, 5.639E+00, 5.653E+00, 5.675E+00, 5.682E+00, 5.685E+00, 5.680E+00, 5.689E+00,
                5.711E+00, 5.723E+00, 5.715E+00, 5.716E+00, 5.732E+00, 5.741E+00, 5.743E+00, 5.752E+00, 5.745E+00, 5.744E+00,
                5.757E+00, 5.766E+00, 5.781E+00, 5.787E+00, 5.798E+00, 5.810E+00, 5.808E+00, 5.815E+00, 5.825E+00, 5.824E+00,
                5.827E+00, 5.854E+00, 5.878E+00, 5.900E+00, 5.908E+00, 5.922E+00, 5.940E+00, 5.962E+00, 5.963E+00, 5.966E+00,
                5.982E+00, 5.990E+00, 5.994E+00, 6.016E+00, 6.014E+00, 6.025E+00, 6.008E+00, 6.022E+00, 6.021E+00, 6.027E+00,
                6.027E+00, 6.035E+00, 6.025E+00, 6.009E+00, 5.990E+00, 5.987E+00, 5.984E+00, 5.971E+00, 5.971E+00, 5.973E+00,
                5.951E+00, 5.952E+00, 5.939E+00, 5.933E+00, 5.931E+00, 5.925E+00, 5.909E+00, 5.897E+00, 5.884E+00, 5.881E+00,
                5.876E+00, 5.856E+00, 5.843E+00, 5.830E+00, 5.818E+00, 5.807E+00, 5.799E+00, 5.792E+00, 5.776E+00, 5.783E+00,
                5.776E+00, 5.767E+00, 5.762E+00, 5.769E+00, 5.756E+00, 5.762E+00, 5.737E+00, 5.740E+00, 5.757E+00, 5.756E+00,
                5.751E+00, 5.754E+00, 5.751E+00, 5.750E+00, 5.744E+00, 5.744E+00, 5.754E+00, 5.744E+00, 5.735E+00, 5.740E+00,
                5.732E+00, 5.728E+00, 5.731E+00, 5.724E+00, 5.724E+00, 5.715E+00, 5.697E+00, 5.693E+00, 5.703E+00, 5.700E+00,
                5.713E+00, 5.728E+00, 5.731E+00, 5.735E+00, 5.743E+00, 5.754E+00, 5.753E+00, 5.744E+00, 5.746E+00, 5.746E+00,
                5.746E+00, 5.750E+00, 5.749E+00, 5.743E+00, 5.740E+00, 5.747E+00, 5.739E+00, 5.755E+00, 5.749E+00, 5.753E+00,
                5.745E+00, 5.732E+00, 5.735E+00, 5.724E+00, 5.725E+00, 5.712E+00, 5.702E+00, 5.700E+00, 5.700E+00, 5.686E+00,
                5.685E+00, 5.672E+00, 5.659E+00, 5.627E+00, 5.613E+00, 5.590E+00, 5.591E+00, 5.563E+00, 5.552E+00, 5.525E+00,
                5.517E+00, 5.506E+00, 5.494E+00, 5.459E+00, 5.450E+00, 5.438E+00, 5.428E+00, 5.407E+00, 5.391E+00, 5.382E+00,
                5.376E+00, 5.358E+00, 5.347E+00, 5.333E+00, 5.319E+00, 5.301E+00, 5.292E+00, 5.284E+00, 5.274E+00, 5.258E+00,
                5.253E+00, 5.249E+00, 5.233E+00, 5.222E+00, 5.211E+00, 5.204E+00, 5.210E+00, 5.200E+00, 5.193E+00, 5.186E+00,
                5.177E+00, 5.175E+00, 5.178E+00, 5.173E+00, 5.152E+00, 5.135E+00, 5.139E+00, 5.128E+00, 5.121E+00, 5.114E+00,
                5.126E+00, 5.107E+00, 5.104E+00, 5.100E+00, 5.109E+00, 5.114E+00, 5.112E+00, 5.128E+00, 5.137E+00, 5.131E+00,
                5.152E+00, 5.175E+00, 5.194E+00, 5.200E+00, 5.244E+00, 5.257E+00, 5.273E+00, 5.289E+00, 5.335E+00, 5.366E+00,
                5.389E+00, 5.427E+00, 5.453E+00, 5.490E+00, 5.522E+00, 5.562E+00, 5.605E+00, 5.652E+00, 5.698E+00, 5.744E+00,
                5.743E+00, 5.642E+00, 5.689E+00, 5.722E+00, 5.755E+00, 5.798E+00, 5.848E+00, 5.875E+00, 5.918E+00, 5.971E+00,
                6.022E+00, 6.061E+00, 6.116E+00, 6.173E+00, 6.214E+00, 6.266E+00, 6.319E+00, 6.382E+00, 6.426E+00, 6.486E+00,
                6.542E+00, 6.579E+00, 6.616E+00, 6.666E+00, 6.728E+00, 6.771E+00, 6.807E+00, 6.858E+00, 6.908E+00, 6.959E+00,
                7.006E+00, 7.052E+00, 7.093E+00, 7.136E+00, 7.164E+00, 7.199E+00, 7.232E+00, 7.266E+00, 7.315E+00, 7.340E+00,
                7.361E+00, 7.399E+00, 7.440E+00, 7.473E+00, 7.505E+00, 7.525E+00, 7.557E+00, 7.579E+00, 7.604E+00, 7.633E+00,
                7.653E+00, 7.674E+00, 7.691E+00, 7.699E+00, 7.708E+00, 7.721E+00, 7.730E+00, 7.729E+00, 7.712E+00, 7.702E+00,
                7.695E+00, 7.670E+00, 7.644E+00, 7.618E+00, 7.585E+00, 7.555E+00, 7.517E+00, 7.479E+00, 7.451E+00, 7.435E+00,
                7.408E+00, 7.379E+00, 7.363E+00, 7.347E+00, 7.332E+00, 7.332E+00, 7.332E+00, 7.304E+00, 7.295E+00, 7.296E+00,
                7.291E+00, 7.292E+00, 7.292E+00, 7.281E+00, 7.283E+00, 7.264E+00, 7.250E+00, 7.240E+00, 7.228E+00, 7.210E+00,
                7.186E+00, 7.164E+00, 7.143E+00, 7.114E+00, 7.101E+00, 7.069E+00, 7.038E+00, 7.003E+00, 6.974E+00, 6.928E+00,
                6.889E+00, 6.839E+00, 6.793E+00, 6.764E+00, 6.729E+00, 6.694E+00, 6.662E+00, 6.613E+00, 6.572E+00, 6.546E+00,
                6.522E+00, 6.507E+00, 6.482E+00, 6.484E+00, 6.479E+00, 6.494E+00, 6.496E+00, 6.491E+00, 6.461E+00, 6.440E+00,
                6.430E+00, 6.413E+00, 6.421E+00, 6.399E+00, 6.379E+00, 6.365E+00, 6.372E+00, 6.346E+00, 6.321E+00, 6.310E+00,
                6.314E+00, 6.282E+00, 6.277E+00, 6.270E+00, 6.258E+00, 6.242E+00, 6.234E+00, 6.221E+00, 6.231E+00, 6.221E+00,
                6.205E+00, 6.193E+00, 6.192E+00, 6.179E+00, 6.159E+00, 6.143E+00, 6.143E+00, 6.120E+00, 6.098E+00, 6.087E+00,
                6.063E+00, 6.056E+00, 6.053E+00, 6.040E+00, 6.044E+00, 6.007E+00, 5.996E+00, 5.994E+00, 5.997E+00, 5.975E+00,
                5.954E+00, 5.946E+00, 5.927E+00, 5.914E+00, 5.890E+00, 5.873E+00, 5.832E+00, 5.794E+00, 5.768E+00, 5.728E+00,
                5.681E+00, 5.680E+00, 5.655E+00, 5.648E+00, 5.620E+00, 5.594E+00, 5.567E+00, 5.557E+00, 5.552E+00, 5.553E+00,
                5.539E+00, 5.524E+00, 5.507E+00, 5.505E+00, 5.487E+00, 5.474E+00, 5.462E+00, 5.450E+00, 5.448E+00, 5.441E+00,
                5.440E+00, 5.442E+00, 5.450E+00, 5.466E+00, 5.461E+00, 5.452E+00, 5.445E+00, 5.412E+00, 5.379E+00, 5.280E+00,
                5.228E+00, 5.199E+00, 5.171E+00, 5.139E+00, 5.124E+00, 5.112E+00, 5.129E+00, 5.145E+00, 5.173E+00, 5.176E+00,
                5.185E+00, 5.183E+00, 5.200E+00, 5.202E+00, 5.204E+00, 5.224E+00, 5.244E+00, 5.297E+00, 5.318E+00, 5.376E+00,
                5.441E+00, 5.491E+00, 5.561E+00, 5.629E+00, 5.687E+00, 5.757E+00, 5.830E+00, 5.911E+00, 5.998E+00, 6.090E+00,
                6.193E+00, 6.330E+00, 6.449E+00, 6.581E+00, 6.710E+00, 6.838E+00, 6.970E+00, 7.107E+00, 7.238E+00, 7.388E+00,
                7.506E+00, 7.635E+00, 7.767E+00, 7.874E+00, 7.977E+00, 8.071E+00, 8.150E+00, 8.220E+00, 8.292E+00, 8.350E+00,
                8.449E+00, 8.521E+00, 8.583E+00, 8.666E+00, 8.723E+00, 8.759E+00, 8.821E+00, 8.864E+00, 8.909E+00, 8.941E+00,
                8.949E+00, 8.955E+00, 8.983E+00, 9.022E+00, 9.043E+00, 9.044E+00, 9.028E+00, 9.034E+00, 9.052E+00, 9.048E+00,
                9.041E+00, 9.037E+00, 9.036E+00, 9.035E+00, 9.021E+00, 9.016E+00, 9.008E+00, 8.970E+00, 8.974E+00, 8.953E+00,
                8.957E+00, 8.937E+00, 8.923E+00, 8.912E+00, 8.895E+00, 8.891E+00, 8.880E+00, 8.867E+00, 8.855E+00, 8.852E+00,
                8.861E+00, 8.864E+00, 8.876E+00, 8.869E+00, 8.873E+00, 8.855E+00, 8.828E+00, 8.839E+00, 8.855E+00, 8.856E+00,
                8.833E+00, 8.842E+00, 8.844E+00, 8.830E+00, 8.808E+00, 8.818E+00, 8.807E+00, 8.797E+00, 8.794E+00, 8.791E+00,
                8.795E+00, 8.772E+00, 8.754E+00, 8.759E+00, 8.760E+00, 8.746E+00, 8.762E+00, 8.778E+00, 8.790E+00, 8.795E+00,
                8.811E+00, 8.848E+00, 8.874E+00, 8.885E+00, 8.913E+00, 8.944E+00, 8.981E+00, 8.988E+00, 9.001E+00, 9.034E+00,
                9.076E+00, 9.111E+00, 9.141E+00, 9.171E+00, 9.214E+00, 9.255E+00, 9.304E+00, 9.356E+00, 9.406E+00, 9.448E+00,
                9.516E+00, 9.578E+00, 9.638E+00, 9.692E+00, 9.763E+00, 9.845E+00, 9.953E+00, 1.004E+01, 1.015E+01, 1.027E+01,
                1.039E+01, 1.052E+01, 1.063E+01, 1.077E+01, 1.091E+01, 1.103E+01, 1.119E+01, 1.135E+01, 1.150E+01, 1.166E+01,
                1.181E+01, 1.201E+01, 1.217E+01, 1.235E+01, 1.251E+01, 1.269E+01, 1.287E+01, 1.307E+01, 1.325E+01, 1.346E+01,
                1.364E+01, 1.384E+01, 1.404E+01, 1.423E+01, 1.441E+01, 1.461E+01, 1.481E+01, 1.499E+01, 1.518E+01, 1.534E+01,
                1.554E+01, 1.571E+01, 1.591E+01, 1.607E+01, 1.622E+01, 1.637E+01, 1.653E+01, 1.667E+01, 1.678E+01, 1.690E+01,
                1.698E+01, 1.709E+01, 1.718E+01, 1.725E+01, 1.734E+01, 1.739E+01, 1.748E+01, 1.755E+01, 1.761E+01, 1.767E+01,
                1.771E+01, 1.777E+01, 1.783E+01, 1.787E+01, 1.794E+01, 1.795E+01, 1.799E+01, 1.805E+01, 1.809E+01, 1.813E+01,
                1.820E+01, 1.827E+01, 1.830E+01, 1.835E+01, 1.841E+01, 1.846E+01, 1.852E+01, 1.856E+01, 1.861E+01, 1.866E+01,
                1.871E+01, 1.876E+01, 1.881E+01, 1.885E+01, 1.890E+01, 1.896E+01, 1.903E+01, 1.907E+01, 1.911E+01, 1.916E+01,
                1.921E+01, 1.927E+01, 1.929E+01, 1.932E+01, 1.935E+01, 1.936E+01, 1.940E+01, 1.943E+01, 1.947E+01, 1.951E+01,
                1.953E+01, 1.956E+01, 1.960E+01, 1.961E+01, 1.962E+01, 1.966E+01, 1.966E+01, 1.969E+01, 1.970E+01, 1.972E+01,
                1.974E+01, 1.974E+01, 1.976E+01, 1.978E+01, 1.979E+01, 1.982E+01, 1.982E+01, 1.983E+01, 1.986E+01, 1.988E+01,
                1.989E+01, 1.989E+01, 1.993E+01, 1.993E+01, 1.997E+01, 2.001E+01, 2.001E+01, 2.004E+01, 2.007E+01, 2.011E+01,
                2.014E+01, 2.015E+01, 2.017E+01, 2.019E+01, 2.022E+01, 2.023E+01, 2.023E+01, 2.026E+01, 2.027E+01, 2.029E+01,
                2.028E+01, 2.027E+01, 2.029E+01, 2.029E+01, 2.031E+01, 2.029E+01, 2.026E+01, 2.030E+01, 2.031E+01, 2.030E+01,
                2.030E+01, 2.031E+01, 2.029E+01, 2.029E+01, 2.026E+01, 2.025E+01, 2.023E+01, 2.020E+01, 2.016E+01, 2.015E+01,
                2.012E+01, 2.009E+01, 2.007E+01, 2.003E+01, 1.998E+01, 1.996E+01, 1.991E+01, 1.986E+01, 1.980E+01, 1.975E+01,
                1.969E+01, 1.964E+01, 1.959E+01, 1.953E+01, 1.947E+01, 1.941E+01, 1.936E+01, 1.931E+01, 1.922E+01, 1.918E+01,
                1.912E+01, 1.906E+01, 1.899E+01, 1.890E+01, 1.885E+01, 1.881E+01, 1.875E+01, 1.867E+01, 1.861E+01, 1.858E+01,
                1.852E+01, 1.846E+01, 1.840E+01, 1.834E+01, 1.829E+01, 1.824E+01, 1.819E+01, 1.813E+01, 1.807E+01, 1.803E+01,
                1.798E+01, 1.792E+01, 1.788E+01, 1.782E+01, 1.780E+01, 1.775E+01, 1.773E+01, 1.768E+01, 1.768E+01, 1.766E+01,
                1.763E+01, 1.762E+01, 1.763E+01, 1.764E+01, 1.764E+01, 1.766E+01, 1.770E+01, 1.774E+01, 1.779E+01, 1.786E+01,
                1.795E+01, 1.803E+01, 1.814E+01, 1.825E+01, 1.836E+01, 1.851E+01, 1.866E+01, 1.881E+01, 1.895E+01, 1.913E+01,
                1.932E+01, 1.951E+01, 1.972E+01, 1.994E+01, 2.017E+01, 2.040E+01, 2.065E+01, 2.089E+01, 2.114E+01, 2.140E+01,
                2.163E+01, 2.186E+01, 2.210E+01, 2.237E+01, 2.262E+01, 2.290E+01, 2.313E+01, 2.339E+01, 2.361E+01, 2.387E+01,
                2.410E+01, 2.435E+01, 2.455E+01, 2.479E+01, 2.499E+01, 2.521E+01, 2.541E+01, 2.562E+01, 2.583E+01, 2.605E+01,
                2.626E+01, 2.643E+01, 2.657E+01, 2.674E+01, 2.689E+01, 2.701E+01, 2.718E+01, 2.732E+01, 2.742E+01, 2.754E+01,
                2.763E+01, 2.777E+01, 2.794E+01, 2.804E+01, 2.821E+01, 2.836E+01, 2.850E+01, 2.863E+01, 2.878E+01, 2.896E+01,
                2.913E+01, 2.922E+01, 2.937E+01, 2.947E+01, 2.960E+01, 2.970E+01, 2.982E+01, 2.997E+01, 3.007E+01, 3.018E+01,
                3.028E+01, 3.040E+01, 3.053E+01, 3.060E+01, 3.066E+01, 3.070E+01, 3.076E+01, 3.078E+01, 3.075E+01, 3.074E+01,
                3.072E+01, 3.065E+01, 3.058E+01, 3.051E+01, 3.045E+01, 3.034E+01, 3.029E+01, 3.023E+01, 3.015E+01, 3.004E+01,
                3.000E+01, 2.998E+01, 2.991E+01, 2.986E+01, 2.984E+01, 2.981E+01, 2.976E+01, 2.973E+01, 2.976E+01, 2.977E+01,
                2.979E+01, 2.981E+01, 2.985E+01, 2.989E+01, 2.999E+01, 3.000E+01, 3.005E+01, 3.007E+01, 3.011E+01, 3.017E+01,
                3.022E+01, 3.023E+01, 3.029E+01, 3.028E+01, 3.029E+01, 3.027E+01, 3.027E+01, 3.024E+01, 3.019E+01, 3.010E+01,
                3.010E+01, 3.003E+01, 2.993E+01, 2.983E+01, 2.984E+01, 2.975E+01, 2.966E+01, 2.958E+01, 2.948E+01, 2.930E+01,
                2.926E+01, 2.920E+01, 2.913E+01, 2.902E+01, 2.890E+01, 2.882E+01, 2.873E+01, 2.873E+01, 2.870E+01, 2.865E+01,
                2.858E+01, 2.854E+01, 2.851E+01, 2.846E+01, 2.838E+01, 2.834E+01, 2.823E+01, 2.820E+01, 2.817E+01, 2.809E+01,
                2.803E+01, 2.803E+01, 2.801E+01, 2.794E+01, 2.791E+01, 2.790E+01, 2.784E+01, 2.779E+01, 2.781E+01, 2.782E+01,
                2.781E+01, 2.781E+01, 2.783E+01, 2.785E+01, 2.785E+01, 2.782E+01, 2.782E+01, 2.780E+01, 2.780E+01, 2.778E+01,
                2.783E+01, 2.784E+01, 2.788E+01, 2.791E+01, 2.799E+01, 2.804E+01, 2.812E+01, 2.811E+01, 2.819E+01, 2.819E+01,
                2.817E+01, 2.817E+01, 2.831E+01, 2.837E+01, 2.848E+01, 2.853E+01, 2.859E+01, 2.870E+01, 2.874E+01, 2.887E+01,
                2.898E+01, 2.910E+01, 2.923E+01, 2.934E+01, 2.944E+01, 2.959E+01, 2.973E+01, 2.987E+01, 3.002E+01, 3.016E+01,
                3.035E+01, 3.043E+01, 3.064E+01, 3.084E+01, 3.098E+01, 3.122E+01, 3.132E+01, 3.152E+01, 3.165E+01, 3.184E+01,
                3.204E+01, 3.221E+01, 3.233E+01, 3.255E+01, 3.282E+01, 3.315E+01, 3.339E+01, 3.360E+01, 3.384E+01, 3.410E+01,
                3.426E+01, 3.452E+01, 3.473E+01, 3.497E+01, 3.519E+01, 3.539E+01, 3.561E+01, 3.579E+01, 3.604E+01, 3.618E+01,
                3.636E+01, 3.660E+01, 3.675E+01, 3.682E+01, 3.699E+01, 3.711E+01, 3.735E+01, 3.758E+01, 3.792E+01, 3.796E+01,
                3.812E+01, 3.822E+01, 3.833E+01, 3.856E+01, 3.874E+01, 3.877E+01, 3.884E+01, 3.883E+01, 3.879E+01, 3.886E+01,
                3.900E+01, 3.900E+01, 3.906E+01, 3.905E+01, 3.916E+01, 3.928E+01, 3.948E+01, 3.943E+01, 3.951E+01, 3.964E+01,
                3.953E+01, 3.960E+01, 3.958E+01, 3.954E+01, 3.940E+01, 3.936E+01, 3.917E+01, 3.926E+01, 3.893E+01, 3.921E+01,
                3.871E+01])

### Direct Energy from the sun

Es = np.array([5.910E-01, 5.980E-01, 6.050E-01, 6.120E-01, 6.190E-01, 6.260E-01, 6.330E-01, 6.400E-01, 6.470E-01, 6.540E-01, 
                6.610E-01, 6.680E-01, 6.750E-01, 6.820E-01, 6.890E-01, 6.960E-01, 7.030E-01, 7.100E-01, 7.170E-01, 7.240E-01,
                7.310E-01, 7.376E-01, 7.442E-01, 7.508E-01, 7.574E-01, 7.640E-01, 7.706E-01, 7.772E-01, 7.838E-01, 7.904E-01,
                7.970E-01, 8.036E-01, 8.102E-01, 8.168E-01, 8.234E-01, 8.300E-01, 8.366E-01, 8.432E-01, 8.498E-01, 8.564E-01,
                8.630E-01, 8.743E-01, 8.856E-01, 8.969E-01, 9.082E-01, 9.195E-01, 9.308E-01, 9.421E-01, 9.534E-01, 9.647E-01,
                9.760E-01, 9.873E-01, 9.986E-01, 1.010E+00, 1.021E+00, 1.033E+00, 1.044E+00, 1.055E+00, 1.066E+00, 1.078E+00,
                1.089E+00, 1.094E+00, 1.100E+00, 1.105E+00, 1.110E+00, 1.116E+00, 1.121E+00, 1.126E+00, 1.131E+00, 1.137E+00,
                1.142E+00, 1.147E+00, 1.153E+00, 1.158E+00, 1.163E+00, 1.169E+00, 1.174E+00, 1.179E+00, 1.184E+00, 1.190E+00,
                1.195E+00, 1.194E+00, 1.194E+00, 1.193E+00, 1.192E+00, 1.191E+00, 1.191E+00, 1.190E+00, 1.189E+00, 1.188E+00,
                1.188E+00, 1.187E+00, 1.186E+00, 1.185E+00, 1.185E+00, 1.184E+00, 1.183E+00, 1.182E+00, 1.182E+00, 1.181E+00,
                1.180E+00, 1.180E+00, 1.181E+00, 1.181E+00, 1.181E+00, 1.182E+00, 1.182E+00, 1.182E+00, 1.182E+00, 1.183E+00,
                1.183E+00, 1.183E+00, 1.184E+00, 1.184E+00, 1.184E+00, 1.185E+00, 1.185E+00, 1.185E+00, 1.185E+00, 1.186E+00,
                1.186E+00, 1.191E+00, 1.195E+00, 1.200E+00, 1.204E+00, 1.209E+00, 1.213E+00, 1.218E+00, 1.222E+00, 1.227E+00,
                1.231E+00, 1.236E+00, 1.240E+00, 1.245E+00, 1.249E+00, 1.254E+00, 1.258E+00, 1.263E+00, 1.267E+00, 1.272E+00,
                1.276E+00, 1.278E+00, 1.279E+00, 1.281E+00, 1.282E+00, 1.284E+00, 1.285E+00, 1.287E+00, 1.288E+00, 1.290E+00,
                1.291E+00, 1.293E+00, 1.294E+00, 1.296E+00, 1.297E+00, 1.299E+00, 1.300E+00, 1.302E+00, 1.303E+00, 1.305E+00,
                1.306E+00, 1.309E+00, 1.312E+00, 1.314E+00, 1.317E+00, 1.320E+00, 1.323E+00, 1.325E+00, 1.328E+00, 1.331E+00,
                1.334E+00, 1.336E+00, 1.339E+00, 1.342E+00, 1.345E+00, 1.347E+00, 1.350E+00, 1.353E+00, 1.356E+00, 1.358E+00,
                1.361E+00, 1.361E+00, 1.360E+00, 1.360E+00, 1.360E+00, 1.359E+00, 1.359E+00, 1.359E+00, 1.358E+00, 1.358E+00,
                1.358E+00, 1.357E+00, 1.357E+00, 1.356E+00, 1.356E+00, 1.356E+00, 1.355E+00, 1.355E+00, 1.355E+00, 1.354E+00,
                1.354E+00, 1.356E+00, 1.357E+00, 1.359E+00, 1.360E+00, 1.362E+00, 1.363E+00, 1.365E+00, 1.366E+00, 1.368E+00,
                1.370E+00, 1.371E+00, 1.373E+00, 1.374E+00, 1.376E+00, 1.377E+00, 1.379E+00, 1.380E+00, 1.382E+00, 1.383E+00,
                1.385E+00, 1.385E+00, 1.385E+00, 1.385E+00, 1.386E+00, 1.386E+00, 1.386E+00, 1.386E+00, 1.386E+00, 1.386E+00,
                1.387E+00, 1.387E+00, 1.387E+00, 1.387E+00, 1.387E+00, 1.387E+00, 1.387E+00, 1.388E+00, 1.388E+00, 1.388E+00,
                1.388E+00, 1.387E+00, 1.386E+00, 1.384E+00, 1.383E+00, 1.382E+00, 1.381E+00, 1.379E+00, 1.378E+00, 1.377E+00,
                1.376E+00, 1.374E+00, 1.373E+00, 1.372E+00, 1.371E+00, 1.369E+00, 1.368E+00, 1.367E+00, 1.366E+00, 1.364E+00,
                1.363E+00, 1.364E+00, 1.365E+00, 1.366E+00, 1.367E+00, 1.368E+00, 1.368E+00, 1.369E+00, 1.370E+00, 1.371E+00,
                1.372E+00, 1.373E+00, 1.374E+00, 1.375E+00, 1.376E+00, 1.377E+00, 1.377E+00, 1.378E+00, 1.379E+00, 1.380E+00,
                1.381E+00, 1.375E+00, 1.368E+00, 1.362E+00, 1.355E+00, 1.349E+00, 1.343E+00, 1.336E+00, 1.330E+00, 1.323E+00,
                1.317E+00, 1.311E+00, 1.304E+00, 1.298E+00, 1.291E+00, 1.285E+00, 1.279E+00, 1.272E+00, 1.266E+00, 1.259E+00,
                1.253E+00, 1.236E+00, 1.219E+00, 1.201E+00, 1.184E+00, 1.167E+00, 1.150E+00, 1.133E+00, 1.115E+00, 1.098E+00,
                1.081E+00, 1.064E+00, 1.047E+00, 1.029E+00, 1.012E+00, 9.950E-01, 9.778E-01, 9.606E-01, 9.434E-01, 9.262E-01,
                9.090E-01, 9.248E-01, 9.405E-01, 9.563E-01, 9.720E-01, 9.878E-01, 1.004E+00, 1.019E+00, 1.035E+00, 1.051E+00,
                1.067E+00, 1.082E+00, 1.098E+00, 1.114E+00, 1.130E+00, 1.145E+00, 1.161E+00, 1.177E+00, 1.193E+00, 1.208E+00,
                1.224E+00, 1.182E+00, 1.139E+00, 1.097E+00, 1.054E+00, 1.012E+00, 9.693E-01, 9.269E-01, 8.844E-01, 8.420E-01,
                7.995E-01, 7.571E-01, 7.146E-01, 6.722E-01, 6.297E-01, 5.873E-01, 5.448E-01, 5.024E-01, 4.599E-01, 4.175E-01,
                3.750E-01, 4.185E-01, 4.619E-01, 5.054E-01, 5.488E-01, 5.923E-01, 6.357E-01, 6.792E-01, 7.226E-01, 7.661E-01,
                8.095E-01, 8.530E-01, 8.964E-01, 9.399E-01, 9.833E-01, 1.027E+00, 1.070E+00, 1.114E+00, 1.157E+00, 1.201E+00,
                1.244E+00, 1.242E+00, 1.240E+00, 1.238E+00, 1.235E+00, 1.233E+00, 1.231E+00, 1.229E+00, 1.227E+00, 1.225E+00,
                1.223E+00, 1.220E+00, 1.218E+00, 1.216E+00, 1.214E+00, 1.212E+00, 1.210E+00, 1.207E+00, 1.205E+00, 1.203E+00,
                1.201E+00, 1.188E+00, 1.174E+00, 1.161E+00, 1.147E+00, 1.134E+00, 1.121E+00, 1.107E+00, 1.094E+00, 1.080E+00,
                1.067E+00, 1.054E+00, 1.040E+00, 1.027E+00, 1.013E+00, 1.000E+00, 9.866E-01, 9.732E-01, 9.598E-01, 9.464E-01,
                9.330E-01, 9.416E-01, 9.502E-01, 9.588E-01, 9.674E-01, 9.760E-01, 9.846E-01, 9.932E-01, 1.002E+00, 1.010E+00,
                1.019E+00, 1.028E+00, 1.036E+00, 1.045E+00, 1.053E+00, 1.062E+00, 1.071E+00, 1.079E+00, 1.088E+00, 1.096E+00,
                1.105E+00, 1.105E+00, 1.106E+00, 1.106E+00, 1.107E+00, 1.107E+00, 1.108E+00, 1.108E+00, 1.109E+00, 1.109E+00,
                1.110E+00, 1.110E+00, 1.110E+00, 1.111E+00, 1.111E+00, 1.112E+00, 1.112E+00, 1.113E+00, 1.113E+00, 1.114E+00,
                1.114E+00, 1.114E+00, 1.113E+00, 1.113E+00, 1.112E+00, 1.112E+00, 1.111E+00, 1.111E+00, 1.110E+00, 1.110E+00,
                1.109E+00, 1.109E+00, 1.108E+00, 1.108E+00, 1.107E+00, 1.107E+00, 1.106E+00, 1.106E+00, 1.105E+00, 1.105E+00,
                1.104E+00, 1.087E+00, 1.070E+00, 1.053E+00, 1.036E+00, 1.019E+00, 1.002E+00, 9.850E-01, 9.680E-01, 9.510E-01,
                9.340E-01, 9.170E-01, 9.000E-01, 8.830E-01, 8.660E-01, 8.490E-01, 8.320E-01, 8.150E-01, 7.980E-01, 7.810E-01,
                7.640E-01, 7.758E-01, 7.876E-01, 7.994E-01, 8.112E-01, 8.230E-01, 8.348E-01, 8.466E-01, 8.584E-01, 8.702E-01,
                8.820E-01, 8.938E-01, 9.056E-01, 9.174E-01, 9.292E-01, 9.410E-01, 9.528E-01, 9.646E-01, 9.764E-01, 9.882E-01,
                1.000E+00, 9.771E-01, 9.542E-01, 9.313E-01, 9.084E-01, 8.855E-01, 8.626E-01, 8.397E-01, 8.168E-01, 7.939E-01,
                7.710E-01, 7.481E-01, 7.252E-01, 7.023E-01, 6.794E-01, 6.565E-01, 6.336E-01, 6.107E-01, 5.878E-01, 5.649E-01,
                5.420E-01, 5.412E-01, 5.403E-01, 5.395E-01, 5.386E-01, 5.378E-01, 5.369E-01, 5.361E-01, 5.352E-01, 5.344E-01,
                5.335E-01, 5.327E-01, 5.318E-01, 5.310E-01, 5.301E-01, 5.293E-01, 5.284E-01, 5.276E-01, 5.267E-01, 5.259E-01,
                5.250E-01, 5.362E-01, 5.474E-01, 5.586E-01, 5.698E-01, 5.810E-01, 5.922E-01, 6.034E-01, 6.146E-01, 6.258E-01,
                6.370E-01, 6.482E-01, 6.594E-01, 6.706E-01, 6.818E-01, 6.930E-01, 7.042E-01, 7.154E-01, 7.266E-01, 7.378E-01,
                7.490E-01, 7.564E-01, 7.638E-01, 7.712E-01, 7.786E-01, 7.860E-01, 7.934E-01, 8.008E-01, 8.082E-01, 8.156E-01,
                8.230E-01, 8.304E-01, 8.378E-01, 8.452E-01, 8.526E-01, 8.600E-01, 8.674E-01, 8.748E-01, 8.822E-01, 8.896E-01,
                8.970E-01, 8.952E-01, 8.933E-01, 8.915E-01, 8.896E-01, 8.878E-01, 8.859E-01, 8.841E-01, 8.822E-01, 8.804E-01,
                8.785E-01, 8.767E-01, 8.748E-01, 8.730E-01, 8.711E-01, 8.693E-01, 8.674E-01, 8.656E-01, 8.637E-01, 8.619E-01,
                8.600E-01, 8.588E-01, 8.575E-01, 8.563E-01, 8.550E-01, 8.538E-01, 8.525E-01, 8.513E-01, 8.500E-01, 8.488E-01,
                8.475E-01, 8.463E-01, 8.450E-01, 8.438E-01, 8.425E-01, 8.413E-01, 8.400E-01, 8.388E-01, 8.375E-01, 8.363E-01,
                8.350E-01, 8.333E-01, 8.316E-01, 8.299E-01, 8.282E-01, 8.265E-01, 8.248E-01, 8.231E-01, 8.214E-01, 8.197E-01,
                8.180E-01, 8.163E-01, 8.146E-01, 8.129E-01, 8.112E-01, 8.095E-01, 8.078E-01, 8.061E-01, 8.044E-01, 8.027E-01,
                8.010E-01, 7.977E-01, 7.944E-01, 7.911E-01, 7.878E-01, 7.845E-01, 7.812E-01, 7.779E-01, 7.746E-01, 7.713E-01,
                7.680E-01, 7.647E-01, 7.614E-01, 7.581E-01, 7.548E-01, 7.515E-01, 7.482E-01, 7.449E-01, 7.416E-01, 7.383E-01,
                7.350E-01, 7.326E-01, 7.302E-01, 7.278E-01, 7.254E-01, 7.230E-01, 7.206E-01, 7.182E-01, 7.158E-01, 7.134E-01,
                7.110E-01, 7.086E-01, 7.062E-01, 7.038E-01, 7.014E-01, 6.990E-01, 6.966E-01, 6.942E-01, 6.918E-01, 6.894E-01,
                6.870E-01, 6.634E-01, 6.397E-01, 6.161E-01, 5.924E-01, 5.688E-01, 5.451E-01, 5.215E-01, 4.978E-01, 4.742E-01,
                4.505E-01, 4.269E-01, 4.032E-01, 3.796E-01, 3.559E-01, 3.323E-01, 3.086E-01, 2.850E-01, 2.613E-01, 2.377E-01,
                2.140E-01, 2.231E-01, 2.321E-01, 2.412E-01, 2.502E-01, 2.593E-01, 2.683E-01, 2.774E-01, 2.864E-01, 2.955E-01,
                3.045E-01, 3.136E-01, 3.226E-01, 3.317E-01, 3.407E-01, 3.498E-01, 3.588E-01, 3.679E-01, 3.769E-01, 3.860E-01,
                3.950E-01, 3.950E-01, 3.949E-01, 3.949E-01, 3.948E-01, 3.948E-01, 3.947E-01, 3.947E-01, 3.946E-01, 3.946E-01,
                3.945E-01, 3.945E-01, 3.944E-01, 3.944E-01, 3.943E-01, 3.943E-01, 3.942E-01, 3.942E-01, 3.941E-01, 3.941E-01,
                3.940E-01, 4.020E-01, 4.099E-01, 4.179E-01, 4.258E-01, 4.338E-01, 4.417E-01, 4.497E-01, 4.576E-01, 4.656E-01,
                4.735E-01, 4.815E-01, 4.894E-01, 4.974E-01, 5.053E-01, 5.133E-01, 5.212E-01, 5.292E-01, 5.371E-01, 5.451E-01,
                5.530E-01, 5.526E-01, 5.522E-01, 5.518E-01, 5.514E-01, 5.510E-01, 5.506E-01, 5.502E-01, 5.498E-01, 5.494E-01,
                5.490E-01, 5.486E-01, 5.482E-01, 5.478E-01, 5.474E-01, 5.470E-01, 5.466E-01, 5.462E-01, 5.458E-01, 5.454E-01,
                5.450E-01, 5.477E-01, 5.504E-01, 5.531E-01, 5.558E-01, 5.585E-01, 5.612E-01, 5.639E-01, 5.666E-01, 5.693E-01,
                5.720E-01, 5.747E-01, 5.774E-01, 5.801E-01, 5.828E-01, 5.855E-01, 5.882E-01, 5.909E-01, 5.936E-01, 5.963E-01,
                5.990E-01, 5.984E-01, 5.978E-01, 5.972E-01, 5.966E-01, 5.960E-01, 5.954E-01, 5.948E-01, 5.942E-01, 5.936E-01,
                5.930E-01, 5.924E-01, 5.918E-01, 5.912E-01, 5.906E-01, 5.900E-01, 5.894E-01, 5.888E-01, 5.882E-01, 5.876E-01,
                5.870E-01, 5.848E-01, 5.825E-01, 5.803E-01, 5.780E-01, 5.758E-01, 5.735E-01, 5.713E-01, 5.690E-01, 5.668E-01,
                5.645E-01, 5.623E-01, 5.600E-01, 5.578E-01, 5.555E-01, 5.533E-01, 5.510E-01, 5.488E-01, 5.465E-01, 5.443E-01,
                5.420E-01, 5.406E-01, 5.392E-01, 5.378E-01, 5.364E-01, 5.350E-01, 5.336E-01, 5.322E-01, 5.308E-01, 5.294E-01,
                5.280E-01, 5.266E-01, 5.252E-01, 5.238E-01, 5.224E-01, 5.210E-01, 5.196E-01, 5.182E-01, 5.168E-01, 5.154E-01,
                5.140E-01, 5.114E-01, 5.088E-01, 5.062E-01, 5.036E-01, 5.010E-01, 4.984E-01, 4.958E-01, 4.932E-01, 4.906E-01,
                4.880E-01, 4.854E-01, 4.828E-01, 4.802E-01, 4.776E-01, 4.750E-01, 4.724E-01, 4.698E-01, 4.672E-01, 4.646E-01,
                4.620E-01, 4.553E-01, 4.485E-01, 4.418E-01, 4.350E-01, 4.283E-01, 4.215E-01, 4.148E-01, 4.080E-01, 4.013E-01,
                3.945E-01, 3.878E-01, 3.810E-01, 3.743E-01, 3.675E-01, 3.608E-01, 3.540E-01, 3.473E-01, 3.405E-01, 3.338E-01,
                3.270E-01, 3.239E-01, 3.207E-01, 3.176E-01, 3.144E-01, 3.113E-01, 3.081E-01, 3.050E-01, 3.018E-01, 2.987E-01,
                2.955E-01, 2.924E-01, 2.892E-01, 2.861E-01, 2.829E-01, 2.798E-01, 2.766E-01, 2.735E-01, 2.703E-01, 2.672E-01,
                2.640E-01, 2.512E-01, 2.383E-01, 2.255E-01, 2.126E-01, 1.998E-01, 1.869E-01, 1.741E-01, 1.612E-01, 1.484E-01,
                1.355E-01, 1.227E-01, 1.098E-01, 9.695E-02, 8.410E-02, 7.125E-02, 5.840E-02, 4.555E-02, 3.270E-02, 1.985E-02,
                7.000E-03, 6.800E-03, 6.600E-03, 6.400E-03, 6.200E-03, 6.000E-03, 5.800E-03, 5.600E-03, 5.400E-03, 5.200E-03,
                5.000E-03, 4.800E-03, 4.600E-03, 4.400E-03, 4.200E-03, 4.000E-03, 3.800E-03, 3.600E-03, 3.400E-03, 3.200E-03,
                3.000E-03, 3.900E-03, 4.800E-03, 5.700E-03, 6.600E-03, 7.500E-03, 8.400E-03, 9.300E-03, 1.020E-02, 1.110E-02,
                1.200E-02, 1.290E-02, 1.380E-02, 1.470E-02, 1.560E-02, 1.650E-02, 1.740E-02, 1.830E-02, 1.920E-02, 2.010E-02,
                2.100E-02, 2.095E-02, 2.090E-02, 2.085E-02, 2.080E-02, 2.075E-02, 2.070E-02, 2.065E-02, 2.060E-02, 2.055E-02,
                2.050E-02, 2.045E-02, 2.040E-02, 2.035E-02, 2.030E-02, 2.025E-02, 2.020E-02, 2.015E-02, 2.010E-02, 2.005E-02,
                2.000E-02, 2.170E-02, 2.340E-02, 2.510E-02, 2.680E-02, 2.850E-02, 3.020E-02, 3.190E-02, 3.360E-02, 3.530E-02,
                3.700E-02, 3.870E-02, 4.040E-02, 4.210E-02, 4.380E-02, 4.550E-02, 4.720E-02, 4.890E-02, 5.060E-02, 5.230E-02,
                5.400E-02, 5.795E-02, 6.190E-02, 6.585E-02, 6.980E-02, 7.375E-02, 7.770E-02, 8.165E-02, 8.560E-02, 8.955E-02,
                9.350E-02, 9.745E-02, 1.014E-01, 1.054E-01, 1.093E-01, 1.133E-01, 1.172E-01, 1.212E-01, 1.251E-01, 1.291E-01,
                1.330E-01, 1.327E-01, 1.324E-01, 1.321E-01, 1.318E-01, 1.315E-01, 1.312E-01, 1.309E-01, 1.306E-01, 1.303E-01,
                1.300E-01, 1.297E-01, 1.294E-01, 1.291E-01, 1.288E-01, 1.285E-01, 1.282E-01, 1.279E-01, 1.276E-01, 1.273E-01,
                1.270E-01, 1.384E-01, 1.497E-01, 1.611E-01, 1.724E-01, 1.838E-01, 1.951E-01, 2.065E-01, 2.178E-01, 2.292E-01,
                2.405E-01, 2.519E-01, 2.632E-01, 2.746E-01, 2.859E-01, 2.973E-01, 3.086E-01, 3.200E-01, 3.313E-01, 3.427E-01,
                3.540E-01, 3.541E-01, 3.541E-01, 3.542E-01, 3.542E-01, 3.543E-01, 3.543E-01, 3.544E-01, 3.544E-01, 3.545E-01,
                3.545E-01, 3.546E-01, 3.546E-01, 3.547E-01, 3.547E-01, 3.548E-01, 3.548E-01, 3.549E-01, 3.549E-01, 3.550E-01,
                3.550E-01, 3.556E-01, 3.561E-01, 3.567E-01, 3.572E-01, 3.578E-01, 3.583E-01, 3.589E-01, 3.594E-01, 3.600E-01,
                3.605E-01, 3.611E-01, 3.616E-01, 3.622E-01, 3.627E-01, 3.633E-01, 3.638E-01, 3.644E-01, 3.649E-01, 3.655E-01,
                3.660E-01, 3.659E-01, 3.658E-01, 3.657E-01, 3.656E-01, 3.655E-01, 3.654E-01, 3.653E-01, 3.652E-01, 3.651E-01,
                3.650E-01, 3.649E-01, 3.648E-01, 3.647E-01, 3.646E-01, 3.645E-01, 3.644E-01, 3.643E-01, 3.642E-01, 3.641E-01,
                3.640E-01, 3.626E-01, 3.611E-01, 3.597E-01, 3.582E-01, 3.568E-01, 3.553E-01, 3.539E-01, 3.524E-01, 3.510E-01,
                3.495E-01, 3.481E-01, 3.466E-01, 3.452E-01, 3.437E-01, 3.423E-01, 3.408E-01, 3.394E-01, 3.379E-01, 3.365E-01,
                3.350E-01, 3.350E-01, 3.349E-01, 3.349E-01, 3.348E-01, 3.348E-01, 3.347E-01, 3.347E-01, 3.346E-01, 3.346E-01,
                3.345E-01, 3.345E-01, 3.344E-01, 3.344E-01, 3.343E-01, 3.343E-01, 3.342E-01, 3.342E-01, 3.341E-01, 3.341E-01,
                3.340E-01, 3.338E-01, 3.335E-01, 3.333E-01, 3.330E-01, 3.328E-01, 3.325E-01, 3.323E-01, 3.320E-01, 3.318E-01,
                3.315E-01, 3.313E-01, 3.310E-01, 3.308E-01, 3.305E-01, 3.303E-01, 3.300E-01, 3.298E-01, 3.295E-01, 3.293E-01,
                3.290E-01, 3.280E-01, 3.270E-01, 3.260E-01, 3.250E-01, 3.240E-01, 3.230E-01, 3.220E-01, 3.210E-01, 3.200E-01,
                3.190E-01, 3.180E-01, 3.170E-01, 3.160E-01, 3.150E-01, 3.140E-01, 3.130E-01, 3.120E-01, 3.110E-01, 3.100E-01,
                3.090E-01, 3.089E-01, 3.087E-01, 3.086E-01, 3.084E-01, 3.083E-01, 3.081E-01, 3.080E-01, 3.078E-01, 3.077E-01,
                3.075E-01, 3.074E-01, 3.072E-01, 3.071E-01, 3.069E-01, 3.068E-01, 3.066E-01, 3.065E-01, 3.063E-01, 3.062E-01,
                3.060E-01, 3.054E-01, 3.047E-01, 3.041E-01, 3.034E-01, 3.028E-01, 3.021E-01, 3.015E-01, 3.008E-01, 3.002E-01,
                2.995E-01, 2.989E-01, 2.982E-01, 2.976E-01, 2.969E-01, 2.963E-01, 2.956E-01, 2.950E-01, 2.943E-01, 2.937E-01,
                2.930E-01, 2.923E-01, 2.915E-01, 2.908E-01, 2.900E-01, 2.893E-01, 2.885E-01, 2.878E-01, 2.870E-01, 2.863E-01,
                2.855E-01, 2.848E-01, 2.840E-01, 2.833E-01, 2.825E-01, 2.818E-01, 2.810E-01, 2.803E-01, 2.795E-01, 2.788E-01,
                2.780E-01, 2.777E-01, 2.774E-01, 2.771E-01, 2.768E-01, 2.765E-01, 2.762E-01, 2.759E-01, 2.756E-01, 2.753E-01,
                2.750E-01, 2.747E-01, 2.744E-01, 2.741E-01, 2.738E-01, 2.735E-01, 2.732E-01, 2.729E-01, 2.726E-01, 2.723E-01,
                2.720E-01, 2.689E-01, 2.658E-01, 2.627E-01, 2.596E-01, 2.565E-01, 2.534E-01, 2.503E-01, 2.472E-01, 2.441E-01,
                2.410E-01, 2.379E-01, 2.348E-01, 2.317E-01, 2.286E-01, 2.255E-01, 2.224E-01, 2.193E-01, 2.162E-01, 2.131E-01,
                2.100E-01, 2.119E-01, 2.138E-01, 2.157E-01, 2.176E-01, 2.195E-01, 2.214E-01, 2.233E-01, 2.252E-01, 2.271E-01,
                2.290E-01, 2.309E-01, 2.328E-01, 2.347E-01, 2.366E-01, 2.385E-01, 2.404E-01, 2.423E-01, 2.442E-01, 2.461E-01,
                2.480E-01, 2.427E-01, 2.373E-01, 2.320E-01, 2.266E-01, 2.213E-01, 2.159E-01, 2.106E-01, 2.052E-01, 1.999E-01,
                1.945E-01, 1.892E-01, 1.838E-01, 1.785E-01, 1.731E-01, 1.678E-01, 1.624E-01, 1.571E-01, 1.517E-01, 1.464E-01,
                1.410E-01, 1.356E-01, 1.302E-01, 1.248E-01, 1.194E-01, 1.140E-01, 1.086E-01, 1.032E-01, 9.780E-02, 9.240E-02,
                8.700E-02, 8.160E-02, 7.620E-02, 7.080E-02, 6.540E-02, 6.000E-02, 5.460E-02, 4.920E-02, 4.380E-02, 3.840E-02,
                3.300E-02, 3.160E-02, 3.020E-02, 2.880E-02, 2.740E-02, 2.600E-02, 2.460E-02, 2.320E-02, 2.180E-02, 2.040E-02,
                1.900E-02, 1.760E-02, 1.620E-02, 1.480E-02, 1.340E-02, 1.200E-02, 1.060E-02, 9.200E-03, 7.800E-03, 6.400E-03,
                5.000E-03, 4.900E-03, 4.800E-03, 4.700E-03, 4.600E-03, 4.500E-03, 4.400E-03, 4.300E-03, 4.200E-03, 4.100E-03,
                4.000E-03, 3.900E-03, 3.800E-03, 3.700E-03, 3.600E-03, 3.500E-03, 3.400E-03, 3.300E-03, 3.200E-03, 3.100E-03,
                3.000E-03, 2.900E-03, 2.800E-03, 2.700E-03, 2.600E-03, 2.500E-03, 2.400E-03, 2.300E-03, 2.200E-03, 2.100E-03,
                2.000E-03, 1.900E-03, 1.800E-03, 1.700E-03, 1.600E-03, 1.500E-03, 1.400E-03, 1.300E-03, 1.200E-03, 1.100E-03,
                1.000E-03, 1.900E-03, 2.800E-03, 3.700E-03, 4.600E-03, 5.500E-03, 6.400E-03, 7.300E-03, 8.200E-03, 9.100E-03,
                1.000E-02, 1.090E-02, 1.180E-02, 1.270E-02, 1.360E-02, 1.450E-02, 1.540E-02, 1.630E-02, 1.720E-02, 1.810E-02,
                1.900E-02, 1.810E-02, 1.720E-02, 1.630E-02, 1.540E-02, 1.450E-02, 1.360E-02, 1.270E-02, 1.180E-02, 1.090E-02,
                1.000E-02, 9.100E-03, 8.200E-03, 7.300E-03, 6.400E-03, 5.500E-03, 4.600E-03, 3.700E-03, 2.800E-03, 1.900E-03,
                1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03,
                1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03,
                1.000E-03, 1.250E-03, 1.500E-03, 1.750E-03, 2.000E-03, 2.250E-03, 2.500E-03, 2.750E-03, 3.000E-03, 3.250E-03,
                3.500E-03, 3.750E-03, 4.000E-03, 4.250E-03, 4.500E-03, 4.750E-03, 5.000E-03, 5.250E-03, 5.500E-03, 5.750E-03,
                6.000E-03, 7.100E-03, 8.200E-03, 9.300E-03, 1.040E-02, 1.150E-02, 1.260E-02, 1.370E-02, 1.480E-02, 1.590E-02,
                1.700E-02, 1.810E-02, 1.920E-02, 2.030E-02, 2.140E-02, 2.250E-02, 2.360E-02, 2.470E-02, 2.580E-02, 2.690E-02,
                2.800E-02, 3.150E-02, 3.500E-02, 3.850E-02, 4.200E-02, 4.550E-02, 4.900E-02, 5.250E-02, 5.600E-02, 5.950E-02,
                6.300E-02, 6.650E-02, 7.000E-02, 7.350E-02, 7.700E-02, 8.050E-02, 8.400E-02, 8.750E-02, 9.100E-02, 9.450E-02,
                9.800E-02, 9.720E-02, 9.640E-02, 9.560E-02, 9.480E-02, 9.400E-02, 9.320E-02, 9.240E-02, 9.160E-02, 9.080E-02,
                9.000E-02, 8.920E-02, 8.840E-02, 8.760E-02, 8.680E-02, 8.600E-02, 8.520E-02, 8.440E-02, 8.360E-02, 8.280E-02,
                8.200E-02, 8.015E-02, 7.830E-02, 7.645E-02, 7.460E-02, 7.275E-02, 7.090E-02, 6.905E-02, 6.720E-02, 6.535E-02,
                6.350E-02, 6.165E-02, 5.980E-02, 5.795E-02, 5.610E-02, 5.425E-02, 5.240E-02, 5.055E-02, 4.870E-02, 4.685E-02,
                4.500E-02, 4.965E-02, 5.430E-02, 5.895E-02, 6.360E-02, 6.825E-02, 7.290E-02, 7.755E-02, 8.220E-02, 8.685E-02,
                9.150E-02, 9.615E-02, 1.008E-01, 1.055E-01, 1.101E-01, 1.148E-01, 1.194E-01, 1.241E-01, 1.287E-01, 1.334E-01,
                1.380E-01, 1.363E-01, 1.346E-01, 1.329E-01, 1.312E-01, 1.295E-01, 1.278E-01, 1.261E-01, 1.244E-01, 1.227E-01,
                1.210E-01, 1.193E-01, 1.176E-01, 1.159E-01, 1.142E-01, 1.125E-01, 1.108E-01, 1.091E-01, 1.074E-01, 1.057E-01,
                1.040E-01, 1.054E-01, 1.068E-01, 1.082E-01, 1.096E-01, 1.110E-01, 1.124E-01, 1.138E-01, 1.152E-01, 1.166E-01,
                1.180E-01, 1.194E-01, 1.208E-01, 1.222E-01, 1.236E-01, 1.250E-01, 1.264E-01, 1.278E-01, 1.292E-01, 1.306E-01,
                1.320E-01, 1.317E-01, 1.314E-01, 1.311E-01, 1.308E-01, 1.305E-01, 1.302E-01, 1.299E-01, 1.296E-01, 1.293E-01,
                1.290E-01, 1.287E-01, 1.284E-01, 1.281E-01, 1.278E-01, 1.275E-01, 1.272E-01, 1.269E-01, 1.266E-01, 1.263E-01,
                1.260E-01, 1.262E-01, 1.264E-01, 1.266E-01, 1.268E-01, 1.270E-01, 1.272E-01, 1.274E-01, 1.276E-01, 1.278E-01,
                1.280E-01, 1.282E-01, 1.284E-01, 1.286E-01, 1.288E-01, 1.290E-01, 1.292E-01, 1.294E-01, 1.296E-01, 1.298E-01,
                1.300E-01, 1.301E-01, 1.301E-01, 1.302E-01, 1.302E-01, 1.303E-01, 1.303E-01, 1.304E-01, 1.304E-01, 1.305E-01,
                1.305E-01, 1.306E-01, 1.306E-01, 1.307E-01, 1.307E-01, 1.308E-01, 1.308E-01, 1.309E-01, 1.309E-01, 1.310E-01,
                1.310E-01, 1.301E-01, 1.292E-01, 1.283E-01, 1.274E-01, 1.265E-01, 1.256E-01, 1.247E-01, 1.238E-01, 1.229E-01,
                1.220E-01, 1.211E-01, 1.202E-01, 1.193E-01, 1.184E-01, 1.175E-01, 1.166E-01, 1.157E-01, 1.148E-01, 1.139E-01,
                1.130E-01, 1.129E-01, 1.127E-01, 1.126E-01, 1.124E-01, 1.123E-01, 1.121E-01, 1.120E-01, 1.118E-01, 1.117E-01,
                1.115E-01, 1.114E-01, 1.112E-01, 1.111E-01, 1.109E-01, 1.108E-01, 1.106E-01, 1.105E-01, 1.103E-01, 1.102E-01,
                1.100E-01, 1.094E-01, 1.087E-01, 1.081E-01, 1.074E-01, 1.068E-01, 1.061E-01, 1.055E-01, 1.048E-01, 1.042E-01,
                1.035E-01, 1.029E-01, 1.022E-01, 1.016E-01, 1.009E-01, 1.003E-01, 9.960E-02, 9.895E-02, 9.830E-02, 9.765E-02,
                9.700E-02, 9.775E-02, 9.850E-02, 9.925E-02, 1.000E-01, 1.008E-01, 1.015E-01, 1.023E-01, 1.030E-01, 1.038E-01,
                1.045E-01, 1.053E-01, 1.060E-01, 1.068E-01, 1.075E-01, 1.083E-01, 1.090E-01, 1.098E-01, 1.105E-01, 1.113E-01,
                1.120E-01, 1.118E-01, 1.115E-01, 1.113E-01, 1.110E-01, 1.108E-01, 1.105E-01, 1.103E-01, 1.100E-01, 1.098E-01,
                1.095E-01, 1.093E-01, 1.090E-01, 1.088E-01, 1.085E-01, 1.083E-01, 1.080E-01, 1.078E-01, 1.075E-01, 1.073E-01,
                1.070E-01, 1.065E-01, 1.059E-01, 1.054E-01, 1.048E-01, 1.043E-01, 1.037E-01, 1.032E-01, 1.026E-01, 1.021E-01,
                1.015E-01, 1.010E-01, 1.004E-01, 9.985E-02, 9.930E-02, 9.875E-02, 9.820E-02, 9.765E-02, 9.710E-02, 9.655E-02,
                9.600E-02, 9.590E-02, 9.580E-02, 9.570E-02, 9.560E-02, 9.550E-02, 9.540E-02, 9.530E-02, 9.520E-02, 9.510E-02,
                9.500E-02, 9.490E-02, 9.480E-02, 9.470E-02, 9.460E-02, 9.450E-02, 9.440E-02, 9.430E-02, 9.420E-02, 9.410E-02,
                9.400E-02, 9.355E-02, 9.310E-02, 9.265E-02, 9.220E-02, 9.175E-02, 9.130E-02, 9.085E-02, 9.040E-02, 8.995E-02,
                8.950E-02, 8.905E-02, 8.860E-02, 8.815E-02, 8.770E-02, 8.725E-02, 8.680E-02, 8.635E-02, 8.590E-02, 8.545E-02,
                8.500E-02, 8.430E-02, 8.360E-02, 8.290E-02, 8.220E-02, 8.150E-02, 8.080E-02, 8.010E-02, 7.940E-02, 7.870E-02,
                7.800E-02, 7.730E-02, 7.660E-02, 7.590E-02, 7.520E-02, 7.450E-02, 7.380E-02, 7.310E-02, 7.240E-02, 7.170E-02,
                7.100E-02, 7.105E-02, 7.110E-02, 7.115E-02, 7.120E-02, 7.125E-02, 7.130E-02, 7.135E-02, 7.140E-02, 7.145E-02,
                7.150E-02, 7.155E-02, 7.160E-02, 7.165E-02, 7.170E-02, 7.175E-02, 7.180E-02, 7.185E-02, 7.190E-02, 7.195E-02,
                7.200E-02, 7.195E-02, 7.190E-02, 7.185E-02, 7.180E-02, 7.175E-02, 7.170E-02, 7.165E-02, 7.160E-02, 7.155E-02,
                7.150E-02, 7.145E-02, 7.140E-02, 7.135E-02, 7.130E-02, 7.125E-02, 7.120E-02, 7.115E-02, 7.110E-02, 7.105E-02,
                7.100E-02, 7.025E-02, 6.950E-02, 6.875E-02, 6.800E-02, 6.725E-02, 6.650E-02, 6.575E-02, 6.500E-02, 6.425E-02,
                6.350E-02, 6.275E-02, 6.200E-02, 6.125E-02, 6.050E-02, 5.975E-02, 5.900E-02, 5.825E-02, 5.750E-02, 5.675E-02,
                5.600E-02, 5.685E-02, 5.770E-02, 5.855E-02, 5.940E-02, 6.025E-02, 6.110E-02, 6.195E-02, 6.280E-02, 6.365E-02,
                6.450E-02, 6.535E-02, 6.620E-02, 6.705E-02, 6.790E-02, 6.875E-02, 6.960E-02, 7.045E-02, 7.130E-02, 7.215E-02,
                7.300E-02, 7.085E-02, 6.870E-02, 6.655E-02, 6.440E-02, 6.225E-02, 6.010E-02, 5.795E-02, 5.580E-02, 5.365E-02,
                5.150E-02, 4.935E-02, 4.720E-02, 4.505E-02, 4.290E-02, 4.075E-02, 3.860E-02, 3.645E-02, 3.430E-02, 3.215E-02,
                3.000E-02, 3.195E-02, 3.390E-02, 3.585E-02, 3.780E-02, 3.975E-02, 4.170E-02, 4.365E-02, 4.560E-02, 4.755E-02,
                4.950E-02, 5.145E-02, 5.340E-02, 5.535E-02, 5.730E-02, 5.925E-02, 6.120E-02, 6.315E-02, 6.510E-02, 6.705E-02,
                6.900E-02, 6.755E-02, 6.610E-02, 6.465E-02, 6.320E-02, 6.175E-02, 6.030E-02, 5.885E-02, 5.740E-02, 5.595E-02,
                5.450E-02, 5.305E-02, 5.160E-02, 5.015E-02, 4.870E-02, 4.725E-02, 4.580E-02, 4.435E-02, 4.290E-02, 4.145E-02,
                4.000E-02, 3.960E-02, 3.920E-02, 3.880E-02, 3.840E-02, 3.800E-02, 3.760E-02, 3.720E-02, 3.680E-02, 3.640E-02,
                3.600E-02, 3.560E-02, 3.520E-02, 3.480E-02, 3.440E-02, 3.400E-02, 3.360E-02, 3.320E-02, 3.280E-02, 3.240E-02,
                3.200E-02, 3.110E-02, 3.020E-02, 2.930E-02, 2.840E-02, 2.750E-02, 2.660E-02, 2.570E-02, 2.480E-02, 2.390E-02,
                2.300E-02, 2.210E-02, 2.120E-02, 2.030E-02, 1.940E-02, 1.850E-02, 1.760E-02, 1.670E-02, 1.580E-02, 1.490E-02,
                1.400E-02])

# Diffuse Energy from the Sun

Ed = np.array([2.413E+00, 2.413E+00, 2.414E+00, 2.414E+00, 2.414E+00, 2.415E+00, 2.415E+00, 2.415E+00, 2.415E+00, 2.416E+00, 
                2.416E+00, 2.416E+00, 2.417E+00, 2.417E+00, 2.417E+00, 2.418E+00, 2.418E+00, 2.418E+00, 2.418E+00, 2.419E+00,
                2.419E+00, 2.418E+00, 2.417E+00, 2.416E+00, 2.415E+00, 2.414E+00, 2.413E+00, 2.412E+00, 2.411E+00, 2.410E+00,
                2.410E+00, 2.409E+00, 2.408E+00, 2.407E+00, 2.406E+00, 2.405E+00, 2.404E+00, 2.403E+00, 2.402E+00, 2.401E+00,
                2.400E+00, 2.412E+00, 2.424E+00, 2.435E+00, 2.447E+00, 2.459E+00, 2.471E+00, 2.483E+00, 2.494E+00, 2.506E+00,
                2.518E+00, 2.530E+00, 2.542E+00, 2.553E+00, 2.565E+00, 2.577E+00, 2.589E+00, 2.601E+00, 2.612E+00, 2.624E+00,
                2.636E+00, 2.634E+00, 2.632E+00, 2.630E+00, 2.628E+00, 2.626E+00, 2.623E+00, 2.621E+00, 2.619E+00, 2.617E+00,
                2.615E+00, 2.613E+00, 2.611E+00, 2.609E+00, 2.607E+00, 2.605E+00, 2.602E+00, 2.600E+00, 2.598E+00, 2.596E+00,
                2.594E+00, 2.579E+00, 2.565E+00, 2.550E+00, 2.535E+00, 2.521E+00, 2.506E+00, 2.491E+00, 2.477E+00, 2.462E+00,
                2.448E+00, 2.433E+00, 2.418E+00, 2.404E+00, 2.389E+00, 2.374E+00, 2.360E+00, 2.345E+00, 2.330E+00, 2.316E+00,
                2.301E+00, 2.290E+00, 2.279E+00, 2.268E+00, 2.257E+00, 2.246E+00, 2.234E+00, 2.223E+00, 2.212E+00, 2.201E+00,
                2.190E+00, 2.179E+00, 2.168E+00, 2.157E+00, 2.146E+00, 2.135E+00, 2.123E+00, 2.112E+00, 2.101E+00, 2.090E+00,
                2.079E+00, 2.076E+00, 2.073E+00, 2.070E+00, 2.067E+00, 2.064E+00, 2.061E+00, 2.058E+00, 2.055E+00, 2.052E+00,
                2.049E+00, 2.045E+00, 2.042E+00, 2.039E+00, 2.036E+00, 2.033E+00, 2.030E+00, 2.027E+00, 2.024E+00, 2.021E+00,
                2.018E+00, 2.011E+00, 2.004E+00, 1.997E+00, 1.990E+00, 1.983E+00, 1.975E+00, 1.968E+00, 1.961E+00, 1.954E+00,
                1.947E+00, 1.940E+00, 1.933E+00, 1.926E+00, 1.919E+00, 1.912E+00, 1.904E+00, 1.897E+00, 1.890E+00, 1.883E+00,
                1.876E+00, 1.871E+00, 1.867E+00, 1.862E+00, 1.857E+00, 1.852E+00, 1.848E+00, 1.843E+00, 1.838E+00, 1.833E+00,
                1.829E+00, 1.824E+00, 1.819E+00, 1.814E+00, 1.810E+00, 1.805E+00, 1.800E+00, 1.795E+00, 1.791E+00, 1.786E+00,
                1.781E+00, 1.774E+00, 1.767E+00, 1.760E+00, 1.752E+00, 1.745E+00, 1.738E+00, 1.731E+00, 1.724E+00, 1.717E+00,
                1.710E+00, 1.702E+00, 1.695E+00, 1.688E+00, 1.681E+00, 1.674E+00, 1.667E+00, 1.659E+00, 1.652E+00, 1.645E+00,
                1.638E+00, 1.635E+00, 1.631E+00, 1.628E+00, 1.624E+00, 1.621E+00, 1.617E+00, 1.614E+00, 1.610E+00, 1.607E+00,
                1.604E+00, 1.600E+00, 1.597E+00, 1.593E+00, 1.590E+00, 1.586E+00, 1.583E+00, 1.579E+00, 1.576E+00, 1.572E+00,
                1.569E+00, 1.564E+00, 1.560E+00, 1.555E+00, 1.550E+00, 1.546E+00, 1.541E+00, 1.536E+00, 1.532E+00, 1.527E+00,
                1.523E+00, 1.518E+00, 1.513E+00, 1.509E+00, 1.504E+00, 1.499E+00, 1.495E+00, 1.490E+00, 1.485E+00, 1.481E+00,
                1.476E+00, 1.470E+00, 1.464E+00, 1.458E+00, 1.451E+00, 1.445E+00, 1.439E+00, 1.433E+00, 1.427E+00, 1.421E+00,
                1.415E+00, 1.408E+00, 1.402E+00, 1.396E+00, 1.390E+00, 1.384E+00, 1.378E+00, 1.371E+00, 1.365E+00, 1.359E+00,
                1.353E+00, 1.350E+00, 1.347E+00, 1.344E+00, 1.340E+00, 1.337E+00, 1.334E+00, 1.331E+00, 1.328E+00, 1.325E+00,
                1.322E+00, 1.318E+00, 1.315E+00, 1.312E+00, 1.309E+00, 1.306E+00, 1.303E+00, 1.299E+00, 1.296E+00, 1.293E+00,
                1.290E+00, 1.281E+00, 1.271E+00, 1.262E+00, 1.253E+00, 1.243E+00, 1.234E+00, 1.225E+00, 1.215E+00, 1.206E+00,
                1.197E+00, 1.187E+00, 1.178E+00, 1.168E+00, 1.159E+00, 1.150E+00, 1.140E+00, 1.131E+00, 1.122E+00, 1.112E+00,
                1.103E+00, 1.085E+00, 1.068E+00, 1.050E+00, 1.032E+00, 1.014E+00, 9.965E-01, 9.788E-01, 9.610E-01, 9.433E-01,
                9.255E-01, 9.078E-01, 8.900E-01, 8.723E-01, 8.545E-01, 8.368E-01, 8.190E-01, 8.013E-01, 7.835E-01, 7.658E-01,
                7.480E-01, 7.579E-01, 7.677E-01, 7.776E-01, 7.874E-01, 7.973E-01, 8.071E-01, 8.170E-01, 8.268E-01, 8.367E-01,
                8.465E-01, 8.564E-01, 8.662E-01, 8.761E-01, 8.859E-01, 8.958E-01, 9.056E-01, 9.155E-01, 9.253E-01, 9.352E-01,
                9.450E-01, 9.114E-01, 8.777E-01, 8.441E-01, 8.104E-01, 7.768E-01, 7.431E-01, 7.095E-01, 6.758E-01, 6.422E-01,
                6.085E-01, 5.749E-01, 5.412E-01, 5.076E-01, 4.739E-01, 4.403E-01, 4.066E-01, 3.730E-01, 3.393E-01, 3.057E-01,
                2.720E-01, 3.015E-01, 3.310E-01, 3.605E-01, 3.900E-01, 4.195E-01, 4.490E-01, 4.785E-01, 5.080E-01, 5.375E-01,
                5.670E-01, 5.965E-01, 6.260E-01, 6.555E-01, 6.850E-01, 7.145E-01, 7.440E-01, 7.735E-01, 8.030E-01, 8.325E-01,
                8.620E-01, 8.586E-01, 8.552E-01, 8.518E-01, 8.484E-01, 8.450E-01, 8.416E-01, 8.382E-01, 8.348E-01, 8.314E-01,
                8.280E-01, 8.246E-01, 8.212E-01, 8.178E-01, 8.144E-01, 8.110E-01, 8.076E-01, 8.042E-01, 8.008E-01, 7.974E-01,
                7.940E-01, 7.840E-01, 7.739E-01, 7.639E-01, 7.538E-01, 7.438E-01, 7.337E-01, 7.237E-01, 7.136E-01, 7.036E-01,
                6.935E-01, 6.835E-01, 6.734E-01, 6.634E-01, 6.533E-01, 6.433E-01, 6.332E-01, 6.232E-01, 6.131E-01, 6.031E-01,
                5.930E-01, 5.972E-01, 6.013E-01, 6.055E-01, 6.096E-01, 6.138E-01, 6.179E-01, 6.221E-01, 6.262E-01, 6.304E-01,
                6.345E-01, 6.387E-01, 6.428E-01, 6.470E-01, 6.511E-01, 6.553E-01, 6.594E-01, 6.636E-01, 6.677E-01, 6.719E-01,
                6.760E-01, 6.752E-01, 6.744E-01, 6.736E-01, 6.728E-01, 6.720E-01, 6.712E-01, 6.704E-01, 6.696E-01, 6.688E-01,
                6.680E-01, 6.672E-01, 6.664E-01, 6.656E-01, 6.648E-01, 6.640E-01, 6.632E-01, 6.624E-01, 6.616E-01, 6.608E-01,
                6.600E-01, 6.580E-01, 6.560E-01, 6.540E-01, 6.520E-01, 6.500E-01, 6.480E-01, 6.460E-01, 6.440E-01, 6.420E-01,
                6.400E-01, 6.380E-01, 6.360E-01, 6.340E-01, 6.320E-01, 6.300E-01, 6.280E-01, 6.260E-01, 6.240E-01, 6.220E-01,
                6.200E-01, 6.094E-01, 5.988E-01, 5.882E-01, 5.776E-01, 5.670E-01, 5.564E-01, 5.458E-01, 5.352E-01, 5.246E-01,
                5.140E-01, 5.034E-01, 4.928E-01, 4.822E-01, 4.716E-01, 4.610E-01, 4.504E-01, 4.398E-01, 4.292E-01, 4.186E-01,
                4.080E-01, 4.130E-01, 4.179E-01, 4.229E-01, 4.278E-01, 4.328E-01, 4.377E-01, 4.427E-01, 4.476E-01, 4.526E-01,
                4.575E-01, 4.625E-01, 4.674E-01, 4.724E-01, 4.773E-01, 4.823E-01, 4.872E-01, 4.922E-01, 4.971E-01, 5.021E-01,
                5.070E-01, 4.948E-01, 4.826E-01, 4.704E-01, 4.582E-01, 4.460E-01, 4.338E-01, 4.216E-01, 4.094E-01, 3.972E-01,
                3.850E-01, 3.728E-01, 3.606E-01, 3.484E-01, 3.362E-01, 3.240E-01, 3.118E-01, 2.996E-01, 2.874E-01, 2.752E-01,
                2.630E-01, 2.621E-01, 2.611E-01, 2.602E-01, 2.592E-01, 2.583E-01, 2.573E-01, 2.564E-01, 2.554E-01, 2.545E-01,
                2.535E-01, 2.526E-01, 2.516E-01, 2.507E-01, 2.497E-01, 2.488E-01, 2.478E-01, 2.469E-01, 2.459E-01, 2.450E-01,
                2.440E-01, 2.484E-01, 2.528E-01, 2.572E-01, 2.616E-01, 2.660E-01, 2.704E-01, 2.748E-01, 2.792E-01, 2.836E-01,
                2.880E-01, 2.924E-01, 2.968E-01, 3.012E-01, 3.056E-01, 3.100E-01, 3.144E-01, 3.188E-01, 3.232E-01, 3.276E-01,
                3.320E-01, 3.344E-01, 3.368E-01, 3.392E-01, 3.416E-01, 3.440E-01, 3.464E-01, 3.488E-01, 3.512E-01, 3.536E-01,
                3.560E-01, 3.584E-01, 3.608E-01, 3.632E-01, 3.656E-01, 3.680E-01, 3.704E-01, 3.728E-01, 3.752E-01, 3.776E-01,
                3.800E-01, 3.786E-01, 3.771E-01, 3.757E-01, 3.742E-01, 3.728E-01, 3.713E-01, 3.699E-01, 3.684E-01, 3.670E-01,
                3.655E-01, 3.641E-01, 3.626E-01, 3.612E-01, 3.597E-01, 3.583E-01, 3.568E-01, 3.554E-01, 3.539E-01, 3.525E-01,
                3.510E-01, 3.499E-01, 3.487E-01, 3.476E-01, 3.464E-01, 3.453E-01, 3.441E-01, 3.430E-01, 3.418E-01, 3.407E-01,
                3.395E-01, 3.384E-01, 3.372E-01, 3.361E-01, 3.349E-01, 3.338E-01, 3.326E-01, 3.315E-01, 3.303E-01, 3.292E-01,
                3.280E-01, 3.268E-01, 3.256E-01, 3.244E-01, 3.232E-01, 3.220E-01, 3.208E-01, 3.196E-01, 3.184E-01, 3.172E-01,
                3.160E-01, 3.148E-01, 3.136E-01, 3.124E-01, 3.112E-01, 3.100E-01, 3.088E-01, 3.076E-01, 3.064E-01, 3.052E-01,
                3.040E-01, 3.023E-01, 3.006E-01, 2.989E-01, 2.972E-01, 2.955E-01, 2.938E-01, 2.921E-01, 2.904E-01, 2.887E-01,
                2.870E-01, 2.853E-01, 2.836E-01, 2.819E-01, 2.802E-01, 2.785E-01, 2.768E-01, 2.751E-01, 2.734E-01, 2.717E-01,
                2.700E-01, 2.687E-01, 2.674E-01, 2.661E-01, 2.648E-01, 2.635E-01, 2.622E-01, 2.609E-01, 2.596E-01, 2.583E-01,
                2.570E-01, 2.557E-01, 2.544E-01, 2.531E-01, 2.518E-01, 2.505E-01, 2.492E-01, 2.479E-01, 2.466E-01, 2.453E-01,
                2.440E-01, 2.356E-01, 2.271E-01, 2.187E-01, 2.102E-01, 2.018E-01, 1.933E-01, 1.849E-01, 1.764E-01, 1.680E-01,
                1.595E-01, 1.511E-01, 1.426E-01, 1.342E-01, 1.257E-01, 1.173E-01, 1.088E-01, 1.004E-01, 9.190E-02, 8.345E-02,
                7.500E-02, 7.790E-02, 8.080E-02, 8.370E-02, 8.660E-02, 8.950E-02, 9.240E-02, 9.530E-02, 9.820E-02, 1.011E-01,
                1.040E-01, 1.069E-01, 1.098E-01, 1.127E-01, 1.156E-01, 1.185E-01, 1.214E-01, 1.243E-01, 1.272E-01, 1.301E-01,
                1.330E-01, 1.328E-01, 1.326E-01, 1.324E-01, 1.322E-01, 1.320E-01, 1.318E-01, 1.316E-01, 1.314E-01, 1.312E-01,
                1.310E-01, 1.308E-01, 1.306E-01, 1.304E-01, 1.302E-01, 1.300E-01, 1.298E-01, 1.296E-01, 1.294E-01, 1.292E-01,
                1.290E-01, 1.314E-01, 1.337E-01, 1.361E-01, 1.384E-01, 1.408E-01, 1.431E-01, 1.455E-01, 1.478E-01, 1.502E-01,
                1.525E-01, 1.549E-01, 1.572E-01, 1.596E-01, 1.619E-01, 1.643E-01, 1.666E-01, 1.690E-01, 1.713E-01, 1.737E-01,
                1.760E-01, 1.757E-01, 1.754E-01, 1.751E-01, 1.748E-01, 1.745E-01, 1.742E-01, 1.739E-01, 1.736E-01, 1.733E-01,
                1.730E-01, 1.727E-01, 1.724E-01, 1.721E-01, 1.718E-01, 1.715E-01, 1.712E-01, 1.709E-01, 1.706E-01, 1.703E-01,
                1.700E-01, 1.707E-01, 1.713E-01, 1.720E-01, 1.726E-01, 1.733E-01, 1.739E-01, 1.746E-01, 1.752E-01, 1.759E-01,
                1.765E-01, 1.772E-01, 1.778E-01, 1.785E-01, 1.791E-01, 1.798E-01, 1.804E-01, 1.811E-01, 1.817E-01, 1.824E-01,
                1.830E-01, 1.826E-01, 1.822E-01, 1.818E-01, 1.814E-01, 1.810E-01, 1.806E-01, 1.802E-01, 1.798E-01, 1.794E-01,
                1.790E-01, 1.786E-01, 1.782E-01, 1.778E-01, 1.774E-01, 1.770E-01, 1.766E-01, 1.762E-01, 1.758E-01, 1.754E-01,
                1.750E-01, 1.742E-01, 1.734E-01, 1.726E-01, 1.718E-01, 1.710E-01, 1.702E-01, 1.694E-01, 1.686E-01, 1.678E-01,
                1.670E-01, 1.662E-01, 1.654E-01, 1.646E-01, 1.638E-01, 1.630E-01, 1.622E-01, 1.614E-01, 1.606E-01, 1.598E-01,
                1.590E-01, 1.585E-01, 1.579E-01, 1.574E-01, 1.568E-01, 1.563E-01, 1.557E-01, 1.552E-01, 1.546E-01, 1.541E-01,
                1.535E-01, 1.530E-01, 1.524E-01, 1.519E-01, 1.513E-01, 1.508E-01, 1.502E-01, 1.497E-01, 1.491E-01, 1.486E-01,
                1.480E-01, 1.472E-01, 1.463E-01, 1.455E-01, 1.446E-01, 1.438E-01, 1.429E-01, 1.421E-01, 1.412E-01, 1.404E-01,
                1.395E-01, 1.387E-01, 1.378E-01, 1.370E-01, 1.361E-01, 1.353E-01, 1.344E-01, 1.336E-01, 1.327E-01, 1.319E-01,
                1.310E-01, 1.291E-01, 1.271E-01, 1.252E-01, 1.232E-01, 1.213E-01, 1.193E-01, 1.174E-01, 1.154E-01, 1.135E-01,
                1.115E-01, 1.096E-01, 1.076E-01, 1.057E-01, 1.037E-01, 1.018E-01, 9.980E-02, 9.785E-02, 9.590E-02, 9.395E-02,
                9.200E-02, 9.110E-02, 9.020E-02, 8.930E-02, 8.840E-02, 8.750E-02, 8.660E-02, 8.570E-02, 8.480E-02, 8.390E-02,
                8.300E-02, 8.210E-02, 8.120E-02, 8.030E-02, 7.940E-02, 7.850E-02, 7.760E-02, 7.670E-02, 7.580E-02, 7.490E-02,
                7.400E-02, 7.040E-02, 6.680E-02, 6.320E-02, 5.960E-02, 5.600E-02, 5.240E-02, 4.880E-02, 4.520E-02, 4.160E-02,
                3.800E-02, 3.440E-02, 3.080E-02, 2.720E-02, 2.360E-02, 2.000E-02, 1.640E-02, 1.280E-02, 9.200E-03, 5.600E-03,
                2.000E-03, 1.950E-03, 1.900E-03, 1.850E-03, 1.800E-03, 1.750E-03, 1.700E-03, 1.650E-03, 1.600E-03, 1.550E-03,
                1.500E-03, 1.450E-03, 1.400E-03, 1.350E-03, 1.300E-03, 1.250E-03, 1.200E-03, 1.150E-03, 1.100E-03, 1.050E-03,
                1.000E-03, 1.250E-03, 1.500E-03, 1.750E-03, 2.000E-03, 2.250E-03, 2.500E-03, 2.750E-03, 3.000E-03, 3.250E-03,
                3.500E-03, 3.750E-03, 4.000E-03, 4.250E-03, 4.500E-03, 4.750E-03, 5.000E-03, 5.250E-03, 5.500E-03, 5.750E-03,
                6.000E-03, 5.950E-03, 5.900E-03, 5.850E-03, 5.800E-03, 5.750E-03, 5.700E-03, 5.650E-03, 5.600E-03, 5.550E-03,
                5.500E-03, 5.450E-03, 5.400E-03, 5.350E-03, 5.300E-03, 5.250E-03, 5.200E-03, 5.150E-03, 5.100E-03, 5.050E-03,
                5.000E-03, 5.450E-03, 5.900E-03, 6.350E-03, 6.800E-03, 7.250E-03, 7.700E-03, 8.150E-03, 8.600E-03, 9.050E-03,
                9.500E-03, 9.950E-03, 1.040E-02, 1.085E-02, 1.130E-02, 1.175E-02, 1.220E-02, 1.265E-02, 1.310E-02, 1.355E-02,
                1.400E-02, 1.505E-02, 1.610E-02, 1.715E-02, 1.820E-02, 1.925E-02, 2.030E-02, 2.135E-02, 2.240E-02, 2.345E-02,
                2.450E-02, 2.555E-02, 2.660E-02, 2.765E-02, 2.870E-02, 2.975E-02, 3.080E-02, 3.185E-02, 3.290E-02, 3.395E-02,
                3.500E-02, 3.495E-02, 3.490E-02, 3.485E-02, 3.480E-02, 3.475E-02, 3.470E-02, 3.465E-02, 3.460E-02, 3.455E-02,
                3.450E-02, 3.445E-02, 3.440E-02, 3.435E-02, 3.430E-02, 3.425E-02, 3.420E-02, 3.415E-02, 3.410E-02, 3.405E-02,
                3.400E-02, 3.690E-02, 3.980E-02, 4.270E-02, 4.560E-02, 4.850E-02, 5.140E-02, 5.430E-02, 5.720E-02, 6.010E-02,
                6.300E-02, 6.590E-02, 6.880E-02, 7.170E-02, 7.460E-02, 7.750E-02, 8.040E-02, 8.330E-02, 8.620E-02, 8.910E-02,
                9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02,
                9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02, 9.200E-02,
                9.200E-02, 9.210E-02, 9.220E-02, 9.230E-02, 9.240E-02, 9.250E-02, 9.260E-02, 9.270E-02, 9.280E-02, 9.290E-02,
                9.300E-02, 9.310E-02, 9.320E-02, 9.330E-02, 9.340E-02, 9.350E-02, 9.360E-02, 9.370E-02, 9.380E-02, 9.390E-02,
                9.400E-02, 9.390E-02, 9.380E-02, 9.370E-02, 9.360E-02, 9.350E-02, 9.340E-02, 9.330E-02, 9.320E-02, 9.310E-02,
                9.300E-02, 9.290E-02, 9.280E-02, 9.270E-02, 9.260E-02, 9.250E-02, 9.240E-02, 9.230E-02, 9.220E-02, 9.210E-02,
                9.200E-02, 9.155E-02, 9.110E-02, 9.065E-02, 9.020E-02, 8.975E-02, 8.930E-02, 8.885E-02, 8.840E-02, 8.795E-02,
                8.750E-02, 8.705E-02, 8.660E-02, 8.615E-02, 8.570E-02, 8.525E-02, 8.480E-02, 8.435E-02, 8.390E-02, 8.345E-02,
                8.300E-02, 8.290E-02, 8.280E-02, 8.270E-02, 8.260E-02, 8.250E-02, 8.240E-02, 8.230E-02, 8.220E-02, 8.210E-02,
                8.200E-02, 8.190E-02, 8.180E-02, 8.170E-02, 8.160E-02, 8.150E-02, 8.140E-02, 8.130E-02, 8.120E-02, 8.110E-02,
                8.100E-02, 8.085E-02, 8.070E-02, 8.055E-02, 8.040E-02, 8.025E-02, 8.010E-02, 7.995E-02, 7.980E-02, 7.965E-02,
                7.950E-02, 7.935E-02, 7.920E-02, 7.905E-02, 7.890E-02, 7.875E-02, 7.860E-02, 7.845E-02, 7.830E-02, 7.815E-02,
                7.800E-02, 7.770E-02, 7.740E-02, 7.710E-02, 7.680E-02, 7.650E-02, 7.620E-02, 7.590E-02, 7.560E-02, 7.530E-02,
                7.500E-02, 7.470E-02, 7.440E-02, 7.410E-02, 7.380E-02, 7.350E-02, 7.320E-02, 7.290E-02, 7.260E-02, 7.230E-02,
                7.200E-02, 7.190E-02, 7.180E-02, 7.170E-02, 7.160E-02, 7.150E-02, 7.140E-02, 7.130E-02, 7.120E-02, 7.110E-02,
                7.100E-02, 7.090E-02, 7.080E-02, 7.070E-02, 7.060E-02, 7.050E-02, 7.040E-02, 7.030E-02, 7.020E-02, 7.010E-02,
                7.000E-02, 6.975E-02, 6.950E-02, 6.925E-02, 6.900E-02, 6.875E-02, 6.850E-02, 6.825E-02, 6.800E-02, 6.775E-02,
                6.750E-02, 6.725E-02, 6.700E-02, 6.675E-02, 6.650E-02, 6.625E-02, 6.600E-02, 6.575E-02, 6.550E-02, 6.525E-02,
                6.500E-02, 6.480E-02, 6.460E-02, 6.440E-02, 6.420E-02, 6.400E-02, 6.380E-02, 6.360E-02, 6.340E-02, 6.320E-02,
                6.300E-02, 6.280E-02, 6.260E-02, 6.240E-02, 6.220E-02, 6.200E-02, 6.180E-02, 6.160E-02, 6.140E-02, 6.120E-02,
                6.100E-02, 6.090E-02, 6.080E-02, 6.070E-02, 6.060E-02, 6.050E-02, 6.040E-02, 6.030E-02, 6.020E-02, 6.010E-02,
                6.000E-02, 5.990E-02, 5.980E-02, 5.970E-02, 5.960E-02, 5.950E-02, 5.940E-02, 5.930E-02, 5.920E-02, 5.910E-02,
                5.900E-02, 5.830E-02, 5.760E-02, 5.690E-02, 5.620E-02, 5.550E-02, 5.480E-02, 5.410E-02, 5.340E-02, 5.270E-02,
                5.200E-02, 5.130E-02, 5.060E-02, 4.990E-02, 4.920E-02, 4.850E-02, 4.780E-02, 4.710E-02, 4.640E-02, 4.570E-02,
                4.500E-02, 4.535E-02, 4.570E-02, 4.605E-02, 4.640E-02, 4.675E-02, 4.710E-02, 4.745E-02, 4.780E-02, 4.815E-02,
                4.850E-02, 4.885E-02, 4.920E-02, 4.955E-02, 4.990E-02, 5.025E-02, 5.060E-02, 5.095E-02, 5.130E-02, 5.165E-02,
                5.200E-02, 5.085E-02, 4.970E-02, 4.855E-02, 4.740E-02, 4.625E-02, 4.510E-02, 4.395E-02, 4.280E-02, 4.165E-02,
                4.050E-02, 3.935E-02, 3.820E-02, 3.705E-02, 3.590E-02, 3.475E-02, 3.360E-02, 3.245E-02, 3.130E-02, 3.015E-02,
                2.900E-02, 2.790E-02, 2.680E-02, 2.570E-02, 2.460E-02, 2.350E-02, 2.240E-02, 2.130E-02, 2.020E-02, 1.910E-02,
                1.800E-02, 1.690E-02, 1.580E-02, 1.470E-02, 1.360E-02, 1.250E-02, 1.140E-02, 1.030E-02, 9.200E-03, 8.100E-03,
                7.000E-03, 6.700E-03, 6.400E-03, 6.100E-03, 5.800E-03, 5.500E-03, 5.200E-03, 4.900E-03, 4.600E-03, 4.300E-03,
                4.000E-03, 3.700E-03, 3.400E-03, 3.100E-03, 2.800E-03, 2.500E-03, 2.200E-03, 1.900E-03, 1.600E-03, 1.300E-03,
                1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03,
                1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03, 1.000E-03,
                1.000E-03, 9.500E-04, 9.000E-04, 8.500E-04, 8.000E-04, 7.500E-04, 7.000E-04, 6.500E-04, 6.000E-04, 5.500E-04,
                5.000E-04, 4.500E-04, 4.000E-04, 3.500E-04, 3.000E-04, 2.500E-04, 2.000E-04, 1.500E-04, 1.000E-04, 5.000E-05,
                0.335E-17, 2.000E-04, 4.000E-04, 6.000E-04, 8.000E-04, 1.000E-03, 1.200E-03, 1.400E-03, 1.600E-03, 1.800E-03,
                2.000E-03, 2.200E-03, 2.400E-03, 2.600E-03, 2.800E-03, 3.000E-03, 3.200E-03, 3.400E-03, 3.600E-03, 3.800E-03,
                4.000E-03, 3.800E-03, 3.600E-03, 3.400E-03, 3.200E-03, 3.000E-03, 2.800E-03, 2.600E-03, 2.400E-03, 2.200E-03,
                2.000E-03, 1.800E-03, 1.600E-03, 1.400E-03, 1.200E-03, 1.000E-03, 8.000E-04, 6.000E-04, 4.000E-04, 2.000E-04,
                0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
                0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
                0.000E+00, 5.000E-05, 1.000E-04, 1.500E-04, 2.000E-04, 2.500E-04, 3.000E-04, 3.500E-04, 4.000E-04, 4.500E-04,
                5.000E-04, 5.500E-04, 6.000E-04, 6.500E-04, 7.000E-04, 7.500E-04, 8.000E-04, 8.500E-04, 9.000E-04, 9.500E-04,
                1.000E-03, 1.200E-03, 1.400E-03, 1.600E-03, 1.800E-03, 2.000E-03, 2.200E-03, 2.400E-03, 2.600E-03, 2.800E-03,
                3.000E-03, 3.200E-03, 3.400E-03, 3.600E-03, 3.800E-03, 4.000E-03, 4.200E-03, 4.400E-03, 4.600E-03, 4.800E-03,
                5.000E-03, 5.650E-03, 6.300E-03, 6.950E-03, 7.600E-03, 8.250E-03, 8.900E-03, 9.550E-03, 1.020E-02, 1.085E-02,
                1.150E-02, 1.215E-02, 1.280E-02, 1.345E-02, 1.410E-02, 1.475E-02, 1.540E-02, 1.605E-02, 1.670E-02, 1.735E-02,
                1.800E-02, 1.785E-02, 1.770E-02, 1.755E-02, 1.740E-02, 1.725E-02, 1.710E-02, 1.695E-02, 1.680E-02, 1.665E-02,
                1.650E-02, 1.635E-02, 1.620E-02, 1.605E-02, 1.590E-02, 1.575E-02, 1.560E-02, 1.545E-02, 1.530E-02, 1.515E-02,
                1.500E-02, 1.465E-02, 1.430E-02, 1.395E-02, 1.360E-02, 1.325E-02, 1.290E-02, 1.255E-02, 1.220E-02, 1.185E-02,
                1.150E-02, 1.115E-02, 1.080E-02, 1.045E-02, 1.010E-02, 9.750E-03, 9.400E-03, 9.050E-03, 8.700E-03, 8.350E-03,
                8.000E-03, 8.800E-03, 9.600E-03, 1.040E-02, 1.120E-02, 1.200E-02, 1.280E-02, 1.360E-02, 1.440E-02, 1.520E-02,
                1.600E-02, 1.680E-02, 1.760E-02, 1.840E-02, 1.920E-02, 2.000E-02, 2.080E-02, 2.160E-02, 2.240E-02, 2.320E-02,
                2.400E-02, 2.370E-02, 2.340E-02, 2.310E-02, 2.280E-02, 2.250E-02, 2.220E-02, 2.190E-02, 2.160E-02, 2.130E-02,
                2.100E-02, 2.070E-02, 2.040E-02, 2.010E-02, 1.980E-02, 1.950E-02, 1.920E-02, 1.890E-02, 1.860E-02, 1.830E-02,
                1.800E-02, 1.825E-02, 1.850E-02, 1.875E-02, 1.900E-02, 1.925E-02, 1.950E-02, 1.975E-02, 2.000E-02, 2.025E-02,
                2.050E-02, 2.075E-02, 2.100E-02, 2.125E-02, 2.150E-02, 2.175E-02, 2.200E-02, 2.225E-02, 2.250E-02, 2.275E-02,
                2.300E-02, 2.290E-02, 2.280E-02, 2.270E-02, 2.260E-02, 2.250E-02, 2.240E-02, 2.230E-02, 2.220E-02, 2.210E-02,
                2.200E-02, 2.190E-02, 2.180E-02, 2.170E-02, 2.160E-02, 2.150E-02, 2.140E-02, 2.130E-02, 2.120E-02, 2.110E-02,
                2.100E-02, 2.105E-02, 2.110E-02, 2.115E-02, 2.120E-02, 2.125E-02, 2.130E-02, 2.135E-02, 2.140E-02, 2.145E-02,
                2.150E-02, 2.155E-02, 2.160E-02, 2.165E-02, 2.170E-02, 2.175E-02, 2.180E-02, 2.185E-02, 2.190E-02, 2.195E-02,
                2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02,
                2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02, 2.200E-02,
                2.200E-02, 2.185E-02, 2.170E-02, 2.155E-02, 2.140E-02, 2.125E-02, 2.110E-02, 2.095E-02, 2.080E-02, 2.065E-02,
                2.050E-02, 2.035E-02, 2.020E-02, 2.005E-02, 1.990E-02, 1.975E-02, 1.960E-02, 1.945E-02, 1.930E-02, 1.915E-02,
                1.900E-02, 1.895E-02, 1.890E-02, 1.885E-02, 1.880E-02, 1.875E-02, 1.870E-02, 1.865E-02, 1.860E-02, 1.855E-02,
                1.850E-02, 1.845E-02, 1.840E-02, 1.835E-02, 1.830E-02, 1.825E-02, 1.820E-02, 1.815E-02, 1.810E-02, 1.805E-02,
                1.800E-02, 1.790E-02, 1.780E-02, 1.770E-02, 1.760E-02, 1.750E-02, 1.740E-02, 1.730E-02, 1.720E-02, 1.710E-02,
                1.700E-02, 1.690E-02, 1.680E-02, 1.670E-02, 1.660E-02, 1.650E-02, 1.640E-02, 1.630E-02, 1.620E-02, 1.610E-02,
                1.600E-02, 1.610E-02, 1.620E-02, 1.630E-02, 1.640E-02, 1.650E-02, 1.660E-02, 1.670E-02, 1.680E-02, 1.690E-02,
                1.700E-02, 1.710E-02, 1.720E-02, 1.730E-02, 1.740E-02, 1.750E-02, 1.760E-02, 1.770E-02, 1.780E-02, 1.790E-02,
                1.800E-02, 1.795E-02, 1.790E-02, 1.785E-02, 1.780E-02, 1.775E-02, 1.770E-02, 1.765E-02, 1.760E-02, 1.755E-02,
                1.750E-02, 1.745E-02, 1.740E-02, 1.735E-02, 1.730E-02, 1.725E-02, 1.720E-02, 1.715E-02, 1.710E-02, 1.705E-02,
                1.700E-02, 1.695E-02, 1.690E-02, 1.685E-02, 1.680E-02, 1.675E-02, 1.670E-02, 1.665E-02, 1.660E-02, 1.655E-02,
                1.650E-02, 1.645E-02, 1.640E-02, 1.635E-02, 1.630E-02, 1.625E-02, 1.620E-02, 1.615E-02, 1.610E-02, 1.605E-02,
                1.600E-02, 1.595E-02, 1.590E-02, 1.585E-02, 1.580E-02, 1.575E-02, 1.570E-02, 1.565E-02, 1.560E-02, 1.555E-02,
                1.550E-02, 1.545E-02, 1.540E-02, 1.535E-02, 1.530E-02, 1.525E-02, 1.520E-02, 1.515E-02, 1.510E-02, 1.505E-02,
                1.500E-02, 1.495E-02, 1.490E-02, 1.485E-02, 1.480E-02, 1.475E-02, 1.470E-02, 1.465E-02, 1.460E-02, 1.455E-02,
                1.450E-02, 1.445E-02, 1.440E-02, 1.435E-02, 1.430E-02, 1.425E-02, 1.420E-02, 1.415E-02, 1.410E-02, 1.405E-02,
                1.400E-02, 1.385E-02, 1.370E-02, 1.355E-02, 1.340E-02, 1.325E-02, 1.310E-02, 1.295E-02, 1.280E-02, 1.265E-02,
                1.250E-02, 1.235E-02, 1.220E-02, 1.205E-02, 1.190E-02, 1.175E-02, 1.160E-02, 1.145E-02, 1.130E-02, 1.115E-02,
                1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02,
                1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02,
                1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02,
                1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02, 1.100E-02,
                1.100E-02, 1.090E-02, 1.080E-02, 1.070E-02, 1.060E-02, 1.050E-02, 1.040E-02, 1.030E-02, 1.020E-02, 1.010E-02,
                1.000E-02, 9.900E-03, 9.800E-03, 9.700E-03, 9.600E-03, 9.500E-03, 9.400E-03, 9.300E-03, 9.200E-03, 9.100E-03,
                9.000E-03, 9.100E-03, 9.200E-03, 9.300E-03, 9.400E-03, 9.500E-03, 9.600E-03, 9.700E-03, 9.800E-03, 9.900E-03,
                1.000E-02, 1.010E-02, 1.020E-02, 1.030E-02, 1.040E-02, 1.050E-02, 1.060E-02, 1.070E-02, 1.080E-02, 1.090E-02,
                1.100E-02, 1.070E-02, 1.040E-02, 1.010E-02, 9.800E-03, 9.500E-03, 9.200E-03, 8.900E-03, 8.600E-03, 8.300E-03,
                8.000E-03, 7.700E-03, 7.400E-03, 7.100E-03, 6.800E-03, 6.500E-03, 6.200E-03, 5.900E-03, 5.600E-03, 5.300E-03,
                5.000E-03, 5.250E-03, 5.500E-03, 5.750E-03, 6.000E-03, 6.250E-03, 6.500E-03, 6.750E-03, 7.000E-03, 7.250E-03,
                7.500E-03, 7.750E-03, 8.000E-03, 8.250E-03, 8.500E-03, 8.750E-03, 9.000E-03, 9.250E-03, 9.500E-03, 9.750E-03,
                1.000E-02, 9.800E-03, 9.600E-03, 9.400E-03, 9.200E-03, 9.000E-03, 8.800E-03, 8.600E-03, 8.400E-03, 8.200E-03,
                8.000E-03, 7.800E-03, 7.600E-03, 7.400E-03, 7.200E-03, 7.000E-03, 6.800E-03, 6.600E-03, 6.400E-03, 6.200E-03,
                6.000E-03, 5.950E-03, 5.900E-03, 5.850E-03, 5.800E-03, 5.750E-03, 5.700E-03, 5.650E-03, 5.600E-03, 5.550E-03,
                5.500E-03, 5.450E-03, 5.400E-03, 5.350E-03, 5.300E-03, 5.250E-03, 5.200E-03, 5.150E-03, 5.100E-03, 5.050E-03,
                5.000E-03, 4.850E-03, 4.700E-03, 4.550E-03, 4.400E-03, 4.250E-03, 4.100E-03, 3.950E-03, 3.800E-03, 3.650E-03,
                3.500E-03, 3.350E-03, 3.200E-03, 3.050E-03, 2.900E-03, 2.750E-03, 2.600E-03, 2.450E-03, 2.300E-03, 2.150E-03,
                2.000E-03])

# Literature-Soil bright (Rsoil1)

Rsoil1 = np.array([2.377E-01, 2.373E-01, 2.369E-01, 2.365E-01, 2.360E-01, 2.356E-01, 2.352E-01, 2.348E-01, 2.344E-01, 2.340E-01, 
                    2.336E-01, 2.332E-01, 2.328E-01, 2.324E-01, 2.320E-01, 2.316E-01, 2.312E-01, 2.308E-01, 2.304E-01, 2.299E-01,
                    2.295E-01, 2.290E-01, 2.284E-01, 2.278E-01, 2.272E-01, 2.267E-01, 2.263E-01, 2.259E-01, 2.254E-01, 2.250E-01,
                    2.246E-01, 2.243E-01, 2.240E-01, 2.237E-01, 2.234E-01, 2.231E-01, 2.228E-01, 2.224E-01, 2.221E-01, 2.218E-01,
                    2.215E-01, 2.215E-01, 2.215E-01, 2.215E-01, 2.215E-01, 2.214E-01, 2.215E-01, 2.215E-01, 2.216E-01, 2.217E-01,
                    2.217E-01, 2.218E-01, 2.219E-01, 2.219E-01, 2.220E-01, 2.221E-01, 2.222E-01, 2.224E-01, 2.225E-01, 2.227E-01,
                    2.228E-01, 2.230E-01, 2.231E-01, 2.233E-01, 2.234E-01, 2.236E-01, 2.238E-01, 2.240E-01, 2.241E-01, 2.243E-01,
                    2.245E-01, 2.247E-01, 2.249E-01, 2.251E-01, 2.253E-01, 2.256E-01, 2.258E-01, 2.260E-01, 2.262E-01, 2.264E-01,
                    2.266E-01, 2.269E-01, 2.271E-01, 2.273E-01, 2.276E-01, 2.278E-01, 2.280E-01, 2.283E-01, 2.285E-01, 2.287E-01,
                    2.289E-01, 2.293E-01, 2.297E-01, 2.302E-01, 2.306E-01, 2.310E-01, 2.314E-01, 2.319E-01, 2.324E-01, 2.329E-01,
                    2.333E-01, 2.340E-01, 2.346E-01, 2.353E-01, 2.359E-01, 2.366E-01, 2.371E-01, 2.376E-01, 2.381E-01, 2.387E-01,
                    2.392E-01, 2.396E-01, 2.400E-01, 2.405E-01, 2.409E-01, 2.413E-01, 2.418E-01, 2.422E-01, 2.427E-01, 2.431E-01,
                    2.436E-01, 2.441E-01, 2.446E-01, 2.452E-01, 2.457E-01, 2.462E-01, 2.467E-01, 2.472E-01, 2.477E-01, 2.482E-01,
                    2.487E-01, 2.492E-01, 2.497E-01, 2.502E-01, 2.507E-01, 2.512E-01, 2.517E-01, 2.522E-01, 2.527E-01, 2.532E-01,
                    2.537E-01, 2.542E-01, 2.546E-01, 2.551E-01, 2.556E-01, 2.561E-01, 2.566E-01, 2.571E-01, 2.576E-01, 2.582E-01,
                    2.587E-01, 2.592E-01, 2.598E-01, 2.603E-01, 2.609E-01, 2.614E-01, 2.620E-01, 2.626E-01, 2.631E-01, 2.637E-01,
                    2.642E-01, 2.647E-01, 2.651E-01, 2.655E-01, 2.659E-01, 2.664E-01, 2.667E-01, 2.671E-01, 2.675E-01, 2.679E-01,
                    2.683E-01, 2.686E-01, 2.690E-01, 2.694E-01, 2.698E-01, 2.702E-01, 2.707E-01, 2.712E-01, 2.717E-01, 2.722E-01,
                    2.727E-01, 2.732E-01, 2.737E-01, 2.742E-01, 2.747E-01, 2.752E-01, 2.757E-01, 2.762E-01, 2.767E-01, 2.772E-01,
                    2.777E-01, 2.782E-01, 2.787E-01, 2.792E-01, 2.797E-01, 2.802E-01, 2.807E-01, 2.812E-01, 2.818E-01, 2.823E-01,
                    2.828E-01, 2.833E-01, 2.838E-01, 2.844E-01, 2.849E-01, 2.855E-01, 2.861E-01, 2.866E-01, 2.872E-01, 2.878E-01,
                    2.884E-01, 2.890E-01, 2.896E-01, 2.902E-01, 2.908E-01, 2.913E-01, 2.919E-01, 2.924E-01, 2.929E-01, 2.934E-01,
                    2.939E-01, 2.944E-01, 2.950E-01, 2.955E-01, 2.960E-01, 2.965E-01, 2.970E-01, 2.975E-01, 2.980E-01, 2.985E-01,
                    2.990E-01, 2.995E-01, 2.999E-01, 3.004E-01, 3.008E-01, 3.013E-01, 3.017E-01, 3.022E-01, 3.026E-01, 3.030E-01,
                    3.035E-01, 3.039E-01, 3.044E-01, 3.048E-01, 3.053E-01, 3.057E-01, 3.062E-01, 3.066E-01, 3.071E-01, 3.075E-01,
                    3.080E-01, 3.086E-01, 3.092E-01, 3.097E-01, 3.103E-01, 3.109E-01, 3.117E-01, 3.125E-01, 3.133E-01, 3.141E-01,
                    3.149E-01, 3.156E-01, 3.162E-01, 3.169E-01, 3.176E-01, 3.182E-01, 3.188E-01, 3.193E-01, 3.199E-01, 3.204E-01,
                    3.210E-01, 3.216E-01, 3.221E-01, 3.227E-01, 3.232E-01, 3.238E-01, 3.244E-01, 3.250E-01, 3.257E-01, 3.263E-01,
                    3.269E-01, 3.275E-01, 3.281E-01, 3.288E-01, 3.294E-01, 3.300E-01, 3.304E-01, 3.309E-01, 3.313E-01, 3.317E-01,
                    3.322E-01, 3.325E-01, 3.328E-01, 3.332E-01, 3.335E-01, 3.338E-01, 3.341E-01, 3.345E-01, 3.348E-01, 3.351E-01,
                    3.355E-01, 3.361E-01, 3.367E-01, 3.373E-01, 3.379E-01, 3.385E-01, 3.392E-01, 3.398E-01, 3.405E-01, 3.412E-01,
                    3.418E-01, 3.424E-01, 3.429E-01, 3.434E-01, 3.439E-01, 3.444E-01, 3.449E-01, 3.454E-01, 3.459E-01, 3.464E-01,
                    3.469E-01, 3.476E-01, 3.483E-01, 3.490E-01, 3.497E-01, 3.504E-01, 3.512E-01, 3.520E-01, 3.529E-01, 3.537E-01,
                    3.545E-01, 3.549E-01, 3.553E-01, 3.557E-01, 3.560E-01, 3.564E-01, 3.568E-01, 3.572E-01, 3.575E-01, 3.579E-01,
                    3.583E-01, 3.587E-01, 3.591E-01, 3.595E-01, 3.600E-01, 3.604E-01, 3.609E-01, 3.615E-01, 3.621E-01, 3.626E-01,
                    3.632E-01, 3.637E-01, 3.643E-01, 3.649E-01, 3.654E-01, 3.660E-01, 3.667E-01, 3.674E-01, 3.681E-01, 3.688E-01,
                    3.695E-01, 3.700E-01, 3.705E-01, 3.710E-01, 3.715E-01, 3.719E-01, 3.722E-01, 3.725E-01, 3.728E-01, 3.731E-01,
                    3.733E-01, 3.736E-01, 3.739E-01, 3.742E-01, 3.745E-01, 3.747E-01, 3.752E-01, 3.758E-01, 3.763E-01, 3.768E-01,
                    3.773E-01, 3.778E-01, 3.783E-01, 3.789E-01, 3.794E-01, 3.799E-01, 3.804E-01, 3.808E-01, 3.813E-01, 3.817E-01,
                    3.822E-01, 3.825E-01, 3.829E-01, 3.832E-01, 3.836E-01, 3.839E-01, 3.843E-01, 3.846E-01, 3.850E-01, 3.853E-01,
                    3.857E-01, 3.862E-01, 3.866E-01, 3.871E-01, 3.876E-01, 3.881E-01, 3.886E-01, 3.891E-01, 3.896E-01, 3.901E-01,
                    3.906E-01, 3.911E-01, 3.917E-01, 3.922E-01, 3.928E-01, 3.933E-01, 3.939E-01, 3.944E-01, 3.950E-01, 3.955E-01,
                    3.961E-01, 3.966E-01, 3.971E-01, 3.976E-01, 3.981E-01, 3.987E-01, 3.991E-01, 3.995E-01, 3.999E-01, 4.003E-01,
                    4.007E-01, 4.010E-01, 4.013E-01, 4.015E-01, 4.018E-01, 4.021E-01, 4.023E-01, 4.026E-01, 4.028E-01, 4.031E-01,
                    4.034E-01, 4.038E-01, 4.043E-01, 4.047E-01, 4.052E-01, 4.056E-01, 4.061E-01, 4.066E-01, 4.070E-01, 4.075E-01,
                    4.079E-01, 4.082E-01, 4.085E-01, 4.088E-01, 4.091E-01, 4.094E-01, 4.097E-01, 4.099E-01, 4.102E-01, 4.104E-01,
                    4.107E-01, 4.110E-01, 4.113E-01, 4.116E-01, 4.119E-01, 4.122E-01, 4.128E-01, 4.134E-01, 4.139E-01, 4.145E-01,
                    4.150E-01, 4.155E-01, 4.160E-01, 4.165E-01, 4.170E-01, 4.175E-01, 4.178E-01, 4.182E-01, 4.185E-01, 4.189E-01,
                    4.193E-01, 4.196E-01, 4.200E-01, 4.204E-01, 4.207E-01, 4.211E-01, 4.214E-01, 4.217E-01, 4.221E-01, 4.224E-01,
                    4.227E-01, 4.230E-01, 4.232E-01, 4.235E-01, 4.237E-01, 4.240E-01, 4.242E-01, 4.245E-01, 4.247E-01, 4.250E-01,
                    4.252E-01, 4.255E-01, 4.258E-01, 4.261E-01, 4.264E-01, 4.267E-01, 4.270E-01, 4.274E-01, 4.277E-01, 4.281E-01,
                    4.284E-01, 4.288E-01, 4.291E-01, 4.295E-01, 4.298E-01, 4.302E-01, 4.306E-01, 4.311E-01, 4.315E-01, 4.319E-01,
                    4.324E-01, 4.328E-01, 4.333E-01, 4.337E-01, 4.342E-01, 4.346E-01, 4.351E-01, 4.355E-01, 4.359E-01, 4.364E-01,
                    4.368E-01, 4.370E-01, 4.373E-01, 4.376E-01, 4.378E-01, 4.381E-01, 4.384E-01, 4.386E-01, 4.389E-01, 4.392E-01,
                    4.394E-01, 4.397E-01, 4.400E-01, 4.403E-01, 4.406E-01, 4.409E-01, 4.412E-01, 4.415E-01, 4.418E-01, 4.421E-01,
                    4.424E-01, 4.427E-01, 4.430E-01, 4.433E-01, 4.436E-01, 4.438E-01, 4.439E-01, 4.440E-01, 4.441E-01, 4.441E-01,
                    4.442E-01, 4.443E-01, 4.444E-01, 4.445E-01, 4.446E-01, 4.447E-01, 4.450E-01, 4.453E-01, 4.456E-01, 4.459E-01,
                    4.462E-01, 4.465E-01, 4.468E-01, 4.471E-01, 4.474E-01, 4.477E-01, 4.479E-01, 4.482E-01, 4.485E-01, 4.487E-01,
                    4.490E-01, 4.492E-01, 4.495E-01, 4.497E-01, 4.500E-01, 4.502E-01, 4.506E-01, 4.509E-01, 4.513E-01, 4.516E-01,
                    4.520E-01, 4.525E-01, 4.530E-01, 4.535E-01, 4.540E-01, 4.545E-01, 4.549E-01, 4.553E-01, 4.557E-01, 4.561E-01,
                    4.565E-01, 4.568E-01, 4.571E-01, 4.573E-01, 4.576E-01, 4.579E-01, 4.579E-01, 4.580E-01, 4.580E-01, 4.580E-01,
                    4.581E-01, 4.582E-01, 4.583E-01, 4.584E-01, 4.585E-01, 4.586E-01, 4.589E-01, 4.591E-01, 4.594E-01, 4.597E-01,
                    4.599E-01, 4.602E-01, 4.604E-01, 4.606E-01, 4.608E-01, 4.611E-01, 4.613E-01, 4.614E-01, 4.616E-01, 4.618E-01,
                    4.620E-01, 4.622E-01, 4.623E-01, 4.625E-01, 4.627E-01, 4.628E-01, 4.628E-01, 4.627E-01, 4.627E-01, 4.627E-01,
                    4.626E-01, 4.626E-01, 4.626E-01, 4.625E-01, 4.625E-01, 4.625E-01, 4.625E-01, 4.626E-01, 4.626E-01, 4.627E-01,
                    4.628E-01, 4.628E-01, 4.629E-01, 4.630E-01, 4.631E-01, 4.631E-01, 4.632E-01, 4.633E-01, 4.634E-01, 4.635E-01,
                    4.636E-01, 4.640E-01, 4.645E-01, 4.649E-01, 4.653E-01, 4.658E-01, 4.661E-01, 4.664E-01, 4.667E-01, 4.670E-01,
                    4.673E-01, 4.673E-01, 4.674E-01, 4.675E-01, 4.676E-01, 4.677E-01, 4.677E-01, 4.678E-01, 4.679E-01, 4.680E-01,
                    4.681E-01, 4.682E-01, 4.684E-01, 4.685E-01, 4.687E-01, 4.688E-01, 4.690E-01, 4.692E-01, 4.694E-01, 4.696E-01,
                    4.698E-01, 4.701E-01, 4.704E-01, 4.708E-01, 4.711E-01, 4.714E-01, 4.715E-01, 4.716E-01, 4.716E-01, 4.717E-01,
                    4.718E-01, 4.717E-01, 4.717E-01, 4.716E-01, 4.716E-01, 4.715E-01, 4.718E-01, 4.720E-01, 4.723E-01, 4.725E-01,
                    4.728E-01, 4.731E-01, 4.733E-01, 4.736E-01, 4.739E-01, 4.742E-01, 4.743E-01, 4.745E-01, 4.746E-01, 4.748E-01,
                    4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01, 4.749E-01,
                    4.749E-01, 4.751E-01, 4.753E-01, 4.755E-01, 4.757E-01, 4.759E-01, 4.761E-01, 4.764E-01, 4.766E-01, 4.768E-01,
                    4.770E-01, 4.773E-01, 4.775E-01, 4.777E-01, 4.779E-01, 4.782E-01, 4.784E-01, 4.786E-01, 4.788E-01, 4.791E-01,
                    4.793E-01, 4.793E-01, 4.794E-01, 4.794E-01, 4.795E-01, 4.796E-01, 4.795E-01, 4.795E-01, 4.795E-01, 4.795E-01,
                    4.795E-01, 4.799E-01, 4.802E-01, 4.805E-01, 4.808E-01, 4.811E-01, 4.811E-01, 4.811E-01, 4.811E-01, 4.811E-01,
                    4.811E-01, 4.813E-01, 4.815E-01, 4.816E-01, 4.818E-01, 4.820E-01, 4.825E-01, 4.829E-01, 4.833E-01, 4.838E-01,
                    4.842E-01, 4.845E-01, 4.847E-01, 4.850E-01, 4.852E-01, 4.855E-01, 4.857E-01, 4.858E-01, 4.860E-01, 4.862E-01,
                    4.864E-01, 4.863E-01, 4.863E-01, 4.863E-01, 4.863E-01, 4.863E-01, 4.863E-01, 4.864E-01, 4.864E-01, 4.864E-01,
                    4.864E-01, 4.866E-01, 4.868E-01, 4.870E-01, 4.872E-01, 4.874E-01, 4.875E-01, 4.875E-01, 4.876E-01, 4.877E-01,
                    4.877E-01, 4.878E-01, 4.878E-01, 4.878E-01, 4.878E-01, 4.879E-01, 4.881E-01, 4.884E-01, 4.887E-01, 4.889E-01,
                    4.892E-01, 4.893E-01, 4.893E-01, 4.894E-01, 4.895E-01, 4.896E-01, 4.897E-01, 4.897E-01, 4.898E-01, 4.899E-01,
                    4.900E-01, 4.901E-01, 4.902E-01, 4.903E-01, 4.904E-01, 4.905E-01, 4.907E-01, 4.909E-01, 4.912E-01, 4.914E-01,
                    4.916E-01, 4.919E-01, 4.921E-01, 4.924E-01, 4.926E-01, 4.929E-01, 4.929E-01, 4.929E-01, 4.930E-01, 4.930E-01,
                    4.930E-01, 4.929E-01, 4.928E-01, 4.927E-01, 4.926E-01, 4.924E-01, 4.926E-01, 4.928E-01, 4.930E-01, 4.932E-01,
                    4.934E-01, 4.935E-01, 4.936E-01, 4.937E-01, 4.938E-01, 4.939E-01, 4.939E-01, 4.940E-01, 4.940E-01, 4.941E-01,
                    4.941E-01, 4.942E-01, 4.943E-01, 4.945E-01, 4.946E-01, 4.947E-01, 4.948E-01, 4.950E-01, 4.951E-01, 4.953E-01,
                    4.954E-01, 4.957E-01, 4.959E-01, 4.962E-01, 4.965E-01, 4.967E-01, 4.969E-01, 4.972E-01, 4.974E-01, 4.976E-01,
                    4.979E-01, 4.980E-01, 4.982E-01, 4.984E-01, 4.986E-01, 4.988E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01,
                    4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01,
                    4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01,
                    4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.986E-01, 4.986E-01, 4.986E-01, 4.986E-01,
                    4.986E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.987E-01, 4.989E-01, 4.990E-01, 4.991E-01, 4.993E-01,
                    4.994E-01, 4.996E-01, 4.997E-01, 4.999E-01, 5.000E-01, 5.002E-01, 5.002E-01, 5.003E-01, 5.003E-01, 5.003E-01,
                    5.004E-01, 5.004E-01, 5.004E-01, 5.004E-01, 5.004E-01, 5.004E-01, 5.002E-01, 5.000E-01, 4.998E-01, 4.996E-01,
                    4.995E-01, 4.993E-01, 4.992E-01, 4.991E-01, 4.990E-01, 4.989E-01, 4.989E-01, 4.989E-01, 4.989E-01, 4.989E-01,
                    4.989E-01, 4.989E-01, 4.989E-01, 4.989E-01, 4.989E-01, 4.989E-01, 4.988E-01, 4.988E-01, 4.988E-01, 4.988E-01,
                    4.988E-01, 4.979E-01, 4.970E-01, 4.962E-01, 4.953E-01, 4.944E-01, 4.940E-01, 4.937E-01, 4.933E-01, 4.930E-01,
                    4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01,
                    4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01, 4.926E-01,
                    4.925E-01, 4.933E-01, 4.940E-01, 4.947E-01, 4.955E-01, 4.962E-01, 4.968E-01, 4.974E-01, 4.980E-01, 4.986E-01,
                    4.992E-01, 4.994E-01, 4.997E-01, 4.999E-01, 5.001E-01, 5.003E-01, 5.004E-01, 5.005E-01, 5.006E-01, 5.006E-01,
                    5.007E-01, 5.007E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01,
                    5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.008E-01, 5.007E-01, 5.006E-01, 5.006E-01, 5.005E-01,
                    5.004E-01, 5.004E-01, 5.005E-01, 5.005E-01, 5.006E-01, 5.006E-01, 5.008E-01, 5.011E-01, 5.014E-01, 5.016E-01,
                    5.019E-01, 5.020E-01, 5.022E-01, 5.023E-01, 5.025E-01, 5.026E-01, 5.027E-01, 5.028E-01, 5.029E-01, 5.031E-01,
                    5.032E-01, 5.032E-01, 5.033E-01, 5.033E-01, 5.034E-01, 5.034E-01, 5.032E-01, 5.030E-01, 5.028E-01, 5.026E-01,
                    5.024E-01, 5.022E-01, 5.020E-01, 5.019E-01, 5.017E-01, 5.015E-01, 5.017E-01, 5.019E-01, 5.021E-01, 5.023E-01,
                    5.025E-01, 5.027E-01, 5.029E-01, 5.031E-01, 5.033E-01, 5.035E-01, 5.036E-01, 5.037E-01, 5.038E-01, 5.040E-01,
                    5.041E-01, 5.039E-01, 5.037E-01, 5.036E-01, 5.034E-01, 5.033E-01, 5.035E-01, 5.036E-01, 5.038E-01, 5.040E-01,
                    5.042E-01, 5.044E-01, 5.047E-01, 5.049E-01, 5.051E-01, 5.054E-01, 5.057E-01, 5.061E-01, 5.065E-01, 5.068E-01,
                    5.072E-01, 5.072E-01, 5.073E-01, 5.073E-01, 5.073E-01, 5.074E-01, 5.072E-01, 5.071E-01, 5.069E-01, 5.068E-01,
                    5.067E-01, 5.067E-01, 5.067E-01, 5.067E-01, 5.067E-01, 5.067E-01, 5.068E-01, 5.070E-01, 5.071E-01, 5.072E-01,
                    5.074E-01, 5.075E-01, 5.076E-01, 5.078E-01, 5.079E-01, 5.080E-01, 5.080E-01, 5.079E-01, 5.078E-01, 5.077E-01,
                    5.077E-01, 5.075E-01, 5.074E-01, 5.073E-01, 5.072E-01, 5.071E-01, 5.072E-01, 5.074E-01, 5.075E-01, 5.077E-01,
                    5.078E-01, 5.079E-01, 5.080E-01, 5.082E-01, 5.083E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01,
                    5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.084E-01, 5.085E-01, 5.085E-01,
                    5.085E-01, 5.087E-01, 5.089E-01, 5.090E-01, 5.092E-01, 5.094E-01, 5.096E-01, 5.097E-01, 5.099E-01, 5.101E-01,
                    5.103E-01, 5.103E-01, 5.104E-01, 5.104E-01, 5.105E-01, 5.106E-01, 5.103E-01, 5.101E-01, 5.099E-01, 5.097E-01,
                    5.095E-01, 5.093E-01, 5.091E-01, 5.089E-01, 5.087E-01, 5.085E-01, 5.086E-01, 5.087E-01, 5.088E-01, 5.089E-01,
                    5.090E-01, 5.091E-01, 5.092E-01, 5.093E-01, 5.095E-01, 5.096E-01, 5.095E-01, 5.093E-01, 5.092E-01, 5.091E-01,
                    5.090E-01, 5.089E-01, 5.087E-01, 5.086E-01, 5.085E-01, 5.084E-01, 5.083E-01, 5.083E-01, 5.083E-01, 5.082E-01,
                    5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01,
                    5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.082E-01, 5.085E-01, 5.089E-01, 5.092E-01, 5.096E-01,
                    5.099E-01, 5.101E-01, 5.104E-01, 5.106E-01, 5.109E-01, 5.111E-01, 5.109E-01, 5.107E-01, 5.106E-01, 5.104E-01,
                    5.102E-01, 5.100E-01, 5.098E-01, 5.097E-01, 5.095E-01, 5.093E-01, 5.091E-01, 5.090E-01, 5.088E-01, 5.086E-01,
                    5.084E-01, 5.083E-01, 5.083E-01, 5.082E-01, 5.081E-01, 5.081E-01, 5.081E-01, 5.081E-01, 5.080E-01, 5.080E-01,
                    5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01, 5.080E-01,
                    5.080E-01, 5.082E-01, 5.084E-01, 5.086E-01, 5.088E-01, 5.090E-01, 5.093E-01, 5.095E-01, 5.098E-01, 5.101E-01,
                    5.103E-01, 5.106E-01, 5.108E-01, 5.111E-01, 5.114E-01, 5.116E-01, 5.117E-01, 5.118E-01, 5.119E-01, 5.120E-01,
                    5.121E-01, 5.122E-01, 5.122E-01, 5.122E-01, 5.123E-01, 5.123E-01, 5.120E-01, 5.116E-01, 5.113E-01, 5.110E-01,
                    5.107E-01, 5.104E-01, 5.102E-01, 5.100E-01, 5.098E-01, 5.095E-01, 5.096E-01, 5.096E-01, 5.097E-01, 5.097E-01,
                    5.098E-01, 5.095E-01, 5.092E-01, 5.089E-01, 5.086E-01, 5.083E-01, 5.085E-01, 5.086E-01, 5.088E-01, 5.090E-01,
                    5.091E-01, 5.092E-01, 5.093E-01, 5.094E-01, 5.095E-01, 5.096E-01, 5.096E-01, 5.096E-01, 5.096E-01, 5.096E-01,
                    5.096E-01, 5.097E-01, 5.098E-01, 5.099E-01, 5.101E-01, 5.102E-01, 5.102E-01, 5.103E-01, 5.103E-01, 5.104E-01,
                    5.105E-01, 5.102E-01, 5.100E-01, 5.098E-01, 5.096E-01, 5.094E-01, 5.092E-01, 5.090E-01, 5.088E-01, 5.086E-01,
                    5.084E-01, 5.082E-01, 5.081E-01, 5.079E-01, 5.078E-01, 5.076E-01, 5.078E-01, 5.079E-01, 5.081E-01, 5.082E-01,
                    5.084E-01, 5.086E-01, 5.088E-01, 5.091E-01, 5.093E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01,
                    5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01,
                    5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.095E-01, 5.094E-01, 5.094E-01, 5.094E-01, 5.094E-01, 5.094E-01,
                    5.094E-01, 5.090E-01, 5.086E-01, 5.082E-01, 5.078E-01, 5.074E-01, 5.073E-01, 5.072E-01, 5.071E-01, 5.070E-01,
                    5.069E-01, 5.071E-01, 5.074E-01, 5.076E-01, 5.079E-01, 5.082E-01, 5.081E-01, 5.081E-01, 5.080E-01, 5.080E-01,
                    5.079E-01, 5.076E-01, 5.073E-01, 5.070E-01, 5.067E-01, 5.064E-01, 5.066E-01, 5.069E-01, 5.071E-01, 5.073E-01,
                    5.076E-01, 5.079E-01, 5.083E-01, 5.087E-01, 5.091E-01, 5.095E-01, 5.097E-01, 5.100E-01, 5.103E-01, 5.105E-01,
                    5.108E-01, 5.110E-01, 5.112E-01, 5.115E-01, 5.117E-01, 5.119E-01, 5.122E-01, 5.125E-01, 5.128E-01, 5.131E-01,
                    5.134E-01, 5.138E-01, 5.142E-01, 5.147E-01, 5.151E-01, 5.155E-01, 5.153E-01, 5.152E-01, 5.150E-01, 5.148E-01,
                    5.146E-01, 5.142E-01, 5.137E-01, 5.133E-01, 5.128E-01, 5.124E-01, 5.102E-01, 5.081E-01, 5.059E-01, 5.037E-01,
                    5.016E-01, 5.016E-01, 5.016E-01, 5.015E-01, 5.015E-01, 5.015E-01, 5.019E-01, 5.023E-01, 5.026E-01, 5.030E-01,
                    5.034E-01, 5.038E-01, 5.042E-01, 5.046E-01, 5.050E-01, 5.055E-01, 5.061E-01, 5.067E-01, 5.073E-01, 5.080E-01,
                    5.086E-01, 5.086E-01, 5.086E-01, 5.085E-01, 5.085E-01, 5.085E-01, 5.081E-01, 5.076E-01, 5.072E-01, 5.068E-01,
                    5.064E-01, 5.059E-01, 5.055E-01, 5.051E-01, 5.047E-01, 5.042E-01, 5.038E-01, 5.034E-01, 5.030E-01, 5.027E-01,
                    5.023E-01, 5.019E-01, 5.015E-01, 5.011E-01, 5.007E-01, 5.003E-01, 5.003E-01, 5.003E-01, 5.003E-01, 5.003E-01,
                    5.003E-01, 4.992E-01, 4.980E-01, 4.969E-01, 4.958E-01, 4.946E-01, 4.943E-01, 4.939E-01, 4.935E-01, 4.931E-01,
                    4.927E-01, 4.924E-01, 4.920E-01, 4.916E-01, 4.912E-01, 4.908E-01, 4.907E-01, 4.905E-01, 4.904E-01, 4.902E-01,
                    4.901E-01, 4.902E-01, 4.903E-01, 4.904E-01, 4.905E-01, 4.906E-01, 4.905E-01, 4.904E-01, 4.902E-01, 4.901E-01,
                    4.900E-01, 4.900E-01, 4.900E-01, 4.900E-01, 4.900E-01, 4.900E-01, 4.902E-01, 4.904E-01, 4.906E-01, 4.907E-01,
                    4.909E-01, 4.911E-01, 4.913E-01, 4.914E-01, 4.916E-01, 4.918E-01, 4.930E-01, 4.941E-01, 4.953E-01, 4.964E-01,
                    4.976E-01, 4.976E-01, 4.976E-01, 4.976E-01, 4.976E-01, 4.977E-01, 4.977E-01, 4.977E-01, 4.977E-01, 4.977E-01,
                    4.977E-01, 4.977E-01, 4.978E-01, 4.978E-01, 4.978E-01, 4.978E-01, 4.978E-01, 4.978E-01, 4.978E-01, 4.978E-01,
                    4.979E-01, 4.981E-01, 4.983E-01, 4.985E-01, 4.986E-01, 4.988E-01, 4.991E-01, 4.994E-01, 4.996E-01, 4.999E-01,
                    5.002E-01, 5.004E-01, 5.006E-01, 5.009E-01, 5.011E-01, 5.013E-01, 5.016E-01, 5.018E-01, 5.021E-01, 5.023E-01,
                    5.025E-01, 5.028E-01, 5.030E-01, 5.033E-01, 5.035E-01, 5.037E-01, 5.038E-01, 5.038E-01, 5.039E-01, 5.039E-01,
                    5.040E-01, 5.040E-01, 5.040E-01, 5.040E-01, 5.040E-01, 5.040E-01, 5.044E-01, 5.049E-01, 5.053E-01, 5.058E-01,
                    5.062E-01, 5.065E-01, 5.068E-01, 5.070E-01, 5.073E-01, 5.076E-01, 5.076E-01, 5.076E-01, 5.076E-01, 5.076E-01,
                    5.076E-01, 5.077E-01, 5.078E-01, 5.079E-01, 5.080E-01, 5.081E-01, 5.085E-01, 5.089E-01, 5.093E-01, 5.097E-01,
                    5.101E-01, 5.100E-01, 5.100E-01, 5.099E-01, 5.098E-01, 5.098E-01, 5.095E-01, 5.092E-01, 5.089E-01, 5.086E-01,
                    5.083E-01, 5.080E-01, 5.078E-01, 5.076E-01, 5.073E-01, 5.071E-01, 5.071E-01, 5.071E-01, 5.071E-01, 5.071E-01,
                    5.071E-01, 5.071E-01, 5.071E-01, 5.070E-01, 5.070E-01, 5.070E-01, 5.070E-01, 5.069E-01, 5.069E-01, 5.068E-01,
                    5.068E-01, 5.067E-01, 5.067E-01, 5.066E-01, 5.066E-01, 5.065E-01, 5.064E-01, 5.062E-01, 5.061E-01, 5.059E-01,
                    5.058E-01, 5.054E-01, 5.050E-01, 5.047E-01, 5.043E-01, 5.039E-01, 5.043E-01, 5.047E-01, 5.050E-01, 5.054E-01,
                    5.058E-01, 5.056E-01, 5.055E-01, 5.054E-01, 5.052E-01, 5.051E-01, 5.050E-01, 5.048E-01, 5.047E-01, 5.046E-01,
                    5.044E-01, 5.047E-01, 5.051E-01, 5.054E-01, 5.057E-01, 5.060E-01, 5.055E-01, 5.050E-01, 5.045E-01, 5.040E-01,
                    5.035E-01, 5.039E-01, 5.043E-01, 5.047E-01, 5.051E-01, 5.055E-01, 5.053E-01, 5.051E-01, 5.048E-01, 5.046E-01,
                    5.044E-01, 5.041E-01, 5.037E-01, 5.034E-01, 5.031E-01, 5.028E-01, 5.024E-01, 5.021E-01, 5.018E-01, 5.015E-01,
                    5.011E-01, 5.009E-01, 5.007E-01, 5.005E-01, 5.003E-01, 5.000E-01, 4.998E-01, 4.996E-01, 4.994E-01, 4.992E-01,
                    4.990E-01, 4.988E-01, 4.986E-01, 4.984E-01, 4.981E-01, 4.979E-01, 4.978E-01, 4.976E-01, 4.974E-01, 4.972E-01,
                    4.970E-01, 4.972E-01, 4.974E-01, 4.975E-01, 4.977E-01, 4.979E-01, 4.979E-01, 4.979E-01, 4.979E-01, 4.979E-01,
                    4.979E-01, 4.963E-01, 4.946E-01, 4.929E-01, 4.912E-01, 4.895E-01, 4.889E-01, 4.883E-01, 4.877E-01, 4.871E-01,
                    4.865E-01, 4.859E-01, 4.854E-01, 4.848E-01, 4.842E-01, 4.836E-01, 4.833E-01, 4.830E-01, 4.827E-01, 4.824E-01,
                    4.821E-01, 4.820E-01, 4.819E-01, 4.818E-01, 4.817E-01, 4.816E-01, 4.816E-01, 4.815E-01, 4.815E-01, 4.815E-01,
                    4.815E-01, 4.817E-01, 4.818E-01, 4.820E-01, 4.821E-01, 4.823E-01, 4.827E-01, 4.831E-01, 4.836E-01, 4.840E-01,
                    4.844E-01, 4.849E-01, 4.853E-01, 4.858E-01, 4.862E-01, 4.867E-01, 4.873E-01, 4.879E-01, 4.884E-01, 4.890E-01,
                    4.896E-01, 4.902E-01, 4.908E-01, 4.914E-01, 4.920E-01, 4.926E-01, 4.924E-01, 4.922E-01, 4.920E-01, 4.919E-01,
                    4.917E-01, 4.914E-01, 4.911E-01, 4.908E-01, 4.905E-01, 4.902E-01, 4.902E-01, 4.902E-01, 4.902E-01, 4.901E-01,
                    4.901E-01, 4.901E-01, 4.900E-01, 4.899E-01, 4.898E-01, 4.897E-01, 4.895E-01, 4.893E-01, 4.891E-01, 4.889E-01,
                    4.887E-01, 4.889E-01, 4.892E-01, 4.894E-01, 4.896E-01, 4.898E-01, 4.900E-01, 4.902E-01, 4.904E-01, 4.906E-01,
                    4.908E-01, 4.910E-01, 4.912E-01, 4.914E-01, 4.916E-01, 4.918E-01, 4.920E-01, 4.923E-01, 4.925E-01, 4.927E-01,
                    4.929E-01, 4.926E-01, 4.924E-01, 4.921E-01, 4.919E-01, 4.916E-01, 4.910E-01, 4.904E-01, 4.898E-01, 4.892E-01,
                    4.886E-01, 4.885E-01, 4.884E-01, 4.883E-01, 4.882E-01, 4.882E-01, 4.879E-01, 4.875E-01, 4.872E-01, 4.869E-01,
                    4.866E-01, 4.863E-01, 4.860E-01, 4.857E-01, 4.853E-01, 4.850E-01, 4.847E-01, 4.844E-01, 4.841E-01, 4.838E-01,
                    4.835E-01, 4.832E-01, 4.830E-01, 4.828E-01, 4.825E-01, 4.823E-01, 4.823E-01, 4.823E-01, 4.823E-01, 4.823E-01,
                    4.823E-01, 4.823E-01, 4.823E-01, 4.823E-01, 4.823E-01, 4.823E-01, 4.822E-01, 4.822E-01, 4.822E-01, 4.822E-01,
                    4.822E-01, 4.817E-01, 4.813E-01, 4.809E-01, 4.805E-01, 4.801E-01, 4.797E-01, 4.793E-01, 4.789E-01, 4.785E-01,
                    4.781E-01, 4.778E-01, 4.776E-01, 4.773E-01, 4.771E-01, 4.768E-01, 4.769E-01, 4.770E-01, 4.770E-01, 4.771E-01,
                    4.772E-01, 4.773E-01, 4.773E-01, 4.774E-01, 4.775E-01, 4.775E-01, 4.776E-01, 4.777E-01, 4.778E-01, 4.779E-01,
                    4.780E-01, 4.778E-01, 4.777E-01, 4.776E-01, 4.774E-01, 4.773E-01, 4.770E-01, 4.767E-01, 4.765E-01, 4.762E-01,
                    4.759E-01, 4.756E-01, 4.754E-01, 4.751E-01, 4.748E-01, 4.745E-01, 4.747E-01, 4.748E-01, 4.749E-01, 4.750E-01,
                    4.752E-01, 4.752E-01, 4.753E-01, 4.754E-01, 4.755E-01, 4.755E-01, 4.752E-01, 4.748E-01, 4.744E-01, 4.740E-01,
                    4.736E-01, 4.736E-01, 4.735E-01, 4.734E-01, 4.734E-01, 4.733E-01, 4.731E-01, 4.729E-01, 4.727E-01, 4.725E-01,
                    4.723E-01, 4.718E-01, 4.714E-01, 4.709E-01, 4.704E-01, 4.699E-01, 4.695E-01, 4.691E-01, 4.686E-01, 4.682E-01,
                    4.678E-01, 4.678E-01, 4.678E-01, 4.678E-01, 4.678E-01, 4.678E-01, 4.678E-01, 4.677E-01, 4.677E-01, 4.677E-01,
                    4.677E-01, 4.675E-01, 4.673E-01, 4.671E-01, 4.668E-01, 4.666E-01, 4.662E-01, 4.658E-01, 4.653E-01, 4.649E-01,
                    4.645E-01, 4.640E-01, 4.636E-01, 4.632E-01, 4.627E-01, 4.623E-01, 4.620E-01, 4.616E-01, 4.613E-01, 4.609E-01,
                    4.606E-01, 4.602E-01, 4.599E-01, 4.595E-01, 4.592E-01, 4.588E-01, 4.585E-01, 4.581E-01, 4.578E-01, 4.574E-01,
                    4.571E-01, 4.567E-01, 4.564E-01, 4.561E-01, 4.557E-01, 4.554E-01, 4.551E-01, 4.548E-01, 4.545E-01, 4.541E-01,
                    4.538E-01, 4.535E-01, 4.532E-01, 4.529E-01, 4.526E-01, 4.523E-01, 4.522E-01, 4.521E-01, 4.521E-01, 4.520E-01,
                    4.519E-01, 4.518E-01, 4.518E-01, 4.517E-01, 4.516E-01, 4.516E-01, 4.513E-01, 4.510E-01, 4.507E-01, 4.505E-01,
                    4.502E-01, 4.499E-01, 4.497E-01, 4.494E-01, 4.491E-01, 4.488E-01, 4.487E-01, 4.486E-01, 4.485E-01, 4.483E-01,
                    4.482E-01, 4.482E-01, 4.482E-01, 4.482E-01, 4.482E-01, 4.482E-01, 4.478E-01, 4.475E-01, 4.471E-01, 4.467E-01,
                    4.464E-01])

# Literature-Soil2 dark (Rsoil2)

Rsoil2 = np.array([3.208E-02, 3.195E-02, 3.181E-02, 3.168E-02, 3.154E-02, 3.141E-02, 3.125E-02, 3.108E-02, 3.092E-02, 3.076E-02, 
                    3.059E-02, 3.044E-02, 3.028E-02, 3.012E-02, 2.996E-02, 2.980E-02, 2.969E-02, 2.957E-02, 2.946E-02, 2.934E-02,
                    2.923E-02, 2.911E-02, 2.900E-02, 2.888E-02, 2.877E-02, 2.865E-02, 2.854E-02, 2.842E-02, 2.831E-02, 2.819E-02,
                    2.808E-02, 2.793E-02, 2.779E-02, 2.764E-02, 2.750E-02, 2.735E-02, 2.720E-02, 2.705E-02, 2.690E-02, 2.675E-02,
                    2.660E-02, 2.646E-02, 2.632E-02, 2.618E-02, 2.604E-02, 2.590E-02, 2.578E-02, 2.566E-02, 2.553E-02, 2.541E-02,
                    2.529E-02, 2.523E-02, 2.518E-02, 2.513E-02, 2.508E-02, 2.502E-02, 2.502E-02, 2.502E-02, 2.502E-02, 2.501E-02,
                    2.501E-02, 2.501E-02, 2.501E-02, 2.500E-02, 2.500E-02, 2.500E-02, 2.500E-02, 2.499E-02, 2.499E-02, 2.499E-02,
                    2.499E-02, 2.498E-02, 2.498E-02, 2.498E-02, 2.498E-02, 2.497E-02, 2.483E-02, 2.468E-02, 2.453E-02, 2.438E-02,
                    2.423E-02, 2.423E-02, 2.423E-02, 2.423E-02, 2.422E-02, 2.422E-02, 2.422E-02, 2.422E-02, 2.421E-02, 2.421E-02,
                    2.421E-02, 2.450E-02, 2.479E-02, 2.508E-02, 2.537E-02, 2.566E-02, 2.565E-02, 2.565E-02, 2.565E-02, 2.565E-02,
                    2.564E-02, 2.564E-02, 2.564E-02, 2.564E-02, 2.563E-02, 2.563E-02, 2.570E-02, 2.577E-02, 2.584E-02, 2.591E-02,
                    2.598E-02, 2.598E-02, 2.598E-02, 2.598E-02, 2.597E-02, 2.597E-02, 2.597E-02, 2.597E-02, 2.596E-02, 2.596E-02,
                    2.596E-02, 2.596E-02, 2.595E-02, 2.595E-02, 2.595E-02, 2.595E-02, 2.594E-02, 2.594E-02, 2.594E-02, 2.594E-02,
                    2.593E-02, 2.593E-02, 2.593E-02, 2.593E-02, 2.592E-02, 2.592E-02, 2.614E-02, 2.635E-02, 2.657E-02, 2.679E-02,
                    2.700E-02, 2.700E-02, 2.700E-02, 2.700E-02, 2.699E-02, 2.699E-02, 2.735E-02, 2.772E-02, 2.808E-02, 2.844E-02,
                    2.880E-02, 2.880E-02, 2.880E-02, 2.879E-02, 2.879E-02, 2.879E-02, 2.879E-02, 2.878E-02, 2.878E-02, 2.878E-02,
                    2.878E-02, 2.877E-02, 2.877E-02, 2.877E-02, 2.877E-02, 2.877E-02, 2.884E-02, 2.891E-02, 2.898E-02, 2.905E-02,
                    2.912E-02, 2.912E-02, 2.911E-02, 2.911E-02, 2.911E-02, 2.911E-02, 2.918E-02, 2.926E-02, 2.934E-02, 2.942E-02,
                    2.950E-02, 2.978E-02, 3.006E-02, 3.034E-02, 3.062E-02, 3.090E-02, 3.090E-02, 3.090E-02, 3.090E-02, 3.089E-02,
                    3.089E-02, 3.089E-02, 3.089E-02, 3.088E-02, 3.088E-02, 3.088E-02, 3.088E-02, 3.087E-02, 3.087E-02, 3.087E-02,
                    3.087E-02, 3.098E-02, 3.110E-02, 3.122E-02, 3.133E-02, 3.145E-02, 3.147E-02, 3.150E-02, 3.152E-02, 3.155E-02,
                    3.157E-02, 3.157E-02, 3.157E-02, 3.156E-02, 3.156E-02, 3.156E-02, 3.163E-02, 3.170E-02, 3.177E-02, 3.184E-02,
                    3.191E-02, 3.198E-02, 3.205E-02, 3.212E-02, 3.219E-02, 3.227E-02, 3.263E-02, 3.299E-02, 3.335E-02, 3.371E-02,
                    3.408E-02, 3.407E-02, 3.407E-02, 3.407E-02, 3.407E-02, 3.406E-02, 3.425E-02, 3.443E-02, 3.461E-02, 3.479E-02,
                    3.498E-02, 3.515E-02, 3.533E-02, 3.551E-02, 3.568E-02, 3.586E-02, 3.593E-02, 3.600E-02, 3.607E-02, 3.614E-02,
                    3.621E-02, 3.636E-02, 3.650E-02, 3.664E-02, 3.679E-02, 3.693E-02, 3.710E-02, 3.727E-02, 3.743E-02, 3.760E-02,
                    3.777E-02, 3.782E-02, 3.786E-02, 3.791E-02, 3.795E-02, 3.800E-02, 3.829E-02, 3.858E-02, 3.887E-02, 3.916E-02,
                    3.945E-02, 3.944E-02, 3.944E-02, 3.944E-02, 3.944E-02, 3.943E-02, 3.980E-02, 4.016E-02, 4.052E-02, 4.088E-02,
                    4.124E-02, 4.131E-02, 4.138E-02, 4.146E-02, 4.153E-02, 4.160E-02, 4.167E-02, 4.174E-02, 4.181E-02, 4.188E-02,
                    4.195E-02, 4.195E-02, 4.194E-02, 4.194E-02, 4.194E-02, 4.194E-02, 4.193E-02, 4.193E-02, 4.193E-02, 4.193E-02,
                    4.193E-02, 4.214E-02, 4.236E-02, 4.257E-02, 4.279E-02, 4.301E-02, 4.332E-02, 4.363E-02, 4.394E-02, 4.426E-02,
                    4.457E-02, 4.462E-02, 4.466E-02, 4.471E-02, 4.476E-02, 4.480E-02, 4.495E-02, 4.509E-02, 4.523E-02, 4.538E-02,
                    4.552E-02, 4.566E-02, 4.581E-02, 4.595E-02, 4.609E-02, 4.624E-02, 4.653E-02, 4.682E-02, 4.711E-02, 4.739E-02,
                    4.768E-02, 4.805E-02, 4.841E-02, 4.877E-02, 4.913E-02, 4.949E-02, 4.971E-02, 4.993E-02, 5.014E-02, 5.036E-02,
                    5.058E-02, 5.073E-02, 5.089E-02, 5.105E-02, 5.121E-02, 5.136E-02, 5.156E-02, 5.175E-02, 5.195E-02, 5.214E-02,
                    5.233E-02, 5.253E-02, 5.272E-02, 5.292E-02, 5.311E-02, 5.330E-02, 5.355E-02, 5.380E-02, 5.404E-02, 5.429E-02,
                    5.454E-02, 5.461E-02, 5.468E-02, 5.475E-02, 5.482E-02, 5.489E-02, 5.489E-02, 5.488E-02, 5.488E-02, 5.488E-02,
                    5.488E-02, 5.490E-02, 5.493E-02, 5.496E-02, 5.498E-02, 5.501E-02, 5.549E-02, 5.597E-02, 5.645E-02, 5.692E-02,
                    5.740E-02, 5.753E-02, 5.766E-02, 5.778E-02, 5.791E-02, 5.804E-02, 5.813E-02, 5.821E-02, 5.830E-02, 5.839E-02,
                    5.847E-02, 5.884E-02, 5.920E-02, 5.956E-02, 5.992E-02, 6.028E-02, 6.028E-02, 6.028E-02, 6.028E-02, 6.027E-02,
                    6.027E-02, 6.063E-02, 6.100E-02, 6.136E-02, 6.172E-02, 6.208E-02, 6.223E-02, 6.237E-02, 6.251E-02, 6.266E-02,
                    6.280E-02, 6.280E-02, 6.279E-02, 6.279E-02, 6.279E-02, 6.279E-02, 6.300E-02, 6.322E-02, 6.344E-02, 6.365E-02,
                    6.387E-02, 6.433E-02, 6.479E-02, 6.525E-02, 6.571E-02, 6.616E-02, 6.643E-02, 6.669E-02, 6.696E-02, 6.722E-02,
                    6.749E-02, 6.749E-02, 6.748E-02, 6.748E-02, 6.748E-02, 6.748E-02, 6.747E-02, 6.747E-02, 6.747E-02, 6.747E-02,
                    6.747E-02, 6.776E-02, 6.806E-02, 6.836E-02, 6.866E-02, 6.896E-02, 6.938E-02, 6.981E-02, 7.023E-02, 7.066E-02,
                    7.109E-02, 7.108E-02, 7.108E-02, 7.108E-02, 7.108E-02, 7.107E-02, 7.107E-02, 7.107E-02, 7.107E-02, 7.106E-02,
                    7.106E-02, 7.113E-02, 7.119E-02, 7.126E-02, 7.132E-02, 7.139E-02, 7.197E-02, 7.256E-02, 7.315E-02, 7.373E-02,
                    7.432E-02, 7.432E-02, 7.431E-02, 7.431E-02, 7.431E-02, 7.431E-02, 7.445E-02, 7.459E-02, 7.474E-02, 7.488E-02,
                    7.502E-02, 7.521E-02, 7.539E-02, 7.558E-02, 7.576E-02, 7.595E-02, 7.614E-02, 7.632E-02, 7.651E-02, 7.670E-02,
                    7.689E-02, 7.717E-02, 7.745E-02, 7.772E-02, 7.800E-02, 7.828E-02, 7.848E-02, 7.867E-02, 7.887E-02, 7.907E-02,
                    7.927E-02, 7.943E-02, 7.959E-02, 7.975E-02, 7.991E-02, 8.007E-02, 8.006E-02, 8.006E-02, 8.006E-02, 8.006E-02,
                    8.005E-02, 8.022E-02, 8.039E-02, 8.056E-02, 8.073E-02, 8.090E-02, 8.120E-02, 8.151E-02, 8.181E-02, 8.212E-02,
                    8.243E-02, 8.272E-02, 8.301E-02, 8.330E-02, 8.359E-02, 8.389E-02, 8.404E-02, 8.419E-02, 8.434E-02, 8.449E-02,
                    8.464E-02, 8.495E-02, 8.526E-02, 8.557E-02, 8.588E-02, 8.619E-02, 8.636E-02, 8.653E-02, 8.670E-02, 8.686E-02,
                    8.703E-02, 8.737E-02, 8.771E-02, 8.804E-02, 8.838E-02, 8.872E-02, 8.882E-02, 8.893E-02, 8.904E-02, 8.914E-02,
                    8.925E-02, 8.947E-02, 8.969E-02, 8.991E-02, 9.013E-02, 9.035E-02, 9.058E-02, 9.081E-02, 9.104E-02, 9.127E-02,
                    9.151E-02, 9.189E-02, 9.227E-02, 9.265E-02, 9.303E-02, 9.341E-02, 9.355E-02, 9.369E-02, 9.384E-02, 9.398E-02,
                    9.412E-02, 9.437E-02, 9.461E-02, 9.485E-02, 9.509E-02, 9.534E-02, 9.540E-02, 9.546E-02, 9.552E-02, 9.558E-02,
                    9.564E-02, 9.569E-02, 9.575E-02, 9.580E-02, 9.586E-02, 9.591E-02, 9.617E-02, 9.643E-02, 9.669E-02, 9.695E-02,
                    9.722E-02, 9.797E-02, 9.872E-02, 9.947E-02, 1.002E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01,
                    1.010E-01, 1.010E-01, 1.011E-01, 1.011E-01, 1.012E-01, 1.012E-01, 1.015E-01, 1.017E-01, 1.019E-01, 1.022E-01,
                    1.024E-01, 1.026E-01, 1.028E-01, 1.031E-01, 1.033E-01, 1.035E-01, 1.035E-01, 1.035E-01, 1.035E-01, 1.035E-01,
                    1.035E-01, 1.035E-01, 1.035E-01, 1.035E-01, 1.035E-01, 1.035E-01, 1.042E-01, 1.049E-01, 1.056E-01, 1.063E-01,
                    1.070E-01, 1.075E-01, 1.080E-01, 1.086E-01, 1.091E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01,
                    1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01, 1.096E-01,
                    1.096E-01, 1.097E-01, 1.099E-01, 1.100E-01, 1.102E-01, 1.103E-01, 1.105E-01, 1.108E-01, 1.110E-01, 1.112E-01,
                    1.114E-01, 1.118E-01, 1.121E-01, 1.125E-01, 1.129E-01, 1.132E-01, 1.132E-01, 1.132E-01, 1.132E-01, 1.132E-01,
                    1.132E-01, 1.135E-01, 1.138E-01, 1.141E-01, 1.144E-01, 1.146E-01, 1.148E-01, 1.150E-01, 1.152E-01, 1.154E-01,
                    1.156E-01, 1.158E-01, 1.160E-01, 1.162E-01, 1.163E-01, 1.165E-01, 1.168E-01, 1.171E-01, 1.174E-01, 1.176E-01,
                    1.179E-01, 1.182E-01, 1.184E-01, 1.186E-01, 1.188E-01, 1.191E-01, 1.191E-01, 1.192E-01, 1.193E-01, 1.194E-01,
                    1.195E-01, 1.196E-01, 1.197E-01, 1.199E-01, 1.200E-01, 1.202E-01, 1.204E-01, 1.206E-01, 1.209E-01, 1.211E-01,
                    1.213E-01, 1.215E-01, 1.217E-01, 1.218E-01, 1.220E-01, 1.221E-01, 1.223E-01, 1.225E-01, 1.226E-01, 1.228E-01,
                    1.229E-01, 1.231E-01, 1.233E-01, 1.234E-01, 1.236E-01, 1.238E-01, 1.240E-01, 1.241E-01, 1.243E-01, 1.245E-01,
                    1.246E-01, 1.248E-01, 1.250E-01, 1.252E-01, 1.253E-01, 1.255E-01, 1.257E-01, 1.259E-01, 1.261E-01, 1.263E-01,
                    1.265E-01, 1.267E-01, 1.268E-01, 1.269E-01, 1.271E-01, 1.272E-01, 1.274E-01, 1.275E-01, 1.277E-01, 1.278E-01,
                    1.279E-01, 1.281E-01, 1.282E-01, 1.284E-01, 1.285E-01, 1.287E-01, 1.288E-01, 1.290E-01, 1.291E-01, 1.293E-01,
                    1.294E-01, 1.296E-01, 1.297E-01, 1.299E-01, 1.300E-01, 1.302E-01, 1.303E-01, 1.304E-01, 1.306E-01, 1.307E-01,
                    1.309E-01, 1.310E-01, 1.312E-01, 1.314E-01, 1.316E-01, 1.318E-01, 1.320E-01, 1.322E-01, 1.323E-01, 1.325E-01,
                    1.327E-01, 1.329E-01, 1.331E-01, 1.334E-01, 1.336E-01, 1.338E-01, 1.340E-01, 1.343E-01, 1.346E-01, 1.348E-01,
                    1.351E-01, 1.352E-01, 1.353E-01, 1.353E-01, 1.354E-01, 1.355E-01, 1.358E-01, 1.361E-01, 1.364E-01, 1.367E-01,
                    1.369E-01, 1.371E-01, 1.373E-01, 1.374E-01, 1.376E-01, 1.377E-01, 1.383E-01, 1.388E-01, 1.394E-01, 1.399E-01,
                    1.405E-01, 1.407E-01, 1.409E-01, 1.411E-01, 1.412E-01, 1.414E-01, 1.415E-01, 1.415E-01, 1.415E-01, 1.416E-01,
                    1.416E-01, 1.420E-01, 1.423E-01, 1.427E-01, 1.431E-01, 1.434E-01, 1.438E-01, 1.442E-01, 1.445E-01, 1.449E-01,
                    1.453E-01, 1.453E-01, 1.452E-01, 1.452E-01, 1.452E-01, 1.452E-01, 1.453E-01, 1.454E-01, 1.455E-01, 1.455E-01,
                    1.456E-01, 1.456E-01, 1.456E-01, 1.456E-01, 1.456E-01, 1.456E-01, 1.458E-01, 1.460E-01, 1.462E-01, 1.464E-01,
                    1.467E-01, 1.469E-01, 1.471E-01, 1.474E-01, 1.476E-01, 1.478E-01, 1.479E-01, 1.479E-01, 1.480E-01, 1.480E-01,
                    1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01, 1.481E-01,
                    1.481E-01, 1.483E-01, 1.485E-01, 1.487E-01, 1.489E-01, 1.491E-01, 1.492E-01, 1.493E-01, 1.494E-01, 1.494E-01,
                    1.495E-01, 1.499E-01, 1.502E-01, 1.506E-01, 1.510E-01, 1.513E-01, 1.513E-01, 1.513E-01, 1.513E-01, 1.513E-01,
                    1.513E-01, 1.513E-01, 1.513E-01, 1.513E-01, 1.513E-01, 1.513E-01, 1.517E-01, 1.521E-01, 1.525E-01, 1.529E-01,
                    1.533E-01, 1.533E-01, 1.533E-01, 1.534E-01, 1.534E-01, 1.535E-01, 1.535E-01, 1.535E-01, 1.534E-01, 1.534E-01,
                    1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01,
                    1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01,
                    1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.534E-01, 1.532E-01, 1.531E-01, 1.529E-01, 1.527E-01,
                    1.526E-01, 1.523E-01, 1.520E-01, 1.517E-01, 1.515E-01, 1.512E-01, 1.510E-01, 1.509E-01, 1.507E-01, 1.506E-01,
                    1.504E-01, 1.504E-01, 1.504E-01, 1.504E-01, 1.504E-01, 1.504E-01, 1.500E-01, 1.497E-01, 1.493E-01, 1.489E-01,
                    1.486E-01, 1.481E-01, 1.476E-01, 1.471E-01, 1.466E-01, 1.461E-01, 1.454E-01, 1.447E-01, 1.440E-01, 1.433E-01,
                    1.425E-01, 1.414E-01, 1.403E-01, 1.392E-01, 1.381E-01, 1.370E-01, 1.363E-01, 1.355E-01, 1.348E-01, 1.340E-01,
                    1.332E-01, 1.321E-01, 1.309E-01, 1.298E-01, 1.287E-01, 1.275E-01, 1.264E-01, 1.252E-01, 1.240E-01, 1.229E-01,
                    1.217E-01, 1.209E-01, 1.201E-01, 1.193E-01, 1.185E-01, 1.178E-01, 1.169E-01, 1.161E-01, 1.152E-01, 1.143E-01,
                    1.135E-01, 1.128E-01, 1.122E-01, 1.116E-01, 1.109E-01, 1.103E-01, 1.098E-01, 1.093E-01, 1.088E-01, 1.083E-01,
                    1.078E-01, 1.070E-01, 1.062E-01, 1.054E-01, 1.046E-01, 1.039E-01, 1.037E-01, 1.036E-01, 1.035E-01, 1.034E-01,
                    1.032E-01, 1.029E-01, 1.026E-01, 1.024E-01, 1.021E-01, 1.018E-01, 1.016E-01, 1.015E-01, 1.013E-01, 1.012E-01,
                    1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01,
                    1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.010E-01, 1.012E-01, 1.014E-01, 1.016E-01, 1.019E-01,
                    1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.021E-01, 1.020E-01,
                    1.020E-01, 1.023E-01, 1.026E-01, 1.029E-01, 1.032E-01, 1.035E-01, 1.036E-01, 1.037E-01, 1.037E-01, 1.038E-01,
                    1.039E-01, 1.049E-01, 1.059E-01, 1.069E-01, 1.079E-01, 1.088E-01, 1.092E-01, 1.096E-01, 1.100E-01, 1.104E-01,
                    1.107E-01, 1.108E-01, 1.108E-01, 1.108E-01, 1.108E-01, 1.108E-01, 1.114E-01, 1.120E-01, 1.126E-01, 1.133E-01,
                    1.139E-01, 1.144E-01, 1.150E-01, 1.156E-01, 1.161E-01, 1.167E-01, 1.171E-01, 1.175E-01, 1.180E-01, 1.184E-01,
                    1.188E-01, 1.192E-01, 1.196E-01, 1.200E-01, 1.204E-01, 1.208E-01, 1.212E-01, 1.216E-01, 1.220E-01, 1.223E-01,
                    1.227E-01, 1.233E-01, 1.239E-01, 1.245E-01, 1.251E-01, 1.257E-01, 1.262E-01, 1.268E-01, 1.274E-01, 1.279E-01,
                    1.285E-01, 1.291E-01, 1.298E-01, 1.305E-01, 1.311E-01, 1.318E-01, 1.321E-01, 1.324E-01, 1.327E-01, 1.329E-01,
                    1.332E-01, 1.337E-01, 1.342E-01, 1.347E-01, 1.352E-01, 1.357E-01, 1.360E-01, 1.363E-01, 1.366E-01, 1.369E-01,
                    1.372E-01, 1.377E-01, 1.381E-01, 1.385E-01, 1.390E-01, 1.394E-01, 1.396E-01, 1.398E-01, 1.400E-01, 1.403E-01,
                    1.405E-01, 1.407E-01, 1.410E-01, 1.413E-01, 1.415E-01, 1.418E-01, 1.424E-01, 1.429E-01, 1.435E-01, 1.440E-01,
                    1.446E-01, 1.451E-01, 1.455E-01, 1.460E-01, 1.465E-01, 1.470E-01, 1.475E-01, 1.480E-01, 1.485E-01, 1.489E-01,
                    1.494E-01, 1.498E-01, 1.501E-01, 1.504E-01, 1.508E-01, 1.511E-01, 1.512E-01, 1.513E-01, 1.515E-01, 1.516E-01,
                    1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01, 1.517E-01,
                    1.517E-01, 1.521E-01, 1.525E-01, 1.530E-01, 1.534E-01, 1.538E-01, 1.541E-01, 1.544E-01, 1.547E-01, 1.550E-01,
                    1.553E-01, 1.555E-01, 1.557E-01, 1.558E-01, 1.560E-01, 1.562E-01, 1.568E-01, 1.573E-01, 1.578E-01, 1.584E-01,
                    1.589E-01, 1.590E-01, 1.590E-01, 1.591E-01, 1.592E-01, 1.592E-01, 1.594E-01, 1.595E-01, 1.597E-01, 1.598E-01,
                    1.600E-01, 1.600E-01, 1.600E-01, 1.600E-01, 1.600E-01, 1.600E-01, 1.603E-01, 1.606E-01, 1.608E-01, 1.611E-01,
                    1.614E-01, 1.618E-01, 1.621E-01, 1.625E-01, 1.628E-01, 1.631E-01, 1.631E-01, 1.632E-01, 1.632E-01, 1.632E-01,
                    1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01, 1.632E-01,
                    1.632E-01, 1.633E-01, 1.635E-01, 1.636E-01, 1.638E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01,
                    1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01,
                    1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.639E-01, 1.638E-01, 1.638E-01,
                    1.638E-01, 1.639E-01, 1.640E-01, 1.641E-01, 1.641E-01, 1.642E-01, 1.642E-01, 1.642E-01, 1.642E-01, 1.642E-01,
                    1.642E-01, 1.643E-01, 1.643E-01, 1.644E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01,
                    1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01,
                    1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.645E-01, 1.642E-01, 1.639E-01, 1.636E-01, 1.633E-01,
                    1.630E-01, 1.630E-01, 1.630E-01, 1.630E-01, 1.630E-01, 1.630E-01, 1.629E-01, 1.627E-01, 1.626E-01, 1.624E-01,
                    1.623E-01, 1.623E-01, 1.623E-01, 1.623E-01, 1.623E-01, 1.623E-01, 1.617E-01, 1.612E-01, 1.607E-01, 1.602E-01,
                    1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01, 1.597E-01,
                    1.597E-01, 1.594E-01, 1.592E-01, 1.590E-01, 1.588E-01, 1.586E-01, 1.585E-01, 1.585E-01, 1.584E-01, 1.584E-01,
                    1.584E-01, 1.580E-01, 1.576E-01, 1.572E-01, 1.568E-01, 1.563E-01, 1.559E-01, 1.555E-01, 1.550E-01, 1.546E-01,
                    1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01,
                    1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01,
                    1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01, 1.541E-01,
                    1.541E-01, 1.540E-01, 1.539E-01, 1.538E-01, 1.538E-01, 1.537E-01, 1.537E-01, 1.537E-01, 1.537E-01, 1.537E-01,
                    1.537E-01, 1.537E-01, 1.537E-01, 1.537E-01, 1.537E-01, 1.537E-01, 1.536E-01, 1.535E-01, 1.534E-01, 1.534E-01,
                    1.533E-01, 1.533E-01, 1.533E-01, 1.533E-01, 1.533E-01, 1.533E-01, 1.531E-01, 1.528E-01, 1.526E-01, 1.524E-01,
                    1.522E-01, 1.519E-01, 1.517E-01, 1.515E-01, 1.512E-01, 1.510E-01, 1.504E-01, 1.497E-01, 1.491E-01, 1.484E-01,
                    1.478E-01, 1.473E-01, 1.468E-01, 1.463E-01, 1.458E-01, 1.453E-01, 1.441E-01, 1.429E-01, 1.417E-01, 1.404E-01,
                    1.392E-01, 1.384E-01, 1.375E-01, 1.366E-01, 1.358E-01, 1.349E-01, 1.341E-01, 1.332E-01, 1.323E-01, 1.315E-01,
                    1.306E-01, 1.287E-01, 1.269E-01, 1.250E-01, 1.231E-01, 1.212E-01, 1.192E-01, 1.171E-01, 1.151E-01, 1.131E-01,
                    1.111E-01, 1.077E-01, 1.044E-01, 1.010E-01, 9.765E-02, 9.430E-02, 9.322E-02, 9.214E-02, 9.106E-02, 8.998E-02,
                    8.890E-02, 8.870E-02, 8.850E-02, 8.829E-02, 8.809E-02, 8.789E-02, 8.823E-02, 8.857E-02, 8.891E-02, 8.924E-02,
                    8.958E-02, 9.038E-02, 9.118E-02, 9.198E-02, 9.278E-02, 9.358E-02, 9.411E-02, 9.464E-02, 9.518E-02, 9.571E-02,
                    9.624E-02, 9.694E-02, 9.765E-02, 9.835E-02, 9.905E-02, 9.975E-02, 9.931E-02, 9.886E-02, 9.842E-02, 9.797E-02,
                    9.752E-02, 9.511E-02, 9.269E-02, 9.027E-02, 8.786E-02, 8.544E-02, 8.363E-02, 8.182E-02, 8.002E-02, 7.821E-02,
                    7.640E-02, 7.433E-02, 7.226E-02, 7.020E-02, 6.813E-02, 6.606E-02, 6.446E-02, 6.285E-02, 6.124E-02, 5.963E-02,
                    5.802E-02, 5.701E-02, 5.600E-02, 5.499E-02, 5.398E-02, 5.297E-02, 5.225E-02, 5.154E-02, 5.083E-02, 5.011E-02,
                    4.940E-02, 4.883E-02, 4.826E-02, 4.769E-02, 4.712E-02, 4.655E-02, 4.626E-02, 4.597E-02, 4.567E-02, 4.538E-02,
                    4.508E-02, 4.508E-02, 4.508E-02, 4.508E-02, 4.507E-02, 4.507E-02, 4.529E-02, 4.550E-02, 4.572E-02, 4.594E-02,
                    4.615E-02, 4.615E-02, 4.615E-02, 4.615E-02, 4.614E-02, 4.614E-02, 4.614E-02, 4.614E-02, 4.613E-02, 4.613E-02,
                    4.613E-02, 4.613E-02, 4.612E-02, 4.612E-02, 4.612E-02, 4.612E-02, 4.626E-02, 4.640E-02, 4.655E-02, 4.669E-02,
                    4.683E-02, 4.731E-02, 4.779E-02, 4.827E-02, 4.875E-02, 4.922E-02, 4.965E-02, 5.009E-02, 5.052E-02, 5.095E-02,
                    5.138E-02, 5.192E-02, 5.246E-02, 5.299E-02, 5.353E-02, 5.407E-02, 5.463E-02, 5.518E-02, 5.574E-02, 5.630E-02,
                    5.685E-02, 5.702E-02, 5.720E-02, 5.737E-02, 5.754E-02, 5.771E-02, 5.807E-02, 5.843E-02, 5.879E-02, 5.916E-02,
                    5.952E-02, 6.013E-02, 6.073E-02, 6.134E-02, 6.194E-02, 6.255E-02, 6.301E-02, 6.347E-02, 6.393E-02, 6.439E-02,
                    6.486E-02, 6.524E-02, 6.563E-02, 6.601E-02, 6.640E-02, 6.679E-02, 6.720E-02, 6.761E-02, 6.802E-02, 6.843E-02,
                    6.885E-02, 6.943E-02, 7.002E-02, 7.060E-02, 7.119E-02, 7.177E-02, 7.267E-02, 7.356E-02, 7.445E-02, 7.534E-02,
                    7.623E-02, 7.693E-02, 7.764E-02, 7.834E-02, 7.904E-02, 7.974E-02, 8.027E-02, 8.080E-02, 8.133E-02, 8.186E-02,
                    8.239E-02, 8.283E-02, 8.327E-02, 8.371E-02, 8.415E-02, 8.459E-02, 8.514E-02, 8.570E-02, 8.626E-02, 8.681E-02,
                    8.737E-02, 8.764E-02, 8.791E-02, 8.817E-02, 8.844E-02, 8.871E-02, 8.911E-02, 8.951E-02, 8.992E-02, 9.032E-02,
                    9.072E-02, 9.072E-02, 9.072E-02, 9.071E-02, 9.071E-02, 9.071E-02, 9.089E-02, 9.107E-02, 9.125E-02, 9.143E-02,
                    9.162E-02, 9.209E-02, 9.256E-02, 9.303E-02, 9.350E-02, 9.397E-02, 9.447E-02, 9.496E-02, 9.546E-02, 9.596E-02,
                    9.646E-02, 9.691E-02, 9.737E-02, 9.782E-02, 9.827E-02, 9.872E-02, 9.886E-02, 9.899E-02, 9.913E-02, 9.926E-02,
                    9.940E-02, 9.976E-02, 1.001E-01, 1.005E-01, 1.008E-01, 1.012E-01, 1.018E-01, 1.025E-01, 1.031E-01, 1.037E-01,
                    1.043E-01, 1.045E-01, 1.047E-01, 1.049E-01, 1.051E-01, 1.053E-01, 1.059E-01, 1.064E-01, 1.070E-01, 1.075E-01,
                    1.081E-01, 1.081E-01, 1.081E-01, 1.081E-01, 1.081E-01, 1.081E-01, 1.086E-01, 1.092E-01, 1.098E-01, 1.103E-01,
                    1.109E-01, 1.111E-01, 1.114E-01, 1.116E-01, 1.118E-01, 1.121E-01, 1.121E-01, 1.122E-01, 1.123E-01, 1.124E-01,
                    1.124E-01, 1.128E-01, 1.132E-01, 1.136E-01, 1.140E-01, 1.144E-01, 1.145E-01, 1.146E-01, 1.147E-01, 1.148E-01,
                    1.150E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01,
                    1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01,
                    1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01, 1.149E-01,
                    1.149E-01, 1.149E-01, 1.150E-01, 1.151E-01, 1.152E-01, 1.152E-01, 1.155E-01, 1.157E-01, 1.160E-01, 1.163E-01,
                    1.165E-01, 1.165E-01, 1.166E-01, 1.166E-01, 1.166E-01, 1.167E-01, 1.174E-01, 1.181E-01, 1.188E-01, 1.196E-01,
                    1.203E-01, 1.201E-01, 1.200E-01, 1.199E-01, 1.197E-01, 1.196E-01, 1.191E-01, 1.186E-01, 1.181E-01, 1.176E-01,
                    1.171E-01, 1.167E-01, 1.163E-01, 1.159E-01, 1.156E-01, 1.152E-01, 1.152E-01, 1.152E-01, 1.151E-01, 1.151E-01,
                    1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01,
                    1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01,
                    1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01, 1.151E-01,
                    1.151E-01, 1.150E-01, 1.149E-01, 1.148E-01, 1.148E-01, 1.147E-01, 1.141E-01, 1.134E-01, 1.128E-01, 1.121E-01,
                    1.115E-01, 1.115E-01, 1.115E-01, 1.114E-01, 1.114E-01, 1.114E-01, 1.111E-01, 1.108E-01, 1.105E-01, 1.102E-01,
                    1.099E-01, 1.097E-01, 1.095E-01, 1.093E-01, 1.091E-01, 1.089E-01, 1.086E-01, 1.084E-01, 1.082E-01, 1.079E-01,
                    1.077E-01, 1.074E-01, 1.071E-01, 1.068E-01, 1.064E-01, 1.061E-01, 1.056E-01, 1.051E-01, 1.046E-01, 1.041E-01,
                    1.036E-01, 1.029E-01, 1.021E-01, 1.013E-01, 1.005E-01, 9.971E-02, 9.941E-02, 9.910E-02, 9.879E-02, 9.849E-02,
                    9.818E-02, 9.818E-02, 9.818E-02, 9.817E-02, 9.817E-02, 9.817E-02, 9.817E-02, 9.817E-02, 9.816E-02, 9.816E-02,
                    9.816E-02, 9.809E-02, 9.802E-02, 9.795E-02, 9.788E-02, 9.781E-02, 9.741E-02, 9.700E-02, 9.660E-02, 9.620E-02,
                    9.580E-02, 9.537E-02, 9.495E-02, 9.453E-02, 9.411E-02, 9.369E-02, 9.319E-02, 9.269E-02, 9.219E-02, 9.169E-02,
                    9.118E-02, 9.118E-02, 9.118E-02, 9.118E-02, 9.117E-02, 9.117E-02, 9.078E-02, 9.039E-02, 9.000E-02, 8.961E-02,
                    8.922E-02, 8.888E-02, 8.853E-02, 8.819E-02, 8.785E-02, 8.750E-02, 8.779E-02, 8.808E-02, 8.837E-02, 8.866E-02,
                    8.895E-02, 8.865E-02, 8.836E-02, 8.807E-02, 8.777E-02, 8.748E-02, 8.680E-02, 8.613E-02, 8.546E-02, 8.478E-02,
                    8.411E-02, 8.332E-02, 8.254E-02, 8.176E-02, 8.097E-02, 8.019E-02, 8.011E-02, 8.003E-02, 7.995E-02, 7.987E-02,
                    7.979E-02, 7.946E-02, 7.914E-02, 7.882E-02, 7.849E-02, 7.817E-02, 7.754E-02, 7.691E-02, 7.628E-02, 7.565E-02,
                    7.502E-02, 7.496E-02, 7.489E-02, 7.483E-02, 7.476E-02, 7.470E-02, 7.394E-02, 7.318E-02, 7.242E-02, 7.167E-02,
                    7.091E-02, 7.083E-02, 7.074E-02, 7.066E-02, 7.058E-02, 7.050E-02, 7.015E-02, 6.981E-02, 6.946E-02, 6.912E-02,
                    6.878E-02, 6.878E-02, 6.877E-02, 6.877E-02, 6.877E-02, 6.877E-02, 6.803E-02, 6.730E-02, 6.657E-02, 6.584E-02,
                    6.511E-02, 6.445E-02, 6.379E-02, 6.313E-02, 6.247E-02, 6.182E-02, 6.167E-02, 6.153E-02, 6.138E-02, 6.124E-02,
                    6.110E-02, 6.018E-02, 5.927E-02, 5.835E-02, 5.743E-02, 5.652E-02, 5.619E-02, 5.585E-02, 5.552E-02, 5.519E-02,
                    5.485E-02, 5.485E-02, 5.485E-02, 5.485E-02, 5.484E-02, 5.484E-02, 5.455E-02, 5.425E-02, 5.396E-02, 5.366E-02,
                    5.337E-02, 5.337E-02, 5.337E-02, 5.336E-02, 5.336E-02, 5.336E-02, 5.316E-02, 5.297E-02, 5.278E-02, 5.258E-02,
                    5.239E-02, 5.192E-02, 5.145E-02, 5.099E-02, 5.052E-02, 5.005E-02, 4.963E-02, 4.921E-02, 4.878E-02, 4.836E-02,
                    4.793E-02, 4.777E-02, 4.761E-02, 4.744E-02, 4.728E-02, 4.711E-02, 4.727E-02, 4.743E-02, 4.759E-02, 4.774E-02,
                    4.790E-02, 4.796E-02, 4.801E-02, 4.807E-02, 4.813E-02, 4.818E-02, 4.833E-02, 4.847E-02, 4.861E-02, 4.876E-02,
                    4.890E-02, 4.904E-02, 4.919E-02, 4.933E-02, 4.947E-02, 4.962E-02, 4.961E-02, 4.961E-02, 4.961E-02, 4.961E-02,
                    4.960E-02, 4.960E-02, 4.960E-02, 4.960E-02, 4.959E-02, 4.959E-02, 4.944E-02, 4.930E-02, 4.915E-02, 4.900E-02,
                    4.885E-02])

# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=40)
P4_t12 = np.array([0.95890472623217504, 0.95881388502324549, 0.95873598378392644, 0.95863206198236528, 0.95848907001894701, 0.95834596329858113, 0.95820274230132896, 0.95804637144334892, 0.95785071836623759, 0.95768098291198989, 0.95752416508233873, 0.95739338211651925, 0.95721013174790015, 0.95701359340659375, 0.95680372729379537, 0.95660676791731813, 0.95640960661427543, 0.95622540824518321, 0.95604103593741685, 0.95584330222966396, 0.95564537108070124, 0.95547367193100363, 0.95528860112175784, 0.95510336110846439, 0.95490470294869134, 0.95469258925635292, 0.95453336141034506, 0.95444042232122073, 0.95432086860378629, 0.95420124693104891, 0.95409485970052965, 0.95400172711664999, 0.95389524002057036, 0.95380202031229011, 0.95370876012208095, 0.95362879068061324, 0.95354879164969719, 0.95349544255847418, 0.95344208036832134, 0.95337535924181549, 0.95330861772104525, 0.953228501032515, 0.95316171478638301, 0.95309490827497512, 0.95304144850186201, 0.952974605614203, 0.95294786281409449, 0.95290774257367195, 0.95286761509262596, 0.95281410053629723, 0.95277395619403782, 0.95274718929207247, 0.95270703293483017, 0.95268025803085443, 0.95266686938007339, 0.9526534799305314, 0.95266686938007339, 0.95268025803085443, 0.95268025803085443, 0.95270703293483017, 0.95274718929207247, 0.95280071989072379, 0.95286761509262596, 0.9529344902056659, 0.95300134518985602, 0.9530681800051376, 0.95313499461139861, 0.95320178896847185, 0.95324185584636867, 0.95328191541138174, 0.95330861772104525, 0.95334866507855753, 0.95338870509995344, 0.95340205014199619, 0.95342873777649939, 0.95345542214275381, 0.9534687630994706, 0.95348210323815186, 0.95349544255847418, 0.95350878106011638, 0.95353545560605035, 0.95356212687336483, 0.95360212762122298, 0.9536554504522875, 0.9537220854806453, 0.95381533989456768, 0.95390855381057693, 0.95404164607411346, 0.954187951449741, 0.95434744197769772, 0.95455990784258493, 0.95477215741099952, 0.95503716313049947, 0.95531505018977592, 0.95563216867878353, 0.95596196622093255, 0.95633068581523484, 0.9567118381211851, 0.95711843936120533, 0.95753723831399484, 0.95796813542187742, 0.9584240357068684, 0.95889175179374864, 0.95935822415691296, 0.95982343570195205, 0.96030023778345752, 0.96076283945241725, 0.96121133178579221, 0.96164580551852619, 0.96207907685795069, 0.96248574954971722, 0.96286601408477546, 0.96323268111397675, 0.9635732372977962, 0.96388785200668958, 0.96417668464695605, 0.96443988408765113, 0.96467758812447224, 0.96488992298268361, 0.96507700286107889, 0.96523892951883294, 0.96538822699030813, 0.96551251392886661, 0.96562427260289041, 0.96572353419567725, 0.96581032656976606, 0.96587228588323948, 0.96593421576991323, 0.96599611617624348, 0.96604561523941235, 0.96609509537333904, 0.9661445565504917, 0.96619399874331902, 0.96624342192420976, 0.96629282606554612, 0.96634221113966856, 0.96639157711888557, 0.96644092397547199, 0.96650258061270755, 0.96655188434182671, 0.96660116885798053, 0.96666274744247105, 0.96671198862750729, 0.96677351295976854, 0.96682271067224312, 0.96687188901807586, 0.96692104796922029, 0.96698246934158161, 0.96703158455194549, 0.96708068027623217, 0.96714202248634196, 0.96719107426382445, 0.96725236145104487, 0.96731361799263971, 0.96737484383323569, 0.96743603891737939, 0.96750943234166376, 0.96758278130057662, 0.96766829875823235, 0.9677415510449886, 0.96782695545400843, 0.96791229877111629, 0.967997580842196, 0.96808280151281689, 0.96816796062820953, 0.96825305803330197, 0.96833809357267953, 0.96842306709060622, 0.96850797843102554, 0.96859282743754582, 0.96866550542593521, 0.96875023825346207, 0.96882281642754509, 0.968895348376413, 0.96896783400062259, 0.9690282032287022, 0.96908854015994395, 0.96914884473651208, 0.96920911690048794, 0.96925731125561376, 0.96930548479981604, 0.96935363750330716, 0.96938973833627529, 0.96942582741699268, 0.96946190473284277, 0.96949797027122575, 0.96952200741420014, 0.96955805329540168, 0.96958207732188928, 0.9696181035107766, 0.96964211439734016, 0.9696661200213611, 0.96969012037908464, 0.9697141154667599, 0.96973810528061322, 0.96976208981688938, 0.96978606907181719, 0.96981004304162677, 0.96983401172255079, 0.96984599407850214, 0.96986995481902771, 0.9698939102612244, 0.96991786040131989, 0.96992983348189687, 0.9699537756617499, 0.9699657447600829, 0.96997771253005138, 0.96998967897118282, 0.96998967897118282, 0.97000164408299472, 0.97000164408299472, 0.97000164408299472, 0.97000164408299472, 0.96998967897118282, 0.96997771253005138, 0.9699657447600829, 0.9699537756617499, 0.96994180523553641, 0.96992983348189687, 0.96991786040131989, 0.96991786040131989, 0.96990588599427197, 0.96990588599427197, 0.96990588599427197, 0.96990588599427197, 0.96990588599427197, 0.96991786040131989, 0.96992983348189687, 0.9699537756617499, 0.9699657447600829, 0.96997771253005138, 0.96998967897118282, 0.96998967897118282, 0.96997771253005138, 0.9699657447600829, 0.96994180523553641, 0.96990588599427197, 0.96984599407850214, 0.96978606907181719, 0.96970211858191269, 0.96960609609521686, 0.96948594973449176, 0.96935363750330716, 0.9692211674386596, 0.96906440926676862, 0.96890743253346412, 0.96873813740397574, 0.96858070997319234, 0.96842306709060622, 0.9682773602213276, 0.96814363574256301, 0.9680097589865323, 0.96787573055430454, 0.96775375540933617, 0.9676194390754409, 0.96746050832680364, 0.96728911905702208, 0.96709295115929828, 0.9668473022677373, 0.96657652900326307, 0.96625577474557856, 0.96590944734988948, 0.96552493622381352, 0.96511438783393455, 0.96469008752266383, 0.96425193505419804, 0.96379982958064991, 0.96335890606394281, 0.96292929748282441, 0.96251113048416992, 0.96210452563590398, 0.96172235297237818, 0.96133924209545285, 0.96098083468187567, 0.9606216274996715, 0.96027449952776545, 0.95992664308899978, 0.95960391068017259, 0.95930645584276442, 0.95906034450763966, 0.95890472623217504, 0.95885282272201422, 0.95896958401676602, 0.95925467198670344, 0.95973307745781811, 0.96040315077553851, 0.96126250825517812, 0.96224441845822906, 0.96332105004264657, 0.96442736203732826, 0.9654876658452598, 0.96646559022410106, 0.96731361799263971, 0.96803411151419005, 0.9686170585398246, 0.96905234188005684, 0.96935363750330716, 0.96954603931339622, 0.96965411786740485, 0.96967812085874527, 0.96963010961164253, 0.96954603931339622, 0.96941379903000557, 0.96925731125561376, 0.96907647536021335, 0.96887117620239105, 0.96866550542593521, 0.96844733382505765, 0.96821659528316151, 0.96798540144479073, 0.96775375540933617, 0.96750943234166376, 0.96726461521279006, 0.96701930757507437, 0.96677351295976854, 0.96651490834467924, 0.96626812637655124, 0.96602086807226362, 0.9657731368790643, 0.96552493622381352, 0.96527626951312828, 0.96503960753884166, 0.96480253089284473, 0.96457755205799567, 0.96435220605654559, 0.96412649530321204, 0.96391299128219687, 0.96371175287623245, 0.96351023162262006, 0.96332105004264657, 0.96313162269073505, 0.96296725456631793, 0.9628027037396788, 0.96263797108755467, 0.96249844055012668, 0.96235878098261185, 0.96223170621344722, 0.96211724844383706, 0.96200270525563536, 0.96191355723717298, 0.9618243578524035, 0.96174786045486493, 0.96167132550110024, 0.96162028137545885, 0.96156922062027761, 0.96153091415566871, 0.96149259836133727, 0.96146704932042704, 0.96145427324772303, 0.96144149614070185, 0.96144149614070185, 0.96144149614070185, 0.96144149614070185, 0.96145427324772303, 0.96146704932042704, 0.96147982435842538, 0.96149259836133727, 0.96151814326034257, 0.96154368401435353, 0.96156922062027761, 0.96159475307500608, 0.96160751774471265, 0.96163304396685878, 0.96165856603006572, 0.9616840839312345, 0.96170959766726383, 0.9617351072350393, 0.9617606126314574, 0.96178611385341284, 0.96181161089778133, 0.96183710376146192, 0.96186259244133232, 0.96188807693427414, 0.96191355723717298, 0.96193903334690534, 0.96196450526035182, 0.96198997297437483, 0.96201543648587073, 0.96204089579169283, 0.96206635088871861, 0.96207907685795069, 0.96210452563590398, 0.96212997019722657, 0.96214269089566973, 0.96216812912616811, 0.96219356313218518, 0.96220627855003382, 0.96223170621344722, 0.96225712964453403, 0.96228254884014119, 0.96229525684865458, 0.96232066968514385, 0.96234607827828156, 0.96237148262492056, 0.96239688272189983, 0.96240958117578157, 0.96243497489236451, 0.96246036435139792, 0.96248574954971722, 0.96251113048416992, 0.96252381935146047, 0.96254919388416837, 0.96257456414509468, 0.96258724767265136, 0.96261261151995625, 0.96263797108755467, 0.9626633263722737, 0.96268867737092878, 0.96270135126199585, 0.962726695825601, 0.96273936649735958, 0.96276470461876484, 0.96277737206762681, 0.9628027037396788, 0.9628280311081745, 0.96284069317759313, 0.96286601408477546, 0.96289133068043753, 0.96290398736044369, 0.96292929748282441, 0.96294195092439827, 0.96296725456631793, 0.96297990476586182, 0.9630052019201164, 0.9630304947452677, 0.96304313953342768, 0.96306842585891195, 0.96309370784728654, 0.9631063472140472, 0.96313162269073505, 0.9631568938222782, 0.96316952775762499, 0.96319479236544447, 0.96320742303711804, 0.96322005262009258, 0.96323268111397675, 0.96325793483284317, 0.96327056005702061, 0.96329580723286001, 0.96330842918370674, 0.96333366980926649, 0.96334628848316473, 0.96335890606394281, 0.96338413794450573, 0.96339675224348886, 0.96342197755683423, 0.96344719848799831, 0.96345980730924807, 0.96347241503374437, 0.96349762719082888, 0.96351023162262006, 0.96353543719065504, 0.96354803832609803, 0.96356063836194539, 0.96358583513324159, 0.96359843186787919, 0.96361102750129646, 0.9636236220330987, 0.96363621546287481, 0.96366139901472403, 0.96368657815358882, 0.96369916606714479, 0.96372433858044204, 0.96374950667263104, 0.96376208905979399, 0.96377467034045639, 0.96377467034045639, 0.96378725051420611, 0.96379982958064991, 0.96381240753936637, 0.96382498438995867, 0.96385013476512071, 0.9638752807028671, 0.96388785200668958, 0.96391299128219687, 0.96393812611212126, 0.9639506918589702, 0.96397582001438753, 0.96398838242214302, 0.96401350389568718, 0.96402606296066651, 0.96403862091056436, 0.96406373346348673, 0.96407628806568835, 0.96410139391952798, 0.96411394517034088, 0.96413904431771691, 0.96416413898999687, 0.96417668464695605, 0.96420177260044393, 0.96421431489615417, 0.96423939612344189, 0.96425193505419804, 0.96426447286247929, 0.96428954510997156, 0.96431461286262177, 0.96432714505234929, 0.96435220605654559, 0.96436473487018359, 0.96437726255763967, 0.96440231455233671, 0.96441483885875701, 0.96443988408765113, 0.96445240500930474, 0.96446492480187451, 0.96448996099811257, 0.96450247740095607, 0.96452750681401211, 0.96454001982339943, 0.9645650424458031, 0.96457755205799567, 0.96460256788228371, 0.96461507409354619, 0.96462757917034136, 0.96465258591884961, 0.96466508758972536, 0.96467758812447224, 0.96470258578388424, 0.96472757889376848, 0.96474007374159121, 0.96476506002090967, 0.96477755145158051, 0.96480253089284473, 0.96481501890260413, 0.96483999149830024, 0.96486495952610574, 0.96487744182600488, 0.96490240299571584, 0.96491488186467789, 0.96493983616876078, 0.96495231160303063, 0.96496478589156998, 0.96498973102974916, 0.96501467157996323, 0.96503960753884166, 0.96506453890304078, 0.96507700286107889, 0.96508946566919529, 0.96510192732695521, 0.9651268471897303, 0.96515176244606748, 0.96518912668610857, 0.96521403041159126, 0.96523892951883294, 0.96525137733956246, 0.96527626951312828, 0.96528871386511483, 0.96528871386511483, 0.96528871386511483, 0.96530115706001673, 0.96533847969795283, 0.96536335566338249, 0.96538822699030813, 0.96540066091327159, 0.96542552527610015, 0.96543795571511215, 0.96545038499195523, 0.96546281310620763, 0.9654876658452598, 0.9654876658452598, 0.9654876658452598, 0.96552493622381352, 0.9655497773178815, 0.96557461374802467, 0.96558703021304648, 0.96559944551082166, 0.96559944551082166, 0.96561185964090712, 0.96562427260289041, 0.96561185964090712, 0.96561185964090712, 0.96562427260289041, 0.96564909502080876, 0.96567391276119063, 0.96569872582061678, 0.96571113059390601, 0.96572353419567725, 0.96573593662550827, 0.96576073796762896, 0.9657731368790643, 0.96579793118056212, 0.96582272078403486, 0.96583511382295151, 0.96585989637298075, 0.96585989637298075, 0.96587228588323948, 0.96585989637298075, 0.96585989637298075, 0.96584750568607047, 0.96584750568607047, 0.96585989637298075, 0.96587228588323948, 0.96588467421643553, 0.96590944734988948, 0.96593421576991323, 0.96595897947309362, 0.96598373845597985, 0.9660084927151501, 0.96603324224716292, 0.96604561523941235, 0.96605798704858703, 0.96608272711597876, 0.96610746244590451, 0.96611982833323995, 0.96613219303491227, 0.9661445565504917, 0.9661445565504917, 0.9661445565504917, 0.96615691887955746, 0.96616928002167135, 0.96618163997640383, 0.96620635632198704, 0.96621871271198112, 0.96623106791286373, 0.96624342192420976, 0.96624342192420976, 0.96625577474557856, 0.96626812637655124, 0.96629282606554612, 0.96631752098773949, 0.96634221113966856, 0.96636689651787533, 0.96639157711888557, 0.96640391562686234, 0.96641625293924349, 0.96642858905559181, 0.96644092397547199, 0.96645325769845503, 0.96647792155198564, 0.96647792155198564, 0.96649025168166025, 0.96649025168166025, 0.96650258061270755, 0.96650258061270755, 0.96650258061270755, 0.96650258061270755, 0.96650258061270755, 0.96650258061270755, 0.96652723487714398, 0.96652723487714398, 0.96655188434182671, 0.96656420727316417, 0.96658884953167745, 0.96661348698172267, 0.96662580390248332, 0.9666381196198186, 0.96665043413329654, 0.96666274744247105, 0.96667505954691801, 0.96667505954691801, 0.96668737044620001, 0.96669968013988017, 0.96672429590866849, 0.96673660198290634, 0.9667612105088883, 0.9667612105088883, 0.9667612105088883, 0.96677351295976854, 0.96678581420197829, 0.96679811423508399, 0.96681041305864601, 0.96682271067224312, 0.96683500707542103, 0.9668595962487726, 0.9668595962487726, 0.9668595962487726, 0.9668595962487726, 0.9668595962487726, 0.96687188901807586, 0.96688418057520764, 0.96689647091973585, 0.96692104796922029, 0.9669333346732919, 0.96694562016300878, 0.96697018749758701, 0.96698246934158161, 0.96700702938076055, 0.96701930757507437, 0.96703158455194549, 0.96705613485160824, 0.96706840817352402, 0.96708068027623217, 0.96709295115929828, 0.96710522082228301, 0.96710522082228301, 0.96711748926474872, 0.96712975648624566, 0.96715428726458752, 0.96716655082053993, 0.96719107426382445, 0.96720333415025983, 0.96722785025053237, 0.96724010646348513, 0.96724010646348513, 0.96725236145104487, 0.96726461521279006, 0.96727686774825794, 0.96731361799263971, 0.96733811201610087, 0.96735035718466866, 0.96736260112385597, 0.96737484383323569, 0.96738708531235562, 0.96739932556077446, 0.96739932556077446, 0.96742380236372572, 0.96744827423855329, 0.96746050832680364, 0.9674849728027507, 0.9674849728027507, 0.96747274118167959, 0.96747274118167959, 0.96747274118167959, 0.96747274118167959, 0.9674849728027507, 0.9674849728027507, 0.96749720318955168, 0.96752166025861841, 0.96754611238530153, 0.96757055956604809, 0.96758278130057662, 0.96759500179728264, 0.9676194390754409, 0.96764387139694663, 0.96766829875823235, 0.96766829875823235, 0.96768051057767623, 0.96769272115571747, 0.96769272115571747, 0.96771713858582964, 0.96772934543700195, 0.9677415510449886, 0.96775375540933617, 0.96777816040533615, 0.96779036103609384, 0.96780256042142199, 0.96781475856087895, 0.96781475856087895, 0.96782695545400843, 0.9678391511003599, 0.96786353865096419, 0.96788792120907963, 0.96790011061482972, 0.96791229877111629, 0.96792448567748124, 0.96796103889257323, 0.967997580842196, 0.9680219358773452, 0.96804628589660702, 0.96807063089637135, 0.96808280151281689, 0.9680949708730231, 0.96810713897656409, 0.96813147141178291, 0.96815579881486014, 0.96818012118216734, 0.96820443851009297, 0.96820443851009297, 0.96821659528316151, 0.96821659528316151, 0.96821659528316151, 0.96822875079501858, 0.96822875079501858, 0.9682409050452172, 0.9682409050452172, 0.96826520975882624, 0.9682773602213276, 0.96830165735546181, 0.96830165735546181, 0.96831380402618894, 0.96831380402618894, 0.96833809357267953, 0.96837451839819899, 0.96839879528043715, 0.96841093181975857, 0.96842306709060622, 0.96841093181975857, 0.96841093181975857, 0.96842306709060622, 0.96842306709060622, 0.96843520109252512, 0.96845946528776206, 0.96848372440180475, 0.96850797843102554, 0.96852010353768614, 0.96850797843102554, 0.96848372440180475, 0.96844733382505765, 0.96843520109252512, 0.96843520109252512, 0.96845946528776206, 0.9684958520522492, 0.96854434993281546, 0.96859282743754582, 0.96862917217684741, 0.96865339562036301, 0.96865339562036301, 0.96864128453718235, 0.96864128453718235, 0.96865339562036301, 0.96866550542593521, 0.96867761395344398, 0.96870182717243658, 0.96872603527366541, 0.96873813740397574, 0.96876233782167631, 0.96876233782167631, 0.96877443610815839, 0.96878653311244978, 0.96879862883408097, 0.96882281642754509, 0.96882281642754509, 0.96883490829845931, 0.96883490829845931, 0.96885908818634425, 0.96888326293256977, 0.968895348376413, 0.96891951540325316, 0.96893159698532583, 0.96894367727921327, 0.96896783400062259, 0.96900405940985379, 0.9690282032287022, 0.96904027320054253, 0.96905234188005684, 0.96906440926676862, 0.96908854015994395, 0.96908854015994395, 0.96908854015994395, 0.96910060366548478, 0.96912472679214556, 0.96913678641234857, 0.96914884473651208, 0.96916090176416914, 0.96916090176416914, 0.96918501192812323, 0.96919706506348313, 0.96923321667756202, 0.96926935659385338, 0.96929344336641943, 0.96930548479981604, 0.96934160128287661, 0.96935363750330716, 0.9693656724193267, 0.9693656724193267, 0.9693656724193267, 0.96938973833627529, 0.96941379903000557, 0.96942582741699268, 0.96943785449677256, 0.96943785449677256, 0.9694498802688799, 0.9694498802688799, 0.96946190473284277, 0.96948594973449176, 0.96950998949795553, 0.96952200741420014, 0.9695340240195025, 0.96955805329540168, 0.96955805329540168, 0.9695700659650538, 0.9695700659650538, 0.96958207732188928, 0.96960609609521686, 0.96963010961164253, 0.96965411786740485, 0.9696661200213611, 0.96967812085874527, 0.96967812085874527, 0.9696661200213611, 0.9696661200213611, 0.96969012037908464, 0.9697141154667599, 0.96973810528061322, 0.96976208981688938, 0.96978606907181719, 0.96979805671759645, 0.96981004304162677, 0.96981004304162677, 0.96981004304162677, 0.96982202804343975, 0.96984599407850214, 0.96986995481902771, 0.96990588599427197, 0.96992983348189687, 0.96994180523553641, 0.9699537756617499, 0.9699657447600829, 0.96997771253005138, 0.9699657447600829, 0.9699657447600829, 0.9699657447600829, 0.96997771253005138, 0.96998967897118282, 0.97000164408299472, 0.97002557031681647, 0.97006144968587182, 0.97008536260526013, 0.97010927019223836, 0.97013317244300334, 0.97013317244300334, 0.97015706935375357, 0.97016901580543236, 0.97019290469902719, 0.97021678824309654, 0.97022872800787197, 0.97024066643382412, 0.97024066643382412, 0.97024066643382412, 0.97022872800787197, 0.97021678824309654, 0.97020484713999278, 0.97020484713999278, 0.97021678824309654, 0.97024066643382412, 0.97026453926741008, 0.97028840674002781, 0.97030033846478414, 0.97031226884785959, 0.97032419788879898, 0.97034805194230433, 0.97035997695391851, 0.9703719006214736, 0.9703719006214736, 0.9703719006214736, 0.97035997695391851, 0.97035997695391851, 0.9703719006214736, 0.97039574392249806, 0.97041958184152566, 0.97041958184152566, 0.97040766355499919, 0.97039574392249806, 0.97041958184152566, 0.97045532862048089, 0.97049106326842538, 0.97051487962121652, 0.97052678577241425, 0.97053869057284725, 0.97052678577241425, 0.97050297211971948, 0.97049106326842538, 0.97050297211971948, 0.97051487962121652, 0.97056249611948386, 0.97062198631401431, 0.97068144264319267, 0.97074086504682844, 0.97076462449562928, 0.97077650217965961, 0.97080025346461485, 0.97081212706455045, 0.97084773968845306, 0.97087147461960632, 0.97089520409175167, 0.97085960783616221, 0.97084773968845306, 0.97078837850281674, 0.97075274545118262, 0.97071710016029633, 0.97070521567909196, 0.97071710016029633, 0.97077650217965961, 0.97087147461960632, 0.9709426466434955, 0.97099006731266613, 0.97102561843541246, 0.97099006731266613, 0.97095450386349647, 0.97093078805583932, 0.97089520409175167, 0.97089520409175167, 0.97089520409175167, 0.97085960783616221, 0.97087147461960632, 0.97090706677947558, 0.97087147461960632, 0.97083587017696094, 0.97080025346461485, 0.97078837850281674, 0.97066955408947531, 0.97071710016029633, 0.97077650217965961, 0.97088334003829535, 0.97088334003829535, 0.97103746606818409, 0.97115586688049571, 0.97123866558115979, 0.97136864115649146, 0.97127413005079677, 0.97139225509047156, 0.97142766559367666, 0.97146306360775769, 0.97143946632003131, 0.9715456103306076, 0.97136864115649146, 0.97135683211141832, 0.97148665533886447, 0.97153382211549422, 0.97158096661839932, 0.97162808881605101, 0.97165164154053263, 0.97175755959006793, 0.97176932126136983, 0.97172226616917623, 0.97156918258256253, 0.97155739715313372, 0.97155739715313372, 0.97155739715313372, 0.97163986587656292, 0.97168696014821432, 0.97167518867685088, 0.97167518867685088, 0.97166341580745452, 0.97167518867685088, 0.97171049889486882, 0.97174579651727289, 0.97176932126136983, 0.97183986183003213, 0.97186336411848517, 0.97189860700522235, 0.97195731699413046, 0.97201599173454178, 0.97209807703499751, 0.97216838064927613, 0.97230883452514005, 0.97240235649988582, 0.97248411321531814, 0.97256579973787705, 0.9726357607579954, 0.97272896151045696, 0.972798801476908, 0.97290346377385351, 0.97297317337605682, 0.97312403114920909, 0.97322832662267889, 0.97330936329546736, 0.97341344752842163, 0.97351741241573519, 0.97357511897834315, 0.97364431798590467, 0.9737249826413138, 0.97380557441252336, 0.97389758981808827, 0.97401247446854744, 0.974104274176116, 0.97419597758033383, 0.97426469177189323, 0.97431047099729573, 0.97435622599462635, 0.97439052632254375, 0.97439052632254375, 0.97442481298875572, 0.97448192703408465, 0.97456182274925285, 0.97461884534924681, 0.97467582973361111, 0.97473277583547369, 0.97476692509314045, 0.97482380980367678, 0.97488065605737295, 0.97485792217501988, 0.97486928988640598, 0.9748920206873789, 0.9748920206873789, 0.97491474532235201, 0.9749601760770451, 0.97492610532623913, 0.97494882070412414, 0.97497152990522806, 0.97494882070412414, 0.97500558211597754, 0.97505096340461339, 0.97502827585624241, 0.97507364475674818, 0.97501692975982956, 0.97503962040468495, 0.97502827585624241, 0.9749942329252349, 0.97500558211597754, 0.97497152990522806, 0.97502827585624241, 0.97506230485547873, 0.97513032100021568, 0.97511898885504567, 0.9751529806314686, 0.97517563404701291, 0.97513032100021568, 0.97513032100021568, 0.97503962040468495, 0.97505096340461339, 0.97500558211597754, 0.97503962040468495, 0.97505096340461339, 0.97510765515757258, 0.97507364475674818, 0.9750963199083359, 0.97507364475674818, 0.97507364475674818, 0.97507364475674818, 0.97500558211597754, 0.97501692975982956, 0.9749601760770451, 0.9749601760770451, 0.97493746378700918, 0.97488065605737295, 0.9748920206873789, 0.97484655292373956, 0.97488065605737295, 0.97482380980367678, 0.97478968358787221, 0.97476692509314045, 0.97472138968091426, 0.97477830510856733, 0.97474416045605994, 0.9746986127720032, 0.9746986127720032, 0.97461884534924681, 0.97455041364925044, 0.97455041364925044, 0.97451617719886408, 0.97447050726733275, 0.97450476200038061, 0.97445908597889508, 0.97441338561886615, 0.97444766316929488, 0.97442481298875572, 0.97441338561886615, 0.97443623883906927, 0.97441338561886615, 0.97439052632254375, 0.97432191201932994, 0.97433335152658029, 0.97428758441097874, 0.97425324318388384, 0.97419597758033383, 0.97418451993063193, 0.97415013793301974, 0.97415013793301974, 0.97411574237376819, 0.97412720906616057, 0.97415013793301974, 0.97412720906616057, 0.97411574237376819, 0.97409280447372204, 0.97412720906616057, 0.97412720906616057, 0.97408133326712654, 0.9740583863433927, 0.97404691062731097, 0.97404691062731097, 0.97403543340913046, 0.97403543340913046, 0.97400099274720819, 0.97398950952585805, 0.97397802480503959, 0.97396653858527205, 0.9739550508670729, 0.97397802480503959, 0.97398950952585805, 0.97398950952585805, 0.97398950952585805, 0.97397802480503959, 0.9739550508670729, 0.9739550508670729, 0.97394356165097784, 0.97397802480503959, 0.97396653858527205, 0.97398950952585805, 0.97398950952585805, 0.97398950952585805, 0.97400099274720819, 0.97400099274720819, 0.97400099274720819, 0.97398950952585805, 0.97402395468936254, 0.97401247446854744, 0.97402395468936254, 0.97402395468936254, 0.97398950952585805, 0.97397802480503959, 0.97394356165097784, 0.9739090850205282, 0.97392057872717752, 0.9739550508670729, 0.97396653858527205, 0.97396653858527205, 0.97397802480503959, 0.97398950952585805, 0.97396653858527205, 0.9739550508670729, 0.97392057872717752, 0.97389758981808827, 0.97388609312035634, 0.97387459492787942, 0.97389758981808827, 0.973932070937507, 0.97392057872717752, 0.97392057872717752, 0.97392057872717752, 0.9739090850205282, 0.9739090850205282, 0.97392057872717752, 0.97389758981808827, 0.97389758981808827, 0.97389758981808827, 0.9739090850205282, 0.97392057872717752, 0.973932070937507, 0.97392057872717752, 0.9739550508670729, 0.97397802480503959, 0.97400099274720819, 0.97401247446854744, 0.97403543340913046, 0.97404691062731097, 0.97404691062731097, 0.97403543340913046, 0.97403543340913046, 0.97401247446854744, 0.97403543340913046, 0.97404691062731097, 0.9740583863433927, 0.97406986055683364, 0.97408133326712654, 0.97409280447372204, 0.974104274176116, 0.97409280447372204, 0.974104274176116, 0.97409280447372204, 0.97409280447372204, 0.97411574237376819, 0.97416160010644526, 0.97417306077248733, 0.97420743372108121, 0.97421888835233927, 0.97425324318388384, 0.97424179308426762, 0.97426469177189323, 0.97426469177189323, 0.97429902846099559, 0.97429902846099559, 0.97431047099729573, 0.97429902846099559, 0.97429902846099559, 0.97427613884776998, 0.97425324318388384, 0.97421888835233927, 0.97421888835233927, 0.97420743372108121, 0.97421888835233927, 0.97423034147358367, 0.97425324318388384, 0.97424179308426762, 0.97427613884776998, 0.97429902846099559, 0.97434478951852999, 0.97434478951852999, 0.97439052632254375, 0.97441338561886615, 0.97444766316929488, 0.97445908597889508, 0.97448192703408465, 0.97450476200038061, 0.97453900302383301, 0.97453900302383301, 0.97457323032329857, 0.97456182274925285, 0.97457323032329857, 0.97457323032329857, 0.97458463637085091, 0.97453900302383301, 0.97459604089139051, 0.97463024528551068, 0.97468722201872093, 0.97473277583547369, 0.97478968358787221, 0.97478968358787221, 0.97480106053051274, 0.97481243593596356, 0.97484655292373956, 0.97485792217501988, 0.9748920206873789, 0.97490338377588714, 0.97491474532235201, 0.97490338377588714, 0.97491474532235201, 0.97491474532235201, 0.97493746378700918, 0.97494882070412414, 0.97498288218813745, 0.97498288218813745, 0.9749942329252349, 0.97498288218813745, 0.9749942329252349, 0.9749942329252349, 0.97500558211597754, 0.9749942329252349, 0.97500558211597754, 0.97502827585624241, 0.97507364475674818, 0.9750963199083359, 0.97513032100021568, 0.97514165159253952, 0.97516430811648014, 0.97517563404701291, 0.97520960250634647, 0.97519828124248842, 0.97522092221356504, 0.97519828124248842, 0.97519828124248842, 0.97522092221356504, 0.97524355695588261, 0.97524355695588261, 0.97526618546511923, 0.97527749738095759, 0.97530011653238258, 0.97530011653238258, 0.97531142376687463, 0.97531142376687463, 0.97534533609893503, 0.97535663708400622, 0.97539053065470172, 0.97539053065470172, 0.97539053065470172, 0.97537923436242979, 0.97537923436242979, 0.97533403355069415, 0.97533403355069415, 0.97532272943982801, 0.97532272943982801, 0.97532272943982801, 0.97535663708400622, 0.97534533609893503, 0.97535663708400622, 0.97534533609893503, 0.97532272943982801, 0.97533403355069415, 0.97534533609893503, 0.97534533609893503, 0.97537923436242979, 0.97539053065470172, 0.97539053065470172, 0.97534533609893503, 0.97534533609893503, 0.97533403355069415, 0.97532272943982801, 0.9752888077368973, 0.97526618546511923, 0.97524355695588261, 0.97523224036358669, 0.97523224036358669, 0.97524355695588261, 0.97520960250634647, 0.9751529806314686, 0.9750963199083359, 0.9750963199083359, 0.97511898885504567, 0.97513032100021568, 0.9751529806314686, 0.97518695842252923, 0.97519828124248842, 0.97516430811648014, 0.97511898885504567, 0.97506230485547873, 0.97500558211597754, 0.97494882070412414, 0.97491474532235201, 0.97497152990522806, 0.97507364475674818, 0.97518695842252923, 0.9752888077368973, 0.97535663708400622, 0.97543570016475978, 0.97543570016475978, 0.9754018253816229, 0.97533403355069415, 0.97520960250634647, 0.9750963199083359, 0.97501692975982956, 0.97497152990522806, 0.97500558211597754, 0.9750963199083359, 0.97524355695588261, 0.97537923436242979, 0.97551468643596284, 0.97558232767775921, 0.97560486216691378, 0.97553723980789075, 0.97544698862478696, 0.97536793650534614, 0.97526618546511923, 0.97522092221356504, 0.97522092221356504, 0.97525487198990723, 0.97527749738095759, 0.97531142376687463, 0.97534533609893503, 0.97534533609893503, 0.97533403355069415, 0.97531142376687463, 0.9752888077368973, 0.97526618546511923, 0.97523224036358669, 0.97518695842252923, 0.97513032100021568, 0.97510765515757258, 0.9750849831078866, 0.97511898885504567, 0.97516430811648014, 0.97519828124248842, 0.97524355695588261, 0.97525487198990723, 0.97524355695588261, 0.97520960250634647, 0.97514165159253952, 0.9750963199083359, 0.97501692975982956, 0.9749601760770451, 0.97493746378700918, 0.97493746378700918, 0.9749601760770451, 0.97501692975982956, 0.97505096340461339, 0.9750849831078866, 0.9750963199083359, 0.97511898885504567, 0.97514165159253952, 0.97516430811648014, 0.97516430811648014, 0.97517563404701291, 0.97518695842252923, 0.97525487198990723, 0.97525487198990723, 0.97525487198990723, 0.97526618546511923, 0.97523224036358669, 0.97519828124248842, 0.97519828124248842, 0.97517563404701291, 0.97520960250634647, 0.97527749738095759, 0.97535663708400622, 0.97544698862478696, 0.97550340739266816, 0.97554851413542631, 0.97555978688995659, 0.97553723980789075, 0.97555978688995659, 0.97555978688995659, 0.97557105807090905, 0.97552596390789237, 0.97560486216691378, 0.97555978688995659, 0.97550340739266816, 0.97537923436242979, 0.97524355695588261, 0.97514165159253952, 0.9750963199083359, 0.97501692975982956, 0.97503962040468495, 0.97498288218813745, 0.97519828124248842, 0.97516430811648014, 0.97513032100021568, 0.97501692975982956, 0.97498288218813745, 0.97482380980367678, 0.97475554354212501, 0.97457323032329857, 0.97492610532623913, 0.97486928988640598, 0.97480106053051274, 0.97481243593596356, 0.97471000199291835, 0.97475554354212501, 0.97461884534924681, 0.97523224036358669, 0.97530011653238258, 0.97525487198990723, 0.97520960250634647, 0.97533403355069415, 0.97520960250634647, 0.97595333802659812, 0.97600940088407062, 0.97599819150163269, 0.97598698052411526, 0.97603181486147816, 0.97655669504107123, 0.97660120096413716, 0.9765121631490794, 0.97641187162997189, 0.97636725558783066, 0.97672345805535565, 0.97660120096413716, 0.97636725558783066, 0.97613259865650237, 0.97577366962262879, 0.97602060867087181, 0.97571743997925897, 0.97551468643596284, 0.97541311854262758, 0.97558232767775921, 0.97553723980789075, 0.97545827551672515, 0.97539053065470172, 0.97554851413542631, 0.97551468643596284, 0.97551468643596284, 0.97545827551672515, 0.97553723980789075, 0.97552596390789237, 0.97549212677855401, 0.97543570016475978, 0.97545827551672515, 0.97536793650534614, 0.97535663708400622, 0.97536793650534614, 0.97545827551672515, 0.97552596390789237, 0.97562739035304491, 0.97578491080146434, 0.97590845906574197, 0.97604301945533756, 0.97621089637498693, 0.97631144923566948, 0.97643416995883747, 0.97653443233893999, 0.97664568088217663, 0.97672345805535565, 0.97680115528326916, 0.97687877237138232, 0.97700057969710141, 0.97713323327545754, 0.97725462335658231, 0.97739782550763776, 0.977518776640798, 0.9776066140132077, 0.97772721504784177, 0.97785854741689027, 0.97796780510791503, 0.97815315347429455, 0.97837057867331467, 0.97853319671174177, 0.9787278251177276, 0.9788788135765506, 0.97895417952863895, 0.97902945968667399, 0.97913685353170599, 0.97912612206258187, 0.97925478331930982, 0.97927620214003852, 0.97943661739632049, 0.97957532037798067, 0.97962858737031988, 0.97972435517577205, 0.97987303817176241, 0.97990485288049489, 0.9800636823533404, 0.9801482245787394, 0.98028535715057719, 0.98046421801778316, 0.98044320308288002, 0.98055869413762375, 0.98049572662853168, 0.98054820415999933, 0.98059015300175312, 0.9805377123386364, 0.98056918227087841, 0.98052721867419168, 0.98061111634754028, 0.980485225598004, 0.98059015300175312, 0.98075765255851743, 0.98072628251376648, 0.98087253297786914, 0.98091425181606662, 0.98106003235830863, 0.98100800997573001, 0.98109122329249188, 0.98101841819846214, 0.98107043121227566, 0.98116393641468391, 0.98107043121227566, 0.98118469466870772, 0.98116393641468391, 0.98128837286816628, 0.98126765232162005, 0.98136083523527295, 0.98129873030787029, 0.98131943951689993, 0.98126765232162005, 0.98131943951689993, 0.98127801353920852, 0.98136083523527295, 0.98137117943197838, 0.98150548135662341, 0.98149516183864915, 0.98162916695701863, 0.98159827130823774, 0.98171147123134861, 0.98180391694672264, 0.9817833868912067, 0.98173202815275062, 0.98183469761369413, 0.98179365287960796, 0.98186546096526439, 0.98183469761369413, 0.98188596023783536, 0.98180391694672264, 0.98185520843977847, 0.9818141790918854, 0.98189620698360358, 0.98184495398903848, 0.98192693565085765, 0.98189620698360358, 0.98195764694918131, 0.98190645180146185, 0.98196788018577708, 0.98190645180146185, 0.98192693565085765, 0.98185520843977847, 0.98180391694672264, 0.98189620698360358, 0.98185520843977847, 0.98188596023783536, 0.98180391694672264, 0.98184495398903848, 0.9817833868912067, 0.98172175065039513, 0.98179365287960796, 0.98183469761369413, 0.98194741178072875, 0.98197811148984249, 0.98210073615970939, 0.98211094228048579, 0.98209052809776731, 0.98214154898917683, 0.98205989227163371, 0.98211094228048579, 0.98209052809776731, 0.98209052809776731, 0.98218233071741279, 0.98216194374361132, 0.98219252128489898, 0.98210073615970939, 0.98199856829770227, 0.98198834086069797, 0.98188596023783536, 0.98188596023783536, 0.9818141790918854, 0.98179365287960796, 0.98186546096526439, 0.98190645180146185, 0.98190645180146185, 0.98196788018577708, 0.98190645180146185, 0.98195764694918131, 0.98192693565085765, 0.98191669469077181, 0.98189620698360358, 0.98188596023783536, 0.98187571156483888, 0.98185520843977847, 0.98184495398903848, 0.98183469761369413, 0.98182443931442753, 0.9818141790918854, 0.98180391694672264, 0.98179365287960796, 0.9817833868912067, 0.98177311898215158, 0.98176284915312551, 0.98175257740478095, 0.98174230373776861, 0.98173202815275062, 0.98173202815275062, 0.98172175065039513, 0.98171147123134861, 0.98171147123134861, 0.98170118989626842, 0.98169090664581371, 0.98169090664581371, 0.9816806214806395, 0.9816806214806395, 0.9816806214806395, 0.98167033440141227, 0.98167033440141227, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98164975450340375, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98166004540879115, 0.98167033440141227, 0.98167033440141227, 0.98167033440141227, 0.9816806214806395, 0.9816806214806395, 0.9816806214806395, 0.98169090664581371, 0.98169090664581371, 0.98170118989626842, 0.98170118989626842, 0.98171147123134861, 0.98171147123134861, 0.98172175065039513, 0.98173202815275062, 0.98173202815275062, 0.98174230373776861, 0.98175257740478095, 0.98175257740478095, 0.98176284915312551, 0.98177311898215158, 0.98177311898215158, 0.9817833868912067, 0.98179365287960796, 0.98180391694672264, 0.9818141790918854, 0.98182443931442753, 0.98182443931442753, 0.98183469761369413, 0.98184495398903848, 0.98185520843977847, 0.98186546096526439, 0.98187571156483888, 0.98188596023783536, 0.98189620698360358, 0.98190645180146185, 0.98191669469077181, 0.98193717468106378, 0.98194741178072875, 0.98195764694918131, 0.98196788018577708, 0.98197811148984249, 0.98199856829770227, 0.98200879380020456, 0.98201901736750596, 0.98202923899897376, 0.98203945869391684, 0.98205989227163371, 0.982070106153073, 0.98208031809533591, 0.98209052809776731, 0.98210073615970939, 0.98212114645943882, 0.98213134869589458, 0.98214154898917683, 0.98215174733864175, 0.98216194374361132, 0.98218233071741279, 0.98219252128489898, 0.98220270990522784, 0.98221289657773869, 0.98222308130173996, 0.98224344490158766, 0.98225362377610004, 0.98226380069942931, 0.98227397567093133, 0.982294319755739, 0.98230448886771449, 0.98232482122742448, 0.98233498447384437, 0.98234514576372067, 0.98235530509640601, 0.98237561788750827, 0.98238577134458971, 0.9823959228417718, 0.98240607237840782, 0.98241621995381889, 0.98242636556733876, 0.98243650921827741, 0.98244665090597694, 0.98245679062976832, 0.98246692838897065, 0.98248719801090723, 0.98249732987230065, 0.98250745976640652, 0.98251758769256459, 0.98252771365009173, 0.98254795965656117, 0.98255807970414311, 0.9825681977803925, 0.98257831388465222, 0.98258842801621438, 0.98260865035860301, 0.98261875856808156, 0.98262886480215506, 0.98263896906018089, 0.98264907134145696, 0.98266926997108639, 0.98267936631808139, 0.98268946068562812, 0.98269955307305112, 0.98271973190479334, 0.98272981834775808, 0.98274998528447599, 0.98276006577687713, 0.98277014428439269, 0.9827802208063442, 0.9828003678908549, 0.98281043845204696, 0.98282050702496326, 0.98283057360890269, 0.98284063820320777, 0.98286076142015033, 0.98287082004142556, 0.98288087667033031, 0.98289093130618543, 0.98290098394830128, 0.98292108324859517, 0.98293112990539311, 0.98294117456573749, 0.98295121722891732, 0.9829612578942627, 0.98298133322872194, 0.98299136789644981, 0.98300140056361252, 0.98301143122951429, 0.98302145989345924, 0.98304151121279149, 0.98305153386680044, 0.98306155451611632, 0.98307157316006144, 0.9830815897979549, 0.98310161705277932, 0.9831116276683507, 0.98312163627512328, 0.98313164287238852, 0.98314164745947485, 0.98316165060033867, 0.98317164915273714, 0.98318164569218736, 0.98319164021801475, 0.98320163272952787, 0.98322161170684175, 0.98323159817126005, 0.98324158261860539, 0.98325156504817834, 0.98326154545929534, 0.98327152385125594, 0.98328150022338145, 0.98329147457496169, 0.98330144690534338, 0.98331141721379878, 0.98333135176218212, 0.98334131600074259, 0.98335127821461132, 0.9833612384031023, 0.9833711965655213, 0.98338115270118276, 0.98339110680937414, 0.98340105888941887, 0.98341100894061995, 0.98342095696228171, 0.9834408469141982, 0.98345078884306447, 0.9834607287396091, 0.98347066660313653, 0.98348060243295998, 0.9835004679886884, 0.98351039771319104, 0.9835203254012127, 0.9835302510520294, 0.98354017466495469, 0.98355009623930123, 0.9835600157743587, 0.98356993326942987, 0.9835798487238262, 0.98358976213683913, 0.98359967350776578, 0.9836095828359297, 0.98361949012060967, 0.98362939536111682, 0.98363929855675269, 0.98365909881059865, 0.98366899586741441, 0.9836788908765608, 0.98368878383732283, 0.98369867474901329, 0.98370856361091497, 0.98371845042236239, 0.98372833518261449, 0.9837382178909907, 0.98374809854678569, 0.9837579771492917, 0.98376785369781827, 0.98377772819164044, 0.98378760063007387, 0.98379747101242665, 0.98381720560600172, 0.98382706981584089, 0.98383693196676503, 0.98384679205807424, 0.98385665008906686, 0.98386650605902726, 0.98387635996725975, 0.98388621181305713, 0.98389606159571441, 0.98390590931453858, 0.9839157549688039, 0.98392559855781536, 0.98393544008086031, 0.98394527953722399, 0.98395511692622295, 0.98396495224712865, 0.98397478549925843, 0.98398461668187642, 0.98399444579427919, 0.98400427283578584, 0.98400427283578584, 0.98401409780565663, 0.98402392070319822, 0.9840337415277044, 0.98404356027844908, 0.98404356027844908, 0.98405337695474016, 0.98406319155587196, 0.98407300408111786, 0.98408281452978585, 0.98408281452978585, 0.98409262290114818, 0.98410242919450064, 0.98411223340913156, 0.98411223340913156, 0.98412203554432898, 0.98412203554432898, 0.98413183559940209, 0.98414163357362738, 0.98414163357362738, 0.98415142946626843, 0.98415142946626843, 0.98416122327664757, 0.98417101500403481, 0.98418080464771329, 0.98419059220698257, 0.98420037768114588, 0.98421016106945791, 0.98421994237121868, 0.98422972158571753, 0.98422972158571753, 0.98423949871222638, 0.98424927375004911, 0.98425904669848097, 0.9842688175567833, 0.98427858632424148, 0.98428835300016049, 0.98429811758380514, 0.98430788007446945, 0.98431764047144055, 0.98432739877401265, 0.98433715498144037, 0.98434690909302891, 0.98435666110805731, 0.9843664110258088, 0.98437615884556695, 0.98438590456660136, 0.98439564818822145, 0.98440538970968339, 0.98441512913028273, 0.98441512913028273, 0.98442486644931104, 0.9844346016660267, 0.98444433477971727, 0.98445406578967287, 0.98445406578967287, 0.98446379469517009, 0.98447352149549072, 0.98448324618991556, 0.98449296877772396, 0.98449296877772396, 0.98450268925819262, 0.98451240763060166, 0.98452212389422478, 0.98453183804836319, 0.98453183804836319, 0.98454155009227828, 0.98455126002524851, 0.98456096784655178, 0.98456096784655178, 0.98457067355547001, 0.98457067355547001, 0.98458037715128477, 0.98459007863326831, 0.98459007863326831, 0.98459977800070486, 0.98459977800070486, 0.98460947525286246, 0.98461917038901903, 0.98461917038901903, 0.98462886340845623, 0.98462886340845623, 0.98463855431045388, 0.98464824309428189, 0.98464824309428189, 0.98465792975921584, 0.98465792975921584, 0.98466761430453731, 0.98467729672950388, 0.98467729672950388, 0.98468697703341401, 0.98468697703341401, 0.98469665521553629, 0.98470633127515272, 0.98470633127515272, 0.98471600521151148, 0.98471600521151148, 0.98472567702390779, 0.98472567702390779, 0.98473534671160778, 0.98473534671160778, 0.98474501427388983, 0.98474501427388983, 0.98475467971003872, 0.98475467971003872, 0.98476434301929661, 0.98476434301929661, 0.9847740042009604, 0.9847740042009604, 0.98478366325430922, 0.98478366325430922, 0.98479332017860077, 0.98479332017860077, 0.9848029749731072, 0.9848029749731072, 0.9848126276371002, 0.9848126276371002, 0.98482227816986967, 0.98482227816986967, 0.98483192657066376, 0.98483192657066376, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.98484157283877427, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.9848512169734559, 0.98486085897396802, 0.98486085897396802, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98487049883962519, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488013656966733, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488977216336815, 0.98488013656966733, 0.98488013656966733, 0.98487049883962519, 0.98487049883962519, 0.98486085897396802, 0.9848512169734559, 0.9848512169734559, 0.98484157283877427, 0.98483192657066376, 0.98482227816986967, 0.9848126276371002, 0.9848029749731072, 0.98479332017860077, 0.98478366325430922, 0.9847740042009604, 0.98475467971003872, 0.98474501427388983, 0.98472567702390779, 0.98471600521151148, 0.98469665521553629, 0.98467729672950388, 0.98465792975921584, 0.98463855431045388, 0.98461917038901903])


# Transmission of isotropic light across a dielectric surface in two and three dimensions (alpha=90)
P4_tav90n = np.array([0.90876601780087585, 0.90866305137555348, 0.90857481373549465, 0.90845719119960178, 0.90829551168724665, 0.90813389160574753, 0.90797233076814921, 0.90779614993112212, 0.90757602235839152, 0.90738533330097271, 0.90720938503060311, 0.90706281439117442, 0.90685769604910305, 0.90663803031057333, 0.9064038381877817, 0.90618439323403577, 0.90596505444566233, 0.9057604336501015, 0.90555590461861946, 0.90533686781290013, 0.90511793554116049, 0.90492827847732604, 0.90472411956743104, 0.90452005072425934, 0.90430150511251717, 0.90406850289846952, 0.9038938275781131, 0.90379196376996496, 0.90366102856050001, 0.90353012988629766, 0.90341380611434108, 0.90331204639571849, 0.90319577647380034, 0.90309406378634649, 0.90299237298716317, 0.90290522683771779, 0.90281809671814428, 0.90276001886562118, 0.90270194812008686, 0.90262936967181129, 0.90255680230388946, 0.90246973606952252, 0.9023971930311312, 0.90232466103024156, 0.9022666433676001, 0.90219413120074721, 0.90216512941485827, 0.90212163003429757, 0.90207813460914477, 0.90202014685688181, 0.90197666064997839, 0.90194767203775916, 0.9019041924059148, 0.90187520817446187, 0.90186071671534918, 0.9018462256938522, 0.90186071671534918, 0.90187520817446187, 0.90187520817446187, 0.9019041924059148, 0.90194767203775916, 0.90200565101596464, 0.90207813460914477, 0.90215062918167699, 0.90222313474670113, 0.9022956513174073, 0.90236817890701837, 0.90244071752881228, 0.90248424600287702, 0.90252777845620624, 0.90255680230388946, 0.90260034139575218, 0.90264388447460964, 0.90265839972072537, 0.90268743154335618, 0.90271646514057324, 0.9027309826049148, 0.90274550051323121, 0.90276001886562118, 0.90277453766220395, 0.90280357658835542, 0.90283261729255548, 0.9028761816845966, 0.90293427377194013, 0.9030068989055211, 0.90310859282928657, 0.90321030864672314, 0.90335565501131299, 0.90351558784085317, 0.90369012211344124, 0.90392293559743253, 0.9041558650757644, 0.90444719075997404, 0.90475327960407803, 0.90510334376304291, 0.90546827732574831, 0.9058773485605438, 0.90630141730358826, 0.90675517201950684, 0.90722404473780727, 0.90770808579449613, 0.90822204065765044, 0.90875130682551997, 0.90928121528179595, 0.90981177283517078, 0.91035775183644407, 0.91088964723754473, 0.91140741080096999, 0.91191099481432947, 0.91241519019504236, 0.91289029146931011, 0.91333620117052638, 0.91376771383697952, 0.91416988328279047, 0.91454262354627602, 0.91488585388087518, 0.91519949899614905, 0.91548348928901557, 0.91573776106314453, 0.91596225673433973, 0.91615692502012991, 0.91633670607445628, 0.91648658786874249, 0.91662153160592441, 0.9167415215857575, 0.91684654378198105, 0.91692157737234115, 0.91699662577268204, 0.91707168900965486, 0.91713175029956107, 0.91719182111574926, 0.91725190147199054, 0.91731199138210073, 0.91737209085991678, 0.917432199919342, 0.91749231857430136, 0.9175524468387688, 0.91761258472675367, 0.91768777064122287, 0.91774793023355627, 0.91780809949523434, 0.91788332469143485, 0.91794351576103972, 0.91801876826225204, 0.91807898121205311, 0.9181392039097076, 0.91819943636963397, 0.9182747406947418, 0.91833499517266559, 0.91839525945999068, 0.91847060363582111, 0.91853089004767363, 0.91860626192556372, 0.91868164923372553, 0.91875705200104252, 0.9188324702564965, 0.9189229926483462, 0.91901353743547154, 0.91911920139321057, 0.91920979487758814, 0.91931551578857928, 0.91942126748316233, 0.91952705004337043, 0.91963286355167195, 0.91973870809095715, 0.91984458374452593, 0.91995049059611156, 0.92005642872987348, 0.92016239823041779, 0.92026839918274483, 0.92035928223970187, 0.92046534182955242, 0.92055627527445494, 0.92064723206161669, 0.92073821224585739, 0.92081404697854774, 0.92088989802944177, 0.92096576543065789, 0.92104164921441922, 0.92110236805858947, 0.92116309742491531, 0.92122383733004898, 0.92126939918505135, 0.92131496698459936, 0.92136054073578477, 0.92140612044571624, 0.92143651023292794, 0.92148209988990859, 0.92151249631509757, 0.92155809593897509, 0.9215884990153802, 0.92161890475599861, 0.92164931316295773, 0.92167972423840416, 0.92171013798445889, 0.92174055440326508, 0.92177097349697934, 0.92180139526773064, 0.92183181971767314, 0.92184703294801662, 0.92187746142080029, 0.92190789257816086, 0.92193832642226192, 0.92195354435251897, 0.92198398223080114, 0.92199920217936204, 0.92201442280124013, 0.9220296440966933, 0.9220296440966933, 0.92204486606600988, 0.92204486606600988, 0.92204486606600988, 0.92204486606600988, 0.9220296440966933, 0.92201442280124013, 0.92199920217936204, 0.92198398223080114, 0.92196876295527208, 0.92195354435251897, 0.92193832642226192, 0.92193832642226192, 0.92192310916422837, 0.92192310916422837, 0.92192310916422837, 0.92192310916422837, 0.92192310916422837, 0.92193832642226192, 0.92195354435251897, 0.92198398223080114, 0.92199920217936204, 0.92201442280124013, 0.9220296440966933, 0.9220296440966933, 0.92201442280124013, 0.92199920217936204, 0.92196876295527208, 0.92192310916422837, 0.92184703294801662, 0.92177097349697934, 0.92166451836699159, 0.92154289539917145, 0.92139092654655519, 0.92122383733004898, 0.92105682793991517, 0.92085955564884703, 0.92066239379937198, 0.92045018852095017, 0.92025325426069615, 0.92005642872987348, 0.91987483965783312, 0.91970846362273773, 0.91954216436213398, 0.91937594155367008, 0.9192248959832614, 0.91905881824308788, 0.91886264190186939, 0.9186514924569873, 0.91841032706624059, 0.91810909134150032, 0.91777801365484479, 0.9173871172259549, 0.91696660463364021, 0.91650157926935916, 0.91600717148221544, 0.91549844186131835, 0.91497544127491892, 0.91443822109226391, 0.91391661847786043, 0.91341056705430113, 0.91292000360533998, 0.91244486792755075, 0.91199992585736056, 0.9115554606692422, 0.91114105278197399, 0.9107270528176219, 0.91032822161168658, 0.90992976336163267, 0.90956115044258246, 0.90922230463626907, 0.90894258821314344, 0.90876601780087585, 0.90870717687236024, 0.90883958011644839, 0.90916340199466494, 0.90970855770389358, 0.91047589322408884, 0.91146662446038307, 0.91260813374284444, 0.91387194129191485, 0.91518455783959562, 0.91645660682618668, 0.91764265728395267, 0.91868164923372553, 0.91957239489539944, 0.92029869095792372, 0.92084438543892289, 0.92122383733004898, 0.92146690267374076, 0.92160370155253346, 0.92163410862605533, 0.92157329714427572, 0.92146690267374076, 0.92129977705713928, 0.92110236805858947, 0.92087472651226865, 0.92061691053559336, 0.92035928223970187, 0.92008670252563118, 0.91979920464915044, 0.91951193635620143, 0.9192248959832614, 0.9189229926483462, 0.91862133815185287, 0.9183199306341252, 0.91801876826225204, 0.91770280963357775, 0.91740214419105914, 0.9171017184646808, 0.91680153072552384, 0.91650157926935916, 0.91620186241625434, 0.91591734719830131, 0.91563304081478569, 0.91536388930992507, 0.91509492283663962, 0.91482614025078202, 0.91457245785989294, 0.91433384603449464, 0.91409537700335275, 0.91387194129191485, 0.91364862978639305, 0.91345519313976475, 0.91326184892396134, 0.91306859674478613, 0.91290514726715122, 0.91274176317122402, 0.91259328871517165, 0.9124597075961558, 0.91232616982282444, 0.91222233699763677, 0.9121185302598771, 0.91202957377546157, 0.91194063637813771, 0.91188135536593384, 0.91182208281002386, 0.91177763393610589, 0.91173318980834139, 0.91170356302437339, 0.91168875042224962, 0.91167393834647981, 0.91167393834647981, 0.91167393834647981, 0.91167393834647981, 0.91168875042224962, 0.91170356302437339, 0.9117183761530111, 0.91173318980834139, 0.91176281869972275, 0.91179244969983531, 0.91182208281002386, 0.91185171803160492, 0.91186653643459703, 0.91189617482578833, 0.91192581533172323, 0.91195545795374688, 0.91198510269318644, 0.91201474955139894, 0.91204439852972052, 0.91207404962950556, 0.91210370285210229, 0.91213335819885655, 0.912163015671132, 0.91219267527026826, 0.91222233699763677, 0.91225200085458558, 0.91228166684248269, 0.91231133496268524, 0.91234100521656414, 0.91237067760547608, 0.91240035213080106, 0.91241519019504236, 0.91244486792755075, 0.91247454779989323, 0.91248938853893313, 0.91251907162361157, 0.91254875685156878, 0.91256360026970951, 0.91259328871517165, 0.91262297930737546, 0.91265267204768574, 0.91266751922382228, 0.91269721518891977, 0.91272691330559863, 0.91275661357526583, 0.91278631599930182, 0.9128011680196515, 0.91283087367786864, 0.91286058149395766, 0.91289029146931011, 0.91292000360533998, 0.9129348604840446, 0.91296457586371316, 0.91299429340757077, 0.9130091529915082, 0.91303887378428672, 0.91306859674478613, 0.91309832187441253, 0.91312804917458301, 0.91314291363906896, 0.91317264419772048, 0.91318751029225154, 0.91321724411257743, 0.91323211183874331, 0.91326184892396134, 0.91329158818755807, 0.91330645863669213, 0.91333620117052638, 0.91336594588631814, 0.91338081906288981, 0.91341056705430113, 0.9134254418694987, 0.91345519313976475, 0.91347006959519816, 0.91349982414756326, 0.91352958088979397, 0.91354446008256529, 0.91357422011232114, 0.91360398233556239, 0.91361886427019579, 0.91364862978639305, 0.9136783974997158, 0.91369328218074708, 0.91372305319248348, 0.91373793952354632, 0.91375282640498146, 0.91376771383697952, 0.91379749035336744, 0.91381237943813298, 0.91384215926171231, 0.9138570500008929, 0.91388683313496089, 0.91390172553021265, 0.91391661847786043, 0.91394640603106547, 0.91396130063698799, 0.9139910915084154, 0.9140208845938389, 0.91403578196725843, 0.91405067989473798, 0.91408047741259768, 0.91409537700335275, 0.91412517784943526, 0.91414007910513417, 0.91415498091618919, 0.91418478620511112, 0.9141996896833533, 0.91421459371769476, 0.91422949830832201, 0.91424440345542535, 0.91427421541979714, 0.91430402961232216, 0.91431893754461024, 0.91434875508216273, 0.91437857485162288, 0.9143934855737853, 0.9144083968544896, 0.9144083968544896, 0.91442330869391819, 0.91443822109226391, 0.91445313404972184, 0.91446804756647093, 0.91449787627861601, 0.91452770723021293, 0.91454262354627602, 0.91457245785989294, 0.91460229441676177, 0.9146172135368873, 0.91464705346148123, 0.91466197426632745, 0.91469181756208262, 0.91470674005336849, 0.91472166310718106, 0.91475151090316564, 0.91476643564571236, 0.91479628682089398, 0.91481121325389902, 0.91484106781172847, 0.91487092462657715, 0.91488585388087518, 0.91491571408415473, 0.9149306450335305, 0.91496050862872202, 0.91497544127491892, 0.91499037448711384, 0.91502024261026493, 0.91505011299972305, 0.91506504904480412, 0.91509492283663962, 0.91510986058378563, 0.91512479889867837, 0.91515467723247346, 0.91516961725177504, 0.91519949899614905, 0.91521444072160796, 0.9152293830161875, 0.91525926931346735, 0.91527421331656833, 0.91530410303265275, 0.91531904874603753, 0.91534894188447147, 0.91536388930992507, 0.9153937858742508, 0.91540873501353182, 0.91542368472448687, 0.91545358586221781, 0.91546853728938204, 0.91548348928901557, 0.9155133950064771, 0.91554330301619502, 0.91555825788114575, 0.91558816933222531, 0.91560312591875559, 0.91563304081478569, 0.91564799912468864, 0.91567791746926686, 0.91570783811488887, 0.91572279930108957, 0.91575272340126823, 0.91576768631565342, 0.91579761387401626, 0.91581257851839815, 0.91582754373984843, 0.91585747591476219, 0.91588741040037802, 0.91591734719830131, 0.91594728631016886, 0.91596225673433973, 0.91597722773760293, 0.91599219932016196, 0.91602214422397521, 0.91605209144742383, 0.91609701663546006, 0.9161269696651213, 0.91615692502012991, 0.91617190357015288, 0.91620186241625434, 0.91621684271275039, 0.91621684271275039, 0.91621684271275039, 0.91623182359180666, 0.91627676972646466, 0.91630673673284924, 0.91633670607445628, 0.91635169162148733, 0.91638166446901947, 0.916396651769944, 0.91641163965591299, 0.9164266281271416, 0.91645660682618668, 0.91645660682618668, 0.91645660682618668, 0.91650157926935916, 0.91653156383030576, 0.91656155073893908, 0.91657654507415021, 0.91659153999691723, 0.91659153999691723, 0.91660653550743554, 0.91662153160592441, 0.91660653550743554, 0.91660653550743554, 0.91662153160592441, 0.91665152556762997, 0.91668152188371821, 0.91671152055586225, 0.91672652077598915, 0.9167415215857575, 0.91675652298538635, 0.91678652755505696, 0.91680153072552384, 0.91683153883877733, 0.91686154931653396, 0.91687655544263325, 0.9169065694703189, 0.9169065694703189, 0.91692157737234115, 0.9169065694703189, 0.9169065694703189, 0.91689156216049039, 0.91689156216049039, 0.9169065694703189, 0.91692157737234115, 0.91693658586675719, 0.91696660463364021, 0.91699662577268204, 0.91702664928558086, 0.91705667517404621, 0.91708670343979426, 0.91711673408453009, 0.91713175029956107, 0.91714676710998211, 0.9171768025178626, 0.9172068403098973, 0.91722186010050422, 0.91723688048779828, 0.91725190147199054, 0.91725190147199054, 0.91725190147199054, 0.91726692305330215, 0.91728194523194817, 0.91729696800814353, 0.9173270153540386, 0.9173420399241764, 0.91735706509272863, 0.91737209085991678, 0.91737209085991678, 0.9173871172259549, 0.91740214419105914, 0.917432199919342, 0.91746225804650938, 0.91749231857430136, 0.91752238150447374, 0.9175524468387688, 0.91756748040801261, 0.91758251457894513, 0.91759754935178639, 0.91761258472675367, 0.91762762070406845, 0.91765769446662404, 0.91765769446662404, 0.91767273225230994, 0.91767273225230994, 0.91768777064122287, 0.91768777064122287, 0.91768777064122287, 0.91768777064122287, 0.91768777064122287, 0.91768777064122287, 0.91771784922959787, 0.91771784922959787, 0.91774793023355627, 0.91776297164191845, 0.91779305627254026, 0.91782314332314185, 0.91783818775649895, 0.917853232795524, 0.91786827844042718, 0.91788332469143485, 0.91789837154878517, 0.91789837154878517, 0.9179134190126863, 0.91792846708336129, 0.9179585650459422, 0.91797361493828722, 0.91800371654621804, 0.91800371654621804, 0.91800371654621804, 0.91801876826225204, 0.91803382058662297, 0.91804887351957032, 0.9180639270612998, 0.91807898121205311, 0.9180940359720432, 0.91812414732064374, 0.91812414732064374, 0.91812414732064374, 0.91812414732064374, 0.91812414732064374, 0.9181392039097076, 0.91815426110891418, 0.91816931891848452, 0.91819943636963397, 0.91821449601165694, 0.91822955626495739, 0.91825967860627289, 0.9182747406947418, 0.91830486670844014, 0.9183199306341252, 0.91833499517266559, 0.91836512608923804, 0.91838019246772817, 0.91839525945999068, 0.91841032706624059, 0.91842539528672451, 0.91842539528672451, 0.91844046412166036, 0.91845553357128451, 0.91848567431550099, 0.91850074561054385, 0.91853089004767363, 0.91854596319020687, 0.91857611132438777, 0.91859118631648751, 0.91859118631648751, 0.91860626192556372, 0.91862133815185287, 0.91863641499557824, 0.91868164923372553, 0.91871180848393497, 0.91872688903716981, 0.9187419702094598, 0.91875705200104252, 0.91877213441215844, 0.91878721744302261, 0.91878721744302261, 0.91881738536496382, 0.91884755576872301, 0.91886264190186939, 0.91889281603186557, 0.91889281603186557, 0.91887772865617556, 0.91887772865617556, 0.91887772865617556, 0.91887772865617556, 0.91889281603186557, 0.91889281603186557, 0.91890790402918021, 0.91893808188960657, 0.91896826223934025, 0.91899844508024109, 0.91901353743547154, 0.9190286304141928, 0.91905881824308788, 0.91908900856879061, 0.91911920139321057, 0.91911920139321057, 0.91913429874301855, 0.91914939671821361, 0.91914939671821361, 0.91917959454571097, 0.91919469439848212, 0.91920979487758814, 0.9192248959832614, 0.91925510007526878, 0.91927020306207829, 0.91928530667640529, 0.91930041091849901, 0.91930041091849901, 0.91931551578857928, 0.91933062128690812, 0.91936083416921188, 0.91939104956732187, 0.91940615821040761, 0.91942126748316233, 0.91943637738582573, 0.91948171087567532, 0.91952705004337043, 0.91955727931272768, 0.91958751111039061, 0.9196177454382819, 0.91963286355167195, 0.91964798229834832, 0.91966310167854837, 0.9196933423405016, 0.91972358553948064, 0.91975383127741606, 0.91978407955627195, 0.91978407955627195, 0.91979920464915044, 0.91979920464915044, 0.91979920464915044, 0.91981433037798888, 0.91981433037798888, 0.91982945674302807, 0.91982945674302807, 0.9198597113827085, 0.91987483965783312, 0.91990509811988108, 0.91990509811988108, 0.91992022830728915, 0.91992022830728915, 0.91995049059611156, 0.91999588881804661, 0.92002615749467365, 0.92004129279233804, 0.92005642872987348, 0.92004129279233804, 0.92004129279233804, 0.92005642872987348, 0.92005642872987348, 0.92007156530756207, 0.9201018403843273, 0.92013211802462214, 0.92016239823041779, 0.92017753929599722, 0.92016239823041779, 0.92013211802462214, 0.92008670252563118, 0.92007156530756207, 0.92007156530756207, 0.9201018403843273, 0.92014725780670603, 0.92020782335376783, 0.92026839918274483, 0.92031383781156606, 0.92034413345220634, 0.92034413345220634, 0.92032898530958041, 0.92032898530958041, 0.92034413345220634, 0.92035928223970187, 0.92037443167231781, 0.92040473247390175, 0.92043503585897479, 0.92045018852095017, 0.92048049578503122, 0.92048049578503122, 0.92049565038764181, 0.9205108056376391, 0.92052596153527388, 0.92055627527445494, 0.92055627527445494, 0.92057143311651646, 0.92057143311651646, 0.92060175074683626, 0.92063207097377631, 0.92064723206161669, 0.92067755618730396, 0.9206927192256652, 0.92070788291470695, 0.92073821224585739, 0.92078371112908064, 0.92081404697854774, 0.92082921588224331, 0.92084438543892289, 0.92085955564884703, 0.92088989802944177, 0.92088989802944177, 0.92088989802944177, 0.92090507020062784, 0.92093541650607158, 0.92095059064084128, 0.92096576543065789, 0.92098094087576998, 0.92098094087576998, 0.92101129373293911, 0.92102647114550362, 0.92107200732228123, 0.92111754941307022, 0.92114791409597108, 0.92116309742491531, 0.92120865136483698, 0.92122383733004898, 0.92123902395497903, 0.92123902395497903, 0.92123902395497903, 0.92126939918505135, 0.92129977705713928, 0.92131496698459936, 0.92133015757334857, 0.92133015757334857, 0.92134534882366803, 0.92134534882366803, 0.92136054073578477, 0.92139092654655519, 0.92142131500775648, 0.92143651023292794, 0.9214517061215044, 0.92148209988990859, 0.92148209988990859, 0.92149729777027289, 0.92149729777027289, 0.92151249631509757, 0.92154289539917145, 0.92157329714427572, 0.92160370155253346, 0.92161890475599861, 0.92163410862605533, 0.92163410862605533, 0.92161890475599861, 0.92161890475599861, 0.92164931316295773, 0.92167972423840416, 0.92171013798445889, 0.92174055440326508, 0.92177097349697934, 0.92178618404758417, 0.92180139526773064, 0.92180139526773064, 0.92180139526773064, 0.92181660715766811, 0.92184703294801662, 0.92187746142080029, 0.92192310916422837, 0.92195354435251897, 0.92196876295527208, 0.92198398223080114, 0.92199920217936204, 0.92201442280124013, 0.92199920217936204, 0.92199920217936204, 0.92199920217936204, 0.92201442280124013, 0.9220296440966933, 0.92204486606600988, 0.92207531202729376, 0.92212098602993509, 0.92215143874201821, 0.92218189415826202, 0.92221235228083409, 0.92221235228083409, 0.92224281311193801, 0.92225804454386906, 0.92228850944188212, 0.92231897705392807, 0.92233421187840336, 0.92234944738219116, 0.92234944738219116, 0.92234944738219116, 0.92233421187840336, 0.92231897705392807, 0.92230374290851114, 0.92230374290851114, 0.92231897705392807, 0.92234944738219116, 0.92237992042891415, 0.92241039619627418, 0.92242563510089137, 0.92244087468649139, 0.92245611495337898, 0.92248659753205042, 0.92250183984440293, 0.92251708283913847, 0.92251708283913847, 0.92251708283913847, 0.92250183984440293, 0.92250183984440293, 0.92251708283913847, 0.92254757087686912, 0.92257806164746137, 0.92257806164746137, 0.92256281592041589, 0.92254757087686912, 0.92257806164746137, 0.92262380293235902, 0.92266955037878773, 0.92270005210319883, 0.92271530399429569, 0.92273055657168079, 0.92271530399429569, 0.92268480089812621, 0.92266955037878773, 0.92268480089812621, 0.92270005210319883, 0.92276106378645872, 0.92283734385330785, 0.92291364113395391, 0.92298995566379627, 0.92302048631347045, 0.9230357526760905, 0.92306628747838282, 0.92308155591859919, 0.92312736539901685, 0.92315790852196566, 0.9231884544230512, 0.92314263661337004, 0.92312736539901685, 0.92305101973097159, 0.92300522064279245, 0.9229594277796811, 0.92294416487399888, 0.9229594277796811, 0.9230357526760905, 0.92315790852196566, 0.92324955456883318, 0.92331066585482091, 0.92335650664117375, 0.92331066585482091, 0.9232648313452172, 0.92323427848871664, 0.9231884544230512, 0.9231884544230512, 0.9231884544230512, 0.92314263661337004, 0.92315790852196566, 0.9232037284161082, 0.92315790852196566, 0.92311209487863999, 0.92306628747838282, 0.92305101973097159, 0.92289838029901994, 0.9229594277796811, 0.9230357526760905, 0.92317318112509505, 0.92317318112509505, 0.92337178829948718, 0.92352464335220152, 0.92363168361036208, 0.92379995941973114, 0.92367756855394267, 0.92383056419811393, 0.92387647667177131, 0.92392239551984567, 0.92389178224579882, 0.92402956433331251, 0.92379995941973114, 0.92378465809086219, 0.9239530116305551, 0.92401425237144608, 0.92407550448760922, 0.92413676799823841, 0.9241674040324791, 0.92430530156242752, 0.92432062708957086, 0.92425932927988641, 0.92406019039109166, 0.92404487700642879, 0.92404487700642879, 0.92404487700642879, 0.92415208565853102, 0.92421336343930061, 0.92419804292255447, 0.92419804292255447, 0.92418272312038952, 0.92419804292255447, 0.92424400661764938, 0.92428997675196856, 0.92432062708957086, 0.9244125953197404, 0.92444325714370856, 0.92448925527611658, 0.92456593324102321, 0.92464262925283158, 0.92475003406149403, 0.92484212361973361, 0.92502638136802062, 0.92514927832975624, 0.92525685168639216, 0.92536446110442405, 0.92545672653322764, 0.92557978856257961, 0.92567211626794854, 0.92581065810969787, 0.92590305296252795, 0.92610333446992821, 0.92624206548069254, 0.92635000974584614, 0.92648884990329572, 0.92662775179586121, 0.92670494628043876, 0.92679760497382535, 0.92690574177586038, 0.92701391637506092, 0.92713759092269321, 0.92729225401939186, 0.9274160406447618, 0.92753987737476118, 0.92763278791251913, 0.92769474402340313, 0.9277567127628561, 0.92780319761876195, 0.92780319761876195, 0.92784968960087721, 0.92792719210015051, 0.92803572898626818, 0.92811327924316711, 0.9281908494764739, 0.92826843973194917, 0.92831500351500695, 0.92839262590166627, 0.92847026843033154, 0.92843920899885635, 0.92845473831100789, 0.92848579935719933, 0.92848579935719933, 0.92851686363502228, 0.92857900189751341, 0.92853239698673073, 0.92856346611760265, 0.92859453848756723, 0.92856346611760265, 0.92864115312238849, 0.92870331733361544, 0.92867223360320161, 0.92873440431662424, 0.92865669295678677, 0.9286877750620246, 0.92867223360320161, 0.9286256140996374, 0.92864115312238849, 0.92859453848756723, 0.92867223360320161, 0.92871886041835794, 0.92881213602404966, 0.92879658805250354, 0.92884323441490579, 0.92887433607196357, 0.92881213602404966, 0.92881213602404966, 0.9286877750620246, 0.92870331733361544, 0.92864115312238849, 0.9286877750620246, 0.92870331733361544, 0.9287810408963536, 0.92873440431662424, 0.92876549455523827, 0.92873440431662424, 0.92873440431662424, 0.92873440431662424, 0.92864115312238849, 0.92865669295678677, 0.92857900189751341, 0.92857900189751341, 0.92854793114745682, 0.92847026843033154, 0.92848579935719933, 0.92842368049349133, 0.92847026843033154, 0.92839262590166627, 0.92834605005558113, 0.92831500351500695, 0.9282529200768852, 0.92833052638319413, 0.92828396018975912, 0.92822188317343279, 0.92822188317343279, 0.92811327924316711, 0.92802022132802919, 0.92802022132802919, 0.92797370313310801, 0.92791169001236551, 0.92795819866016493, 0.92789618871890955, 0.92783419148109525, 0.92788068821941849, 0.92784968960087721, 0.92783419148109525, 0.9278651885135194, 0.92783419148109525, 0.92780319761876195, 0.92771023502344052, 0.92772572681311449, 0.92766376439082177, 0.92761730085533578, 0.92753987737476118, 0.92752439503723039, 0.92747795273536837, 0.92747795273536837, 0.92743151749220232, 0.92744699512288675, 0.92747795273536837, 0.92744699512288675, 0.92743151749220232, 0.92740056458019371, 0.92744699512288675, 0.92744699512288675, 0.9273850892981752, 0.92735414108029435, 0.92733866814373767, 0.92733866814373767, 0.92732319598830548, 0.92732319598830548, 0.92727678420521187, 0.92726131517073718, 0.92724584691563272, 0.92723037943954767, 0.92721491274211343, 0.92724584691563272, 0.92726131517073718, 0.92726131517073718, 0.92726131517073718, 0.92724584691563272, 0.92721491274211343, 0.92721491274211343, 0.92719944682300437, 0.92724584691563272, 0.92723037943954767, 0.92726131517073718, 0.92726131517073718, 0.92726131517073718, 0.92727678420521187, 0.92727678420521187, 0.92727678420521187, 0.92726131517073718, 0.9273077246136342, 0.92729225401939186, 0.9273077246136342, 0.9273077246136342, 0.92726131517073718, 0.92724584691563272, 0.92719944682300437, 0.92715305373204615, 0.92716851731830985, 0.92721491274211343, 0.92723037943954767, 0.92723037943954767, 0.92724584691563272, 0.92726131517073718, 0.92723037943954767, 0.92721491274211343, 0.92716851731830985, 0.92713759092269321, 0.9271221288899032, 0.92710666763333516, 0.92713759092269321, 0.92718398168185567, 0.92716851731830985, 0.92716851731830985, 0.92716851731830985, 0.92715305373204615, 0.92715305373204615, 0.92716851731830985, 0.92713759092269321, 0.92713759092269321, 0.92713759092269321, 0.92715305373204615, 0.92716851731830985, 0.92718398168185567, 0.92716851731830985, 0.92721491274211343, 0.92724584691563272, 0.92727678420521187, 0.92729225401939186, 0.92732319598830548, 0.92733866814373767, 0.92733866814373767, 0.92732319598830548, 0.92732319598830548, 0.92729225401939186, 0.92732319598830548, 0.92733866814373767, 0.92735414108029435, 0.9273696147983177, 0.9273850892981752, 0.92740056458019371, 0.9274160406447618, 0.92740056458019371, 0.9274160406447618, 0.92740056458019371, 0.92740056458019371, 0.92743151749220232, 0.92749343271787754, 0.92750891348505138, 0.92755536049801379, 0.92757084440734427, 0.92761730085533578, 0.9276018145856515, 0.92763278791251913, 0.92763278791251913, 0.92767925381264194, 0.92767925381264194, 0.92769474402340313, 0.92767925381264194, 0.92767925381264194, 0.92764827575756481, 0.92761730085533578, 0.92757084440734427, 0.92757084440734427, 0.92755536049801379, 0.92757084440734427, 0.92758632910311201, 0.92761730085533578, 0.9276018145856515, 0.92764827575756481, 0.92767925381264194, 0.92774121939281828, 0.92774121939281828, 0.92780319761876195, 0.92783419148109525, 0.92788068821941849, 0.92789618871890955, 0.92792719210015051, 0.92795819866016493, 0.9280047144666751, 0.9280047144666751, 0.92805123744172646, 0.92803572898626818, 0.92805123744172646, 0.92805123744172646, 0.92806674669478295, 0.9280047144666751, 0.92808225674579259, 0.92812879169025342, 0.92820636592431915, 0.92826843973194917, 0.92834605005558113, 0.92834605005558113, 0.92836157453254042, 0.92837709981444405, 0.92842368049349133, 0.92843920899885635, 0.92848579935719933, 0.92850133109197341, 0.92851686363502228, 0.92850133109197341, 0.92851686363502228, 0.92851686363502228, 0.92854793114745682, 0.92856346611760265, 0.92861007588815325, 0.92861007588815325, 0.9286256140996374, 0.92861007588815325, 0.9286256140996374, 0.9286256140996374, 0.92864115312238849, 0.9286256140996374, 0.92864115312238849, 0.92867223360320161, 0.92873440431662424, 0.92876549455523827, 0.92881213602404966, 0.92882768481139633, 0.9288587848349773, 0.92887433607196357, 0.92892099468829481, 0.92890544099823946, 0.9289365491967857, 0.92890544099823946, 0.92890544099823946, 0.9289365491967857, 0.92896766067063552, 0.92896766067063552, 0.92899877542284048, 0.92901433402928368, 0.92904545370474323, 0.92904545370474323, 0.92906101477452896, 0.92906101477452896, 0.92910770291670963, 0.92912326727632089, 0.92916996529718321, 0.92916996529718321, 0.92916996529718321, 0.92915439846616898, 0.92915439846616898, 0.92909213938012747, 0.92909213938012747, 0.92907657666620158, 0.92907657666620158, 0.92907657666620158, 0.92912326727632089, 0.92910770291670963, 0.92912326727632089, 0.92910770291670963, 0.92907657666620158, 0.92909213938012747, 0.92910770291670963, 0.92910770291670963, 0.92915439846616898, 0.92916996529718321, 0.92916996529718321, 0.92910770291670963, 0.92910770291670963, 0.92909213938012747, 0.92907657666620158, 0.92902989345646225, 0.92899877542284048, 0.92896766067063552, 0.92895210452411037, 0.92895210452411037, 0.92896766067063552, 0.92892099468829481, 0.92884323441490579, 0.92876549455523827, 0.92876549455523827, 0.92879658805250354, 0.92881213602404966, 0.92884323441490579, 0.92888988812627149, 0.92890544099823946, 0.9288587848349773, 0.92879658805250354, 0.92871886041835794, 0.92864115312238849, 0.92856346611760265, 0.92851686363502228, 0.92859453848756723, 0.92873440431662424, 0.92888988812627149, 0.92902989345646225, 0.92912326727632089, 0.92923224087076239, 0.92923224087076239, 0.92918553295276562, 0.92909213938012747, 0.92892099468829481, 0.92876549455523827, 0.92865669295678677, 0.92859453848756723, 0.92864115312238849, 0.92876549455523827, 0.92896766067063552, 0.92915439846616898, 0.92934125494474007, 0.92943472789864146, 0.9294658921950476, 0.92937240927660736, 0.92924781182847838, 0.9291388324593427, 0.92899877542284048, 0.9289365491967857, 0.9289365491967857, 0.9289832176367564, 0.92901433402928368, 0.92906101477452896, 0.92910770291670963, 0.92910770291670963, 0.92909213938012747, 0.92906101477452896, 0.92902989345646225, 0.92899877542284048, 0.92895210452411037, 0.92888988812627149, 0.92881213602404966, 0.9287810408963536, 0.92874994902879959, 0.92879658805250354, 0.9288587848349773, 0.92890544099823946, 0.92896766067063552, 0.9289832176367564, 0.92896766067063552, 0.92892099468829481, 0.92882768481139633, 0.92876549455523827, 0.92865669295678677, 0.92857900189751341, 0.92854793114745682, 0.92854793114745682, 0.92857900189751341, 0.92865669295678677, 0.92870331733361544, 0.92874994902879959, 0.92876549455523827, 0.92879658805250354, 0.92882768481139633, 0.9288587848349773, 0.9288587848349773, 0.92887433607196357, 0.92888988812627149, 0.9289832176367564, 0.9289832176367564, 0.9289832176367564, 0.92899877542284048, 0.92895210452411037, 0.92890544099823946, 0.92890544099823946, 0.92887433607196357, 0.92892099468829481, 0.92901433402928368, 0.92912326727632089, 0.92924781182847838, 0.92932567902223662, 0.92938798768674158, 0.92940356692687343, 0.92937240927660736, 0.92940356692687343, 0.92940356692687343, 0.92941914699737149, 0.92935683169607797, 0.9294658921950476, 0.92940356692687343, 0.92932567902223662, 0.92915439846616898, 0.92896766067063552, 0.92882768481139633, 0.92876549455523827, 0.92865669295678677, 0.9286877750620246, 0.92861007588815325, 0.92890544099823946, 0.9288587848349773, 0.92881213602404966, 0.92865669295678677, 0.92861007588815325, 0.92839262590166627, 0.92829948145065255, 0.92805123744172646, 0.92853239698673073, 0.92845473831100789, 0.92836157453254042, 0.92837709981444405, 0.92823740122416565, 0.92829948145065255, 0.92811327924316711, 0.92895210452411037, 0.92904545370474323, 0.9289832176367564, 0.92892099468829481, 0.92909213938012747, 0.92892099468829481, 0.92994936626906488, 0.93002742162577579, 0.93001180886364387, 0.92999619694731239, 0.93005864968905472, 0.93079349151160073, 0.93085611899503595, 0.93073087788826214, 0.93059004777387044, 0.93052747901224786, 0.93102841625930222, 0.93085611899503595, 0.93052747901224786, 0.93019921794696403, 0.9296997307066992, 0.93004303523411069, 0.9296217636560028, 0.92934125494474007, 0.92920110143329937, 0.92943472789864146, 0.92937240927660736, 0.92926338361268446, 0.92916996529718321, 0.92938798768674158, 0.92934125494474007, 0.92934125494474007, 0.92926338361268446, 0.92937240927660736, 0.92935683169607797, 0.92931010392817071, 0.92923224087076239, 0.92926338361268446, 0.9291388324593427, 0.92912326727632089, 0.9291388324593427, 0.92926338361268446, 0.92935683169607797, 0.9294970598192116, 0.929715326628762, 0.92988693718161031, 0.93007426499099133, 0.93030859643482788, 0.93044928738939503, 0.93062133731820051, 0.93076218296908519, 0.93091876036533239, 0.93102841625930222, 0.93113811490828913, 0.9312478564574489, 0.9314203944904047, 0.93160873970147251, 0.93178150184193176, 0.93198581466441199, 0.93215881336311779, 0.93228469925378998, 0.93245788722231149, 0.932646945476725, 0.93280459494784917, 0.93307281098774308, 0.93338870365322824, 0.93362586961976202, 0.9339107501437327, 0.93413253778882854, 0.93424350226567698, 0.93435451407101144, 0.93451318480261114, 0.93449731335309449, 0.93468783516595977, 0.9347196024965766, 0.9349579828249136, 0.93516475896935414, 0.93524433298143816, 0.9353876291137555, 0.93561069576669731, 0.9356585214686125, 0.93589778682773372, 0.93602548870667235, 0.93623314414766035, 0.93650495666126754, 0.93647296316563211, 0.93664897895369181, 0.93655295470880962, 0.93663297230270204, 0.93669700518114485, 0.93661696669653205, 0.93666498665005415, 0.93660096213462685, 0.93672902790043733, 0.9365369543183425, 0.93669700518114485, 0.93695330458315185, 0.93690522792164421, 0.93712966711012191, 0.93719383076861107, 0.93741853796075292, 0.93733826133812714, 0.9374667168025238, 0.9373543145206642, 0.93743459650117211, 0.93757917173410887, 0.93743459650117211, 0.93761131141295062, 0.93757917173410887, 0.93777207468602697, 0.93773991336520024, 0.93788467353773086, 0.93778815697461204, 0.93782032481106636, 0.93773991336520024, 0.93782032481106636, 0.93775599348309202, 0.93788467353773086, 0.93790076344240692, 0.93811003164602047, 0.93809392751966014, 0.93830336699270223, 0.93825501827358426, 0.9384323455942376, 0.93857753147602441, 0.93854526015160955, 0.93846460133555321, 0.93862594683300959, 0.93856139525620241, 0.93867437224928552, 0.93862594683300959, 0.93870666145688242, 0.93857753147602441, 0.93865822932513443, 0.93859366881168893, 0.93872280774157213, 0.93864208751992873, 0.93877125332656486, 0.93872280774157213, 0.938819709021122, 0.93873895514765249, 0.93883586316876499, 0.93873895514765249, 0.93877125332656486, 0.93865822932513443, 0.93857753147602441, 0.93872280774157213, 0.93865822932513443, 0.93870666145688242, 0.93857753147602441, 0.93864208751992873, 0.93854526015160955, 0.93844847290943434, 0.93856139525620241, 0.93862594683300959, 0.93880355599861265, 0.938852018442211, 0.93904596976198396, 0.93906213972756358, 0.93902980093032007, 0.93911065643432834, 0.93898130123271339, 0.93906213972756358, 0.93902980093032007, 0.93902980093032007, 0.93917536129024837, 0.9391430065868005, 0.93919154035016683, 0.93904596976198396, 0.93888433236889512, 0.938868174842036, 0.93870666145688242, 0.93870666145688242, 0.93859366881168893, 0.93856139525620241, 0.93867437224928552, 0.93873895514765249, 0.93873895514765249, 0.93883586316876499, 0.93873895514765249, 0.938819709021122, 0.93877125332656486, 0.93875510367578185, 0.93872280774157213, 0.93870666145688242, 0.93869051629300337, 0.93865822932513443, 0.93864208751992873, 0.93862594683300959, 0.93860980726381238, 0.93859366881168893, 0.93857753147602441, 0.93856139525620241, 0.93854526015160955, 0.9385291261616322, 0.93851299328566051, 0.93849686152307576, 0.93848073087323536, 0.93846460133555321, 0.93846460133555321, 0.93844847290943434, 0.9384323455942376, 0.9384323455942376, 0.93841621938934772, 0.93840009429417048, 0.93840009429417048, 0.93838397030809051, 0.93838397030809051, 0.93838397030809051, 0.93836784743049118, 0.93836784743049118, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93833560499829427, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93835172566076452, 0.93836784743049118, 0.93836784743049118, 0.93836784743049118, 0.93838397030809051, 0.93838397030809051, 0.93838397030809051, 0.93840009429417048, 0.93840009429417048, 0.93841621938934772, 0.93841621938934772, 0.9384323455942376, 0.9384323455942376, 0.93844847290943434, 0.93846460133555321, 0.93846460133555321, 0.93848073087323536, 0.93849686152307576, 0.93849686152307576, 0.93851299328566051, 0.9385291261616322, 0.9385291261616322, 0.93854526015160955, 0.93856139525620241, 0.93857753147602441, 0.93859366881168893, 0.93860980726381238, 0.93860980726381238, 0.93862594683300959, 0.93864208751992873, 0.93865822932513443, 0.93867437224928552, 0.93869051629300337, 0.93870666145688242, 0.93872280774157213, 0.93873895514765249, 0.93875510367578185, 0.93878740410064121, 0.93880355599861265, 0.938819709021122, 0.93883586316876499, 0.938852018442211, 0.93888433236889512, 0.9389004910234181, 0.93891665080619391, 0.93893281171789478, 0.93894897375911468, 0.93898130123271339, 0.938997466666322, 0.93901363323197351, 0.93902980093032007, 0.93904596976198396, 0.93907831082773607, 0.9390944830631105, 0.93911065643432834, 0.93912683094201932, 0.9391430065868005, 0.93917536129024837, 0.93919154035016683, 0.93920772054973822, 0.93922390188959792, 0.93924008437037443, 0.9392724527572327, 0.93928863866460766, 0.93930482571543861, 0.93932101391040002, 0.93935339373521731, 0.93936958536636062, 0.93940197206932219, 0.93941816714243909, 0.93943436336414454, 0.93945056073510458, 0.93948295892736844, 0.93949915974996567, 0.9395153617243881, 0.93953156485127165, 0.93954776913129678, 0.93956397456511442, 0.93958018115332742, 0.93959638889662234, 0.93961259779563078, 0.93962880785101532, 0.93966123143349067, 0.9396774449618831, 0.93969365964924711, 0.93970987549625018, 0.93972609250353167, 0.93975853000156773, 0.93977475049360415, 0.9397909721485519, 0.93980719496705944, 0.93982341894976384, 0.93985587041044594, 0.93987209788975068, 0.93988832653587318, 0.93990455634951986, 0.93992078733130224, 0.93995325280200714, 0.93996948729225072, 0.93998572295329752, 0.94000195978580448, 0.94003443696787492, 0.94005067731877778, 0.9400831615435925, 0.94009940541886416, 0.94011565047024526, 0.94013189669841646, 0.94016439268777319, 0.94018064245030775, 0.94019689339230816, 0.94021314551442325, 0.94022939881735068, 0.94026190896828754, 0.94027816581763668, 0.94029442385047679, 0.94031068306747012, 0.9403269434692989, 0.94035946783016866, 0.94037573179054634, 0.94039199693845077, 0.94040826327456739, 0.94042453079957788, 0.94045706941898022, 0.94047334051470699, 0.94048961280205789, 0.94050588628166154, 0.94052216095424246, 0.94055471388099765, 0.94057099213656037, 0.94058727158779043, 0.94060355223540215, 0.94061983408007599, 0.94065240136328876, 0.94066868680322868, 0.94068497344297453, 0.94070126128318277, 0.94071755032456761, 0.94075013201362123, 0.9407664246626557, 0.94078271851560802, 0.94079901357317153, 0.94081530983603712, 0.94084790598047341, 0.94086420586343311, 0.94088050695446179, 0.94089680925423858, 0.94091311276349676, 0.94092941748290271, 0.9409457234131734, 0.94096203055497829, 0.94097833890905047, 0.94099464847605563, 0.94102727125167207, 0.94104358446170222, 0.94105989888746377, 0.94107621452966195, 0.94109253138900595, 0.9411088494661729, 0.94112516876190289, 0.94114148927687191, 0.94115781101178453, 0.94117413396735394, 0.94120678354326359, 0.9412231101649986, 0.94123943801022092, 0.94125576707962699, 0.9412720973739136, 0.94130476163997379, 0.94132109561315813, 0.94133743081408805, 0.94135376724344477, 0.94137010490192752, 0.94138644379027925, 0.94140278390918386, 0.94141912525935678, 0.94143546784155097, 0.94145181165643521, 0.94146815670473205, 0.94148450298717234, 0.94150085050446608, 0.94151719925732502, 0.94153354924648647, 0.9415662529364982, 0.94158260663879756, 0.94159896158027323, 0.94161531776161111, 0.94163167518355784, 0.94164803384679441, 0.94166439375210498, 0.94168075490017622, 0.94169711729173178, 0.94171348092749541, 0.94172984580818775, 0.94174621193455132, 0.9417625793072858, 0.94177894792713612, 0.94179531779484027, 0.94182806127663266, 0.94184443489220626, 0.94186080975853037, 0.94187718587633806, 0.94189356324636608, 0.9419099418693021, 0.94192632174593349, 0.94194270287697079, 0.94195908526315142, 0.9419754689051969, 0.94199185380385841, 0.94200823995984906, 0.94202462737393899, 0.94204101604680246, 0.94205740597925569, 0.94207379717197437, 0.94209018962572355, 0.9421065833412301, 0.94212297831924174, 0.94213937456050889, 0.94213937456050889, 0.94215577206572187, 0.94217217083570515, 0.94218857087112662, 0.94220497217275323, 0.94220497217275323, 0.94222137474134815, 0.94223777857762858, 0.94225418368234104, 0.94227059005625324, 0.94227059005625324, 0.9422869977000885, 0.94230340661458745, 0.94231981680050636, 0.94231981680050636, 0.94233622825859475, 0.94233622825859475, 0.9423526409896229, 0.94236905499431733, 0.94236905499431733, 0.94238547027338948, 0.94238547027338948, 0.94240188682767267, 0.94241830465784615, 0.94243472376468074, 0.94245114414893827, 0.94246756581138624, 0.94248398875275141, 0.94250041297377352, 0.94251683847525669, 0.94251683847525669, 0.94253326525789582, 0.94254969332250005, 0.94256612266981643, 0.94258255330058383, 0.94259898521556174, 0.94261541841549135, 0.94263185290118423, 0.94264828867333639, 0.9426647257327756, 0.94268116408021785, 0.9426976037164303, 0.94271404464217079, 0.94273048685823635, 0.94274693036535318, 0.94276337516430031, 0.94277982125582216, 0.94279626864072585, 0.94281271731974803, 0.94282916729364885, 0.94282916729364885, 0.94284561856323101, 0.94286207112921894, 0.94287852499240776, 0.94289498015356144, 0.94289498015356144, 0.94291143661345356, 0.94292789437285995, 0.94294435343254102, 0.9429608137932709, 0.9429608137932709, 0.94297727545580989, 0.9429937384209629, 0.94301020268945979, 0.94302666826213477, 0.94302666826213477, 0.9430431351397307, 0.94305960332300054, 0.94307607281276362, 0.94307607281276362, 0.94309254360975214, 0.94309254360975214, 0.94310901571479477, 0.94312548912862337, 0.94312548912862337, 0.94314196385204285, 0.94314196385204285, 0.94315843988584069, 0.94317491723078739, 0.94317491723078739, 0.94319139588765277, 0.94319139588765277, 0.94320787585724419, 0.94322435714033181, 0.94322435714033181, 0.94324083973769379, 0.94324083973769379, 0.94325732365010917, 0.94327380887836354, 0.94327380887836354, 0.94329029542327103, 0.94329029542327103, 0.94330678328559681, 0.94332327246613656, 0.94332327246613656, 0.94333976296563704, 0.94333976296563704, 0.94335625478494145, 0.94335625478494145, 0.9433727479248144, 0.9433727479248144, 0.94338924238605271, 0.94338924238605271, 0.9434057381694344, 0.9434057381694344, 0.94342223527575697, 0.94342223527575697, 0.94343873370581788, 0.94343873370581788, 0.94345523346041149, 0.94345523346041149, 0.94347173454031275, 0.94347173454031275, 0.94348823694634643, 0.94348823694634643, 0.94350474067924728, 0.94350474067924728, 0.94352124573987561, 0.94352124573987561, 0.94353775212898405, 0.94353775212898405, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94355425984742158, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94357076889594704, 0.94358727927532482, 0.94358727927532482, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94360379098640079, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94362030402998776, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94363681840686042, 0.94362030402998776, 0.94362030402998776, 0.94360379098640079, 0.94360379098640079, 0.94358727927532482, 0.94357076889594704, 0.94357076889594704, 0.94355425984742158, 0.94353775212898405, 0.94352124573987561, 0.94350474067924728, 0.94348823694634643, 0.94347173454031275, 0.94345523346041149, 0.94343873370581788, 0.9434057381694344, 0.94338924238605271, 0.94335625478494145, 0.94333976296563704, 0.94330678328559681, 0.94327380887836354, 0.94324083973769379, 0.94320787585724419, 0.94317491723078739])


if __name__ == '__main__':
    from matplotlib import pyplot as plt
    import numpy as np

    plt.plot(lambd, PD_k_Cm, label="ProspectD")
    plt.plot(lambd, P5_k_Cm, label="Prospect5B")
    plt.plot(lambd, P4_k_Cm, label="Prospect4")
    plt.xlabel("Wavelength [nm]")
    plt.ylabel("Absorption coefficient")
    plt.title("Absorption coefficients of dry matter")
    plt.legend()
    plt.savefig(r"D:\ECST_III\Papers\2017_ISD\5th submission RS\Figures\drymatter_abs.png", dpi=700)
    plt.show()

    plt.plot(lambd, PD_k_Brown, label="ProspectD")
    plt.plot(lambd, P5_k_Brown, label="Prospect5B")
    plt.xlabel("Wavelength [nm]")
    plt.ylabel("Absorption coefficient")
    plt.title("Absorption coefficients of Brown Pigments")
    plt.legend()
    plt.savefig(r"D:\ECST_III\Papers\2017_ISD\5th submission RS\Figures\cbrown_abs.png", dpi=700)
    plt.show()

    plt.plot(lambd, PD_refractive, label="ProspectD")
    plt.plot(lambd, P5_refractive, label="Prospect5B")
    plt.plot(lambd, P4_refractive, label="Prospect4")
    plt.xlabel("Wavelength [nm]")
    plt.ylabel("Refractive Index")
    plt.title("Refractive Indices")
    plt.legend()
    plt.savefig(r"D:\ECST_III\Papers\2017_ISD\5th submission RS\Figures\refractive_index.png", dpi=700)
    plt.show()