from math import nan

import numpy as np

from enmapboxprocessing.algorithm.testcase import TestCase
from profileanalyticsapp.examples.rbftimeseriesfitting import rbfEnsemblePrediction


class TestRbfTimeseriesFitting(TestCase):

    def test_core(self):
        # example data: two temporal profiles from 1984 to 2006
        # - X: aquisition dates [decimal years]
        # - Y: target variable/index; missing data coded as nan

        X = np.array([1984.2896, 1984.3523, 1984.3961, 1984.4207, 1984.4644, 1984.4835, 1984.5955, 1984.6393, 1984.6583,
                      1984.683, 1984.702, 1984.7267, 1984.7457, 1984.7704, 1984.8141, 1984.8579, 1984.8771, 1984.9016,
                      1984.9453, 1985.052, 1985.096, 1985.2083, 1985.252, 1985.3834, 1985.4026, 1985.4464, 1985.4711,
                      1985.515, 1985.5342, 1985.5588, 1985.578, 1985.6027, 1985.6465, 1985.6656, 1985.7341, 1985.778,
                      1985.7971, 1985.8657, 1985.9095, 1985.9287, 1986.1288, 1986.148, 1986.1918, 1986.304, 1986.3478,
                      1986.3671, 1986.3917, 1986.4109, 1986.4355, 1986.4547, 1986.4985, 1986.5424, 1986.567, 1986.5862,
                      1986.6108, 1986.63, 1986.6547, 1986.6985, 1986.7177, 1986.7423, 1986.7615, 1986.7861, 1986.8301,
                      1986.874, 1986.9178, 1986.937, 1987.0247, 1987.0493, 1987.0685, 1987.0931, 1987.1561, 1987.2,
                      1987.2246, 1987.2684, 1987.2876, 1987.3123, 1987.3314, 1987.3561, 1987.3752, 1987.3999, 1987.4191,
                      1987.4437, 1987.4629, 1987.4875, 1987.5067, 1987.5314, 1987.5505, 1987.5752, 1987.5944, 1987.619,
                      1987.6382, 1987.6628, 1987.6821, 1987.7068, 1987.726, 1987.7478, 1987.7506, 1987.7698, 1987.7944,
                      1987.8136, 1987.8575, 1987.8822, 1987.9014, 1987.926, 1987.989, 1988.0137, 1988.0328, 1988.0547,
                      1988.0792, 1988.1011, 1988.1448, 1988.1885, 1988.2076, 1988.2295, 1988.2323, 1988.2512, 1988.2759,
                      1988.2949, 1988.3386, 1988.3633, 1988.3824, 1988.4043, 1988.407, 1988.4261, 1988.4507, 1988.4698,
                      1988.4944, 1988.5135, 1988.5381, 1988.5573, 1988.5819, 1988.601, 1988.6447, 1988.6693, 1988.6884,
                      1988.713, 1988.7322, 1988.7567, 1988.7759, 1988.8004, 1988.8634, 1988.9098, 1988.929, 1988.9508,
                      1988.9755, 1988.9945, 1988.9973, 1989.0165, 1989.0192, 1989.0383, 1989.0822, 1989.1068, 1989.1699,
                      1989.1946, 1989.2137, 1989.2574, 1989.2821, 1989.3259, 1989.3451, 1989.3698, 1989.3889, 1989.4136,
                      1989.4327, 1989.4574, 1989.4766, 1989.5012, 1989.545, 1989.5642, 1989.5889, 1989.6082, 1989.6328,
                      1989.652, 1989.6766, 1989.6958, 1989.7205, 1989.7396, 1989.7643, 1989.7834, 1989.8081, 1989.852,
                      1989.8959, 1989.9178, 1989.937, 1989.9397, 1989.9589, 1989.9617, 1990.0273, 1990.0466, 1990.0713,
                      1990.1343, 1990.1781, 1990.2028, 1990.2219, 1990.3094, 1990.3341, 1990.3533, 1990.3779, 1990.3971,
                      1990.4218, 1990.441, 1990.4657, 1990.4849, 1990.5095, 1990.5287, 1990.5533, 1990.5725, 1990.5972,
                      1990.6163, 1990.641, 1990.6602, 1990.6848, 1990.704, 1990.7286, 1990.7478, 1990.7725, 1990.7916,
                      1990.8163, 1990.8356, 1990.8602, 1990.8794, 1990.948, 1990.9672, 1991.011, 1991.0548, 1991.0986,
                      1991.1425, 1991.1863, 1991.2109, 1991.2301, 1991.2546, 1991.2738, 1991.2985, 1991.3177, 1991.3424,
                      1991.3862, 1991.4054, 1991.43, 1991.4492, 1991.4739, 1991.493, 1991.5177, 1991.5369, 1991.5615,
                      1991.5807, 1991.6053, 1991.6245, 1991.6492, 1991.6683, 1991.693, 1991.7122, 1991.7368, 1991.7561,
                      1991.7808, 1991.7999, 1991.8247, 1991.8439, 1991.8685, 1991.8877, 1991.9124, 1991.9562, 1991.9753,
                      1992.0192, 1992.0437, 1992.1066, 1992.1311, 1992.1748, 1992.194, 1992.2622, 1992.3059, 1992.3496,
                      1992.3688, 1992.4125, 1992.437, 1992.4562, 1992.4807, 1992.4999, 1992.5245, 1992.5436, 1992.5682,
                      1992.5873, 1992.631, 1992.6556, 1992.6748, 1992.6993, 1992.7185, 1992.743, 1992.7622, 1992.7867,
                      1992.8306, 1992.8497, 1992.8743, 1992.9181, 1993.0055, 1993.0247, 1993.0493, 1993.0931, 1993.1123,
                      1993.137, 1993.1561, 1993.1808, 1993.2, 1993.2438, 1993.3123, 1993.3314, 1993.3752, 1993.3999,
                      1993.4437, 1993.4629, 1993.4875, 1993.5067, 1993.5314, 1993.5505, 1993.5752, 1993.5944, 1993.619,
                      1993.6382, 1993.6628, 1993.6821, 1993.7068, 1993.726, 1993.7506, 1993.7698, 1993.7944, 1993.8136,
                      1993.8384, 1993.8575, 1993.926, 1993.9452, 1993.989, 1994.0137, 1994.1013, 1994.1453, 1994.1644,
                      1994.1891, 1994.2329, 1994.252, 1994.2766, 1994.2958, 1994.3204, 1994.3396, 1994.3643, 1994.3834,
                      1994.4081, 1994.4272, 1994.4519, 1994.4711, 1994.4957, 1994.515, 1994.5588, 1994.5835, 1994.6027,
                      1994.6273, 1994.6465, 1994.6711, 1994.6903, 1994.715, 1994.7341, 1994.778, 1994.8218, 1994.8466,
                      1994.8657, 1994.8904, 1994.9342, 1994.978, 1995.022, 1995.0411, 1995.0658, 1995.1096, 1995.1534,
                      1995.1726, 1995.1973, 1995.2164, 1995.241, 1995.2601, 1995.2848, 1995.304, 1995.3286, 1995.3478,
                      1995.3724, 1995.3917, 1995.4164, 1995.4355, 1995.4602, 1995.4794, 1995.504, 1995.5479, 1995.567,
                      1995.5917, 1995.6108, 1995.6355, 1995.6547, 1995.6793, 1995.6985, 1995.767, 1995.7861, 1995.874,
                      1995.8987, 1995.9178, 1996.0492, 1996.0737, 1996.0929, 1996.1366, 1996.205, 1996.224, 1996.2485,
                      1996.2677, 1996.2922, 1996.3114, 1996.3359, 1996.3551, 1996.3796, 1996.3988, 1996.4233, 1996.4425,
                      1996.467, 1996.4862, 1996.5109, 1996.5299, 1996.5546, 1996.5736, 1996.5983, 1996.6174, 1996.642,
                      1996.6611, 1996.6857, 1996.7048, 1996.7294, 1996.7922, 1996.8168, 1996.836, 1996.8606, 1996.8798,
                      1996.9481, 1996.9672, 1996.9918, 1997.011, 1997.0548, 1997.0795, 1997.0986, 1997.1233, 1997.1425,
                      1997.1671, 1997.2738, 1997.2985, 1997.3177, 1997.3424, 1997.3616, 1997.3862, 1997.4054, 1997.4739,
                      1997.493, 1997.5177, 1997.5369, 1997.5615, 1997.5807, 1997.6053, 1997.6245, 1997.6492, 1997.6683,
                      1997.693, 1997.7122, 1997.7368, 1997.7808, 1997.7999, 1997.8247, 1997.8439, 1997.8685, 1997.9124,
                      1997.9315, 1997.9562, 1997.9753, 1998.0, 1998.0192, 1998.063, 1998.1068, 1998.1506, 1998.1753,
                      1998.2384, 1998.263, 1998.3068, 1998.3259, 1998.3506, 1998.4136, 1998.4382, 1998.4574, 1998.482,
                      1998.5012, 1998.5259, 1998.545, 1998.5697, 1998.5889, 1998.6135, 1998.6328, 1998.6575, 1998.6766,
                      1998.7013, 1998.7205, 1998.7451, 1998.7643, 1998.789, 1998.8081, 1998.8329, 1998.852, 1998.8767,
                      1998.8959, 1998.9205, 1998.9397, 1998.9835, 1999.0082, 1999.0273, 1999.052, 1999.0713, 1999.096,
                      1999.1398, 1999.1589, 1999.1836, 1999.2274, 1999.2465, 1999.2711, 1999.315, 1999.3341, 1999.3588,
                      1999.3779, 1999.4026, 1999.4218, 1999.4464, 1999.4657, 1999.4904, 1999.5095, 1999.5342, 1999.5533,
                      1999.556, 1999.5752, 1999.578, 1999.5972, 1999.5999, 1999.619, 1999.6218, 1999.641, 1999.6437,
                      1999.6656, 1999.6848, 1999.6875, 1999.7068, 1999.7286, 1999.7314, 1999.7506, 1999.7533, 1999.7725,
                      1999.7753, 1999.7944, 1999.7971, 1999.8163, 1999.8191, 1999.8384, 1999.8411, 1999.8602, 1999.863,
                      1999.8822, 1999.904, 1999.9069, 1999.926, 1999.948, 1999.9698, 1999.9918, 1999.9945, 2000.0792,
                      2000.0819, 2000.1011, 2000.1229, 2000.1257, 2000.1448, 2000.1666, 2000.1885, 2000.1913, 2000.2131,
                      2000.2323, 2000.2349, 2000.3004, 2000.3196, 2000.3223, 2000.3414, 2000.3441, 2000.3633, 2000.366,
                      2000.3851, 2000.3878, 2000.4097, 2000.4288, 2000.4316, 2000.4507, 2000.4535, 2000.4725, 2000.4944,
                      2000.4972, 2000.5162, 2000.519, 2000.5409, 2000.5599, 2000.5627, 2000.5819, 2000.5846, 2000.6038,
                      2000.6064, 2000.6256, 2000.6283, 2000.6475, 2000.6501, 2000.6693, 2000.672, 2000.6912, 2000.6938,
                      2000.713, 2000.7157, 2000.7349, 2000.7567, 2000.7812, 2000.8004, 2000.8032, 2000.8223, 2000.8251,
                      2000.8442, 2000.847, 2000.8661, 2000.8689, 2000.888, 2000.8907, 2000.9344, 2000.9535, 2000.9563,
                      2000.9781, 2001.0192, 2001.022, 2001.0438, 2001.0658, 2001.0876, 2001.1068, 2001.1288, 2001.1315,
                      2001.1726, 2001.1753, 2001.1946, 2001.2164, 2001.2192, 2001.2383, 2001.263, 2001.2821, 2001.304,
                      2001.3068, 2001.3259, 2001.3478, 2001.3506, 2001.3698, 2001.3917, 2001.4136, 2001.4164, 2001.4355,
                      2001.4382, 2001.4574, 2001.4602, 2001.4794, 2001.482, 2001.5012, 2001.504, 2001.5259, 2001.545,
                      2001.5479, 2001.567, 2001.5697, 2001.5889, 2001.5917, 2001.6108, 2001.6355, 2001.6547, 2001.6575,
                      2001.6766, 2001.6793, 2001.6985, 2001.7013, 2001.7205, 2001.7423, 2001.7451, 2001.7643, 2001.7861,
                      2001.789, 2001.8081, 2001.8301, 2001.8329, 2001.8547, 2001.874, 2001.8767, 2001.9617, 2001.9644,
                      2002.0055, 2002.0273, 2002.0302, 2002.0493, 2002.052, 2002.074, 2002.096, 2002.1151, 2002.1178,
                      2002.137, 2002.1589, 2002.1616, 2002.1808, 2002.1836, 2002.2028, 2002.2054, 2002.2246, 2002.2274,
                      2002.2711, 2002.2903, 2002.315, 2002.3588, 2002.3779, 2002.3807, 2002.4026, 2002.4246, 2002.4437,
                      2002.4464, 2002.4657, 2002.4684, 2002.4875, 2002.4904, 2002.5122, 2002.5314, 2002.5342, 2002.5533,
                      2002.556, 2002.5752, 2002.5972, 2002.5999, 2002.6218, 2002.6656, 2002.6848, 2002.7095, 2002.7533,
                      2002.7971, 2002.8163, 2002.9727, 2003.0165, 2003.0603, 2003.0795, 2003.1671, 2003.1918, 2003.2109,
                      2003.2356, 2003.2546, 2003.2793, 2003.2985, 2003.3231, 2003.3424, 2003.3671, 2003.4109, 2003.4766,
                      2003.4957, 2003.5204, 2003.5397, 2003.5642, 2003.5835, 2003.6082, 2003.6273, 2003.6711, 2003.6958,
                      2003.715, 2003.7177, 2003.7396, 2003.7808, 2003.7834, 2003.8026, 2003.8932, 2003.9124, 2004.0437,
                      2004.0465, 2004.0656, 2004.0902, 2004.112, 2004.1776, 2004.1968, 2004.1995, 2004.2186, 2004.2622,
                      2004.2649, 2004.3086, 2004.3715, 2004.3741, 2004.4152, 2004.4398, 2004.4589, 2004.4807, 2004.4835,
                      2004.5026, 2004.5245, 2004.5272, 2004.5464, 2004.5709, 2004.5901, 2004.5928, 2004.6146, 2004.6365,
                      2004.6583, 2004.6775, 2004.6993, 2004.702, 2004.7239, 2004.743, 2004.7457, 2004.7867, 2004.8304,
                      2004.8743, 2004.8771, 2004.9208, 2004.9426, 2005.0302, 2005.0713, 2005.1151, 2005.137, 2005.1398,
                      2005.1589, 2005.1808, 2005.1836, 2005.2054, 2005.2246, 2005.2274, 2005.2465, 2005.2684, 2005.2711,
                      2005.3123, 2005.315, 2005.3341, 2005.3369, 2005.3588, 2005.3779, 2005.3807, 2005.3999, 2005.4026,
                      2005.4218, 2005.4246, 2005.4464, 2005.4657, 2005.4684, 2005.4875, 2005.4904, 2005.5095, 2005.5314,
                      2005.5342, 2005.5533, 2005.5752, 2005.578, 2005.619, 2005.6218, 2005.641, 2005.6628, 2005.6656,
                      2005.6848, 2005.6875, 2005.7095, 2005.7506, 2005.7971, 2005.8191, 2005.8411, 2005.8602, 2005.863,
                      2005.8849, 2005.926, 2005.9698, 2006.0795, 2006.1041, 2006.1233, 2006.1453, 2006.148, 2006.1671,
                      2006.2328, 2006.2793, 2006.2985, 2006.3231, 2006.3424, 2006.3451, 2006.3643, 2006.3889, 2006.4081,
                      2006.4109, 2006.43, 2006.4327, 2006.4519, 2006.4547, 2006.4739, 2006.4957, 2006.4985, 2006.5397,
                      2006.5424, 2006.5835, 2006.5862, 2006.6053, 2006.6273, 2006.63, 2006.6492, 2006.6711, 2006.6738,
                      2006.693, 2006.715, 2006.7177, 2006.7588, 2006.7615, 2006.7834, 2006.8054, 2006.8246, 2006.8466,
                      2006.8494, 2006.8685, 2006.8712, 2006.8904, 2006.8932, 2006.9124, 2006.9562, 2006.9589, 2006.978])
        Y = np.array([[4884.0, 4099.0, 3636.0, 2581.0, 1833.0, 2593.0, 1683.0, 2103.0, nan, 1738.0, nan, 2177.0, 1951.0,
                       1756.0, nan, 2044.0, 1891.0, nan, 5924.0, 7583.0, 5714.0, nan, 4949.0, 3852.0, 2883.0, 1507.0,
                       1966.0, 1452.0, 2093.0, 1356.0, 1667.0, 1129.0, 1360.0, 1566.0, 1441.0, 2274.0, 1058.0, nan,
                       3290.0, nan, 6231.0, 6043.0, 5635.0, 3199.0, 1972.0, nan, 1640.0, 1541.0, nan, 1426.0, 1440.0,
                       1533.0, 860.0, 1132.0, 784.0, 777.0, 1192.0, 1052.0, 1305.0, 430.0, 246.0, 475.0, 855.0, 1530.0,
                       3688.0, nan, 6049.0, nan, 6503.0, 5754.0, 5900.0, 6182.0, 5941.0, 4935.0, 5272.0, 4728.0, nan,
                       3899.0, 3698.0, 4105.0, 2564.0, 1760.0, 1928.0, 1698.0, 1826.0, 1369.0, 1456.0, 869.0, 1649.0,
                       1206.0, 1616.0, 1023.0, 1384.0, 958.0, 1273.0, 1112.0, 1297.0, 2191.0, nan, 973.0, nan, 799.0,
                       nan, 3707.0, nan, 5638.0, 5848.0, 6172.0, 5495.0, 5746.0, 5435.0, nan, 5854.0, 5395.0, nan,
                       5571.0, 5071.0, nan, 3727.0, 3036.0, 2677.0, nan, 2224.0, 2319.0, nan, 1829.0, 1594.0, 1752.0,
                       1407.0, 1147.0, 1258.0, 1402.0, 1592.0, 1126.0, 1445.0, 1919.0, 1588.0, 915.0, 1109.0, 1019.0,
                       nan, nan, 5220.0, 6031.0, 5851.0, 6175.0, 5688.0, nan, 7214.0, 6217.0, 6060.0, 4842.0, 5492.0,
                       nan, 3969.0, 3445.0, 2194.0, 1968.0, 2621.0, 992.0, 1584.0, nan, 796.0, 655.0, 1300.0, 386.0,
                       735.0, 324.0, 674.0, 829.0, 3.0, 1068.0, 418.0, 1119.0, 435.0, nan, 70.0, 853.0, 410.0, 1985.0,
                       2459.0, 748.0, 2843.0, nan, nan, 2075.0, nan, 3680.0, nan, 4187.0, 4301.0, nan, 2666.0, 1536.0,
                       223.0, 872.0, 277.0, 515.0, 1407.0, 188.0, 0.0, 195.0, 0.0, 230.0, 0.0, 121.0, 0.0, 24.0, nan,
                       63.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 431.0, 0.0, nan, 0.0, nan, 3654.0, 4215.0, 4688.0, 5573.0,
                       5767.0, 6045.0, 5570.0, 5689.0, nan, 3935.0, 2779.0, 2706.0, 2504.0, 897.0, 1109.0, 641.0, 667.0,
                       232.0, 723.0, 243.0, 650.0, 0.0, 854.0, 88.0, 886.0, 74.0, 405.0, 137.0, 169.0, 0.0, 759.0, 16.0,
                       598.0, 429.0, 640.0, 446.0, nan, 2923.0, 3671.0, nan, 5380.0, 4523.0, 4790.0, 5140.0, 4533.0,
                       nan, 3263.0, nan, 3840.0, 1770.0, nan, 689.0, 763.0, 551.0, 810.0, 495.0, 486.0, 218.0, 492.0,
                       629.0, 0.0, 663.0, 0.0, 676.0, 66.0, 390.0, nan, 297.0, 280.0, 0.0, 885.0, 3083.0, 4001.0,
                       2743.0, 3289.0, nan, 4114.0, 5157.0, 4862.0, 4646.0, 3952.0, 2135.0, 2359.0, 1617.0, 727.0,
                       428.0, 669.0, 0.0, 387.0, 205.0, 452.0, 118.0, 320.0, 0.0, 172.0, 497.0, 602.0, 1228.0, nan, 0.0,
                       0.0, 0.0, 516.0, nan, 411.0, 56.0, nan, 4484.0, nan, nan, 5805.0, 5027.0, nan, 4399.0, 4096.0,
                       2942.0, nan, 1636.0, 1711.0, 1313.0, 1435.0, 501.0, 1073.0, 950.0, 1223.0, 579.0, 676.0, 968.0,
                       272.0, 281.0, 334.0, 533.0, 246.0, 735.0, 206.0, 850.0, nan, 1875.0, 2543.0, 4419.0, 3488.0,
                       5441.0, nan, 6608.0, 7158.0, nan, nan, nan, 6373.0, nan, nan, 6255.0, 4050.0, 3028.0, 2371.0,
                       nan, 2072.0, 2282.0, 1714.0, 1869.0, nan, 1808.0, 1438.0, 961.0, 1304.0, 1583.0, 1186.0, 1204.0,
                       1249.0, 1556.0, nan, 1710.0, 820.0, nan, 2645.0, nan, 3743.0, nan, 6333.0, 6960.0, 6777.0,
                       6564.0, 6960.0, 6608.0, 5963.0, 5337.0, 5280.0, 4259.0, nan, 3540.0, 3424.0, 2295.0, 2689.0,
                       2029.0, 2496.0, 1969.0, 2129.0, 2053.0, 2069.0, 1866.0, 1819.0, 2326.0, 2377.0, nan, 2314.0,
                       2167.0, nan, 2027.0, 2340.0, 2012.0, 3599.0, 4598.0, nan, 6057.0, 6827.0, 7188.0, 6444.0, 6884.0,
                       nan, 5881.0, nan, 5360.0, 5001.0, 4608.0, 3840.0, 3846.0, 3226.0, 2900.0, 1818.0, 2034.0, 1983.0,
                       1855.0, nan, 1815.0, 1692.0, 2148.0, 1770.0, 1893.0, 1716.0, 1895.0, 2051.0, nan, 2512.0, 1535.0,
                       2270.0, 2498.0, nan, nan, 6467.0, 6973.0, 6675.0, 7160.0, nan, 7274.0, 6379.0, nan, 5734.0,
                       5690.0, 4134.0, 3498.0, 2673.0, 2255.0, 1742.0, 1359.0, 979.0, 1426.0, 797.0, 1244.0, 532.0,
                       1066.0, nan, 1341.0, 1385.0, 1504.0, 1225.0, 1150.0, 1031.0, 1114.0, nan, 1506.0, 2307.0, 1226.0,
                       nan, 1057.0, 2797.0, 5194.0, 6339.0, 6152.0, 6112.0, 6836.0, 6762.0, nan, 8011.0, 7494.0, 6841.0,
                       nan, nan, 5810.0, nan, 3217.0, 2251.0, 2986.0, 1437.0, 1986.0, 1283.0, 1613.0, 1372.0, 1694.0,
                       1339.0, 1561.0, 1273.0, 1849.0, 1515.0, 1496.0, 1403.0, 1324.0, 1402.0, 1595.0, 1128.0, nan,
                       1400.0, 1753.0, 1317.0, 1062.0, 1339.0, 1700.0, 1158.0, 1439.0, 1505.0, 2259.0, 1847.0, 1273.0,
                       nan, 1478.0, nan, 1712.0, 2025.0, nan, 2713.0, 2608.0, nan, 3291.0, nan, 5567.0, 5379.0, nan,
                       5817.0, 5708.0, 5881.0, 5878.0, 6404.0, nan, nan, 4794.0, 5355.0, 4719.0, nan, nan, nan, nan,
                       1094.0, nan, 1024.0, 1463.0, 906.0, nan, 604.0, 538.0, 742.0, 561.0, 146.0, 206.0, 670.0, 0.0,
                       321.0, 281.0, 563.0, 740.0, 235.0, 666.0, 374.0, 803.0, 504.0, 764.0, 107.0, 438.0, 265.0,
                       1244.0, 539.0, 1748.0, 479.0, 731.0, 247.0, 519.0, 1006.0, 621.0, nan, 39.0, nan, 811.0, 795.0,
                       0.0, 748.0, 784.0, 950.0, nan, 720.0, 1570.0, nan, 2297.0, nan, nan, 5677.0, 5090.0, nan, 6742.0,
                       6100.0, 6154.0, 5701.0, nan, 6005.0, 4708.0, 5177.0, 4001.0, 3326.0, 2655.0, 2567.0, 2385.0, nan,
                       nan, nan, 1418.0, nan, 926.0, 648.0, 613.0, 778.0, 1019.0, 673.0, nan, 693.0, 1176.0, 625.0,
                       1000.0, 974.0, 339.0, 1218.0, 846.0, 1083.0, 371.0, 609.0, 495.0, 345.0, 729.0, 1216.0, nan,
                       661.0, 862.0, 1148.0, 330.0, 511.0, 1365.0, nan, 1431.0, 1307.0, 634.0, nan, 2717.0, 2063.0, nan,
                       6100.0, 5430.0, 5976.0, 6118.0, 5826.0, 6633.0, 6670.0, 6279.0, 6811.0, 5921.0, 5727.0, 5622.0,
                       nan, 5645.0, 4554.0, nan, 4875.0, 4846.0, nan, nan, 2269.0, 2017.0, 1346.0, 1164.0, 1054.0,
                       429.0, 809.0, 483.0, 855.0, 719.0, 691.0, 127.0, 488.0, 402.0, 0.0, 507.0, 512.0, 822.0, 290.0,
                       556.0, 1086.0, 595.0, 420.0, 290.0, 843.0, 315.0, nan, 1947.0, 2986.0, 6508.0, 7001.0, 7293.0,
                       nan, nan, 6789.0, nan, 6583.0, 6208.0, nan, nan, 4001.0, 3234.0, 2800.0, 1444.0, 732.0, 859.0,
                       839.0, 1121.0, 624.0, 1238.0, 693.0, 1208.0, 1136.0, 993.0, 1111.0, 1074.0, 918.0, 1447.0, 879.0,
                       1304.0, 1017.0, 3006.0, nan, 4444.0, 5679.0, 4929.0, 5472.0, 6014.0, 5468.0, nan, 4973.0, nan,
                       nan, 2038.0, 1629.0, nan, 1278.0, 837.0, 1689.0, 892.0, 559.0, 669.0, 968.0, 381.0, 632.0, 817.0,
                       556.0, 1239.0, 437.0, nan, 545.0, 713.0, nan, 176.0, nan, 1102.0, 514.0, 1710.0, nan, nan, 575.0,
                       3098.0, nan, nan, nan, 6548.0, nan, 6855.0, 6697.0, 7577.0, nan, 6987.0, nan, 5492.0, nan,
                       4764.0, 4150.0, nan, 3624.0, 2892.0, 2994.0, nan, 3248.0, 2298.0, nan, nan, 1709.0, nan, 1452.0,
                       1738.0, nan, nan, 1178.0, 1554.0, nan, nan, 1987.0, nan, 1510.0, 1841.0, 1200.0, 1770.0, 1691.0,
                       1304.0, 1668.0, nan, 1148.0, 1764.0, 666.0, 1661.0, 580.0, 1441.0, nan, 1431.0, 3113.0, 3696.0,
                       3831.0, 4688.0, nan, nan, nan, 5266.0, 5910.0, 3595.0, 3149.0, nan, nan, 2812.0, 2389.0, 2276.0,
                       nan, 1848.0, 1605.0, nan, 1785.0, 1433.0, 1721.0, 1622.0, 1651.0, 1660.0, 1248.0, 1616.0, 1230.0,
                       1947.0, 1426.0, 1162.0, 1503.0, nan, 1028.0, 1352.0, 1475.0, nan, 1525.0, 1048.0, 1436.0, 2672.0,
                       2392.0, 2540.0, 3336.0, 4720.0, 4426.0, nan, 5083.0, nan, 5475.0, 5802.0, nan],
                      [4976.0, 4062.0, 3527.0, 2411.0, 1802.0, 2646.0, 1760.0, 1917.0, nan, 1744.0, nan, 2065.0, 2068.0,
                       1944.0, nan, 1958.0, 2335.0, nan, 6204.0, 7428.0, 6247.0, nan, 4896.0, 3410.0, 2815.0, 1027.0,
                       1781.0, 1398.0, 2184.0, 1329.0, 1473.0, 1390.0, 1252.0, 1768.0, 1364.0, 2082.0, 1655.0, nan,
                       3418.0, nan, 6245.0, 6028.0, 5539.0, 3105.0, 1863.0, nan, 1494.0, 1670.0, nan, 1607.0, 1447.0,
                       1614.0, 647.0, 1391.0, 861.0, 1190.0, 1204.0, 1099.0, 1627.0, 323.0, 409.0, 390.0, 1189.0,
                       1988.0, 4109.0, nan, 6383.0, nan, 6470.0, 5714.0, 5922.0, 6065.0, 5562.0, 4738.0, 5614.0, 4428.0,
                       nan, 4067.0, 3745.0, 4212.0, 2603.0, 1966.0, 2052.0, 1637.0, 1798.0, 951.0, 1358.0, 773.0,
                       1872.0, 1187.0, 1429.0, 1212.0, 1528.0, 1011.0, 1523.0, 1179.0, 1434.0, 2664.0, nan, 1291.0, nan,
                       1015.0, nan, 3658.0, nan, 6004.0, 6056.0, 6503.0, 5926.0, 5965.0, 5785.0, nan, 5663.0, 5216.0,
                       nan, 5514.0, 4875.0, nan, 3899.0, 2945.0, 2549.0, nan, 1960.0, 2420.0, 2351.0, 2048.0, 1536.0,
                       2021.0, 1310.0, 1582.0, 1306.0, 1712.0, 1884.0, 1234.0, 1502.0, 1968.0, 1755.0, 1496.0, 1424.0,
                       1247.0, nan, nan, 5627.0, 6468.0, 6414.0, 6632.0, 6104.0, nan, 6739.0, 6323.0, 5498.0, 4892.0,
                       5387.0, nan, 4130.0, 3345.0, 2396.0, nan, nan, 998.0, 1322.0, nan, 1238.0, 751.0, 1158.0, 385.0,
                       661.0, 625.0, 737.0, 1017.0, 359.0, 877.0, 640.0, 1469.0, 428.0, nan, 187.0, 985.0, 552.0,
                       2059.0, 1561.0, 647.0, 3380.0, nan, nan, 2146.0, nan, 4322.0, nan, 4464.0, 4010.0, nan, 2968.0,
                       1673.0, 283.0, 982.0, 164.0, 784.0, 1605.0, 292.0, 0.0, 163.0, 0.0, 117.0, 0.0, 284.0, 0.0,
                       158.0, nan, 45.0, 0.0, 0.0, 0.0, 0.0, 300.0, 96.0, 0.0, 360.0, nan, 141.0, nan, 4371.0, 5096.0,
                       4994.0, 5859.0, 5786.0, 5944.0, 5570.0, 5517.0, nan, 4246.0, 2867.0, 2991.0, 2834.0, 1126.0,
                       1339.0, 865.0, 559.0, 133.0, 620.0, 256.0, 706.0, 13.0, 970.0, 10.0, 1052.0, 277.0, 314.0, 190.0,
                       268.0, 30.0, 1036.0, 236.0, 874.0, 198.0, 266.0, 700.0, nan, 3176.0, 3967.0, nan, 5410.0, 4992.0,
                       4842.0, 5301.0, 4525.0, nan, 3129.0, nan, 3631.0, 1651.0, nan, 487.0, 980.0, 409.0, 702.0, 493.0,
                       442.0, 436.0, 527.0, 563.0, 38.0, 410.0, 0.0, 408.0, 0.0, 747.0, 1058.0, 529.0, 614.0, 0.0,
                       852.0, 3386.0, 4919.0, 2900.0, 3039.0, nan, 4103.0, 5322.0, 4537.0, 4758.0, 3724.0, 2008.0,
                       2305.0, 1600.0, 727.0, 469.0, 573.0, 51.0, 272.0, 159.0, 191.0, 360.0, 806.0, 100.0, 542.0,
                       577.0, 716.0, 1193.0, nan, 0.0, 449.0, 0.0, 1008.0, nan, 1034.0, 474.0, nan, 4942.0, nan, nan,
                       5673.0, 5449.0, nan, 4361.0, 3940.0, 2941.0, nan, 1657.0, 2003.0, 1278.0, 1127.0, 653.0, 1131.0,
                       1186.0, 1267.0, 649.0, 776.0, 737.0, 202.0, 545.0, 102.0, 776.0, 564.0, 1353.0, 267.0, 722.0,
                       nan, 2232.0, 2863.0, 4931.0, 3928.0, 5653.0, nan, 6730.0, 7273.0, nan, nan, nan, 6449.0, nan,
                       nan, nan, 4480.0, 3052.0, 2913.0, nan, 2352.0, 1996.0, 2188.0, 1892.0, nan, 1868.0, 1609.0,
                       1123.0, 1178.0, 1507.0, 1458.0, 1582.0, 1363.0, 1457.0, nan, 1484.0, 1036.0, nan, 3757.0, nan,
                       4170.0, nan, 6252.0, 6575.0, 6495.0, 6528.0, 7067.0, 6640.0, 5874.0, 5185.0, 5225.0, 4270.0, nan,
                       3417.0, 3162.0, 2206.0, 2538.0, 2057.0, 2489.0, 2053.0, 2284.0, 1934.0, 2152.0, 1852.0, 1799.0,
                       2316.0, 2371.0, nan, 2538.0, 2141.0, nan, 2299.0, 2734.0, 2144.0, 3854.0, 4400.0, nan, 5947.0,
                       6733.0, 7547.0, 6645.0, 6938.0, nan, 5731.0, nan, 5520.0, 4557.0, 4768.0, 3693.0, 4031.0, 3322.0,
                       2749.0, 1733.0, 2417.0, 1758.0, 1939.0, nan, 1703.0, 1723.0, 2218.0, 1851.0, 1919.0, 1889.0,
                       2113.0, 1694.0, nan, 2355.0, 1416.0, 2158.0, 2960.0, nan, nan, 6706.0, 7325.0, 7109.0, 7743.0,
                       nan, 7422.0, 6709.0, nan, 5837.0, 5624.0, 3991.0, 3655.0, 2687.0, 2386.0, 1828.0, 1381.0, 1200.0,
                       1504.0, 712.0, 1181.0, 472.0, 1053.0, nan, 1453.0, 1218.0, 1820.0, 1259.0, 1094.0, 813.0, 1440.0,
                       nan, 1744.0, 2507.0, 1578.0, nan, 3261.0, 2751.0, 5704.0, 6444.0, 6568.0, 6553.0, 7162.0, 6906.0,
                       nan, 8236.0, 7351.0, 6698.0, nan, nan, 5108.0, nan, 3588.0, 2422.0, 2683.0, 1173.0, 1917.0,
                       1183.0, 1734.0, 1657.0, 1672.0, 1537.0, 1595.0, 1359.0, 1691.0, 1423.0, 1537.0, 1228.0, 1538.0,
                       1492.0, 1871.0, 1432.0, nan, 1660.0, 1488.0, 1564.0, 1188.0, 1329.0, 1714.0, 1320.0, 1443.0,
                       1545.0, 2525.0, 1621.0, 1307.0, nan, 1666.0, 1764.0, 2043.0, 1931.0, nan, 2320.0, 2558.0, 3824.0,
                       3468.0, nan, 5923.0, 4929.0, nan, 5552.0, 5878.0, 5870.0, 5963.0, 6652.0, nan, nan, 4916.0,
                       5205.0, 5009.0, nan, nan, nan, nan, 1292.0, nan, 1219.0, 1706.0, 913.0, nan, 659.0, 431.0, 730.0,
                       620.0, 346.0, 641.0, 805.0, 0.0, 638.0, 632.0, 251.0, 518.0, 317.0, 583.0, 365.0, 617.0, 740.0,
                       885.0, 199.0, 711.0, 309.0, 1092.0, 376.0, 1747.0, 508.0, 619.0, 648.0, 562.0, 1265.0, 713.0,
                       nan, 67.0, nan, 384.0, 926.0, 406.0, 855.0, 597.0, 1238.0, nan, 779.0, 1582.0, nan, 2440.0,
                       4557.0, nan, 5595.0, 4707.0, nan, 6803.0, 6666.0, 5798.0, 5757.0, nan, 5881.0, 4866.0, 4807.0,
                       4052.0, 3434.0, 3155.0, 2549.0, 2193.0, nan, nan, nan, 1519.0, nan, 1247.0, 814.0, 943.0, 940.0,
                       1046.0, 941.0, nan, 623.0, 1014.0, 711.0, 961.0, 1022.0, 116.0, 1390.0, 815.0, 1195.0, 265.0,
                       851.0, 43.0, 698.0, 899.0, 1429.0, nan, 770.0, 689.0, 1381.0, 696.0, 560.0, 1712.0, nan, 1319.0,
                       1625.0, 765.0, nan, 2427.0, 2213.0, nan, 6231.0, 5687.0, 6646.0, 6586.0, 6057.0, 6785.0, 6333.0,
                       6117.0, 6356.0, 6184.0, 5898.0, 5778.0, nan, nan, 4696.0, nan, 4724.0, 4457.0, nan, nan, 2203.0,
                       2205.0, 1175.0, 1235.0, 1048.0, 442.0, 964.0, 566.0, 693.0, 592.0, 826.0, 239.0, 569.0, 283.0,
                       144.0, 680.0, 950.0, 935.0, 265.0, 799.0, 888.0, 746.0, 478.0, 462.0, 890.0, 204.0, nan, 1824.0,
                       3291.0, 6129.0, 6840.0, 7309.0, nan, nan, 6210.0, nan, 6309.0, 6032.0, nan, nan, 3864.0, 2883.0,
                       2618.0, 1272.0, 496.0, 985.0, 671.0, 1078.0, 771.0, 1113.0, 567.0, 876.0, 836.0, 643.0, 751.0,
                       937.0, 378.0, 1267.0, 749.0, 1374.0, 1257.0, 2887.0, nan, 4836.0, 5788.0, 4602.0, 5198.0, 6001.0,
                       5459.0, 4490.0, 5071.0, nan, nan, 1717.0, 1668.0, nan, 1115.0, 762.0, 1712.0, 941.0, 542.0,
                       693.0, 926.0, 500.0, 734.0, 794.0, 789.0, nan, 491.0, nan, 801.0, 768.0, nan, 0.0, nan, 1268.0,
                       647.0, 1832.0, nan, nan, 1010.0, 2854.0, nan, nan, nan, 6588.0, nan, 7251.0, 6923.0, 7186.0, nan,
                       7150.0, nan, 5497.0, nan, 4789.0, 4000.0, nan, 3555.0, 2976.0, 3251.0, nan, 3165.0, 2251.0, nan,
                       nan, 1529.0, nan, 1379.0, 1658.0, nan, nan, 1283.0, 1545.0, nan, nan, 1902.0, nan, 1488.0,
                       1805.0, 1093.0, 1874.0, 1885.0, 1507.0, 1572.0, nan, 1175.0, 1889.0, 379.0, 1429.0, 515.0,
                       1026.0, nan, 1358.0, 2986.0, 4160.0, 4446.0, 4342.0, 4995.0, nan, nan, 4999.0, 5860.0, 3474.0,
                       3144.0, 2672.0, nan, 2542.0, 2660.0, 1868.0, nan, 1752.0, 1398.0, nan, 1762.0, 1307.0, 1774.0,
                       1594.0, 1316.0, 1515.0, 1179.0, 1575.0, 1073.0, 2011.0, 1553.0, 1030.0, 1410.0, nan, 909.0,
                       1358.0, 1702.0, nan, 1394.0, 1271.0, 1051.0, 2731.0, 2988.0, 3332.0, 3352.0, 4946.0, 4436.0, nan,
                       5254.0, nan, 5708.0, 5918.0, nan]])

        rbfCutOffValue = 0.01  # minimal value concidered as weights in convolution (value between 0 and 1)
        rbfFwhms = [day / 365 for day in [30, 60, 120]]  # RBF kernel sizes [decimal years]
        rbfUserWeights = [9, 3, 1]

        # rbfFwhms = [day / 365 for day in [10, 30, 100]]  # RBF kernel sizes [decimal years]
        # rbfUserWeights = [1, 1, 1]

        X2 = np.linspace(1984.0, 1988.0, 3000)
        Y2 = rbfEnsemblePrediction(X, Y, X2, rbfFwhms, rbfUserWeights, rbfCutOffValue)

        # check result visually
        import matplotlib.pyplot as plt
        n = 100  # only show the first 3 years
        plt.plot(X[:n], Y[0, :n], marker="o", linestyle='None')
        plt.plot(X2, Y2[0], marker="None", color='red')
        plt.show()
