from unittest import TestCase

from _classic.hubdsm.algorithm.importdesisl2a import isDesisL2AProduct, importDesisL2A


class TestImportDesisL2A(TestCase):

    def test_isDesisL2AProduct(self):
        filenameMetadataXml = r'C:\Users\janzandr\Downloads\desis\dims_op_oc_dfd2_655324643_1\DESIS.HSI.L2A\p4\DESIS-HSI-L2A-DT1203190212_025-20191203T021128-V0210\DESIS-HSI-L2A-DT1203190212_025-20191203T021128-V0210-METADATA.xml'
        self.assertTrue(isDesisL2AProduct(filenameMetadataXml=filenameMetadataXml))
        self.assertFalse(isDesisL2AProduct(filenameMetadataXml=''))

    def test(self):
        dsSpectral = importDesisL2A(
            filenameMetadataXml=r'C:\Users\janzandr\Downloads\desis\dims_op_oc_dfd2_655324643_1\DESIS.HSI.L2A\p4\DESIS-HSI-L2A-DT1203190212_025-20191203T021128-V0210\DESIS-HSI-L2A-DT1203190212_025-20191203T021128-V0210-METADATA.xml'
        )

        self.assertEqual(
            dsSpectral.GetMetadataItem('wavelength', 'ENVI'),
            '{402.0,404.2,406.8,409.3,411.8,414.3,416.9,419.4,422.0,424.6,427.3,429.8,432.4,434.9,437.5,439.9,442.5,445.1,447.8,450.3,452.9,455.6,458.2,460.7,463.3,465.8,468.3,470.7,473.4,475.9,478.5,481.3,483.8,486.4,489.0,491.6,494.0,496.5,499.2,501.8,504.3,506.9,509.5,512.2,514.7,517.2,519.6,522.2,524.7,527.3,529.7,532.3,534.9,537.5,540.2,542.7,545.2,547.7,550.3,552.9,555.5,558.1,560.6,563.2,565.8,568.4,571.0,573.5,576.1,578.6,581.1,583.7,586.3,588.8,591.3,594.0,596.6,599.1,601.6,604.2,606.8,609.2,611.8,614.3,616.9,619.5,622.1,624.7,627.2,629.7,632.2,634.7,637.2,639.8,642.3,644.9,647.5,650.0,652.6,655.2,657.7,660.2,662.8,665.3,667.9,670.5,673.1,675.8,678.4,680.9,683.5,685.9,688.4,690.9,693.5,696.2,698.8,701.5,703.9,706.7,709.4,711.8,714.0,716.4,718.9,721.6,724.2,726.9,729.4,732.1,734.4,736.9,739.5,742.0,744.5,747.2,749.7,752.3,755.2,757.7,760.3,763.0,765.0,767.5,770.3,772.7,775.4,778.0,780.5,783.0,785.6,788.2,790.6,793.1,795.9,798.4,801.2,804.0,806.7,809.1,811.7,814.3,816.9,819.8,822.8,824.2,827.2,829.2,832.2,834.9,836.7,840.1,842.0,844.7,847.7,850.0,852.4,855.4,857.9,860.3,862.9,865.4,868.0,870.6,873.2,875.8,878.8,881.5,883.1,885.3,888.1,890.9,894.1,896.0,898.3,901.2,903.7,906.0,908.7,911.6,914.8,916.6,918.4,921.0,923.9,927.1,929.6,931.9,934.5,937.3,939.4,942.0,944.7,947.3,949.6,951.9,954.2,957.3,959.6,962.3,965.5,968.1,970.4,972.9,976.0,978.7,980.0,981.9,984.8,988.9,991.6,993.1,995.6,997.9,999.5}'
        )

        return
        profile = list(dsSpectral.ReadAsArray(188, 20, 1, 1).flatten())
        self.assertListEqual(
            profile,
            [379, 426, 291, 341, 327, 321, 352, 354, 360, 372, 359, 385, 405, 390, 363, 424, 397, 411, 465, 497, 448,
             531, 542, 592, 591, 600, 626, 658, 627, 653, 651, 662, 682, 662, 669, 705, 714, 724, 703, 708, 708, 710,
             710, 707, 702, 695, 725, 773, 876, 1034, 1215, 1404, 1622, 1753, 1966, 2258, 2529, 2766, 2910, 3012, 3208,
             3239, 3272, 3253, 3210, 3232, 3156, 3195, 3240, 3363, 3485, 3530, 3455, 3493, 3503, 3514, 3380, 3303, 3297,
             3145, 3178, 3223, 3192, 3070, 2615, 2394, 2429, 2457, 2554, 2666, 2819, 3018, 3112, 3226, 3236, 3433, 3462,
             3614, 3658, 3732, 3836, 3899, 3979, 4031, 4027, 3925, 3763, 3374, 2673, 2297, 2474, 2763, 3150, 3273, 3281,
             3301, 3341, 3454, 3571, 3633, 3663, 3679, 3614, 3375, 3163, 2855, 2345, 1784, 2142, 14998, 11865, 1180,
             1462, 1639, 1751, 1851, 1934, 2018, 2077, 2146, 2207, 2238, 2269, 2317, 2326, 2388, 2404, 2371, 2463, 2440,
             2327, 2267, 2256, 2229, 2179, 2099, 1963, 1774, 306, 425, 633, 848, 855, 918, 1001, 1006, 1135, 1225, 1250,
             1274, 1291, 1292, 1311, 1374, 1396, 1391, 1434, 1436, 1472, 1483, 1495, 1510, 1507, 1594, 1559, 1559, 1577,
             1586, 1553, 1541, 1599, 1603, 1546, 1519, 1508, 1481, 1442, 1425, 1398, 1388, 1349, 1348, 1337, 1271, 1280,
             1258, 1250, 1215, 1174, 1106, 1092, 1075, 1097, 1000, 899, 889, 976, 864]

        )
