# -*- coding: utf-8 -*-

"""
/***************************************************************************
 emiTools
                                 A QGIS plugin
 This plugin compiles tools used by EMI-PB

                              -------------------
        begin                : 2024-10-10
        copyright            : (C) 2024 by Alexandre Parente Lima
        email                : alexandre.parente@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Alexandre Parente Lima'
__date__ = '2024-10-10'
__copyright__ = '(C) 2024 by Alexandre Parente Lima'

__revision__ = '$Format:%H$'

import os
import sys
from qgis.PyQt.QtCore import QTranslator, QCoreApplication, QSettings, QLocale
from qgis.core import (QgsProcessingAlgorithm,
                       QgsApplication)

from .emi_tools_expressions import *
from .emi_tools_provider import emiToolsProvider

listFunctions = (validate_cpf, validate_cnpj, format_cpf, format_cnpj, format_cpf_cnpj, mask_cpf, mask_name,
                 format_proper_name, format_title_abnt, get_image_date, get_satellite_name, get_image_source)

cmd_folder = os.path.dirname(os.path.abspath(__file__))

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class emiToolsPlugin(object):

    def __init__(self):
        self.provider = None

        # Initialize the plugin path directory
        self.plugin_dir = os.path.dirname(__file__)

        # Gets the locale configured in the system.
        settings = QSettings()
        locale = settings.value("locale/userLocale", QLocale.system().name())

        # Initialize locale
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'emiTools_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = emiToolsProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        for expr in listFunctions:
            if not QgsExpression.isFunctionName(expr.name()):
                QgsExpression.registerFunction(expr)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        for expr in listFunctions:
            if QgsExpression.isFunctionName(expr.name()):
                QgsExpression.unregisterFunction(expr.name())
